/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.misc.model;

import ec.util.MersenneTwister;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;

public class RandStateHash {
    private static int nextHash(int prevHash, int newValue) {
        return Math.abs(31 * prevHash + newValue) % 32452867;
    }

    private static int nextHash(int prevHash, long newValue) {
        int newHash = RandStateHash.nextHash(prevHash, (int)newValue);
        return RandStateHash.nextHash(newHash, (int)(newValue >>> 32));
    }

    public static int randHash(Random rOrig) {
        Random r = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream o = new ObjectOutputStream(bout);
            o.writeObject(rOrig);
            o.close();
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bin);
            r = (Random)in.readObject();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        int hash = r.nextBoolean() ? 0 : 1;
        hash = RandStateHash.nextHash(hash, r.nextInt());
        hash = RandStateHash.nextHash(hash, Double.doubleToLongBits(r.nextDouble()));
        hash = RandStateHash.nextHash(hash, Double.doubleToLongBits(r.nextGaussian()));
        hash = RandStateHash.nextHash(hash, r.nextLong());
        hash = RandStateHash.nextHash(hash, r.nextInt(Integer.MAX_VALUE));
        hash = RandStateHash.nextHash(hash, Float.floatToIntBits(r.nextFloat()));
        return hash;
    }

    public static void main(String[] args) {
        int j;
        MersenneTwister r2;
        int length;
        int i;
        MersenneTwister r = new MersenneTwister(1L);
        for (i = 0; i < 100; ++i) {
            length = ((Random)r).nextInt(10000) + 1000;
            r2 = new MersenneTwister(r.nextInt());
            block15: for (j = 0; j < length; ++j) {
                switch (((Random)r).nextInt(5)) {
                    case 0: {
                        ((Random)r2).nextBoolean();
                        continue block15;
                    }
                    case 1: {
                        ((Random)r2).nextDouble();
                        continue block15;
                    }
                    case 2: {
                        r2.nextLong();
                        continue block15;
                    }
                    case 3: {
                        ((Random)r2).nextGaussian();
                        continue block15;
                    }
                    case 4: {
                        ((Random)r2).nextInt(32);
                    }
                }
            }
            System.out.println("Random Hash (" + i + ")" + RandStateHash.randHash(r2) + " and again " + RandStateHash.randHash(r2) + " and again " + RandStateHash.randHash(r2));
        }
        r = new MersenneTwister(1L);
        for (i = 0; i < 100; ++i) {
            length = ((Random)r).nextInt(10000) + 1000;
            r2 = new MersenneTwister(r.nextInt());
            block17: for (j = 0; j < length; ++j) {
                switch (((Random)r).nextInt(5)) {
                    case 0: {
                        ((Random)r2).nextBoolean();
                        continue block17;
                    }
                    case 1: {
                        ((Random)r2).nextDouble();
                        continue block17;
                    }
                    case 2: {
                        r2.nextLong();
                        continue block17;
                    }
                    case 3: {
                        ((Random)r2).nextGaussian();
                        continue block17;
                    }
                    case 4: {
                        ((Random)r2).nextInt(32);
                    }
                }
            }
            System.out.println("Random Hash (" + i + ")" + RandStateHash.randHash(r) + " and again " + RandStateHash.randHash(r2) + " and again " + RandStateHash.randHash(r2));
        }
    }
}

