/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.probleminstance;

import ca.ubc.cs.beta.aclib.exceptions.FeatureNotFoundException;
import ca.ubc.cs.beta.aclib.misc.options.CommandLineOnly;
import ca.ubc.cs.beta.aclib.misc.options.OptionLevel;
import ca.ubc.cs.beta.aclib.misc.options.UsageTextField;
import ca.ubc.cs.beta.aclib.options.AbstractOptions;
import ca.ubc.cs.beta.aclib.probleminstance.InstanceListWithSeeds;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceHelper;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsageTextField(hiddenSection=true)
public class ProblemInstanceOptions
extends AbstractOptions {
    @CommandLineOnly
    @Parameter(names={"--instance-file", "--instanceFile", "-i", "--instance_file", "--instance_seed_file"}, description="file containing a list of instances to use during the automatic configuration phase (see Instance File Format section of the manual)", required=false)
    public String instanceFile;
    @CommandLineOnly
    @UsageTextField(defaultValues="")
    @Parameter(names={"--feature-file", "--instanceFeatureFile", "--feature_file"}, description="file that contains the all the instances features")
    public String instanceFeatureFile;
    @CommandLineOnly
    @Parameter(names={"--test-instance-file", "--testInstanceFile", "--test_instance_file", "--test_instance_seed_file"}, description="file containing a list of instances to use during the validation phase (see Instance File Format section of the manual)", required=false)
    public String testInstanceFile;
    @CommandLineOnly
    @UsageTextField(level=OptionLevel.ADVANCED)
    @Parameter(names={"--check-instances-exist", "--checkInstanceFilesExist"}, description="check if instances files exist on disk")
    public boolean checkInstanceFilesExist = false;

    public InstanceListWithSeeds getTrainingProblemInstances(String experimentDirectory, long seed, boolean deterministic, boolean required, boolean featuresRequired) throws IOException {
        InstanceListWithSeeds ilws;
        if (this.instanceFile == null) {
            if (required) {
                throw new ParameterException("The instance file option --instanceFile must be set");
            }
            return null;
        }
        Logger log = LoggerFactory.getLogger(this.getClass());
        try {
            ilws = ProblemInstanceHelper.getInstances(this.instanceFile, experimentDirectory, this.instanceFeatureFile, this.checkInstanceFilesExist, seed, deterministic);
        }
        catch (FeatureNotFoundException e) {
            ProblemInstanceHelper.clearCache();
            if (featuresRequired) {
                throw new ParameterException("Training instances require features and there was a problem loading features for all instances: " + e.getMessage());
            }
            ilws = ProblemInstanceHelper.getInstances(this.instanceFile, experimentDirectory, null, this.checkInstanceFilesExist, seed, deterministic);
        }
        log.debug("Training Instance Seed Generator reports {} seeds ", (Object)ilws.getSeedGen().getInitialInstanceSeedCount());
        if (!ilws.getSeedGen().allInstancesHaveSameNumberOfSeeds()) {
            log.error("Training Instance Seed Generator reports that some instances have a different number of seeds than others");
            throw new ParameterException("All Training instances must have the same number of seeds in this version of SMAC");
        }
        log.debug("Training Instance Seed Generator reports that all instances have the same number of available seeds");
        return ilws;
    }

    public InstanceListWithSeeds getTestingProblemInstances(String experimentDirectory, long seed, boolean deterministic, boolean required, boolean featuresRequired) throws IOException {
        InstanceListWithSeeds ilws;
        if (this.testInstanceFile == null) {
            if (required) {
                throw new ParameterException("The instance file option --testInstanceFile must be set");
            }
            return null;
        }
        Logger log = LoggerFactory.getLogger(this.getClass());
        try {
            ilws = ProblemInstanceHelper.getInstances(this.testInstanceFile, experimentDirectory, this.instanceFeatureFile, this.checkInstanceFilesExist, seed, deterministic);
        }
        catch (FeatureNotFoundException e) {
            ProblemInstanceHelper.clearCache();
            if (featuresRequired) {
                throw new ParameterException("Testing instances require features and there was a problem loading features for all instances: " + e.getMessage());
            }
            ilws = ProblemInstanceHelper.getInstances(this.testInstanceFile, experimentDirectory, null, this.checkInstanceFilesExist, seed, deterministic);
        }
        log.debug("Test Instance Seed Generator reports {} seeds ", (Object)ilws.getSeedGen().getInitialInstanceSeedCount());
        if (!ilws.getSeedGen().allInstancesHaveSameNumberOfSeeds()) {
            log.debug("Test Instance Seed Generator reports that some instances have a different number of seeds than others");
            throw new ParameterException("All Testing instances must have the same number of seeds in this version of SMAC");
        }
        log.debug("Test Instance Seed Generator reports that all instances have the same number of available seeds");
        return ilws;
    }

    public TrainTestInstances getTrainingAndTestProblemInstances(String experimentDirectory, long trainingSeed, long testingSeed, boolean deterministic, boolean trainingRequired, boolean testRequired, boolean trainingFeaturesRequired, boolean testingFeaturesRequired) throws IOException {
        InstanceListWithSeeds training = this.getTrainingProblemInstances(experimentDirectory, trainingSeed, deterministic, trainingRequired, trainingFeaturesRequired);
        InstanceListWithSeeds testing = this.getTestingProblemInstances(experimentDirectory, testingSeed, deterministic, testRequired, testingFeaturesRequired);
        return new TrainTestInstances(training, testing);
    }

    public TrainTestInstances getTrainingAndTestProblemInstances(List<String> directories, long trainingSeed, long testingSeed, boolean deterministic, boolean trainingRequired, boolean testRequired, boolean trainingFeaturesRequired, boolean testingFeaturesRequired) throws IOException {
        directories.add(new File(".").getAbsolutePath());
        LinkedHashMap<String, String> exceptionMessages = new LinkedHashMap<String, String>();
        Logger log = LoggerFactory.getLogger(this.getClass());
        for (String dir : directories) {
            try {
                InstanceListWithSeeds training = this.getTrainingProblemInstances(dir, trainingSeed, deterministic, trainingRequired, trainingFeaturesRequired);
                InstanceListWithSeeds testing = this.getTestingProblemInstances(dir, testingSeed, deterministic, testRequired, testingFeaturesRequired);
                return new TrainTestInstances(training, testing);
            }
            catch (ParameterException e) {
                log.debug("Ignore this exception for now: ", (Throwable)e);
                exceptionMessages.put(dir, e.getMessage());
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry ent : exceptionMessages.entrySet()) {
            sb.append((String)ent.getKey() + "==>" + (String)ent.getValue()).append("\n");
        }
        throw new ParameterException("Couldn't retrieve instances after searching several locations, errors for each location as follows: \n" + sb.toString());
    }

    public static class TrainTestInstances {
        private final InstanceListWithSeeds trainingInstances;
        private final InstanceListWithSeeds testInstances;

        public TrainTestInstances(InstanceListWithSeeds training, InstanceListWithSeeds testing) {
            this.trainingInstances = training;
            this.testInstances = testing;
        }

        public InstanceListWithSeeds getTrainingInstances() {
            return this.trainingInstances;
        }

        public InstanceListWithSeeds getTestInstances() {
            return this.testInstances;
        }
    }
}

