/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.runhistory;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.ExistingAlgorithmRun;
import ca.ubc.cs.beta.aclib.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aclib.misc.MapList;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.runhistory.AbstractRunHistoryDecorator;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ReindexSeedRunHistoryDecorator
extends AbstractRunHistoryDecorator
implements RunHistory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Random rand;
    private final Map<ProblemInstanceSeedPair, ProblemInstanceSeedPair> pispTransform = new HashMap<ProblemInstanceSeedPair, ProblemInstanceSeedPair>();
    private final MapList<ProblemInstance, ProblemInstanceSeedPair> mpi = new MapList(new HashMap());
    AtomicInteger nextSeed = new AtomicInteger(0);
    AtomicInteger duplicateRunsDropped = new AtomicInteger(0);

    public ReindexSeedRunHistoryDecorator(RunHistory rh, Random rand) {
        super(rh);
        this.rand = rand;
    }

    @Override
    public void append(AlgorithmRun run) throws DuplicateRunException {
        ProblemInstanceSeedPair pisp = run.getRunConfig().getProblemInstanceSeedPair();
        if (run.getRunConfig().getParamConfiguration().getConfigurationSpace().getDefaultConfiguration().equals(run.getRunConfig().getParamConfiguration())) {
            this.log.debug("Transforming run of default configuration {}", (Object)run);
        }
        if (this.pispTransform.get(pisp) != null) {
            RunConfig newRc = new RunConfig(this.pispTransform.get(pisp), run.getRunConfig().getCutoffTime(), run.getRunConfig().getParamConfiguration(), run.getRunConfig().hasCutoffLessThanMax());
            ExistingAlgorithmRun er = new ExistingAlgorithmRun(run.getExecutionConfig(), newRc, run.getRunResult(), run.getRuntime(), run.getRunLength(), run.getQuality(), this.pispTransform.get(pisp).getSeed(), run.getAdditionalRunData(), run.getWallclockExecutionTime());
            try {
                this.rh.append(er);
                return;
            }
            catch (DuplicateRunException e) {
                this.log.debug("Duplicate run has been dropped, so far: {} ", (Object)this.duplicateRunsDropped.incrementAndGet());
            }
        } else {
            ArrayList<ProblemInstanceSeedPair> possiblePisps = new ArrayList<ProblemInstanceSeedPair>(this.mpi.getList(pisp.getInstance()));
            Collections.shuffle(possiblePisps, this.rand);
            for (ProblemInstanceSeedPair newPisp : possiblePisps) {
                RunConfig newRc = new RunConfig(newPisp, run.getRunConfig().getCutoffTime(), run.getRunConfig().getParamConfiguration(), run.getRunConfig().hasCutoffLessThanMax());
                ExistingAlgorithmRun er = new ExistingAlgorithmRun(run.getExecutionConfig(), newRc, run.getRunResult(), run.getRuntime(), run.getRunLength(), run.getQuality(), newPisp.getSeed(), run.getAdditionalRunData(), run.getWallclockExecutionTime());
                try {
                    this.rh.append(er);
                    this.pispTransform.put(pisp, newPisp);
                    return;
                }
                catch (DuplicateRunException e) {
                }
            }
            ProblemInstanceSeedPair newPisp = new ProblemInstanceSeedPair(pisp.getInstance(), this.nextSeed.incrementAndGet());
            RunConfig newRc = new RunConfig(newPisp, run.getRunConfig().getCutoffTime(), run.getRunConfig().getParamConfiguration(), run.getRunConfig().hasCutoffLessThanMax());
            ExistingAlgorithmRun er = new ExistingAlgorithmRun(run.getExecutionConfig(), newRc, run.getRunResult(), run.getRuntime(), run.getRunLength(), run.getQuality(), newPisp.getSeed(), run.getAdditionalRunData(), run.getWallclockExecutionTime());
            try {
                this.rh.append(er);
                this.pispTransform.put(pisp, newPisp);
                return;
            }
            catch (DuplicateRunException e) {
                this.log.debug("Duplicate run has been dropped, so far: {} ", (Object)this.duplicateRunsDropped.incrementAndGet());
            }
        }
    }
}

