/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.state.legacy;

import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.exceptions.StateSerializationException;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import ca.ubc.cs.beta.aclib.state.StateDeserializer;
import ca.ubc.cs.beta.aclib.state.StateFactory;
import ca.ubc.cs.beta.aclib.state.StateSerializer;
import ca.ubc.cs.beta.aclib.state.legacy.LegacyStateDeserializer;
import ca.ubc.cs.beta.aclib.state.legacy.LegacyStateSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyStateFactory
implements StateFactory {
    static final String OBJECT_MAP_KEY = "OBJECT_MAP_KEY";
    static final String ITERATION_KEY = "ITERATION_KEY";
    static final String INCUMBENT_TEXT_KEY = "INCUMBENT_TEXT_KEY";
    public static final String SCENARIO_FILE = "scenario.txt";
    public static final String PARAM_FILE = "param.pcs";
    public static final String FEATURE_FILE = "instance-features.csv";
    public static final String INSTANCE_FILE = "instances.txt";
    private final String saveStatePath;
    private final String restoreFromPath;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentSkipListMap<Integer, Set<String>> savedFilesPerIteration = new ConcurrentSkipListMap();
    static final String RUN_NUMBER_HEADING = "Run Number";

    public LegacyStateFactory(String saveStatePath, String restoreFromPath) {
        this.saveStatePath = saveStatePath;
        this.restoreFromPath = restoreFromPath;
        if (saveStatePath != null) {
            File f = new File(this.saveStatePath);
            if (!f.exists()) {
                if (!f.mkdirs()) {
                    this.log.error("Could not create directory to save states: {} " + f.getAbsolutePath());
                    throw new IllegalArgumentException("Could not create directory" + f.getAbsolutePath());
                }
                this.log.info("Directory created for states: {}", (Object)f.getAbsolutePath());
            } else if (f.isDirectory() && f.listFiles().length > 0) {
                File newFileName = new File(f.getParent() + File.separator + "/old-state-" + System.currentTimeMillis() + "/");
                f.renameTo(newFileName);
                this.log.warn("Found previous state output, renamed to: {}", (Object)newFileName.getAbsolutePath());
                f = new File(this.saveStatePath);
                f.mkdir();
            }
            if (!f.isDirectory()) {
                throw new IllegalArgumentException("Not a directory: " + f.getAbsolutePath());
            }
            if (!f.canWrite()) {
                throw new IllegalArgumentException("Can't write to state saving directory: " + f.getAbsolutePath());
            }
        }
    }

    @Override
    public StateDeserializer getStateDeserializer(String id, int iteration, ParamConfigurationSpace configSpace, List<ProblemInstance> instances, AlgorithmExecutionConfig execConfig, RunHistory rh) throws StateSerializationException {
        if (this.restoreFromPath == null) {
            throw new IllegalArgumentException("This Serializer does not support restoring state");
        }
        return new LegacyStateDeserializer(this.restoreFromPath, id, iteration, configSpace, instances, execConfig, rh);
    }

    @Override
    public StateSerializer getStateSerializer(String id, int iteration) throws StateSerializationException {
        if (this.saveStatePath == null) {
            throw new IllegalArgumentException("This Serializer does not support saving State");
        }
        return new LegacyStateSerializer(this.saveStatePath, id, iteration, this);
    }

    @Override
    public void copyFileToStateDir(String name, File f) {
        if (!f.isFile()) {
            throw new IllegalArgumentException("Input file f is not a file :" + f.getAbsolutePath());
        }
        if (!f.exists()) {
            throw new IllegalArgumentException("Input file f does not exist :" + f.getAbsolutePath());
        }
        try {
            this.copyFileToStateDir(name, new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("IOException occured :", e);
        }
    }

    public void copyFileToStateDir(String name, InputStream in) {
        if (this.saveStatePath == null) {
            throw new IllegalArgumentException("This Serializer does not support saving State");
        }
        File outputFile = new File(this.saveStatePath + File.separator + name);
        try {
            int len;
            FileOutputStream out = new FileOutputStream(outputFile);
            byte[] buf = new byte[8172];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
            this.log.info("File copied to {} ", (Object)outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException occured :", e);
        }
    }

    static String getUniqConfigurationsFilename(String path, String id, int iteration) {
        return LegacyStateFactory.getUniqConfigurationsFilename(path, id, String.valueOf(iteration), "-");
    }

    static String getUniqConfigurationsFilename(String path, String id, String iteration, String dash) {
        if (path.equals("")) {
            return "uniq_configurations" + dash + id + iteration + ".csv";
        }
        return path + File.separator + "uniq_configurations" + dash + id + iteration + ".csv";
    }

    static String getParamStringsFilename(String path, String id, int iteration) {
        return LegacyStateFactory.getParamStringsFilename(path, id, String.valueOf(iteration), "-");
    }

    static String getParamStringsFilename(String path, String id, String iteration, String dash) {
        if (path.equals("")) {
            return "paramstrings" + dash + id + iteration + ".txt";
        }
        return path + File.separator + "paramstrings" + dash + id + iteration + ".txt";
    }

    static String getRunAndResultsFilename(String path, String id, int iteration) {
        return LegacyStateFactory.getRunAndResultsFilename(path, id, String.valueOf(iteration));
    }

    public static String getRunAndResultsFilename(String path, String id, String iteration) {
        return LegacyStateFactory.getRunAndResultsFilename(path, id, iteration, "-");
    }

    public static String getRunAndResultsFilename(String path, String id, String iteration, String dash) {
        if (!path.equals("")) {
            return path + File.separator + "runs_and_results" + dash + id + iteration + ".csv";
        }
        return "runs_and_results" + dash + id + iteration + ".csv";
    }

    static String getJavaObjectDumpFilename(String path, String id, int iteration) {
        return path + File.separator + "java_obj_dump-v2-" + id + iteration + ".obj";
    }

    static String getJavaQuickObjectDumpFilename(String path, String id, int iteration) {
        return path + File.separator + "java_obj_dump-v2-" + id + "quick.obj";
    }

    public static String getJavaQuickBackObjectDumpFilename(String path, String id, int iteration) {
        return path + File.separator + "java_obj_dump-v2-" + id + "quick-bak.obj";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readIterationFromObjectFile(File javaObjDumpFile) {
        int n;
        block6: {
            ObjectInputStream oReader = null;
            try {
                oReader = new ObjectInputStream(new FileInputStream(javaObjDumpFile));
                Object o = oReader.readObject();
                Map map = (Map)o;
                n = Integer.valueOf(((Serializable)map.get(ITERATION_KEY)).toString());
                if (oReader == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (oReader != null) {
                        oReader.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return -1;
                }
            }
            oReader.close();
        }
        return n;
    }

    @Override
    public void purgePreviousStates() {
        if (this.savedFilesPerIteration.size() == 0) {
            return;
        }
        HashSet<String> filesToDelete = new HashSet<String>();
        for (Set<String> files : this.savedFilesPerIteration.values()) {
            filesToDelete.addAll(files);
        }
        filesToDelete.removeAll((Collection)this.savedFilesPerIteration.lastEntry().getValue());
        Integer lastIteration = this.savedFilesPerIteration.lastKey();
        this.log.info("Deleting all saved state files except those applicable to iteration {} ", (Object)lastIteration);
        if (this.log.isDebugEnabled()) {
            for (String filename : filesToDelete) {
                this.log.debug("Deleting file {}", (Object)filename);
                if (new File(filename).delete()) continue;
                this.log.warn("Could not delete file {} ", (Object)filename);
            }
        }
    }

    void addWrittenFilesForIteration(int iteration, Set<String> savedFiles) {
        this.savedFilesPerIteration.putIfAbsent(iteration, new HashSet());
        Set<String> iterationFiles = this.savedFilesPerIteration.get(iteration);
        iterationFiles.addAll(savedFiles);
    }
}

