/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class TargetAlgorithmEvaluatorHelper {
    public static List<AlgorithmRun> evaluateRunSyncToAsync(List<RunConfig> runConfigs, TargetAlgorithmEvaluator tae, TargetAlgorithmEvaluatorRunObserver obs) {
        if (runConfigs.size() == 0) {
            return Collections.emptyList();
        }
        final Semaphore b = new Semaphore(0);
        final AtomicBoolean success = new AtomicBoolean();
        final AtomicReference list = new AtomicReference();
        final AtomicReference rt = new AtomicReference();
        tae.evaluateRunsAsync(runConfigs, new TargetAlgorithmEvaluatorCallback(){

            @Override
            public void onSuccess(List<AlgorithmRun> runs) {
                success.set(true);
                list.set(runs);
                b.release();
            }

            @Override
            public void onFailure(RuntimeException t) {
                success.set(false);
                rt.set(t);
                b.release();
            }
        }, obs);
        b.acquireUninterruptibly();
        if (success.get()) {
            return (List)list.get();
        }
        throw (RuntimeException)rt.get();
    }

    private TargetAlgorithmEvaluatorHelper() {
    }
}

