/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrunner.AlgorithmRunner;
import ca.ubc.cs.beta.aclib.algorithmrunner.AutomaticConfiguratorFactory;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.AbstractSyncTargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli.CommandLineTargetAlgorithmEvaluatorOptions;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandLineTargetAlgorithmEvaluator
extends AbstractSyncTargetAlgorithmEvaluator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int observerFrequency;
    private final CommandLineTargetAlgorithmEvaluatorOptions options;
    private final boolean concurrentExecution;

    CommandLineTargetAlgorithmEvaluator(AlgorithmExecutionConfig execConfig, CommandLineTargetAlgorithmEvaluatorOptions options) {
        super(execConfig);
        this.observerFrequency = options.observerFrequency;
        this.log.debug("Initalized with the following Execution Configuration {} ", (Object)execConfig);
        this.concurrentExecution = options.concurrentExecution;
        if (this.observerFrequency < 50) {
            throw new ParameterException("Observer Frequency can't be less than 50 ms");
        }
        this.log.debug("Concurrent Execution {}", (Object)options.concurrentExecution);
        this.options = options;
        File execDir = new File(execConfig.getAlgorithmExecutionDirectory());
        if (!execDir.exists()) {
            throw new ParameterException("The Algorithm Execution Directory does not exist (" + execConfig.getAlgorithmExecutionDirectory() + ")");
        }
        if (!execDir.isDirectory()) {
            throw new ParameterException("The Algorithm Execution Directory is NOT a directory (" + execConfig.getAlgorithmExecutionDirectory() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        if (runConfigs.size() == 0) {
            return Collections.emptyList();
        }
        AlgorithmRunner runner = null;
        try {
            runner = this.getAlgorithmRunner(runConfigs, obs);
            List<AlgorithmRun> runs = runner.run();
            this.addRuns(runs);
            List<AlgorithmRun> list = runs;
            return list;
        }
        finally {
            if (runner != null) {
                runner.shutdownThreadPool();
            }
        }
    }

    private AlgorithmRunner getAlgorithmRunner(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        if (this.concurrentExecution && this.options.cores > 1) {
            this.log.debug("Using concurrent algorithm runner");
            return AutomaticConfiguratorFactory.getConcurrentAlgorithmRunner(this.execConfig, runConfigs, obs, this.options);
        }
        this.log.debug("Using single-threaded algorithm runner");
        return AutomaticConfiguratorFactory.getSingleThreadedAlgorithmRunner(this.execConfig, runConfigs, obs, this.options);
    }

    @Override
    public boolean isRunFinal() {
        return false;
    }

    @Override
    public boolean areRunsPersisted() {
        return false;
    }

    @Override
    protected void subtypeShutdown() {
    }

    @Override
    public boolean areRunsObservable() {
        return true;
    }
}

