/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.debug;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LeakingMemoryTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final List<byte[]> leakedMemory = new ArrayList<byte[]>();
    private volatile long totalLeaked = 0L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static volatile int memoryToLeak = 1024;

    public static void leakMemoryAmount(int newAmount) {
        if (newAmount < 0) {
            throw new IllegalArgumentException("I'm not supplying a user-friendly error to something that is designed to leak memory. Don't use this, or at the very least have the good sense to leak a positive amount of memory");
        }
        memoryToLeak = newAmount;
    }

    public LeakingMemoryTargetAlgorithmEvaluator(TargetAlgorithmEvaluator tae) {
        super(tae);
    }

    @Override
    public List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        List<AlgorithmRun> runs = this.tae.evaluateRun(runConfigs, obs);
        this.leak(runConfigs.size());
        return runs;
    }

    @Override
    public void evaluateRunsAsync(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorCallback handler, TargetAlgorithmEvaluatorRunObserver obs) {
        this.tae.evaluateRunsAsync(runConfigs, handler, obs);
        this.leak(runConfigs.size());
    }

    private synchronized void leak(int size) {
        this.totalLeaked += (long)(size * memoryToLeak);
        this.leakedMemory.add(new byte[size * memoryToLeak]);
        this.log.warn("Leaking >= {} bytes of memory, total leaked: {} MB", (Object)(size * memoryToLeak), (Object)(this.totalLeaked / 1024L / 1024L));
    }
}

