/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.debug;

import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class UncleanShutdownDetectingTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final AtomicLong notifyShutdownInvoked = new AtomicLong(0L);
    private static final int MESSAGE_REPEAT = 1;
    private static final int SLEEP_TIME_IN_MS = 0;
    private static final int SLEEP_TIME_BETWEEN_MESSAGES = 0;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final StackTraceElement[] taeCreationStackTrace = new Exception().getStackTrace();
    private static final Object stackTracePrintingLock = new Object();

    public UncleanShutdownDetectingTargetAlgorithmEvaluator(TargetAlgorithmEvaluator tae) {
        super(tae);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread.currentThread().setName("Unclean Target Algorithm Evaluator Shutdown Detector");
                try {
                    int i;
                    long notifies = UncleanShutdownDetectingTargetAlgorithmEvaluator.this.notifyShutdownInvoked.get();
                    if (notifies == 0L) {
                        UncleanShutdownDetectingTargetAlgorithmEvaluator.this.log.error("Unclean Shutdown Detected, You must call notifyShutdown() on your TAE. You may have a broken TAE decorator that doesn't forward the notifyShutdown() correctly");
                        for (i = 0; i < 1; ++i) {
                            System.err.println("Arr\u00eat anormal d\u00e9tect\u00e9. Vous devez appeler notifyShutdown() de votre TAE. Vous pouvez avoir un TAE qui bloque la transmission appropri\u00e9e.\n Unclean Shutdown Detected, You must call notifyShutdown() on your TAE before exiting. You may have a decorator that doesn't forward the call correctly.");
                            Thread.sleep(0L);
                        }
                        Thread.sleep(0L);
                    } else if (notifies > 1L) {
                        UncleanShutdownDetectingTargetAlgorithmEvaluator.this.log.warn("You called notifyShutdown() on your TAE more than once, this seems exceptionally weird");
                        for (i = 0; i < 1; ++i) {
                            System.err.println("You called notifyShutdown() on your TAE more than once, this is almost certainly a logic error and may cause weird behaivour");
                            Thread.sleep(0L);
                        }
                        Thread.sleep(0L);
                    } else if (notifies < 0L) {
                        UncleanShutdownDetectingTargetAlgorithmEvaluator.this.log.warn("You seem to have overflowed the counter we use to track the number of calls to notifyShutdown(), well played...");
                        for (i = 0; i < 1; ++i) {
                            System.err.println("You seem to have overflowed the counter we use to notify shutdown. I don't even have words for this");
                            Thread.sleep(0L);
                        }
                        Thread.sleep(0L);
                    } else {
                        return;
                    }
                    Object object = stackTracePrintingLock;
                    synchronized (object) {
                        if (UncleanShutdownDetectingTargetAlgorithmEvaluator.this.log.isDebugEnabled()) {
                            System.err.println("Target Algorithm Evaluator that wasn't shutdown, was created here");
                            for (StackTraceElement el : UncleanShutdownDetectingTargetAlgorithmEvaluator.this.taeCreationStackTrace) {
                                System.err.println(el);
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    System.err.println("Interrupted while trying to make you wait, don't think you are off the hook");
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }));
    }

    @Override
    public void notifyShutdown() {
        this.notifyShutdownInvoked.incrementAndGet();
        this.tae.notifyShutdown();
    }
}

