/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.safety;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.AbstractTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.exceptions.TargetAlgorithmAbortException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AbortOnFirstRunCrashTargetAlgorithmEvaluator
extends AbstractTargetAlgorithmEvaluatorDecorator {
    private final AtomicBoolean firstRunChecked = new AtomicBoolean(false);

    public AbortOnFirstRunCrashTargetAlgorithmEvaluator(TargetAlgorithmEvaluator tae) {
        super(tae);
    }

    @Override
    public List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return this.validate(super.evaluateRun(runConfigs, null));
    }

    private List<AlgorithmRun> validate(List<AlgorithmRun> runs) {
        if (runs.size() == 0) {
            return runs;
        }
        if (this.firstRunChecked.getAndSet(true)) {
            return runs;
        }
        if (runs.get(0).getRunResult().equals((Object)RunResult.CRASHED)) {
            throw new TargetAlgorithmAbortException("First Run Crashed : " + runs.toString());
        }
        return runs;
    }

    @Override
    public void evaluateRunsAsync(List<RunConfig> runConfigs, final TargetAlgorithmEvaluatorCallback handler, TargetAlgorithmEvaluatorRunObserver obs) {
        TargetAlgorithmEvaluatorCallback myHandler = new TargetAlgorithmEvaluatorCallback(){

            @Override
            public void onSuccess(List<AlgorithmRun> runs) {
                try {
                    AbortOnFirstRunCrashTargetAlgorithmEvaluator.this.validate(runs);
                    handler.onSuccess(runs);
                }
                catch (TargetAlgorithmAbortException e) {
                    handler.onFailure(e);
                }
            }

            @Override
            public void onFailure(RuntimeException t) {
                handler.onFailure(t);
            }
        };
        this.tae.evaluateRunsAsync(runConfigs, myHandler, obs);
    }
}

