/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.trajectoryfile;

import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.eventsystem.EventHandler;
import ca.ubc.cs.beta.aclib.eventsystem.events.AutomaticConfiguratorEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.AutomaticConfigurationEnd;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.IncumbentPerformanceChangeEvent;
import ca.ubc.cs.beta.aclib.misc.cputime.CPUTime;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import ca.ubc.cs.beta.aclib.termination.TerminationCondition;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFileEntry;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrajectoryFileLogger
implements EventHandler<AutomaticConfiguratorEvent> {
    private double lastEmpericalPerformance = 0.0;
    private ParamConfiguration lastIncumbent;
    private final RunHistory runHistory;
    private final TerminationCondition terminationCondition;
    private final FileWriter trajectoryFileWriter;
    private final FileWriter trajectoryFileWriterCSV;
    private final String fileNamePrefix;
    private static final Logger log = LoggerFactory.getLogger(TrajectoryFileLogger.class);
    boolean closed = false;
    IncumbentPerformanceChangeEvent lastIevent;
    private final List<TrajectoryFileEntry> tfes = new ArrayList<TrajectoryFileEntry>();

    public TrajectoryFileLogger(RunHistory runHistory, TerminationCondition terminationCondition, String fileNamePrefix, ParamConfiguration initialIncumbent) {
        this.fileNamePrefix = fileNamePrefix;
        this.runHistory = runHistory;
        this.terminationCondition = terminationCondition;
        try {
            this.trajectoryFileWriter = new FileWriter(fileNamePrefix + ".txt");
            this.trajectoryFileWriterCSV = new FileWriter(fileNamePrefix + ".csv");
            this.trajectoryFileWriter.append("\"Total Time\",\"Mean Performance\",\"Wallclock Time\",\"Incumbent ID\",\"Automatic Configurator Time\",\"Configuration...\"\n");
            this.trajectoryFileWriterCSV.append("\"Total Time\",\"Mean Performance\",\"Wallclock Time\",\"Incumbent ID\",\"Automatic Configurator Time\",\"Configuration...\"\n");
            this.writeIncumbent(0.0, Double.MAX_VALUE, 0.0, initialIncumbent, 0.0);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error occured creating files", e);
        }
    }

    @Override
    public synchronized void handleEvent(AutomaticConfiguratorEvent event) {
        if (event instanceof IncumbentPerformanceChangeEvent) {
            IncumbentPerformanceChangeEvent ievent;
            if (this.closed) {
                log.error("Got Another Event After shutdown:{} ", (Object)event.getClass().getCanonicalName());
            }
            this.lastIevent = ievent = (IncumbentPerformanceChangeEvent)event;
            this.writeIncumbent(ievent.getTunerTime(), ievent.getEmpiricalPerformance(), ievent.getWallTime(), ievent.getIncumbent(), ievent.getAutomaticConfiguratorCPUTime());
        } else if (event instanceof AutomaticConfigurationEnd) {
            log.info("Writing trajectory file to {}", (Object)new File(this.fileNamePrefix).getAbsolutePath());
            if (this.lastIevent != null) {
                this.writeIncumbent(this.terminationCondition.getTunerTime(), this.lastIevent.getEmpiricalPerformance(), this.terminationCondition.getWallTime(), this.lastIevent.getIncumbent(), CPUTime.getCPUTime());
            }
            try {
                this.trajectoryFileWriter.close();
                this.trajectoryFileWriterCSV.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.closed = true;
        } else {
            log.error("Got an event I wasn't expecting: {}", (Object)event.getClass().getCanonicalName());
        }
    }

    private synchronized void writeIncumbent(double tunerTime, double empiricalPerformance, double wallclockTime, ParamConfiguration incumbent, double acTime) {
        this.tfes.add(new TrajectoryFileEntry(incumbent, tunerTime, wallclockTime, empiricalPerformance, acTime));
        boolean outOfTime = this.terminationCondition.haveToStop();
        if (incumbent.equals(this.lastIncumbent) && this.lastEmpericalPerformance == empiricalPerformance && !outOfTime) {
            log.debug("No change in performance");
            return;
        }
        log.debug("Incumbent Performance changed");
        this.lastEmpericalPerformance = empiricalPerformance;
        this.lastIncumbent = incumbent;
        int thetaIdxInc = this.runHistory.getThetaIdx(incumbent);
        if (thetaIdxInc == -1) {
            thetaIdxInc = 1;
        }
        double wallClockTime = wallclockTime;
        String paramString = incumbent.getFormattedParamString(ParamConfiguration.StringFormat.STATEFILE_SYNTAX);
        String outLine = tunerTime + ", " + empiricalPerformance + ", " + wallClockTime / 1000.0 + ", " + thetaIdxInc + ", " + acTime + ", " + paramString + "\n";
        log.debug("Logging incumbent: (Runs {}): {}", this.lastIevent != null ? Long.valueOf(this.lastIevent.getIncumbentRunCount()) : "?", (Object)outLine.trim());
        try {
            this.trajectoryFileWriter.write(outLine);
            this.trajectoryFileWriter.flush();
            this.trajectoryFileWriterCSV.write(outLine);
            this.trajectoryFileWriterCSV.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not update trajectory file", e);
        }
    }

    public final synchronized List<TrajectoryFileEntry> getTrajectoryFileEntries() {
        return Collections.unmodifiableList(this.tfes);
    }
}

