/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.trajectoryfile;

import au.com.bytecode.opencsv.CSVReader;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.misc.csvhelpers.ConfigCSVFileHelper;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFileEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrajectoryFileParser {
    private static final Logger log = LoggerFactory.getLogger(TrajectoryFileParser.class);

    private static ConcurrentSkipListMap<Double, TrajectoryFileEntry> parseSMACTrajectoryFile(ConfigCSVFileHelper configs, ParamConfigurationSpace configSpace, boolean useTunerTimeAsWallTime) {
        ConcurrentSkipListMap<Double, TrajectoryFileEntry> skipList = new ConcurrentSkipListMap<Double, TrajectoryFileEntry>();
        for (int i = 0; i < configs.getNumberOfDataRows(); ++i) {
            String time = configs.getStringDataValue(i, 0);
            String[] dataRow = configs.getDataRow(i);
            StringBuilder sb = new StringBuilder();
            for (int j = 5; j < dataRow.length; ++j) {
                sb.append(dataRow[j]).append(",");
            }
            double tunerTime = Double.valueOf(dataRow[0]);
            double empiricalPerformance = Double.valueOf(dataRow[1]);
            double wallTime = Double.valueOf(dataRow[2]);
            if (wallTime == -1.0) {
                wallTime = tunerTime;
            }
            double overhead = Double.valueOf(dataRow[4]);
            ParamConfiguration configObj = configSpace.getConfigurationFromString(sb.toString(), ParamConfiguration.StringFormat.STATEFILE_SYNTAX);
            TrajectoryFileEntry tfe = new TrajectoryFileEntry(configObj, tunerTime, wallTime, empiricalPerformance, overhead);
            skipList.put(Double.valueOf(time), tfe);
        }
        return skipList;
    }

    private static ConcurrentSkipListMap<Double, TrajectoryFileEntry> parseParamILSTrajectoryFile(ConfigCSVFileHelper configs, ParamConfigurationSpace configSpace, boolean useTunerTimeAsWallTime) {
        ConcurrentSkipListMap<Double, TrajectoryFileEntry> skipList = new ConcurrentSkipListMap<Double, TrajectoryFileEntry>();
        ArrayList<String> paramNames = new ArrayList<String>(configSpace.getParameterNames());
        Collections.sort(paramNames);
        for (int i = 0; i < configs.getNumberOfDataRows(); ++i) {
            String time = configs.getStringDataValue(i, 0);
            String[] dataRow = configs.getDataRow(i);
            StringBuilder sb = new StringBuilder();
            int dataOffset = 5;
            for (int j = 0; j < paramNames.size(); ++j) {
                sb.append((String)paramNames.get(j)).append("=").append("'").append(dataRow[j + dataOffset]).append("',");
            }
            double tunerTime = Double.valueOf(dataRow[0]);
            Double empiricalPerformance = Double.valueOf(dataRow[1]);
            Double wallTime = Double.valueOf(dataRow[2]);
            Double overhead = Double.valueOf(dataRow[4]);
            if (wallTime == -1.0) {
                wallTime = tunerTime;
            }
            ParamConfiguration configObj = configSpace.getConfigurationFromString(sb.toString(), ParamConfiguration.StringFormat.STATEFILE_SYNTAX);
            TrajectoryFileEntry tfe = new TrajectoryFileEntry(configObj, tunerTime, wallTime, empiricalPerformance, overhead);
            skipList.put(Double.valueOf(time), tfe);
        }
        return skipList;
    }

    public static ConcurrentSkipListMap<Double, TrajectoryFileEntry> parseTrajectoryFile(ConfigCSVFileHelper configs, ParamConfigurationSpace configSpace, boolean useTunerTimeAsWallTime) {
        ConcurrentSkipListMap<Double, TrajectoryFileEntry> skipList;
        try {
            skipList = TrajectoryFileParser.parseSMACTrajectoryFile(configs, configSpace, useTunerTimeAsWallTime);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.info("Trajectory File is not in SMAC Format, falling back to ParamILS Format");
            skipList = TrajectoryFileParser.parseParamILSTrajectoryFile(configs, configSpace, useTunerTimeAsWallTime);
        }
        return skipList;
    }

    public static ConcurrentSkipListMap<Double, TrajectoryFileEntry> parseTrajectoryFile(ConfigCSVFileHelper configs, ParamConfigurationSpace configSpace) {
        return TrajectoryFileParser.parseTrajectoryFile(configs, configSpace, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConcurrentSkipListMap<Double, TrajectoryFileEntry> parseTrajectoryFile(File trajectoryFile, ParamConfigurationSpace configSpace, boolean useTunerTimeAsWallTime) throws FileNotFoundException, IOException {
        CSVReader configCSV = new CSVReader((Reader)new FileReader(trajectoryFile), ',', '\u0001');
        try {
            ConfigCSVFileHelper configs = new ConfigCSVFileHelper(configCSV.readAll(), 1, 0);
            ConcurrentSkipListMap<Double, TrajectoryFileEntry> concurrentSkipListMap = TrajectoryFileParser.parseTrajectoryFile(configs, configSpace, useTunerTimeAsWallTime);
            return concurrentSkipListMap;
        }
        finally {
            configCSV.close();
        }
    }

    public static List<TrajectoryFileEntry> parseTrajectoryFileAsList(File trajectoryFile, ParamConfigurationSpace configSpace, boolean useTunerTimeAsWallTime) throws FileNotFoundException, IOException {
        ConcurrentSkipListMap<Double, TrajectoryFileEntry> parseTrajectoryFile = TrajectoryFileParser.parseTrajectoryFile(trajectoryFile, configSpace, useTunerTimeAsWallTime);
        ArrayList<TrajectoryFileEntry> tfes = new ArrayList<TrajectoryFileEntry>(parseTrajectoryFile.size());
        for (TrajectoryFileEntry tfe : parseTrajectoryFile.values()) {
            tfes.add(tfe);
        }
        return tfes;
    }

    public static ConcurrentSkipListMap<Double, TrajectoryFileEntry> parseTrajectoryFile(File trajectoryFile, ParamConfigurationSpace configSpace) throws FileNotFoundException, IOException {
        return TrajectoryFileParser.parseTrajectoryFile(trajectoryFile, configSpace, false);
    }

    public static List<TrajectoryFileEntry> parseTrajectoryFileAsList(File trajectoryFile, ParamConfigurationSpace configSpace) throws FileNotFoundException, IOException {
        return TrajectoryFileParser.parseTrajectoryFileAsList(trajectoryFile, configSpace, false);
    }
}

