import java.util.Vector;
import java.util.Iterator;

public class CheckInter {
    
    private Domain DA,DB;
    private Vector intAtoms;
    private int noA, noB;
    private double intVol;
    
    public CheckInter(Domain DA, Domain DB) {
	this.DA = DA;
	this.DB = DB;
	intAtoms = new Vector();
	intVol = noA = noB = 0;
    }
    
    public void calcTrueInter(){
	Vector atomsA = (Vector)DA.getAtomsVector();
	Vector atomsB = (Vector)DB.getAtomsVector();
	boolean flag = false;
	
	for (Iterator i = atomsA.iterator(); i.hasNext();){
	    Atom atomA = (Atom)i.next();
	    for (Iterator j = atomsB.iterator(); j.hasNext();){
		Atom atomB = (Atom)j.next();
		if(interact(atomA,atomB)){
		    atomA.setInteraction(true);
		    atomB.setInteraction(true);
		}
	    }
	}
	setAtomA(atomsA);
	setAtomB(atomsB);
	calcVolume();
    }
    
    private void setAtomA(Vector atoms){
	int counter = 0;
	for (Iterator i = atoms.iterator(); i.hasNext();){
	    Atom atom = (Atom)i.next();
	    if(atom.getInteraction()){
		intAtoms.add(atom);
		counter++;
	    }
	}
	noA = counter;
    }
    
    private void setAtomB(Vector atoms){
	int counter = 0;
	for (Iterator i = atoms.iterator(); i.hasNext();){
	    Atom atom = (Atom)i.next();
	    if(atom.getInteraction()){
		intAtoms.add(atom);
		counter++;
	    }
	}
	noB = counter;
    }
    
    private void calcVolume(){
	try{
	    ConvexHull intHull = new ConvexHull(intAtoms);
	    //Hull.print2File(intHull,"AA");
	    intVol=Hull.calcVolume(intHull);
	}catch(ConvexHullException ce){
	    intVol=0;
	}
    }

    private boolean interact(Atom atomA, Atom atomB){
	if(Vertex.distance(atomA,atomB)<=DomainInter.THRES)
	    return true;
	else
	    return false;
    }
    
    public double getIntVol(){
	return intVol;
    }
    
    public int getAtomA(){
	return noA;
    }
    
    public int getAtomB(){
	return noB;
    }

}
