package ca.ubc.cs.beta.aclib.misc.jcommander.validator;

import ca.ubc.cs.beta.aclib.misc.options.DomainDisplay;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.ParameterException;

public class ZeroInfinityHalfOpenIntervalRight implements IParameterValidator, DomainDisplay {

	  public void validate(String name, String value)
	      throws ParameterException {
	    double n = Double.parseDouble(value);
	    if (n < 0) {
	      throw new ParameterException("Parameter " + name
	          + " should be non-negative (found " + value +")");
	    }
	  }
	  
	  @Override
	  public String getDomain() {
			return "[0, " + Double.POSITIVE_INFINITY + ")";
	  }

	}