#!/usr/bin/env pyformex --gui
# $Id: Slice.py 1497 2010-06-05 08:50:48Z bverheg $
##
##  This file is part of pyFormex 0.8.2 Release Sat Jun  5 10:49:53 2010
##  pyFormex is a tool for generating, manipulating and transforming 3D
##  geometrical models by sequences of mathematical operations.
##  Homepage: http://pyformex.org   (http://pyformex.berlios.de)
##  Copyright (C) Benedict Verhegghe (benedict.verhegghe@ugent.be) 
##  Distributed under the GNU General Public License version 3 or later.
##
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see http://www.gnu.org/licenses/.
##

"""Slice

level = 'advanced'
topics = ['surface']
techniques = ['colors','widgets']

"""
from plugins.surface import TriSurface


def askSlices(bb):
    res = askItems([['Direction',0],
                    ['# slices',25],
                    ['total rot',70.],
                   ],caption = 'Define the slicing planes')
    if res:
        axis = res['Direction']
        nslices = res['# slices']
        totalrot = res['total rot']
        xmin,xmax = bb[:,axis]
        dx =  (xmax-xmin) / nslices
        x = arange(nslices+1) * dx
        N = unitVector(axis)
        P = [ bb[0]+N*s for s in x ]
        return P,N,totalrot
    else:
        return None

reset()
smooth()
lights(True)
transparent(False)
setView('horse',[20,20,0])
S = TriSurface.read(getcfg('datadir')+'/horse.gts')
bb = S.bbox()

t = -0.3
bb[0] = (1.0-t)*bb[0] + t*bb[1]
draw(S,bbox=bb,view='front')

try:
    P,n,t = askSlices(S.bbox())
except:
    exit()

a = t/len(P)

F = S.toFormex()
G = []
old = seterr(all='ignore')
setDrawOptions({'bbox':None})
for i,p in enumerate(P):
    F1,F = F.cutWithPlane(p,-n)
    F1.setProp(i)
    G = [ g.rot(a,around=p) for g in G ] 
    G.append(F1)
    clear()
    draw(F)
    draw(G)

seterr(**old)

x = GD.canvas.width()/2
y = GD.canvas.height() - 40
drawText("No animals got hurt during the making of this movie!",x,y,size=18,gravity='C')

# End
