# Copyright (C) 2010-2011 anmitsu <anmitsu.s@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

from pyful import completion
from pyful.completion import Argument

def _python_arguments(f): return (
    ("-3"  , "-- warn about Python 3.x incompatibilities", f.comp_files),
    ("-B"  , "-- don't write .py[co] files on import", f.comp_files),
    ("-E"  , "-- ignore PYTHON* environment variables (such as PYTHONPATH)", f.comp_files),
    ("-O"  , "-- optimize generated bytecode slightly", f.comp_files),
    ("-OO" , "-- remove doc-strings in addition to the -O optimizations", f.comp_files),
    ("-Q"  , "-- division options", f.comp_files),
    ("-S"  , "-- don't imply 'import site' on initialization", f.comp_files),
    ("-W"  , "-- warning control", f.comp_files),
    ("-c"  , "-- program passed in as string (terminates option list)", f.comp_files),
    ("-d"  , "-- debug output from parser", f.comp_files),
    ("-i"  , "-- inspect interactively after running script", f.comp_files),
    ("-m"  , "-- run library module as a script (terminates option list)", f.comp_files),
    ("-s"  , "-- don't add user site directory to sys.path", f.comp_files),
    ("-t"  , "-- issue warnings about inconsistent tab usage", f.comp_files),
    ("-tt" , "-- issue errors about inconsistent tab usage", f.comp_files),
    ("-u"  , "-- unbuffered binary stdout and stderr", f.comp_files),
    ("-v"  , "-- verbose (trace import statements)", f.comp_files),
    ("-x"  , "-- skip first line of source, allowing use of non-Unix forms of #!cmd", f.comp_files),
    (("-V", "--version") , "-- print the Python version number and exit", f.comp_files),
    (("-h", "--help")    , "-- print this help message and exit", f.comp_files),
    )

class Python(completion.ShellCompletionFunction):
    def __init__(self):
        self.arguments = [Argument(*item) for item in _python_arguments(self)]

    def default(self):
        return self.comp_files()

completion.register("python", Python)
