import requests
from optparse import OptionParser

URL = "http://gitignore.io/api/"
USAGE = "Usage: gi <ignore_string>"

def _build_parser():
    p = OptionParser(USAGE)
    p.add_option("-f", "--file", dest = "write_file", default = "")
    return p

def main():
    (opts, args) = _build_parser().parse_args()

    if len(args) < 1:
        print(USAGE)
        return

    r = requests.get(URL + args[0])

    if opts.write_file:
        try:
            with open(opts.write_file, "w") as ignore_file:
                ignore_file.write(r.text)
        except IOError as e:
            print("ERROR: Unable to write file, printing to console instead")
            print(r.text)
    else:
        print(r.text)

if __name__ == "__main__":
    main()
