""" Python Character Mapping Codec cp1147 : EBCDIC France, Euro support
"""

import codecs


### Codec APIs
class Codec(codecs.Codec):
    def encode(self,input,errors='strict'):
        return codecs.charmap_encode(input,errors,encoding_table)
    def decode(self,input,errors='strict'):
        return codecs.charmap_decode(input,errors,decoding_table)

class IncrementalEncoder(codecs.IncrementalEncoder):
    def encode(self, input, final=False):
        return codecs.charmap_encode(input,self.errors,encoding_table)[0]

class IncrementalDecoder(codecs.IncrementalDecoder):
    def decode(self, input, final=False):
        return codecs.charmap_decode(input,self.errors,decoding_table)[0]

class StreamWriter(Codec,codecs.StreamWriter):
    pass

class StreamReader(Codec,codecs.StreamReader):
    pass

### encodings module API

def getregentry():
    return codecs.CodecInfo(
        name='cp1147',
        encode=Codec().encode,
        decode=Codec().decode,
        incrementalencoder=IncrementalEncoder,
        incrementaldecoder=IncrementalDecoder,
        streamreader=StreamReader,
        streamwriter=StreamWriter,
    )

### Decoding Table
decoding_table = (
u'\x00'
u'\x01'
u'\x02'
u'\x03'
u'\x9c'
u'\x09'  
u'\x86'
u'\x7f'
u'\x97'
u'\x8d'
u'\x8e'
u'\x0b'
u'\x0c'
u'\x0d'  
u'\x0e'
u'\x0f'
u'\x10'
u'\x11'
u'\x12'
u'\x13'
u'\x9d'
u'\x85'
u'\x08'
u'\x87'
u'\x18'
u'\x19'
u'\x92'
u'\x8f'
u'\x1c'
u'\x1d'
u'\x1e'
u'\x1f'
u'\x80'
u'\x81'
u'\x82'
u'\x83'
u'\x84'
u'\x0a'
u'\x17'
u'\x1b'
u'\x88'
u'\x89'
u'\x8a'
u'\x8b'
u'\x8c'
u'\x05'
u'\x06'
u'\x07'
u'\x90'
u'\x91'
u'\x16'
u'\x93'
u'\x94'
u'\x95'
u'\x96'
u'\x04'
u'\x98'
u'\x99'
u'\x9a'
u'\x9b'
u'\x14'
u'\x15'
u'\x9e'
u'\x1a'
u'\x20' 
u'\xa0'
u'\xe2'
u'\xe4'
u'\x40' 
u'\xe1'
u'\xe3'
u'\xe5'
u'\x5c' 
u'\xf1'
u'\xb0' 
u'\x2e' 
u'\x3c' 
u'\x28' 
u'\x2b' 
u'\x21' 
u'\x26' 
u'\x7b'
u'\xea'
u'\xeb'
u'\x7d'
u'\xed'
u'\xee'
u'\xef'
u'\xec'
u'\xdf'
u'\xa7'
u'\x24'
u'\x2a'
u'\x29'
u'\x3b'
u'\x5e'
u'\x2d'
u'\x2f'
u'\xc2'
u'\xc4'
u'\xc0'
u'\xc1'
u'\xc3'
u'\xc5'
u'\xc7'
u'\xd1'
u'\xf9'
u'\x2c'
u'\x25'
u'\x5f'
u'\x3e'
u'\x3f'
u'\xf8'
u'\xc9'
u'\xca'
u'\xcb'
u'\xc8'
u'\xcd'
u'\xce'
u'\xcf'
u'\xcc'
u'\xb5'
u'\x3a'
u'\xa3'
u'\xe0'
u'\x27'
u'\x3d'
u'\x22'
u'\xd8'
u'\x61'
u'\x62'
u'\x63'
u'\x64'
u'\x65'
u'\x66'
u'\x67'
u'\x68'
u'\x69'
u'\xab'
u'\xbb'
u'\xf0'
u'\xfd'
u'\xfe'
u'\xb1'
u'\x5b'
u'\x6a'
u'\x6b'
u'\x6c'
u'\x6d'
u'\x6e'
u'\x6f'
u'\x70'
u'\x71'
u'\x72'
u'\xaa'
u'\xba'
u'\xe6'
u'\xb8'
u'\xc6'
u'\u20ac'   # EURO SIGN
u'\x60'
u'\xa8'
u'\x73'
u'\x74'
u'\x75'
u'\x76'
u'\x77'
u'\x78'
u'\x79'
u'\x7a'
u'\xa1'
u'\xbf'
u'\xd0'
u'\xdd'
u'\xde'
u'\xae'
u'\xa2'
u'\x23'
u'\xa5'
u'\xb7'
u'\xa9'
u'\x5d'
u'\xb6'
u'\xbc'
u'\xbd'
u'\xbe'
u'\xac'
u'\x7c'
u'\xaf'
u'\x7e'
u'\xb4'
u'\xd7'
u'\xe9'
u'\x41'
u'\x42'
u'\x43'
u'\x44'
u'\x45'
u'\x46'
u'\x47'
u'\x48'
u'\x49'
u'\xad'
u'\xf4'
u'\xf6'
u'\xf2'
u'\xf3'
u'\xf5'
u'\xe8'
u'\x4a'
u'\x4b'
u'\x4c'
u'\x4d'
u'\x4e'
u'\x4f'
u'\x50'
u'\x51'
u'\x52'
u'\xb9'
u'\xfb'
u'\xfc'
u'\xa6'
u'\xfa'
u'\xff'
u'\xe7'
u'\xf7'
u'\x53'
u'\x54'
u'\x55'
u'\x56'
u'\x57'
u'\x58'
u'\x59'
u'\x5a'
u'\xb2'
u'\xd4'
u'\xd6'
u'\xd2'
u'\xd3'
u'\xd5'
u'\x30'
u'\x31'
u'\x32'
u'\x33'
u'\x34'
u'\x35'
u'\x36'
u'\x37'
u'\x38'
u'\x39'
u'\xb3'
u'\xdb'
u'\xdc'
u'\xd9'
u'\xda'
u'\x9f'
)

### Encoding table
encoding_table=codecs.charmap_build(decoding_table)    
