#!/usr/bin/env python

from __future__ import print_function

from os.path import dirname, join, exists
from distutils.core import setup

try:
    from setuptools.command.install import install as _install
except ImportError:
    from distutils.command.install import install as _install

import sys
import subprocess

setup_dir = dirname(__file__)

def _post_install():
    '''Initialize the parse table at install time'''
    import hcl
    from hcl.parser import HclParser
    parser = HclParser()


class install(_install):
    def run(self):
        _install.run(self)
        self.execute(_post_install, (), msg="Generating parse table...")

def get_version():
    d = {}
    with open(join(setup_dir, 'src', 'hcl', 'version.py')) as fp:
        exec(compile(fp.read(), 'version.py', 'exec'), {}, d)
    return d['__version__']

# Automatically generate a version.py based on the git version
if exists(join(setup_dir, '.git')):
    p = subprocess.Popen(["git", "describe", "--tags", "--dirty=-dirty"],
                         stdout=subprocess.PIPE,
                         stderr=subprocess.PIPE)
    out, err = p.communicate()
    # Make sure the git version has at least one tag
    if err:
        print("Error: You need to create a tag for this repo to use the builder")
        sys.exit(1)
    
    # Create the version.py file
    with open(join(setup_dir, 'src', 'hcl', 'version.py'), 'w') as fp:
        fp.write("# Autogenerated by setup.py\n__version__ = '{0}'".format(out.decode('utf-8').rstrip()))

with open(join(dirname(__file__), 'README.rst'), 'r') as readme_file:
    long_description = readme_file.read()

install_requires=open(join(setup_dir, 'requirements.txt')).readlines()

setup(name='pyhcl',
      version=get_version(),
      description='HCL configuration parser for python',
      long_description=long_description,
      author='Dustin Spicuzza',
      author_email='dustin@virtualroadside.com',
      package_dir={'': 'src'},
      packages=['hcl'],
      scripts=["scripts/hcltool"],
      setup_requires=install_requires,
      install_requires=install_requires,
      cmdclass={'install': install},
      classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: Mozilla Public License 2.0 (MPL 2.0)",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
        "Topic :: Text Processing"
      ])


