import sys

from thrift.protocol.TBinaryProtocol import TBinaryProtocol
from thrift.transport.TSocket import TSocket
from thrift.transport.TTransport import TBufferedTransport
import sasl
from cloudera.thrift_sasl import TSaslClientTransport

from TCLIService import TCLIService

from cursor import Cursor
from TCLIService.ttypes import TCloseSessionReq,TOpenSessionReq

class Connection(object):
    client = None
    session = None

    def __init__(self, host=None, port=10000, authMechanism=None, user=None, password=None, database=None):
        authMechanisms = {'NOSASL', 'PLAIN', 'KERBEROS', 'LDAP'}
        if authMechanism not in authMechanisms or authMechanism == 'KERBEROS':
            raise NotImplementedError('authMechanism is either not supported or not implemented')
        socket = TSocket(host, port)
        if authMechanism == 'NOSASL':
            transport = TBufferedTransport(socket)
        else:
            saslc = sasl.Client()
            saslc.setAttr("username", user)
            saslc.setAttr("password", password)
            saslc.init()
            transport = TSaslClientTransport(saslc, "PLAIN", socket)
        self.client = TCLIService.Client(TBinaryProtocol(transport))
        transport.open()
        res = self.client.OpenSession(TOpenSessionReq())
        self.session = res.sessionHandle

    def cursor(self):
        return Cursor(self.client, self.session)

    def close(self):
        req = TCloseSessionReq(sessionHandle=self.session)
        self.client.CloseSession(req)