""" Data objects in group "Coils"
"""

from collections import OrderedDict
import logging
from pyidf.helper import DataObject

logger = logging.getLogger("pyidf")
logger.addHandler(logging.NullHandler())



class CoilCoolingWater(DataObject):

    """ Corresponds to IDD object `Coil:Cooling:Water`
        Chilled water cooling coil, NTU-effectiveness model, with inputs for design entering
        and leaving conditionss.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'design water flow rate',
                                      {'name': u'Design Water Flow Rate',
                                       'pyname': u'design_water_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'design air flow rate',
                                      {'name': u'Design Air Flow Rate',
                                       'pyname': u'design_air_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'design inlet water temperature',
                                      {'name': u'Design Inlet Water Temperature',
                                       'pyname': u'design_inlet_water_temperature',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'design inlet air temperature',
                                      {'name': u'Design Inlet Air Temperature',
                                       'pyname': u'design_inlet_air_temperature',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'design outlet air temperature',
                                      {'name': u'Design Outlet Air Temperature',
                                       'pyname': u'design_outlet_air_temperature',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'design inlet air humidity ratio',
                                      {'name': u'Design Inlet Air Humidity Ratio',
                                       'pyname': u'design_inlet_air_humidity_ratio',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'kgWater/kgDryAir'}),
                                     (u'design outlet air humidity ratio',
                                      {'name': u'Design Outlet Air Humidity Ratio',
                                       'pyname': u'design_outlet_air_humidity_ratio',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'kgWater/kgDryAir'}),
                                     (u'water inlet node name',
                                      {'name': u'Water Inlet Node Name',
                                       'pyname': u'water_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'water outlet node name',
                                      {'name': u'Water Outlet Node Name',
                                       'pyname': u'water_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air inlet node name',
                                      {'name': u'Air Inlet Node Name',
                                       'pyname': u'air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air outlet node name',
                                      {'name': u'Air Outlet Node Name',
                                       'pyname': u'air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'type of analysis',
                                      {'name': u'Type of Analysis',
                                       'pyname': u'type_of_analysis',
                                       'default': u'SimpleAnalysis',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SimpleAnalysis',
                                                           u'DetailedAnalysis'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heat exchanger configuration',
                                      {'name': u'Heat Exchanger Configuration',
                                       'pyname': u'heat_exchanger_configuration',
                                       'default': u'CounterFlow',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'CrossFlow',
                                                           u'CounterFlow'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'condensate collection water storage tank name',
                                      {'name': u'Condensate Collection Water Storage Tank Name',
                                       'pyname': u'condensate_collection_water_storage_tank_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 15,
              'name': u'Coil:Cooling:Water',
              'pyname': u'CoilCoolingWater',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def design_water_flow_rate(self):
        """Get design_water_flow_rate.

        Returns:
            float: the value of `design_water_flow_rate` or None if not set

        """
        return self["Design Water Flow Rate"]

    @design_water_flow_rate.setter
    def design_water_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Design Water Flow Rate`

        Args:
            value (float or "Autosize"): value for IDD Field `Design Water Flow Rate`
                Units: m3/s
                IP-Units: gal/min
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Design Water Flow Rate"] = value

    @property
    def design_air_flow_rate(self):
        """Get design_air_flow_rate.

        Returns:
            float: the value of `design_air_flow_rate` or None if not set

        """
        return self["Design Air Flow Rate"]

    @design_air_flow_rate.setter
    def design_air_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Design Air Flow Rate`

        Args:
            value (float or "Autosize"): value for IDD Field `Design Air Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Design Air Flow Rate"] = value

    @property
    def design_inlet_water_temperature(self):
        """Get design_inlet_water_temperature.

        Returns:
            float: the value of `design_inlet_water_temperature` or None if not set

        """
        return self["Design Inlet Water Temperature"]

    @design_inlet_water_temperature.setter
    def design_inlet_water_temperature(self, value="autosize"):
        """Corresponds to IDD field `Design Inlet Water Temperature`

        Args:
            value (float or "Autosize"): value for IDD Field `Design Inlet Water Temperature`
                Units: C
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Design Inlet Water Temperature"] = value

    @property
    def design_inlet_air_temperature(self):
        """Get design_inlet_air_temperature.

        Returns:
            float: the value of `design_inlet_air_temperature` or None if not set

        """
        return self["Design Inlet Air Temperature"]

    @design_inlet_air_temperature.setter
    def design_inlet_air_temperature(self, value="autosize"):
        """Corresponds to IDD field `Design Inlet Air Temperature`

        Args:
            value (float or "Autosize"): value for IDD Field `Design Inlet Air Temperature`
                Units: C
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Design Inlet Air Temperature"] = value

    @property
    def design_outlet_air_temperature(self):
        """Get design_outlet_air_temperature.

        Returns:
            float: the value of `design_outlet_air_temperature` or None if not set

        """
        return self["Design Outlet Air Temperature"]

    @design_outlet_air_temperature.setter
    def design_outlet_air_temperature(self, value="autosize"):
        """Corresponds to IDD field `Design Outlet Air Temperature`

        Args:
            value (float or "Autosize"): value for IDD Field `Design Outlet Air Temperature`
                Units: C
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Design Outlet Air Temperature"] = value

    @property
    def design_inlet_air_humidity_ratio(self):
        """Get design_inlet_air_humidity_ratio.

        Returns:
            float: the value of `design_inlet_air_humidity_ratio` or None if not set

        """
        return self["Design Inlet Air Humidity Ratio"]

    @design_inlet_air_humidity_ratio.setter
    def design_inlet_air_humidity_ratio(self, value="autosize"):
        """Corresponds to IDD field `Design Inlet Air Humidity Ratio`

        Args:
            value (float or "Autosize"): value for IDD Field `Design Inlet Air Humidity Ratio`
                Units: kgWater/kgDryAir
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Design Inlet Air Humidity Ratio"] = value

    @property
    def design_outlet_air_humidity_ratio(self):
        """Get design_outlet_air_humidity_ratio.

        Returns:
            float: the value of `design_outlet_air_humidity_ratio` or None if not set

        """
        return self["Design Outlet Air Humidity Ratio"]

    @design_outlet_air_humidity_ratio.setter
    def design_outlet_air_humidity_ratio(self, value="autosize"):
        """Corresponds to IDD field `Design Outlet Air Humidity Ratio`

        Args:
            value (float or "Autosize"): value for IDD Field `Design Outlet Air Humidity Ratio`
                Units: kgWater/kgDryAir
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Design Outlet Air Humidity Ratio"] = value

    @property
    def water_inlet_node_name(self):
        """Get water_inlet_node_name.

        Returns:
            str: the value of `water_inlet_node_name` or None if not set

        """
        return self["Water Inlet Node Name"]

    @water_inlet_node_name.setter
    def water_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Water Inlet Node Name`

        Args:
            value (str): value for IDD Field `Water Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Water Inlet Node Name"] = value

    @property
    def water_outlet_node_name(self):
        """Get water_outlet_node_name.

        Returns:
            str: the value of `water_outlet_node_name` or None if not set

        """
        return self["Water Outlet Node Name"]

    @water_outlet_node_name.setter
    def water_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Water Outlet Node Name`

        Args:
            value (str): value for IDD Field `Water Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Water Outlet Node Name"] = value

    @property
    def air_inlet_node_name(self):
        """Get air_inlet_node_name.

        Returns:
            str: the value of `air_inlet_node_name` or None if not set

        """
        return self["Air Inlet Node Name"]

    @air_inlet_node_name.setter
    def air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Inlet Node Name"] = value

    @property
    def air_outlet_node_name(self):
        """Get air_outlet_node_name.

        Returns:
            str: the value of `air_outlet_node_name` or None if not set

        """
        return self["Air Outlet Node Name"]

    @air_outlet_node_name.setter
    def air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Outlet Node Name"] = value

    @property
    def type_of_analysis(self):
        """Get type_of_analysis.

        Returns:
            str: the value of `type_of_analysis` or None if not set

        """
        return self["Type of Analysis"]

    @type_of_analysis.setter
    def type_of_analysis(self, value="SimpleAnalysis"):
        """Corresponds to IDD field `Type of Analysis`

        Args:
            value (str): value for IDD Field `Type of Analysis`
                Default value: SimpleAnalysis
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Type of Analysis"] = value

    @property
    def heat_exchanger_configuration(self):
        """Get heat_exchanger_configuration.

        Returns:
            str: the value of `heat_exchanger_configuration` or None if not set

        """
        return self["Heat Exchanger Configuration"]

    @heat_exchanger_configuration.setter
    def heat_exchanger_configuration(self, value="CounterFlow"):
        """Corresponds to IDD field `Heat Exchanger Configuration`

        Args:
            value (str): value for IDD Field `Heat Exchanger Configuration`
                Default value: CounterFlow
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Exchanger Configuration"] = value

    @property
    def condensate_collection_water_storage_tank_name(self):
        """Get condensate_collection_water_storage_tank_name.

        Returns:
            str: the value of `condensate_collection_water_storage_tank_name` or None if not set

        """
        return self["Condensate Collection Water Storage Tank Name"]

    @condensate_collection_water_storage_tank_name.setter
    def condensate_collection_water_storage_tank_name(self, value=None):
        """Corresponds to IDD field `Condensate Collection Water Storage Tank
        Name`

        Args:
            value (str): value for IDD Field `Condensate Collection Water Storage Tank Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Condensate Collection Water Storage Tank Name"] = value




class CoilCoolingWaterDetailedGeometry(DataObject):

    """ Corresponds to IDD object `Coil:Cooling:Water:DetailedGeometry`
        Chilled water cooling coil, detailed flat fin coil model for continuous plate fins,
        with inputs for detailed coil geometry specificatons.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'maximum water flow rate',
                                      {'name': u'Maximum Water Flow Rate',
                                       'pyname': u'maximum_water_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'tube outside surface area',
                                      {'name': u'Tube Outside Surface Area',
                                       'pyname': u'tube_outside_surface_area',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm2'}),
                                     (u'total tube inside area',
                                      {'name': u'Total Tube Inside Area',
                                       'pyname': u'total_tube_inside_area',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm2'}),
                                     (u'fin surface area',
                                      {'name': u'Fin Surface Area',
                                       'pyname': u'fin_surface_area',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm2'}),
                                     (u'minimum airflow area',
                                      {'name': u'Minimum Airflow Area',
                                       'pyname': u'minimum_airflow_area',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm2'}),
                                     (u'coil depth',
                                      {'name': u'Coil Depth',
                                       'pyname': u'coil_depth',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm'}),
                                     (u'fin diameter',
                                      {'name': u'Fin Diameter',
                                       'pyname': u'fin_diameter',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm'}),
                                     (u'fin thickness',
                                      {'name': u'Fin Thickness',
                                       'pyname': u'fin_thickness',
                                       'default': 0.0015,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm'}),
                                     (u'tube inside diameter',
                                      {'name': u'Tube Inside Diameter',
                                       'pyname': u'tube_inside_diameter',
                                       'default': 0.01445,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm'}),
                                     (u'tube outside diameter',
                                      {'name': u'Tube Outside Diameter',
                                       'pyname': u'tube_outside_diameter',
                                       'default': 0.0159,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm'}),
                                     (u'tube thermal conductivity',
                                      {'name': u'Tube Thermal Conductivity',
                                       'pyname': u'tube_thermal_conductivity',
                                       'default': 386.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 1.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/m-K'}),
                                     (u'fin thermal conductivity',
                                      {'name': u'Fin Thermal Conductivity',
                                       'pyname': u'fin_thermal_conductivity',
                                       'default': 204.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 1.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/m-K'}),
                                     (u'fin spacing',
                                      {'name': u'Fin Spacing',
                                       'pyname': u'fin_spacing',
                                       'default': 0.0018,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm'}),
                                     (u'tube depth spacing',
                                      {'name': u'Tube Depth Spacing',
                                       'pyname': u'tube_depth_spacing',
                                       'default': 0.026,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm'}),
                                     (u'number of tube rows',
                                      {'name': u'Number of Tube Rows',
                                       'pyname': u'number_of_tube_rows',
                                       'default': 4.0,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'number of tubes per row',
                                      {'name': u'Number of Tubes per Row',
                                       'pyname': u'number_of_tubes_per_row',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'water inlet node name',
                                      {'name': u'Water Inlet Node Name',
                                       'pyname': u'water_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'water outlet node name',
                                      {'name': u'Water Outlet Node Name',
                                       'pyname': u'water_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air inlet node name',
                                      {'name': u'Air Inlet Node Name',
                                       'pyname': u'air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air outlet node name',
                                      {'name': u'Air Outlet Node Name',
                                       'pyname': u'air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'condensate collection water storage tank name',
                                      {'name': u'Condensate Collection Water Storage Tank Name',
                                       'pyname': u'condensate_collection_water_storage_tank_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 0,
              'name': u'Coil:Cooling:Water:DetailedGeometry',
              'pyname': u'CoilCoolingWaterDetailedGeometry',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def maximum_water_flow_rate(self):
        """Get maximum_water_flow_rate.

        Returns:
            float: the value of `maximum_water_flow_rate` or None if not set

        """
        return self["Maximum Water Flow Rate"]

    @maximum_water_flow_rate.setter
    def maximum_water_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Maximum Water Flow Rate`

        Args:
            value (float or "Autosize"): value for IDD Field `Maximum Water Flow Rate`
                Units: m3/s
                IP-Units: gal/min
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Maximum Water Flow Rate"] = value

    @property
    def tube_outside_surface_area(self):
        """Get tube_outside_surface_area.

        Returns:
            float: the value of `tube_outside_surface_area` or None if not set

        """
        return self["Tube Outside Surface Area"]

    @tube_outside_surface_area.setter
    def tube_outside_surface_area(self, value="autosize"):
        """Corresponds to IDD field `Tube Outside Surface Area` Tube Primary
        Surface Area.

        Args:
            value (float or "Autosize"): value for IDD Field `Tube Outside Surface Area`
                Units: m2
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Tube Outside Surface Area"] = value

    @property
    def total_tube_inside_area(self):
        """Get total_tube_inside_area.

        Returns:
            float: the value of `total_tube_inside_area` or None if not set

        """
        return self["Total Tube Inside Area"]

    @total_tube_inside_area.setter
    def total_tube_inside_area(self, value="autosize"):
        """Corresponds to IDD field `Total Tube Inside Area` Total tube inside
        surface area.

        Args:
            value (float or "Autosize"): value for IDD Field `Total Tube Inside Area`
                Units: m2
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Total Tube Inside Area"] = value

    @property
    def fin_surface_area(self):
        """Get fin_surface_area.

        Returns:
            float: the value of `fin_surface_area` or None if not set

        """
        return self["Fin Surface Area"]

    @fin_surface_area.setter
    def fin_surface_area(self, value="autosize"):
        """Corresponds to IDD field `Fin Surface Area`

        Args:
            value (float or "Autosize"): value for IDD Field `Fin Surface Area`
                Units: m2
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Fin Surface Area"] = value

    @property
    def minimum_airflow_area(self):
        """Get minimum_airflow_area.

        Returns:
            float: the value of `minimum_airflow_area` or None if not set

        """
        return self["Minimum Airflow Area"]

    @minimum_airflow_area.setter
    def minimum_airflow_area(self, value="autosize"):
        """Corresponds to IDD field `Minimum Airflow Area`

        Args:
            value (float or "Autosize"): value for IDD Field `Minimum Airflow Area`
                Units: m2
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Minimum Airflow Area"] = value

    @property
    def coil_depth(self):
        """Get coil_depth.

        Returns:
            float: the value of `coil_depth` or None if not set

        """
        return self["Coil Depth"]

    @coil_depth.setter
    def coil_depth(self, value="autosize"):
        """Corresponds to IDD field `Coil Depth`

        Args:
            value (float or "Autosize"): value for IDD Field `Coil Depth`
                Units: m
                IP-Units: in
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Coil Depth"] = value

    @property
    def fin_diameter(self):
        """Get fin_diameter.

        Returns:
            float: the value of `fin_diameter` or None if not set

        """
        return self["Fin Diameter"]

    @fin_diameter.setter
    def fin_diameter(self, value="autosize"):
        """Corresponds to IDD field `Fin Diameter` Fin diameter or the coil
        height.

        Args:
            value (float or "Autosize"): value for IDD Field `Fin Diameter`
                Units: m
                IP-Units: in
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Fin Diameter"] = value

    @property
    def fin_thickness(self):
        """Get fin_thickness.

        Returns:
            float: the value of `fin_thickness` or None if not set

        """
        return self["Fin Thickness"]

    @fin_thickness.setter
    def fin_thickness(self, value=0.0015):
        """Corresponds to IDD field `Fin Thickness`

        Args:
            value (float): value for IDD Field `Fin Thickness`
                Units: m
                IP-Units: in
                Default value: 0.0015
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Fin Thickness"] = value

    @property
    def tube_inside_diameter(self):
        """Get tube_inside_diameter.

        Returns:
            float: the value of `tube_inside_diameter` or None if not set

        """
        return self["Tube Inside Diameter"]

    @tube_inside_diameter.setter
    def tube_inside_diameter(self, value=0.01445):
        """Corresponds to IDD field `Tube Inside Diameter` Inner diameter of
        tubes.

        Args:
            value (float): value for IDD Field `Tube Inside Diameter`
                Units: m
                IP-Units: in
                Default value: 0.01445
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Tube Inside Diameter"] = value

    @property
    def tube_outside_diameter(self):
        """Get tube_outside_diameter.

        Returns:
            float: the value of `tube_outside_diameter` or None if not set

        """
        return self["Tube Outside Diameter"]

    @tube_outside_diameter.setter
    def tube_outside_diameter(self, value=0.0159):
        """Corresponds to IDD field `Tube Outside Diameter` Outer diameter of
        tubes.

        Args:
            value (float): value for IDD Field `Tube Outside Diameter`
                Units: m
                IP-Units: in
                Default value: 0.0159
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Tube Outside Diameter"] = value

    @property
    def tube_thermal_conductivity(self):
        """Get tube_thermal_conductivity.

        Returns:
            float: the value of `tube_thermal_conductivity` or None if not set

        """
        return self["Tube Thermal Conductivity"]

    @tube_thermal_conductivity.setter
    def tube_thermal_conductivity(self, value=386.0):
        """Corresponds to IDD field `Tube Thermal Conductivity`

        Args:
            value (float): value for IDD Field `Tube Thermal Conductivity`
                Units: W/m-K
                Default value: 386.0
                value >= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Tube Thermal Conductivity"] = value

    @property
    def fin_thermal_conductivity(self):
        """Get fin_thermal_conductivity.

        Returns:
            float: the value of `fin_thermal_conductivity` or None if not set

        """
        return self["Fin Thermal Conductivity"]

    @fin_thermal_conductivity.setter
    def fin_thermal_conductivity(self, value=204.0):
        """Corresponds to IDD field `Fin Thermal Conductivity`

        Args:
            value (float): value for IDD Field `Fin Thermal Conductivity`
                Units: W/m-K
                Default value: 204.0
                value >= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Fin Thermal Conductivity"] = value

    @property
    def fin_spacing(self):
        """Get fin_spacing.

        Returns:
            float: the value of `fin_spacing` or None if not set

        """
        return self["Fin Spacing"]

    @fin_spacing.setter
    def fin_spacing(self, value=0.0018):
        """Corresponds to IDD field `Fin Spacing` Fin spacing or distance.

        Args:
            value (float): value for IDD Field `Fin Spacing`
                Units: m
                IP-Units: in
                Default value: 0.0018
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Fin Spacing"] = value

    @property
    def tube_depth_spacing(self):
        """Get tube_depth_spacing.

        Returns:
            float: the value of `tube_depth_spacing` or None if not set

        """
        return self["Tube Depth Spacing"]

    @tube_depth_spacing.setter
    def tube_depth_spacing(self, value=0.026):
        """Corresponds to IDD field `Tube Depth Spacing`

        Args:
            value (float): value for IDD Field `Tube Depth Spacing`
                Units: m
                IP-Units: in
                Default value: 0.026
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Tube Depth Spacing"] = value

    @property
    def number_of_tube_rows(self):
        """Get number_of_tube_rows.

        Returns:
            float: the value of `number_of_tube_rows` or None if not set

        """
        return self["Number of Tube Rows"]

    @number_of_tube_rows.setter
    def number_of_tube_rows(self, value=4.0):
        """Corresponds to IDD field `Number of Tube Rows`

        Args:
            value (float): value for IDD Field `Number of Tube Rows`
                Default value: 4.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Number of Tube Rows"] = value

    @property
    def number_of_tubes_per_row(self):
        """Get number_of_tubes_per_row.

        Returns:
            float: the value of `number_of_tubes_per_row` or None if not set

        """
        return self["Number of Tubes per Row"]

    @number_of_tubes_per_row.setter
    def number_of_tubes_per_row(self, value="autosize"):
        """Corresponds to IDD field `Number of Tubes per Row`

        Args:
            value (float or "Autosize"): value for IDD Field `Number of Tubes per Row`
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Number of Tubes per Row"] = value

    @property
    def water_inlet_node_name(self):
        """Get water_inlet_node_name.

        Returns:
            str: the value of `water_inlet_node_name` or None if not set

        """
        return self["Water Inlet Node Name"]

    @water_inlet_node_name.setter
    def water_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Water Inlet Node Name`

        Args:
            value (str): value for IDD Field `Water Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Water Inlet Node Name"] = value

    @property
    def water_outlet_node_name(self):
        """Get water_outlet_node_name.

        Returns:
            str: the value of `water_outlet_node_name` or None if not set

        """
        return self["Water Outlet Node Name"]

    @water_outlet_node_name.setter
    def water_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Water Outlet Node Name`

        Args:
            value (str): value for IDD Field `Water Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Water Outlet Node Name"] = value

    @property
    def air_inlet_node_name(self):
        """Get air_inlet_node_name.

        Returns:
            str: the value of `air_inlet_node_name` or None if not set

        """
        return self["Air Inlet Node Name"]

    @air_inlet_node_name.setter
    def air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Inlet Node Name"] = value

    @property
    def air_outlet_node_name(self):
        """Get air_outlet_node_name.

        Returns:
            str: the value of `air_outlet_node_name` or None if not set

        """
        return self["Air Outlet Node Name"]

    @air_outlet_node_name.setter
    def air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Outlet Node Name"] = value

    @property
    def condensate_collection_water_storage_tank_name(self):
        """Get condensate_collection_water_storage_tank_name.

        Returns:
            str: the value of `condensate_collection_water_storage_tank_name` or None if not set

        """
        return self["Condensate Collection Water Storage Tank Name"]

    @condensate_collection_water_storage_tank_name.setter
    def condensate_collection_water_storage_tank_name(self, value=None):
        """Corresponds to IDD field `Condensate Collection Water Storage Tank
        Name`

        Args:
            value (str): value for IDD Field `Condensate Collection Water Storage Tank Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Condensate Collection Water Storage Tank Name"] = value




class CoilCoolingDxSingleSpeed(DataObject):

    """ Corresponds to IDD object `Coil:Cooling:DX:SingleSpeed`
        Direct expansion (DX) cooling coil and condensing unit (includes electric compressor
        and condenser fan), single-speed. Optional inputs for moisture evaporation from wet
        coil when compressor cycles off with continuous fan operation.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'gross rated total cooling capacity',
                                      {'name': u'Gross Rated Total Cooling Capacity',
                                       'pyname': u'gross_rated_total_cooling_capacity',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'gross rated sensible heat ratio',
                                      {'name': u'Gross Rated Sensible Heat Ratio',
                                       'pyname': u'gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'minimum': 0.5,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'gross rated cooling cop',
                                      {'name': u'Gross Rated Cooling COP',
                                       'pyname': u'gross_rated_cooling_cop',
                                       'default': 3.0,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'rated air flow rate',
                                      {'name': u'Rated Air Flow Rate',
                                       'pyname': u'rated_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'rated evaporator fan power per volume flow rate',
                                      {'name': u'Rated Evaporator Fan Power Per Volume Flow Rate',
                                       'pyname': u'rated_evaporator_fan_power_per_volume_flow_rate',
                                       'default': 773.3,
                                       'maximum': 1250.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/(m3/s)'}),
                                     (u'air inlet node name',
                                      {'name': u'Air Inlet Node Name',
                                       'pyname': u'air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air outlet node name',
                                      {'name': u'Air Outlet Node Name',
                                       'pyname': u'air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'total cooling capacity function of temperature curve name',
                                      {'name': u'Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'total cooling capacity function of flow fraction curve name',
                                      {'name': u'Total Cooling Capacity Function of Flow Fraction Curve Name',
                                       'pyname': u'total_cooling_capacity_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'energy input ratio function of temperature curve name',
                                      {'name': u'Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'energy input ratio function of flow fraction curve name',
                                      {'name': u'Energy Input Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'energy_input_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'part load fraction correlation curve name',
                                      {'name': u'Part Load Fraction Correlation Curve Name',
                                       'pyname': u'part_load_fraction_correlation_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'nominal time for condensate removal to begin',
                                      {'name': u'Nominal Time for Condensate Removal to Begin',
                                       'pyname': u'nominal_time_for_condensate_removal_to_begin',
                                       'default': 0.0,
                                       'maximum': 3000.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u's'}),
                                     (u'ratio of initial moisture evaporation rate and steady state latent capacity',
                                      {'name': u'Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity',
                                       'pyname': u'ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity',
                                       'default': 0.0,
                                       'maximum': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'maximum cycling rate',
                                      {'name': u'Maximum Cycling Rate',
                                       'pyname': u'maximum_cycling_rate',
                                       'default': 0.0,
                                       'maximum': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'cycles/hr'}),
                                     (u'latent capacity time constant',
                                      {'name': u'Latent Capacity Time Constant',
                                       'pyname': u'latent_capacity_time_constant',
                                       'default': 0.0,
                                       'maximum': 500.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u's'}),
                                     (u'condenser air inlet node name',
                                      {'name': u'Condenser Air Inlet Node Name',
                                       'pyname': u'condenser_air_inlet_node_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'condenser type',
                                      {'name': u'Condenser Type',
                                       'pyname': u'condenser_type',
                                       'default': u'AirCooled',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'AirCooled',
                                                           u'EvaporativelyCooled'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'evaporative condenser effectiveness',
                                      {'name': u'Evaporative Condenser Effectiveness',
                                       'pyname': u'evaporative_condenser_effectiveness',
                                       'default': 0.9,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'evaporative condenser air flow rate',
                                      {'name': u'Evaporative Condenser Air Flow Rate',
                                       'pyname': u'evaporative_condenser_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'evaporative condenser pump rated power consumption',
                                      {'name': u'Evaporative Condenser Pump Rated Power Consumption',
                                       'pyname': u'evaporative_condenser_pump_rated_power_consumption',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'crankcase heater capacity',
                                      {'name': u'Crankcase Heater Capacity',
                                       'pyname': u'crankcase_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'maximum outdoor dry-bulb temperature for crankcase heater operation',
                                      {'name': u'Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation',
                                       'pyname': u'maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation',
                                       'default': 10.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'supply water storage tank name',
                                      {'name': u'Supply Water Storage Tank Name',
                                       'pyname': u'supply_water_storage_tank_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'condensate collection water storage tank name',
                                      {'name': u'Condensate Collection Water Storage Tank Name',
                                       'pyname': u'condensate_collection_water_storage_tank_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'basin heater capacity',
                                      {'name': u'Basin Heater Capacity',
                                       'pyname': u'basin_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/K'}),
                                     (u'basin heater setpoint temperature',
                                      {'name': u'Basin Heater Setpoint Temperature',
                                       'pyname': u'basin_heater_setpoint_temperature',
                                       'default': 2.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 2.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'basin heater operating schedule name',
                                      {'name': u'Basin Heater Operating Schedule Name',
                                       'pyname': u'basin_heater_operating_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'sensible heat ratio function of temperature curve name',
                                      {'name': u'Sensible Heat Ratio Function of Temperature Curve Name',
                                       'pyname': u'sensible_heat_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'sensible heat ratio function of flow fraction curve name',
                                      {'name': u'Sensible Heat Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'sensible_heat_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 14,
              'name': u'Coil:Cooling:DX:SingleSpeed',
              'pyname': u'CoilCoolingDxSingleSpeed',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def gross_rated_total_cooling_capacity(self):
        """Get gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `gross_rated_total_cooling_capacity` or None if not set

        """
        return self["Gross Rated Total Cooling Capacity"]

    @gross_rated_total_cooling_capacity.setter
    def gross_rated_total_cooling_capacity(self, value=None):
        """  Corresponds to IDD field `Gross Rated Total Cooling Capacity`
        Total cooling capacity not accounting for the effect of supply air fan heat
        gross capacity excluding supply air fan heat
        rating point: air entering the cooling coil at 26.7 C dry-bulb/19.4 C wet-bulb, and
        air entering the outdoor condenser coil at 35 C dry-bulb/23.9 C wet-bulb

        Args:
            value (float or "Autosize"): value for IDD Field `Gross Rated Total Cooling Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Gross Rated Total Cooling Capacity"] = value

    @property
    def gross_rated_sensible_heat_ratio(self):
        """Get gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Gross Rated Sensible Heat Ratio"]

    @gross_rated_sensible_heat_ratio.setter
    def gross_rated_sensible_heat_ratio(self, value=None):
        """Corresponds to IDD field `Gross Rated Sensible Heat Ratio` Rated
        sensible heat ratio (gross sensible capacity/gross total capacity)
        sensible and total capacities do not include supply fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Gross Rated Sensible Heat Ratio`
                value >= 0.5
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gross Rated Sensible Heat Ratio"] = value

    @property
    def gross_rated_cooling_cop(self):
        """Get gross_rated_cooling_cop.

        Returns:
            float: the value of `gross_rated_cooling_cop` or None if not set

        """
        return self["Gross Rated Cooling COP"]

    @gross_rated_cooling_cop.setter
    def gross_rated_cooling_cop(self, value=3.0):
        """Corresponds to IDD field `Gross Rated Cooling COP` Gross cooling
        capacity divided by power input to the compressor and outdoor fan, does
        not include supply fan heat or supply fan electrical energy input.

        Args:
            value (float): value for IDD Field `Gross Rated Cooling COP`
                Units: W/W
                Default value: 3.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gross Rated Cooling COP"] = value

    @property
    def rated_air_flow_rate(self):
        """Get rated_air_flow_rate.

        Returns:
            float: the value of `rated_air_flow_rate` or None if not set

        """
        return self["Rated Air Flow Rate"]

    @rated_air_flow_rate.setter
    def rated_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Rated Air Flow Rate`
        Flow rate corresponding to rated total cooling capacity, Rated SHR and Rated COP
        should be between 0.00004027 m3/s and .00006041 m3/s per watt of rated total cooling capacity

        Args:
            value (float or "Autosize"): value for IDD Field `Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Rated Air Flow Rate"] = value

    @property
    def rated_evaporator_fan_power_per_volume_flow_rate(self):
        """Get rated_evaporator_fan_power_per_volume_flow_rate.

        Returns:
            float: the value of `rated_evaporator_fan_power_per_volume_flow_rate` or None if not set

        """
        return self["Rated Evaporator Fan Power Per Volume Flow Rate"]

    @rated_evaporator_fan_power_per_volume_flow_rate.setter
    def rated_evaporator_fan_power_per_volume_flow_rate(self, value=773.3):
        """Corresponds to IDD field `Rated Evaporator Fan Power Per Volume Flow
        Rate` Enter the evaporator fan power per air volume flow rate at the
        rated test conditions. The test conditions vary external static
        pressure based on total cooling capacity. This value is only used to
        calculate Seasonal Energy Efficiency Ratio (SEER), Energy Efficiency
        Ratio (EER), Integrated Energy Efficiency Ratio (IEER), and the
        Standard Rating (Net) Cooling Capacity which will be outputs in the
        EnergyPlus eio file.  This value is not used for modeling the
        evaporator fan during simulations.

        Args:
            value (float): value for IDD Field `Rated Evaporator Fan Power Per Volume Flow Rate`
                Units: W/(m3/s)
                Default value: 773.3
                value <= 1250.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Rated Evaporator Fan Power Per Volume Flow Rate"] = value

    @property
    def air_inlet_node_name(self):
        """Get air_inlet_node_name.

        Returns:
            str: the value of `air_inlet_node_name` or None if not set

        """
        return self["Air Inlet Node Name"]

    @air_inlet_node_name.setter
    def air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Inlet Node Name"] = value

    @property
    def air_outlet_node_name(self):
        """Get air_outlet_node_name.

        Returns:
            str: the value of `air_outlet_node_name` or None if not set

        """
        return self["Air Outlet Node Name"]

    @air_outlet_node_name.setter
    def air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Outlet Node Name"] = value

    @property
    def total_cooling_capacity_function_of_temperature_curve_name(self):
        """Get total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Total Cooling Capacity Function of Temperature Curve Name"]

    @total_cooling_capacity_function_of_temperature_curve_name.setter
    def total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be used
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def total_cooling_capacity_function_of_flow_fraction_curve_name(self):
        """Get total_cooling_capacity_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `total_cooling_capacity_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Total Cooling Capacity Function of Flow Fraction Curve Name"]

    @total_cooling_capacity_function_of_flow_fraction_curve_name.setter
    def total_cooling_capacity_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Total Cooling Capacity Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = Fraction of the full load flow

        Args:
            value (str): value for IDD Field `Total Cooling Capacity Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Total Cooling Capacity Function of Flow Fraction Curve Name"] = value

    @property
    def energy_input_ratio_function_of_temperature_curve_name(self):
        """Get energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self["Energy Input Ratio Function of Temperature Curve Name"]

    @energy_input_ratio_function_of_temperature_curve_name.setter
    def energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be sued
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def energy_input_ratio_function_of_flow_fraction_curve_name(self):
        """Get energy_input_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `energy_input_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self["Energy Input Ratio Function of Flow Fraction Curve Name"]

    @energy_input_ratio_function_of_flow_fraction_curve_name.setter
    def energy_input_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Energy Input Ratio Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = Fraction of the full load flow

        Args:
            value (str): value for IDD Field `Energy Input Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Energy Input Ratio Function of Flow Fraction Curve Name"] = value

    @property
    def part_load_fraction_correlation_curve_name(self):
        """Get part_load_fraction_correlation_curve_name.

        Returns:
            str: the value of `part_load_fraction_correlation_curve_name` or None if not set

        """
        return self["Part Load Fraction Correlation Curve Name"]

    @part_load_fraction_correlation_curve_name.setter
    def part_load_fraction_correlation_curve_name(self, value=None):
        """  Corresponds to IDD field `Part Load Fraction Correlation Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*PLR + c*PLR**2
        cubic curve = a + b*PLR + c*PLR**2 + d*PLR**3
        PLR = part load ratio (cooling load/steady state capacity)

        Args:
            value (str): value for IDD Field `Part Load Fraction Correlation Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Part Load Fraction Correlation Curve Name"] = value

    @property
    def nominal_time_for_condensate_removal_to_begin(self):
        """Get nominal_time_for_condensate_removal_to_begin.

        Returns:
            float: the value of `nominal_time_for_condensate_removal_to_begin` or None if not set

        """
        return self["Nominal Time for Condensate Removal to Begin"]

    @nominal_time_for_condensate_removal_to_begin.setter
    def nominal_time_for_condensate_removal_to_begin(self, value=None):
        """Corresponds to IDD field `Nominal Time for Condensate Removal to
        Begin` The nominal time for condensate to begin leaving the coil's
        condensate drain line at the coil's rated air flow rate and temperature
        conditions. Nominal time is equal to the ratio of the energy of the
        coil's maximum condensate holding capacity (J) to the coil's steady
        state latent capacity (W). Suggested value is 1000; zero value means
        latent degradation model is disabled.

        Args:
            value (float): value for IDD Field `Nominal Time for Condensate Removal to Begin`
                Units: s
                value <= 3000.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Nominal Time for Condensate Removal to Begin"] = value

    @property
    def ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity(
            self):
        """Get ratio_of_initial_moisture_evaporation_rate_and_steady_state_late
        nt_capacity.

        Returns:
            float: the value of `ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity` or None if not set

        """
        return self[
            "Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity"]

    @ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity.setter
    def ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity(
            self,
            value=None):
        """  Corresponds to IDD field `Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity`
        Ratio of the initial moisture evaporation rate from the cooling coil (when
        the compressor first turns off) and the coil's steady state latent capacity
        at rated air flow rate and temperature conditions. Suggested value is 1.5; zero value
        means latent degradation model is disabled.

        Args:
            value (float): value for IDD Field `Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity`
                Units: dimensionless
                value <= 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity"] = value

    @property
    def maximum_cycling_rate(self):
        """Get maximum_cycling_rate.

        Returns:
            float: the value of `maximum_cycling_rate` or None if not set

        """
        return self["Maximum Cycling Rate"]

    @maximum_cycling_rate.setter
    def maximum_cycling_rate(self, value=None):
        """  Corresponds to IDD field `Maximum Cycling Rate`
        The maximum on-off cycling Rate for the compressor, which occurs at 50% run time
        fraction. Suggested value is 3; zero value means latent degradation model is disabled.

        Args:
            value (float): value for IDD Field `Maximum Cycling Rate`
                Units: cycles/hr
                value <= 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Maximum Cycling Rate"] = value

    @property
    def latent_capacity_time_constant(self):
        """Get latent_capacity_time_constant.

        Returns:
            float: the value of `latent_capacity_time_constant` or None if not set

        """
        return self["Latent Capacity Time Constant"]

    @latent_capacity_time_constant.setter
    def latent_capacity_time_constant(self, value=None):
        """Corresponds to IDD field `Latent Capacity Time Constant` Time
        constant for the cooling coil's latent capacity to reach steady state
        after startup. Suggested value is 45; zero value means latent
        degradation model is disabled.

        Args:
            value (float): value for IDD Field `Latent Capacity Time Constant`
                Units: s
                value <= 500.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Latent Capacity Time Constant"] = value

    @property
    def condenser_air_inlet_node_name(self):
        """Get condenser_air_inlet_node_name.

        Returns:
            str: the value of `condenser_air_inlet_node_name` or None if not set

        """
        return self["Condenser Air Inlet Node Name"]

    @condenser_air_inlet_node_name.setter
    def condenser_air_inlet_node_name(self, value=None):
        """  Corresponds to IDD field `Condenser Air Inlet Node Name`
        Enter the name of an outdoor air node. This node name is also specified in
        an OutdoorAir:Node or OutdoorAir:NodeList object.

        Args:
            value (str): value for IDD Field `Condenser Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Condenser Air Inlet Node Name"] = value

    @property
    def condenser_type(self):
        """Get condenser_type.

        Returns:
            str: the value of `condenser_type` or None if not set

        """
        return self["Condenser Type"]

    @condenser_type.setter
    def condenser_type(self, value="AirCooled"):
        """Corresponds to IDD field `Condenser Type`

        Args:
            value (str): value for IDD Field `Condenser Type`
                Default value: AirCooled
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Condenser Type"] = value

    @property
    def evaporative_condenser_effectiveness(self):
        """Get evaporative_condenser_effectiveness.

        Returns:
            float: the value of `evaporative_condenser_effectiveness` or None if not set

        """
        return self["Evaporative Condenser Effectiveness"]

    @evaporative_condenser_effectiveness.setter
    def evaporative_condenser_effectiveness(self, value=0.9):
        """Corresponds to IDD field `Evaporative Condenser Effectiveness`

        Args:
            value (float): value for IDD Field `Evaporative Condenser Effectiveness`
                Units: dimensionless
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Evaporative Condenser Effectiveness"] = value

    @property
    def evaporative_condenser_air_flow_rate(self):
        """Get evaporative_condenser_air_flow_rate.

        Returns:
            float: the value of `evaporative_condenser_air_flow_rate` or None if not set

        """
        return self["Evaporative Condenser Air Flow Rate"]

    @evaporative_condenser_air_flow_rate.setter
    def evaporative_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Evaporative Condenser Air Flow Rate` Used
        to calculate evaporative condenser water use.

        Args:
            value (float or "Autosize"): value for IDD Field `Evaporative Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Evaporative Condenser Air Flow Rate"] = value

    @property
    def evaporative_condenser_pump_rated_power_consumption(self):
        """Get evaporative_condenser_pump_rated_power_consumption.

        Returns:
            float: the value of `evaporative_condenser_pump_rated_power_consumption` or None if not set

        """
        return self["Evaporative Condenser Pump Rated Power Consumption"]

    @evaporative_condenser_pump_rated_power_consumption.setter
    def evaporative_condenser_pump_rated_power_consumption(self, value=None):
        """Corresponds to IDD field `Evaporative Condenser Pump Rated Power
        Consumption` Rated power consumed by the evaporative condenser's water
        pump.

        Args:
            value (float or "Autosize"): value for IDD Field `Evaporative Condenser Pump Rated Power Consumption`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Evaporative Condenser Pump Rated Power Consumption"] = value

    @property
    def crankcase_heater_capacity(self):
        """Get crankcase_heater_capacity.

        Returns:
            float: the value of `crankcase_heater_capacity` or None if not set

        """
        return self["Crankcase Heater Capacity"]

    @crankcase_heater_capacity.setter
    def crankcase_heater_capacity(self, value=None):
        """Corresponds to IDD field `Crankcase Heater Capacity`

        Args:
            value (float): value for IDD Field `Crankcase Heater Capacity`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Crankcase Heater Capacity"] = value

    @property
    def maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation(
            self):
        """Get
        maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation.

        Returns:
            float: the value of `maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation` or None if not set

        """
        return self[
            "Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation"]

    @maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation.setter
    def maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation(
            self,
            value=10.0):
        """  Corresponds to IDD field `Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation`

        Args:
            value (float): value for IDD Field `Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation`
                Units: C
                Default value: 10.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation"] = value

    @property
    def supply_water_storage_tank_name(self):
        """Get supply_water_storage_tank_name.

        Returns:
            str: the value of `supply_water_storage_tank_name` or None if not set

        """
        return self["Supply Water Storage Tank Name"]

    @supply_water_storage_tank_name.setter
    def supply_water_storage_tank_name(self, value=None):
        """Corresponds to IDD field `Supply Water Storage Tank Name`

        Args:
            value (str): value for IDD Field `Supply Water Storage Tank Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Water Storage Tank Name"] = value

    @property
    def condensate_collection_water_storage_tank_name(self):
        """Get condensate_collection_water_storage_tank_name.

        Returns:
            str: the value of `condensate_collection_water_storage_tank_name` or None if not set

        """
        return self["Condensate Collection Water Storage Tank Name"]

    @condensate_collection_water_storage_tank_name.setter
    def condensate_collection_water_storage_tank_name(self, value=None):
        """Corresponds to IDD field `Condensate Collection Water Storage Tank
        Name`

        Args:
            value (str): value for IDD Field `Condensate Collection Water Storage Tank Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Condensate Collection Water Storage Tank Name"] = value

    @property
    def basin_heater_capacity(self):
        """Get basin_heater_capacity.

        Returns:
            float: the value of `basin_heater_capacity` or None if not set

        """
        return self["Basin Heater Capacity"]

    @basin_heater_capacity.setter
    def basin_heater_capacity(self, value=None):
        """  Corresponds to IDD field `Basin Heater Capacity`
        This field is only used for Condenser Type = EvaporativelyCooled and for periods
        when the basin heater is available (field Basin Heater Operating Schedule Name).
        For this situation, the heater maintains the basin water temperature at the basin heater
        setpoint temperature when the outdoor air temperature falls below the setpoint temperature.
        The basin heater only operates when the DX coil is off.

        Args:
            value (float): value for IDD Field `Basin Heater Capacity`
                Units: W/K
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Capacity"] = value

    @property
    def basin_heater_setpoint_temperature(self):
        """Get basin_heater_setpoint_temperature.

        Returns:
            float: the value of `basin_heater_setpoint_temperature` or None if not set

        """
        return self["Basin Heater Setpoint Temperature"]

    @basin_heater_setpoint_temperature.setter
    def basin_heater_setpoint_temperature(self, value=2.0):
        """  Corresponds to IDD field `Basin Heater Setpoint Temperature`
        This field is only used for Condenser Type = EvaporativelyCooled.
        Enter the outdoor dry-bulb temperature when the basin heater turns on.

        Args:
            value (float): value for IDD Field `Basin Heater Setpoint Temperature`
                Units: C
                Default value: 2.0
                value >= 2.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Setpoint Temperature"] = value

    @property
    def basin_heater_operating_schedule_name(self):
        """Get basin_heater_operating_schedule_name.

        Returns:
            str: the value of `basin_heater_operating_schedule_name` or None if not set

        """
        return self["Basin Heater Operating Schedule Name"]

    @basin_heater_operating_schedule_name.setter
    def basin_heater_operating_schedule_name(self, value=None):
        """  Corresponds to IDD field `Basin Heater Operating Schedule Name`
        This field is only used for Condenser Type = EvaporativelyCooled.
        Schedule values greater than 0 allow the basin heater to operate whenever the outdoor
        air dry-bulb temperature is below the basin heater setpoint temperature.
        If a schedule name is not entered, the basin heater is allowed to operate
        throughout the entire simulation.

        Args:
            value (str): value for IDD Field `Basin Heater Operating Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Operating Schedule Name"] = value

    @property
    def sensible_heat_ratio_function_of_temperature_curve_name(self):
        """Get sensible_heat_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `sensible_heat_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self["Sensible Heat Ratio Function of Temperature Curve Name"]

    @sensible_heat_ratio_function_of_temperature_curve_name.setter
    def sensible_heat_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Sensible Heat Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be used
        curve = a + b*wb + c*wb**2 + d*db + e*db**2 + f*wb*db
        wb = entering wet-bulb temperature seen by the DX cooling coil (C)
        db = entering dry-bulb temperature seen by the DX cooling coil (C)
        entering temperature can be outside air or pretreated air.

        Args:
            value (str): value for IDD Field `Sensible Heat Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Sensible Heat Ratio Function of Temperature Curve Name"] = value

    @property
    def sensible_heat_ratio_function_of_flow_fraction_curve_name(self):
        """Get sensible_heat_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `sensible_heat_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self["Sensible Heat Ratio Function of Flow Fraction Curve Name"]

    @sensible_heat_ratio_function_of_flow_fraction_curve_name.setter
    def sensible_heat_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Sensible Heat Ratio Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Sensible Heat Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Sensible Heat Ratio Function of Flow Fraction Curve Name"] = value




class CoilCoolingDxTwoSpeed(DataObject):

    """ Corresponds to IDD object `Coil:Cooling:DX:TwoSpeed`
        Direct expansion (DX) cooling coil and condensing unit (includes electric compressor
        and condenser fan), two-speed (or variable-speed). Requires two sets of performance
        data and will interpolate between speeds. Modelled as a single coil (multi-speed
        compressor or multiple compressors with row split or intertwined coil).
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'high speed gross rated total cooling capacity',
                                      {'name': u'High Speed Gross Rated Total Cooling Capacity',
                                       'pyname': u'high_speed_gross_rated_total_cooling_capacity',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'high speed rated sensible heat ratio',
                                      {'name': u'High Speed Rated Sensible Heat Ratio',
                                       'pyname': u'high_speed_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'minimum': 0.5,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'high speed gross rated cooling cop',
                                      {'name': u'High Speed Gross Rated Cooling COP',
                                       'pyname': u'high_speed_gross_rated_cooling_cop',
                                       'default': 3.0,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'high speed rated air flow rate',
                                      {'name': u'High Speed Rated Air Flow Rate',
                                       'pyname': u'high_speed_rated_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'unit internal static air pressure',
                                      {'name': u'Unit Internal Static Air Pressure',
                                       'pyname': u'unit_internal_static_air_pressure',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'Pa'}),
                                     (u'air inlet node name',
                                      {'name': u'Air Inlet Node Name',
                                       'pyname': u'air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air outlet node name',
                                      {'name': u'Air Outlet Node Name',
                                       'pyname': u'air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'total cooling capacity function of temperature curve name',
                                      {'name': u'Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'total cooling capacity function of flow fraction curve name',
                                      {'name': u'Total Cooling Capacity Function of Flow Fraction Curve Name',
                                       'pyname': u'total_cooling_capacity_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'energy input ratio function of temperature curve name',
                                      {'name': u'Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'energy input ratio function of flow fraction curve name',
                                      {'name': u'Energy Input Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'energy_input_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'part load fraction correlation curve name',
                                      {'name': u'Part Load Fraction Correlation Curve Name',
                                       'pyname': u'part_load_fraction_correlation_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'low speed gross rated total cooling capacity',
                                      {'name': u'Low Speed Gross Rated Total Cooling Capacity',
                                       'pyname': u'low_speed_gross_rated_total_cooling_capacity',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'low speed gross rated sensible heat ratio',
                                      {'name': u'Low Speed Gross Rated Sensible Heat Ratio',
                                       'pyname': u'low_speed_gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'minimum': 0.5,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'low speed gross rated cooling cop',
                                      {'name': u'Low Speed Gross Rated Cooling COP',
                                       'pyname': u'low_speed_gross_rated_cooling_cop',
                                       'default': 3.0,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'low speed rated air flow rate',
                                      {'name': u'Low Speed Rated Air Flow Rate',
                                       'pyname': u'low_speed_rated_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'low speed total cooling capacity function of temperature curve name',
                                      {'name': u'Low Speed Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'low_speed_total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'low speed energy input ratio function of temperature curve name',
                                      {'name': u'Low Speed Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'low_speed_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'condenser air inlet node name',
                                      {'name': u'Condenser Air Inlet Node Name',
                                       'pyname': u'condenser_air_inlet_node_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'condenser type',
                                      {'name': u'Condenser Type',
                                       'pyname': u'condenser_type',
                                       'default': u'AirCooled',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'AirCooled',
                                                           u'EvaporativelyCooled'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'high speed evaporative condenser effectiveness',
                                      {'name': u'High Speed Evaporative Condenser Effectiveness',
                                       'pyname': u'high_speed_evaporative_condenser_effectiveness',
                                       'default': 0.9,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'high speed evaporative condenser air flow rate',
                                      {'name': u'High Speed Evaporative Condenser Air Flow Rate',
                                       'pyname': u'high_speed_evaporative_condenser_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'high speed evaporative condenser pump rated power consumption',
                                      {'name': u'High Speed Evaporative Condenser Pump Rated Power Consumption',
                                       'pyname': u'high_speed_evaporative_condenser_pump_rated_power_consumption',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'low speed evaporative condenser effectiveness',
                                      {'name': u'Low Speed Evaporative Condenser Effectiveness',
                                       'pyname': u'low_speed_evaporative_condenser_effectiveness',
                                       'default': 0.9,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'low speed evaporative condenser air flow rate',
                                      {'name': u'Low Speed Evaporative Condenser Air Flow Rate',
                                       'pyname': u'low_speed_evaporative_condenser_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'low speed evaporative condenser pump rated power consumption',
                                      {'name': u'Low Speed Evaporative Condenser Pump Rated Power Consumption',
                                       'pyname': u'low_speed_evaporative_condenser_pump_rated_power_consumption',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'supply water storage tank name',
                                      {'name': u'Supply Water Storage Tank Name',
                                       'pyname': u'supply_water_storage_tank_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'condensate collection water storage tank name',
                                      {'name': u'Condensate Collection Water Storage Tank Name',
                                       'pyname': u'condensate_collection_water_storage_tank_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'basin heater capacity',
                                      {'name': u'Basin Heater Capacity',
                                       'pyname': u'basin_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/K'}),
                                     (u'basin heater setpoint temperature',
                                      {'name': u'Basin Heater Setpoint Temperature',
                                       'pyname': u'basin_heater_setpoint_temperature',
                                       'default': 2.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 2.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'basin heater operating schedule name',
                                      {'name': u'Basin Heater Operating Schedule Name',
                                       'pyname': u'basin_heater_operating_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'sensible heat ratio function of temperature curve name',
                                      {'name': u'Sensible Heat Ratio Function of Temperature Curve Name',
                                       'pyname': u'sensible_heat_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'sensible heat ratio function of flow fraction curve name',
                                      {'name': u'Sensible Heat Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'sensible_heat_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'low speed sensible heat ratio function of temperature curve name',
                                      {'name': u'Low Speed Sensible Heat Ratio Function of Temperature Curve Name',
                                       'pyname': u'low_speed_sensible_heat_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'low speed sensible heat ratio function of flow fraction curve name',
                                      {'name': u'Low Speed Sensible Heat Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'low_speed_sensible_heat_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 19,
              'name': u'Coil:Cooling:DX:TwoSpeed',
              'pyname': u'CoilCoolingDxTwoSpeed',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def high_speed_gross_rated_total_cooling_capacity(self):
        """Get high_speed_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `high_speed_gross_rated_total_cooling_capacity` or None if not set

        """
        return self["High Speed Gross Rated Total Cooling Capacity"]

    @high_speed_gross_rated_total_cooling_capacity.setter
    def high_speed_gross_rated_total_cooling_capacity(self, value=None):
        """  Corresponds to IDD field `High Speed Gross Rated Total Cooling Capacity`
        Total cooling capacity not accounting for the effect of supply air fan heat
        gross capacity excluding supply air fan heat
        rating point: air entering the cooling coil at 26.7 C dry-bulb/19.4 C wet-bulb, and
        air entering the outdoor condenser coil at 35 C dry-bulb/23.9 C wet-bulb

        Args:
            value (float or "Autosize"): value for IDD Field `High Speed Gross Rated Total Cooling Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["High Speed Gross Rated Total Cooling Capacity"] = value

    @property
    def high_speed_rated_sensible_heat_ratio(self):
        """Get high_speed_rated_sensible_heat_ratio.

        Returns:
            float: the value of `high_speed_rated_sensible_heat_ratio` or None if not set

        """
        return self["High Speed Rated Sensible Heat Ratio"]

    @high_speed_rated_sensible_heat_ratio.setter
    def high_speed_rated_sensible_heat_ratio(self, value=None):
        """Corresponds to IDD field `High Speed Rated Sensible Heat Ratio`
        Rated sensible heat ratio (gross sensible capacity/gross total
        capacity) sensible and total capacities do not include supply fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `High Speed Rated Sensible Heat Ratio`
                value >= 0.5
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["High Speed Rated Sensible Heat Ratio"] = value

    @property
    def high_speed_gross_rated_cooling_cop(self):
        """Get high_speed_gross_rated_cooling_cop.

        Returns:
            float: the value of `high_speed_gross_rated_cooling_cop` or None if not set

        """
        return self["High Speed Gross Rated Cooling COP"]

    @high_speed_gross_rated_cooling_cop.setter
    def high_speed_gross_rated_cooling_cop(self, value=3.0):
        """Corresponds to IDD field `High Speed Gross Rated Cooling COP` Gross
        cooling capacity divided by power input to the compressor and outdoor
        fan, does not include supply fan heat or supply fan electrical energy
        input.

        Args:
            value (float): value for IDD Field `High Speed Gross Rated Cooling COP`
                Units: W/W
                Default value: 3.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["High Speed Gross Rated Cooling COP"] = value

    @property
    def high_speed_rated_air_flow_rate(self):
        """Get high_speed_rated_air_flow_rate.

        Returns:
            float: the value of `high_speed_rated_air_flow_rate` or None if not set

        """
        return self["High Speed Rated Air Flow Rate"]

    @high_speed_rated_air_flow_rate.setter
    def high_speed_rated_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `High Speed Rated Air Flow Rate`
        Flow rate corresponding to rated total cooling capacity, Rated SHR
        and Rated COP. Should be between 0.00004027 m3/s and .00006041 m3/s per watt
        of rated total cooling capacity.

        Args:
            value (float or "Autosize"): value for IDD Field `High Speed Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["High Speed Rated Air Flow Rate"] = value

    @property
    def unit_internal_static_air_pressure(self):
        """Get unit_internal_static_air_pressure.

        Returns:
            float: the value of `unit_internal_static_air_pressure` or None if not set

        """
        return self["Unit Internal Static Air Pressure"]

    @unit_internal_static_air_pressure.setter
    def unit_internal_static_air_pressure(self, value=None):
        """Corresponds to IDD field `Unit Internal Static Air Pressure` Enter
        pressure drop for the unit containing the coil. This value is only used
        to calculate Energy Efficiency Ratio (EER), Integrated Energy
        Efficiency Ratio (IEER), and the Standard Rating (Net) Cooling
        Capacity. This value is not used for modeling the evaporator fan during
        simulations.

        Args:
            value (float): value for IDD Field `Unit Internal Static Air Pressure`
                Units: Pa
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Unit Internal Static Air Pressure"] = value

    @property
    def air_inlet_node_name(self):
        """Get air_inlet_node_name.

        Returns:
            str: the value of `air_inlet_node_name` or None if not set

        """
        return self["Air Inlet Node Name"]

    @air_inlet_node_name.setter
    def air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Inlet Node Name"] = value

    @property
    def air_outlet_node_name(self):
        """Get air_outlet_node_name.

        Returns:
            str: the value of `air_outlet_node_name` or None if not set

        """
        return self["Air Outlet Node Name"]

    @air_outlet_node_name.setter
    def air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Outlet Node Name"] = value

    @property
    def total_cooling_capacity_function_of_temperature_curve_name(self):
        """Get total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Total Cooling Capacity Function of Temperature Curve Name"]

    @total_cooling_capacity_function_of_temperature_curve_name.setter
    def total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be used
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def total_cooling_capacity_function_of_flow_fraction_curve_name(self):
        """Get total_cooling_capacity_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `total_cooling_capacity_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Total Cooling Capacity Function of Flow Fraction Curve Name"]

    @total_cooling_capacity_function_of_flow_fraction_curve_name.setter
    def total_cooling_capacity_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Total Cooling Capacity Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Total Cooling Capacity Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Total Cooling Capacity Function of Flow Fraction Curve Name"] = value

    @property
    def energy_input_ratio_function_of_temperature_curve_name(self):
        """Get energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self["Energy Input Ratio Function of Temperature Curve Name"]

    @energy_input_ratio_function_of_temperature_curve_name.setter
    def energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Energy Input Ratio Function of Temperature Curve Name`
        Table:OneIndependentVariable object can also be used
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def energy_input_ratio_function_of_flow_fraction_curve_name(self):
        """Get energy_input_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `energy_input_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self["Energy Input Ratio Function of Flow Fraction Curve Name"]

    @energy_input_ratio_function_of_flow_fraction_curve_name.setter
    def energy_input_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Energy Input Ratio Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Energy Input Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Energy Input Ratio Function of Flow Fraction Curve Name"] = value

    @property
    def part_load_fraction_correlation_curve_name(self):
        """Get part_load_fraction_correlation_curve_name.

        Returns:
            str: the value of `part_load_fraction_correlation_curve_name` or None if not set

        """
        return self["Part Load Fraction Correlation Curve Name"]

    @part_load_fraction_correlation_curve_name.setter
    def part_load_fraction_correlation_curve_name(self, value=None):
        """  Corresponds to IDD field `Part Load Fraction Correlation Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*PLR + c*PLR**2
        cubic curve = a + b*PLR + c*PLR**2 + d*PLR**3
        PLR = part load ratio (cooling load/steady state capacity)

        Args:
            value (str): value for IDD Field `Part Load Fraction Correlation Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Part Load Fraction Correlation Curve Name"] = value

    @property
    def low_speed_gross_rated_total_cooling_capacity(self):
        """Get low_speed_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `low_speed_gross_rated_total_cooling_capacity` or None if not set

        """
        return self["Low Speed Gross Rated Total Cooling Capacity"]

    @low_speed_gross_rated_total_cooling_capacity.setter
    def low_speed_gross_rated_total_cooling_capacity(self, value=None):
        """  Corresponds to IDD field `Low Speed Gross Rated Total Cooling Capacity`
        Total cooling capacity not accounting for the effect of supply air fan heat
        gross capacity excluding supply air fan heat
        rating point: air entering the cooling coil at 26.7 C dry-bulb/19.4 C wet-bulb, and
        air entering the outdoor condenser coil at 35 C dry-bulb/23.9 C wet-bulb

        Args:
            value (float or "Autosize"): value for IDD Field `Low Speed Gross Rated Total Cooling Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Low Speed Gross Rated Total Cooling Capacity"] = value

    @property
    def low_speed_gross_rated_sensible_heat_ratio(self):
        """Get low_speed_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `low_speed_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Low Speed Gross Rated Sensible Heat Ratio"]

    @low_speed_gross_rated_sensible_heat_ratio.setter
    def low_speed_gross_rated_sensible_heat_ratio(self, value=None):
        """Corresponds to IDD field `Low Speed Gross Rated Sensible Heat Ratio`
        Gross Rated Sensible Heat Ratio (gross sensible capacity/gross total
        capacity) sensible and total capacities do not include supply fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Low Speed Gross Rated Sensible Heat Ratio`
                value >= 0.5
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Low Speed Gross Rated Sensible Heat Ratio"] = value

    @property
    def low_speed_gross_rated_cooling_cop(self):
        """Get low_speed_gross_rated_cooling_cop.

        Returns:
            float: the value of `low_speed_gross_rated_cooling_cop` or None if not set

        """
        return self["Low Speed Gross Rated Cooling COP"]

    @low_speed_gross_rated_cooling_cop.setter
    def low_speed_gross_rated_cooling_cop(self, value=3.0):
        """Corresponds to IDD field `Low Speed Gross Rated Cooling COP` Gross
        cooling capacity divided by power input to the compressor and outdoor
        fan, does not include supply fan heat or supply fan electrical energy
        input.

        Args:
            value (float): value for IDD Field `Low Speed Gross Rated Cooling COP`
                Units: W/W
                Default value: 3.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Low Speed Gross Rated Cooling COP"] = value

    @property
    def low_speed_rated_air_flow_rate(self):
        """Get low_speed_rated_air_flow_rate.

        Returns:
            float: the value of `low_speed_rated_air_flow_rate` or None if not set

        """
        return self["Low Speed Rated Air Flow Rate"]

    @low_speed_rated_air_flow_rate.setter
    def low_speed_rated_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Low Speed Rated Air Flow Rate`
        Flow rate corresponding to rated total cooling capacity, Rated SHR
        and Rated COP. Should be between 0.00004027 m3/s and .00006041 m3/s per watt
        of rated total cooling capacity.

        Args:
            value (float or "Autosize"): value for IDD Field `Low Speed Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Low Speed Rated Air Flow Rate"] = value

    @property
    def low_speed_total_cooling_capacity_function_of_temperature_curve_name(
            self):
        """Get
        low_speed_total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `low_speed_total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Low Speed Total Cooling Capacity Function of Temperature Curve Name"]

    @low_speed_total_cooling_capacity_function_of_temperature_curve_name.setter
    def low_speed_total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Low Speed Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be used
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Low Speed Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Low Speed Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def low_speed_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get low_speed_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `low_speed_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Low Speed Energy Input Ratio Function of Temperature Curve Name"]

    @low_speed_energy_input_ratio_function_of_temperature_curve_name.setter
    def low_speed_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Low Speed Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be used
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Low Speed Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Low Speed Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def condenser_air_inlet_node_name(self):
        """Get condenser_air_inlet_node_name.

        Returns:
            str: the value of `condenser_air_inlet_node_name` or None if not set

        """
        return self["Condenser Air Inlet Node Name"]

    @condenser_air_inlet_node_name.setter
    def condenser_air_inlet_node_name(self, value=None):
        """  Corresponds to IDD field `Condenser Air Inlet Node Name`
        Enter the name of an outdoor air node. This node name is also specified in
        an OutdoorAir:Node or OutdoorAir:NodeList object.

        Args:
            value (str): value for IDD Field `Condenser Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Condenser Air Inlet Node Name"] = value

    @property
    def condenser_type(self):
        """Get condenser_type.

        Returns:
            str: the value of `condenser_type` or None if not set

        """
        return self["Condenser Type"]

    @condenser_type.setter
    def condenser_type(self, value="AirCooled"):
        """Corresponds to IDD field `Condenser Type`

        Args:
            value (str): value for IDD Field `Condenser Type`
                Default value: AirCooled
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Condenser Type"] = value

    @property
    def high_speed_evaporative_condenser_effectiveness(self):
        """Get high_speed_evaporative_condenser_effectiveness.

        Returns:
            float: the value of `high_speed_evaporative_condenser_effectiveness` or None if not set

        """
        return self["High Speed Evaporative Condenser Effectiveness"]

    @high_speed_evaporative_condenser_effectiveness.setter
    def high_speed_evaporative_condenser_effectiveness(self, value=0.9):
        """Corresponds to IDD field `High Speed Evaporative Condenser
        Effectiveness`

        Args:
            value (float): value for IDD Field `High Speed Evaporative Condenser Effectiveness`
                Units: dimensionless
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["High Speed Evaporative Condenser Effectiveness"] = value

    @property
    def high_speed_evaporative_condenser_air_flow_rate(self):
        """Get high_speed_evaporative_condenser_air_flow_rate.

        Returns:
            float: the value of `high_speed_evaporative_condenser_air_flow_rate` or None if not set

        """
        return self["High Speed Evaporative Condenser Air Flow Rate"]

    @high_speed_evaporative_condenser_air_flow_rate.setter
    def high_speed_evaporative_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `High Speed Evaporative Condenser Air Flow
        Rate` Used to calculate evaporative condenser water use.

        Args:
            value (float or "Autosize"): value for IDD Field `High Speed Evaporative Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["High Speed Evaporative Condenser Air Flow Rate"] = value

    @property
    def high_speed_evaporative_condenser_pump_rated_power_consumption(self):
        """Get high_speed_evaporative_condenser_pump_rated_power_consumption.

        Returns:
            float: the value of `high_speed_evaporative_condenser_pump_rated_power_consumption` or None if not set

        """
        return self[
            "High Speed Evaporative Condenser Pump Rated Power Consumption"]

    @high_speed_evaporative_condenser_pump_rated_power_consumption.setter
    def high_speed_evaporative_condenser_pump_rated_power_consumption(
            self,
            value=None):
        """Corresponds to IDD field `High Speed Evaporative Condenser Pump
        Rated Power Consumption` Rated power consumed by the evaporative
        condenser's water pump at high speed.

        Args:
            value (float or "Autosize"): value for IDD Field `High Speed Evaporative Condenser Pump Rated Power Consumption`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "High Speed Evaporative Condenser Pump Rated Power Consumption"] = value

    @property
    def low_speed_evaporative_condenser_effectiveness(self):
        """Get low_speed_evaporative_condenser_effectiveness.

        Returns:
            float: the value of `low_speed_evaporative_condenser_effectiveness` or None if not set

        """
        return self["Low Speed Evaporative Condenser Effectiveness"]

    @low_speed_evaporative_condenser_effectiveness.setter
    def low_speed_evaporative_condenser_effectiveness(self, value=0.9):
        """Corresponds to IDD field `Low Speed Evaporative Condenser
        Effectiveness`

        Args:
            value (float): value for IDD Field `Low Speed Evaporative Condenser Effectiveness`
                Units: dimensionless
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Low Speed Evaporative Condenser Effectiveness"] = value

    @property
    def low_speed_evaporative_condenser_air_flow_rate(self):
        """Get low_speed_evaporative_condenser_air_flow_rate.

        Returns:
            float: the value of `low_speed_evaporative_condenser_air_flow_rate` or None if not set

        """
        return self["Low Speed Evaporative Condenser Air Flow Rate"]

    @low_speed_evaporative_condenser_air_flow_rate.setter
    def low_speed_evaporative_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Low Speed Evaporative Condenser Air Flow
        Rate` Used to calculate evaporative condenser water use.

        Args:
            value (float or "Autosize"): value for IDD Field `Low Speed Evaporative Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Low Speed Evaporative Condenser Air Flow Rate"] = value

    @property
    def low_speed_evaporative_condenser_pump_rated_power_consumption(self):
        """Get low_speed_evaporative_condenser_pump_rated_power_consumption.

        Returns:
            float: the value of `low_speed_evaporative_condenser_pump_rated_power_consumption` or None if not set

        """
        return self[
            "Low Speed Evaporative Condenser Pump Rated Power Consumption"]

    @low_speed_evaporative_condenser_pump_rated_power_consumption.setter
    def low_speed_evaporative_condenser_pump_rated_power_consumption(
            self,
            value=None):
        """Corresponds to IDD field `Low Speed Evaporative Condenser Pump Rated
        Power Consumption` Rated power consumed by the evaporative condenser's
        water pump at low speed.

        Args:
            value (float or "Autosize"): value for IDD Field `Low Speed Evaporative Condenser Pump Rated Power Consumption`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Low Speed Evaporative Condenser Pump Rated Power Consumption"] = value

    @property
    def supply_water_storage_tank_name(self):
        """Get supply_water_storage_tank_name.

        Returns:
            str: the value of `supply_water_storage_tank_name` or None if not set

        """
        return self["Supply Water Storage Tank Name"]

    @supply_water_storage_tank_name.setter
    def supply_water_storage_tank_name(self, value=None):
        """Corresponds to IDD field `Supply Water Storage Tank Name`

        Args:
            value (str): value for IDD Field `Supply Water Storage Tank Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Water Storage Tank Name"] = value

    @property
    def condensate_collection_water_storage_tank_name(self):
        """Get condensate_collection_water_storage_tank_name.

        Returns:
            str: the value of `condensate_collection_water_storage_tank_name` or None if not set

        """
        return self["Condensate Collection Water Storage Tank Name"]

    @condensate_collection_water_storage_tank_name.setter
    def condensate_collection_water_storage_tank_name(self, value=None):
        """Corresponds to IDD field `Condensate Collection Water Storage Tank
        Name`

        Args:
            value (str): value for IDD Field `Condensate Collection Water Storage Tank Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Condensate Collection Water Storage Tank Name"] = value

    @property
    def basin_heater_capacity(self):
        """Get basin_heater_capacity.

        Returns:
            float: the value of `basin_heater_capacity` or None if not set

        """
        return self["Basin Heater Capacity"]

    @basin_heater_capacity.setter
    def basin_heater_capacity(self, value=None):
        """  Corresponds to IDD field `Basin Heater Capacity`
        This field is only used for Condenser Type = EvaporativelyCooled and for periods
        when the basin heater is available (field Basin Heater Operating Schedule Name).
        For this situation, the heater maintains the basin water temperature at the basin heater
        setpoint temperature when the outdoor air temperature falls below the setpoint temperature.
        The basin heater only operates when the DX coil is off.

        Args:
            value (float): value for IDD Field `Basin Heater Capacity`
                Units: W/K
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Capacity"] = value

    @property
    def basin_heater_setpoint_temperature(self):
        """Get basin_heater_setpoint_temperature.

        Returns:
            float: the value of `basin_heater_setpoint_temperature` or None if not set

        """
        return self["Basin Heater Setpoint Temperature"]

    @basin_heater_setpoint_temperature.setter
    def basin_heater_setpoint_temperature(self, value=2.0):
        """  Corresponds to IDD field `Basin Heater Setpoint Temperature`
        This field is only used for Condenser Type = EvaporativelyCooled.
        Enter the outdoor dry-bulb temperature when the basin heater turns on.

        Args:
            value (float): value for IDD Field `Basin Heater Setpoint Temperature`
                Units: C
                Default value: 2.0
                value >= 2.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Setpoint Temperature"] = value

    @property
    def basin_heater_operating_schedule_name(self):
        """Get basin_heater_operating_schedule_name.

        Returns:
            str: the value of `basin_heater_operating_schedule_name` or None if not set

        """
        return self["Basin Heater Operating Schedule Name"]

    @basin_heater_operating_schedule_name.setter
    def basin_heater_operating_schedule_name(self, value=None):
        """  Corresponds to IDD field `Basin Heater Operating Schedule Name`
        This field is only used for Condenser Type = EvaporativelyCooled.
        Schedule values greater than 0 allow the basin heater to operate whenever the outdoor
        air dry-bulb temperature is below the basin heater setpoint temperature.
        If a schedule name is not entered, the basin heater is allowed to operate
        throughout the entire simulation.

        Args:
            value (str): value for IDD Field `Basin Heater Operating Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Operating Schedule Name"] = value

    @property
    def sensible_heat_ratio_function_of_temperature_curve_name(self):
        """Get sensible_heat_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `sensible_heat_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self["Sensible Heat Ratio Function of Temperature Curve Name"]

    @sensible_heat_ratio_function_of_temperature_curve_name.setter
    def sensible_heat_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Sensible Heat Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be used
        curve = a + b*wb + c*wb**2 + d*db + e*db**2 + f*wb*db
        wb = entering wet-bulb temperature seen by the DX cooling coil (C)
        db = entering dry-bulb temperature seen by the DX cooling coil (C)
        entering temperature can be outside air or pretreated air.

        Args:
            value (str): value for IDD Field `Sensible Heat Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Sensible Heat Ratio Function of Temperature Curve Name"] = value

    @property
    def sensible_heat_ratio_function_of_flow_fraction_curve_name(self):
        """Get sensible_heat_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `sensible_heat_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self["Sensible Heat Ratio Function of Flow Fraction Curve Name"]

    @sensible_heat_ratio_function_of_flow_fraction_curve_name.setter
    def sensible_heat_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Sensible Heat Ratio Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Sensible Heat Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Sensible Heat Ratio Function of Flow Fraction Curve Name"] = value

    @property
    def low_speed_sensible_heat_ratio_function_of_temperature_curve_name(self):
        """Get
        low_speed_sensible_heat_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `low_speed_sensible_heat_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Low Speed Sensible Heat Ratio Function of Temperature Curve Name"]

    @low_speed_sensible_heat_ratio_function_of_temperature_curve_name.setter
    def low_speed_sensible_heat_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Low Speed Sensible Heat Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be used
        curve = a + b*wb + c*wb**2 + d*db + e*db**2 + f*wb*db
        wb = entering wet-bulb temperature seen by the DX cooling coil (C)
        db = entering dry-bulb temperature seen by the DX cooling coil (C)
        entering temperature can be outside air or pretreated air.

        Args:
            value (str): value for IDD Field `Low Speed Sensible Heat Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Low Speed Sensible Heat Ratio Function of Temperature Curve Name"] = value

    @property
    def low_speed_sensible_heat_ratio_function_of_flow_fraction_curve_name(
            self):
        """Get
        low_speed_sensible_heat_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `low_speed_sensible_heat_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Low Speed Sensible Heat Ratio Function of Flow Fraction Curve Name"]

    @low_speed_sensible_heat_ratio_function_of_flow_fraction_curve_name.setter
    def low_speed_sensible_heat_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Low Speed Sensible Heat Ratio Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Low Speed Sensible Heat Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Low Speed Sensible Heat Ratio Function of Flow Fraction Curve Name"] = value




class CoilCoolingDxMultiSpeed(DataObject):

    """ Corresponds to IDD object `Coil:Cooling:DX:MultiSpeed`
        Direct expansion (DX) cooling coil and condensing unit (includes electric or
        engine-driven compressor and condenser fan), multi-speed (or variable-speed).
        Optional moisture evaporation from wet coil when compressor cycles off with continuous
        fan operation. Requires two to four sets of performance data and will interpolate
        between speeds. Modeled as a single coil (multi-speed compressor or multiple
        compressors with row split or intertwined coil).
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'air inlet node name',
                                      {'name': u'Air Inlet Node Name',
                                       'pyname': u'air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air outlet node name',
                                      {'name': u'Air Outlet Node Name',
                                       'pyname': u'air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'condenser air inlet node name',
                                      {'name': u'Condenser Air Inlet Node Name',
                                       'pyname': u'condenser_air_inlet_node_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'condenser type',
                                      {'name': u'Condenser Type',
                                       'pyname': u'condenser_type',
                                       'default': u'AirCooled',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'AirCooled',
                                                           u'EvaporativelyCooled'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'supply water storage tank name',
                                      {'name': u'Supply Water Storage Tank Name',
                                       'pyname': u'supply_water_storage_tank_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'condensate collection water storage tank name',
                                      {'name': u'Condensate Collection Water Storage Tank Name',
                                       'pyname': u'condensate_collection_water_storage_tank_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'apply part load fraction to speeds greater than 1',
                                      {'name': u'Apply Part Load Fraction to Speeds Greater than 1',
                                       'pyname': u'apply_part_load_fraction_to_speeds_greater_than_1',
                                       'default': u'No',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Yes',
                                                           u'No'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'apply latent degradation to speeds greater than 1',
                                      {'name': u'Apply Latent Degradation to Speeds Greater than 1',
                                       'pyname': u'apply_latent_degradation_to_speeds_greater_than_1',
                                       'default': u'No',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Yes',
                                                           u'No'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'crankcase heater capacity',
                                      {'name': u'Crankcase Heater Capacity',
                                       'pyname': u'crankcase_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'maximum outdoor dry-bulb temperature for crankcase heater operation',
                                      {'name': u'Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation',
                                       'pyname': u'maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation',
                                       'default': 10.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'basin heater capacity',
                                      {'name': u'Basin Heater Capacity',
                                       'pyname': u'basin_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/K'}),
                                     (u'basin heater setpoint temperature',
                                      {'name': u'Basin Heater Setpoint Temperature',
                                       'pyname': u'basin_heater_setpoint_temperature',
                                       'default': 2.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 2.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'basin heater operating schedule name',
                                      {'name': u'Basin Heater Operating Schedule Name',
                                       'pyname': u'basin_heater_operating_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'fuel type',
                                      {'name': u'Fuel Type',
                                       'pyname': u'fuel_type',
                                       'default': u'NaturalGas',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Electricity',
                                                           u'NaturalGas',
                                                           u'PropaneGas',
                                                           u'Diesel',
                                                           u'Gasoline',
                                                           u'FuelOil#1',
                                                           u'FuelOil#2',
                                                           u'OtherFuel1',
                                                           u'OtherFuel2'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'number of speeds',
                                      {'name': u'Number of Speeds',
                                       'pyname': u'number_of_speeds',
                                       'maximum': 4,
                                       'required-field': True,
                                       'autosizable': False,
                                       'minimum': 2,
                                       'autocalculatable': False,
                                       'type': u'integer'}),
                                     (u'speed 1 gross rated total cooling capacity',
                                      {'name': u'Speed 1 Gross Rated Total Cooling Capacity',
                                       'pyname': u'speed_1_gross_rated_total_cooling_capacity',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'speed 1 gross rated sensible heat ratio',
                                      {'name': u'Speed 1 Gross Rated Sensible Heat Ratio',
                                       'pyname': u'speed_1_gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'minimum': 0.5,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'speed 1 gross rated cooling cop',
                                      {'name': u'Speed 1 Gross Rated Cooling COP',
                                       'pyname': u'speed_1_gross_rated_cooling_cop',
                                       'default': 3.0,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'speed 1 rated air flow rate',
                                      {'name': u'Speed 1 Rated Air Flow Rate',
                                       'pyname': u'speed_1_rated_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'rated evaporator fan power per volume flow rate',
                                      {'name': u'Rated Evaporator Fan Power Per Volume Flow Rate',
                                       'pyname': u'rated_evaporator_fan_power_per_volume_flow_rate',
                                       'default': 773.3,
                                       'maximum': 1250.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/(m3/s)'}),
                                     (u'speed 1 total cooling capacity function of temperature curve name',
                                      {'name': u'Speed 1 Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_1_total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 total cooling capacity function of flow fraction curve name',
                                      {'name': u'Speed 1 Total Cooling Capacity Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_1_total_cooling_capacity_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 1 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_1_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 energy input ratio function of flow fraction curve name',
                                      {'name': u'Speed 1 Energy Input Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_1_energy_input_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 part load fraction correlation curve name',
                                      {'name': u'Speed 1 Part Load Fraction Correlation Curve Name',
                                       'pyname': u'speed_1_part_load_fraction_correlation_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 nominal time for condensate removal to begin',
                                      {'name': u'Speed 1 Nominal Time for Condensate Removal to Begin',
                                       'pyname': u'speed_1_nominal_time_for_condensate_removal_to_begin',
                                       'default': 0.0,
                                       'maximum': 3000.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u's'}),
                                     (u'speed 1 ratio of initial moisture evaporation rate and steady state latent capacity',
                                      {'name': u'Speed 1 Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity',
                                       'pyname': u'speed_1_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity',
                                       'default': 0.0,
                                       'maximum': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 1 maximum cycling rate',
                                      {'name': u'Speed 1 Maximum Cycling Rate',
                                       'pyname': u'speed_1_maximum_cycling_rate',
                                       'default': 0.0,
                                       'maximum': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'cycles/hr'}),
                                     (u'speed 1 latent capacity time constant',
                                      {'name': u'Speed 1 Latent Capacity Time Constant',
                                       'pyname': u'speed_1_latent_capacity_time_constant',
                                       'default': 0.0,
                                       'maximum': 500.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u's'}),
                                     (u'speed 1 rated waste heat fraction of power input',
                                      {'name': u'Speed 1 Rated Waste Heat Fraction of Power Input',
                                       'pyname': u'speed_1_rated_waste_heat_fraction_of_power_input',
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 1 waste heat function of temperature curve name',
                                      {'name': u'Speed 1 Waste Heat Function of Temperature Curve Name',
                                       'pyname': u'speed_1_waste_heat_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 evaporative condenser effectiveness',
                                      {'name': u'Speed 1 Evaporative Condenser Effectiveness',
                                       'pyname': u'speed_1_evaporative_condenser_effectiveness',
                                       'default': 0.9,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 1 evaporative condenser air flow rate',
                                      {'name': u'Speed 1 Evaporative Condenser Air Flow Rate',
                                       'pyname': u'speed_1_evaporative_condenser_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 1 rated evaporative condenser pump power consumption',
                                      {'name': u'Speed 1 Rated Evaporative Condenser Pump Power Consumption',
                                       'pyname': u'speed_1_rated_evaporative_condenser_pump_power_consumption',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'speed 2 gross rated total cooling capacity',
                                      {'name': u'Speed 2 Gross Rated Total Cooling Capacity',
                                       'pyname': u'speed_2_gross_rated_total_cooling_capacity',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'speed 2 gross rated sensible heat ratio',
                                      {'name': u'Speed 2 Gross Rated Sensible Heat Ratio',
                                       'pyname': u'speed_2_gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'minimum': 0.5,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'speed 2 gross rated cooling cop',
                                      {'name': u'Speed 2 Gross Rated Cooling COP',
                                       'pyname': u'speed_2_gross_rated_cooling_cop',
                                       'default': 3.0,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'speed 2 rated air flow rate',
                                      {'name': u'Speed 2 Rated Air Flow Rate',
                                       'pyname': u'speed_2_rated_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     ('rated evaporator fan power per volume flow rate v3',
                                      {'name': 'Rated Evaporator Fan Power Per Volume Flow Rate v3',
                                       'pyname': 'rated_evaporator_fan_power_per_volume_flow_rate_v3',
                                       'default': 773.3,
                                       'maximum': 1250.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/(m3/s)'}),
                                     (u'speed 2 total cooling capacity function of temperature curve name',
                                      {'name': u'Speed 2 Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_2_total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 total cooling capacity function of flow fraction curve name',
                                      {'name': u'Speed 2 Total Cooling Capacity Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_2_total_cooling_capacity_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 2 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_2_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 energy input ratio function of flow fraction curve name',
                                      {'name': u'Speed 2 Energy Input Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_2_energy_input_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 part load fraction correlation curve name',
                                      {'name': u'Speed 2 Part Load Fraction Correlation Curve Name',
                                       'pyname': u'speed_2_part_load_fraction_correlation_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 nominal time for condensate removal to begin',
                                      {'name': u'Speed 2 Nominal Time for Condensate Removal to Begin',
                                       'pyname': u'speed_2_nominal_time_for_condensate_removal_to_begin',
                                       'default': 0.0,
                                       'maximum': 3000.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u's'}),
                                     (u'speed 2 ratio of initial moisture evaporation rate and steady state latent capacity',
                                      {'name': u'Speed 2 Ratio of Initial Moisture Evaporation Rate and steady state Latent Capacity',
                                       'pyname': u'speed_2_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity',
                                       'default': 0.0,
                                       'maximum': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 2 maximum cycling rate',
                                      {'name': u'Speed 2 Maximum Cycling Rate',
                                       'pyname': u'speed_2_maximum_cycling_rate',
                                       'default': 0.0,
                                       'maximum': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'cycles/hr'}),
                                     (u'speed 2 latent capacity time constant',
                                      {'name': u'Speed 2 Latent Capacity Time Constant',
                                       'pyname': u'speed_2_latent_capacity_time_constant',
                                       'default': 0.0,
                                       'maximum': 500.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u's'}),
                                     (u'speed 2 rated waste heat fraction of power input',
                                      {'name': u'Speed 2 Rated Waste Heat Fraction of Power Input',
                                       'pyname': u'speed_2_rated_waste_heat_fraction_of_power_input',
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 2 waste heat function of temperature curve name',
                                      {'name': u'Speed 2 Waste Heat Function of Temperature Curve Name',
                                       'pyname': u'speed_2_waste_heat_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 evaporative condenser effectiveness',
                                      {'name': u'Speed 2 Evaporative Condenser Effectiveness',
                                       'pyname': u'speed_2_evaporative_condenser_effectiveness',
                                       'default': 0.9,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 2 evaporative condenser air flow rate',
                                      {'name': u'Speed 2 Evaporative Condenser Air Flow Rate',
                                       'pyname': u'speed_2_evaporative_condenser_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 2 rated evaporative condenser pump power consumption',
                                      {'name': u'Speed 2 Rated Evaporative Condenser Pump Power Consumption',
                                       'pyname': u'speed_2_rated_evaporative_condenser_pump_power_consumption',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'speed 3 gross rated total cooling capacity',
                                      {'name': u'Speed 3 Gross Rated Total Cooling Capacity',
                                       'pyname': u'speed_3_gross_rated_total_cooling_capacity',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'speed 3 gross rated sensible heat ratio',
                                      {'name': u'Speed 3 Gross Rated Sensible Heat Ratio',
                                       'pyname': u'speed_3_gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.5,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'speed 3 gross rated cooling cop',
                                      {'name': u'Speed 3 Gross Rated Cooling COP',
                                       'pyname': u'speed_3_gross_rated_cooling_cop',
                                       'default': 3.0,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'speed 3 rated air flow rate',
                                      {'name': u'Speed 3 Rated Air Flow Rate',
                                       'pyname': u'speed_3_rated_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     ('rated evaporator fan power per volume flow rate v4',
                                      {'name': 'Rated Evaporator Fan Power Per Volume Flow Rate v4',
                                       'pyname': 'rated_evaporator_fan_power_per_volume_flow_rate_v4',
                                       'default': 773.3,
                                       'maximum': 1250.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/(m3/s)'}),
                                     (u'speed 3 total cooling capacity function of temperature curve name',
                                      {'name': u'Speed 3 Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_3_total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 total cooling capacity function of flow fraction curve name',
                                      {'name': u'Speed 3 Total Cooling Capacity Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_3_total_cooling_capacity_function_of_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 3 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_3_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 energy input ratio function of flow fraction curve name',
                                      {'name': u'Speed 3 Energy Input Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_3_energy_input_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 part load fraction correlation curve name',
                                      {'name': u'Speed 3 Part Load Fraction Correlation Curve Name',
                                       'pyname': u'speed_3_part_load_fraction_correlation_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 nominal time for condensate removal to begin',
                                      {'name': u'Speed 3 Nominal Time for Condensate Removal to Begin',
                                       'pyname': u'speed_3_nominal_time_for_condensate_removal_to_begin',
                                       'default': 0.0,
                                       'maximum': 3000.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u's'}),
                                     (u'speed 3 ratio of initial moisture evaporation rate and steady state latent capacity',
                                      {'name': u'Speed 3 Ratio of Initial Moisture Evaporation Rate and steady state Latent Capacity',
                                       'pyname': u'speed_3_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity',
                                       'default': 0.0,
                                       'maximum': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 3 maximum cycling rate',
                                      {'name': u'Speed 3 Maximum Cycling Rate',
                                       'pyname': u'speed_3_maximum_cycling_rate',
                                       'default': 0.0,
                                       'maximum': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'cycles/hr'}),
                                     (u'speed 3 latent capacity time constant',
                                      {'name': u'Speed 3 Latent Capacity Time Constant',
                                       'pyname': u'speed_3_latent_capacity_time_constant',
                                       'default': 0.0,
                                       'maximum': 500.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u's'}),
                                     (u'speed 3 rated waste heat fraction of power input',
                                      {'name': u'Speed 3 Rated Waste Heat Fraction of Power Input',
                                       'pyname': u'speed_3_rated_waste_heat_fraction_of_power_input',
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 3 waste heat function of temperature curve name',
                                      {'name': u'Speed 3 Waste Heat Function of Temperature Curve Name',
                                       'pyname': u'speed_3_waste_heat_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 evaporative condenser effectiveness',
                                      {'name': u'Speed 3 Evaporative Condenser Effectiveness',
                                       'pyname': u'speed_3_evaporative_condenser_effectiveness',
                                       'default': 0.9,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 3 evaporative condenser air flow rate',
                                      {'name': u'Speed 3 Evaporative Condenser Air Flow Rate',
                                       'pyname': u'speed_3_evaporative_condenser_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 3 rated evaporative condenser pump power consumption',
                                      {'name': u'Speed 3 Rated Evaporative Condenser Pump Power Consumption',
                                       'pyname': u'speed_3_rated_evaporative_condenser_pump_power_consumption',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'speed 4 gross rated total cooling capacity',
                                      {'name': u'Speed 4 Gross Rated Total Cooling Capacity',
                                       'pyname': u'speed_4_gross_rated_total_cooling_capacity',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'speed 4 gross rated sensible heat ratio',
                                      {'name': u'Speed 4 Gross Rated Sensible Heat Ratio',
                                       'pyname': u'speed_4_gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.5,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'speed 4 gross rated cooling cop',
                                      {'name': u'Speed 4 Gross Rated Cooling COP',
                                       'pyname': u'speed_4_gross_rated_cooling_cop',
                                       'default': 3.0,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'speed 4 rated air flow rate',
                                      {'name': u'Speed 4 Rated Air Flow Rate',
                                       'pyname': u'speed_4_rated_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     ('rated evaporator fan power per volume flow rate v5',
                                      {'name': 'Rated Evaporator Fan Power Per Volume Flow Rate v5',
                                       'pyname': 'rated_evaporator_fan_power_per_volume_flow_rate_v5',
                                       'default': 773.3,
                                       'maximum': 1250.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/(m3/s)'}),
                                     (u'speed 4 total cooling capacity function of temperature curve name',
                                      {'name': u'Speed 4 Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_4_total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 total cooling capacity function of flow fraction curve name',
                                      {'name': u'Speed 4 Total Cooling Capacity Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_4_total_cooling_capacity_function_of_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 4 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_4_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 energy input ratio function of flow fraction curve name',
                                      {'name': u'Speed 4 Energy Input Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_4_energy_input_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 part load fraction correlation curve name',
                                      {'name': u'Speed 4 Part Load Fraction Correlation Curve Name',
                                       'pyname': u'speed_4_part_load_fraction_correlation_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 nominal time for condensate removal to begin',
                                      {'name': u'Speed 4 Nominal Time for Condensate Removal to Begin',
                                       'pyname': u'speed_4_nominal_time_for_condensate_removal_to_begin',
                                       'default': 0.0,
                                       'maximum': 3000.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u's'}),
                                     (u'speed 4 ratio of initial moisture evaporation rate and steady state latent capacity',
                                      {'name': u'Speed 4 Ratio of Initial Moisture Evaporation Rate and steady state Latent Capacity',
                                       'pyname': u'speed_4_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity',
                                       'default': 0.0,
                                       'maximum': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 4 maximum cycling rate',
                                      {'name': u'Speed 4 Maximum Cycling Rate',
                                       'pyname': u'speed_4_maximum_cycling_rate',
                                       'default': 0.0,
                                       'maximum': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'cycles/hr'}),
                                     (u'speed 4 latent capacity time constant',
                                      {'name': u'Speed 4 Latent Capacity Time Constant',
                                       'pyname': u'speed_4_latent_capacity_time_constant',
                                       'default': 0.0,
                                       'maximum': 500.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u's'}),
                                     (u'speed 4 rated waste heat fraction of power input',
                                      {'name': u'Speed 4 Rated Waste Heat Fraction of Power Input',
                                       'pyname': u'speed_4_rated_waste_heat_fraction_of_power_input',
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 4 waste heat function of temperature curve name',
                                      {'name': u'Speed 4 Waste Heat Function of Temperature Curve Name',
                                       'pyname': u'speed_4_waste_heat_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 evaporative condenser effectiveness',
                                      {'name': u'Speed 4 Evaporative Condenser Effectiveness',
                                       'pyname': u'speed_4_evaporative_condenser_effectiveness',
                                       'default': 0.9,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 4 evaporative condenser air flow rate',
                                      {'name': u'Speed 4 Evaporative Condenser Air Flow Rate',
                                       'pyname': u'speed_4_evaporative_condenser_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 4 rated evaporative condenser pump power consumption',
                                      {'name': u'Speed 4 Rated Evaporative Condenser Pump Power Consumption',
                                       'pyname': u'speed_4_rated_evaporative_condenser_pump_power_consumption',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 55,
              'name': u'Coil:Cooling:DX:MultiSpeed',
              'pyname': u'CoilCoolingDxMultiSpeed',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def air_inlet_node_name(self):
        """Get air_inlet_node_name.

        Returns:
            str: the value of `air_inlet_node_name` or None if not set

        """
        return self["Air Inlet Node Name"]

    @air_inlet_node_name.setter
    def air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Inlet Node Name"] = value

    @property
    def air_outlet_node_name(self):
        """Get air_outlet_node_name.

        Returns:
            str: the value of `air_outlet_node_name` or None if not set

        """
        return self["Air Outlet Node Name"]

    @air_outlet_node_name.setter
    def air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Outlet Node Name"] = value

    @property
    def condenser_air_inlet_node_name(self):
        """Get condenser_air_inlet_node_name.

        Returns:
            str: the value of `condenser_air_inlet_node_name` or None if not set

        """
        return self["Condenser Air Inlet Node Name"]

    @condenser_air_inlet_node_name.setter
    def condenser_air_inlet_node_name(self, value=None):
        """  Corresponds to IDD field `Condenser Air Inlet Node Name`
        Enter the name of an outdoor air node. This node name is also specified in
        an OutdoorAir:Node or OutdoorAir:NodeList object.

        Args:
            value (str): value for IDD Field `Condenser Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Condenser Air Inlet Node Name"] = value

    @property
    def condenser_type(self):
        """Get condenser_type.

        Returns:
            str: the value of `condenser_type` or None if not set

        """
        return self["Condenser Type"]

    @condenser_type.setter
    def condenser_type(self, value="AirCooled"):
        """Corresponds to IDD field `Condenser Type`

        Args:
            value (str): value for IDD Field `Condenser Type`
                Default value: AirCooled
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Condenser Type"] = value

    @property
    def supply_water_storage_tank_name(self):
        """Get supply_water_storage_tank_name.

        Returns:
            str: the value of `supply_water_storage_tank_name` or None if not set

        """
        return self["Supply Water Storage Tank Name"]

    @supply_water_storage_tank_name.setter
    def supply_water_storage_tank_name(self, value=None):
        """Corresponds to IDD field `Supply Water Storage Tank Name`

        Args:
            value (str): value for IDD Field `Supply Water Storage Tank Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Water Storage Tank Name"] = value

    @property
    def condensate_collection_water_storage_tank_name(self):
        """Get condensate_collection_water_storage_tank_name.

        Returns:
            str: the value of `condensate_collection_water_storage_tank_name` or None if not set

        """
        return self["Condensate Collection Water Storage Tank Name"]

    @condensate_collection_water_storage_tank_name.setter
    def condensate_collection_water_storage_tank_name(self, value=None):
        """Corresponds to IDD field `Condensate Collection Water Storage Tank
        Name`

        Args:
            value (str): value for IDD Field `Condensate Collection Water Storage Tank Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Condensate Collection Water Storage Tank Name"] = value

    @property
    def apply_part_load_fraction_to_speeds_greater_than_1(self):
        """Get apply_part_load_fraction_to_speeds_greater_than_1.

        Returns:
            str: the value of `apply_part_load_fraction_to_speeds_greater_than_1` or None if not set

        """
        return self["Apply Part Load Fraction to Speeds Greater than 1"]

    @apply_part_load_fraction_to_speeds_greater_than_1.setter
    def apply_part_load_fraction_to_speeds_greater_than_1(self, value="No"):
        """Corresponds to IDD field `Apply Part Load Fraction to Speeds Greater
        than 1`

        Args:
            value (str): value for IDD Field `Apply Part Load Fraction to Speeds Greater than 1`
                Default value: No
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Apply Part Load Fraction to Speeds Greater than 1"] = value

    @property
    def apply_latent_degradation_to_speeds_greater_than_1(self):
        """Get apply_latent_degradation_to_speeds_greater_than_1.

        Returns:
            str: the value of `apply_latent_degradation_to_speeds_greater_than_1` or None if not set

        """
        return self["Apply Latent Degradation to Speeds Greater than 1"]

    @apply_latent_degradation_to_speeds_greater_than_1.setter
    def apply_latent_degradation_to_speeds_greater_than_1(self, value="No"):
        """Corresponds to IDD field `Apply Latent Degradation to Speeds Greater
        than 1`

        Args:
            value (str): value for IDD Field `Apply Latent Degradation to Speeds Greater than 1`
                Default value: No
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Apply Latent Degradation to Speeds Greater than 1"] = value

    @property
    def crankcase_heater_capacity(self):
        """Get crankcase_heater_capacity.

        Returns:
            float: the value of `crankcase_heater_capacity` or None if not set

        """
        return self["Crankcase Heater Capacity"]

    @crankcase_heater_capacity.setter
    def crankcase_heater_capacity(self, value=None):
        """Corresponds to IDD field `Crankcase Heater Capacity`

        Args:
            value (float): value for IDD Field `Crankcase Heater Capacity`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Crankcase Heater Capacity"] = value

    @property
    def maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation(
            self):
        """Get
        maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation.

        Returns:
            float: the value of `maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation` or None if not set

        """
        return self[
            "Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation"]

    @maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation.setter
    def maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation(
            self,
            value=10.0):
        """  Corresponds to IDD field `Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation`

        Args:
            value (float): value for IDD Field `Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation`
                Units: C
                Default value: 10.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation"] = value

    @property
    def basin_heater_capacity(self):
        """Get basin_heater_capacity.

        Returns:
            float: the value of `basin_heater_capacity` or None if not set

        """
        return self["Basin Heater Capacity"]

    @basin_heater_capacity.setter
    def basin_heater_capacity(self, value=None):
        """  Corresponds to IDD field `Basin Heater Capacity`
        This field is only used for Condenser Type = EvaporativelyCooled and for periods
        when the basin heater is available (field Basin Heater Operating Schedule Name).
        For this situation, the heater maintains the basin water temperature at the basin heater
        setpoint temperature when the outdoor air temperature falls below the setpoint temperature.
        The basin heater only operates when the DX coil is off.

        Args:
            value (float): value for IDD Field `Basin Heater Capacity`
                Units: W/K
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Capacity"] = value

    @property
    def basin_heater_setpoint_temperature(self):
        """Get basin_heater_setpoint_temperature.

        Returns:
            float: the value of `basin_heater_setpoint_temperature` or None if not set

        """
        return self["Basin Heater Setpoint Temperature"]

    @basin_heater_setpoint_temperature.setter
    def basin_heater_setpoint_temperature(self, value=2.0):
        """  Corresponds to IDD field `Basin Heater Setpoint Temperature`
        This field is only used for Condenser Type = EvaporativelyCooled.
        Enter the outdoor dry-bulb temperature when the basin heater turns on.

        Args:
            value (float): value for IDD Field `Basin Heater Setpoint Temperature`
                Units: C
                Default value: 2.0
                value >= 2.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Setpoint Temperature"] = value

    @property
    def basin_heater_operating_schedule_name(self):
        """Get basin_heater_operating_schedule_name.

        Returns:
            str: the value of `basin_heater_operating_schedule_name` or None if not set

        """
        return self["Basin Heater Operating Schedule Name"]

    @basin_heater_operating_schedule_name.setter
    def basin_heater_operating_schedule_name(self, value=None):
        """  Corresponds to IDD field `Basin Heater Operating Schedule Name`
        This field is only used for Condenser Type = EvaporativelyCooled.
        Schedule values greater than 0 allow the basin heater to operate whenever the outdoor
        air dry-bulb temperature is below the basin heater setpoint temperature.
        If a schedule name is not entered, the basin heater is allowed to operate
        throughout the entire simulation.

        Args:
            value (str): value for IDD Field `Basin Heater Operating Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Operating Schedule Name"] = value

    @property
    def fuel_type(self):
        """Get fuel_type.

        Returns:
            str: the value of `fuel_type` or None if not set

        """
        return self["Fuel Type"]

    @fuel_type.setter
    def fuel_type(self, value="NaturalGas"):
        """Corresponds to IDD field `Fuel Type`

        Args:
            value (str): value for IDD Field `Fuel Type`
                Default value: NaturalGas
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Fuel Type"] = value

    @property
    def number_of_speeds(self):
        """Get number_of_speeds.

        Returns:
            int: the value of `number_of_speeds` or None if not set

        """
        return self["Number of Speeds"]

    @number_of_speeds.setter
    def number_of_speeds(self, value=None):
        """Corresponds to IDD field `Number of Speeds` Enter the number of the
        following sets of data for coil capacity, SHR, COP, flow rate, and
        associated curves.

        Args:
            value (int): value for IDD Field `Number of Speeds`
                value >= 2
                value <= 4
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Number of Speeds"] = value

    @property
    def speed_1_gross_rated_total_cooling_capacity(self):
        """Get speed_1_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `speed_1_gross_rated_total_cooling_capacity` or None if not set

        """
        return self["Speed 1 Gross Rated Total Cooling Capacity"]

    @speed_1_gross_rated_total_cooling_capacity.setter
    def speed_1_gross_rated_total_cooling_capacity(self, value=None):
        """  Corresponds to IDD field `Speed 1 Gross Rated Total Cooling Capacity`
        Total cooling capacity not accounting for the effect of supply air fan heat
        Gross capacity excluding supply air fan heat
        Rating point: air entering the cooling coil at 26.7 C dry-bulb/19.4 C wet-bulb, and
        air entering the outdoor condenser coil at 35 C dry-bulb/23.9 C wet-bulb
        Speed 1 is defined as low speed

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 1 Gross Rated Total Cooling Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 1 Gross Rated Total Cooling Capacity"] = value

    @property
    def speed_1_gross_rated_sensible_heat_ratio(self):
        """Get speed_1_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `speed_1_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Speed 1 Gross Rated Sensible Heat Ratio"]

    @speed_1_gross_rated_sensible_heat_ratio.setter
    def speed_1_gross_rated_sensible_heat_ratio(self, value=None):
        """Corresponds to IDD field `Speed 1 Gross Rated Sensible Heat Ratio`
        Gross Rated Sensible Heat Ratio (gross sensible capacity/gross total
        capacity) Sensible and total capacities do not include supply fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 1 Gross Rated Sensible Heat Ratio`
                value >= 0.5
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 1 Gross Rated Sensible Heat Ratio"] = value

    @property
    def speed_1_gross_rated_cooling_cop(self):
        """Get speed_1_gross_rated_cooling_cop.

        Returns:
            float: the value of `speed_1_gross_rated_cooling_cop` or None if not set

        """
        return self["Speed 1 Gross Rated Cooling COP"]

    @speed_1_gross_rated_cooling_cop.setter
    def speed_1_gross_rated_cooling_cop(self, value=3.0):
        """Corresponds to IDD field `Speed 1 Gross Rated Cooling COP` Gross
        cooling capacity divided by power input to the compressor and outdoor
        fan, does not include supply fan heat or supply fan electrical energy
        input.

        Args:
            value (float): value for IDD Field `Speed 1 Gross Rated Cooling COP`
                Units: W/W
                Default value: 3.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 1 Gross Rated Cooling COP"] = value

    @property
    def speed_1_rated_air_flow_rate(self):
        """Get speed_1_rated_air_flow_rate.

        Returns:
            float: the value of `speed_1_rated_air_flow_rate` or None if not set

        """
        return self["Speed 1 Rated Air Flow Rate"]

    @speed_1_rated_air_flow_rate.setter
    def speed_1_rated_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Speed 1 Rated Air Flow Rate`
        Flow rate corresponding to rated total cooling capacity, rated SHR and rated
        COP should be between 0.00004027 m3/s and .00006041 m3/s per watt of rated total
        cooling capacity

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 1 Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 1 Rated Air Flow Rate"] = value

    @property
    def rated_evaporator_fan_power_per_volume_flow_rate(self):
        """Get rated_evaporator_fan_power_per_volume_flow_rate.

        Returns:
            float: the value of `rated_evaporator_fan_power_per_volume_flow_rate` or None if not set

        """
        return self["Rated Evaporator Fan Power Per Volume Flow Rate"]

    @rated_evaporator_fan_power_per_volume_flow_rate.setter
    def rated_evaporator_fan_power_per_volume_flow_rate(self, value=773.3):
        """Corresponds to IDD field `Rated Evaporator Fan Power Per Volume Flow
        Rate` Enter the evaporator fan power per air volume flow rate at the
        rated test conditions. The test conditions vary external static
        pressure based on total cooling capacity. This value is only used to
        calculate Seasonal Energy Efficiency Ratio (SEER), and the Standard
        Rating (Net) Cooling Capacity which will be outputs in the EnergyPlus
        eio file. This value is not used for modeling the evaporator fan during
        simulations.

        Args:
            value (float): value for IDD Field `Rated Evaporator Fan Power Per Volume Flow Rate`
                Units: W/(m3/s)
                Default value: 773.3
                value <= 1250.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Rated Evaporator Fan Power Per Volume Flow Rate"] = value

    @property
    def speed_1_total_cooling_capacity_function_of_temperature_curve_name(
            self):
        """Get
        speed_1_total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_1_total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 1 Total Cooling Capacity Function of Temperature Curve Name"]

    @speed_1_total_cooling_capacity_function_of_temperature_curve_name.setter
    def speed_1_total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be used
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 1 Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 1 Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_1_total_cooling_capacity_function_of_flow_fraction_curve_name(
            self):
        """Get
        speed_1_total_cooling_capacity_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_1_total_cooling_capacity_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 1 Total Cooling Capacity Function of Flow Fraction Curve Name"]

    @speed_1_total_cooling_capacity_function_of_flow_fraction_curve_name.setter
    def speed_1_total_cooling_capacity_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Total Cooling Capacity Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = Fraction of the full load Flow

        Args:
            value (str): value for IDD Field `Speed 1 Total Cooling Capacity Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 1 Total Cooling Capacity Function of Flow Fraction Curve Name"] = value

    @property
    def speed_1_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_1_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_1_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 1 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_1_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_1_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be used
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 1 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 1 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_1_energy_input_ratio_function_of_flow_fraction_curve_name(self):
        """Get speed_1_energy_input_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_1_energy_input_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 1 Energy Input Ratio Function of Flow Fraction Curve Name"]

    @speed_1_energy_input_ratio_function_of_flow_fraction_curve_name.setter
    def speed_1_energy_input_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Energy Input Ratio Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Speed 1 Energy Input Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 1 Energy Input Ratio Function of Flow Fraction Curve Name"] = value

    @property
    def speed_1_part_load_fraction_correlation_curve_name(self):
        """Get speed_1_part_load_fraction_correlation_curve_name.

        Returns:
            str: the value of `speed_1_part_load_fraction_correlation_curve_name` or None if not set

        """
        return self["Speed 1 Part Load Fraction Correlation Curve Name"]

    @speed_1_part_load_fraction_correlation_curve_name.setter
    def speed_1_part_load_fraction_correlation_curve_name(self, value=None):
        """  Corresponds to IDD field `Speed 1 Part Load Fraction Correlation Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*PLR + c*PLR**2
        cubic curve = a + b*PLR + c*PLR**2 + d*PLR**3
        PLR = part load ratio (cooling load/steady state capacity)

        Args:
            value (str): value for IDD Field `Speed 1 Part Load Fraction Correlation Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 1 Part Load Fraction Correlation Curve Name"] = value

    @property
    def speed_1_nominal_time_for_condensate_removal_to_begin(self):
        """Get speed_1_nominal_time_for_condensate_removal_to_begin.

        Returns:
            float: the value of `speed_1_nominal_time_for_condensate_removal_to_begin` or None if not set

        """
        return self["Speed 1 Nominal Time for Condensate Removal to Begin"]

    @speed_1_nominal_time_for_condensate_removal_to_begin.setter
    def speed_1_nominal_time_for_condensate_removal_to_begin(self, value=None):
        """Corresponds to IDD field `Speed 1 Nominal Time for Condensate
        Removal to Begin` The nominal time for condensate to begin leaving the
        coil's condensate drain line at the coil's rated air flow rate and
        temperature conditions. Nominal time is equal to the ratio of the
        energy of the coil's maximum condensate holding capacity (J) to the
        coil's steady state latent capacity (W). Suggested value is 1000; zero
        value means latent degradation model is disabled.

        Args:
            value (float): value for IDD Field `Speed 1 Nominal Time for Condensate Removal to Begin`
                Units: s
                value <= 3000.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 1 Nominal Time for Condensate Removal to Begin"] = value

    @property
    def speed_1_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity(
            self):
        """Get speed_1_ratio_of_initial_moisture_evaporation_rate_and_steady_st
        ate_latent_capacity.

        Returns:
            float: the value of `speed_1_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity` or None if not set

        """
        return self[
            "Speed 1 Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity"]

    @speed_1_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity.setter
    def speed_1_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity`
        Ratio of the initial moisture evaporation Rate from the Cooling Coil (when
        the compressor first turns off) and the Coil's steady state latent capacity
        at rated air flow rate and temperature conditions. Suggested value is 1.5; zero value
        means latent degradation model is disabled.

        Args:
            value (float): value for IDD Field `Speed 1 Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity`
                Units: dimensionless
                value <= 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 1 Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity"] = value

    @property
    def speed_1_maximum_cycling_rate(self):
        """Get speed_1_maximum_cycling_rate.

        Returns:
            float: the value of `speed_1_maximum_cycling_rate` or None if not set

        """
        return self["Speed 1 Maximum Cycling Rate"]

    @speed_1_maximum_cycling_rate.setter
    def speed_1_maximum_cycling_rate(self, value=None):
        """  Corresponds to IDD field `Speed 1 Maximum Cycling Rate`
        The maximum on-off cycling rate for the compressor, which occurs at 50% run time
        fraction. Suggested value is 3; zero value means latent degradation
        model is disabled.

        Args:
            value (float): value for IDD Field `Speed 1 Maximum Cycling Rate`
                Units: cycles/hr
                value <= 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 1 Maximum Cycling Rate"] = value

    @property
    def speed_1_latent_capacity_time_constant(self):
        """Get speed_1_latent_capacity_time_constant.

        Returns:
            float: the value of `speed_1_latent_capacity_time_constant` or None if not set

        """
        return self["Speed 1 Latent Capacity Time Constant"]

    @speed_1_latent_capacity_time_constant.setter
    def speed_1_latent_capacity_time_constant(self, value=None):
        """Corresponds to IDD field `Speed 1 Latent Capacity Time Constant`
        Time constant for the cooling coil's latent capacity to reach steady
        state after startup. Suggested value is 45; zero value means latent
        degradation model is disabled.

        Args:
            value (float): value for IDD Field `Speed 1 Latent Capacity Time Constant`
                Units: s
                value <= 500.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 1 Latent Capacity Time Constant"] = value

    @property
    def speed_1_rated_waste_heat_fraction_of_power_input(self):
        """Get speed_1_rated_waste_heat_fraction_of_power_input.

        Returns:
            float: the value of `speed_1_rated_waste_heat_fraction_of_power_input` or None if not set

        """
        return self["Speed 1 Rated Waste Heat Fraction of Power Input"]

    @speed_1_rated_waste_heat_fraction_of_power_input.setter
    def speed_1_rated_waste_heat_fraction_of_power_input(self, value=None):
        """Corresponds to IDD field `Speed 1 Rated Waste Heat Fraction of Power
        Input` Recoverable waste heat at full load and rated conditions.

        Args:
            value (float): value for IDD Field `Speed 1 Rated Waste Heat Fraction of Power Input`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 1 Rated Waste Heat Fraction of Power Input"] = value

    @property
    def speed_1_waste_heat_function_of_temperature_curve_name(self):
        """Get speed_1_waste_heat_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_1_waste_heat_function_of_temperature_curve_name` or None if not set

        """
        return self["Speed 1 Waste Heat Function of Temperature Curve Name"]

    @speed_1_waste_heat_function_of_temperature_curve_name.setter
    def speed_1_waste_heat_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Waste Heat Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be used
        curve = a + b*odb + c*odb**2 + d*db + e*db**2 + f*odb*db
        odb = Outdoor air dry-bulb temperature (C)
        db = entering coil dry-bulb temperature (C)

        Args:
            value (str): value for IDD Field `Speed 1 Waste Heat Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 1 Waste Heat Function of Temperature Curve Name"] = value

    @property
    def speed_1_evaporative_condenser_effectiveness(self):
        """Get speed_1_evaporative_condenser_effectiveness.

        Returns:
            float: the value of `speed_1_evaporative_condenser_effectiveness` or None if not set

        """
        return self["Speed 1 Evaporative Condenser Effectiveness"]

    @speed_1_evaporative_condenser_effectiveness.setter
    def speed_1_evaporative_condenser_effectiveness(self, value=0.9):
        """Corresponds to IDD field `Speed 1 Evaporative Condenser
        Effectiveness`

        Args:
            value (float): value for IDD Field `Speed 1 Evaporative Condenser Effectiveness`
                Units: dimensionless
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 1 Evaporative Condenser Effectiveness"] = value

    @property
    def speed_1_evaporative_condenser_air_flow_rate(self):
        """Get speed_1_evaporative_condenser_air_flow_rate.

        Returns:
            float: the value of `speed_1_evaporative_condenser_air_flow_rate` or None if not set

        """
        return self["Speed 1 Evaporative Condenser Air Flow Rate"]

    @speed_1_evaporative_condenser_air_flow_rate.setter
    def speed_1_evaporative_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 1 Evaporative Condenser Air Flow
        Rate` Used to calculate evaporative condenser water use.

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 1 Evaporative Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 1 Evaporative Condenser Air Flow Rate"] = value

    @property
    def speed_1_rated_evaporative_condenser_pump_power_consumption(self):
        """Get speed_1_rated_evaporative_condenser_pump_power_consumption.

        Returns:
            float: the value of `speed_1_rated_evaporative_condenser_pump_power_consumption` or None if not set

        """
        return self[
            "Speed 1 Rated Evaporative Condenser Pump Power Consumption"]

    @speed_1_rated_evaporative_condenser_pump_power_consumption.setter
    def speed_1_rated_evaporative_condenser_pump_power_consumption(
            self,
            value=None):
        """Corresponds to IDD field `Speed 1 Rated Evaporative Condenser Pump
        Power Consumption` Rated power consumed by the evaporative condenser's
        water pump at high speed.

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 1 Rated Evaporative Condenser Pump Power Consumption`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 1 Rated Evaporative Condenser Pump Power Consumption"] = value

    @property
    def speed_2_gross_rated_total_cooling_capacity(self):
        """Get speed_2_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `speed_2_gross_rated_total_cooling_capacity` or None if not set

        """
        return self["Speed 2 Gross Rated Total Cooling Capacity"]

    @speed_2_gross_rated_total_cooling_capacity.setter
    def speed_2_gross_rated_total_cooling_capacity(self, value=None):
        """  Corresponds to IDD field `Speed 2 Gross Rated Total Cooling Capacity`
        Total cooling capacity not accounting for the effect of supply air fan heat
        Gross capacity excluding supply air fan heat
        Rating point: air entering the cooling coil at 26.7 C dry-bulb/19.4 C wet-bulb, and
        air entering the outdoor condenser coil at 35 C dry-bulb/23.9 C wet-bulb

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 2 Gross Rated Total Cooling Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 2 Gross Rated Total Cooling Capacity"] = value

    @property
    def speed_2_gross_rated_sensible_heat_ratio(self):
        """Get speed_2_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `speed_2_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Speed 2 Gross Rated Sensible Heat Ratio"]

    @speed_2_gross_rated_sensible_heat_ratio.setter
    def speed_2_gross_rated_sensible_heat_ratio(self, value=None):
        """Corresponds to IDD field `Speed 2 Gross Rated Sensible Heat Ratio`
        Gross Rated Sensible Heat Ratio (gross sensible capacity/gross total
        capacity) Sensible and total capacities do not include supply fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 2 Gross Rated Sensible Heat Ratio`
                value >= 0.5
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 2 Gross Rated Sensible Heat Ratio"] = value

    @property
    def speed_2_gross_rated_cooling_cop(self):
        """Get speed_2_gross_rated_cooling_cop.

        Returns:
            float: the value of `speed_2_gross_rated_cooling_cop` or None if not set

        """
        return self["Speed 2 Gross Rated Cooling COP"]

    @speed_2_gross_rated_cooling_cop.setter
    def speed_2_gross_rated_cooling_cop(self, value=3.0):
        """Corresponds to IDD field `Speed 2 Gross Rated Cooling COP` Gross
        cooling capacity divided by power input to the compressor and outdoor
        fan, does not include supply fan heat or supply fan electrical energy
        input.

        Args:
            value (float): value for IDD Field `Speed 2 Gross Rated Cooling COP`
                Units: W/W
                Default value: 3.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 2 Gross Rated Cooling COP"] = value

    @property
    def speed_2_rated_air_flow_rate(self):
        """Get speed_2_rated_air_flow_rate.

        Returns:
            float: the value of `speed_2_rated_air_flow_rate` or None if not set

        """
        return self["Speed 2 Rated Air Flow Rate"]

    @speed_2_rated_air_flow_rate.setter
    def speed_2_rated_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Speed 2 Rated Air Flow Rate`
        Flow rate corresponding to rated total cooling capacity, rated SHR and rated
        COP should be between 0.00004027 m3/s and .00006041 m3/s per watt of rated total
        cooling capacity for Speed 2.

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 2 Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 2 Rated Air Flow Rate"] = value

    @property
    def rated_evaporator_fan_power_per_volume_flow_rate_v3(self):
        """Get rated_evaporator_fan_power_per_volume_flow_rate_v3.

        Returns:
            float: the value of `rated_evaporator_fan_power_per_volume_flow_rate_v3` or None if not set

        """
        return self["Rated Evaporator Fan Power Per Volume Flow Rate v3"]

    @rated_evaporator_fan_power_per_volume_flow_rate_v3.setter
    def rated_evaporator_fan_power_per_volume_flow_rate_v3(self, value=773.3):
        """Corresponds to IDD field `Rated Evaporator Fan Power Per Volume Flow
        Rate v3` Enter the evaporator fan power per air volume flow rate at the
        rated test conditions. The test conditions vary external static
        pressure based on total cooling capacity. This value is only used to
        calculate Seasonal Energy Efficiency Ratio (SEER), and the Standard
        Rating (Net) Cooling Capacity which will be outputs in the EnergyPlus
        eio file. This value is not used for modeling the evaporator fan during
        simulations.

        Args:
            value (float): value for IDD Field `Rated Evaporator Fan Power Per Volume Flow Rate v3`
                Units: W/(m3/s)
                Default value: 773.3
                value <= 1250.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Rated Evaporator Fan Power Per Volume Flow Rate v3"] = value

    @property
    def speed_2_total_cooling_capacity_function_of_temperature_curve_name(
            self):
        """Get
        speed_2_total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_2_total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 2 Total Cooling Capacity Function of Temperature Curve Name"]

    @speed_2_total_cooling_capacity_function_of_temperature_curve_name.setter
    def speed_2_total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 2 Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be used
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 2 Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 2 Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_2_total_cooling_capacity_function_of_flow_fraction_curve_name(
            self):
        """Get
        speed_2_total_cooling_capacity_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_2_total_cooling_capacity_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 2 Total Cooling Capacity Function of Flow Fraction Curve Name"]

    @speed_2_total_cooling_capacity_function_of_flow_fraction_curve_name.setter
    def speed_2_total_cooling_capacity_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 2 Total Cooling Capacity Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Speed 2 Total Cooling Capacity Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 2 Total Cooling Capacity Function of Flow Fraction Curve Name"] = value

    @property
    def speed_2_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_2_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_2_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 2 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_2_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_2_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 2 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be used
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 2 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 2 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_2_energy_input_ratio_function_of_flow_fraction_curve_name(self):
        """Get speed_2_energy_input_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_2_energy_input_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 2 Energy Input Ratio Function of Flow Fraction Curve Name"]

    @speed_2_energy_input_ratio_function_of_flow_fraction_curve_name.setter
    def speed_2_energy_input_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 2 Energy Input Ratio Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = Fraction of the full load Flow

        Args:
            value (str): value for IDD Field `Speed 2 Energy Input Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 2 Energy Input Ratio Function of Flow Fraction Curve Name"] = value

    @property
    def speed_2_part_load_fraction_correlation_curve_name(self):
        """Get speed_2_part_load_fraction_correlation_curve_name.

        Returns:
            str: the value of `speed_2_part_load_fraction_correlation_curve_name` or None if not set

        """
        return self["Speed 2 Part Load Fraction Correlation Curve Name"]

    @speed_2_part_load_fraction_correlation_curve_name.setter
    def speed_2_part_load_fraction_correlation_curve_name(self, value=None):
        """  Corresponds to IDD field `Speed 2 Part Load Fraction Correlation Curve Name`
        Table:OneIndependentVariable
        quadratic curve = a + b*PLR + c*PLR**2
        cubic curve = a + b*PLR + c*PLR**2 + d*PLR**3
        PLR = part load ratio (Cooling load/steady state capacity)

        Args:
            value (str): value for IDD Field `Speed 2 Part Load Fraction Correlation Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 2 Part Load Fraction Correlation Curve Name"] = value

    @property
    def speed_2_nominal_time_for_condensate_removal_to_begin(self):
        """Get speed_2_nominal_time_for_condensate_removal_to_begin.

        Returns:
            float: the value of `speed_2_nominal_time_for_condensate_removal_to_begin` or None if not set

        """
        return self["Speed 2 Nominal Time for Condensate Removal to Begin"]

    @speed_2_nominal_time_for_condensate_removal_to_begin.setter
    def speed_2_nominal_time_for_condensate_removal_to_begin(self, value=None):
        """Corresponds to IDD field `Speed 2 Nominal Time for Condensate
        Removal to Begin` The nominal time for condensate to begin leaving the
        coil's condensate drain line at the coil's rated air flow rate and
        temperature conditions. Nominal time is equal to the ratio of the
        energy of the coil's maximum condensate holding capacity (J) to the
        coil's steady state latent capacity (W). Suggested value is 1000; zero
        value means latent degradation model is disabled.

        Args:
            value (float): value for IDD Field `Speed 2 Nominal Time for Condensate Removal to Begin`
                Units: s
                value <= 3000.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 2 Nominal Time for Condensate Removal to Begin"] = value

    @property
    def speed_2_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity(
            self):
        """Get speed_2_ratio_of_initial_moisture_evaporation_rate_and_steady_st
        ate_latent_capacity.

        Returns:
            float: the value of `speed_2_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity` or None if not set

        """
        return self[
            "Speed 2 Ratio of Initial Moisture Evaporation Rate and steady state Latent Capacity"]

    @speed_2_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity.setter
    def speed_2_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 2 Ratio of Initial Moisture Evaporation Rate and steady state Latent Capacity`
        Ratio of the initial moisture evaporation rate from the cooling coil (when
        the compressor first turns off) and the coil's steady state latent capacity
        at rated air flow rate and temperature conditions. Suggested value is 1.5; zero value
        means latent degradation model is disabled.

        Args:
            value (float): value for IDD Field `Speed 2 Ratio of Initial Moisture Evaporation Rate and steady state Latent Capacity`
                Units: dimensionless
                value <= 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 2 Ratio of Initial Moisture Evaporation Rate and steady state Latent Capacity"] = value

    @property
    def speed_2_maximum_cycling_rate(self):
        """Get speed_2_maximum_cycling_rate.

        Returns:
            float: the value of `speed_2_maximum_cycling_rate` or None if not set

        """
        return self["Speed 2 Maximum Cycling Rate"]

    @speed_2_maximum_cycling_rate.setter
    def speed_2_maximum_cycling_rate(self, value=None):
        """  Corresponds to IDD field `Speed 2 Maximum Cycling Rate`
        The maximum on-off cycling rate for the compressor, which occurs at 50% run time
        fraction. Suggested value is 3; zero value means latent degradation
        model is disabled.

        Args:
            value (float): value for IDD Field `Speed 2 Maximum Cycling Rate`
                Units: cycles/hr
                value <= 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 2 Maximum Cycling Rate"] = value

    @property
    def speed_2_latent_capacity_time_constant(self):
        """Get speed_2_latent_capacity_time_constant.

        Returns:
            float: the value of `speed_2_latent_capacity_time_constant` or None if not set

        """
        return self["Speed 2 Latent Capacity Time Constant"]

    @speed_2_latent_capacity_time_constant.setter
    def speed_2_latent_capacity_time_constant(self, value=None):
        """Corresponds to IDD field `Speed 2 Latent Capacity Time Constant`
        Time constant for the cooling coil's latent capacity to reach steady
        state after startup. Suggested value is 45; zero value means latent
        degradation model is disabled.

        Args:
            value (float): value for IDD Field `Speed 2 Latent Capacity Time Constant`
                Units: s
                value <= 500.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 2 Latent Capacity Time Constant"] = value

    @property
    def speed_2_rated_waste_heat_fraction_of_power_input(self):
        """Get speed_2_rated_waste_heat_fraction_of_power_input.

        Returns:
            float: the value of `speed_2_rated_waste_heat_fraction_of_power_input` or None if not set

        """
        return self["Speed 2 Rated Waste Heat Fraction of Power Input"]

    @speed_2_rated_waste_heat_fraction_of_power_input.setter
    def speed_2_rated_waste_heat_fraction_of_power_input(self, value=None):
        """Corresponds to IDD field `Speed 2 Rated Waste Heat Fraction of Power
        Input` Recoverable waste heat at full load and rated conditions.

        Args:
            value (float): value for IDD Field `Speed 2 Rated Waste Heat Fraction of Power Input`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 2 Rated Waste Heat Fraction of Power Input"] = value

    @property
    def speed_2_waste_heat_function_of_temperature_curve_name(self):
        """Get speed_2_waste_heat_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_2_waste_heat_function_of_temperature_curve_name` or None if not set

        """
        return self["Speed 2 Waste Heat Function of Temperature Curve Name"]

    @speed_2_waste_heat_function_of_temperature_curve_name.setter
    def speed_2_waste_heat_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 2 Waste Heat Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be used
        curve = a + b*odb + c*odb**2 + d*db + e*db**2 + f*odb*db
        odb = Outdoor air dry-bulb temperature (C)
        db = entering coil dry-bulb temperature (C)

        Args:
            value (str): value for IDD Field `Speed 2 Waste Heat Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 2 Waste Heat Function of Temperature Curve Name"] = value

    @property
    def speed_2_evaporative_condenser_effectiveness(self):
        """Get speed_2_evaporative_condenser_effectiveness.

        Returns:
            float: the value of `speed_2_evaporative_condenser_effectiveness` or None if not set

        """
        return self["Speed 2 Evaporative Condenser Effectiveness"]

    @speed_2_evaporative_condenser_effectiveness.setter
    def speed_2_evaporative_condenser_effectiveness(self, value=0.9):
        """Corresponds to IDD field `Speed 2 Evaporative Condenser
        Effectiveness`

        Args:
            value (float): value for IDD Field `Speed 2 Evaporative Condenser Effectiveness`
                Units: dimensionless
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 2 Evaporative Condenser Effectiveness"] = value

    @property
    def speed_2_evaporative_condenser_air_flow_rate(self):
        """Get speed_2_evaporative_condenser_air_flow_rate.

        Returns:
            float: the value of `speed_2_evaporative_condenser_air_flow_rate` or None if not set

        """
        return self["Speed 2 Evaporative Condenser Air Flow Rate"]

    @speed_2_evaporative_condenser_air_flow_rate.setter
    def speed_2_evaporative_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 2 Evaporative Condenser Air Flow
        Rate` Used to calculate evaporative condenser water use.

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 2 Evaporative Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 2 Evaporative Condenser Air Flow Rate"] = value

    @property
    def speed_2_rated_evaporative_condenser_pump_power_consumption(self):
        """Get speed_2_rated_evaporative_condenser_pump_power_consumption.

        Returns:
            float: the value of `speed_2_rated_evaporative_condenser_pump_power_consumption` or None if not set

        """
        return self[
            "Speed 2 Rated Evaporative Condenser Pump Power Consumption"]

    @speed_2_rated_evaporative_condenser_pump_power_consumption.setter
    def speed_2_rated_evaporative_condenser_pump_power_consumption(
            self,
            value=None):
        """Corresponds to IDD field `Speed 2 Rated Evaporative Condenser Pump
        Power Consumption` Rated power consumed by the evaporative condenser's
        water pump at low speed.

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 2 Rated Evaporative Condenser Pump Power Consumption`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 2 Rated Evaporative Condenser Pump Power Consumption"] = value

    @property
    def speed_3_gross_rated_total_cooling_capacity(self):
        """Get speed_3_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `speed_3_gross_rated_total_cooling_capacity` or None if not set

        """
        return self["Speed 3 Gross Rated Total Cooling Capacity"]

    @speed_3_gross_rated_total_cooling_capacity.setter
    def speed_3_gross_rated_total_cooling_capacity(self, value=None):
        """  Corresponds to IDD field `Speed 3 Gross Rated Total Cooling Capacity`
        Total cooling capacity not accounting for the effect of supply air fan heat
        Gross capacity excluding supply air fan heat
        Rating point: air entering the cooling coil at 26.7 C dry-bulb/19.4 C wet-bulb, and
        air entering the outdoor condenser coil at 35 C dry-bulb/23.9 C wet-bulb

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 3 Gross Rated Total Cooling Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 3 Gross Rated Total Cooling Capacity"] = value

    @property
    def speed_3_gross_rated_sensible_heat_ratio(self):
        """Get speed_3_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `speed_3_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Speed 3 Gross Rated Sensible Heat Ratio"]

    @speed_3_gross_rated_sensible_heat_ratio.setter
    def speed_3_gross_rated_sensible_heat_ratio(self, value=None):
        """Corresponds to IDD field `Speed 3 Gross Rated Sensible Heat Ratio`
        Gross Rated Sensible Heat Ratio (gross sensible capacity/gross total
        capacity) Sensible and total capacities do not include supply fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 3 Gross Rated Sensible Heat Ratio`
                value >= 0.5
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 3 Gross Rated Sensible Heat Ratio"] = value

    @property
    def speed_3_gross_rated_cooling_cop(self):
        """Get speed_3_gross_rated_cooling_cop.

        Returns:
            float: the value of `speed_3_gross_rated_cooling_cop` or None if not set

        """
        return self["Speed 3 Gross Rated Cooling COP"]

    @speed_3_gross_rated_cooling_cop.setter
    def speed_3_gross_rated_cooling_cop(self, value=3.0):
        """Corresponds to IDD field `Speed 3 Gross Rated Cooling COP` Gross
        cooling capacity divided by power input to the compressor and outdoor
        fan, does not include supply fan heat or supply fan electrical energy
        input.

        Args:
            value (float): value for IDD Field `Speed 3 Gross Rated Cooling COP`
                Units: W/W
                Default value: 3.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 3 Gross Rated Cooling COP"] = value

    @property
    def speed_3_rated_air_flow_rate(self):
        """Get speed_3_rated_air_flow_rate.

        Returns:
            float: the value of `speed_3_rated_air_flow_rate` or None if not set

        """
        return self["Speed 3 Rated Air Flow Rate"]

    @speed_3_rated_air_flow_rate.setter
    def speed_3_rated_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Speed 3 Rated Air Flow Rate`
        Flow rate corresponding to rated total cooling capacity, rated SHR and rated
        COP should be between 0.00004027 m3/s and .00006041 m3/s per watt of rated total
        cooling capacity for Speed 3.

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 3 Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 3 Rated Air Flow Rate"] = value

    @property
    def rated_evaporator_fan_power_per_volume_flow_rate_v4(self):
        """Get rated_evaporator_fan_power_per_volume_flow_rate_v4.

        Returns:
            float: the value of `rated_evaporator_fan_power_per_volume_flow_rate_v4` or None if not set

        """
        return self["Rated Evaporator Fan Power Per Volume Flow Rate v4"]

    @rated_evaporator_fan_power_per_volume_flow_rate_v4.setter
    def rated_evaporator_fan_power_per_volume_flow_rate_v4(self, value=773.3):
        """Corresponds to IDD field `Rated Evaporator Fan Power Per Volume Flow
        Rate v4` Enter the evaporator fan power per air volume flow rate at the
        rated test conditions. The test conditions vary external static
        pressure based on total cooling capacity. This value is only used to
        calculate Seasonal Energy Efficiency Ratio (SEER), and the Standard
        Rating (Net) Cooling Capacity which will be outputs in the EnergyPlus
        eio file. This value is not used for modeling the evaporator fan during
        simulations.

        Args:
            value (float): value for IDD Field `Rated Evaporator Fan Power Per Volume Flow Rate v4`
                Units: W/(m3/s)
                Default value: 773.3
                value <= 1250.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Rated Evaporator Fan Power Per Volume Flow Rate v4"] = value

    @property
    def speed_3_total_cooling_capacity_function_of_temperature_curve_name(
            self):
        """Get
        speed_3_total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_3_total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 3 Total Cooling Capacity Function of Temperature Curve Name"]

    @speed_3_total_cooling_capacity_function_of_temperature_curve_name.setter
    def speed_3_total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 3 Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be used
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 3 Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 3 Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_3_total_cooling_capacity_function_of_flow_fraction_curve_name(
            self):
        """Get
        speed_3_total_cooling_capacity_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_3_total_cooling_capacity_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 3 Total Cooling Capacity Function of Flow Fraction Curve Name"]

    @speed_3_total_cooling_capacity_function_of_flow_fraction_curve_name.setter
    def speed_3_total_cooling_capacity_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 3 Total Cooling Capacity Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Speed 3 Total Cooling Capacity Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 3 Total Cooling Capacity Function of Flow Fraction Curve Name"] = value

    @property
    def speed_3_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_3_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_3_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 3 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_3_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_3_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 3 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariable object can also be used
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 3 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 3 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_3_energy_input_ratio_function_of_flow_fraction_curve_name(self):
        """Get speed_3_energy_input_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_3_energy_input_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 3 Energy Input Ratio Function of Flow Fraction Curve Name"]

    @speed_3_energy_input_ratio_function_of_flow_fraction_curve_name.setter
    def speed_3_energy_input_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 3 Energy Input Ratio Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Speed 3 Energy Input Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 3 Energy Input Ratio Function of Flow Fraction Curve Name"] = value

    @property
    def speed_3_part_load_fraction_correlation_curve_name(self):
        """Get speed_3_part_load_fraction_correlation_curve_name.

        Returns:
            str: the value of `speed_3_part_load_fraction_correlation_curve_name` or None if not set

        """
        return self["Speed 3 Part Load Fraction Correlation Curve Name"]

    @speed_3_part_load_fraction_correlation_curve_name.setter
    def speed_3_part_load_fraction_correlation_curve_name(self, value=None):
        """  Corresponds to IDD field `Speed 3 Part Load Fraction Correlation Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*PLR + c*PLR**2
        cubic curve = a + b*PLR + c*PLR**2 + d*PLR**3
        PLR = part load ratio (Cooling load/steady state capacity)

        Args:
            value (str): value for IDD Field `Speed 3 Part Load Fraction Correlation Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 3 Part Load Fraction Correlation Curve Name"] = value

    @property
    def speed_3_nominal_time_for_condensate_removal_to_begin(self):
        """Get speed_3_nominal_time_for_condensate_removal_to_begin.

        Returns:
            float: the value of `speed_3_nominal_time_for_condensate_removal_to_begin` or None if not set

        """
        return self["Speed 3 Nominal Time for Condensate Removal to Begin"]

    @speed_3_nominal_time_for_condensate_removal_to_begin.setter
    def speed_3_nominal_time_for_condensate_removal_to_begin(self, value=None):
        """Corresponds to IDD field `Speed 3 Nominal Time for Condensate
        Removal to Begin` The nominal time for condensate to begin leaving the
        coil's condensate drain line at the coil's rated air flow rate and
        temperature conditions. Nominal time is equal to the ratio of the
        energy of the coil's maximum condensate holding capacity (J) to the
        coil's steady state latent capacity (W). Suggested value is 1000; zero
        value means latent degradation model is disabled.

        Args:
            value (float): value for IDD Field `Speed 3 Nominal Time for Condensate Removal to Begin`
                Units: s
                value <= 3000.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 3 Nominal Time for Condensate Removal to Begin"] = value

    @property
    def speed_3_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity(
            self):
        """Get speed_3_ratio_of_initial_moisture_evaporation_rate_and_steady_st
        ate_latent_capacity.

        Returns:
            float: the value of `speed_3_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity` or None if not set

        """
        return self[
            "Speed 3 Ratio of Initial Moisture Evaporation Rate and steady state Latent Capacity"]

    @speed_3_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity.setter
    def speed_3_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 3 Ratio of Initial Moisture Evaporation Rate and steady state Latent Capacity`
        Ratio of the initial moisture evaporation rate from the cooling coil (when
        the compressor first turns off) and the coil's steady state latent capacity
        at rated air flow and temperature conditions. Suggested value is 1.5; zero value
        means latent degradation model is disabled.

        Args:
            value (float): value for IDD Field `Speed 3 Ratio of Initial Moisture Evaporation Rate and steady state Latent Capacity`
                Units: dimensionless
                value <= 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 3 Ratio of Initial Moisture Evaporation Rate and steady state Latent Capacity"] = value

    @property
    def speed_3_maximum_cycling_rate(self):
        """Get speed_3_maximum_cycling_rate.

        Returns:
            float: the value of `speed_3_maximum_cycling_rate` or None if not set

        """
        return self["Speed 3 Maximum Cycling Rate"]

    @speed_3_maximum_cycling_rate.setter
    def speed_3_maximum_cycling_rate(self, value=None):
        """  Corresponds to IDD field `Speed 3 Maximum Cycling Rate`
        The maximum on-off cycling rate for the compressor, which occurs at 50% run time
        fraction. Suggested value is 3; zero value means latent degradation
        model is disabled.

        Args:
            value (float): value for IDD Field `Speed 3 Maximum Cycling Rate`
                Units: cycles/hr
                value <= 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 3 Maximum Cycling Rate"] = value

    @property
    def speed_3_latent_capacity_time_constant(self):
        """Get speed_3_latent_capacity_time_constant.

        Returns:
            float: the value of `speed_3_latent_capacity_time_constant` or None if not set

        """
        return self["Speed 3 Latent Capacity Time Constant"]

    @speed_3_latent_capacity_time_constant.setter
    def speed_3_latent_capacity_time_constant(self, value=None):
        """Corresponds to IDD field `Speed 3 Latent Capacity Time Constant`
        Time constant for the cooling coil's latent capacity to reach steady
        state after startup. Suggested value is 45; zero value means latent
        degradation model is disabled.

        Args:
            value (float): value for IDD Field `Speed 3 Latent Capacity Time Constant`
                Units: s
                value <= 500.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 3 Latent Capacity Time Constant"] = value

    @property
    def speed_3_rated_waste_heat_fraction_of_power_input(self):
        """Get speed_3_rated_waste_heat_fraction_of_power_input.

        Returns:
            float: the value of `speed_3_rated_waste_heat_fraction_of_power_input` or None if not set

        """
        return self["Speed 3 Rated Waste Heat Fraction of Power Input"]

    @speed_3_rated_waste_heat_fraction_of_power_input.setter
    def speed_3_rated_waste_heat_fraction_of_power_input(self, value=None):
        """Corresponds to IDD field `Speed 3 Rated Waste Heat Fraction of Power
        Input` Recoverable waste heat at full load and rated conditions.

        Args:
            value (float): value for IDD Field `Speed 3 Rated Waste Heat Fraction of Power Input`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 3 Rated Waste Heat Fraction of Power Input"] = value

    @property
    def speed_3_waste_heat_function_of_temperature_curve_name(self):
        """Get speed_3_waste_heat_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_3_waste_heat_function_of_temperature_curve_name` or None if not set

        """
        return self["Speed 3 Waste Heat Function of Temperature Curve Name"]

    @speed_3_waste_heat_function_of_temperature_curve_name.setter
    def speed_3_waste_heat_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 3 Waste Heat Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*odb + c*odb**2 + d*db + e*db**2 + f*odb*db
        odb = Outdoor air dry-bulb temperature (C)
        db = entering coil dry-bulb temperature (C)

        Args:
            value (str): value for IDD Field `Speed 3 Waste Heat Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 3 Waste Heat Function of Temperature Curve Name"] = value

    @property
    def speed_3_evaporative_condenser_effectiveness(self):
        """Get speed_3_evaporative_condenser_effectiveness.

        Returns:
            float: the value of `speed_3_evaporative_condenser_effectiveness` or None if not set

        """
        return self["Speed 3 Evaporative Condenser Effectiveness"]

    @speed_3_evaporative_condenser_effectiveness.setter
    def speed_3_evaporative_condenser_effectiveness(self, value=0.9):
        """Corresponds to IDD field `Speed 3 Evaporative Condenser
        Effectiveness`

        Args:
            value (float): value for IDD Field `Speed 3 Evaporative Condenser Effectiveness`
                Units: dimensionless
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 3 Evaporative Condenser Effectiveness"] = value

    @property
    def speed_3_evaporative_condenser_air_flow_rate(self):
        """Get speed_3_evaporative_condenser_air_flow_rate.

        Returns:
            float: the value of `speed_3_evaporative_condenser_air_flow_rate` or None if not set

        """
        return self["Speed 3 Evaporative Condenser Air Flow Rate"]

    @speed_3_evaporative_condenser_air_flow_rate.setter
    def speed_3_evaporative_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 3 Evaporative Condenser Air Flow
        Rate` Used to calculate evaporative condenser water use.

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 3 Evaporative Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 3 Evaporative Condenser Air Flow Rate"] = value

    @property
    def speed_3_rated_evaporative_condenser_pump_power_consumption(self):
        """Get speed_3_rated_evaporative_condenser_pump_power_consumption.

        Returns:
            float: the value of `speed_3_rated_evaporative_condenser_pump_power_consumption` or None if not set

        """
        return self[
            "Speed 3 Rated Evaporative Condenser Pump Power Consumption"]

    @speed_3_rated_evaporative_condenser_pump_power_consumption.setter
    def speed_3_rated_evaporative_condenser_pump_power_consumption(
            self,
            value=None):
        """Corresponds to IDD field `Speed 3 Rated Evaporative Condenser Pump
        Power Consumption` Rated power consumed by the evaporative condenser's
        water pump at Low speed.

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 3 Rated Evaporative Condenser Pump Power Consumption`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 3 Rated Evaporative Condenser Pump Power Consumption"] = value

    @property
    def speed_4_gross_rated_total_cooling_capacity(self):
        """Get speed_4_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `speed_4_gross_rated_total_cooling_capacity` or None if not set

        """
        return self["Speed 4 Gross Rated Total Cooling Capacity"]

    @speed_4_gross_rated_total_cooling_capacity.setter
    def speed_4_gross_rated_total_cooling_capacity(self, value=None):
        """  Corresponds to IDD field `Speed 4 Gross Rated Total Cooling Capacity`
        Total cooling capacity not accounting for the effect of supply air fan heat
        Gross capacity excluding supply air fan heat
        Rating point: air entering the cooling coil at 26.7 C dry-bulb/19.4 C wet-bulb, and
        air entering the outdoor condenser coil at 35 C dry-bulb/23.9 C wet-bulb

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 4 Gross Rated Total Cooling Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 4 Gross Rated Total Cooling Capacity"] = value

    @property
    def speed_4_gross_rated_sensible_heat_ratio(self):
        """Get speed_4_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `speed_4_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Speed 4 Gross Rated Sensible Heat Ratio"]

    @speed_4_gross_rated_sensible_heat_ratio.setter
    def speed_4_gross_rated_sensible_heat_ratio(self, value=None):
        """Corresponds to IDD field `Speed 4 Gross Rated Sensible Heat Ratio`
        Gross Rated Sensible Heat Ratio (gross sensible capacity/gross total
        capacity) Sensible and total capacities do not include supply fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 4 Gross Rated Sensible Heat Ratio`
                value >= 0.5
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 4 Gross Rated Sensible Heat Ratio"] = value

    @property
    def speed_4_gross_rated_cooling_cop(self):
        """Get speed_4_gross_rated_cooling_cop.

        Returns:
            float: the value of `speed_4_gross_rated_cooling_cop` or None if not set

        """
        return self["Speed 4 Gross Rated Cooling COP"]

    @speed_4_gross_rated_cooling_cop.setter
    def speed_4_gross_rated_cooling_cop(self, value=3.0):
        """Corresponds to IDD field `Speed 4 Gross Rated Cooling COP` Gross
        cooling capacity divided by power input to the compressor and outdoor
        fan, does not include supply fan heat or supply fan electrical energy
        input.

        Args:
            value (float): value for IDD Field `Speed 4 Gross Rated Cooling COP`
                Units: W/W
                Default value: 3.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 4 Gross Rated Cooling COP"] = value

    @property
    def speed_4_rated_air_flow_rate(self):
        """Get speed_4_rated_air_flow_rate.

        Returns:
            float: the value of `speed_4_rated_air_flow_rate` or None if not set

        """
        return self["Speed 4 Rated Air Flow Rate"]

    @speed_4_rated_air_flow_rate.setter
    def speed_4_rated_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Speed 4 Rated Air Flow Rate`
        Flow rate corresponding to rated total cooling capacity, rated SHR and rated
        COP should be between 0.00004027 m3/s and .00006041 m3/s per watt of rated total
        cooling capacity for Speed 4

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 4 Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 4 Rated Air Flow Rate"] = value

    @property
    def rated_evaporator_fan_power_per_volume_flow_rate_v5(self):
        """Get rated_evaporator_fan_power_per_volume_flow_rate_v5.

        Returns:
            float: the value of `rated_evaporator_fan_power_per_volume_flow_rate_v5` or None if not set

        """
        return self["Rated Evaporator Fan Power Per Volume Flow Rate v5"]

    @rated_evaporator_fan_power_per_volume_flow_rate_v5.setter
    def rated_evaporator_fan_power_per_volume_flow_rate_v5(self, value=773.3):
        """Corresponds to IDD field `Rated Evaporator Fan Power Per Volume Flow
        Rate v5` Enter the evaporator fan power per air volume flow rate at the
        rated test conditions. The test conditions vary external static
        pressure based on total cooling capacity. This value is only used to
        calculate Seasonal Energy Efficiency Ratio (SEER), and the Standard
        Rating (Net) Cooling Capacity which will be outputs in the EnergyPlus
        eio file. This value is not used for modeling the evaporator fan during
        simulations.

        Args:
            value (float): value for IDD Field `Rated Evaporator Fan Power Per Volume Flow Rate v5`
                Units: W/(m3/s)
                Default value: 773.3
                value <= 1250.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Rated Evaporator Fan Power Per Volume Flow Rate v5"] = value

    @property
    def speed_4_total_cooling_capacity_function_of_temperature_curve_name(
            self):
        """Get
        speed_4_total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_4_total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 4 Total Cooling Capacity Function of Temperature Curve Name"]

    @speed_4_total_cooling_capacity_function_of_temperature_curve_name.setter
    def speed_4_total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 4 Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 4 Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 4 Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_4_total_cooling_capacity_function_of_flow_fraction_curve_name(
            self):
        """Get
        speed_4_total_cooling_capacity_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_4_total_cooling_capacity_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 4 Total Cooling Capacity Function of Flow Fraction Curve Name"]

    @speed_4_total_cooling_capacity_function_of_flow_fraction_curve_name.setter
    def speed_4_total_cooling_capacity_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 4 Total Cooling Capacity Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Speed 4 Total Cooling Capacity Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 4 Total Cooling Capacity Function of Flow Fraction Curve Name"] = value

    @property
    def speed_4_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_4_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_4_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 4 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_4_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_4_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 4 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 4 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 4 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_4_energy_input_ratio_function_of_flow_fraction_curve_name(self):
        """Get speed_4_energy_input_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_4_energy_input_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 4 Energy Input Ratio Function of Flow Fraction Curve Name"]

    @speed_4_energy_input_ratio_function_of_flow_fraction_curve_name.setter
    def speed_4_energy_input_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 4 Energy Input Ratio Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Speed 4 Energy Input Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 4 Energy Input Ratio Function of Flow Fraction Curve Name"] = value

    @property
    def speed_4_part_load_fraction_correlation_curve_name(self):
        """Get speed_4_part_load_fraction_correlation_curve_name.

        Returns:
            str: the value of `speed_4_part_load_fraction_correlation_curve_name` or None if not set

        """
        return self["Speed 4 Part Load Fraction Correlation Curve Name"]

    @speed_4_part_load_fraction_correlation_curve_name.setter
    def speed_4_part_load_fraction_correlation_curve_name(self, value=None):
        """  Corresponds to IDD field `Speed 4 Part Load Fraction Correlation Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*PLR + c*PLR**2
        cubic curve = a + b*PLR + c*PLR**2 + d*PLR**3
        PLR = part load ratio (cooling load/steady state capacity)

        Args:
            value (str): value for IDD Field `Speed 4 Part Load Fraction Correlation Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 4 Part Load Fraction Correlation Curve Name"] = value

    @property
    def speed_4_nominal_time_for_condensate_removal_to_begin(self):
        """Get speed_4_nominal_time_for_condensate_removal_to_begin.

        Returns:
            float: the value of `speed_4_nominal_time_for_condensate_removal_to_begin` or None if not set

        """
        return self["Speed 4 Nominal Time for Condensate Removal to Begin"]

    @speed_4_nominal_time_for_condensate_removal_to_begin.setter
    def speed_4_nominal_time_for_condensate_removal_to_begin(self, value=None):
        """Corresponds to IDD field `Speed 4 Nominal Time for Condensate
        Removal to Begin` The nominal time for condensate to begin leaving the
        coil's condensate drain line at the coil's rated air flow rate and
        temperature conditions. Nominal time is equal to the ratio of the
        energy of the coil's maximum condensate holding capacity (J) to the
        coil's steady state latent capacity (W). Suggested value is 1000; zero
        value means latent degradation model is disabled.

        Args:
            value (float): value for IDD Field `Speed 4 Nominal Time for Condensate Removal to Begin`
                Units: s
                value <= 3000.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 4 Nominal Time for Condensate Removal to Begin"] = value

    @property
    def speed_4_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity(
            self):
        """Get speed_4_ratio_of_initial_moisture_evaporation_rate_and_steady_st
        ate_latent_capacity.

        Returns:
            float: the value of `speed_4_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity` or None if not set

        """
        return self[
            "Speed 4 Ratio of Initial Moisture Evaporation Rate and steady state Latent Capacity"]

    @speed_4_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity.setter
    def speed_4_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 4 Ratio of Initial Moisture Evaporation Rate and steady state Latent Capacity`
        Ratio of the initial moisture evaporation rate from the cooling coil (when
        the compressor first turns off) and the coil's steady state latent capacity
        at rated air flow rate and temperature conditions. Suggested value is 1.5; zero value
        means latent degradation model is disabled.

        Args:
            value (float): value for IDD Field `Speed 4 Ratio of Initial Moisture Evaporation Rate and steady state Latent Capacity`
                Units: dimensionless
                value <= 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 4 Ratio of Initial Moisture Evaporation Rate and steady state Latent Capacity"] = value

    @property
    def speed_4_maximum_cycling_rate(self):
        """Get speed_4_maximum_cycling_rate.

        Returns:
            float: the value of `speed_4_maximum_cycling_rate` or None if not set

        """
        return self["Speed 4 Maximum Cycling Rate"]

    @speed_4_maximum_cycling_rate.setter
    def speed_4_maximum_cycling_rate(self, value=None):
        """  Corresponds to IDD field `Speed 4 Maximum Cycling Rate`
        The maximum on-off cycling rate for the compressor, which occurs at 50% run time
        fraction. Suggested value is 3; zero value means latent degradation
        model is disabled.

        Args:
            value (float): value for IDD Field `Speed 4 Maximum Cycling Rate`
                Units: cycles/hr
                value <= 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 4 Maximum Cycling Rate"] = value

    @property
    def speed_4_latent_capacity_time_constant(self):
        """Get speed_4_latent_capacity_time_constant.

        Returns:
            float: the value of `speed_4_latent_capacity_time_constant` or None if not set

        """
        return self["Speed 4 Latent Capacity Time Constant"]

    @speed_4_latent_capacity_time_constant.setter
    def speed_4_latent_capacity_time_constant(self, value=None):
        """Corresponds to IDD field `Speed 4 Latent Capacity Time Constant`
        Time constant for the cooling coil's latent capacity to reach steady
        state after startup. Suggested value is 45; zero value means latent
        degradation model is disabled.

        Args:
            value (float): value for IDD Field `Speed 4 Latent Capacity Time Constant`
                Units: s
                value <= 500.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 4 Latent Capacity Time Constant"] = value

    @property
    def speed_4_rated_waste_heat_fraction_of_power_input(self):
        """Get speed_4_rated_waste_heat_fraction_of_power_input.

        Returns:
            float: the value of `speed_4_rated_waste_heat_fraction_of_power_input` or None if not set

        """
        return self["Speed 4 Rated Waste Heat Fraction of Power Input"]

    @speed_4_rated_waste_heat_fraction_of_power_input.setter
    def speed_4_rated_waste_heat_fraction_of_power_input(self, value=None):
        """Corresponds to IDD field `Speed 4 Rated Waste Heat Fraction of Power
        Input` Recoverable waste heat at full load and rated conditions.

        Args:
            value (float): value for IDD Field `Speed 4 Rated Waste Heat Fraction of Power Input`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 4 Rated Waste Heat Fraction of Power Input"] = value

    @property
    def speed_4_waste_heat_function_of_temperature_curve_name(self):
        """Get speed_4_waste_heat_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_4_waste_heat_function_of_temperature_curve_name` or None if not set

        """
        return self["Speed 4 Waste Heat Function of Temperature Curve Name"]

    @speed_4_waste_heat_function_of_temperature_curve_name.setter
    def speed_4_waste_heat_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 4 Waste Heat Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*odb + c*odb**2 + d*db + e*db**2 + f*odb*db
        odb = Outdoor air dry-bulb temperature (C)
        db = entering coil dry-bulb temperature (C)

        Args:
            value (str): value for IDD Field `Speed 4 Waste Heat Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 4 Waste Heat Function of Temperature Curve Name"] = value

    @property
    def speed_4_evaporative_condenser_effectiveness(self):
        """Get speed_4_evaporative_condenser_effectiveness.

        Returns:
            float: the value of `speed_4_evaporative_condenser_effectiveness` or None if not set

        """
        return self["Speed 4 Evaporative Condenser Effectiveness"]

    @speed_4_evaporative_condenser_effectiveness.setter
    def speed_4_evaporative_condenser_effectiveness(self, value=0.9):
        """Corresponds to IDD field `Speed 4 Evaporative Condenser
        Effectiveness`

        Args:
            value (float): value for IDD Field `Speed 4 Evaporative Condenser Effectiveness`
                Units: dimensionless
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 4 Evaporative Condenser Effectiveness"] = value

    @property
    def speed_4_evaporative_condenser_air_flow_rate(self):
        """Get speed_4_evaporative_condenser_air_flow_rate.

        Returns:
            float: the value of `speed_4_evaporative_condenser_air_flow_rate` or None if not set

        """
        return self["Speed 4 Evaporative Condenser Air Flow Rate"]

    @speed_4_evaporative_condenser_air_flow_rate.setter
    def speed_4_evaporative_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 4 Evaporative Condenser Air Flow
        Rate` Used to calculate evaporative condenser water use.

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 4 Evaporative Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 4 Evaporative Condenser Air Flow Rate"] = value

    @property
    def speed_4_rated_evaporative_condenser_pump_power_consumption(self):
        """Get speed_4_rated_evaporative_condenser_pump_power_consumption.

        Returns:
            float: the value of `speed_4_rated_evaporative_condenser_pump_power_consumption` or None if not set

        """
        return self[
            "Speed 4 Rated Evaporative Condenser Pump Power Consumption"]

    @speed_4_rated_evaporative_condenser_pump_power_consumption.setter
    def speed_4_rated_evaporative_condenser_pump_power_consumption(
            self,
            value=None):
        """Corresponds to IDD field `Speed 4 Rated Evaporative Condenser Pump
        Power Consumption` Rated power consumed by the evaporative condenser's
        water pump at Speed 4.

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 4 Rated Evaporative Condenser Pump Power Consumption`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 4 Rated Evaporative Condenser Pump Power Consumption"] = value




class CoilCoolingDxVariableSpeed(DataObject):

    """ Corresponds to IDD object `Coil:Cooling:DX:VariableSpeed`
        Direct expansion (DX) cooling coil and condensing unit (includes electric compressor
        and condenser fan), variable-speed. Optional inputs for moisture evaporation from
        wet coil when compressor cycles off with continuous fan operation. Requires two to
        ten sets of performance data and will interpolate between speeds. Modeled as a
        single coil with variable-speed compressor.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'indoor air inlet node name',
                                      {'name': u'Indoor Air Inlet Node Name',
                                       'pyname': u'indoor_air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'indoor air outlet node name',
                                      {'name': u'Indoor Air Outlet Node Name',
                                       'pyname': u'indoor_air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'number of speeds',
                                      {'name': u'Number of Speeds',
                                       'pyname': u'number_of_speeds',
                                       'default': 2,
                                       'maximum': 10,
                                       'required-field': True,
                                       'autosizable': False,
                                       'minimum': 1,
                                       'autocalculatable': False,
                                       'type': u'integer',
                                       'unit': u'dimensionless'}),
                                     (u'nominal speed level',
                                      {'name': u'Nominal Speed Level',
                                       'pyname': u'nominal_speed_level',
                                       'default': 2,
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'integer',
                                       'unit': u'dimensionless'}),
                                     (u'gross rated total cooling capacity at selected nominal speed level',
                                      {'name': u'Gross Rated Total Cooling Capacity At Selected Nominal Speed Level',
                                       'pyname': u'gross_rated_total_cooling_capacity_at_selected_nominal_speed_level',
                                       'default': 'autosize',
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'rated air flow rate at selected nominal speed level',
                                      {'name': u'Rated Air Flow Rate At Selected Nominal Speed Level',
                                       'pyname': u'rated_air_flow_rate_at_selected_nominal_speed_level',
                                       'default': 'autosize',
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'nominal time for condensate to begin leaving the coil',
                                      {'name': u'Nominal Time for Condensate to Begin Leaving the Coil',
                                       'pyname': u'nominal_time_for_condensate_to_begin_leaving_the_coil',
                                       'default': 0.0,
                                       'required-field': True,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u's'}),
                                     (u'initial moisture evaporation rate divided by steady-state ac latent capacity',
                                      {'name': u'Initial Moisture Evaporation Rate Divided by Steady-State AC Latent Capacity',
                                       'pyname': u'initial_moisture_evaporation_rate_divided_by_steadystate_ac_latent_capacity',
                                       'default': 0.0,
                                       'required-field': True,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'energy part load fraction curve name',
                                      {'name': u'Energy Part Load Fraction Curve Name',
                                       'pyname': u'energy_part_load_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'condenser air inlet node name',
                                      {'name': u'Condenser Air Inlet Node Name',
                                       'pyname': u'condenser_air_inlet_node_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'condenser type',
                                      {'name': u'Condenser Type',
                                       'pyname': u'condenser_type',
                                       'default': u'AirCooled',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'AirCooled',
                                                           u'EvaporativelyCooled'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'evaporative condenser pump rated power consumption',
                                      {'name': u'Evaporative Condenser Pump Rated Power Consumption',
                                       'pyname': u'evaporative_condenser_pump_rated_power_consumption',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'crankcase heater capacity',
                                      {'name': u'Crankcase Heater Capacity',
                                       'pyname': u'crankcase_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'maximum outdoor dry-bulb temperature for crankcase heater operation',
                                      {'name': u'Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation',
                                       'pyname': u'maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation',
                                       'default': 10.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'supply water storage tank name',
                                      {'name': u'Supply Water Storage Tank Name',
                                       'pyname': u'supply_water_storage_tank_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'condensate collection water storage tank name',
                                      {'name': u'Condensate Collection Water Storage Tank Name',
                                       'pyname': u'condensate_collection_water_storage_tank_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'basin heater capacity',
                                      {'name': u'Basin Heater Capacity',
                                       'pyname': u'basin_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/K'}),
                                     (u'basin heater setpoint temperature',
                                      {'name': u'Basin Heater Setpoint Temperature',
                                       'pyname': u'basin_heater_setpoint_temperature',
                                       'default': 2.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 2.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'basin heater operating schedule name',
                                      {'name': u'Basin Heater Operating Schedule Name',
                                       'pyname': u'basin_heater_operating_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 reference unit gross rated total cooling capacity',
                                      {'name': u'Speed 1 Reference Unit Gross Rated Total Cooling Capacity',
                                       'pyname': u'speed_1_reference_unit_gross_rated_total_cooling_capacity',
                                       'required-field': True,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 1 reference unit gross rated sensible heat ratio',
                                      {'name': u'Speed 1 Reference Unit Gross Rated Sensible Heat Ratio',
                                       'pyname': u'speed_1_reference_unit_gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': True,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 1 reference unit gross rated cooling cop',
                                      {'name': u'Speed 1 Reference Unit Gross Rated Cooling COP',
                                       'pyname': u'speed_1_reference_unit_gross_rated_cooling_cop',
                                       'required-field': True,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 1 reference unit rated air flow rate',
                                      {'name': u'Speed 1 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_1_reference_unit_rated_air_flow_rate',
                                       'required-field': True,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 1 reference unit rated condenser air flow rate',
                                      {'name': u'Speed 1 Reference Unit Rated Condenser Air Flow Rate',
                                       'pyname': u'speed_1_reference_unit_rated_condenser_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 1 reference unit rated pad effectiveness of evap precooling',
                                      {'name': u'Speed 1 Reference Unit Rated Pad Effectiveness of Evap Precooling',
                                       'pyname': u'speed_1_reference_unit_rated_pad_effectiveness_of_evap_precooling',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 1 total cooling capacity function of temperature curve name',
                                      {'name': u'Speed 1 Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_1_total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 total cooling capacity function of air flow fraction curve name',
                                      {'name': u'Speed 1 Total Cooling Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_1_total_cooling_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 1 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_1_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 1 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_1_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 reference unit gross rated total cooling capacity',
                                      {'name': u'Speed 2 Reference Unit Gross Rated Total Cooling Capacity',
                                       'pyname': u'speed_2_reference_unit_gross_rated_total_cooling_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 2 reference unit gross rated sensible heat ratio',
                                      {'name': u'Speed 2 Reference Unit Gross Rated Sensible Heat Ratio',
                                       'pyname': u'speed_2_reference_unit_gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 2 reference unit gross rated cooling cop',
                                      {'name': u'Speed 2 Reference Unit Gross Rated Cooling COP',
                                       'pyname': u'speed_2_reference_unit_gross_rated_cooling_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 2 reference unit rated air flow rate',
                                      {'name': u'Speed 2 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_2_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 2 reference unit rated condenser air flow rate',
                                      {'name': u'Speed 2 Reference Unit Rated Condenser Air Flow Rate',
                                       'pyname': u'speed_2_reference_unit_rated_condenser_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 2 reference unit rated pad effectiveness of evap precooling',
                                      {'name': u'Speed 2 Reference Unit Rated Pad Effectiveness of Evap Precooling',
                                       'pyname': u'speed_2_reference_unit_rated_pad_effectiveness_of_evap_precooling',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 2 total cooling capacity function of temperature curve name',
                                      {'name': u'Speed 2 Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_2_total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 total cooling capacity function of air flow fraction curve name',
                                      {'name': u'Speed 2 Total Cooling Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_2_total_cooling_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 2 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_2_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 2 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_2_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 reference unit gross rated total cooling capacity',
                                      {'name': u'Speed 3 Reference Unit Gross Rated Total Cooling Capacity',
                                       'pyname': u'speed_3_reference_unit_gross_rated_total_cooling_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 3 reference unit gross rated sensible heat ratio',
                                      {'name': u'Speed 3 Reference Unit Gross Rated Sensible Heat Ratio',
                                       'pyname': u'speed_3_reference_unit_gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 3 reference unit gross rated cooling cop',
                                      {'name': u'Speed 3 Reference Unit Gross Rated Cooling COP',
                                       'pyname': u'speed_3_reference_unit_gross_rated_cooling_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 3 reference unit rated air flow rate',
                                      {'name': u'Speed 3 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_3_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 3 reference unit rated condenser air flow rate',
                                      {'name': u'Speed 3 Reference Unit Rated Condenser Air Flow Rate',
                                       'pyname': u'speed_3_reference_unit_rated_condenser_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 3 reference unit rated pad effectiveness of evap precooling',
                                      {'name': u'Speed 3 Reference Unit Rated Pad Effectiveness of Evap Precooling',
                                       'pyname': u'speed_3_reference_unit_rated_pad_effectiveness_of_evap_precooling',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 3 total cooling capacity function of temperature curve name',
                                      {'name': u'Speed 3 Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_3_total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 total cooling capacity function of air flow fraction curve name',
                                      {'name': u'Speed 3 Total Cooling Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_3_total_cooling_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 3 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_3_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 3 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_3_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 reference unit gross rated total cooling capacity',
                                      {'name': u'Speed 4 Reference Unit Gross Rated Total Cooling Capacity',
                                       'pyname': u'speed_4_reference_unit_gross_rated_total_cooling_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 4 reference unit gross rated sensible heat ratio',
                                      {'name': u'Speed 4 Reference Unit Gross Rated Sensible Heat Ratio',
                                       'pyname': u'speed_4_reference_unit_gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 4 reference unit gross rated cooling cop',
                                      {'name': u'Speed 4 Reference Unit Gross Rated Cooling COP',
                                       'pyname': u'speed_4_reference_unit_gross_rated_cooling_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 4 reference unit rated air flow rate',
                                      {'name': u'Speed 4 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_4_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 4 reference unit rated condenser air flow rate',
                                      {'name': u'Speed 4 Reference Unit Rated Condenser Air Flow Rate',
                                       'pyname': u'speed_4_reference_unit_rated_condenser_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 4 reference unit rated pad effectiveness of evap precooling',
                                      {'name': u'Speed 4 Reference Unit Rated Pad Effectiveness of Evap Precooling',
                                       'pyname': u'speed_4_reference_unit_rated_pad_effectiveness_of_evap_precooling',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 4 total cooling capacity function of temperature curve name',
                                      {'name': u'Speed 4 Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_4_total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 total cooling capacity function of air flow fraction curve name',
                                      {'name': u'Speed 4 Total Cooling Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_4_total_cooling_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 4 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_4_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 4 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_4_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 5 reference unit gross rated total cooling capacity',
                                      {'name': u'Speed 5 Reference Unit Gross Rated Total Cooling Capacity',
                                       'pyname': u'speed_5_reference_unit_gross_rated_total_cooling_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 5 reference unit gross rated sensible heat ratio',
                                      {'name': u'Speed 5 Reference Unit Gross Rated Sensible Heat Ratio',
                                       'pyname': u'speed_5_reference_unit_gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 5 reference unit gross rated cooling cop',
                                      {'name': u'Speed 5 Reference Unit Gross Rated Cooling COP',
                                       'pyname': u'speed_5_reference_unit_gross_rated_cooling_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 5 reference unit rated air flow rate',
                                      {'name': u'Speed 5 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_5_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 5 reference unit rated condenser air flow rate',
                                      {'name': u'Speed 5 Reference Unit Rated Condenser Air Flow Rate',
                                       'pyname': u'speed_5_reference_unit_rated_condenser_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 5 reference unit rated pad effectiveness of evap precooling',
                                      {'name': u'Speed 5 Reference Unit Rated Pad Effectiveness of Evap Precooling',
                                       'pyname': u'speed_5_reference_unit_rated_pad_effectiveness_of_evap_precooling',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 5 total cooling capacity function of temperature curve name',
                                      {'name': u'Speed 5 Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_5_total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 5 total cooling capacity function of air flow fraction curve name',
                                      {'name': u'Speed 5 Total Cooling Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_5_total_cooling_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 5 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 5 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_5_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 5 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 5 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_5_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 6 reference unit gross rated total cooling capacity',
                                      {'name': u'Speed 6 Reference Unit Gross Rated Total Cooling Capacity',
                                       'pyname': u'speed_6_reference_unit_gross_rated_total_cooling_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 6 reference unit gross rated sensible heat ratio',
                                      {'name': u'Speed 6 Reference Unit Gross Rated Sensible Heat Ratio',
                                       'pyname': u'speed_6_reference_unit_gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 6 reference unit gross rated cooling cop',
                                      {'name': u'Speed 6 Reference Unit Gross Rated Cooling COP',
                                       'pyname': u'speed_6_reference_unit_gross_rated_cooling_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 6 reference unit rated air flow rate',
                                      {'name': u'Speed 6 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_6_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 6 reference unit condenser air flow rate',
                                      {'name': u'Speed 6 Reference Unit Condenser Air Flow Rate',
                                       'pyname': u'speed_6_reference_unit_condenser_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 6 reference unit rated pad effectiveness of evap precooling',
                                      {'name': u'Speed 6 Reference Unit Rated Pad Effectiveness of Evap Precooling',
                                       'pyname': u'speed_6_reference_unit_rated_pad_effectiveness_of_evap_precooling',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 6 total cooling capacity function of temperature curve name',
                                      {'name': u'Speed 6 Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_6_total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 6 total cooling capacity function of air flow fraction curve name',
                                      {'name': u'Speed 6 Total Cooling Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_6_total_cooling_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 6 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 6 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_6_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 6 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 6 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_6_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 7 reference unit gross rated total cooling capacity',
                                      {'name': u'Speed 7 Reference Unit Gross Rated Total Cooling Capacity',
                                       'pyname': u'speed_7_reference_unit_gross_rated_total_cooling_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 7 reference unit gross rated sensible heat ratio',
                                      {'name': u'Speed 7 Reference Unit Gross Rated Sensible Heat Ratio',
                                       'pyname': u'speed_7_reference_unit_gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 7 reference unit gross rated cooling cop',
                                      {'name': u'Speed 7 Reference Unit Gross Rated Cooling COP',
                                       'pyname': u'speed_7_reference_unit_gross_rated_cooling_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 7 reference unit rated air flow rate',
                                      {'name': u'Speed 7 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_7_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 7 reference unit condenser flow rate',
                                      {'name': u'Speed 7 Reference Unit Condenser Flow Rate',
                                       'pyname': u'speed_7_reference_unit_condenser_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 7 reference unit rated pad effectiveness of evap precooling',
                                      {'name': u'Speed 7 Reference Unit Rated Pad Effectiveness of Evap Precooling',
                                       'pyname': u'speed_7_reference_unit_rated_pad_effectiveness_of_evap_precooling',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 7 total cooling capacity function of temperature curve name',
                                      {'name': u'Speed 7 Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_7_total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 7 total cooling capacity function of air flow fraction curve name',
                                      {'name': u'Speed 7 Total Cooling Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_7_total_cooling_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 7 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 7 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_7_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 7 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 7 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_7_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 8 reference unit gross rated total cooling capacity',
                                      {'name': u'Speed 8 Reference Unit Gross Rated Total Cooling Capacity',
                                       'pyname': u'speed_8_reference_unit_gross_rated_total_cooling_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 8 reference unit gross rated sensible heat ratio',
                                      {'name': u'Speed 8 Reference Unit Gross Rated Sensible Heat Ratio',
                                       'pyname': u'speed_8_reference_unit_gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 8 reference unit gross rated cooling cop',
                                      {'name': u'Speed 8 Reference Unit Gross Rated Cooling COP',
                                       'pyname': u'speed_8_reference_unit_gross_rated_cooling_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 8 reference unit rated air flow rate',
                                      {'name': u'Speed 8 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_8_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 8 reference unit condenser air flow rate',
                                      {'name': u'Speed 8 Reference Unit Condenser Air Flow Rate',
                                       'pyname': u'speed_8_reference_unit_condenser_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 8 reference unit rated pad effectiveness of evap precooling',
                                      {'name': u'Speed 8 Reference Unit Rated Pad Effectiveness of Evap Precooling',
                                       'pyname': u'speed_8_reference_unit_rated_pad_effectiveness_of_evap_precooling',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 8 total cooling capacity function of temperature curve name',
                                      {'name': u'Speed 8 Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_8_total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 8 total cooling capacity function of air flow fraction curve name',
                                      {'name': u'Speed 8 Total Cooling Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_8_total_cooling_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 8 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 8 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_8_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 8 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 8 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_8_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 9 reference unit gross rated total cooling capacity',
                                      {'name': u'Speed 9 Reference Unit Gross Rated Total Cooling Capacity',
                                       'pyname': u'speed_9_reference_unit_gross_rated_total_cooling_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 9 reference unit gross rated sensible heat ratio',
                                      {'name': u'Speed 9 Reference Unit Gross Rated Sensible Heat Ratio',
                                       'pyname': u'speed_9_reference_unit_gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 9 reference unit gross rated cooling cop',
                                      {'name': u'Speed 9 Reference Unit Gross Rated Cooling COP',
                                       'pyname': u'speed_9_reference_unit_gross_rated_cooling_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 9 reference unit rated air flow rate',
                                      {'name': u'Speed 9 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_9_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 9 reference unit condenser air flow rate',
                                      {'name': u'Speed 9 Reference Unit Condenser Air Flow Rate',
                                       'pyname': u'speed_9_reference_unit_condenser_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 9 reference unit rated pad effectiveness of evap precooling',
                                      {'name': u'Speed 9 Reference Unit Rated Pad Effectiveness of Evap Precooling',
                                       'pyname': u'speed_9_reference_unit_rated_pad_effectiveness_of_evap_precooling',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 9 total cooling capacity function of temperature curve name',
                                      {'name': u'Speed 9 Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_9_total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 9 total cooling capacity function of air flow fraction curve name',
                                      {'name': u'Speed 9 Total Cooling Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_9_total_cooling_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 9 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 9 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_9_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 9 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 9 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_9_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 10 reference unit gross rated total cooling capacity',
                                      {'name': u'Speed 10 Reference Unit Gross Rated Total Cooling Capacity',
                                       'pyname': u'speed_10_reference_unit_gross_rated_total_cooling_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 10 reference unit gross rated sensible heat ratio',
                                      {'name': u'Speed 10 Reference Unit Gross Rated Sensible Heat Ratio',
                                       'pyname': u'speed_10_reference_unit_gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 10 reference unit gross rated cooling cop',
                                      {'name': u'Speed 10 Reference Unit Gross Rated Cooling COP',
                                       'pyname': u'speed_10_reference_unit_gross_rated_cooling_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 10 reference unit rated air flow rate',
                                      {'name': u'Speed 10 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_10_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 10 reference unit condenser air flow rate',
                                      {'name': u'Speed 10 Reference Unit Condenser Air Flow Rate',
                                       'pyname': u'speed_10_reference_unit_condenser_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 10 reference unit rated pad effectiveness of evap precooling',
                                      {'name': u'Speed 10 Reference Unit Rated Pad Effectiveness of Evap Precooling',
                                       'pyname': u'speed_10_reference_unit_rated_pad_effectiveness_of_evap_precooling',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 10 total cooling capacity function of temperature curve name',
                                      {'name': u'Speed 10 Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_10_total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 10 total cooling capacity function of air flow fraction curve name',
                                      {'name': u'Speed 10 Total Cooling Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_10_total_cooling_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 10 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 10 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_10_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 10 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 10 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_10_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 0,
              'name': u'Coil:Cooling:DX:VariableSpeed',
              'pyname': u'CoilCoolingDxVariableSpeed',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def indoor_air_inlet_node_name(self):
        """Get indoor_air_inlet_node_name.

        Returns:
            str: the value of `indoor_air_inlet_node_name` or None if not set

        """
        return self["Indoor Air Inlet Node Name"]

    @indoor_air_inlet_node_name.setter
    def indoor_air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Indoor Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Indoor Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Indoor Air Inlet Node Name"] = value

    @property
    def indoor_air_outlet_node_name(self):
        """Get indoor_air_outlet_node_name.

        Returns:
            str: the value of `indoor_air_outlet_node_name` or None if not set

        """
        return self["Indoor Air Outlet Node Name"]

    @indoor_air_outlet_node_name.setter
    def indoor_air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Indoor Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Indoor Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Indoor Air Outlet Node Name"] = value

    @property
    def number_of_speeds(self):
        """Get number_of_speeds.

        Returns:
            int: the value of `number_of_speeds` or None if not set

        """
        return self["Number of Speeds"]

    @number_of_speeds.setter
    def number_of_speeds(self, value=2):
        """Corresponds to IDD field `Number of Speeds`

        Args:
            value (int): value for IDD Field `Number of Speeds`
                Units: dimensionless
                Default value: 2
                value >= 1
                value <= 10
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Number of Speeds"] = value

    @property
    def nominal_speed_level(self):
        """Get nominal_speed_level.

        Returns:
            int: the value of `nominal_speed_level` or None if not set

        """
        return self["Nominal Speed Level"]

    @nominal_speed_level.setter
    def nominal_speed_level(self, value=2):
        """Corresponds to IDD field `Nominal Speed Level` must be lower than or
        equal to the highest speed number.

        Args:
            value (int): value for IDD Field `Nominal Speed Level`
                Units: dimensionless
                Default value: 2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Nominal Speed Level"] = value

    @property
    def gross_rated_total_cooling_capacity_at_selected_nominal_speed_level(
            self):
        """Get
        gross_rated_total_cooling_capacity_at_selected_nominal_speed_level.

        Returns:
            float: the value of `gross_rated_total_cooling_capacity_at_selected_nominal_speed_level` or None if not set

        """
        return self[
            "Gross Rated Total Cooling Capacity At Selected Nominal Speed Level"]

    @gross_rated_total_cooling_capacity_at_selected_nominal_speed_level.setter
    def gross_rated_total_cooling_capacity_at_selected_nominal_speed_level(
            self,
            value="autosize"):
        """Corresponds to IDD field `Gross Rated Total Cooling Capacity At
        Selected Nominal Speed Level` Total cooling capacity not accounting for
        the effect of supply air fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Gross Rated Total Cooling Capacity At Selected Nominal Speed Level`
                Units: w
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Gross Rated Total Cooling Capacity At Selected Nominal Speed Level"] = value

    @property
    def rated_air_flow_rate_at_selected_nominal_speed_level(self):
        """Get rated_air_flow_rate_at_selected_nominal_speed_level.

        Returns:
            float: the value of `rated_air_flow_rate_at_selected_nominal_speed_level` or None if not set

        """
        return self["Rated Air Flow Rate At Selected Nominal Speed Level"]

    @rated_air_flow_rate_at_selected_nominal_speed_level.setter
    def rated_air_flow_rate_at_selected_nominal_speed_level(
            self,
            value="autosize"):
        """Corresponds to IDD field `Rated Air Flow Rate At Selected Nominal
        Speed Level`

        Args:
            value (float or "Autosize"): value for IDD Field `Rated Air Flow Rate At Selected Nominal Speed Level`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Rated Air Flow Rate At Selected Nominal Speed Level"] = value

    @property
    def nominal_time_for_condensate_to_begin_leaving_the_coil(self):
        """Get nominal_time_for_condensate_to_begin_leaving_the_coil.

        Returns:
            float: the value of `nominal_time_for_condensate_to_begin_leaving_the_coil` or None if not set

        """
        return self["Nominal Time for Condensate to Begin Leaving the Coil"]

    @nominal_time_for_condensate_to_begin_leaving_the_coil.setter
    def nominal_time_for_condensate_to_begin_leaving_the_coil(
            self,
            value=None):
        """Corresponds to IDD field `Nominal Time for Condensate to Begin
        Leaving the Coil`

        Args:
            value (float): value for IDD Field `Nominal Time for Condensate to Begin Leaving the Coil`
                Units: s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Nominal Time for Condensate to Begin Leaving the Coil"] = value

    @property
    def initial_moisture_evaporation_rate_divided_by_steadystate_ac_latent_capacity(
            self):
        """Get initial_moisture_evaporation_rate_divided_by_steadystate_ac_late
        nt_capacity.

        Returns:
            float: the value of `initial_moisture_evaporation_rate_divided_by_steadystate_ac_latent_capacity` or None if not set

        """
        return self[
            "Initial Moisture Evaporation Rate Divided by Steady-State AC Latent Capacity"]

    @initial_moisture_evaporation_rate_divided_by_steadystate_ac_latent_capacity.setter
    def initial_moisture_evaporation_rate_divided_by_steadystate_ac_latent_capacity(
            self,
            value=None):
        """  Corresponds to IDD field `Initial Moisture Evaporation Rate Divided by Steady-State AC Latent Capacity`

        Args:
            value (float): value for IDD Field `Initial Moisture Evaporation Rate Divided by Steady-State AC Latent Capacity`
                Units: dimensionless
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Initial Moisture Evaporation Rate Divided by Steady-State AC Latent Capacity"] = value

    @property
    def energy_part_load_fraction_curve_name(self):
        """Get energy_part_load_fraction_curve_name.

        Returns:
            str: the value of `energy_part_load_fraction_curve_name` or None if not set

        """
        return self["Energy Part Load Fraction Curve Name"]

    @energy_part_load_fraction_curve_name.setter
    def energy_part_load_fraction_curve_name(self, value=None):
        """  Corresponds to IDD field `Energy Part Load Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*PLR + c*PLR**2
        cubic curve = a + b*PLR + c*PLR**2 + d*PLR**3
        PLR = part load ratio (cooling load/steady state capacity)

        Args:
            value (str): value for IDD Field `Energy Part Load Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Energy Part Load Fraction Curve Name"] = value

    @property
    def condenser_air_inlet_node_name(self):
        """Get condenser_air_inlet_node_name.

        Returns:
            str: the value of `condenser_air_inlet_node_name` or None if not set

        """
        return self["Condenser Air Inlet Node Name"]

    @condenser_air_inlet_node_name.setter
    def condenser_air_inlet_node_name(self, value=None):
        """  Corresponds to IDD field `Condenser Air Inlet Node Name`
        Enter the name of an outdoor air node. This node name is also specified in
        an OutdoorAir:Node or OutdoorAir:NodeList object.

        Args:
            value (str): value for IDD Field `Condenser Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Condenser Air Inlet Node Name"] = value

    @property
    def condenser_type(self):
        """Get condenser_type.

        Returns:
            str: the value of `condenser_type` or None if not set

        """
        return self["Condenser Type"]

    @condenser_type.setter
    def condenser_type(self, value="AirCooled"):
        """Corresponds to IDD field `Condenser Type`

        Args:
            value (str): value for IDD Field `Condenser Type`
                Default value: AirCooled
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Condenser Type"] = value

    @property
    def evaporative_condenser_pump_rated_power_consumption(self):
        """Get evaporative_condenser_pump_rated_power_consumption.

        Returns:
            float: the value of `evaporative_condenser_pump_rated_power_consumption` or None if not set

        """
        return self["Evaporative Condenser Pump Rated Power Consumption"]

    @evaporative_condenser_pump_rated_power_consumption.setter
    def evaporative_condenser_pump_rated_power_consumption(self, value=None):
        """Corresponds to IDD field `Evaporative Condenser Pump Rated Power
        Consumption` Rated power consumed by the evaporative condenser's water
        pump.

        Args:
            value (float or "Autosize"): value for IDD Field `Evaporative Condenser Pump Rated Power Consumption`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Evaporative Condenser Pump Rated Power Consumption"] = value

    @property
    def crankcase_heater_capacity(self):
        """Get crankcase_heater_capacity.

        Returns:
            float: the value of `crankcase_heater_capacity` or None if not set

        """
        return self["Crankcase Heater Capacity"]

    @crankcase_heater_capacity.setter
    def crankcase_heater_capacity(self, value=None):
        """Corresponds to IDD field `Crankcase Heater Capacity`

        Args:
            value (float): value for IDD Field `Crankcase Heater Capacity`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Crankcase Heater Capacity"] = value

    @property
    def maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation(
            self):
        """Get
        maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation.

        Returns:
            float: the value of `maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation` or None if not set

        """
        return self[
            "Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation"]

    @maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation.setter
    def maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation(
            self,
            value=10.0):
        """  Corresponds to IDD field `Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation`

        Args:
            value (float): value for IDD Field `Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation`
                Units: C
                Default value: 10.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation"] = value

    @property
    def supply_water_storage_tank_name(self):
        """Get supply_water_storage_tank_name.

        Returns:
            str: the value of `supply_water_storage_tank_name` or None if not set

        """
        return self["Supply Water Storage Tank Name"]

    @supply_water_storage_tank_name.setter
    def supply_water_storage_tank_name(self, value=None):
        """Corresponds to IDD field `Supply Water Storage Tank Name`

        Args:
            value (str): value for IDD Field `Supply Water Storage Tank Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Water Storage Tank Name"] = value

    @property
    def condensate_collection_water_storage_tank_name(self):
        """Get condensate_collection_water_storage_tank_name.

        Returns:
            str: the value of `condensate_collection_water_storage_tank_name` or None if not set

        """
        return self["Condensate Collection Water Storage Tank Name"]

    @condensate_collection_water_storage_tank_name.setter
    def condensate_collection_water_storage_tank_name(self, value=None):
        """Corresponds to IDD field `Condensate Collection Water Storage Tank
        Name`

        Args:
            value (str): value for IDD Field `Condensate Collection Water Storage Tank Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Condensate Collection Water Storage Tank Name"] = value

    @property
    def basin_heater_capacity(self):
        """Get basin_heater_capacity.

        Returns:
            float: the value of `basin_heater_capacity` or None if not set

        """
        return self["Basin Heater Capacity"]

    @basin_heater_capacity.setter
    def basin_heater_capacity(self, value=None):
        """  Corresponds to IDD field `Basin Heater Capacity`
        This field is only used for Condenser Type = EvaporativelyCooled and for periods
        when the basin heater is available (field Basin Heater Operating Schedule Name).
        For this situation, the heater maintains the basin water temperature at the basin heater
        setpoint temperature when the outdoor air temperature falls below the setpoint temperature.
        The basin heater only operates when the DX coil is off.

        Args:
            value (float): value for IDD Field `Basin Heater Capacity`
                Units: W/K
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Capacity"] = value

    @property
    def basin_heater_setpoint_temperature(self):
        """Get basin_heater_setpoint_temperature.

        Returns:
            float: the value of `basin_heater_setpoint_temperature` or None if not set

        """
        return self["Basin Heater Setpoint Temperature"]

    @basin_heater_setpoint_temperature.setter
    def basin_heater_setpoint_temperature(self, value=2.0):
        """  Corresponds to IDD field `Basin Heater Setpoint Temperature`
        This field is only used for Condenser Type = EvaporativelyCooled.
        Enter the outdoor dry-bulb temperature when the basin heater turns on.

        Args:
            value (float): value for IDD Field `Basin Heater Setpoint Temperature`
                Units: C
                Default value: 2.0
                value >= 2.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Setpoint Temperature"] = value

    @property
    def basin_heater_operating_schedule_name(self):
        """Get basin_heater_operating_schedule_name.

        Returns:
            str: the value of `basin_heater_operating_schedule_name` or None if not set

        """
        return self["Basin Heater Operating Schedule Name"]

    @basin_heater_operating_schedule_name.setter
    def basin_heater_operating_schedule_name(self, value=None):
        """  Corresponds to IDD field `Basin Heater Operating Schedule Name`
        This field is only used for Condenser Type = EvaporativelyCooled.
        Schedule values greater than 0 allow the basin heater to operate whenever the outdoor
        air dry-bulb temperature is below the basin heater setpoint temperature.
        If a schedule name is not entered, the basin heater is allowed to operate
        throughout the entire simulation.

        Args:
            value (str): value for IDD Field `Basin Heater Operating Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Operating Schedule Name"] = value

    @property
    def speed_1_reference_unit_gross_rated_total_cooling_capacity(self):
        """Get speed_1_reference_unit_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `speed_1_reference_unit_gross_rated_total_cooling_capacity` or None if not set

        """
        return self[
            "Speed 1 Reference Unit Gross Rated Total Cooling Capacity"]

    @speed_1_reference_unit_gross_rated_total_cooling_capacity.setter
    def speed_1_reference_unit_gross_rated_total_cooling_capacity(
            self,
            value=None):
        """Corresponds to IDD field `Speed 1 Reference Unit Gross Rated Total
        Cooling Capacity` Total cooling capacity not accounting for the effect
        of supply air fan heat.

        Args:
            value (float): value for IDD Field `Speed 1 Reference Unit Gross Rated Total Cooling Capacity`
                Units: w
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 1 Reference Unit Gross Rated Total Cooling Capacity"] = value

    @property
    def speed_1_reference_unit_gross_rated_sensible_heat_ratio(self):
        """Get speed_1_reference_unit_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `speed_1_reference_unit_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Speed 1 Reference Unit Gross Rated Sensible Heat Ratio"]

    @speed_1_reference_unit_gross_rated_sensible_heat_ratio.setter
    def speed_1_reference_unit_gross_rated_sensible_heat_ratio(
            self,
            value=None):
        """Corresponds to IDD field `Speed 1 Reference Unit Gross Rated
        Sensible Heat Ratio`

        Args:
            value (float): value for IDD Field `Speed 1 Reference Unit Gross Rated Sensible Heat Ratio`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 1 Reference Unit Gross Rated Sensible Heat Ratio"] = value

    @property
    def speed_1_reference_unit_gross_rated_cooling_cop(self):
        """Get speed_1_reference_unit_gross_rated_cooling_cop.

        Returns:
            float: the value of `speed_1_reference_unit_gross_rated_cooling_cop` or None if not set

        """
        return self["Speed 1 Reference Unit Gross Rated Cooling COP"]

    @speed_1_reference_unit_gross_rated_cooling_cop.setter
    def speed_1_reference_unit_gross_rated_cooling_cop(self, value=None):
        """Corresponds to IDD field `Speed 1 Reference Unit Gross Rated Cooling
        COP`

        Args:
            value (float): value for IDD Field `Speed 1 Reference Unit Gross Rated Cooling COP`
                Units: dimensionless
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 1 Reference Unit Gross Rated Cooling COP"] = value

    @property
    def speed_1_reference_unit_rated_air_flow_rate(self):
        """Get speed_1_reference_unit_rated_air_flow_rate.

        Returns:
            float: the value of `speed_1_reference_unit_rated_air_flow_rate` or None if not set

        """
        return self["Speed 1 Reference Unit Rated Air Flow Rate"]

    @speed_1_reference_unit_rated_air_flow_rate.setter
    def speed_1_reference_unit_rated_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 1 Reference Unit Rated Air Flow
        Rate`

        Args:
            value (float): value for IDD Field `Speed 1 Reference Unit Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 1 Reference Unit Rated Air Flow Rate"] = value

    @property
    def speed_1_reference_unit_rated_condenser_air_flow_rate(self):
        """Get speed_1_reference_unit_rated_condenser_air_flow_rate.

        Returns:
            float: the value of `speed_1_reference_unit_rated_condenser_air_flow_rate` or None if not set

        """
        return self["Speed 1 Reference Unit Rated Condenser Air Flow Rate"]

    @speed_1_reference_unit_rated_condenser_air_flow_rate.setter
    def speed_1_reference_unit_rated_condenser_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Speed 1 Reference Unit Rated Condenser Air Flow Rate`
        This field is only used for Condenser Type = EvaporativelyCooled

        Args:
            value (float): value for IDD Field `Speed 1 Reference Unit Rated Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 1 Reference Unit Rated Condenser Air Flow Rate"] = value

    @property
    def speed_1_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self):
        """Get
        speed_1_reference_unit_rated_pad_effectiveness_of_evap_precooling.

        Returns:
            float: the value of `speed_1_reference_unit_rated_pad_effectiveness_of_evap_precooling` or None if not set

        """
        return self[
            "Speed 1 Reference Unit Rated Pad Effectiveness of Evap Precooling"]

    @speed_1_reference_unit_rated_pad_effectiveness_of_evap_precooling.setter
    def speed_1_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Reference Unit Rated Pad Effectiveness of Evap Precooling`
        This field is only used for Condenser Type = EvaporativelyCooled

        Args:
            value (float): value for IDD Field `Speed 1 Reference Unit Rated Pad Effectiveness of Evap Precooling`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 1 Reference Unit Rated Pad Effectiveness of Evap Precooling"] = value

    @property
    def speed_1_total_cooling_capacity_function_of_temperature_curve_name(
            self):
        """Get
        speed_1_total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_1_total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 1 Total Cooling Capacity Function of Temperature Curve Name"]

    @speed_1_total_cooling_capacity_function_of_temperature_curve_name.setter
    def speed_1_total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 1 Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 1 Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_1_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self):
        """Get speed_1_total_cooling_capacity_function_of_air_flow_fraction_cur
        ve_name.

        Returns:
            str: the value of `speed_1_total_cooling_capacity_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 1 Total Cooling Capacity Function of Air Flow Fraction Curve Name"]

    @speed_1_total_cooling_capacity_function_of_air_flow_fraction_curve_name.setter
    def speed_1_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 1 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 1 Total Cooling Capacity Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_1_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_1_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_1_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 1 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_1_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_1_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 1 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 1 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_1_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self):
        """Get
        speed_1_energy_input_ratio_function_of_air_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_1_energy_input_ratio_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 1 Energy Input Ratio Function of Air Flow Fraction Curve Name"]

    @speed_1_energy_input_ratio_function_of_air_flow_fraction_curve_name.setter
    def speed_1_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Energy Input Ratio Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 1 Energy Input Ratio Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 1 Energy Input Ratio Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_2_reference_unit_gross_rated_total_cooling_capacity(self):
        """Get speed_2_reference_unit_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `speed_2_reference_unit_gross_rated_total_cooling_capacity` or None if not set

        """
        return self[
            "Speed 2 Reference Unit Gross Rated Total Cooling Capacity"]

    @speed_2_reference_unit_gross_rated_total_cooling_capacity.setter
    def speed_2_reference_unit_gross_rated_total_cooling_capacity(
            self,
            value=None):
        """Corresponds to IDD field `Speed 2 Reference Unit Gross Rated Total
        Cooling Capacity` Total cooling capacity not accounting for the effect
        of supply air fan heat.

        Args:
            value (float): value for IDD Field `Speed 2 Reference Unit Gross Rated Total Cooling Capacity`
                Units: w
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 2 Reference Unit Gross Rated Total Cooling Capacity"] = value

    @property
    def speed_2_reference_unit_gross_rated_sensible_heat_ratio(self):
        """Get speed_2_reference_unit_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `speed_2_reference_unit_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Speed 2 Reference Unit Gross Rated Sensible Heat Ratio"]

    @speed_2_reference_unit_gross_rated_sensible_heat_ratio.setter
    def speed_2_reference_unit_gross_rated_sensible_heat_ratio(
            self,
            value=None):
        """Corresponds to IDD field `Speed 2 Reference Unit Gross Rated
        Sensible Heat Ratio`

        Args:
            value (float): value for IDD Field `Speed 2 Reference Unit Gross Rated Sensible Heat Ratio`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 2 Reference Unit Gross Rated Sensible Heat Ratio"] = value

    @property
    def speed_2_reference_unit_gross_rated_cooling_cop(self):
        """Get speed_2_reference_unit_gross_rated_cooling_cop.

        Returns:
            float: the value of `speed_2_reference_unit_gross_rated_cooling_cop` or None if not set

        """
        return self["Speed 2 Reference Unit Gross Rated Cooling COP"]

    @speed_2_reference_unit_gross_rated_cooling_cop.setter
    def speed_2_reference_unit_gross_rated_cooling_cop(self, value=None):
        """Corresponds to IDD field `Speed 2 Reference Unit Gross Rated Cooling
        COP`

        Args:
            value (float): value for IDD Field `Speed 2 Reference Unit Gross Rated Cooling COP`
                Units: dimensionless
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 2 Reference Unit Gross Rated Cooling COP"] = value

    @property
    def speed_2_reference_unit_rated_air_flow_rate(self):
        """Get speed_2_reference_unit_rated_air_flow_rate.

        Returns:
            float: the value of `speed_2_reference_unit_rated_air_flow_rate` or None if not set

        """
        return self["Speed 2 Reference Unit Rated Air Flow Rate"]

    @speed_2_reference_unit_rated_air_flow_rate.setter
    def speed_2_reference_unit_rated_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 2 Reference Unit Rated Air Flow
        Rate`

        Args:
            value (float): value for IDD Field `Speed 2 Reference Unit Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 2 Reference Unit Rated Air Flow Rate"] = value

    @property
    def speed_2_reference_unit_rated_condenser_air_flow_rate(self):
        """Get speed_2_reference_unit_rated_condenser_air_flow_rate.

        Returns:
            float: the value of `speed_2_reference_unit_rated_condenser_air_flow_rate` or None if not set

        """
        return self["Speed 2 Reference Unit Rated Condenser Air Flow Rate"]

    @speed_2_reference_unit_rated_condenser_air_flow_rate.setter
    def speed_2_reference_unit_rated_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 2 Reference Unit Rated Condenser Air
        Flow Rate`

        Args:
            value (float): value for IDD Field `Speed 2 Reference Unit Rated Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 2 Reference Unit Rated Condenser Air Flow Rate"] = value

    @property
    def speed_2_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self):
        """Get
        speed_2_reference_unit_rated_pad_effectiveness_of_evap_precooling.

        Returns:
            float: the value of `speed_2_reference_unit_rated_pad_effectiveness_of_evap_precooling` or None if not set

        """
        return self[
            "Speed 2 Reference Unit Rated Pad Effectiveness of Evap Precooling"]

    @speed_2_reference_unit_rated_pad_effectiveness_of_evap_precooling.setter
    def speed_2_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self,
            value=None):
        """Corresponds to IDD field `Speed 2 Reference Unit Rated Pad
        Effectiveness of Evap Precooling`

        Args:
            value (float): value for IDD Field `Speed 2 Reference Unit Rated Pad Effectiveness of Evap Precooling`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 2 Reference Unit Rated Pad Effectiveness of Evap Precooling"] = value

    @property
    def speed_2_total_cooling_capacity_function_of_temperature_curve_name(
            self):
        """Get
        speed_2_total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_2_total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 2 Total Cooling Capacity Function of Temperature Curve Name"]

    @speed_2_total_cooling_capacity_function_of_temperature_curve_name.setter
    def speed_2_total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 2 Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 2 Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 2 Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_2_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self):
        """Get speed_2_total_cooling_capacity_function_of_air_flow_fraction_cur
        ve_name.

        Returns:
            str: the value of `speed_2_total_cooling_capacity_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 2 Total Cooling Capacity Function of Air Flow Fraction Curve Name"]

    @speed_2_total_cooling_capacity_function_of_air_flow_fraction_curve_name.setter
    def speed_2_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 2 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 2 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 2 Total Cooling Capacity Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_2_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_2_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_2_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 2 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_2_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_2_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 2 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 2 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 2 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_2_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self):
        """Get
        speed_2_energy_input_ratio_function_of_air_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_2_energy_input_ratio_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 2 Energy Input Ratio Function of Air Flow Fraction Curve Name"]

    @speed_2_energy_input_ratio_function_of_air_flow_fraction_curve_name.setter
    def speed_2_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 2 Energy Input Ratio Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 2 Energy Input Ratio Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 2 Energy Input Ratio Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_3_reference_unit_gross_rated_total_cooling_capacity(self):
        """Get speed_3_reference_unit_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `speed_3_reference_unit_gross_rated_total_cooling_capacity` or None if not set

        """
        return self[
            "Speed 3 Reference Unit Gross Rated Total Cooling Capacity"]

    @speed_3_reference_unit_gross_rated_total_cooling_capacity.setter
    def speed_3_reference_unit_gross_rated_total_cooling_capacity(
            self,
            value=None):
        """Corresponds to IDD field `Speed 3 Reference Unit Gross Rated Total
        Cooling Capacity` Total cooling capacity not accounting for the effect
        of supply air fan heat.

        Args:
            value (float): value for IDD Field `Speed 3 Reference Unit Gross Rated Total Cooling Capacity`
                Units: w
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 3 Reference Unit Gross Rated Total Cooling Capacity"] = value

    @property
    def speed_3_reference_unit_gross_rated_sensible_heat_ratio(self):
        """Get speed_3_reference_unit_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `speed_3_reference_unit_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Speed 3 Reference Unit Gross Rated Sensible Heat Ratio"]

    @speed_3_reference_unit_gross_rated_sensible_heat_ratio.setter
    def speed_3_reference_unit_gross_rated_sensible_heat_ratio(
            self,
            value=None):
        """Corresponds to IDD field `Speed 3 Reference Unit Gross Rated
        Sensible Heat Ratio`

        Args:
            value (float): value for IDD Field `Speed 3 Reference Unit Gross Rated Sensible Heat Ratio`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 3 Reference Unit Gross Rated Sensible Heat Ratio"] = value

    @property
    def speed_3_reference_unit_gross_rated_cooling_cop(self):
        """Get speed_3_reference_unit_gross_rated_cooling_cop.

        Returns:
            float: the value of `speed_3_reference_unit_gross_rated_cooling_cop` or None if not set

        """
        return self["Speed 3 Reference Unit Gross Rated Cooling COP"]

    @speed_3_reference_unit_gross_rated_cooling_cop.setter
    def speed_3_reference_unit_gross_rated_cooling_cop(self, value=None):
        """Corresponds to IDD field `Speed 3 Reference Unit Gross Rated Cooling
        COP`

        Args:
            value (float): value for IDD Field `Speed 3 Reference Unit Gross Rated Cooling COP`
                Units: dimensionless
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 3 Reference Unit Gross Rated Cooling COP"] = value

    @property
    def speed_3_reference_unit_rated_air_flow_rate(self):
        """Get speed_3_reference_unit_rated_air_flow_rate.

        Returns:
            float: the value of `speed_3_reference_unit_rated_air_flow_rate` or None if not set

        """
        return self["Speed 3 Reference Unit Rated Air Flow Rate"]

    @speed_3_reference_unit_rated_air_flow_rate.setter
    def speed_3_reference_unit_rated_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 3 Reference Unit Rated Air Flow
        Rate`

        Args:
            value (float): value for IDD Field `Speed 3 Reference Unit Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 3 Reference Unit Rated Air Flow Rate"] = value

    @property
    def speed_3_reference_unit_rated_condenser_air_flow_rate(self):
        """Get speed_3_reference_unit_rated_condenser_air_flow_rate.

        Returns:
            float: the value of `speed_3_reference_unit_rated_condenser_air_flow_rate` or None if not set

        """
        return self["Speed 3 Reference Unit Rated Condenser Air Flow Rate"]

    @speed_3_reference_unit_rated_condenser_air_flow_rate.setter
    def speed_3_reference_unit_rated_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 3 Reference Unit Rated Condenser Air
        Flow Rate`

        Args:
            value (float): value for IDD Field `Speed 3 Reference Unit Rated Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 3 Reference Unit Rated Condenser Air Flow Rate"] = value

    @property
    def speed_3_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self):
        """Get
        speed_3_reference_unit_rated_pad_effectiveness_of_evap_precooling.

        Returns:
            float: the value of `speed_3_reference_unit_rated_pad_effectiveness_of_evap_precooling` or None if not set

        """
        return self[
            "Speed 3 Reference Unit Rated Pad Effectiveness of Evap Precooling"]

    @speed_3_reference_unit_rated_pad_effectiveness_of_evap_precooling.setter
    def speed_3_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self,
            value=None):
        """Corresponds to IDD field `Speed 3 Reference Unit Rated Pad
        Effectiveness of Evap Precooling`

        Args:
            value (float): value for IDD Field `Speed 3 Reference Unit Rated Pad Effectiveness of Evap Precooling`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 3 Reference Unit Rated Pad Effectiveness of Evap Precooling"] = value

    @property
    def speed_3_total_cooling_capacity_function_of_temperature_curve_name(
            self):
        """Get
        speed_3_total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_3_total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 3 Total Cooling Capacity Function of Temperature Curve Name"]

    @speed_3_total_cooling_capacity_function_of_temperature_curve_name.setter
    def speed_3_total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 3 Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 3 Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 3 Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_3_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self):
        """Get speed_3_total_cooling_capacity_function_of_air_flow_fraction_cur
        ve_name.

        Returns:
            str: the value of `speed_3_total_cooling_capacity_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 3 Total Cooling Capacity Function of Air Flow Fraction Curve Name"]

    @speed_3_total_cooling_capacity_function_of_air_flow_fraction_curve_name.setter
    def speed_3_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 3 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 3 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 3 Total Cooling Capacity Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_3_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_3_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_3_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 3 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_3_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_3_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 3 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 3 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 3 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_3_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self):
        """Get
        speed_3_energy_input_ratio_function_of_air_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_3_energy_input_ratio_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 3 Energy Input Ratio Function of Air Flow Fraction Curve Name"]

    @speed_3_energy_input_ratio_function_of_air_flow_fraction_curve_name.setter
    def speed_3_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 3 Energy Input Ratio Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 3 Energy Input Ratio Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 3 Energy Input Ratio Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_4_reference_unit_gross_rated_total_cooling_capacity(self):
        """Get speed_4_reference_unit_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `speed_4_reference_unit_gross_rated_total_cooling_capacity` or None if not set

        """
        return self[
            "Speed 4 Reference Unit Gross Rated Total Cooling Capacity"]

    @speed_4_reference_unit_gross_rated_total_cooling_capacity.setter
    def speed_4_reference_unit_gross_rated_total_cooling_capacity(
            self,
            value=None):
        """Corresponds to IDD field `Speed 4 Reference Unit Gross Rated Total
        Cooling Capacity` Total cooling capacity not accounting for the effect
        of supply air fan heat.

        Args:
            value (float): value for IDD Field `Speed 4 Reference Unit Gross Rated Total Cooling Capacity`
                Units: w
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 4 Reference Unit Gross Rated Total Cooling Capacity"] = value

    @property
    def speed_4_reference_unit_gross_rated_sensible_heat_ratio(self):
        """Get speed_4_reference_unit_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `speed_4_reference_unit_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Speed 4 Reference Unit Gross Rated Sensible Heat Ratio"]

    @speed_4_reference_unit_gross_rated_sensible_heat_ratio.setter
    def speed_4_reference_unit_gross_rated_sensible_heat_ratio(
            self,
            value=None):
        """Corresponds to IDD field `Speed 4 Reference Unit Gross Rated
        Sensible Heat Ratio`

        Args:
            value (float): value for IDD Field `Speed 4 Reference Unit Gross Rated Sensible Heat Ratio`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 4 Reference Unit Gross Rated Sensible Heat Ratio"] = value

    @property
    def speed_4_reference_unit_gross_rated_cooling_cop(self):
        """Get speed_4_reference_unit_gross_rated_cooling_cop.

        Returns:
            float: the value of `speed_4_reference_unit_gross_rated_cooling_cop` or None if not set

        """
        return self["Speed 4 Reference Unit Gross Rated Cooling COP"]

    @speed_4_reference_unit_gross_rated_cooling_cop.setter
    def speed_4_reference_unit_gross_rated_cooling_cop(self, value=None):
        """Corresponds to IDD field `Speed 4 Reference Unit Gross Rated Cooling
        COP`

        Args:
            value (float): value for IDD Field `Speed 4 Reference Unit Gross Rated Cooling COP`
                Units: dimensionless
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 4 Reference Unit Gross Rated Cooling COP"] = value

    @property
    def speed_4_reference_unit_rated_air_flow_rate(self):
        """Get speed_4_reference_unit_rated_air_flow_rate.

        Returns:
            float: the value of `speed_4_reference_unit_rated_air_flow_rate` or None if not set

        """
        return self["Speed 4 Reference Unit Rated Air Flow Rate"]

    @speed_4_reference_unit_rated_air_flow_rate.setter
    def speed_4_reference_unit_rated_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 4 Reference Unit Rated Air Flow
        Rate`

        Args:
            value (float): value for IDD Field `Speed 4 Reference Unit Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 4 Reference Unit Rated Air Flow Rate"] = value

    @property
    def speed_4_reference_unit_rated_condenser_air_flow_rate(self):
        """Get speed_4_reference_unit_rated_condenser_air_flow_rate.

        Returns:
            float: the value of `speed_4_reference_unit_rated_condenser_air_flow_rate` or None if not set

        """
        return self["Speed 4 Reference Unit Rated Condenser Air Flow Rate"]

    @speed_4_reference_unit_rated_condenser_air_flow_rate.setter
    def speed_4_reference_unit_rated_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 4 Reference Unit Rated Condenser Air
        Flow Rate`

        Args:
            value (float): value for IDD Field `Speed 4 Reference Unit Rated Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 4 Reference Unit Rated Condenser Air Flow Rate"] = value

    @property
    def speed_4_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self):
        """Get
        speed_4_reference_unit_rated_pad_effectiveness_of_evap_precooling.

        Returns:
            float: the value of `speed_4_reference_unit_rated_pad_effectiveness_of_evap_precooling` or None if not set

        """
        return self[
            "Speed 4 Reference Unit Rated Pad Effectiveness of Evap Precooling"]

    @speed_4_reference_unit_rated_pad_effectiveness_of_evap_precooling.setter
    def speed_4_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self,
            value=None):
        """Corresponds to IDD field `Speed 4 Reference Unit Rated Pad
        Effectiveness of Evap Precooling`

        Args:
            value (float): value for IDD Field `Speed 4 Reference Unit Rated Pad Effectiveness of Evap Precooling`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 4 Reference Unit Rated Pad Effectiveness of Evap Precooling"] = value

    @property
    def speed_4_total_cooling_capacity_function_of_temperature_curve_name(
            self):
        """Get
        speed_4_total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_4_total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 4 Total Cooling Capacity Function of Temperature Curve Name"]

    @speed_4_total_cooling_capacity_function_of_temperature_curve_name.setter
    def speed_4_total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 4 Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 4 Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 4 Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_4_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self):
        """Get speed_4_total_cooling_capacity_function_of_air_flow_fraction_cur
        ve_name.

        Returns:
            str: the value of `speed_4_total_cooling_capacity_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 4 Total Cooling Capacity Function of Air Flow Fraction Curve Name"]

    @speed_4_total_cooling_capacity_function_of_air_flow_fraction_curve_name.setter
    def speed_4_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 4 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 4 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 4 Total Cooling Capacity Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_4_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_4_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_4_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 4 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_4_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_4_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 4 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 4 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 4 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_4_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self):
        """Get
        speed_4_energy_input_ratio_function_of_air_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_4_energy_input_ratio_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 4 Energy Input Ratio Function of Air Flow Fraction Curve Name"]

    @speed_4_energy_input_ratio_function_of_air_flow_fraction_curve_name.setter
    def speed_4_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 4 Energy Input Ratio Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 4 Energy Input Ratio Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 4 Energy Input Ratio Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_5_reference_unit_gross_rated_total_cooling_capacity(self):
        """Get speed_5_reference_unit_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `speed_5_reference_unit_gross_rated_total_cooling_capacity` or None if not set

        """
        return self[
            "Speed 5 Reference Unit Gross Rated Total Cooling Capacity"]

    @speed_5_reference_unit_gross_rated_total_cooling_capacity.setter
    def speed_5_reference_unit_gross_rated_total_cooling_capacity(
            self,
            value=None):
        """Corresponds to IDD field `Speed 5 Reference Unit Gross Rated Total
        Cooling Capacity` Total cooling capacity not accounting for the effect
        of supply air fan heat.

        Args:
            value (float): value for IDD Field `Speed 5 Reference Unit Gross Rated Total Cooling Capacity`
                Units: w
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 5 Reference Unit Gross Rated Total Cooling Capacity"] = value

    @property
    def speed_5_reference_unit_gross_rated_sensible_heat_ratio(self):
        """Get speed_5_reference_unit_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `speed_5_reference_unit_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Speed 5 Reference Unit Gross Rated Sensible Heat Ratio"]

    @speed_5_reference_unit_gross_rated_sensible_heat_ratio.setter
    def speed_5_reference_unit_gross_rated_sensible_heat_ratio(
            self,
            value=None):
        """Corresponds to IDD field `Speed 5 Reference Unit Gross Rated
        Sensible Heat Ratio`

        Args:
            value (float): value for IDD Field `Speed 5 Reference Unit Gross Rated Sensible Heat Ratio`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 5 Reference Unit Gross Rated Sensible Heat Ratio"] = value

    @property
    def speed_5_reference_unit_gross_rated_cooling_cop(self):
        """Get speed_5_reference_unit_gross_rated_cooling_cop.

        Returns:
            float: the value of `speed_5_reference_unit_gross_rated_cooling_cop` or None if not set

        """
        return self["Speed 5 Reference Unit Gross Rated Cooling COP"]

    @speed_5_reference_unit_gross_rated_cooling_cop.setter
    def speed_5_reference_unit_gross_rated_cooling_cop(self, value=None):
        """Corresponds to IDD field `Speed 5 Reference Unit Gross Rated Cooling
        COP`

        Args:
            value (float): value for IDD Field `Speed 5 Reference Unit Gross Rated Cooling COP`
                Units: dimensionless
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 5 Reference Unit Gross Rated Cooling COP"] = value

    @property
    def speed_5_reference_unit_rated_air_flow_rate(self):
        """Get speed_5_reference_unit_rated_air_flow_rate.

        Returns:
            float: the value of `speed_5_reference_unit_rated_air_flow_rate` or None if not set

        """
        return self["Speed 5 Reference Unit Rated Air Flow Rate"]

    @speed_5_reference_unit_rated_air_flow_rate.setter
    def speed_5_reference_unit_rated_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 5 Reference Unit Rated Air Flow
        Rate`

        Args:
            value (float): value for IDD Field `Speed 5 Reference Unit Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 5 Reference Unit Rated Air Flow Rate"] = value

    @property
    def speed_5_reference_unit_rated_condenser_air_flow_rate(self):
        """Get speed_5_reference_unit_rated_condenser_air_flow_rate.

        Returns:
            float: the value of `speed_5_reference_unit_rated_condenser_air_flow_rate` or None if not set

        """
        return self["Speed 5 Reference Unit Rated Condenser Air Flow Rate"]

    @speed_5_reference_unit_rated_condenser_air_flow_rate.setter
    def speed_5_reference_unit_rated_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 5 Reference Unit Rated Condenser Air
        Flow Rate`

        Args:
            value (float): value for IDD Field `Speed 5 Reference Unit Rated Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 5 Reference Unit Rated Condenser Air Flow Rate"] = value

    @property
    def speed_5_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self):
        """Get
        speed_5_reference_unit_rated_pad_effectiveness_of_evap_precooling.

        Returns:
            float: the value of `speed_5_reference_unit_rated_pad_effectiveness_of_evap_precooling` or None if not set

        """
        return self[
            "Speed 5 Reference Unit Rated Pad Effectiveness of Evap Precooling"]

    @speed_5_reference_unit_rated_pad_effectiveness_of_evap_precooling.setter
    def speed_5_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self,
            value=None):
        """Corresponds to IDD field `Speed 5 Reference Unit Rated Pad
        Effectiveness of Evap Precooling`

        Args:
            value (float): value for IDD Field `Speed 5 Reference Unit Rated Pad Effectiveness of Evap Precooling`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 5 Reference Unit Rated Pad Effectiveness of Evap Precooling"] = value

    @property
    def speed_5_total_cooling_capacity_function_of_temperature_curve_name(
            self):
        """Get
        speed_5_total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_5_total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 5 Total Cooling Capacity Function of Temperature Curve Name"]

    @speed_5_total_cooling_capacity_function_of_temperature_curve_name.setter
    def speed_5_total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 5 Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 5 Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 5 Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_5_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self):
        """Get speed_5_total_cooling_capacity_function_of_air_flow_fraction_cur
        ve_name.

        Returns:
            str: the value of `speed_5_total_cooling_capacity_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 5 Total Cooling Capacity Function of Air Flow Fraction Curve Name"]

    @speed_5_total_cooling_capacity_function_of_air_flow_fraction_curve_name.setter
    def speed_5_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 5 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 5 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 5 Total Cooling Capacity Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_5_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_5_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_5_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 5 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_5_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_5_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 5 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 5 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 5 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_5_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self):
        """Get
        speed_5_energy_input_ratio_function_of_air_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_5_energy_input_ratio_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 5 Energy Input Ratio Function of Air Flow Fraction Curve Name"]

    @speed_5_energy_input_ratio_function_of_air_flow_fraction_curve_name.setter
    def speed_5_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 5 Energy Input Ratio Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 5 Energy Input Ratio Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 5 Energy Input Ratio Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_6_reference_unit_gross_rated_total_cooling_capacity(self):
        """Get speed_6_reference_unit_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `speed_6_reference_unit_gross_rated_total_cooling_capacity` or None if not set

        """
        return self[
            "Speed 6 Reference Unit Gross Rated Total Cooling Capacity"]

    @speed_6_reference_unit_gross_rated_total_cooling_capacity.setter
    def speed_6_reference_unit_gross_rated_total_cooling_capacity(
            self,
            value=None):
        """Corresponds to IDD field `Speed 6 Reference Unit Gross Rated Total
        Cooling Capacity` Total cooling capacity not accounting for the effect
        of supply air fan heat.

        Args:
            value (float): value for IDD Field `Speed 6 Reference Unit Gross Rated Total Cooling Capacity`
                Units: w
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 6 Reference Unit Gross Rated Total Cooling Capacity"] = value

    @property
    def speed_6_reference_unit_gross_rated_sensible_heat_ratio(self):
        """Get speed_6_reference_unit_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `speed_6_reference_unit_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Speed 6 Reference Unit Gross Rated Sensible Heat Ratio"]

    @speed_6_reference_unit_gross_rated_sensible_heat_ratio.setter
    def speed_6_reference_unit_gross_rated_sensible_heat_ratio(
            self,
            value=None):
        """Corresponds to IDD field `Speed 6 Reference Unit Gross Rated
        Sensible Heat Ratio`

        Args:
            value (float): value for IDD Field `Speed 6 Reference Unit Gross Rated Sensible Heat Ratio`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 6 Reference Unit Gross Rated Sensible Heat Ratio"] = value

    @property
    def speed_6_reference_unit_gross_rated_cooling_cop(self):
        """Get speed_6_reference_unit_gross_rated_cooling_cop.

        Returns:
            float: the value of `speed_6_reference_unit_gross_rated_cooling_cop` or None if not set

        """
        return self["Speed 6 Reference Unit Gross Rated Cooling COP"]

    @speed_6_reference_unit_gross_rated_cooling_cop.setter
    def speed_6_reference_unit_gross_rated_cooling_cop(self, value=None):
        """Corresponds to IDD field `Speed 6 Reference Unit Gross Rated Cooling
        COP`

        Args:
            value (float): value for IDD Field `Speed 6 Reference Unit Gross Rated Cooling COP`
                Units: dimensionless
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 6 Reference Unit Gross Rated Cooling COP"] = value

    @property
    def speed_6_reference_unit_rated_air_flow_rate(self):
        """Get speed_6_reference_unit_rated_air_flow_rate.

        Returns:
            float: the value of `speed_6_reference_unit_rated_air_flow_rate` or None if not set

        """
        return self["Speed 6 Reference Unit Rated Air Flow Rate"]

    @speed_6_reference_unit_rated_air_flow_rate.setter
    def speed_6_reference_unit_rated_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 6 Reference Unit Rated Air Flow
        Rate`

        Args:
            value (float): value for IDD Field `Speed 6 Reference Unit Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 6 Reference Unit Rated Air Flow Rate"] = value

    @property
    def speed_6_reference_unit_condenser_air_flow_rate(self):
        """Get speed_6_reference_unit_condenser_air_flow_rate.

        Returns:
            float: the value of `speed_6_reference_unit_condenser_air_flow_rate` or None if not set

        """
        return self["Speed 6 Reference Unit Condenser Air Flow Rate"]

    @speed_6_reference_unit_condenser_air_flow_rate.setter
    def speed_6_reference_unit_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 6 Reference Unit Condenser Air Flow
        Rate`

        Args:
            value (float): value for IDD Field `Speed 6 Reference Unit Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 6 Reference Unit Condenser Air Flow Rate"] = value

    @property
    def speed_6_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self):
        """Get
        speed_6_reference_unit_rated_pad_effectiveness_of_evap_precooling.

        Returns:
            float: the value of `speed_6_reference_unit_rated_pad_effectiveness_of_evap_precooling` or None if not set

        """
        return self[
            "Speed 6 Reference Unit Rated Pad Effectiveness of Evap Precooling"]

    @speed_6_reference_unit_rated_pad_effectiveness_of_evap_precooling.setter
    def speed_6_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self,
            value=None):
        """Corresponds to IDD field `Speed 6 Reference Unit Rated Pad
        Effectiveness of Evap Precooling`

        Args:
            value (float): value for IDD Field `Speed 6 Reference Unit Rated Pad Effectiveness of Evap Precooling`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 6 Reference Unit Rated Pad Effectiveness of Evap Precooling"] = value

    @property
    def speed_6_total_cooling_capacity_function_of_temperature_curve_name(
            self):
        """Get
        speed_6_total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_6_total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 6 Total Cooling Capacity Function of Temperature Curve Name"]

    @speed_6_total_cooling_capacity_function_of_temperature_curve_name.setter
    def speed_6_total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 6 Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 6 Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 6 Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_6_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self):
        """Get speed_6_total_cooling_capacity_function_of_air_flow_fraction_cur
        ve_name.

        Returns:
            str: the value of `speed_6_total_cooling_capacity_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 6 Total Cooling Capacity Function of Air Flow Fraction Curve Name"]

    @speed_6_total_cooling_capacity_function_of_air_flow_fraction_curve_name.setter
    def speed_6_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 6 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 6 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 6 Total Cooling Capacity Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_6_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_6_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_6_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 6 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_6_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_6_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 6 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 6 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 6 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_6_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self):
        """Get
        speed_6_energy_input_ratio_function_of_air_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_6_energy_input_ratio_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 6 Energy Input Ratio Function of Air Flow Fraction Curve Name"]

    @speed_6_energy_input_ratio_function_of_air_flow_fraction_curve_name.setter
    def speed_6_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 6 Energy Input Ratio Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 6 Energy Input Ratio Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 6 Energy Input Ratio Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_7_reference_unit_gross_rated_total_cooling_capacity(self):
        """Get speed_7_reference_unit_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `speed_7_reference_unit_gross_rated_total_cooling_capacity` or None if not set

        """
        return self[
            "Speed 7 Reference Unit Gross Rated Total Cooling Capacity"]

    @speed_7_reference_unit_gross_rated_total_cooling_capacity.setter
    def speed_7_reference_unit_gross_rated_total_cooling_capacity(
            self,
            value=None):
        """Corresponds to IDD field `Speed 7 Reference Unit Gross Rated Total
        Cooling Capacity` Total cooling capacity not accounting for the effect
        of supply air fan heat.

        Args:
            value (float): value for IDD Field `Speed 7 Reference Unit Gross Rated Total Cooling Capacity`
                Units: w
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 7 Reference Unit Gross Rated Total Cooling Capacity"] = value

    @property
    def speed_7_reference_unit_gross_rated_sensible_heat_ratio(self):
        """Get speed_7_reference_unit_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `speed_7_reference_unit_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Speed 7 Reference Unit Gross Rated Sensible Heat Ratio"]

    @speed_7_reference_unit_gross_rated_sensible_heat_ratio.setter
    def speed_7_reference_unit_gross_rated_sensible_heat_ratio(
            self,
            value=None):
        """Corresponds to IDD field `Speed 7 Reference Unit Gross Rated
        Sensible Heat Ratio`

        Args:
            value (float): value for IDD Field `Speed 7 Reference Unit Gross Rated Sensible Heat Ratio`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 7 Reference Unit Gross Rated Sensible Heat Ratio"] = value

    @property
    def speed_7_reference_unit_gross_rated_cooling_cop(self):
        """Get speed_7_reference_unit_gross_rated_cooling_cop.

        Returns:
            float: the value of `speed_7_reference_unit_gross_rated_cooling_cop` or None if not set

        """
        return self["Speed 7 Reference Unit Gross Rated Cooling COP"]

    @speed_7_reference_unit_gross_rated_cooling_cop.setter
    def speed_7_reference_unit_gross_rated_cooling_cop(self, value=None):
        """Corresponds to IDD field `Speed 7 Reference Unit Gross Rated Cooling
        COP`

        Args:
            value (float): value for IDD Field `Speed 7 Reference Unit Gross Rated Cooling COP`
                Units: dimensionless
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 7 Reference Unit Gross Rated Cooling COP"] = value

    @property
    def speed_7_reference_unit_rated_air_flow_rate(self):
        """Get speed_7_reference_unit_rated_air_flow_rate.

        Returns:
            float: the value of `speed_7_reference_unit_rated_air_flow_rate` or None if not set

        """
        return self["Speed 7 Reference Unit Rated Air Flow Rate"]

    @speed_7_reference_unit_rated_air_flow_rate.setter
    def speed_7_reference_unit_rated_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 7 Reference Unit Rated Air Flow
        Rate`

        Args:
            value (float): value for IDD Field `Speed 7 Reference Unit Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 7 Reference Unit Rated Air Flow Rate"] = value

    @property
    def speed_7_reference_unit_condenser_flow_rate(self):
        """Get speed_7_reference_unit_condenser_flow_rate.

        Returns:
            float: the value of `speed_7_reference_unit_condenser_flow_rate` or None if not set

        """
        return self["Speed 7 Reference Unit Condenser Flow Rate"]

    @speed_7_reference_unit_condenser_flow_rate.setter
    def speed_7_reference_unit_condenser_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 7 Reference Unit Condenser Flow
        Rate`

        Args:
            value (float): value for IDD Field `Speed 7 Reference Unit Condenser Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 7 Reference Unit Condenser Flow Rate"] = value

    @property
    def speed_7_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self):
        """Get
        speed_7_reference_unit_rated_pad_effectiveness_of_evap_precooling.

        Returns:
            float: the value of `speed_7_reference_unit_rated_pad_effectiveness_of_evap_precooling` or None if not set

        """
        return self[
            "Speed 7 Reference Unit Rated Pad Effectiveness of Evap Precooling"]

    @speed_7_reference_unit_rated_pad_effectiveness_of_evap_precooling.setter
    def speed_7_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self,
            value=None):
        """Corresponds to IDD field `Speed 7 Reference Unit Rated Pad
        Effectiveness of Evap Precooling`

        Args:
            value (float): value for IDD Field `Speed 7 Reference Unit Rated Pad Effectiveness of Evap Precooling`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 7 Reference Unit Rated Pad Effectiveness of Evap Precooling"] = value

    @property
    def speed_7_total_cooling_capacity_function_of_temperature_curve_name(
            self):
        """Get
        speed_7_total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_7_total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 7 Total Cooling Capacity Function of Temperature Curve Name"]

    @speed_7_total_cooling_capacity_function_of_temperature_curve_name.setter
    def speed_7_total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 7 Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 7 Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 7 Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_7_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self):
        """Get speed_7_total_cooling_capacity_function_of_air_flow_fraction_cur
        ve_name.

        Returns:
            str: the value of `speed_7_total_cooling_capacity_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 7 Total Cooling Capacity Function of Air Flow Fraction Curve Name"]

    @speed_7_total_cooling_capacity_function_of_air_flow_fraction_curve_name.setter
    def speed_7_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 7 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 7 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 7 Total Cooling Capacity Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_7_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_7_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_7_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 7 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_7_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_7_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 7 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 7 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 7 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_7_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self):
        """Get
        speed_7_energy_input_ratio_function_of_air_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_7_energy_input_ratio_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 7 Energy Input Ratio Function of Air Flow Fraction Curve Name"]

    @speed_7_energy_input_ratio_function_of_air_flow_fraction_curve_name.setter
    def speed_7_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 7 Energy Input Ratio Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 7 Energy Input Ratio Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 7 Energy Input Ratio Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_8_reference_unit_gross_rated_total_cooling_capacity(self):
        """Get speed_8_reference_unit_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `speed_8_reference_unit_gross_rated_total_cooling_capacity` or None if not set

        """
        return self[
            "Speed 8 Reference Unit Gross Rated Total Cooling Capacity"]

    @speed_8_reference_unit_gross_rated_total_cooling_capacity.setter
    def speed_8_reference_unit_gross_rated_total_cooling_capacity(
            self,
            value=None):
        """Corresponds to IDD field `Speed 8 Reference Unit Gross Rated Total
        Cooling Capacity` Total cooling capacity not accounting for the effect
        of supply air fan heat.

        Args:
            value (float): value for IDD Field `Speed 8 Reference Unit Gross Rated Total Cooling Capacity`
                Units: w
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 8 Reference Unit Gross Rated Total Cooling Capacity"] = value

    @property
    def speed_8_reference_unit_gross_rated_sensible_heat_ratio(self):
        """Get speed_8_reference_unit_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `speed_8_reference_unit_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Speed 8 Reference Unit Gross Rated Sensible Heat Ratio"]

    @speed_8_reference_unit_gross_rated_sensible_heat_ratio.setter
    def speed_8_reference_unit_gross_rated_sensible_heat_ratio(
            self,
            value=None):
        """Corresponds to IDD field `Speed 8 Reference Unit Gross Rated
        Sensible Heat Ratio`

        Args:
            value (float): value for IDD Field `Speed 8 Reference Unit Gross Rated Sensible Heat Ratio`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 8 Reference Unit Gross Rated Sensible Heat Ratio"] = value

    @property
    def speed_8_reference_unit_gross_rated_cooling_cop(self):
        """Get speed_8_reference_unit_gross_rated_cooling_cop.

        Returns:
            float: the value of `speed_8_reference_unit_gross_rated_cooling_cop` or None if not set

        """
        return self["Speed 8 Reference Unit Gross Rated Cooling COP"]

    @speed_8_reference_unit_gross_rated_cooling_cop.setter
    def speed_8_reference_unit_gross_rated_cooling_cop(self, value=None):
        """Corresponds to IDD field `Speed 8 Reference Unit Gross Rated Cooling
        COP`

        Args:
            value (float): value for IDD Field `Speed 8 Reference Unit Gross Rated Cooling COP`
                Units: dimensionless
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 8 Reference Unit Gross Rated Cooling COP"] = value

    @property
    def speed_8_reference_unit_rated_air_flow_rate(self):
        """Get speed_8_reference_unit_rated_air_flow_rate.

        Returns:
            float: the value of `speed_8_reference_unit_rated_air_flow_rate` or None if not set

        """
        return self["Speed 8 Reference Unit Rated Air Flow Rate"]

    @speed_8_reference_unit_rated_air_flow_rate.setter
    def speed_8_reference_unit_rated_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 8 Reference Unit Rated Air Flow
        Rate`

        Args:
            value (float): value for IDD Field `Speed 8 Reference Unit Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 8 Reference Unit Rated Air Flow Rate"] = value

    @property
    def speed_8_reference_unit_condenser_air_flow_rate(self):
        """Get speed_8_reference_unit_condenser_air_flow_rate.

        Returns:
            float: the value of `speed_8_reference_unit_condenser_air_flow_rate` or None if not set

        """
        return self["Speed 8 Reference Unit Condenser Air Flow Rate"]

    @speed_8_reference_unit_condenser_air_flow_rate.setter
    def speed_8_reference_unit_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 8 Reference Unit Condenser Air Flow
        Rate`

        Args:
            value (float): value for IDD Field `Speed 8 Reference Unit Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 8 Reference Unit Condenser Air Flow Rate"] = value

    @property
    def speed_8_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self):
        """Get
        speed_8_reference_unit_rated_pad_effectiveness_of_evap_precooling.

        Returns:
            float: the value of `speed_8_reference_unit_rated_pad_effectiveness_of_evap_precooling` or None if not set

        """
        return self[
            "Speed 8 Reference Unit Rated Pad Effectiveness of Evap Precooling"]

    @speed_8_reference_unit_rated_pad_effectiveness_of_evap_precooling.setter
    def speed_8_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self,
            value=None):
        """Corresponds to IDD field `Speed 8 Reference Unit Rated Pad
        Effectiveness of Evap Precooling`

        Args:
            value (float): value for IDD Field `Speed 8 Reference Unit Rated Pad Effectiveness of Evap Precooling`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 8 Reference Unit Rated Pad Effectiveness of Evap Precooling"] = value

    @property
    def speed_8_total_cooling_capacity_function_of_temperature_curve_name(
            self):
        """Get
        speed_8_total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_8_total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 8 Total Cooling Capacity Function of Temperature Curve Name"]

    @speed_8_total_cooling_capacity_function_of_temperature_curve_name.setter
    def speed_8_total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 8 Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 8 Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 8 Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_8_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self):
        """Get speed_8_total_cooling_capacity_function_of_air_flow_fraction_cur
        ve_name.

        Returns:
            str: the value of `speed_8_total_cooling_capacity_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 8 Total Cooling Capacity Function of Air Flow Fraction Curve Name"]

    @speed_8_total_cooling_capacity_function_of_air_flow_fraction_curve_name.setter
    def speed_8_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 8 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 8 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 8 Total Cooling Capacity Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_8_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_8_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_8_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 8 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_8_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_8_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 8 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 8 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 8 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_8_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self):
        """Get
        speed_8_energy_input_ratio_function_of_air_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_8_energy_input_ratio_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 8 Energy Input Ratio Function of Air Flow Fraction Curve Name"]

    @speed_8_energy_input_ratio_function_of_air_flow_fraction_curve_name.setter
    def speed_8_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 8 Energy Input Ratio Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 8 Energy Input Ratio Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 8 Energy Input Ratio Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_9_reference_unit_gross_rated_total_cooling_capacity(self):
        """Get speed_9_reference_unit_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `speed_9_reference_unit_gross_rated_total_cooling_capacity` or None if not set

        """
        return self[
            "Speed 9 Reference Unit Gross Rated Total Cooling Capacity"]

    @speed_9_reference_unit_gross_rated_total_cooling_capacity.setter
    def speed_9_reference_unit_gross_rated_total_cooling_capacity(
            self,
            value=None):
        """Corresponds to IDD field `Speed 9 Reference Unit Gross Rated Total
        Cooling Capacity` Total cooling capacity not accounting for the effect
        of supply air fan heat.

        Args:
            value (float): value for IDD Field `Speed 9 Reference Unit Gross Rated Total Cooling Capacity`
                Units: w
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 9 Reference Unit Gross Rated Total Cooling Capacity"] = value

    @property
    def speed_9_reference_unit_gross_rated_sensible_heat_ratio(self):
        """Get speed_9_reference_unit_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `speed_9_reference_unit_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Speed 9 Reference Unit Gross Rated Sensible Heat Ratio"]

    @speed_9_reference_unit_gross_rated_sensible_heat_ratio.setter
    def speed_9_reference_unit_gross_rated_sensible_heat_ratio(
            self,
            value=None):
        """Corresponds to IDD field `Speed 9 Reference Unit Gross Rated
        Sensible Heat Ratio`

        Args:
            value (float): value for IDD Field `Speed 9 Reference Unit Gross Rated Sensible Heat Ratio`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 9 Reference Unit Gross Rated Sensible Heat Ratio"] = value

    @property
    def speed_9_reference_unit_gross_rated_cooling_cop(self):
        """Get speed_9_reference_unit_gross_rated_cooling_cop.

        Returns:
            float: the value of `speed_9_reference_unit_gross_rated_cooling_cop` or None if not set

        """
        return self["Speed 9 Reference Unit Gross Rated Cooling COP"]

    @speed_9_reference_unit_gross_rated_cooling_cop.setter
    def speed_9_reference_unit_gross_rated_cooling_cop(self, value=None):
        """Corresponds to IDD field `Speed 9 Reference Unit Gross Rated Cooling
        COP`

        Args:
            value (float): value for IDD Field `Speed 9 Reference Unit Gross Rated Cooling COP`
                Units: dimensionless
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 9 Reference Unit Gross Rated Cooling COP"] = value

    @property
    def speed_9_reference_unit_rated_air_flow_rate(self):
        """Get speed_9_reference_unit_rated_air_flow_rate.

        Returns:
            float: the value of `speed_9_reference_unit_rated_air_flow_rate` or None if not set

        """
        return self["Speed 9 Reference Unit Rated Air Flow Rate"]

    @speed_9_reference_unit_rated_air_flow_rate.setter
    def speed_9_reference_unit_rated_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 9 Reference Unit Rated Air Flow
        Rate`

        Args:
            value (float): value for IDD Field `Speed 9 Reference Unit Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 9 Reference Unit Rated Air Flow Rate"] = value

    @property
    def speed_9_reference_unit_condenser_air_flow_rate(self):
        """Get speed_9_reference_unit_condenser_air_flow_rate.

        Returns:
            float: the value of `speed_9_reference_unit_condenser_air_flow_rate` or None if not set

        """
        return self["Speed 9 Reference Unit Condenser Air Flow Rate"]

    @speed_9_reference_unit_condenser_air_flow_rate.setter
    def speed_9_reference_unit_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 9 Reference Unit Condenser Air Flow
        Rate` optional.

        Args:
            value (float): value for IDD Field `Speed 9 Reference Unit Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 9 Reference Unit Condenser Air Flow Rate"] = value

    @property
    def speed_9_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self):
        """Get
        speed_9_reference_unit_rated_pad_effectiveness_of_evap_precooling.

        Returns:
            float: the value of `speed_9_reference_unit_rated_pad_effectiveness_of_evap_precooling` or None if not set

        """
        return self[
            "Speed 9 Reference Unit Rated Pad Effectiveness of Evap Precooling"]

    @speed_9_reference_unit_rated_pad_effectiveness_of_evap_precooling.setter
    def speed_9_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self,
            value=None):
        """Corresponds to IDD field `Speed 9 Reference Unit Rated Pad
        Effectiveness of Evap Precooling` optional.

        Args:
            value (float): value for IDD Field `Speed 9 Reference Unit Rated Pad Effectiveness of Evap Precooling`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 9 Reference Unit Rated Pad Effectiveness of Evap Precooling"] = value

    @property
    def speed_9_total_cooling_capacity_function_of_temperature_curve_name(
            self):
        """Get
        speed_9_total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_9_total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 9 Total Cooling Capacity Function of Temperature Curve Name"]

    @speed_9_total_cooling_capacity_function_of_temperature_curve_name.setter
    def speed_9_total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 9 Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 9 Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 9 Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_9_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self):
        """Get speed_9_total_cooling_capacity_function_of_air_flow_fraction_cur
        ve_name.

        Returns:
            str: the value of `speed_9_total_cooling_capacity_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 9 Total Cooling Capacity Function of Air Flow Fraction Curve Name"]

    @speed_9_total_cooling_capacity_function_of_air_flow_fraction_curve_name.setter
    def speed_9_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 9 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 9 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 9 Total Cooling Capacity Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_9_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_9_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_9_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 9 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_9_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_9_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 9 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 9 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 9 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_9_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self):
        """Get
        speed_9_energy_input_ratio_function_of_air_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_9_energy_input_ratio_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 9 Energy Input Ratio Function of Air Flow Fraction Curve Name"]

    @speed_9_energy_input_ratio_function_of_air_flow_fraction_curve_name.setter
    def speed_9_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 9 Energy Input Ratio Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 9 Energy Input Ratio Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 9 Energy Input Ratio Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_10_reference_unit_gross_rated_total_cooling_capacity(self):
        """Get speed_10_reference_unit_gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `speed_10_reference_unit_gross_rated_total_cooling_capacity` or None if not set

        """
        return self[
            "Speed 10 Reference Unit Gross Rated Total Cooling Capacity"]

    @speed_10_reference_unit_gross_rated_total_cooling_capacity.setter
    def speed_10_reference_unit_gross_rated_total_cooling_capacity(
            self,
            value=None):
        """Corresponds to IDD field `Speed 10 Reference Unit Gross Rated Total
        Cooling Capacity` Total cooling capacity not accounting for the effect
        of supply air fan heat.

        Args:
            value (float): value for IDD Field `Speed 10 Reference Unit Gross Rated Total Cooling Capacity`
                Units: w
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 10 Reference Unit Gross Rated Total Cooling Capacity"] = value

    @property
    def speed_10_reference_unit_gross_rated_sensible_heat_ratio(self):
        """Get speed_10_reference_unit_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `speed_10_reference_unit_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Speed 10 Reference Unit Gross Rated Sensible Heat Ratio"]

    @speed_10_reference_unit_gross_rated_sensible_heat_ratio.setter
    def speed_10_reference_unit_gross_rated_sensible_heat_ratio(
            self,
            value=None):
        """Corresponds to IDD field `Speed 10 Reference Unit Gross Rated
        Sensible Heat Ratio`

        Args:
            value (float): value for IDD Field `Speed 10 Reference Unit Gross Rated Sensible Heat Ratio`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 10 Reference Unit Gross Rated Sensible Heat Ratio"] = value

    @property
    def speed_10_reference_unit_gross_rated_cooling_cop(self):
        """Get speed_10_reference_unit_gross_rated_cooling_cop.

        Returns:
            float: the value of `speed_10_reference_unit_gross_rated_cooling_cop` or None if not set

        """
        return self["Speed 10 Reference Unit Gross Rated Cooling COP"]

    @speed_10_reference_unit_gross_rated_cooling_cop.setter
    def speed_10_reference_unit_gross_rated_cooling_cop(self, value=None):
        """Corresponds to IDD field `Speed 10 Reference Unit Gross Rated
        Cooling COP`

        Args:
            value (float): value for IDD Field `Speed 10 Reference Unit Gross Rated Cooling COP`
                Units: dimensionless
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 10 Reference Unit Gross Rated Cooling COP"] = value

    @property
    def speed_10_reference_unit_rated_air_flow_rate(self):
        """Get speed_10_reference_unit_rated_air_flow_rate.

        Returns:
            float: the value of `speed_10_reference_unit_rated_air_flow_rate` or None if not set

        """
        return self["Speed 10 Reference Unit Rated Air Flow Rate"]

    @speed_10_reference_unit_rated_air_flow_rate.setter
    def speed_10_reference_unit_rated_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 10 Reference Unit Rated Air Flow
        Rate`

        Args:
            value (float): value for IDD Field `Speed 10 Reference Unit Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 10 Reference Unit Rated Air Flow Rate"] = value

    @property
    def speed_10_reference_unit_condenser_air_flow_rate(self):
        """Get speed_10_reference_unit_condenser_air_flow_rate.

        Returns:
            float: the value of `speed_10_reference_unit_condenser_air_flow_rate` or None if not set

        """
        return self["Speed 10 Reference Unit Condenser Air Flow Rate"]

    @speed_10_reference_unit_condenser_air_flow_rate.setter
    def speed_10_reference_unit_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Speed 10 Reference Unit Condenser Air Flow
        Rate` optional.

        Args:
            value (float): value for IDD Field `Speed 10 Reference Unit Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 10 Reference Unit Condenser Air Flow Rate"] = value

    @property
    def speed_10_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self):
        """Get
        speed_10_reference_unit_rated_pad_effectiveness_of_evap_precooling.

        Returns:
            float: the value of `speed_10_reference_unit_rated_pad_effectiveness_of_evap_precooling` or None if not set

        """
        return self[
            "Speed 10 Reference Unit Rated Pad Effectiveness of Evap Precooling"]

    @speed_10_reference_unit_rated_pad_effectiveness_of_evap_precooling.setter
    def speed_10_reference_unit_rated_pad_effectiveness_of_evap_precooling(
            self,
            value=None):
        """Corresponds to IDD field `Speed 10 Reference Unit Rated Pad
        Effectiveness of Evap Precooling` optional.

        Args:
            value (float): value for IDD Field `Speed 10 Reference Unit Rated Pad Effectiveness of Evap Precooling`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Speed 10 Reference Unit Rated Pad Effectiveness of Evap Precooling"] = value

    @property
    def speed_10_total_cooling_capacity_function_of_temperature_curve_name(
            self):
        """Get
        speed_10_total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_10_total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 10 Total Cooling Capacity Function of Temperature Curve Name"]

    @speed_10_total_cooling_capacity_function_of_temperature_curve_name.setter
    def speed_10_total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 10 Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 10 Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 10 Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_10_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self):
        """Get speed_10_total_cooling_capacity_function_of_air_flow_fraction_cu
        rve_name.

        Returns:
            str: the value of `speed_10_total_cooling_capacity_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 10 Total Cooling Capacity Function of Air Flow Fraction Curve Name"]

    @speed_10_total_cooling_capacity_function_of_air_flow_fraction_curve_name.setter
    def speed_10_total_cooling_capacity_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 10 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
        optional
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 10 Total Cooling Capacity Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 10 Total Cooling Capacity Function of Air Flow Fraction Curve Name"] = value

    @property
    def speed_10_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_10_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_10_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 10 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_10_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_10_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 10 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*odb + e*odb**2 + f*wb*odb
        wb = entering wet-bulb temperature (C)
        odb = air entering temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Speed 10 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 10 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_10_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self):
        """Get speed_10_energy_input_ratio_function_of_air_flow_fraction_curve_
        name.

        Returns:
            str: the value of `speed_10_energy_input_ratio_function_of_air_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 10 Energy Input Ratio Function of Air Flow Fraction Curve Name"]

    @speed_10_energy_input_ratio_function_of_air_flow_fraction_curve_name.setter
    def speed_10_energy_input_ratio_function_of_air_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 10 Energy Input Ratio Function of Air Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ffa + c*ffa**2
        cubic curve = a + b*ffa + c*ffa**2 + d*ffa**3
        ffa = Fraction of the full load Air Flow

        Args:
            value (str): value for IDD Field `Speed 10 Energy Input Ratio Function of Air Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 10 Energy Input Ratio Function of Air Flow Fraction Curve Name"] = value




class CoilCoolingDxTwoStageWithHumidityControlMode(DataObject):

    """ Corresponds to IDD object `Coil:Cooling:DX:TwoStageWithHumidityControlMode`
        Direct expansion (DX) cooling coil and condensing unit (includes electric compressor
        and condenser fan), two-stage with humidity control mode (e.g. sub-cool or hot gas
        reheat). Optional inputs for moisture evaporation from wet coil when compressor
        cycles off with continuous fan operation. Requires two to four sets of performance
        data, see CoilPerformance:DX:Cooling. Stages are modeled as a face-split coil.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'air inlet node name',
                                      {'name': u'Air Inlet Node Name',
                                       'pyname': u'air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air outlet node name',
                                      {'name': u'Air Outlet Node Name',
                                       'pyname': u'air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'crankcase heater capacity',
                                      {'name': u'Crankcase Heater Capacity',
                                       'pyname': u'crankcase_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'maximum outdoor dry-bulb temperature for crankcase heater operation',
                                      {'name': u'Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation',
                                       'pyname': u'maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation',
                                       'default': 10.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'number of capacity stages',
                                      {'name': u'Number of Capacity Stages',
                                       'pyname': u'number_of_capacity_stages',
                                       'default': 1,
                                       'maximum': 2,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 1,
                                       'autocalculatable': False,
                                       'type': u'integer'}),
                                     (u'number of enhanced dehumidification modes',
                                      {'name': u'Number of Enhanced Dehumidification Modes',
                                       'pyname': u'number_of_enhanced_dehumidification_modes',
                                       'default': 0,
                                       'maximum': 1,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0,
                                       'autocalculatable': False,
                                       'type': u'integer'}),
                                     (u'normal mode stage 1 coil performance object type',
                                      {'name': u'Normal Mode Stage 1 Coil Performance Object Type',
                                       'pyname': u'normal_mode_stage_1_coil_performance_object_type',
                                       'required-field': True,
                                       'autosizable': False,
                                       'accepted-values': [u'CoilPerformance:DX:Cooling'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'normal mode stage 1 coil performance name',
                                      {'name': u'Normal Mode Stage 1 Coil Performance Name',
                                       'pyname': u'normal_mode_stage_1_coil_performance_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'normal mode stage 1+2 coil performance object type',
                                      {'name': u'Normal Mode Stage 1+2 Coil Performance Object Type',
                                       'pyname': u'normal_mode_stage_12_coil_performance_object_type',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'CoilPerformance:DX:Cooling'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'normal mode stage 1+2 coil performance name',
                                      {'name': u'Normal Mode Stage 1+2 Coil Performance Name',
                                       'pyname': u'normal_mode_stage_12_coil_performance_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'dehumidification mode 1 stage 1 coil performance object type',
                                      {'name': u'Dehumidification Mode 1 Stage 1 Coil Performance Object Type',
                                       'pyname': u'dehumidification_mode_1_stage_1_coil_performance_object_type',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'CoilPerformance:DX:Cooling'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'dehumidification mode 1 stage 1 coil performance name',
                                      {'name': u'Dehumidification Mode 1 Stage 1 Coil Performance Name',
                                       'pyname': u'dehumidification_mode_1_stage_1_coil_performance_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'dehumidification mode 1 stage 1+2 coil performance object type',
                                      {'name': u'Dehumidification Mode 1 Stage 1+2 Coil Performance Object Type',
                                       'pyname': u'dehumidification_mode_1_stage_12_coil_performance_object_type',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'CoilPerformance:DX:Cooling'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'dehumidification mode 1 stage 1+2 coil performance name',
                                      {'name': u'Dehumidification Mode 1 Stage 1+2 Coil Performance Name',
                                       'pyname': u'dehumidification_mode_1_stage_12_coil_performance_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply water storage tank name',
                                      {'name': u'Supply Water Storage Tank Name',
                                       'pyname': u'supply_water_storage_tank_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'condensate collection water storage tank name',
                                      {'name': u'Condensate Collection Water Storage Tank Name',
                                       'pyname': u'condensate_collection_water_storage_tank_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'basin heater capacity',
                                      {'name': u'Basin Heater Capacity',
                                       'pyname': u'basin_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/K'}),
                                     (u'basin heater setpoint temperature',
                                      {'name': u'Basin Heater Setpoint Temperature',
                                       'pyname': u'basin_heater_setpoint_temperature',
                                       'default': 2.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 2.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'basin heater operating schedule name',
                                      {'name': u'Basin Heater Operating Schedule Name',
                                       'pyname': u'basin_heater_operating_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 10,
              'name': u'Coil:Cooling:DX:TwoStageWithHumidityControlMode',
              'pyname': u'CoilCoolingDxTwoStageWithHumidityControlMode',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def air_inlet_node_name(self):
        """Get air_inlet_node_name.

        Returns:
            str: the value of `air_inlet_node_name` or None if not set

        """
        return self["Air Inlet Node Name"]

    @air_inlet_node_name.setter
    def air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Inlet Node Name"] = value

    @property
    def air_outlet_node_name(self):
        """Get air_outlet_node_name.

        Returns:
            str: the value of `air_outlet_node_name` or None if not set

        """
        return self["Air Outlet Node Name"]

    @air_outlet_node_name.setter
    def air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Outlet Node Name"] = value

    @property
    def crankcase_heater_capacity(self):
        """Get crankcase_heater_capacity.

        Returns:
            float: the value of `crankcase_heater_capacity` or None if not set

        """
        return self["Crankcase Heater Capacity"]

    @crankcase_heater_capacity.setter
    def crankcase_heater_capacity(self, value=None):
        """Corresponds to IDD field `Crankcase Heater Capacity`

        Args:
            value (float): value for IDD Field `Crankcase Heater Capacity`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Crankcase Heater Capacity"] = value

    @property
    def maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation(
            self):
        """Get
        maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation.

        Returns:
            float: the value of `maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation` or None if not set

        """
        return self[
            "Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation"]

    @maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation.setter
    def maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation(
            self,
            value=10.0):
        """  Corresponds to IDD field `Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation`

        Args:
            value (float): value for IDD Field `Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation`
                Units: C
                Default value: 10.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation"] = value

    @property
    def number_of_capacity_stages(self):
        """Get number_of_capacity_stages.

        Returns:
            int: the value of `number_of_capacity_stages` or None if not set

        """
        return self["Number of Capacity Stages"]

    @number_of_capacity_stages.setter
    def number_of_capacity_stages(self, value=1):
        """Corresponds to IDD field `Number of Capacity Stages`

        Args:
            value (int): value for IDD Field `Number of Capacity Stages`
                Default value: 1
                value >= 1
                value <= 2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Number of Capacity Stages"] = value

    @property
    def number_of_enhanced_dehumidification_modes(self):
        """Get number_of_enhanced_dehumidification_modes.

        Returns:
            int: the value of `number_of_enhanced_dehumidification_modes` or None if not set

        """
        return self["Number of Enhanced Dehumidification Modes"]

    @number_of_enhanced_dehumidification_modes.setter
    def number_of_enhanced_dehumidification_modes(self, value=None):
        """Corresponds to IDD field `Number of Enhanced Dehumidification Modes`

        Args:
            value (int): value for IDD Field `Number of Enhanced Dehumidification Modes`
                value <= 1
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Number of Enhanced Dehumidification Modes"] = value

    @property
    def normal_mode_stage_1_coil_performance_object_type(self):
        """Get normal_mode_stage_1_coil_performance_object_type.

        Returns:
            str: the value of `normal_mode_stage_1_coil_performance_object_type` or None if not set

        """
        return self["Normal Mode Stage 1 Coil Performance Object Type"]

    @normal_mode_stage_1_coil_performance_object_type.setter
    def normal_mode_stage_1_coil_performance_object_type(self, value=None):
        """Corresponds to IDD field `Normal Mode Stage 1 Coil Performance
        Object Type`

        Args:
            value (str): value for IDD Field `Normal Mode Stage 1 Coil Performance Object Type`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Normal Mode Stage 1 Coil Performance Object Type"] = value

    @property
    def normal_mode_stage_1_coil_performance_name(self):
        """Get normal_mode_stage_1_coil_performance_name.

        Returns:
            str: the value of `normal_mode_stage_1_coil_performance_name` or None if not set

        """
        return self["Normal Mode Stage 1 Coil Performance Name"]

    @normal_mode_stage_1_coil_performance_name.setter
    def normal_mode_stage_1_coil_performance_name(self, value=None):
        """Corresponds to IDD field `Normal Mode Stage 1 Coil Performance Name`

        Args:
            value (str): value for IDD Field `Normal Mode Stage 1 Coil Performance Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Normal Mode Stage 1 Coil Performance Name"] = value

    @property
    def normal_mode_stage_12_coil_performance_object_type(self):
        """Get normal_mode_stage_12_coil_performance_object_type.

        Returns:
            str: the value of `normal_mode_stage_12_coil_performance_object_type` or None if not set

        """
        return self["Normal Mode Stage 1+2 Coil Performance Object Type"]

    @normal_mode_stage_12_coil_performance_object_type.setter
    def normal_mode_stage_12_coil_performance_object_type(self, value=None):
        """Corresponds to IDD field `Normal Mode Stage 1+2 Coil Performance
        Object Type`

        Args:
            value (str): value for IDD Field `Normal Mode Stage 1+2 Coil Performance Object Type`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Normal Mode Stage 1+2 Coil Performance Object Type"] = value

    @property
    def normal_mode_stage_12_coil_performance_name(self):
        """Get normal_mode_stage_12_coil_performance_name.

        Returns:
            str: the value of `normal_mode_stage_12_coil_performance_name` or None if not set

        """
        return self["Normal Mode Stage 1+2 Coil Performance Name"]

    @normal_mode_stage_12_coil_performance_name.setter
    def normal_mode_stage_12_coil_performance_name(self, value=None):
        """Corresponds to IDD field `Normal Mode Stage 1+2 Coil Performance
        Name`

        Args:
            value (str): value for IDD Field `Normal Mode Stage 1+2 Coil Performance Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Normal Mode Stage 1+2 Coil Performance Name"] = value

    @property
    def dehumidification_mode_1_stage_1_coil_performance_object_type(self):
        """Get dehumidification_mode_1_stage_1_coil_performance_object_type.

        Returns:
            str: the value of `dehumidification_mode_1_stage_1_coil_performance_object_type` or None if not set

        """
        return self[
            "Dehumidification Mode 1 Stage 1 Coil Performance Object Type"]

    @dehumidification_mode_1_stage_1_coil_performance_object_type.setter
    def dehumidification_mode_1_stage_1_coil_performance_object_type(
            self,
            value=None):
        """Corresponds to IDD field `Dehumidification Mode 1 Stage 1 Coil
        Performance Object Type`

        Args:
            value (str): value for IDD Field `Dehumidification Mode 1 Stage 1 Coil Performance Object Type`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Dehumidification Mode 1 Stage 1 Coil Performance Object Type"] = value

    @property
    def dehumidification_mode_1_stage_1_coil_performance_name(self):
        """Get dehumidification_mode_1_stage_1_coil_performance_name.

        Returns:
            str: the value of `dehumidification_mode_1_stage_1_coil_performance_name` or None if not set

        """
        return self["Dehumidification Mode 1 Stage 1 Coil Performance Name"]

    @dehumidification_mode_1_stage_1_coil_performance_name.setter
    def dehumidification_mode_1_stage_1_coil_performance_name(
            self,
            value=None):
        """Corresponds to IDD field `Dehumidification Mode 1 Stage 1 Coil
        Performance Name`

        Args:
            value (str): value for IDD Field `Dehumidification Mode 1 Stage 1 Coil Performance Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Dehumidification Mode 1 Stage 1 Coil Performance Name"] = value

    @property
    def dehumidification_mode_1_stage_12_coil_performance_object_type(self):
        """Get dehumidification_mode_1_stage_12_coil_performance_object_type.

        Returns:
            str: the value of `dehumidification_mode_1_stage_12_coil_performance_object_type` or None if not set

        """
        return self[
            "Dehumidification Mode 1 Stage 1+2 Coil Performance Object Type"]

    @dehumidification_mode_1_stage_12_coil_performance_object_type.setter
    def dehumidification_mode_1_stage_12_coil_performance_object_type(
            self,
            value=None):
        """Corresponds to IDD field `Dehumidification Mode 1 Stage 1+2 Coil
        Performance Object Type`

        Args:
            value (str): value for IDD Field `Dehumidification Mode 1 Stage 1+2 Coil Performance Object Type`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Dehumidification Mode 1 Stage 1+2 Coil Performance Object Type"] = value

    @property
    def dehumidification_mode_1_stage_12_coil_performance_name(self):
        """Get dehumidification_mode_1_stage_12_coil_performance_name.

        Returns:
            str: the value of `dehumidification_mode_1_stage_12_coil_performance_name` or None if not set

        """
        return self["Dehumidification Mode 1 Stage 1+2 Coil Performance Name"]

    @dehumidification_mode_1_stage_12_coil_performance_name.setter
    def dehumidification_mode_1_stage_12_coil_performance_name(
            self,
            value=None):
        """Corresponds to IDD field `Dehumidification Mode 1 Stage 1+2 Coil
        Performance Name`

        Args:
            value (str): value for IDD Field `Dehumidification Mode 1 Stage 1+2 Coil Performance Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Dehumidification Mode 1 Stage 1+2 Coil Performance Name"] = value

    @property
    def supply_water_storage_tank_name(self):
        """Get supply_water_storage_tank_name.

        Returns:
            str: the value of `supply_water_storage_tank_name` or None if not set

        """
        return self["Supply Water Storage Tank Name"]

    @supply_water_storage_tank_name.setter
    def supply_water_storage_tank_name(self, value=None):
        """Corresponds to IDD field `Supply Water Storage Tank Name`

        Args:
            value (str): value for IDD Field `Supply Water Storage Tank Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Water Storage Tank Name"] = value

    @property
    def condensate_collection_water_storage_tank_name(self):
        """Get condensate_collection_water_storage_tank_name.

        Returns:
            str: the value of `condensate_collection_water_storage_tank_name` or None if not set

        """
        return self["Condensate Collection Water Storage Tank Name"]

    @condensate_collection_water_storage_tank_name.setter
    def condensate_collection_water_storage_tank_name(self, value=None):
        """Corresponds to IDD field `Condensate Collection Water Storage Tank
        Name`

        Args:
            value (str): value for IDD Field `Condensate Collection Water Storage Tank Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Condensate Collection Water Storage Tank Name"] = value

    @property
    def basin_heater_capacity(self):
        """Get basin_heater_capacity.

        Returns:
            float: the value of `basin_heater_capacity` or None if not set

        """
        return self["Basin Heater Capacity"]

    @basin_heater_capacity.setter
    def basin_heater_capacity(self, value=None):
        """  Corresponds to IDD field `Basin Heater Capacity`
        This field is only used for Condenser Type = EvaporativelyCooled and for periods
        when the basin heater is available (field Basin Heater Operating Schedule Name).
        For this situation, the heater maintains the basin water temperature at the basin heater
        setpoint temperature when the outdoor air temperature falls below the setpoint temperature.
        The basin heater only operates when the DX coil is off.

        Args:
            value (float): value for IDD Field `Basin Heater Capacity`
                Units: W/K
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Capacity"] = value

    @property
    def basin_heater_setpoint_temperature(self):
        """Get basin_heater_setpoint_temperature.

        Returns:
            float: the value of `basin_heater_setpoint_temperature` or None if not set

        """
        return self["Basin Heater Setpoint Temperature"]

    @basin_heater_setpoint_temperature.setter
    def basin_heater_setpoint_temperature(self, value=2.0):
        """  Corresponds to IDD field `Basin Heater Setpoint Temperature`
        This field is only used for Condenser Type = EvaporativelyCooled.
        Enter the outdoor dry-bulb temperature when the basin heater turns on.

        Args:
            value (float): value for IDD Field `Basin Heater Setpoint Temperature`
                Units: C
                Default value: 2.0
                value >= 2.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Setpoint Temperature"] = value

    @property
    def basin_heater_operating_schedule_name(self):
        """Get basin_heater_operating_schedule_name.

        Returns:
            str: the value of `basin_heater_operating_schedule_name` or None if not set

        """
        return self["Basin Heater Operating Schedule Name"]

    @basin_heater_operating_schedule_name.setter
    def basin_heater_operating_schedule_name(self, value=None):
        """  Corresponds to IDD field `Basin Heater Operating Schedule Name`
        This field is only used for Condenser Type = EvaporativelyCooled.
        Schedule values greater than 0 allow the basin heater to operate whenever the outdoor
        air dry-bulb temperature is below the basin heater setpoint temperature.
        If a schedule name is not entered, the basin heater is allowed to operate
        throughout the entire simulation.

        Args:
            value (str): value for IDD Field `Basin Heater Operating Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Operating Schedule Name"] = value




class CoilPerformanceDxCooling(DataObject):

    """ Corresponds to IDD object `CoilPerformance:DX:Cooling`
        Used to specify DX cooling coil performance for one mode of operation for a
        Coil:Cooling:DX:TwoStageWithHumidityControlMode object which may reference one to four
        CoilPerformance:DX:Cooling objects depending on the specified number of stages and
        dehumidification modes. In nearly all cases, the Rated Air Flow Rate will be the same
        for all performance objects associated with a given coil. If bypass is specified,
        the Rated Air Flow Rate includes both the bypassed flow and the flow through the
        active part of the coil.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'gross rated total cooling capacity',
                                      {'name': u'Gross Rated Total Cooling Capacity',
                                       'pyname': u'gross_rated_total_cooling_capacity',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'gross rated sensible heat ratio',
                                      {'name': u'Gross Rated Sensible Heat Ratio',
                                       'pyname': u'gross_rated_sensible_heat_ratio',
                                       'maximum': 1.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'minimum': 0.5,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'gross rated cooling cop',
                                      {'name': u'Gross Rated Cooling COP',
                                       'pyname': u'gross_rated_cooling_cop',
                                       'default': 3.0,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'rated air flow rate',
                                      {'name': u'Rated Air Flow Rate',
                                       'pyname': u'rated_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'fraction of air flow bypassed around coil',
                                      {'name': u'Fraction of Air Flow Bypassed Around Coil',
                                       'pyname': u'fraction_of_air_flow_bypassed_around_coil',
                                       'default': 0.0,
                                       'maximum<': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'total cooling capacity function of temperature curve name',
                                      {'name': u'Total Cooling Capacity Function of Temperature Curve Name',
                                       'pyname': u'total_cooling_capacity_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'total cooling capacity function of flow fraction curve name',
                                      {'name': u'Total Cooling Capacity Function of Flow Fraction Curve Name',
                                       'pyname': u'total_cooling_capacity_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'energy input ratio function of temperature curve name',
                                      {'name': u'Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'energy input ratio function of flow fraction curve name',
                                      {'name': u'Energy Input Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'energy_input_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'part load fraction correlation curve name',
                                      {'name': u'Part Load Fraction Correlation Curve Name',
                                       'pyname': u'part_load_fraction_correlation_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'nominal time for condensate removal to begin',
                                      {'name': u'Nominal Time for Condensate Removal to Begin',
                                       'pyname': u'nominal_time_for_condensate_removal_to_begin',
                                       'default': 0.0,
                                       'maximum': 3000.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u's'}),
                                     (u'ratio of initial moisture evaporation rate and steady state latent capacity',
                                      {'name': u'Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity',
                                       'pyname': u'ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity',
                                       'default': 0.0,
                                       'maximum': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'maximum cycling rate',
                                      {'name': u'Maximum Cycling Rate',
                                       'pyname': u'maximum_cycling_rate',
                                       'default': 0.0,
                                       'maximum': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'cycles/hr'}),
                                     (u'latent capacity time constant',
                                      {'name': u'Latent Capacity Time Constant',
                                       'pyname': u'latent_capacity_time_constant',
                                       'default': 0.0,
                                       'maximum': 500.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u's'}),
                                     (u'condenser air inlet node name',
                                      {'name': u'Condenser Air Inlet Node Name',
                                       'pyname': u'condenser_air_inlet_node_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'condenser type',
                                      {'name': u'Condenser Type',
                                       'pyname': u'condenser_type',
                                       'default': u'AirCooled',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'AirCooled',
                                                           u'EvaporativelyCooled'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'evaporative condenser effectiveness',
                                      {'name': u'Evaporative Condenser Effectiveness',
                                       'pyname': u'evaporative_condenser_effectiveness',
                                       'default': 0.9,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'evaporative condenser air flow rate',
                                      {'name': u'Evaporative Condenser Air Flow Rate',
                                       'pyname': u'evaporative_condenser_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'evaporative condenser pump rated power consumption',
                                      {'name': u'Evaporative Condenser Pump Rated Power Consumption',
                                       'pyname': u'evaporative_condenser_pump_rated_power_consumption',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'sensible heat ratio function of temperature curve name',
                                      {'name': u'Sensible Heat Ratio Function of Temperature Curve Name',
                                       'pyname': u'sensible_heat_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'sensible heat ratio function of flow fraction curve name',
                                      {'name': u'Sensible Heat Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'sensible_heat_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 11,
              'name': u'CoilPerformance:DX:Cooling',
              'pyname': u'CoilPerformanceDxCooling',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def gross_rated_total_cooling_capacity(self):
        """Get gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `gross_rated_total_cooling_capacity` or None if not set

        """
        return self["Gross Rated Total Cooling Capacity"]

    @gross_rated_total_cooling_capacity.setter
    def gross_rated_total_cooling_capacity(self, value=None):
        """  Corresponds to IDD field `Gross Rated Total Cooling Capacity`
        Total cooling capacity not accounting for the effect of supply air fan heat
        gross capacity excluding supply air fan heat
        rating point: air entering the cooling coil at 26.7 C dry-bulb/19.4 C wet-bulb, and
        air entering the outdoor condenser coil at 35 C dry-bulb/23.9 C wet-bulb

        Args:
            value (float or "Autosize"): value for IDD Field `Gross Rated Total Cooling Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Gross Rated Total Cooling Capacity"] = value

    @property
    def gross_rated_sensible_heat_ratio(self):
        """Get gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Gross Rated Sensible Heat Ratio"]

    @gross_rated_sensible_heat_ratio.setter
    def gross_rated_sensible_heat_ratio(self, value=None):
        """Corresponds to IDD field `Gross Rated Sensible Heat Ratio` Rated
        sensible heat ratio (gross sensible capacity/gross total capacity)
        sensible and total capacities do not include supply fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Gross Rated Sensible Heat Ratio`
                value >= 0.5
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gross Rated Sensible Heat Ratio"] = value

    @property
    def gross_rated_cooling_cop(self):
        """Get gross_rated_cooling_cop.

        Returns:
            float: the value of `gross_rated_cooling_cop` or None if not set

        """
        return self["Gross Rated Cooling COP"]

    @gross_rated_cooling_cop.setter
    def gross_rated_cooling_cop(self, value=3.0):
        """Corresponds to IDD field `Gross Rated Cooling COP` Gross cooling
        capacity divided by power input to the compressor and outdoor fan, does
        not include supply fan heat or supply fan electrical energy input.

        Args:
            value (float): value for IDD Field `Gross Rated Cooling COP`
                Units: W/W
                Default value: 3.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gross Rated Cooling COP"] = value

    @property
    def rated_air_flow_rate(self):
        """Get rated_air_flow_rate.

        Returns:
            float: the value of `rated_air_flow_rate` or None if not set

        """
        return self["Rated Air Flow Rate"]

    @rated_air_flow_rate.setter
    def rated_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Rated Air Flow Rate` Flow rate
        corresponding to Rated total Cooling capacity, Rated SHR and Rated COP.

        Args:
            value (float or "Autosize"): value for IDD Field `Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Rated Air Flow Rate"] = value

    @property
    def fraction_of_air_flow_bypassed_around_coil(self):
        """Get fraction_of_air_flow_bypassed_around_coil.

        Returns:
            float: the value of `fraction_of_air_flow_bypassed_around_coil` or None if not set

        """
        return self["Fraction of Air Flow Bypassed Around Coil"]

    @fraction_of_air_flow_bypassed_around_coil.setter
    def fraction_of_air_flow_bypassed_around_coil(self, value=None):
        """  Corresponds to IDD field `Fraction of Air Flow Bypassed Around Coil`
        Fraction of Rated Air Flow Rate which bypasses the cooling coil
        in this performance mode.  The remaining portion of the flow
        should be between 0.00004027 m3/s and .00006041 m3/s per watt of rated total cooling capacity.
        This is used to model face-split coils on multi-stage units or bypass dampers.
        If total flow rate varies during simulation, the same fraction is bypassed.

        Args:
            value (float): value for IDD Field `Fraction of Air Flow Bypassed Around Coil`
                value < 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Fraction of Air Flow Bypassed Around Coil"] = value

    @property
    def total_cooling_capacity_function_of_temperature_curve_name(self):
        """Get total_cooling_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `total_cooling_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Total Cooling Capacity Function of Temperature Curve Name"]

    @total_cooling_capacity_function_of_temperature_curve_name.setter
    def total_cooling_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Total Cooling Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Total Cooling Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Total Cooling Capacity Function of Temperature Curve Name"] = value

    @property
    def total_cooling_capacity_function_of_flow_fraction_curve_name(self):
        """Get total_cooling_capacity_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `total_cooling_capacity_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Total Cooling Capacity Function of Flow Fraction Curve Name"]

    @total_cooling_capacity_function_of_flow_fraction_curve_name.setter
    def total_cooling_capacity_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Total Cooling Capacity Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Total Cooling Capacity Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Total Cooling Capacity Function of Flow Fraction Curve Name"] = value

    @property
    def energy_input_ratio_function_of_temperature_curve_name(self):
        """Get energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self["Energy Input Ratio Function of Temperature Curve Name"]

    @energy_input_ratio_function_of_temperature_curve_name.setter
    def energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*edb + e*edb**2 + f*wb*edb
        wb = entering wet-bulb temperature (C)
        edb = dry-bulb temperature seen by the condenser (C)

        Args:
            value (str): value for IDD Field `Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def energy_input_ratio_function_of_flow_fraction_curve_name(self):
        """Get energy_input_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `energy_input_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self["Energy Input Ratio Function of Flow Fraction Curve Name"]

    @energy_input_ratio_function_of_flow_fraction_curve_name.setter
    def energy_input_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Energy Input Ratio Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Energy Input Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Energy Input Ratio Function of Flow Fraction Curve Name"] = value

    @property
    def part_load_fraction_correlation_curve_name(self):
        """Get part_load_fraction_correlation_curve_name.

        Returns:
            str: the value of `part_load_fraction_correlation_curve_name` or None if not set

        """
        return self["Part Load Fraction Correlation Curve Name"]

    @part_load_fraction_correlation_curve_name.setter
    def part_load_fraction_correlation_curve_name(self, value=None):
        """  Corresponds to IDD field `Part Load Fraction Correlation Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*PLR + c*PLR**2
        cubic curve = a + b*PLR + c*PLR**2 + d*PLR**3
        PLR = part load ratio (cooling load/steady state capacity)

        Args:
            value (str): value for IDD Field `Part Load Fraction Correlation Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Part Load Fraction Correlation Curve Name"] = value

    @property
    def nominal_time_for_condensate_removal_to_begin(self):
        """Get nominal_time_for_condensate_removal_to_begin.

        Returns:
            float: the value of `nominal_time_for_condensate_removal_to_begin` or None if not set

        """
        return self["Nominal Time for Condensate Removal to Begin"]

    @nominal_time_for_condensate_removal_to_begin.setter
    def nominal_time_for_condensate_removal_to_begin(self, value=None):
        """Corresponds to IDD field `Nominal Time for Condensate Removal to
        Begin` The nominal time for condensate to begin leaving the coil's
        condensate drain line at the coil's rated air flow rate and temperature
        conditions. Nominal time is equal to the ratio of the energy of the
        coil's maximum condensate holding capacity (J) to the coil's steady
        state latent capacity (W). Suggested value is 1000; zero value means
        latent degradation model is disabled.

        Args:
            value (float): value for IDD Field `Nominal Time for Condensate Removal to Begin`
                Units: s
                value <= 3000.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Nominal Time for Condensate Removal to Begin"] = value

    @property
    def ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity(
            self):
        """Get ratio_of_initial_moisture_evaporation_rate_and_steady_state_late
        nt_capacity.

        Returns:
            float: the value of `ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity` or None if not set

        """
        return self[
            "Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity"]

    @ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity.setter
    def ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity(
            self,
            value=None):
        """  Corresponds to IDD field `Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity`
        Ratio of the initial moisture evaporation rate from the cooling coil (when
        the compressor first turns off) and the coil's steady state latent capacity
        at rated air flow rate and temperature conditions. Suggested value is 1.5; zero value
        means latent degradation model is disabled.

        Args:
            value (float): value for IDD Field `Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity`
                Units: dimensionless
                value <= 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Ratio of Initial Moisture Evaporation Rate and Steady State Latent Capacity"] = value

    @property
    def maximum_cycling_rate(self):
        """Get maximum_cycling_rate.

        Returns:
            float: the value of `maximum_cycling_rate` or None if not set

        """
        return self["Maximum Cycling Rate"]

    @maximum_cycling_rate.setter
    def maximum_cycling_rate(self, value=None):
        """  Corresponds to IDD field `Maximum Cycling Rate`
        The maximum on-off cycling rate for the compressor, which occurs at 50% run time
        fraction. Suggested value is 3; zero value means latent degradation model is disabled.

        Args:
            value (float): value for IDD Field `Maximum Cycling Rate`
                Units: cycles/hr
                value <= 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Maximum Cycling Rate"] = value

    @property
    def latent_capacity_time_constant(self):
        """Get latent_capacity_time_constant.

        Returns:
            float: the value of `latent_capacity_time_constant` or None if not set

        """
        return self["Latent Capacity Time Constant"]

    @latent_capacity_time_constant.setter
    def latent_capacity_time_constant(self, value=None):
        """Corresponds to IDD field `Latent Capacity Time Constant` Time
        constant for the cooling coil's latent capacity to reach steady state
        after startup. Suggested value is 45; zero value means latent
        degradation model is disabled.

        Args:
            value (float): value for IDD Field `Latent Capacity Time Constant`
                Units: s
                value <= 500.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Latent Capacity Time Constant"] = value

    @property
    def condenser_air_inlet_node_name(self):
        """Get condenser_air_inlet_node_name.

        Returns:
            str: the value of `condenser_air_inlet_node_name` or None if not set

        """
        return self["Condenser Air Inlet Node Name"]

    @condenser_air_inlet_node_name.setter
    def condenser_air_inlet_node_name(self, value=None):
        """  Corresponds to IDD field `Condenser Air Inlet Node Name`
        Enter the name of an outdoor air node. This node name is also specified in
        an OutdoorAir:Node or OutdoorAir:NodeList object.

        Args:
            value (str): value for IDD Field `Condenser Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Condenser Air Inlet Node Name"] = value

    @property
    def condenser_type(self):
        """Get condenser_type.

        Returns:
            str: the value of `condenser_type` or None if not set

        """
        return self["Condenser Type"]

    @condenser_type.setter
    def condenser_type(self, value="AirCooled"):
        """Corresponds to IDD field `Condenser Type`

        Args:
            value (str): value for IDD Field `Condenser Type`
                Default value: AirCooled
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Condenser Type"] = value

    @property
    def evaporative_condenser_effectiveness(self):
        """Get evaporative_condenser_effectiveness.

        Returns:
            float: the value of `evaporative_condenser_effectiveness` or None if not set

        """
        return self["Evaporative Condenser Effectiveness"]

    @evaporative_condenser_effectiveness.setter
    def evaporative_condenser_effectiveness(self, value=0.9):
        """Corresponds to IDD field `Evaporative Condenser Effectiveness`

        Args:
            value (float): value for IDD Field `Evaporative Condenser Effectiveness`
                Units: dimensionless
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Evaporative Condenser Effectiveness"] = value

    @property
    def evaporative_condenser_air_flow_rate(self):
        """Get evaporative_condenser_air_flow_rate.

        Returns:
            float: the value of `evaporative_condenser_air_flow_rate` or None if not set

        """
        return self["Evaporative Condenser Air Flow Rate"]

    @evaporative_condenser_air_flow_rate.setter
    def evaporative_condenser_air_flow_rate(self, value=None):
        """Corresponds to IDD field `Evaporative Condenser Air Flow Rate` Used
        to calculate evaporative condenser water use.

        Args:
            value (float or "Autosize"): value for IDD Field `Evaporative Condenser Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Evaporative Condenser Air Flow Rate"] = value

    @property
    def evaporative_condenser_pump_rated_power_consumption(self):
        """Get evaporative_condenser_pump_rated_power_consumption.

        Returns:
            float: the value of `evaporative_condenser_pump_rated_power_consumption` or None if not set

        """
        return self["Evaporative Condenser Pump Rated Power Consumption"]

    @evaporative_condenser_pump_rated_power_consumption.setter
    def evaporative_condenser_pump_rated_power_consumption(self, value=None):
        """Corresponds to IDD field `Evaporative Condenser Pump Rated Power
        Consumption` Rated power consumed by the evaporative condenser's water
        pump.

        Args:
            value (float or "Autosize"): value for IDD Field `Evaporative Condenser Pump Rated Power Consumption`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Evaporative Condenser Pump Rated Power Consumption"] = value

    @property
    def sensible_heat_ratio_function_of_temperature_curve_name(self):
        """Get sensible_heat_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `sensible_heat_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self["Sensible Heat Ratio Function of Temperature Curve Name"]

    @sensible_heat_ratio_function_of_temperature_curve_name.setter
    def sensible_heat_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Sensible Heat Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*wb + c*wb**2 + d*db + e*db**2 + f*wb*db
        wb = entering wet-bulb temperature seen by the DX cooling coil (C)
        db = entering dry-bulb temperature seen by the DX cooling coil (C)
        entering temperature can be outside air or pretreated air.

        Args:
            value (str): value for IDD Field `Sensible Heat Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Sensible Heat Ratio Function of Temperature Curve Name"] = value

    @property
    def sensible_heat_ratio_function_of_flow_fraction_curve_name(self):
        """Get sensible_heat_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `sensible_heat_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self["Sensible Heat Ratio Function of Flow Fraction Curve Name"]

    @sensible_heat_ratio_function_of_flow_fraction_curve_name.setter
    def sensible_heat_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Sensible Heat Ratio Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Sensible Heat Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Sensible Heat Ratio Function of Flow Fraction Curve Name"] = value




class CoilCoolingDxVariableRefrigerantFlow(DataObject):

    """ Corresponds to IDD object `Coil:Cooling:DX:VariableRefrigerantFlow`
        Variable refrigerant flow (VRF) direct expansion (DX) cooling coil. Used with
        ZoneHVAC:TerminalUnit:VariableRefrigerantFlow. Condensing unit is modeled separately,
        see AirConditioner:VariableRefrigerantFlow.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'gross rated total cooling capacity',
                                      {'name': u'Gross Rated Total Cooling Capacity',
                                       'pyname': u'gross_rated_total_cooling_capacity',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'gross rated sensible heat ratio',
                                      {'name': u'Gross Rated Sensible Heat Ratio',
                                       'pyname': u'gross_rated_sensible_heat_ratio',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'rated air flow rate',
                                      {'name': u'Rated Air Flow Rate',
                                       'pyname': u'rated_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'cooling capacity ratio modifier function of temperature curve name',
                                      {'name': u'Cooling Capacity Ratio Modifier Function of Temperature Curve Name',
                                       'pyname': u'cooling_capacity_ratio_modifier_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'cooling capacity modifier curve function of flow fraction name',
                                      {'name': u'Cooling Capacity Modifier Curve Function of Flow Fraction Name',
                                       'pyname': u'cooling_capacity_modifier_curve_function_of_flow_fraction_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'coil air inlet node',
                                      {'name': u'Coil Air Inlet Node',
                                       'pyname': u'coil_air_inlet_node',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'coil air outlet node',
                                      {'name': u'Coil Air Outlet Node',
                                       'pyname': u'coil_air_outlet_node',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'name of water storage tank for condensate collection',
                                      {'name': u'Name of Water Storage Tank for Condensate Collection',
                                       'pyname': u'name_of_water_storage_tank_for_condensate_collection',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 9,
              'name': u'Coil:Cooling:DX:VariableRefrigerantFlow',
              'pyname': u'CoilCoolingDxVariableRefrigerantFlow',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def gross_rated_total_cooling_capacity(self):
        """Get gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `gross_rated_total_cooling_capacity` or None if not set

        """
        return self["Gross Rated Total Cooling Capacity"]

    @gross_rated_total_cooling_capacity.setter
    def gross_rated_total_cooling_capacity(self, value=None):
        """Corresponds to IDD field `Gross Rated Total Cooling Capacity` Total
        cooling capacity not accounting for the effect of supply air fan heat
        Cooling capacity excluding supply air fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Gross Rated Total Cooling Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gross Rated Total Cooling Capacity"] = value

    @property
    def gross_rated_sensible_heat_ratio(self):
        """Get gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Gross Rated Sensible Heat Ratio"]

    @gross_rated_sensible_heat_ratio.setter
    def gross_rated_sensible_heat_ratio(self, value=None):
        """Corresponds to IDD field `Gross Rated Sensible Heat Ratio` Sensible
        heat ratio excluding supply air fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Gross Rated Sensible Heat Ratio`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gross Rated Sensible Heat Ratio"] = value

    @property
    def rated_air_flow_rate(self):
        """Get rated_air_flow_rate.

        Returns:
            float: the value of `rated_air_flow_rate` or None if not set

        """
        return self["Rated Air Flow Rate"]

    @rated_air_flow_rate.setter
    def rated_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Rated Air Flow Rate`
        Volume flow rate corresponding to rated total cooling capacity
        should be between 0.00004027 m3/s and .00006041 m3/s per watt of rated total cooling capacity

        Args:
            value (float or "Autosize"): value for IDD Field `Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Rated Air Flow Rate"] = value

    @property
    def cooling_capacity_ratio_modifier_function_of_temperature_curve_name(
            self):
        """Get
        cooling_capacity_ratio_modifier_function_of_temperature_curve_name.

        Returns:
            str: the value of `cooling_capacity_ratio_modifier_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Cooling Capacity Ratio Modifier Function of Temperature Curve Name"]

    @cooling_capacity_ratio_modifier_function_of_temperature_curve_name.setter
    def cooling_capacity_ratio_modifier_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Cooling Capacity Ratio Modifier Function of Temperature Curve Name`
        Table:OneIndependentVariable object can also be used
        Table:TwoIndependentVariables object can also be used

        Args:
            value (str): value for IDD Field `Cooling Capacity Ratio Modifier Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Cooling Capacity Ratio Modifier Function of Temperature Curve Name"] = value

    @property
    def cooling_capacity_modifier_curve_function_of_flow_fraction_name(self):
        """Get cooling_capacity_modifier_curve_function_of_flow_fraction_name.

        Returns:
            str: the value of `cooling_capacity_modifier_curve_function_of_flow_fraction_name` or None if not set

        """
        return self[
            "Cooling Capacity Modifier Curve Function of Flow Fraction Name"]

    @cooling_capacity_modifier_curve_function_of_flow_fraction_name.setter
    def cooling_capacity_modifier_curve_function_of_flow_fraction_name(
            self,
            value=None):
        """  Corresponds to IDD field `Cooling Capacity Modifier Curve Function of Flow Fraction Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Cooling Capacity Modifier Curve Function of Flow Fraction Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Cooling Capacity Modifier Curve Function of Flow Fraction Name"] = value

    @property
    def coil_air_inlet_node(self):
        """Get coil_air_inlet_node.

        Returns:
            str: the value of `coil_air_inlet_node` or None if not set

        """
        return self["Coil Air Inlet Node"]

    @coil_air_inlet_node.setter
    def coil_air_inlet_node(self, value=None):
        """Corresponds to IDD field `Coil Air Inlet Node`

        Args:
            value (str): value for IDD Field `Coil Air Inlet Node`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Coil Air Inlet Node"] = value

    @property
    def coil_air_outlet_node(self):
        """Get coil_air_outlet_node.

        Returns:
            str: the value of `coil_air_outlet_node` or None if not set

        """
        return self["Coil Air Outlet Node"]

    @coil_air_outlet_node.setter
    def coil_air_outlet_node(self, value=None):
        """Corresponds to IDD field `Coil Air Outlet Node`

        Args:
            value (str): value for IDD Field `Coil Air Outlet Node`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Coil Air Outlet Node"] = value

    @property
    def name_of_water_storage_tank_for_condensate_collection(self):
        """Get name_of_water_storage_tank_for_condensate_collection.

        Returns:
            str: the value of `name_of_water_storage_tank_for_condensate_collection` or None if not set

        """
        return self["Name of Water Storage Tank for Condensate Collection"]

    @name_of_water_storage_tank_for_condensate_collection.setter
    def name_of_water_storage_tank_for_condensate_collection(self, value=None):
        """Corresponds to IDD field `Name of Water Storage Tank for Condensate
        Collection`

        Args:
            value (str): value for IDD Field `Name of Water Storage Tank for Condensate Collection`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name of Water Storage Tank for Condensate Collection"] = value




class CoilHeatingDxVariableRefrigerantFlow(DataObject):

    """ Corresponds to IDD object `Coil:Heating:DX:VariableRefrigerantFlow`
        Variable refrigerant flow (VRF) direct expansion (DX) heating coil (air-to-air heat
        pump). Used with ZoneHVAC:TerminalUnit:VariableRefrigerantFlow. Condensing unit is
        modeled separately, see AirConditioner:VariableRefrigerantFlow.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'availability schedule',
                                      {'name': u'Availability Schedule',
                                       'pyname': u'availability_schedule',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'gross rated heating capacity',
                                      {'name': u'Gross Rated Heating Capacity',
                                       'pyname': u'gross_rated_heating_capacity',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'rated air flow rate',
                                      {'name': u'Rated Air Flow Rate',
                                       'pyname': u'rated_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'coil air inlet node',
                                      {'name': u'Coil Air Inlet Node',
                                       'pyname': u'coil_air_inlet_node',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'coil air outlet node',
                                      {'name': u'Coil Air Outlet Node',
                                       'pyname': u'coil_air_outlet_node',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'heating capacity ratio modifier function of temperature curve name',
                                      {'name': u'Heating Capacity Ratio Modifier Function of Temperature Curve Name',
                                       'pyname': u'heating_capacity_ratio_modifier_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'heating capacity modifier function of flow fraction curve name',
                                      {'name': u'Heating Capacity Modifier Function of Flow Fraction Curve Name',
                                       'pyname': u'heating_capacity_modifier_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 5,
              'name': u'Coil:Heating:DX:VariableRefrigerantFlow',
              'pyname': u'CoilHeatingDxVariableRefrigerantFlow',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule(self):
        """Get availability_schedule.

        Returns:
            str: the value of `availability_schedule` or None if not set

        """
        return self["Availability Schedule"]

    @availability_schedule.setter
    def availability_schedule(self, value=None):
        """Corresponds to IDD field `Availability Schedule` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule"] = value

    @property
    def gross_rated_heating_capacity(self):
        """Get gross_rated_heating_capacity.

        Returns:
            float: the value of `gross_rated_heating_capacity` or None if not set

        """
        return self["Gross Rated Heating Capacity"]

    @gross_rated_heating_capacity.setter
    def gross_rated_heating_capacity(self, value=None):
        """  Corresponds to IDD field `Gross Rated Heating Capacity`
        Heating capacity not accounting for the effect of supply air fan heat
        capacity excluding supply air fan heat
        rating point outside dry-bulb temp 8.33 C, outside wet-bulb temp 6.11 C
        rating point heating coil entering air dry-bulb 21.11 C, coil entering wetbulb 15.55 C

        Args:
            value (float or "Autosize"): value for IDD Field `Gross Rated Heating Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Gross Rated Heating Capacity"] = value

    @property
    def rated_air_flow_rate(self):
        """Get rated_air_flow_rate.

        Returns:
            float: the value of `rated_air_flow_rate` or None if not set

        """
        return self["Rated Air Flow Rate"]

    @rated_air_flow_rate.setter
    def rated_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Rated Air Flow Rate`
        volume flow rate corresponding to rated total capacity
        should be between 0.00004027 m3/s and .00006041 m3/s per watt of rated heating capacity

        Args:
            value (float or "Autosize"): value for IDD Field `Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Rated Air Flow Rate"] = value

    @property
    def coil_air_inlet_node(self):
        """Get coil_air_inlet_node.

        Returns:
            str: the value of `coil_air_inlet_node` or None if not set

        """
        return self["Coil Air Inlet Node"]

    @coil_air_inlet_node.setter
    def coil_air_inlet_node(self, value=None):
        """Corresponds to IDD field `Coil Air Inlet Node`

        Args:
            value (str): value for IDD Field `Coil Air Inlet Node`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Coil Air Inlet Node"] = value

    @property
    def coil_air_outlet_node(self):
        """Get coil_air_outlet_node.

        Returns:
            str: the value of `coil_air_outlet_node` or None if not set

        """
        return self["Coil Air Outlet Node"]

    @coil_air_outlet_node.setter
    def coil_air_outlet_node(self, value=None):
        """Corresponds to IDD field `Coil Air Outlet Node`

        Args:
            value (str): value for IDD Field `Coil Air Outlet Node`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Coil Air Outlet Node"] = value

    @property
    def heating_capacity_ratio_modifier_function_of_temperature_curve_name(
            self):
        """Get
        heating_capacity_ratio_modifier_function_of_temperature_curve_name.

        Returns:
            str: the value of `heating_capacity_ratio_modifier_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Heating Capacity Ratio Modifier Function of Temperature Curve Name"]

    @heating_capacity_ratio_modifier_function_of_temperature_curve_name.setter
    def heating_capacity_ratio_modifier_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Heating Capacity Ratio Modifier Function of Temperature Curve Name`
        Table:OneIndependentVariable object can also be used
        Table:TwoIndependentVariables object can also be used

        Args:
            value (str): value for IDD Field `Heating Capacity Ratio Modifier Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Heating Capacity Ratio Modifier Function of Temperature Curve Name"] = value

    @property
    def heating_capacity_modifier_function_of_flow_fraction_curve_name(self):
        """Get heating_capacity_modifier_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `heating_capacity_modifier_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Heating Capacity Modifier Function of Flow Fraction Curve Name"]

    @heating_capacity_modifier_function_of_flow_fraction_curve_name.setter
    def heating_capacity_modifier_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Heating Capacity Modifier Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Heating Capacity Modifier Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Heating Capacity Modifier Function of Flow Fraction Curve Name"] = value




class CoilHeatingWater(DataObject):

    """ Corresponds to IDD object `Coil:Heating:Water`
        Hot water heating coil, NTU-effectiveness model, assumes a cross-flow heat exchanger.
        Two options for capacity inputs: UA and water flow rate or capacity and design
        temperatures.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'u-factor times area value',
                                      {'name': u'U-Factor Times Area Value',
                                       'pyname': u'ufactor_times_area_value',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W/K'}),
                                     (u'maximum water flow rate',
                                      {'name': u'Maximum Water Flow Rate',
                                       'pyname': u'maximum_water_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'water inlet node name',
                                      {'name': u'Water Inlet Node Name',
                                       'pyname': u'water_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'water outlet node name',
                                      {'name': u'Water Outlet Node Name',
                                       'pyname': u'water_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air inlet node name',
                                      {'name': u'Air Inlet Node Name',
                                       'pyname': u'air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air outlet node name',
                                      {'name': u'Air Outlet Node Name',
                                       'pyname': u'air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'performance input method',
                                      {'name': u'Performance Input Method',
                                       'pyname': u'performance_input_method',
                                       'default': u'UFactorTimesAreaAndDesignWaterFlowRate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'UFactorTimesAreaAndDesignWaterFlowRate',
                                                           u'NominalCapacity'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'rated capacity',
                                      {'name': u'Rated Capacity',
                                       'pyname': u'rated_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'rated inlet water temperature',
                                      {'name': u'Rated Inlet Water Temperature',
                                       'pyname': u'rated_inlet_water_temperature',
                                       'default': 82.2,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'rated inlet air temperature',
                                      {'name': u'Rated Inlet Air Temperature',
                                       'pyname': u'rated_inlet_air_temperature',
                                       'default': 16.6,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'rated outlet water temperature',
                                      {'name': u'Rated Outlet Water Temperature',
                                       'pyname': u'rated_outlet_water_temperature',
                                       'default': 71.1,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'rated outlet air temperature',
                                      {'name': u'Rated Outlet Air Temperature',
                                       'pyname': u'rated_outlet_air_temperature',
                                       'default': 32.2,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'rated ratio for air and water convection',
                                      {'name': u'Rated Ratio for Air and Water Convection',
                                       'pyname': u'rated_ratio_for_air_and_water_convection',
                                       'default': 0.5,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 15,
              'name': u'Coil:Heating:Water',
              'pyname': u'CoilHeatingWater',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def ufactor_times_area_value(self):
        """Get ufactor_times_area_value.

        Returns:
            float: the value of `ufactor_times_area_value` or None if not set

        """
        return self["U-Factor Times Area Value"]

    @ufactor_times_area_value.setter
    def ufactor_times_area_value(self, value="autosize"):
        """  Corresponds to IDD field `U-Factor Times Area Value`
        UA value under rating conditions

        Args:
            value (float or "Autosize"): value for IDD Field `U-Factor Times Area Value`
                Units: W/K
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["U-Factor Times Area Value"] = value

    @property
    def maximum_water_flow_rate(self):
        """Get maximum_water_flow_rate.

        Returns:
            float: the value of `maximum_water_flow_rate` or None if not set

        """
        return self["Maximum Water Flow Rate"]

    @maximum_water_flow_rate.setter
    def maximum_water_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Maximum Water Flow Rate`

        Args:
            value (float or "Autosize"): value for IDD Field `Maximum Water Flow Rate`
                Units: m3/s
                IP-Units: gal/min
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Maximum Water Flow Rate"] = value

    @property
    def water_inlet_node_name(self):
        """Get water_inlet_node_name.

        Returns:
            str: the value of `water_inlet_node_name` or None if not set

        """
        return self["Water Inlet Node Name"]

    @water_inlet_node_name.setter
    def water_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Water Inlet Node Name`

        Args:
            value (str): value for IDD Field `Water Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Water Inlet Node Name"] = value

    @property
    def water_outlet_node_name(self):
        """Get water_outlet_node_name.

        Returns:
            str: the value of `water_outlet_node_name` or None if not set

        """
        return self["Water Outlet Node Name"]

    @water_outlet_node_name.setter
    def water_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Water Outlet Node Name`

        Args:
            value (str): value for IDD Field `Water Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Water Outlet Node Name"] = value

    @property
    def air_inlet_node_name(self):
        """Get air_inlet_node_name.

        Returns:
            str: the value of `air_inlet_node_name` or None if not set

        """
        return self["Air Inlet Node Name"]

    @air_inlet_node_name.setter
    def air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Inlet Node Name"] = value

    @property
    def air_outlet_node_name(self):
        """Get air_outlet_node_name.

        Returns:
            str: the value of `air_outlet_node_name` or None if not set

        """
        return self["Air Outlet Node Name"]

    @air_outlet_node_name.setter
    def air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Outlet Node Name"] = value

    @property
    def performance_input_method(self):
        """Get performance_input_method.

        Returns:
            str: the value of `performance_input_method` or None if not set

        """
        return self["Performance Input Method"]

    @performance_input_method.setter
    def performance_input_method(
            self,
            value="UFactorTimesAreaAndDesignWaterFlowRate"):
        """Corresponds to IDD field `Performance Input Method`

        Args:
            value (str): value for IDD Field `Performance Input Method`
                Default value: UFactorTimesAreaAndDesignWaterFlowRate
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Performance Input Method"] = value

    @property
    def rated_capacity(self):
        """Get rated_capacity.

        Returns:
            float: the value of `rated_capacity` or None if not set

        """
        return self["Rated Capacity"]

    @rated_capacity.setter
    def rated_capacity(self, value="autosize"):
        """Corresponds to IDD field `Rated Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Rated Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Rated Capacity"] = value

    @property
    def rated_inlet_water_temperature(self):
        """Get rated_inlet_water_temperature.

        Returns:
            float: the value of `rated_inlet_water_temperature` or None if not set

        """
        return self["Rated Inlet Water Temperature"]

    @rated_inlet_water_temperature.setter
    def rated_inlet_water_temperature(self, value=82.2):
        """Corresponds to IDD field `Rated Inlet Water Temperature`

        Args:
            value (float): value for IDD Field `Rated Inlet Water Temperature`
                Units: C
                Default value: 82.2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Rated Inlet Water Temperature"] = value

    @property
    def rated_inlet_air_temperature(self):
        """Get rated_inlet_air_temperature.

        Returns:
            float: the value of `rated_inlet_air_temperature` or None if not set

        """
        return self["Rated Inlet Air Temperature"]

    @rated_inlet_air_temperature.setter
    def rated_inlet_air_temperature(self, value=16.6):
        """Corresponds to IDD field `Rated Inlet Air Temperature`

        Args:
            value (float): value for IDD Field `Rated Inlet Air Temperature`
                Units: C
                Default value: 16.6
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Rated Inlet Air Temperature"] = value

    @property
    def rated_outlet_water_temperature(self):
        """Get rated_outlet_water_temperature.

        Returns:
            float: the value of `rated_outlet_water_temperature` or None if not set

        """
        return self["Rated Outlet Water Temperature"]

    @rated_outlet_water_temperature.setter
    def rated_outlet_water_temperature(self, value=71.1):
        """Corresponds to IDD field `Rated Outlet Water Temperature`

        Args:
            value (float): value for IDD Field `Rated Outlet Water Temperature`
                Units: C
                Default value: 71.1
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Rated Outlet Water Temperature"] = value

    @property
    def rated_outlet_air_temperature(self):
        """Get rated_outlet_air_temperature.

        Returns:
            float: the value of `rated_outlet_air_temperature` or None if not set

        """
        return self["Rated Outlet Air Temperature"]

    @rated_outlet_air_temperature.setter
    def rated_outlet_air_temperature(self, value=32.2):
        """Corresponds to IDD field `Rated Outlet Air Temperature`

        Args:
            value (float): value for IDD Field `Rated Outlet Air Temperature`
                Units: C
                Default value: 32.2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Rated Outlet Air Temperature"] = value

    @property
    def rated_ratio_for_air_and_water_convection(self):
        """Get rated_ratio_for_air_and_water_convection.

        Returns:
            float: the value of `rated_ratio_for_air_and_water_convection` or None if not set

        """
        return self["Rated Ratio for Air and Water Convection"]

    @rated_ratio_for_air_and_water_convection.setter
    def rated_ratio_for_air_and_water_convection(self, value=0.5):
        """Corresponds to IDD field `Rated Ratio for Air and Water Convection`

        Args:
            value (float): value for IDD Field `Rated Ratio for Air and Water Convection`
                Default value: 0.5
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Rated Ratio for Air and Water Convection"] = value




class CoilHeatingSteam(DataObject):

    """ Corresponds to IDD object `Coil:Heating:Steam`
        Steam heating coil. Condenses and sub-cools steam at loop pressure and discharges
        condensate through steam traps to low pressure condensate line.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'maximum steam flow rate',
                                      {'name': u'Maximum Steam Flow Rate',
                                       'pyname': u'maximum_steam_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'degree of subcooling',
                                      {'name': u'Degree of SubCooling',
                                       'pyname': u'degree_of_subcooling',
                                       'maximum': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 1.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'degree of loop subcooling',
                                      {'name': u'Degree of Loop SubCooling',
                                       'pyname': u'degree_of_loop_subcooling',
                                       'default': 20.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 10.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'water inlet node name',
                                      {'name': u'Water Inlet Node Name',
                                       'pyname': u'water_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'water outlet node name',
                                      {'name': u'Water Outlet Node Name',
                                       'pyname': u'water_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air inlet node name',
                                      {'name': u'Air Inlet Node Name',
                                       'pyname': u'air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air outlet node name',
                                      {'name': u'Air Outlet Node Name',
                                       'pyname': u'air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'coil control type',
                                      {'name': u'Coil Control Type',
                                       'pyname': u'coil_control_type',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'TemperatureSetpointControl',
                                                           u'ZoneLoadControl'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'temperature setpoint node name',
                                      {'name': u'Temperature Setpoint Node Name',
                                       'pyname': u'temperature_setpoint_node_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 0,
              'name': u'Coil:Heating:Steam',
              'pyname': u'CoilHeatingSteam',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def maximum_steam_flow_rate(self):
        """Get maximum_steam_flow_rate.

        Returns:
            float: the value of `maximum_steam_flow_rate` or None if not set

        """
        return self["Maximum Steam Flow Rate"]

    @maximum_steam_flow_rate.setter
    def maximum_steam_flow_rate(self, value=None):
        """Corresponds to IDD field `Maximum Steam Flow Rate`

        Args:
            value (float or "Autosize"): value for IDD Field `Maximum Steam Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Maximum Steam Flow Rate"] = value

    @property
    def degree_of_subcooling(self):
        """Get degree_of_subcooling.

        Returns:
            float: the value of `degree_of_subcooling` or None if not set

        """
        return self["Degree of SubCooling"]

    @degree_of_subcooling.setter
    def degree_of_subcooling(self, value=None):
        """Corresponds to IDD field `Degree of SubCooling`

        Args:
            value (float): value for IDD Field `Degree of SubCooling`
                Units: C
                value >= 1.0
                value <= 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Degree of SubCooling"] = value

    @property
    def degree_of_loop_subcooling(self):
        """Get degree_of_loop_subcooling.

        Returns:
            float: the value of `degree_of_loop_subcooling` or None if not set

        """
        return self["Degree of Loop SubCooling"]

    @degree_of_loop_subcooling.setter
    def degree_of_loop_subcooling(self, value=20.0):
        """Corresponds to IDD field `Degree of Loop SubCooling`

        Args:
            value (float): value for IDD Field `Degree of Loop SubCooling`
                Units: C
                Default value: 20.0
                value >= 10.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Degree of Loop SubCooling"] = value

    @property
    def water_inlet_node_name(self):
        """Get water_inlet_node_name.

        Returns:
            str: the value of `water_inlet_node_name` or None if not set

        """
        return self["Water Inlet Node Name"]

    @water_inlet_node_name.setter
    def water_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Water Inlet Node Name`

        Args:
            value (str): value for IDD Field `Water Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Water Inlet Node Name"] = value

    @property
    def water_outlet_node_name(self):
        """Get water_outlet_node_name.

        Returns:
            str: the value of `water_outlet_node_name` or None if not set

        """
        return self["Water Outlet Node Name"]

    @water_outlet_node_name.setter
    def water_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Water Outlet Node Name`

        Args:
            value (str): value for IDD Field `Water Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Water Outlet Node Name"] = value

    @property
    def air_inlet_node_name(self):
        """Get air_inlet_node_name.

        Returns:
            str: the value of `air_inlet_node_name` or None if not set

        """
        return self["Air Inlet Node Name"]

    @air_inlet_node_name.setter
    def air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Inlet Node Name"] = value

    @property
    def air_outlet_node_name(self):
        """Get air_outlet_node_name.

        Returns:
            str: the value of `air_outlet_node_name` or None if not set

        """
        return self["Air Outlet Node Name"]

    @air_outlet_node_name.setter
    def air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Outlet Node Name"] = value

    @property
    def coil_control_type(self):
        """Get coil_control_type.

        Returns:
            str: the value of `coil_control_type` or None if not set

        """
        return self["Coil Control Type"]

    @coil_control_type.setter
    def coil_control_type(self, value=None):
        """Corresponds to IDD field `Coil Control Type` Use ZoneLoadControl if
        the coil is contained within another component such as an air terminal
        unit, zone HVAC equipment, or unitary system. Use
        TemperatureSetpointControl if the coil is located directly in an air
        loop branch or outdoor air equipment list.

        Args:
            value (str): value for IDD Field `Coil Control Type`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Coil Control Type"] = value

    @property
    def temperature_setpoint_node_name(self):
        """Get temperature_setpoint_node_name.

        Returns:
            str: the value of `temperature_setpoint_node_name` or None if not set

        """
        return self["Temperature Setpoint Node Name"]

    @temperature_setpoint_node_name.setter
    def temperature_setpoint_node_name(self, value=None):
        """Corresponds to IDD field `Temperature Setpoint Node Name` Required
        if Coil Control Type is TemperatureSetpointControl.

        Args:
            value (str): value for IDD Field `Temperature Setpoint Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Temperature Setpoint Node Name"] = value




class CoilHeatingElectric(DataObject):

    """ Corresponds to IDD object `Coil:Heating:Electric`
        Electric heating coil. If the coil is located directly in an air loop branch or
        outdoor air equipment list, then it is controlled on leaving air temperature and
        the Temperature Setpoint Node Name must be specified. If the coil is contained within
        another component such as an air terminal unit, zone HVAC equipment, or unitary
        system, then the coil is controlled by the parent component and the setpoint node name
        is not entered.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'efficiency',
                                      {'name': u'Efficiency',
                                       'pyname': u'efficiency',
                                       'default': 1.0,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'nominal capacity',
                                      {'name': u'Nominal Capacity',
                                       'pyname': u'nominal_capacity',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'air inlet node name',
                                      {'name': u'Air Inlet Node Name',
                                       'pyname': u'air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air outlet node name',
                                      {'name': u'Air Outlet Node Name',
                                       'pyname': u'air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'temperature setpoint node name',
                                      {'name': u'Temperature Setpoint Node Name',
                                       'pyname': u'temperature_setpoint_node_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 0,
              'name': u'Coil:Heating:Electric',
              'pyname': u'CoilHeatingElectric',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def efficiency(self):
        """Get efficiency.

        Returns:
            float: the value of `efficiency` or None if not set

        """
        return self["Efficiency"]

    @efficiency.setter
    def efficiency(self, value=1.0):
        """Corresponds to IDD field `Efficiency`

        Args:
            value (float): value for IDD Field `Efficiency`
                Default value: 1.0
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Efficiency"] = value

    @property
    def nominal_capacity(self):
        """Get nominal_capacity.

        Returns:
            float: the value of `nominal_capacity` or None if not set

        """
        return self["Nominal Capacity"]

    @nominal_capacity.setter
    def nominal_capacity(self, value=None):
        """Corresponds to IDD field `Nominal Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Nominal Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Nominal Capacity"] = value

    @property
    def air_inlet_node_name(self):
        """Get air_inlet_node_name.

        Returns:
            str: the value of `air_inlet_node_name` or None if not set

        """
        return self["Air Inlet Node Name"]

    @air_inlet_node_name.setter
    def air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Inlet Node Name"] = value

    @property
    def air_outlet_node_name(self):
        """Get air_outlet_node_name.

        Returns:
            str: the value of `air_outlet_node_name` or None if not set

        """
        return self["Air Outlet Node Name"]

    @air_outlet_node_name.setter
    def air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Outlet Node Name"] = value

    @property
    def temperature_setpoint_node_name(self):
        """Get temperature_setpoint_node_name.

        Returns:
            str: the value of `temperature_setpoint_node_name` or None if not set

        """
        return self["Temperature Setpoint Node Name"]

    @temperature_setpoint_node_name.setter
    def temperature_setpoint_node_name(self, value=None):
        """Corresponds to IDD field `Temperature Setpoint Node Name` Required
        if coil is temperature controlled.

        Args:
            value (str): value for IDD Field `Temperature Setpoint Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Temperature Setpoint Node Name"] = value




class CoilHeatingElectricMultiStage(DataObject):

    """ Corresponds to IDD object `Coil:Heating:Electric:MultiStage`
        Electric heating coil, multi-stage. If the coil is located directly in an air loop
        branch or outdoor air equipment list, then it is controlled on leaving air temperature
        and the Temperature Setpoint Node Name must be specified. If the coil is contained
        within another component such as an air terminal unit, zone HVAC equipment, or unitary
        system, then the coil is controlled by the parent component and the setpoint node name
        is not entered.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'air inlet node name',
                                      {'name': u'Air Inlet Node Name',
                                       'pyname': u'air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air outlet node name',
                                      {'name': u'Air Outlet Node Name',
                                       'pyname': u'air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'temperature setpoint node name',
                                      {'name': u'Temperature Setpoint Node Name',
                                       'pyname': u'temperature_setpoint_node_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'number of stages',
                                      {'name': u'Number of Stages',
                                       'pyname': u'number_of_stages',
                                       'maximum': 4,
                                       'required-field': True,
                                       'autosizable': False,
                                       'minimum': 1,
                                       'autocalculatable': False,
                                       'type': u'integer'}),
                                     (u'stage 1 efficiency',
                                      {'name': u'Stage 1 Efficiency',
                                       'pyname': u'stage_1_efficiency',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'stage 1 nominal capacity',
                                      {'name': u'Stage 1 Nominal Capacity',
                                       'pyname': u'stage_1_nominal_capacity',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'stage 2 efficiency',
                                      {'name': u'Stage 2 Efficiency',
                                       'pyname': u'stage_2_efficiency',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'stage 2 nominal capacity',
                                      {'name': u'Stage 2 Nominal Capacity',
                                       'pyname': u'stage_2_nominal_capacity',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'stage 3 efficiency',
                                      {'name': u'Stage 3 Efficiency',
                                       'pyname': u'stage_3_efficiency',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'stage 3 nominal capacity',
                                      {'name': u'Stage 3 Nominal Capacity',
                                       'pyname': u'stage_3_nominal_capacity',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'stage 4 efficiency',
                                      {'name': u'Stage 4 Efficiency',
                                       'pyname': u'stage_4_efficiency',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'stage 4 nominal capacity',
                                      {'name': u'Stage 4 Nominal Capacity',
                                       'pyname': u'stage_4_nominal_capacity',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 0,
              'name': u'Coil:Heating:Electric:MultiStage',
              'pyname': u'CoilHeatingElectricMultiStage',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def air_inlet_node_name(self):
        """Get air_inlet_node_name.

        Returns:
            str: the value of `air_inlet_node_name` or None if not set

        """
        return self["Air Inlet Node Name"]

    @air_inlet_node_name.setter
    def air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Inlet Node Name"] = value

    @property
    def air_outlet_node_name(self):
        """Get air_outlet_node_name.

        Returns:
            str: the value of `air_outlet_node_name` or None if not set

        """
        return self["Air Outlet Node Name"]

    @air_outlet_node_name.setter
    def air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Outlet Node Name"] = value

    @property
    def temperature_setpoint_node_name(self):
        """Get temperature_setpoint_node_name.

        Returns:
            str: the value of `temperature_setpoint_node_name` or None if not set

        """
        return self["Temperature Setpoint Node Name"]

    @temperature_setpoint_node_name.setter
    def temperature_setpoint_node_name(self, value=None):
        """Corresponds to IDD field `Temperature Setpoint Node Name` Required
        if coil is temperature controlled. controlled.

        Args:
            value (str): value for IDD Field `Temperature Setpoint Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Temperature Setpoint Node Name"] = value

    @property
    def number_of_stages(self):
        """Get number_of_stages.

        Returns:
            int: the value of `number_of_stages` or None if not set

        """
        return self["Number of Stages"]

    @number_of_stages.setter
    def number_of_stages(self, value=None):
        """Corresponds to IDD field `Number of Stages` Enter the number of the
        following sets of data for coil capacity and Efficiency.

        Args:
            value (int): value for IDD Field `Number of Stages`
                value >= 1
                value <= 4
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Number of Stages"] = value

    @property
    def stage_1_efficiency(self):
        """Get stage_1_efficiency.

        Returns:
            float: the value of `stage_1_efficiency` or None if not set

        """
        return self["Stage 1 Efficiency"]

    @stage_1_efficiency.setter
    def stage_1_efficiency(self, value=None):
        """Corresponds to IDD field `Stage 1 Efficiency`

        Args:
            value (float): value for IDD Field `Stage 1 Efficiency`
                Units: W/W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 1 Efficiency"] = value

    @property
    def stage_1_nominal_capacity(self):
        """Get stage_1_nominal_capacity.

        Returns:
            float: the value of `stage_1_nominal_capacity` or None if not set

        """
        return self["Stage 1 Nominal Capacity"]

    @stage_1_nominal_capacity.setter
    def stage_1_nominal_capacity(self, value=None):
        """Corresponds to IDD field `Stage 1 Nominal Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Stage 1 Nominal Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 1 Nominal Capacity"] = value

    @property
    def stage_2_efficiency(self):
        """Get stage_2_efficiency.

        Returns:
            float: the value of `stage_2_efficiency` or None if not set

        """
        return self["Stage 2 Efficiency"]

    @stage_2_efficiency.setter
    def stage_2_efficiency(self, value=None):
        """Corresponds to IDD field `Stage 2 Efficiency`

        Args:
            value (float): value for IDD Field `Stage 2 Efficiency`
                Units: W/W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 2 Efficiency"] = value

    @property
    def stage_2_nominal_capacity(self):
        """Get stage_2_nominal_capacity.

        Returns:
            float: the value of `stage_2_nominal_capacity` or None if not set

        """
        return self["Stage 2 Nominal Capacity"]

    @stage_2_nominal_capacity.setter
    def stage_2_nominal_capacity(self, value=None):
        """Corresponds to IDD field `Stage 2 Nominal Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Stage 2 Nominal Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 2 Nominal Capacity"] = value

    @property
    def stage_3_efficiency(self):
        """Get stage_3_efficiency.

        Returns:
            float: the value of `stage_3_efficiency` or None if not set

        """
        return self["Stage 3 Efficiency"]

    @stage_3_efficiency.setter
    def stage_3_efficiency(self, value=None):
        """Corresponds to IDD field `Stage 3 Efficiency`

        Args:
            value (float): value for IDD Field `Stage 3 Efficiency`
                Units: W/W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 3 Efficiency"] = value

    @property
    def stage_3_nominal_capacity(self):
        """Get stage_3_nominal_capacity.

        Returns:
            float: the value of `stage_3_nominal_capacity` or None if not set

        """
        return self["Stage 3 Nominal Capacity"]

    @stage_3_nominal_capacity.setter
    def stage_3_nominal_capacity(self, value=None):
        """Corresponds to IDD field `Stage 3 Nominal Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Stage 3 Nominal Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 3 Nominal Capacity"] = value

    @property
    def stage_4_efficiency(self):
        """Get stage_4_efficiency.

        Returns:
            float: the value of `stage_4_efficiency` or None if not set

        """
        return self["Stage 4 Efficiency"]

    @stage_4_efficiency.setter
    def stage_4_efficiency(self, value=None):
        """Corresponds to IDD field `Stage 4 Efficiency`

        Args:
            value (float): value for IDD Field `Stage 4 Efficiency`
                Units: W/W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 4 Efficiency"] = value

    @property
    def stage_4_nominal_capacity(self):
        """Get stage_4_nominal_capacity.

        Returns:
            float: the value of `stage_4_nominal_capacity` or None if not set

        """
        return self["Stage 4 Nominal Capacity"]

    @stage_4_nominal_capacity.setter
    def stage_4_nominal_capacity(self, value=None):
        """Corresponds to IDD field `Stage 4 Nominal Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Stage 4 Nominal Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 4 Nominal Capacity"] = value




class CoilHeatingGas(DataObject):

    """ Corresponds to IDD object `Coil:Heating:Gas`
        Gas heating coil. If the coil is located directly in an air loop branch or
        outdoor air equipment list, then it is controlled on leaving air temperature and
        the Temperature Setpoint Node Name must be specified. If the coil is contained within
        another component such as an air terminal unit, zone HVAC equipment, or unitary
        system, then the coil is controlled by the parent component and the setpoint node name
        is not entered.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'gas burner efficiency',
                                      {'name': u'Gas Burner Efficiency',
                                       'pyname': u'gas_burner_efficiency',
                                       'default': 0.8,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'nominal capacity',
                                      {'name': u'Nominal Capacity',
                                       'pyname': u'nominal_capacity',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'air inlet node name',
                                      {'name': u'Air Inlet Node Name',
                                       'pyname': u'air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air outlet node name',
                                      {'name': u'Air Outlet Node Name',
                                       'pyname': u'air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'temperature setpoint node name',
                                      {'name': u'Temperature Setpoint Node Name',
                                       'pyname': u'temperature_setpoint_node_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'parasitic electric load',
                                      {'name': u'Parasitic Electric Load',
                                       'pyname': u'parasitic_electric_load',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'part load fraction correlation curve name',
                                      {'name': u'Part Load Fraction Correlation Curve Name',
                                       'pyname': u'part_load_fraction_correlation_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'parasitic gas load',
                                      {'name': u'Parasitic Gas Load',
                                       'pyname': u'parasitic_gas_load',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 0,
              'name': u'Coil:Heating:Gas',
              'pyname': u'CoilHeatingGas',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def gas_burner_efficiency(self):
        """Get gas_burner_efficiency.

        Returns:
            float: the value of `gas_burner_efficiency` or None if not set

        """
        return self["Gas Burner Efficiency"]

    @gas_burner_efficiency.setter
    def gas_burner_efficiency(self, value=0.8):
        """Corresponds to IDD field `Gas Burner Efficiency`

        Args:
            value (float): value for IDD Field `Gas Burner Efficiency`
                Default value: 0.8
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gas Burner Efficiency"] = value

    @property
    def nominal_capacity(self):
        """Get nominal_capacity.

        Returns:
            float: the value of `nominal_capacity` or None if not set

        """
        return self["Nominal Capacity"]

    @nominal_capacity.setter
    def nominal_capacity(self, value=None):
        """Corresponds to IDD field `Nominal Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Nominal Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Nominal Capacity"] = value

    @property
    def air_inlet_node_name(self):
        """Get air_inlet_node_name.

        Returns:
            str: the value of `air_inlet_node_name` or None if not set

        """
        return self["Air Inlet Node Name"]

    @air_inlet_node_name.setter
    def air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Inlet Node Name"] = value

    @property
    def air_outlet_node_name(self):
        """Get air_outlet_node_name.

        Returns:
            str: the value of `air_outlet_node_name` or None if not set

        """
        return self["Air Outlet Node Name"]

    @air_outlet_node_name.setter
    def air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Outlet Node Name"] = value

    @property
    def temperature_setpoint_node_name(self):
        """Get temperature_setpoint_node_name.

        Returns:
            str: the value of `temperature_setpoint_node_name` or None if not set

        """
        return self["Temperature Setpoint Node Name"]

    @temperature_setpoint_node_name.setter
    def temperature_setpoint_node_name(self, value=None):
        """  Corresponds to IDD field `Temperature Setpoint Node Name`
        optional, used if coil is temperature control and not load-base controlled

        Args:
            value (str): value for IDD Field `Temperature Setpoint Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Temperature Setpoint Node Name"] = value

    @property
    def parasitic_electric_load(self):
        """Get parasitic_electric_load.

        Returns:
            float: the value of `parasitic_electric_load` or None if not set

        """
        return self["Parasitic Electric Load"]

    @parasitic_electric_load.setter
    def parasitic_electric_load(self, value=None):
        """Corresponds to IDD field `Parasitic Electric Load` parasitic
        electric load associated with the gas coil operation such as an inducer
        fan, etc..  This will be modified by the part load ratio to reflect the
        time of operation in a timestep.

        Args:
            value (float): value for IDD Field `Parasitic Electric Load`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Parasitic Electric Load"] = value

    @property
    def part_load_fraction_correlation_curve_name(self):
        """Get part_load_fraction_correlation_curve_name.

        Returns:
            str: the value of `part_load_fraction_correlation_curve_name` or None if not set

        """
        return self["Part Load Fraction Correlation Curve Name"]

    @part_load_fraction_correlation_curve_name.setter
    def part_load_fraction_correlation_curve_name(self, value=None):
        """  Corresponds to IDD field `Part Load Fraction Correlation Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve, PLF = a + b*PLR + c*PLR**2
        cubic curve, PLF = a + b*PLR + c*PLR**2 + d*PLR**3
        PLF = part load fraction
        PLR = part load ratio (sensible heating load/steady state heating capacity)
        Coil runtime fraction = Part Load Ratio / PLF
        This part load degradation is for coil performance & will
        increase the gas consumption of the coil due to transient coil operation.

        Args:
            value (str): value for IDD Field `Part Load Fraction Correlation Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Part Load Fraction Correlation Curve Name"] = value

    @property
    def parasitic_gas_load(self):
        """Get parasitic_gas_load.

        Returns:
            float: the value of `parasitic_gas_load` or None if not set

        """
        return self["Parasitic Gas Load"]

    @parasitic_gas_load.setter
    def parasitic_gas_load(self, value=None):
        """Corresponds to IDD field `Parasitic Gas Load` parasitic gas load
        associated with the gas coil operation (i.e., standing pilot)

        Args:
            value (float): value for IDD Field `Parasitic Gas Load`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Parasitic Gas Load"] = value




class CoilHeatingGasMultiStage(DataObject):

    """ Corresponds to IDD object `Coil:Heating:Gas:MultiStage`
        Gas heating coil, multi-stage. If the coil is located directly in an air loop
        branch or outdoor air equipment list, then it is controlled on leaving air temperature
        and the Temperature Setpoint Node Name must be specified. If the coil is contained
        within another component such as an air terminal unit, zone HVAC equipment, or unitary
        system, then the coil is controlled by the parent component and the setpoint node name
        is not entered.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'air inlet node name',
                                      {'name': u'Air Inlet Node Name',
                                       'pyname': u'air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air outlet node name',
                                      {'name': u'Air Outlet Node Name',
                                       'pyname': u'air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'temperature setpoint node name',
                                      {'name': u'Temperature Setpoint Node Name',
                                       'pyname': u'temperature_setpoint_node_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'part load fraction correlation curve name',
                                      {'name': u'Part Load Fraction Correlation Curve Name',
                                       'pyname': u'part_load_fraction_correlation_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'parasitic gas load',
                                      {'name': u'Parasitic Gas Load',
                                       'pyname': u'parasitic_gas_load',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'number of stages',
                                      {'name': u'Number of Stages',
                                       'pyname': u'number_of_stages',
                                       'maximum': 4,
                                       'required-field': True,
                                       'autosizable': False,
                                       'minimum': 1,
                                       'autocalculatable': False,
                                       'type': u'integer'}),
                                     (u'stage 1 gas burner efficiency',
                                      {'name': u'Stage 1 Gas Burner Efficiency',
                                       'pyname': u'stage_1_gas_burner_efficiency',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'stage 1 nominal capacity',
                                      {'name': u'Stage 1 Nominal Capacity',
                                       'pyname': u'stage_1_nominal_capacity',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'stage 1 parasitic electric load',
                                      {'name': u'Stage 1 Parasitic Electric Load',
                                       'pyname': u'stage_1_parasitic_electric_load',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'stage 2 gas burner efficiency',
                                      {'name': u'Stage 2 Gas Burner Efficiency',
                                       'pyname': u'stage_2_gas_burner_efficiency',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'stage 2 nominal capacity',
                                      {'name': u'Stage 2 Nominal Capacity',
                                       'pyname': u'stage_2_nominal_capacity',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'stage 2 parasitic electric load',
                                      {'name': u'Stage 2 Parasitic Electric Load',
                                       'pyname': u'stage_2_parasitic_electric_load',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'stage 3 gas burner efficiency',
                                      {'name': u'Stage 3 Gas Burner Efficiency',
                                       'pyname': u'stage_3_gas_burner_efficiency',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'stage 3 nominal capacity',
                                      {'name': u'Stage 3 Nominal Capacity',
                                       'pyname': u'stage_3_nominal_capacity',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'stage 3 parasitic electric load',
                                      {'name': u'Stage 3 Parasitic Electric Load',
                                       'pyname': u'stage_3_parasitic_electric_load',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'stage 4 gas burner efficiency',
                                      {'name': u'Stage 4 Gas Burner Efficiency',
                                       'pyname': u'stage_4_gas_burner_efficiency',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'stage 4 nominal capacity',
                                      {'name': u'Stage 4 Nominal Capacity',
                                       'pyname': u'stage_4_nominal_capacity',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'stage 4 parasitic electric load',
                                      {'name': u'Stage 4 Parasitic Electric Load',
                                       'pyname': u'stage_4_parasitic_electric_load',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 8,
              'name': u'Coil:Heating:Gas:MultiStage',
              'pyname': u'CoilHeatingGasMultiStage',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def air_inlet_node_name(self):
        """Get air_inlet_node_name.

        Returns:
            str: the value of `air_inlet_node_name` or None if not set

        """
        return self["Air Inlet Node Name"]

    @air_inlet_node_name.setter
    def air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Inlet Node Name"] = value

    @property
    def air_outlet_node_name(self):
        """Get air_outlet_node_name.

        Returns:
            str: the value of `air_outlet_node_name` or None if not set

        """
        return self["Air Outlet Node Name"]

    @air_outlet_node_name.setter
    def air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Outlet Node Name"] = value

    @property
    def temperature_setpoint_node_name(self):
        """Get temperature_setpoint_node_name.

        Returns:
            str: the value of `temperature_setpoint_node_name` or None if not set

        """
        return self["Temperature Setpoint Node Name"]

    @temperature_setpoint_node_name.setter
    def temperature_setpoint_node_name(self, value=None):
        """  Corresponds to IDD field `Temperature Setpoint Node Name`
        optional, used if coil is temperature control and not load-base
        controlled.

        Args:
            value (str): value for IDD Field `Temperature Setpoint Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Temperature Setpoint Node Name"] = value

    @property
    def part_load_fraction_correlation_curve_name(self):
        """Get part_load_fraction_correlation_curve_name.

        Returns:
            str: the value of `part_load_fraction_correlation_curve_name` or None if not set

        """
        return self["Part Load Fraction Correlation Curve Name"]

    @part_load_fraction_correlation_curve_name.setter
    def part_load_fraction_correlation_curve_name(self, value=None):
        """  Corresponds to IDD field `Part Load Fraction Correlation Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve, PLF = a + b*PLR + c*PLR**2
        cubic curve, PLF = a + b*PLR + c*PLR**2 + d*PLR**3
        PLF = part load fraction
        PLR = part load ratio (sensible heating load/steady state
        heating capacity)
        Coil runtime fraction = Part Load Ratio / PLF
        This part load degradation is for coil performance & will
        increase the gas consumption of the coil due to transient coil
        operation.

        Args:
            value (str): value for IDD Field `Part Load Fraction Correlation Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Part Load Fraction Correlation Curve Name"] = value

    @property
    def parasitic_gas_load(self):
        """Get parasitic_gas_load.

        Returns:
            float: the value of `parasitic_gas_load` or None if not set

        """
        return self["Parasitic Gas Load"]

    @parasitic_gas_load.setter
    def parasitic_gas_load(self, value=None):
        """Corresponds to IDD field `Parasitic Gas Load` parasitic gas load
        associated with the gas coil operation (i.e., standing pilot)

        Args:
            value (float): value for IDD Field `Parasitic Gas Load`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Parasitic Gas Load"] = value

    @property
    def number_of_stages(self):
        """Get number_of_stages.

        Returns:
            int: the value of `number_of_stages` or None if not set

        """
        return self["Number of Stages"]

    @number_of_stages.setter
    def number_of_stages(self, value=None):
        """Corresponds to IDD field `Number of Stages` Enter the number of the
        following sets of data for coil capacity and Gas Burner Efficiency.

        Args:
            value (int): value for IDD Field `Number of Stages`
                value >= 1
                value <= 4
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Number of Stages"] = value

    @property
    def stage_1_gas_burner_efficiency(self):
        """Get stage_1_gas_burner_efficiency.

        Returns:
            float: the value of `stage_1_gas_burner_efficiency` or None if not set

        """
        return self["Stage 1 Gas Burner Efficiency"]

    @stage_1_gas_burner_efficiency.setter
    def stage_1_gas_burner_efficiency(self, value=None):
        """Corresponds to IDD field `Stage 1 Gas Burner Efficiency`

        Args:
            value (float): value for IDD Field `Stage 1 Gas Burner Efficiency`
                Units: W/W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 1 Gas Burner Efficiency"] = value

    @property
    def stage_1_nominal_capacity(self):
        """Get stage_1_nominal_capacity.

        Returns:
            float: the value of `stage_1_nominal_capacity` or None if not set

        """
        return self["Stage 1 Nominal Capacity"]

    @stage_1_nominal_capacity.setter
    def stage_1_nominal_capacity(self, value=None):
        """Corresponds to IDD field `Stage 1 Nominal Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Stage 1 Nominal Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 1 Nominal Capacity"] = value

    @property
    def stage_1_parasitic_electric_load(self):
        """Get stage_1_parasitic_electric_load.

        Returns:
            float: the value of `stage_1_parasitic_electric_load` or None if not set

        """
        return self["Stage 1 Parasitic Electric Load"]

    @stage_1_parasitic_electric_load.setter
    def stage_1_parasitic_electric_load(self, value=None):
        """Corresponds to IDD field `Stage 1 Parasitic Electric Load` Stage 1
        parasitic electric load associated with the gas coil operation such as
        an inducer fan, etc.  This will be modified by the part load ratio to
        reflect the time of operation in a timestep.

        Args:
            value (float): value for IDD Field `Stage 1 Parasitic Electric Load`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 1 Parasitic Electric Load"] = value

    @property
    def stage_2_gas_burner_efficiency(self):
        """Get stage_2_gas_burner_efficiency.

        Returns:
            float: the value of `stage_2_gas_burner_efficiency` or None if not set

        """
        return self["Stage 2 Gas Burner Efficiency"]

    @stage_2_gas_burner_efficiency.setter
    def stage_2_gas_burner_efficiency(self, value=None):
        """Corresponds to IDD field `Stage 2 Gas Burner Efficiency`

        Args:
            value (float): value for IDD Field `Stage 2 Gas Burner Efficiency`
                Units: W/W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 2 Gas Burner Efficiency"] = value

    @property
    def stage_2_nominal_capacity(self):
        """Get stage_2_nominal_capacity.

        Returns:
            float: the value of `stage_2_nominal_capacity` or None if not set

        """
        return self["Stage 2 Nominal Capacity"]

    @stage_2_nominal_capacity.setter
    def stage_2_nominal_capacity(self, value=None):
        """Corresponds to IDD field `Stage 2 Nominal Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Stage 2 Nominal Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 2 Nominal Capacity"] = value

    @property
    def stage_2_parasitic_electric_load(self):
        """Get stage_2_parasitic_electric_load.

        Returns:
            float: the value of `stage_2_parasitic_electric_load` or None if not set

        """
        return self["Stage 2 Parasitic Electric Load"]

    @stage_2_parasitic_electric_load.setter
    def stage_2_parasitic_electric_load(self, value=None):
        """Corresponds to IDD field `Stage 2 Parasitic Electric Load` Stage 2
        parasitic electric load associated with the gas coil operation such as
        an inducer fan, etc.  This will be modified by the part load ratio to
        reflect the time of operation in a timestep.

        Args:
            value (float): value for IDD Field `Stage 2 Parasitic Electric Load`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 2 Parasitic Electric Load"] = value

    @property
    def stage_3_gas_burner_efficiency(self):
        """Get stage_3_gas_burner_efficiency.

        Returns:
            float: the value of `stage_3_gas_burner_efficiency` or None if not set

        """
        return self["Stage 3 Gas Burner Efficiency"]

    @stage_3_gas_burner_efficiency.setter
    def stage_3_gas_burner_efficiency(self, value=None):
        """Corresponds to IDD field `Stage 3 Gas Burner Efficiency`

        Args:
            value (float): value for IDD Field `Stage 3 Gas Burner Efficiency`
                Units: W/W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 3 Gas Burner Efficiency"] = value

    @property
    def stage_3_nominal_capacity(self):
        """Get stage_3_nominal_capacity.

        Returns:
            float: the value of `stage_3_nominal_capacity` or None if not set

        """
        return self["Stage 3 Nominal Capacity"]

    @stage_3_nominal_capacity.setter
    def stage_3_nominal_capacity(self, value=None):
        """Corresponds to IDD field `Stage 3 Nominal Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Stage 3 Nominal Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 3 Nominal Capacity"] = value

    @property
    def stage_3_parasitic_electric_load(self):
        """Get stage_3_parasitic_electric_load.

        Returns:
            float: the value of `stage_3_parasitic_electric_load` or None if not set

        """
        return self["Stage 3 Parasitic Electric Load"]

    @stage_3_parasitic_electric_load.setter
    def stage_3_parasitic_electric_load(self, value=None):
        """Corresponds to IDD field `Stage 3 Parasitic Electric Load` Stage 3
        parasitic electric load associated with the gas coil operation such as
        an inducer fan, etc.  This will be modified by the part load ratio to
        reflect the time of operation in a timestep.

        Args:
            value (float): value for IDD Field `Stage 3 Parasitic Electric Load`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 3 Parasitic Electric Load"] = value

    @property
    def stage_4_gas_burner_efficiency(self):
        """Get stage_4_gas_burner_efficiency.

        Returns:
            float: the value of `stage_4_gas_burner_efficiency` or None if not set

        """
        return self["Stage 4 Gas Burner Efficiency"]

    @stage_4_gas_burner_efficiency.setter
    def stage_4_gas_burner_efficiency(self, value=None):
        """Corresponds to IDD field `Stage 4 Gas Burner Efficiency`

        Args:
            value (float): value for IDD Field `Stage 4 Gas Burner Efficiency`
                Units: W/W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 4 Gas Burner Efficiency"] = value

    @property
    def stage_4_nominal_capacity(self):
        """Get stage_4_nominal_capacity.

        Returns:
            float: the value of `stage_4_nominal_capacity` or None if not set

        """
        return self["Stage 4 Nominal Capacity"]

    @stage_4_nominal_capacity.setter
    def stage_4_nominal_capacity(self, value=None):
        """Corresponds to IDD field `Stage 4 Nominal Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Stage 4 Nominal Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 4 Nominal Capacity"] = value

    @property
    def stage_4_parasitic_electric_load(self):
        """Get stage_4_parasitic_electric_load.

        Returns:
            float: the value of `stage_4_parasitic_electric_load` or None if not set

        """
        return self["Stage 4 Parasitic Electric Load"]

    @stage_4_parasitic_electric_load.setter
    def stage_4_parasitic_electric_load(self, value=None):
        """Corresponds to IDD field `Stage 4 Parasitic Electric Load` Stage 4
        parasitic electric load associated with the gas coil operation such as
        an inducer fan, etc.  This will be modified by the part load ratio to
        reflect the time of operation in a timestep.

        Args:
            value (float): value for IDD Field `Stage 4 Parasitic Electric Load`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Stage 4 Parasitic Electric Load"] = value




class CoilHeatingDesuperheater(DataObject):

    """ Corresponds to IDD object `Coil:Heating:Desuperheater`
        Desuperheater air heating coil. The heating energy provided by this coil is reclaimed
        from the superheated refrigerant gas leaving a compressor and does not impact the
        performance of the compressor. If the coil is located directly in an air loop
        branch or outdoor air equipment list, then it is controlled on leaving air temperature
        and the Temperature Setpoint Node Name must be specified. If the coil is contained
        within another component such as a unitary system, then the coil is controlled by the
        parent component and the setpoint node name is not entered.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'heat reclaim recovery efficiency',
                                      {'name': u'Heat Reclaim Recovery Efficiency',
                                       'pyname': u'heat_reclaim_recovery_efficiency',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'air inlet node name',
                                      {'name': u'Air Inlet Node Name',
                                       'pyname': u'air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air outlet node name',
                                      {'name': u'Air Outlet Node Name',
                                       'pyname': u'air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'heating source object type',
                                      {'name': u'Heating Source Object Type',
                                       'pyname': u'heating_source_object_type',
                                       'required-field': True,
                                       'autosizable': False,
                                       'accepted-values': [u'Coil:Cooling:DX:SingleSpeed',
                                                           u'Coil:Cooling:DX:TwoSpeed',
                                                           u'Coil:Cooling:DX:TwoStageWithHumidityControlMode',
                                                           u'Refrigeration:CompressorRack',
                                                           u'Refrigeration:Condenser:AirCooled',
                                                           u'Refrigeration:Condenser:EvaporativeCooled',
                                                           u'Refrigeration:Condenser:WaterCooled'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heating source name',
                                      {'name': u'Heating Source Name',
                                       'pyname': u'heating_source_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'temperature setpoint node name',
                                      {'name': u'Temperature Setpoint Node Name',
                                       'pyname': u'temperature_setpoint_node_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'parasitic electric load',
                                      {'name': u'Parasitic Electric Load',
                                       'pyname': u'parasitic_electric_load',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 7,
              'name': u'Coil:Heating:Desuperheater',
              'pyname': u'CoilHeatingDesuperheater',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def heat_reclaim_recovery_efficiency(self):
        """Get heat_reclaim_recovery_efficiency.

        Returns:
            float: the value of `heat_reclaim_recovery_efficiency` or None if not set

        """
        return self["Heat Reclaim Recovery Efficiency"]

    @heat_reclaim_recovery_efficiency.setter
    def heat_reclaim_recovery_efficiency(self, value=None):
        """Corresponds to IDD field `Heat Reclaim Recovery Efficiency`

        Args:
            value (float): value for IDD Field `Heat Reclaim Recovery Efficiency`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Reclaim Recovery Efficiency"] = value

    @property
    def air_inlet_node_name(self):
        """Get air_inlet_node_name.

        Returns:
            str: the value of `air_inlet_node_name` or None if not set

        """
        return self["Air Inlet Node Name"]

    @air_inlet_node_name.setter
    def air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Inlet Node Name"] = value

    @property
    def air_outlet_node_name(self):
        """Get air_outlet_node_name.

        Returns:
            str: the value of `air_outlet_node_name` or None if not set

        """
        return self["Air Outlet Node Name"]

    @air_outlet_node_name.setter
    def air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Outlet Node Name"] = value

    @property
    def heating_source_object_type(self):
        """Get heating_source_object_type.

        Returns:
            str: the value of `heating_source_object_type` or None if not set

        """
        return self["Heating Source Object Type"]

    @heating_source_object_type.setter
    def heating_source_object_type(self, value=None):
        """Corresponds to IDD field `Heating Source Object Type`

        Args:
            value (str): value for IDD Field `Heating Source Object Type`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Source Object Type"] = value

    @property
    def heating_source_name(self):
        """Get heating_source_name.

        Returns:
            str: the value of `heating_source_name` or None if not set

        """
        return self["Heating Source Name"]

    @heating_source_name.setter
    def heating_source_name(self, value=None):
        """Corresponds to IDD field `Heating Source Name`

        Args:
            value (str): value for IDD Field `Heating Source Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Source Name"] = value

    @property
    def temperature_setpoint_node_name(self):
        """Get temperature_setpoint_node_name.

        Returns:
            str: the value of `temperature_setpoint_node_name` or None if not set

        """
        return self["Temperature Setpoint Node Name"]

    @temperature_setpoint_node_name.setter
    def temperature_setpoint_node_name(self, value=None):
        """  Corresponds to IDD field `Temperature Setpoint Node Name`
        Required if coil is temperature controlled.
        Temperature-based control requires the use of a SetpointManager object

        Args:
            value (str): value for IDD Field `Temperature Setpoint Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Temperature Setpoint Node Name"] = value

    @property
    def parasitic_electric_load(self):
        """Get parasitic_electric_load.

        Returns:
            float: the value of `parasitic_electric_load` or None if not set

        """
        return self["Parasitic Electric Load"]

    @parasitic_electric_load.setter
    def parasitic_electric_load(self, value=None):
        """Corresponds to IDD field `Parasitic Electric Load` parasitic
        electric load associated with the desuperheater coil operation such as
        solenoid valves, etc.

        Args:
            value (float): value for IDD Field `Parasitic Electric Load`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Parasitic Electric Load"] = value




class CoilHeatingDxSingleSpeed(DataObject):

    """ Corresponds to IDD object `Coil:Heating:DX:SingleSpeed`
        Direct expansion (DX) heating coil (air-to-air heat pump) and compressor unit
        (includes electric compressor and outdoor fan), single-speed, with defrost controls.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'gross rated heating capacity',
                                      {'name': u'Gross Rated Heating Capacity',
                                       'pyname': u'gross_rated_heating_capacity',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'gross rated heating cop',
                                      {'name': u'Gross Rated Heating COP',
                                       'pyname': u'gross_rated_heating_cop',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'rated air flow rate',
                                      {'name': u'Rated Air Flow Rate',
                                       'pyname': u'rated_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'rated supply fan power per volume flow rate',
                                      {'name': u'Rated Supply Fan Power Per Volume Flow Rate',
                                       'pyname': u'rated_supply_fan_power_per_volume_flow_rate',
                                       'default': 773.3,
                                       'maximum': 1250.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/(m3/s)'}),
                                     (u'air inlet node name',
                                      {'name': u'Air Inlet Node Name',
                                       'pyname': u'air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air outlet node name',
                                      {'name': u'Air Outlet Node Name',
                                       'pyname': u'air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'heating capacity function of temperature curve name',
                                      {'name': u'Heating Capacity Function of Temperature Curve Name',
                                       'pyname': u'heating_capacity_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'heating capacity function of flow fraction curve name',
                                      {'name': u'Heating Capacity Function of Flow Fraction Curve Name',
                                       'pyname': u'heating_capacity_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'energy input ratio function of temperature curve name',
                                      {'name': u'Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'energy input ratio function of flow fraction curve name',
                                      {'name': u'Energy Input Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'energy_input_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'part load fraction correlation curve name',
                                      {'name': u'Part Load Fraction Correlation Curve Name',
                                       'pyname': u'part_load_fraction_correlation_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'defrost energy input ratio function of temperature curve name',
                                      {'name': u'Defrost Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'defrost_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'minimum outdoor dry-bulb temperature for compressor operation',
                                      {'name': u'Minimum Outdoor Dry-Bulb Temperature for Compressor Operation',
                                       'pyname': u'minimum_outdoor_drybulb_temperature_for_compressor_operation',
                                       'default': -8.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': -20.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'outdoor dry-bulb temperature to turn on compressor',
                                      {'name': u'Outdoor Dry-Bulb Temperature to Turn On Compressor',
                                       'pyname': u'outdoor_drybulb_temperature_to_turn_on_compressor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'maximum outdoor dry-bulb temperature for defrost operation',
                                      {'name': u'Maximum Outdoor Dry-Bulb Temperature for Defrost Operation',
                                       'pyname': u'maximum_outdoor_drybulb_temperature_for_defrost_operation',
                                       'default': 5.0,
                                       'maximum': 7.22,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'crankcase heater capacity',
                                      {'name': u'Crankcase Heater Capacity',
                                       'pyname': u'crankcase_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'maximum outdoor dry-bulb temperature for crankcase heater operation',
                                      {'name': u'Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation',
                                       'pyname': u'maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation',
                                       'default': 10.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'defrost strategy',
                                      {'name': u'Defrost Strategy',
                                       'pyname': u'defrost_strategy',
                                       'default': u'ReverseCycle',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'ReverseCycle',
                                                           u'Resistive'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'defrost control',
                                      {'name': u'Defrost Control',
                                       'pyname': u'defrost_control',
                                       'default': u'Timed',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Timed',
                                                           u'OnDemand'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'defrost time period fraction',
                                      {'name': u'Defrost Time Period Fraction',
                                       'pyname': u'defrost_time_period_fraction',
                                       'default': 0.058333,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'resistive defrost heater capacity',
                                      {'name': u'Resistive Defrost Heater Capacity',
                                       'pyname': u'resistive_defrost_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'region number for calculating hspf',
                                      {'name': u'Region number for calculating HSPF',
                                       'pyname': u'region_number_for_calculating_hspf',
                                       'default': 4,
                                       'maximum': 6,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 1,
                                       'autocalculatable': False,
                                       'type': u'integer'}),
                                     (u'evaporator air inlet node name',
                                      {'name': u'Evaporator Air Inlet Node Name',
                                       'pyname': u'evaporator_air_inlet_node_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 21,
              'name': u'Coil:Heating:DX:SingleSpeed',
              'pyname': u'CoilHeatingDxSingleSpeed',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def gross_rated_heating_capacity(self):
        """Get gross_rated_heating_capacity.

        Returns:
            float: the value of `gross_rated_heating_capacity` or None if not set

        """
        return self["Gross Rated Heating Capacity"]

    @gross_rated_heating_capacity.setter
    def gross_rated_heating_capacity(self, value=None):
        """  Corresponds to IDD field `Gross Rated Heating Capacity`
        Heating capacity not accounting for the effect of supply air fan heat
        capacity excluding supply air fan heat
        rating point outdoor dry-bulb temp 8.33 C, outdoor wet-bulb temp 6.11 C
        rating point heating coil entering air dry-bulb 21.11 C, coil entering wet-bulb 15.55 C

        Args:
            value (float or "Autosize"): value for IDD Field `Gross Rated Heating Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Gross Rated Heating Capacity"] = value

    @property
    def gross_rated_heating_cop(self):
        """Get gross_rated_heating_cop.

        Returns:
            float: the value of `gross_rated_heating_cop` or None if not set

        """
        return self["Gross Rated Heating COP"]

    @gross_rated_heating_cop.setter
    def gross_rated_heating_cop(self, value=None):
        """Corresponds to IDD field `Gross Rated Heating COP` Rated heating
        capacity divided by power input to the compressor and outdoor fan, does
        not include supply air fan heat or supply air fan electrical energy
        does not include supply air fan heat or supply air fan electrical
        energy.

        Args:
            value (float): value for IDD Field `Gross Rated Heating COP`
                Units: W/W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gross Rated Heating COP"] = value

    @property
    def rated_air_flow_rate(self):
        """Get rated_air_flow_rate.

        Returns:
            float: the value of `rated_air_flow_rate` or None if not set

        """
        return self["Rated Air Flow Rate"]

    @rated_air_flow_rate.setter
    def rated_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Rated Air Flow Rate`
        Flow rate corresponding to rated total capacity
        should be between 0.00004027 m3/s and .00006041 m3/s per watt of rated heating capacity

        Args:
            value (float or "Autosize"): value for IDD Field `Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Rated Air Flow Rate"] = value

    @property
    def rated_supply_fan_power_per_volume_flow_rate(self):
        """Get rated_supply_fan_power_per_volume_flow_rate.

        Returns:
            float: the value of `rated_supply_fan_power_per_volume_flow_rate` or None if not set

        """
        return self["Rated Supply Fan Power Per Volume Flow Rate"]

    @rated_supply_fan_power_per_volume_flow_rate.setter
    def rated_supply_fan_power_per_volume_flow_rate(self, value=773.3):
        """Corresponds to IDD field `Rated Supply Fan Power Per Volume Flow
        Rate` Enter the supply fan power per air volume flow rate at the rated
        test conditions. The test conditions vary external static pressure
        based on heating capacity. This value is only used to calculate Heating
        Seasonal Performance Factor(HSPF). This value is not used for modeling
        the supply (condenser) fan during simulations.

        Args:
            value (float): value for IDD Field `Rated Supply Fan Power Per Volume Flow Rate`
                Units: W/(m3/s)
                Default value: 773.3
                value <= 1250.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Rated Supply Fan Power Per Volume Flow Rate"] = value

    @property
    def air_inlet_node_name(self):
        """Get air_inlet_node_name.

        Returns:
            str: the value of `air_inlet_node_name` or None if not set

        """
        return self["Air Inlet Node Name"]

    @air_inlet_node_name.setter
    def air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Inlet Node Name"] = value

    @property
    def air_outlet_node_name(self):
        """Get air_outlet_node_name.

        Returns:
            str: the value of `air_outlet_node_name` or None if not set

        """
        return self["Air Outlet Node Name"]

    @air_outlet_node_name.setter
    def air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Outlet Node Name"] = value

    @property
    def heating_capacity_function_of_temperature_curve_name(self):
        """Get heating_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `heating_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self["Heating Capacity Function of Temperature Curve Name"]

    @heating_capacity_function_of_temperature_curve_name.setter
    def heating_capacity_function_of_temperature_curve_name(self, value=None):
        """  Corresponds to IDD field `Heating Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        quadratic curve = a + b*oat + c*oat**2
        cubic curve = a + b*oat + c*oat**2 + d*oat**3
        biquadratic curve = a + b*iat + c*iat**2 + d*oat + e*oat**2 + f*iat*oat
        oat = outdoor air dry-bulb temperature (C)
        iat = indoor air dry-bulb temperature (C)
        Biquadratic curve is recommended if sufficient manufacturer data is
        available for the heating capacity to be sensitive to both iat and oat.

        Args:
            value (str): value for IDD Field `Heating Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Heating Capacity Function of Temperature Curve Name"] = value

    @property
    def heating_capacity_function_of_flow_fraction_curve_name(self):
        """Get heating_capacity_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `heating_capacity_function_of_flow_fraction_curve_name` or None if not set

        """
        return self["Heating Capacity Function of Flow Fraction Curve Name"]

    @heating_capacity_function_of_flow_fraction_curve_name.setter
    def heating_capacity_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Heating Capacity Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Heating Capacity Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Heating Capacity Function of Flow Fraction Curve Name"] = value

    @property
    def energy_input_ratio_function_of_temperature_curve_name(self):
        """Get energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self["Energy Input Ratio Function of Temperature Curve Name"]

    @energy_input_ratio_function_of_temperature_curve_name.setter
    def energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        quadratic curve = a + b*oat + c*oat**2
        cubic curve = a + b*oat + c*oat**2 + d*oat**3
        biquadratic curve = a + b*iat + c*iat**2 + d*oat + e*oat**2 + f*iat*oat
        oat = outdoor air dry-bulb temperature (C)
        iat = indoor air dry-bulb temperature (C)
        biquadratic curve is recommended if sufficient manufacturer data is
        available for the energy input ratio to be sensitive to both iat and oat.

        Args:
            value (str): value for IDD Field `Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def energy_input_ratio_function_of_flow_fraction_curve_name(self):
        """Get energy_input_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `energy_input_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self["Energy Input Ratio Function of Flow Fraction Curve Name"]

    @energy_input_ratio_function_of_flow_fraction_curve_name.setter
    def energy_input_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Energy Input Ratio Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Energy Input Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Energy Input Ratio Function of Flow Fraction Curve Name"] = value

    @property
    def part_load_fraction_correlation_curve_name(self):
        """Get part_load_fraction_correlation_curve_name.

        Returns:
            str: the value of `part_load_fraction_correlation_curve_name` or None if not set

        """
        return self["Part Load Fraction Correlation Curve Name"]

    @part_load_fraction_correlation_curve_name.setter
    def part_load_fraction_correlation_curve_name(self, value=None):
        """  Corresponds to IDD field `Part Load Fraction Correlation Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*PLR + c*PLR**2
        cubic curve = a + b*PLR + c*PLR**2 + d*PLR**3
        PLR = part load ratio (sensible heating load/steady state heating capacity)

        Args:
            value (str): value for IDD Field `Part Load Fraction Correlation Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Part Load Fraction Correlation Curve Name"] = value

    @property
    def defrost_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get defrost_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `defrost_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Defrost Energy Input Ratio Function of Temperature Curve Name"]

    @defrost_energy_input_ratio_function_of_temperature_curve_name.setter
    def defrost_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Defrost Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        biquadratic curve = a + b*wb + c*wb**2 + d*oat + e*oat**2 + f*wb*oat
        wb = wet-bulb temperature (C) of air entering the indoor coil
        oat = outdoor air dry-bulb temperature (C)
        only required if ReverseCycle defrost strategy is specified

        Args:
            value (str): value for IDD Field `Defrost Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Defrost Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def minimum_outdoor_drybulb_temperature_for_compressor_operation(self):
        """Get minimum_outdoor_drybulb_temperature_for_compressor_operation.

        Returns:
            float: the value of `minimum_outdoor_drybulb_temperature_for_compressor_operation` or None if not set

        """
        return self[
            "Minimum Outdoor Dry-Bulb Temperature for Compressor Operation"]

    @minimum_outdoor_drybulb_temperature_for_compressor_operation.setter
    def minimum_outdoor_drybulb_temperature_for_compressor_operation(
            self,
            value=-
            8.0):
        """  Corresponds to IDD field `Minimum Outdoor Dry-Bulb Temperature for Compressor Operation`

        Args:
            value (float): value for IDD Field `Minimum Outdoor Dry-Bulb Temperature for Compressor Operation`
                Units: C
                Default value: -8.0
                value >= -20.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Minimum Outdoor Dry-Bulb Temperature for Compressor Operation"] = value

    @property
    def outdoor_drybulb_temperature_to_turn_on_compressor(self):
        """Get outdoor_drybulb_temperature_to_turn_on_compressor.

        Returns:
            float: the value of `outdoor_drybulb_temperature_to_turn_on_compressor` or None if not set

        """
        return self["Outdoor Dry-Bulb Temperature to Turn On Compressor"]

    @outdoor_drybulb_temperature_to_turn_on_compressor.setter
    def outdoor_drybulb_temperature_to_turn_on_compressor(self, value=None):
        """  Corresponds to IDD field `Outdoor Dry-Bulb Temperature to Turn On Compressor`
        The outdoor temperature when the compressor is automatically turned back on following an
        automatic shut off because of low outdoor dry-bulb temperature. This field is only used
        for the calculation of HSPF. If this field is not provided, then outdoor bin temperature
        used in the HSPF calculation is always considered to be greater than this temperature and
        'Minimum Outdoor Dry-Bulb Temperature for Compressor Operation' field described above.
        This assumption is based on AHRI standard 210/240 (2008) and can introduce significant error
        in the final value of HSPF.

        Args:
            value (float): value for IDD Field `Outdoor Dry-Bulb Temperature to Turn On Compressor`
                Units: C
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Dry-Bulb Temperature to Turn On Compressor"] = value

    @property
    def maximum_outdoor_drybulb_temperature_for_defrost_operation(self):
        """Get maximum_outdoor_drybulb_temperature_for_defrost_operation.

        Returns:
            float: the value of `maximum_outdoor_drybulb_temperature_for_defrost_operation` or None if not set

        """
        return self[
            "Maximum Outdoor Dry-Bulb Temperature for Defrost Operation"]

    @maximum_outdoor_drybulb_temperature_for_defrost_operation.setter
    def maximum_outdoor_drybulb_temperature_for_defrost_operation(
            self,
            value=5.0):
        """  Corresponds to IDD field `Maximum Outdoor Dry-Bulb Temperature for Defrost Operation`

        Args:
            value (float): value for IDD Field `Maximum Outdoor Dry-Bulb Temperature for Defrost Operation`
                Units: C
                Default value: 5.0
                value <= 7.22
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Maximum Outdoor Dry-Bulb Temperature for Defrost Operation"] = value

    @property
    def crankcase_heater_capacity(self):
        """Get crankcase_heater_capacity.

        Returns:
            float: the value of `crankcase_heater_capacity` or None if not set

        """
        return self["Crankcase Heater Capacity"]

    @crankcase_heater_capacity.setter
    def crankcase_heater_capacity(self, value=None):
        """Corresponds to IDD field `Crankcase Heater Capacity`

        Args:
            value (float): value for IDD Field `Crankcase Heater Capacity`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Crankcase Heater Capacity"] = value

    @property
    def maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation(
            self):
        """Get
        maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation.

        Returns:
            float: the value of `maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation` or None if not set

        """
        return self[
            "Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation"]

    @maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation.setter
    def maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation(
            self,
            value=10.0):
        """  Corresponds to IDD field `Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation`

        Args:
            value (float): value for IDD Field `Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation`
                Units: C
                Default value: 10.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation"] = value

    @property
    def defrost_strategy(self):
        """Get defrost_strategy.

        Returns:
            str: the value of `defrost_strategy` or None if not set

        """
        return self["Defrost Strategy"]

    @defrost_strategy.setter
    def defrost_strategy(self, value="ReverseCycle"):
        """Corresponds to IDD field `Defrost Strategy`

        Args:
            value (str): value for IDD Field `Defrost Strategy`
                Default value: ReverseCycle
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Defrost Strategy"] = value

    @property
    def defrost_control(self):
        """Get defrost_control.

        Returns:
            str: the value of `defrost_control` or None if not set

        """
        return self["Defrost Control"]

    @defrost_control.setter
    def defrost_control(self, value="Timed"):
        """Corresponds to IDD field `Defrost Control`

        Args:
            value (str): value for IDD Field `Defrost Control`
                Default value: Timed
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Defrost Control"] = value

    @property
    def defrost_time_period_fraction(self):
        """Get defrost_time_period_fraction.

        Returns:
            float: the value of `defrost_time_period_fraction` or None if not set

        """
        return self["Defrost Time Period Fraction"]

    @defrost_time_period_fraction.setter
    def defrost_time_period_fraction(self, value=0.058333):
        """Corresponds to IDD field `Defrost Time Period Fraction` Fraction of
        time in defrost mode only applicable if timed defrost control is
        specified.

        Args:
            value (float): value for IDD Field `Defrost Time Period Fraction`
                Default value: 0.058333
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Defrost Time Period Fraction"] = value

    @property
    def resistive_defrost_heater_capacity(self):
        """Get resistive_defrost_heater_capacity.

        Returns:
            float: the value of `resistive_defrost_heater_capacity` or None if not set

        """
        return self["Resistive Defrost Heater Capacity"]

    @resistive_defrost_heater_capacity.setter
    def resistive_defrost_heater_capacity(self, value=None):
        """Corresponds to IDD field `Resistive Defrost Heater Capacity` only
        applicable if resistive defrost strategy is specified.

        Args:
            value (float or "Autosize"): value for IDD Field `Resistive Defrost Heater Capacity`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Resistive Defrost Heater Capacity"] = value

    @property
    def region_number_for_calculating_hspf(self):
        """Get region_number_for_calculating_hspf.

        Returns:
            int: the value of `region_number_for_calculating_hspf` or None if not set

        """
        return self["Region number for calculating HSPF"]

    @region_number_for_calculating_hspf.setter
    def region_number_for_calculating_hspf(self, value=4):
        """Corresponds to IDD field `Region number for calculating HSPF`
        Standard Region number for which HSPF and other standard ratings are
        calculated.

        Args:
            value (int): value for IDD Field `Region number for calculating HSPF`
                Default value: 4
                value >= 1
                value <= 6
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Region number for calculating HSPF"] = value

    @property
    def evaporator_air_inlet_node_name(self):
        """Get evaporator_air_inlet_node_name.

        Returns:
            str: the value of `evaporator_air_inlet_node_name` or None if not set

        """
        return self["Evaporator Air Inlet Node Name"]

    @evaporator_air_inlet_node_name.setter
    def evaporator_air_inlet_node_name(self, value=None):
        """  Corresponds to IDD field `Evaporator Air Inlet Node Name`
        Enter the name of an outdoor air node. This node name is also specified in
        an OutdoorAir:Node or OutdoorAir:NodeList object.

        Args:
            value (str): value for IDD Field `Evaporator Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Evaporator Air Inlet Node Name"] = value




class CoilHeatingDxMultiSpeed(DataObject):

    """ Corresponds to IDD object `Coil:Heating:DX:MultiSpeed`
        Direct expansion (DX) heating coil (air-to-air heat pump) and compressor unit
        (includes electric or engine-driven compressor and outdoor fan), multi-speed
        (or variable-speed), with defrost controls. Requires two to four sets
        of performance data and will interpolate between speeds.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'availability schedule name',
                                      {'name': u'Availability Schedule Name',
                                       'pyname': u'availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'air inlet node name',
                                      {'name': u'Air Inlet Node Name',
                                       'pyname': u'air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'air outlet node name',
                                      {'name': u'Air Outlet Node Name',
                                       'pyname': u'air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'minimum outdoor dry-bulb temperature for compressor operation',
                                      {'name': u'Minimum Outdoor Dry-Bulb Temperature for Compressor Operation',
                                       'pyname': u'minimum_outdoor_drybulb_temperature_for_compressor_operation',
                                       'default': -8.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'outdoor dry-bulb temperature to turn on compressor',
                                      {'name': u'Outdoor Dry-Bulb Temperature to Turn On Compressor',
                                       'pyname': u'outdoor_drybulb_temperature_to_turn_on_compressor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'crankcase heater capacity',
                                      {'name': u'Crankcase Heater Capacity',
                                       'pyname': u'crankcase_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'maximum outdoor dry-bulb temperature for crankcase heater operation',
                                      {'name': u'Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation',
                                       'pyname': u'maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation',
                                       'default': 10.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'defrost energy input ratio function of temperature curve name',
                                      {'name': u'Defrost Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'defrost_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'maximum outdoor dry-bulb temperature for defrost operation',
                                      {'name': u'Maximum Outdoor Dry-Bulb Temperature for Defrost Operation',
                                       'pyname': u'maximum_outdoor_drybulb_temperature_for_defrost_operation',
                                       'default': 5.0,
                                       'maximum': 7.22,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'defrost strategy',
                                      {'name': u'Defrost Strategy',
                                       'pyname': u'defrost_strategy',
                                       'default': u'ReverseCycle',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'ReverseCycle',
                                                           u'Resistive'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'defrost control',
                                      {'name': u'Defrost Control',
                                       'pyname': u'defrost_control',
                                       'default': u'Timed',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Timed',
                                                           u'OnDemand'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'defrost time period fraction',
                                      {'name': u'Defrost Time Period Fraction',
                                       'pyname': u'defrost_time_period_fraction',
                                       'default': 0.058333,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'resistive defrost heater capacity',
                                      {'name': u'Resistive Defrost Heater Capacity',
                                       'pyname': u'resistive_defrost_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'apply part load fraction to speeds greater than 1',
                                      {'name': u'Apply Part Load Fraction to Speeds Greater than 1',
                                       'pyname': u'apply_part_load_fraction_to_speeds_greater_than_1',
                                       'default': u'No',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Yes',
                                                           u'No'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'fuel type',
                                      {'name': u'Fuel Type',
                                       'pyname': u'fuel_type',
                                       'default': u'NaturalGas',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Electricity',
                                                           u'NaturalGas',
                                                           u'PropaneGas',
                                                           u'Diesel',
                                                           u'Gasoline',
                                                           u'FuelOil#1',
                                                           u'FuelOil#2',
                                                           u'OtherFuel1',
                                                           u'OtherFuel2'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'region number for calculating hspf',
                                      {'name': u'Region number for Calculating HSPF',
                                       'pyname': u'region_number_for_calculating_hspf',
                                       'default': 4,
                                       'maximum': 6,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 1,
                                       'autocalculatable': False,
                                       'type': u'integer'}),
                                     (u'number of speeds',
                                      {'name': u'Number of Speeds',
                                       'pyname': u'number_of_speeds',
                                       'maximum': 4,
                                       'required-field': True,
                                       'autosizable': False,
                                       'minimum': 2,
                                       'autocalculatable': False,
                                       'type': u'integer'}),
                                     (u'speed 1 gross rated heating capacity',
                                      {'name': u'Speed 1 Gross Rated Heating Capacity',
                                       'pyname': u'speed_1_gross_rated_heating_capacity',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'speed 1 gross rated heating cop',
                                      {'name': u'Speed 1 Gross Rated Heating COP',
                                       'pyname': u'speed_1_gross_rated_heating_cop',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'speed 1 rated air flow rate',
                                      {'name': u'Speed 1 Rated Air Flow Rate',
                                       'pyname': u'speed_1_rated_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 1 rated supply air fan power per volume flow rate',
                                      {'name': u'Speed 1 Rated Supply Air Fan Power Per Volume Flow Rate',
                                       'pyname': u'speed_1_rated_supply_air_fan_power_per_volume_flow_rate',
                                       'default': 773.3,
                                       'maximum': 1250.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/(m3/s)'}),
                                     (u'speed 1 heating capacity function of temperature curve name',
                                      {'name': u'Speed 1 Heating Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_1_heating_capacity_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 heating capacity function of flow fraction curve name',
                                      {'name': u'Speed 1 Heating Capacity Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_1_heating_capacity_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 1 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_1_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 energy input ratio function of flow fraction curve name',
                                      {'name': u'Speed 1 Energy Input Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_1_energy_input_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 part load fraction correlation curve name',
                                      {'name': u'Speed 1 Part Load Fraction Correlation Curve Name',
                                       'pyname': u'speed_1_part_load_fraction_correlation_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 rated waste heat fraction of power input',
                                      {'name': u'Speed 1 Rated Waste Heat Fraction of Power Input',
                                       'pyname': u'speed_1_rated_waste_heat_fraction_of_power_input',
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 1 waste heat function of temperature curve name',
                                      {'name': u'Speed 1 Waste Heat Function of Temperature Curve Name',
                                       'pyname': u'speed_1_waste_heat_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 gross rated heating capacity',
                                      {'name': u'Speed 2 Gross Rated Heating Capacity',
                                       'pyname': u'speed_2_gross_rated_heating_capacity',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'speed 2 gross rated heating cop',
                                      {'name': u'Speed 2 Gross Rated Heating COP',
                                       'pyname': u'speed_2_gross_rated_heating_cop',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'speed 2 rated air flow rate',
                                      {'name': u'Speed 2 Rated Air Flow Rate',
                                       'pyname': u'speed_2_rated_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 2 rated supply air fan power per volume flow rate',
                                      {'name': u'Speed 2 Rated Supply Air Fan Power Per Volume Flow Rate',
                                       'pyname': u'speed_2_rated_supply_air_fan_power_per_volume_flow_rate',
                                       'default': 773.3,
                                       'maximum': 1250.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/(m3/s)'}),
                                     (u'speed 2 heating capacity function of temperature curve name',
                                      {'name': u'Speed 2 Heating Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_2_heating_capacity_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 heating capacity function of flow fraction curve name',
                                      {'name': u'Speed 2 Heating Capacity Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_2_heating_capacity_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 2 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_2_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 energy input ratio function of flow fraction curve name',
                                      {'name': u'Speed 2 Energy Input Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_2_energy_input_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 part load fraction correlation curve name',
                                      {'name': u'Speed 2 Part Load Fraction Correlation Curve Name',
                                       'pyname': u'speed_2_part_load_fraction_correlation_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 rated waste heat fraction of power input',
                                      {'name': u'Speed 2 Rated Waste Heat Fraction of Power Input',
                                       'pyname': u'speed_2_rated_waste_heat_fraction_of_power_input',
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 2 waste heat function of temperature curve name',
                                      {'name': u'Speed 2 Waste Heat Function of Temperature Curve Name',
                                       'pyname': u'speed_2_waste_heat_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 gross rated heating capacity',
                                      {'name': u'Speed 3 Gross Rated Heating Capacity',
                                       'pyname': u'speed_3_gross_rated_heating_capacity',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'speed 3 gross rated heating cop',
                                      {'name': u'Speed 3 Gross Rated Heating COP',
                                       'pyname': u'speed_3_gross_rated_heating_cop',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'speed 3 rated air flow rate',
                                      {'name': u'Speed 3 Rated Air Flow Rate',
                                       'pyname': u'speed_3_rated_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 3 rated supply air fan power per volume flow rate',
                                      {'name': u'Speed 3 Rated Supply Air Fan Power Per Volume Flow Rate',
                                       'pyname': u'speed_3_rated_supply_air_fan_power_per_volume_flow_rate',
                                       'default': 773.3,
                                       'maximum': 1250.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/(m3/s)'}),
                                     (u'speed 3 heating capacity function of temperature curve name',
                                      {'name': u'Speed 3 Heating Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_3_heating_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 heating capacity function of flow fraction curve name',
                                      {'name': u'Speed 3 Heating Capacity Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_3_heating_capacity_function_of_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 3 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_3_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 energy input ratio function of flow fraction curve name',
                                      {'name': u'Speed 3 Energy Input Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_3_energy_input_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 part load fraction correlation curve name',
                                      {'name': u'Speed 3 Part Load Fraction Correlation Curve Name',
                                       'pyname': u'speed_3_part_load_fraction_correlation_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 rated waste heat fraction of power input',
                                      {'name': u'Speed 3 Rated Waste Heat Fraction of Power Input',
                                       'pyname': u'speed_3_rated_waste_heat_fraction_of_power_input',
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 3 waste heat function of temperature curve name',
                                      {'name': u'Speed 3 Waste Heat Function of Temperature Curve Name',
                                       'pyname': u'speed_3_waste_heat_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 gross rated heating capacity',
                                      {'name': u'Speed 4 Gross Rated Heating Capacity',
                                       'pyname': u'speed_4_gross_rated_heating_capacity',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'speed 4 gross rated heating cop',
                                      {'name': u'Speed 4 Gross Rated Heating COP',
                                       'pyname': u'speed_4_gross_rated_heating_cop',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'speed 4 rated air flow rate',
                                      {'name': u'Speed 4 Rated Air Flow Rate',
                                       'pyname': u'speed_4_rated_air_flow_rate',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 4 rated supply air fan power per volume flow rate',
                                      {'name': u'Speed 4 Rated Supply Air Fan Power Per Volume Flow Rate',
                                       'pyname': u'speed_4_rated_supply_air_fan_power_per_volume_flow_rate',
                                       'default': 773.3,
                                       'maximum': 1250.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/(m3/s)'}),
                                     (u'speed 4 heating capacity function of temperature curve name',
                                      {'name': u'Speed 4 Heating Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_4_heating_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 heating capacity function of flow fraction curve name',
                                      {'name': u'Speed 4 Heating Capacity Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_4_heating_capacity_function_of_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 4 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_4_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 energy input ratio function of flow fraction curve name',
                                      {'name': u'Speed 4 Energy Input Ratio Function of Flow Fraction Curve Name',
                                       'pyname': u'speed_4_energy_input_ratio_function_of_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 part load fraction correlation curve name',
                                      {'name': u'Speed 4 Part Load Fraction Correlation Curve Name',
                                       'pyname': u'speed_4_part_load_fraction_correlation_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 rated waste heat fraction of power input',
                                      {'name': u'Speed 4 Rated Waste Heat Fraction of Power Input',
                                       'pyname': u'speed_4_rated_waste_heat_fraction_of_power_input',
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 4 waste heat function of temperature curve name',
                                      {'name': u'Speed 4 Waste Heat Function of Temperature Curve Name',
                                       'pyname': u'speed_4_waste_heat_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'})]),
              'format': None,
              'group': u'Coils',
              'min-fields': 40,
              'name': u'Coil:Heating:DX:MultiSpeed',
              'pyname': u'CoilHeatingDxMultiSpeed',
              'required-object': False,
              'unique-object': False}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def availability_schedule_name(self):
        """Get availability_schedule_name.

        Returns:
            str: the value of `availability_schedule_name` or None if not set

        """
        return self["Availability Schedule Name"]

    @availability_schedule_name.setter
    def availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Availability Schedule Name` Availability
        schedule name for this system. Schedule value > 0 means the system is
        available. If this field is blank, the system is always available.

        Args:
            value (str): value for IDD Field `Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Availability Schedule Name"] = value

    @property
    def air_inlet_node_name(self):
        """Get air_inlet_node_name.

        Returns:
            str: the value of `air_inlet_node_name` or None if not set

        """
        return self["Air Inlet Node Name"]

    @air_inlet_node_name.setter
    def air_inlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Inlet Node Name`

        Args:
            value (str): value for IDD Field `Air Inlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Inlet Node Name"] = value

    @property
    def air_outlet_node_name(self):
        """Get air_outlet_node_name.

        Returns:
            str: the value of `air_outlet_node_name` or None if not set

        """
        return self["Air Outlet Node Name"]

    @air_outlet_node_name.setter
    def air_outlet_node_name(self, value=None):
        """Corresponds to IDD field `Air Outlet Node Name`

        Args:
            value (str): value for IDD Field `Air Outlet Node Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Air Outlet Node Name"] = value

    @property
    def minimum_outdoor_drybulb_temperature_for_compressor_operation(self):
        """Get minimum_outdoor_drybulb_temperature_for_compressor_operation.

        Returns:
            float: the value of `minimum_outdoor_drybulb_temperature_for_compressor_operation` or None if not set

        """
        return self[
            "Minimum Outdoor Dry-Bulb Temperature for Compressor Operation"]

    @minimum_outdoor_drybulb_temperature_for_compressor_operation.setter
    def minimum_outdoor_drybulb_temperature_for_compressor_operation(
            self,
            value=-
            8.0):
        """  Corresponds to IDD field `Minimum Outdoor Dry-Bulb Temperature for Compressor Operation`

        Args:
            value (float): value for IDD Field `Minimum Outdoor Dry-Bulb Temperature for Compressor Operation`
                Units: C
                Default value: -8.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Minimum Outdoor Dry-Bulb Temperature for Compressor Operation"] = value

    @property
    def outdoor_drybulb_temperature_to_turn_on_compressor(self):
        """Get outdoor_drybulb_temperature_to_turn_on_compressor.

        Returns:
            float: the value of `outdoor_drybulb_temperature_to_turn_on_compressor` or None if not set

        """
        return self["Outdoor Dry-Bulb Temperature to Turn On Compressor"]

    @outdoor_drybulb_temperature_to_turn_on_compressor.setter
    def outdoor_drybulb_temperature_to_turn_on_compressor(self, value=None):
        """  Corresponds to IDD field `Outdoor Dry-Bulb Temperature to Turn On Compressor`
        The outdoor temperature when the compressor is automatically turned back on following an
        automatic shut off because of low outdoor dry-bulb temperature. This field is only used
        for the calculation of HSPF. If this field is not provided, then outdoor bin temperature
        used in the HSPF calculation is always considered to be greater than this temperature and
        'Minimum Outdoor Dry-Bulb Temperature for Compressor Operation' field described above.
        This assumption is based on AHRI standard 210/240 (2008) and can introduce significant error
        in the final value of HSPF.

        Args:
            value (float): value for IDD Field `Outdoor Dry-Bulb Temperature to Turn On Compressor`
                Units: C
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Dry-Bulb Temperature to Turn On Compressor"] = value

    @property
    def crankcase_heater_capacity(self):
        """Get crankcase_heater_capacity.

        Returns:
            float: the value of `crankcase_heater_capacity` or None if not set

        """
        return self["Crankcase Heater Capacity"]

    @crankcase_heater_capacity.setter
    def crankcase_heater_capacity(self, value=None):
        """Corresponds to IDD field `Crankcase Heater Capacity`

        Args:
            value (float): value for IDD Field `Crankcase Heater Capacity`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Crankcase Heater Capacity"] = value

    @property
    def maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation(
            self):
        """Get
        maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation.

        Returns:
            float: the value of `maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation` or None if not set

        """
        return self[
            "Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation"]

    @maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation.setter
    def maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation(
            self,
            value=10.0):
        """  Corresponds to IDD field `Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation`

        Args:
            value (float): value for IDD Field `Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation`
                Units: C
                Default value: 10.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation"] = value

    @property
    def defrost_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get defrost_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `defrost_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Defrost Energy Input Ratio Function of Temperature Curve Name"]

    @defrost_energy_input_ratio_function_of_temperature_curve_name.setter
    def defrost_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Defrost Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        biquadratic curve = a + b*wb + c*wb**2 + d*oat + e*oat**2 + f*wb*oat
        wb = wet-bulb temperature (C) of air entering the indoor coil
        oat = outdoor air dry-bulb temperature (C)
        only required if ReverseCycle defrost strategy is specified

        Args:
            value (str): value for IDD Field `Defrost Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Defrost Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def maximum_outdoor_drybulb_temperature_for_defrost_operation(self):
        """Get maximum_outdoor_drybulb_temperature_for_defrost_operation.

        Returns:
            float: the value of `maximum_outdoor_drybulb_temperature_for_defrost_operation` or None if not set

        """
        return self[
            "Maximum Outdoor Dry-Bulb Temperature for Defrost Operation"]

    @maximum_outdoor_drybulb_temperature_for_defrost_operation.setter
    def maximum_outdoor_drybulb_temperature_for_defrost_operation(
            self,
            value=5.0):
        """  Corresponds to IDD field `Maximum Outdoor Dry-Bulb Temperature for Defrost Operation`

        Args:
            value (float): value for IDD Field `Maximum Outdoor Dry-Bulb Temperature for Defrost Operation`
                Units: C
                Default value: 5.0
                value <= 7.22
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Maximum Outdoor Dry-Bulb Temperature for Defrost Operation"] = value

    @property
    def defrost_strategy(self):
        """Get defrost_strategy.

        Returns:
            str: the value of `defrost_strategy` or None if not set

        """
        return self["Defrost Strategy"]

    @defrost_strategy.setter
    def defrost_strategy(self, value="ReverseCycle"):
        """Corresponds to IDD field `Defrost Strategy`

        Args:
            value (str): value for IDD Field `Defrost Strategy`
                Default value: ReverseCycle
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Defrost Strategy"] = value

    @property
    def defrost_control(self):
        """Get defrost_control.

        Returns:
            str: the value of `defrost_control` or None if not set

        """
        return self["Defrost Control"]

    @defrost_control.setter
    def defrost_control(self, value="Timed"):
        """Corresponds to IDD field `Defrost Control`

        Args:
            value (str): value for IDD Field `Defrost Control`
                Default value: Timed
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Defrost Control"] = value

    @property
    def defrost_time_period_fraction(self):
        """Get defrost_time_period_fraction.

        Returns:
            float: the value of `defrost_time_period_fraction` or None if not set

        """
        return self["Defrost Time Period Fraction"]

    @defrost_time_period_fraction.setter
    def defrost_time_period_fraction(self, value=0.058333):
        """Corresponds to IDD field `Defrost Time Period Fraction` Fraction of
        time in defrost mode only applicable if timed defrost control is
        specified.

        Args:
            value (float): value for IDD Field `Defrost Time Period Fraction`
                Default value: 0.058333
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Defrost Time Period Fraction"] = value

    @property
    def resistive_defrost_heater_capacity(self):
        """Get resistive_defrost_heater_capacity.

        Returns:
            float: the value of `resistive_defrost_heater_capacity` or None if not set

        """
        return self["Resistive Defrost Heater Capacity"]

    @resistive_defrost_heater_capacity.setter
    def resistive_defrost_heater_capacity(self, value=None):
        """Corresponds to IDD field `Resistive Defrost Heater Capacity` only
        applicable if resistive defrost strategy is specified.

        Args:
            value (float or "Autosize"): value for IDD Field `Resistive Defrost Heater Capacity`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Resistive Defrost Heater Capacity"] = value

    @property
    def apply_part_load_fraction_to_speeds_greater_than_1(self):
        """Get apply_part_load_fraction_to_speeds_greater_than_1.

        Returns:
            str: the value of `apply_part_load_fraction_to_speeds_greater_than_1` or None if not set

        """
        return self["Apply Part Load Fraction to Speeds Greater than 1"]

    @apply_part_load_fraction_to_speeds_greater_than_1.setter
    def apply_part_load_fraction_to_speeds_greater_than_1(self, value="No"):
        """Corresponds to IDD field `Apply Part Load Fraction to Speeds Greater
        than 1`

        Args:
            value (str): value for IDD Field `Apply Part Load Fraction to Speeds Greater than 1`
                Default value: No
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Apply Part Load Fraction to Speeds Greater than 1"] = value

    @property
    def fuel_type(self):
        """Get fuel_type.

        Returns:
            str: the value of `fuel_type` or None if not set

        """
        return self["Fuel Type"]

    @fuel_type.setter
    def fuel_type(self, value="NaturalGas"):
        """Corresponds to IDD field `Fuel Type`

        Args:
            value (str): value for IDD Field `Fuel Type`
                Default value: NaturalGas
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Fuel Type"] = value

    @property
    def region_number_for_calculating_hspf(self):
        """Get region_number_for_calculating_hspf.

        Returns:
            int: the value of `region_number_for_calculating_hspf` or None if not set

        """
        return self["Region number for Calculating HSPF"]

    @region_number_for_calculating_hspf.setter
    def region_number_for_calculating_hspf(self, value=4):
        """Corresponds to IDD field `Region number for Calculating HSPF`
        Standard Region number for which HSPF and other standard ratings are
        calculated.

        Args:
            value (int): value for IDD Field `Region number for Calculating HSPF`
                Default value: 4
                value >= 1
                value <= 6
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Region number for Calculating HSPF"] = value

    @property
    def number_of_speeds(self):
        """Get number_of_speeds.

        Returns:
            int: the value of `number_of_speeds` or None if not set

        """
        return self["Number of Speeds"]

    @number_of_speeds.setter
    def number_of_speeds(self, value=None):
        """Corresponds to IDD field `Number of Speeds` Enter the number of the
        following sets of data for coil capacity, COP, flow rate, and
        associated curves.

        Args:
            value (int): value for IDD Field `Number of Speeds`
                value >= 2
                value <= 4
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Number of Speeds"] = value

    @property
    def speed_1_gross_rated_heating_capacity(self):
        """Get speed_1_gross_rated_heating_capacity.

        Returns:
            float: the value of `speed_1_gross_rated_heating_capacity` or None if not set

        """
        return self["Speed 1 Gross Rated Heating Capacity"]

    @speed_1_gross_rated_heating_capacity.setter
    def speed_1_gross_rated_heating_capacity(self, value=None):
        """  Corresponds to IDD field `Speed 1 Gross Rated Heating Capacity`
        Heating capacity not accounting for the effect of supply air fan heat
        capacity excluding supply air fan heat
        rating point outdoor dry-bulb temp 8.33 C, outdoor wet-bulb temp 6.11 C
        rating point heating coil entering air dry-bulb 21.11 C, coil entering
        wet-bulb 15.55 C

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 1 Gross Rated Heating Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 1 Gross Rated Heating Capacity"] = value

    @property
    def speed_1_gross_rated_heating_cop(self):
        """Get speed_1_gross_rated_heating_cop.

        Returns:
            float: the value of `speed_1_gross_rated_heating_cop` or None if not set

        """
        return self["Speed 1 Gross Rated Heating COP"]

    @speed_1_gross_rated_heating_cop.setter
    def speed_1_gross_rated_heating_cop(self, value=None):
        """Corresponds to IDD field `Speed 1 Gross Rated Heating COP` Rated
        heating capacity divided by power input to the compressor and outdoor
        fan, does not include supply air fan heat or supply air fan electrical
        energy.

        Args:
            value (float): value for IDD Field `Speed 1 Gross Rated Heating COP`
                Units: W/W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 1 Gross Rated Heating COP"] = value

    @property
    def speed_1_rated_air_flow_rate(self):
        """Get speed_1_rated_air_flow_rate.

        Returns:
            float: the value of `speed_1_rated_air_flow_rate` or None if not set

        """
        return self["Speed 1 Rated Air Flow Rate"]

    @speed_1_rated_air_flow_rate.setter
    def speed_1_rated_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Speed 1 Rated Air Flow Rate`
        Flow rate corresponding to rated total capacity
        should be between 0.00004027 m3/s and .00006041 m3/s per watt of rated total
        heating capacity

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 1 Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 1 Rated Air Flow Rate"] = value

    @property
    def speed_1_rated_supply_air_fan_power_per_volume_flow_rate(self):
        """Get speed_1_rated_supply_air_fan_power_per_volume_flow_rate.

        Returns:
            float: the value of `speed_1_rated_supply_air_fan_power_per_volume_flow_rate` or None if not set

        """
        return self["Speed 1 Rated Supply Air Fan Power Per Volume Flow Rate"]

    @speed_1_rated_supply_air_fan_power_per_volume_flow_rate.setter
    def speed_1_rated_supply_air_fan_power_per_volume_flow_rate(
            self,
            value=773.3):
        """Corresponds to IDD field `Speed 1 Rated Supply Air Fan Power Per
        Volume Flow Rate` Enter the supply air fan power per air volume flow
        rate at the rated speed 1 test conditions. The test conditions vary
        external static pressure based on heating capacity. This value is only
        used to calculate Heating Seasonal Performance Factor(HSPF). This value
        is not used for modeling the supply air fan during simulations.

        Args:
            value (float): value for IDD Field `Speed 1 Rated Supply Air Fan Power Per Volume Flow Rate`
                Units: W/(m3/s)
                Default value: 773.3
                value <= 1250.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 1 Rated Supply Air Fan Power Per Volume Flow Rate"] = value

    @property
    def speed_1_heating_capacity_function_of_temperature_curve_name(self):
        """Get speed_1_heating_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_1_heating_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 1 Heating Capacity Function of Temperature Curve Name"]

    @speed_1_heating_capacity_function_of_temperature_curve_name.setter
    def speed_1_heating_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Heating Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        quadratic curve = a + b*oat + c*oat**2
        cubic curve = a + b*oat + c*oat**2 + d*oat**3
        biquadratic curve = a + b*iat + c*iat**2 + d*oat + e*oat**2 + f*iat*oat
        oat = outdoor air dry-bulb temperature (C)
        iat = indoor air dry-bulb temperature (C)
        biquadratic curve is recommended if sufficient manufacturer data is
        available for the heating capacity to be sensitive to both iat and oat.

        Args:
            value (str): value for IDD Field `Speed 1 Heating Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 1 Heating Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_1_heating_capacity_function_of_flow_fraction_curve_name(self):
        """Get speed_1_heating_capacity_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_1_heating_capacity_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 1 Heating Capacity Function of Flow Fraction Curve Name"]

    @speed_1_heating_capacity_function_of_flow_fraction_curve_name.setter
    def speed_1_heating_capacity_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Heating Capacity Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Speed 1 Heating Capacity Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 1 Heating Capacity Function of Flow Fraction Curve Name"] = value

    @property
    def speed_1_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_1_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_1_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 1 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_1_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_1_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        quadratic curve = a + b*oat + c*oat**2
        cubic curve = a + b*oat + c*oat**2 + d*oat**3
        biquadratic curve = a + b*iat + c*iat**2 + d*oat + e*oat**2 + f*iat*oat
        oat = outdoor air dry-bulb temperature (C)
        iat = indoor air dry-bulb temperature (C)
        biquadratic curve is recommended if sufficient manufacturer data is
        available for the energy input ratio to be sensitive to both iat and oat.

        Args:
            value (str): value for IDD Field `Speed 1 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 1 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_1_energy_input_ratio_function_of_flow_fraction_curve_name(self):
        """Get speed_1_energy_input_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_1_energy_input_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 1 Energy Input Ratio Function of Flow Fraction Curve Name"]

    @speed_1_energy_input_ratio_function_of_flow_fraction_curve_name.setter
    def speed_1_energy_input_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Energy Input Ratio Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Speed 1 Energy Input Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 1 Energy Input Ratio Function of Flow Fraction Curve Name"] = value

    @property
    def speed_1_part_load_fraction_correlation_curve_name(self):
        """Get speed_1_part_load_fraction_correlation_curve_name.

        Returns:
            str: the value of `speed_1_part_load_fraction_correlation_curve_name` or None if not set

        """
        return self["Speed 1 Part Load Fraction Correlation Curve Name"]

    @speed_1_part_load_fraction_correlation_curve_name.setter
    def speed_1_part_load_fraction_correlation_curve_name(self, value=None):
        """  Corresponds to IDD field `Speed 1 Part Load Fraction Correlation Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*PLR + c*PLR**2
        cubic curve = a + b*PLR + c*PLR**2 + d*PLR**3
        PLR = part load ratio (sensible heating load/steady state heating capacity)

        Args:
            value (str): value for IDD Field `Speed 1 Part Load Fraction Correlation Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 1 Part Load Fraction Correlation Curve Name"] = value

    @property
    def speed_1_rated_waste_heat_fraction_of_power_input(self):
        """Get speed_1_rated_waste_heat_fraction_of_power_input.

        Returns:
            float: the value of `speed_1_rated_waste_heat_fraction_of_power_input` or None if not set

        """
        return self["Speed 1 Rated Waste Heat Fraction of Power Input"]

    @speed_1_rated_waste_heat_fraction_of_power_input.setter
    def speed_1_rated_waste_heat_fraction_of_power_input(self, value=None):
        """Corresponds to IDD field `Speed 1 Rated Waste Heat Fraction of Power
        Input` recoverable waste heat at full load and rated conditions.

        Args:
            value (float): value for IDD Field `Speed 1 Rated Waste Heat Fraction of Power Input`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 1 Rated Waste Heat Fraction of Power Input"] = value

    @property
    def speed_1_waste_heat_function_of_temperature_curve_name(self):
        """Get speed_1_waste_heat_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_1_waste_heat_function_of_temperature_curve_name` or None if not set

        """
        return self["Speed 1 Waste Heat Function of Temperature Curve Name"]

    @speed_1_waste_heat_function_of_temperature_curve_name.setter
    def speed_1_waste_heat_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 1 Waste Heat Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*odb + c*odb**2 + d*db + e*db**2 + f*odb*db
        odb = Outdoor air dry-bulb temperature (C)
        db = entering coil dry-bulb temperature (C)

        Args:
            value (str): value for IDD Field `Speed 1 Waste Heat Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 1 Waste Heat Function of Temperature Curve Name"] = value

    @property
    def speed_2_gross_rated_heating_capacity(self):
        """Get speed_2_gross_rated_heating_capacity.

        Returns:
            float: the value of `speed_2_gross_rated_heating_capacity` or None if not set

        """
        return self["Speed 2 Gross Rated Heating Capacity"]

    @speed_2_gross_rated_heating_capacity.setter
    def speed_2_gross_rated_heating_capacity(self, value=None):
        """  Corresponds to IDD field `Speed 2 Gross Rated Heating Capacity`
        Heating capacity not accounting for the effect of supply air fan heat
        capacity excluding supply air fan heat
        rating point outdoor dry-bulb temp 8.33 C, outdoor wet-bulb temp 6.11 C
        rating point heating coil entering air dry-bulb 21.11 C, coil entering
        wet-bulb 15.55 C

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 2 Gross Rated Heating Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 2 Gross Rated Heating Capacity"] = value

    @property
    def speed_2_gross_rated_heating_cop(self):
        """Get speed_2_gross_rated_heating_cop.

        Returns:
            float: the value of `speed_2_gross_rated_heating_cop` or None if not set

        """
        return self["Speed 2 Gross Rated Heating COP"]

    @speed_2_gross_rated_heating_cop.setter
    def speed_2_gross_rated_heating_cop(self, value=None):
        """Corresponds to IDD field `Speed 2 Gross Rated Heating COP` Rated
        heating capacity divided by power input to the compressor and outdoor
        fan, does not include supply air fan heat or supply air fan electrical
        energy.

        Args:
            value (float): value for IDD Field `Speed 2 Gross Rated Heating COP`
                Units: W/W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 2 Gross Rated Heating COP"] = value

    @property
    def speed_2_rated_air_flow_rate(self):
        """Get speed_2_rated_air_flow_rate.

        Returns:
            float: the value of `speed_2_rated_air_flow_rate` or None if not set

        """
        return self["Speed 2 Rated Air Flow Rate"]

    @speed_2_rated_air_flow_rate.setter
    def speed_2_rated_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Speed 2 Rated Air Flow Rate`
        Flow rate corresponding to rated total capacity
        should be between 0.00004027 m3/s and .00006041 m3/s per watt of rated total
        heating capacity

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 2 Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 2 Rated Air Flow Rate"] = value

    @property
    def speed_2_rated_supply_air_fan_power_per_volume_flow_rate(self):
        """Get speed_2_rated_supply_air_fan_power_per_volume_flow_rate.

        Returns:
            float: the value of `speed_2_rated_supply_air_fan_power_per_volume_flow_rate` or None if not set

        """
        return self["Speed 2 Rated Supply Air Fan Power Per Volume Flow Rate"]

    @speed_2_rated_supply_air_fan_power_per_volume_flow_rate.setter
    def speed_2_rated_supply_air_fan_power_per_volume_flow_rate(
            self,
            value=773.3):
        """Corresponds to IDD field `Speed 2 Rated Supply Air Fan Power Per
        Volume Flow Rate` Enter the supply air fan power per air volume flow
        rate at the rated speed 2 test conditions. The test conditions vary
        external static pressure based on heating capacity. This value is only
        used to calculate Heating Seasonal Performance Factor(HSPF). This value
        is not used for modeling the supply air fan during simulations.

        Args:
            value (float): value for IDD Field `Speed 2 Rated Supply Air Fan Power Per Volume Flow Rate`
                Units: W/(m3/s)
                Default value: 773.3
                value <= 1250.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 2 Rated Supply Air Fan Power Per Volume Flow Rate"] = value

    @property
    def speed_2_heating_capacity_function_of_temperature_curve_name(self):
        """Get speed_2_heating_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_2_heating_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 2 Heating Capacity Function of Temperature Curve Name"]

    @speed_2_heating_capacity_function_of_temperature_curve_name.setter
    def speed_2_heating_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 2 Heating Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        quadratic curve = a + b*oat + c*oat**2
        cubic curve = a + b*oat + c*oat**2 + d*oat**3
        biquadratic curve = a + b*iat + c*iat**2 + d*oat + e*oat**2 + f*iat*oat
        oat = outdoor air dry-bulb temperature (C)
        iat = indoor air dry-bulb temperature (C)
        biquadratic curve is recommended if sufficient manufacturer data is
        available for the heating capacity to be sensitive to both iat and oat.

        Args:
            value (str): value for IDD Field `Speed 2 Heating Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 2 Heating Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_2_heating_capacity_function_of_flow_fraction_curve_name(self):
        """Get speed_2_heating_capacity_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_2_heating_capacity_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 2 Heating Capacity Function of Flow Fraction Curve Name"]

    @speed_2_heating_capacity_function_of_flow_fraction_curve_name.setter
    def speed_2_heating_capacity_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 2 Heating Capacity Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Speed 2 Heating Capacity Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 2 Heating Capacity Function of Flow Fraction Curve Name"] = value

    @property
    def speed_2_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_2_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_2_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 2 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_2_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_2_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 2 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        quadratic curve = a + b*oat + c*oat**2
        cubic curve = a + b*oat + c*oat**2 + d*oat**3
        biquadratic curve = a + b*iat + c*iat**2 + d*oat + e*oat**2 + f*iat*oat
        oat = outdoor air dry-bulb temperature (C)
        iat = indoor air dry-bulb temperature (C)
        biquadratic curve is recommended if sufficient manufacturer data is
        available for the energy input ratio to be sensitive to both iat and oat.

        Args:
            value (str): value for IDD Field `Speed 2 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 2 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_2_energy_input_ratio_function_of_flow_fraction_curve_name(self):
        """Get speed_2_energy_input_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_2_energy_input_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 2 Energy Input Ratio Function of Flow Fraction Curve Name"]

    @speed_2_energy_input_ratio_function_of_flow_fraction_curve_name.setter
    def speed_2_energy_input_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 2 Energy Input Ratio Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Speed 2 Energy Input Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 2 Energy Input Ratio Function of Flow Fraction Curve Name"] = value

    @property
    def speed_2_part_load_fraction_correlation_curve_name(self):
        """Get speed_2_part_load_fraction_correlation_curve_name.

        Returns:
            str: the value of `speed_2_part_load_fraction_correlation_curve_name` or None if not set

        """
        return self["Speed 2 Part Load Fraction Correlation Curve Name"]

    @speed_2_part_load_fraction_correlation_curve_name.setter
    def speed_2_part_load_fraction_correlation_curve_name(self, value=None):
        """  Corresponds to IDD field `Speed 2 Part Load Fraction Correlation Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*PLR + c*PLR**2
        cubic curve = a + b*PLR + c*PLR**2 + d*PLR**3
        PLR = part load ratio (sensible heating load/steady state heating capacity)

        Args:
            value (str): value for IDD Field `Speed 2 Part Load Fraction Correlation Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 2 Part Load Fraction Correlation Curve Name"] = value

    @property
    def speed_2_rated_waste_heat_fraction_of_power_input(self):
        """Get speed_2_rated_waste_heat_fraction_of_power_input.

        Returns:
            float: the value of `speed_2_rated_waste_heat_fraction_of_power_input` or None if not set

        """
        return self["Speed 2 Rated Waste Heat Fraction of Power Input"]

    @speed_2_rated_waste_heat_fraction_of_power_input.setter
    def speed_2_rated_waste_heat_fraction_of_power_input(self, value=None):
        """Corresponds to IDD field `Speed 2 Rated Waste Heat Fraction of Power
        Input` recoverable waste heat at full load and rated conditions.

        Args:
            value (float): value for IDD Field `Speed 2 Rated Waste Heat Fraction of Power Input`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 2 Rated Waste Heat Fraction of Power Input"] = value

    @property
    def speed_2_waste_heat_function_of_temperature_curve_name(self):
        """Get speed_2_waste_heat_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_2_waste_heat_function_of_temperature_curve_name` or None if not set

        """
        return self["Speed 2 Waste Heat Function of Temperature Curve Name"]

    @speed_2_waste_heat_function_of_temperature_curve_name.setter
    def speed_2_waste_heat_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 2 Waste Heat Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*odb + c*odb**2 + d*db + e*db**2 + f*odb*db
        odb = Outdoor air dry-bulb temperature (C)
        db = entering coil dry-bulb temperature (C)

        Args:
            value (str): value for IDD Field `Speed 2 Waste Heat Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 2 Waste Heat Function of Temperature Curve Name"] = value

    @property
    def speed_3_gross_rated_heating_capacity(self):
        """Get speed_3_gross_rated_heating_capacity.

        Returns:
            float: the value of `speed_3_gross_rated_heating_capacity` or None if not set

        """
        return self["Speed 3 Gross Rated Heating Capacity"]

    @speed_3_gross_rated_heating_capacity.setter
    def speed_3_gross_rated_heating_capacity(self, value=None):
        """  Corresponds to IDD field `Speed 3 Gross Rated Heating Capacity`
        Heating capacity not accounting for the effect of supply air fan heat
        capacity excluding supply air fan heat
        rating point outdoor dry-bulb temp 8.33 C, outdoor wet-bulb temp 6.11 C
        rating point heating coil entering air dry-bulb 21.11 C, coil entering
        wet-bulb 15.55 C

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 3 Gross Rated Heating Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 3 Gross Rated Heating Capacity"] = value

    @property
    def speed_3_gross_rated_heating_cop(self):
        """Get speed_3_gross_rated_heating_cop.

        Returns:
            float: the value of `speed_3_gross_rated_heating_cop` or None if not set

        """
        return self["Speed 3 Gross Rated Heating COP"]

    @speed_3_gross_rated_heating_cop.setter
    def speed_3_gross_rated_heating_cop(self, value=None):
        """Corresponds to IDD field `Speed 3 Gross Rated Heating COP` Rated
        heating capacity divided by power input to the compressor and outdoor
        fan, does not include supply air fan heat or supply air fan electrical
        energy.

        Args:
            value (float): value for IDD Field `Speed 3 Gross Rated Heating COP`
                Units: W/W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 3 Gross Rated Heating COP"] = value

    @property
    def speed_3_rated_air_flow_rate(self):
        """Get speed_3_rated_air_flow_rate.

        Returns:
            float: the value of `speed_3_rated_air_flow_rate` or None if not set

        """
        return self["Speed 3 Rated Air Flow Rate"]

    @speed_3_rated_air_flow_rate.setter
    def speed_3_rated_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Speed 3 Rated Air Flow Rate`
        Flow rate corresponding to rated total capacity
        should be between 0.00004027 m3/s and .00006041 m3/s per watt of rated total
        heating capacity

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 3 Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 3 Rated Air Flow Rate"] = value

    @property
    def speed_3_rated_supply_air_fan_power_per_volume_flow_rate(self):
        """Get speed_3_rated_supply_air_fan_power_per_volume_flow_rate.

        Returns:
            float: the value of `speed_3_rated_supply_air_fan_power_per_volume_flow_rate` or None if not set

        """
        return self["Speed 3 Rated Supply Air Fan Power Per Volume Flow Rate"]

    @speed_3_rated_supply_air_fan_power_per_volume_flow_rate.setter
    def speed_3_rated_supply_air_fan_power_per_volume_flow_rate(
            self,
            value=773.3):
        """Corresponds to IDD field `Speed 3 Rated Supply Air Fan Power Per
        Volume Flow Rate` Enter the supply air fan power per air volume flow
        rate at the rated speed 3 test conditions. The test conditions vary
        external static pressure based on heating capacity. This value is only
        used to calculate Heating Seasonal Performance Factor(HSPF). This value
        is not used for modeling the supply air fan during simulations.

        Args:
            value (float): value for IDD Field `Speed 3 Rated Supply Air Fan Power Per Volume Flow Rate`
                Units: W/(m3/s)
                Default value: 773.3
                value <= 1250.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 3 Rated Supply Air Fan Power Per Volume Flow Rate"] = value

    @property
    def speed_3_heating_capacity_function_of_temperature_curve_name(self):
        """Get speed_3_heating_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_3_heating_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 3 Heating Capacity Function of Temperature Curve Name"]

    @speed_3_heating_capacity_function_of_temperature_curve_name.setter
    def speed_3_heating_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 3 Heating Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        quadratic curve = a + b*oat + c*oat**2
        cubic curve = a + b*oat + c*oat**2 + d*oat**3
        biquadratic curve = a + b*iat + c*iat**2 + d*oat + e*oat**2 + f*iat*oat
        oat = outdoor air dry-bulb temperature (C)
        iat = indoor air dry-bulb temperature (C)
        biquadratic curve is recommended if sufficient manufacturer data is
        available for the heating capacity to be sensitive to both iat and oat.

        Args:
            value (str): value for IDD Field `Speed 3 Heating Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 3 Heating Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_3_heating_capacity_function_of_flow_fraction_curve_name(self):
        """Get speed_3_heating_capacity_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_3_heating_capacity_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 3 Heating Capacity Function of Flow Fraction Curve Name"]

    @speed_3_heating_capacity_function_of_flow_fraction_curve_name.setter
    def speed_3_heating_capacity_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 3 Heating Capacity Function of Flow Fraction Curve Name`
        Table:TwoIndependentVariables object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Speed 3 Heating Capacity Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 3 Heating Capacity Function of Flow Fraction Curve Name"] = value

    @property
    def speed_3_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_3_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_3_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 3 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_3_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_3_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 3 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        quadratic curve = a + b*oat + c*oat**2
        cubic curve = a + b*oat + c*oat**2 + d*oat**3
        biquadratic curve = a + b*iat + c*iat**2 + d*oat + e*oat**2 + f*iat*oat
        oat = outdoor air dry-bulb temperature (C)
        iat = indoor air dry-bulb temperature (C)
        biquadratic curve is recommended if sufficient manufacturer data is
        available for the energy input ratio to be sensitive to both iat and oat.

        Args:
            value (str): value for IDD Field `Speed 3 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 3 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_3_energy_input_ratio_function_of_flow_fraction_curve_name(self):
        """Get speed_3_energy_input_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_3_energy_input_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 3 Energy Input Ratio Function of Flow Fraction Curve Name"]

    @speed_3_energy_input_ratio_function_of_flow_fraction_curve_name.setter
    def speed_3_energy_input_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 3 Energy Input Ratio Function of Flow Fraction Curve Name`
        Table:TwoIndependentVariables object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Speed 3 Energy Input Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 3 Energy Input Ratio Function of Flow Fraction Curve Name"] = value

    @property
    def speed_3_part_load_fraction_correlation_curve_name(self):
        """Get speed_3_part_load_fraction_correlation_curve_name.

        Returns:
            str: the value of `speed_3_part_load_fraction_correlation_curve_name` or None if not set

        """
        return self["Speed 3 Part Load Fraction Correlation Curve Name"]

    @speed_3_part_load_fraction_correlation_curve_name.setter
    def speed_3_part_load_fraction_correlation_curve_name(self, value=None):
        """  Corresponds to IDD field `Speed 3 Part Load Fraction Correlation Curve Name`
        Table:TwoIndependentVariables object can also be used
        quadratic curve = a + b*PLR + c*PLR**2
        cubic curve = a + b*PLR + c*PLR**2 + d*PLR**3
        PLR = part load ratio (sensible heating load/steady state heating capacity)

        Args:
            value (str): value for IDD Field `Speed 3 Part Load Fraction Correlation Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 3 Part Load Fraction Correlation Curve Name"] = value

    @property
    def speed_3_rated_waste_heat_fraction_of_power_input(self):
        """Get speed_3_rated_waste_heat_fraction_of_power_input.

        Returns:
            float: the value of `speed_3_rated_waste_heat_fraction_of_power_input` or None if not set

        """
        return self["Speed 3 Rated Waste Heat Fraction of Power Input"]

    @speed_3_rated_waste_heat_fraction_of_power_input.setter
    def speed_3_rated_waste_heat_fraction_of_power_input(self, value=None):
        """Corresponds to IDD field `Speed 3 Rated Waste Heat Fraction of Power
        Input` recoverable waste heat at full load and rated conditions.

        Args:
            value (float): value for IDD Field `Speed 3 Rated Waste Heat Fraction of Power Input`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 3 Rated Waste Heat Fraction of Power Input"] = value

    @property
    def speed_3_waste_heat_function_of_temperature_curve_name(self):
        """Get speed_3_waste_heat_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_3_waste_heat_function_of_temperature_curve_name` or None if not set

        """
        return self["Speed 3 Waste Heat Function of Temperature Curve Name"]

    @speed_3_waste_heat_function_of_temperature_curve_name.setter
    def speed_3_waste_heat_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 3 Waste Heat Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*odb + c*odb**2 + d*db + e*db**2 + f*odb*db
        odb = Outdoor air dry-bulb temperature (C)
        db = entering coil dry-bulb temperature (C)

        Args:
            value (str): value for IDD Field `Speed 3 Waste Heat Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 3 Waste Heat Function of Temperature Curve Name"] = value

    @property
    def speed_4_gross_rated_heating_capacity(self):
        """Get speed_4_gross_rated_heating_capacity.

        Returns:
            float: the value of `speed_4_gross_rated_heating_capacity` or None if not set

        """
        return self["Speed 4 Gross Rated Heating Capacity"]

    @speed_4_gross_rated_heating_capacity.setter
    def speed_4_gross_rated_heating_capacity(self, value=None):
        """  Corresponds to IDD field `Speed 4 Gross Rated Heating Capacity`
        Heating capacity not accounting for the effect of supply air fan heat
        capacity excluding supply air fan heat
        rating point outdoor dry-bulb temp 8.33 C, outdoor wet-bulb temp 6.11 C
        rating point heating coil entering air dry-bulb 21.11 C, coil entering
        wet-bulb 15.55 C

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 4 Gross Rated Heating Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 4 Gross Rated Heating Capacity"] = value

    @property
    def speed_4_gross_rated_heating_cop(self):
        """Get speed_4_gross_rated_heating_cop.

        Returns:
            float: the value of `speed_4_gross_rated_heating_cop` or None if not set

        """
        return self["Speed 4 Gross Rated Heating COP"]

    @speed_4_gross_rated_heating_cop.setter
    def speed_4_gross_rated_heating_cop(self, value=None):
        """Corresponds to IDD field `Speed 4 Gross Rated Heating COP` Rated
        heating capacity divided by power input to the compressor and outdoor
        fan, does not include supply air fan heat or supply air fan electrical
        energy.

        Args:
            value (float): value for IDD Field `Speed 4 Gross Rated Heating COP`
                Units: W/W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 4 Gross Rated Heating COP"] = value

    @property
    def speed_4_rated_air_flow_rate(self):
        """Get speed_4_rated_air_flow_rate.

        Returns:
            float: the value of `speed_4_rated_air_flow_rate` or None if not set

        """
        return self["Speed 4 Rated Air Flow Rate"]

    @speed_4_rated_air_flow_rate.setter
    def speed_4_rated_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Speed 4 Rated Air Flow Rate`
        Flow rate corresponding to rated total capacity
        should be between 0.00004027 m3/s and .00006041 m3/s per watt of rated total
        heating capacity

        Args:
            value (float or "Autosize"): value for IDD Field `Speed 4 Rated Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 4 Rated Air Flow Rate"] = value

    @property
    def speed_4_rated_supply_air_fan_power_per_volume_flow_rate(self):
        """Get speed_4_rated_supply_air_fan_power_per_volume_flow_rate.

        Returns:
            float: the value of `speed_4_rated_supply_air_fan_power_per_volume_flow_rate` or None if not set

        """
        return self["Speed 4 Rated Supply Air Fan Power Per Volume Flow Rate"]

    @speed_4_rated_supply_air_fan_power_per_volume_flow_rate.setter
    def speed_4_rated_supply_air_fan_power_per_volume_flow_rate(
            self,
            value=773.3):
        """Corresponds to IDD field `Speed 4 Rated Supply Air Fan Power Per
        Volume Flow Rate` Enter the supply air fan power per air volume flow
        rate at the rated speed 4 test conditions. The test conditions vary
        external static pressure based on heating capacity. This value is only
        used to calculate Heating Seasonal Performance Factor(HSPF). This value
        is not used for modeling the supply air fan during simulations.

        Args:
            value (float): value for IDD Field `Speed 4 Rated Supply Air Fan Power Per Volume Flow Rate`
                Units: W/(m3/s)
                Default value: 773.3
                value <= 1250.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 4 Rated Supply Air Fan Power Per Volume Flow Rate"] = value

    @property
    def speed_4_heating_capacity_function_of_temperature_curve_name(self):
        """Get speed_4_heating_capacity_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_4_heating_capacity_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 4 Heating Capacity Function of Temperature Curve Name"]

    @speed_4_heating_capacity_function_of_temperature_curve_name.setter
    def speed_4_heating_capacity_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 4 Heating Capacity Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        quadratic curve = a + b*oat + c*oat**2
        cubic curve = a + b*oat + c*oat**2 + d*oat**3
        biquadratic curve = a + b*iat + c*iat**2 + d*oat + e*oat**2 + f*iat*oat
        oat = outdoor air dry-bulb temperature (C)
        iat = indoor air dry-bulb temperature (C)
        biquadratic curve is recommended if sufficient manufacturer data is
        available for the heating capacity to be sensitive to both iat and oat.

        Args:
            value (str): value for IDD Field `Speed 4 Heating Capacity Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 4 Heating Capacity Function of Temperature Curve Name"] = value

    @property
    def speed_4_heating_capacity_function_of_flow_fraction_curve_name(self):
        """Get speed_4_heating_capacity_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_4_heating_capacity_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 4 Heating Capacity Function of Flow Fraction Curve Name"]

    @speed_4_heating_capacity_function_of_flow_fraction_curve_name.setter
    def speed_4_heating_capacity_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 4 Heating Capacity Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Speed 4 Heating Capacity Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 4 Heating Capacity Function of Flow Fraction Curve Name"] = value

    @property
    def speed_4_energy_input_ratio_function_of_temperature_curve_name(self):
        """Get speed_4_energy_input_ratio_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_4_energy_input_ratio_function_of_temperature_curve_name` or None if not set

        """
        return self[
            "Speed 4 Energy Input Ratio Function of Temperature Curve Name"]

    @speed_4_energy_input_ratio_function_of_temperature_curve_name.setter
    def speed_4_energy_input_ratio_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 4 Energy Input Ratio Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        quadratic curve = a + b*oat + c*oat**2
        cubic curve = a + b*oat + c*oat**2 + d*oat**3
        biquadratic curve = a + b*iat + c*iat**2 + d*oat + e*oat**2 + f*iat*oat
        oat = outdoor air dry-bulb temperature (C)
        iat = indoor air dry-bulb temperature (C)
        biquadratic curve is recommended if sufficient manufacturer data is
        available for the energy input ratio to be sensitive to both iat and oat.

        Args:
            value (str): value for IDD Field `Speed 4 Energy Input Ratio Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 4 Energy Input Ratio Function of Temperature Curve Name"] = value

    @property
    def speed_4_energy_input_ratio_function_of_flow_fraction_curve_name(self):
        """Get speed_4_energy_input_ratio_function_of_flow_fraction_curve_name.

        Returns:
            str: the value of `speed_4_energy_input_ratio_function_of_flow_fraction_curve_name` or None if not set

        """
        return self[
            "Speed 4 Energy Input Ratio Function of Flow Fraction Curve Name"]

    @speed_4_energy_input_ratio_function_of_flow_fraction_curve_name.setter
    def speed_4_energy_input_ratio_function_of_flow_fraction_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 4 Energy Input Ratio Function of Flow Fraction Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*ff + c*ff**2
        cubic curve = a + b*ff + c*ff**2 + d*ff**3
        ff = fraction of the full load flow

        Args:
            value (str): value for IDD Field `Speed 4 Energy Input Ratio Function of Flow Fraction Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Speed 4 Energy Input Ratio Function of Flow Fraction Curve Name"] = value

    @property
    def speed_4_part_load_fraction_correlation_curve_name(self):
        """Get speed_4_part_load_fraction_correlation_curve_name.

        Returns:
            str: the value of `speed_4_part_load_fraction_correlation_curve_name` or None if not set

        """
        return self["Speed 4 Part Load Fraction Correlation Curve Name"]

    @speed_4_part_load_fraction_correlation_curve_name.setter
    def speed_4_part_load_fraction_correlation_curve_name(self, value=None):
        """  Corresponds to IDD field `Speed 4 Part Load Fraction Correlation Curve Name`
        Table:OneIndependentVariable object can also be used
        quadratic curve = a + b*PLR + c*PLR**2
        cubic curve = a + b*PLR + c*PLR**2 + d*PLR**3
        PLR = part load ratio (sensible heating load/steady state heating capacity)

        Args:
            value (str): value for IDD Field `Speed 4 Part Load Fraction Correlation Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 4 Part Load Fraction Correlation Curve Name"] = value

    @property
    def speed_4_rated_waste_heat_fraction_of_power_input(self):
        """Get speed_4_rated_waste_heat_fraction_of_power_input.

        Returns:
            float: the value of `speed_4_rated_waste_heat_fraction_of_power_input` or None if not set

        """
        return self["Speed 4 Rated Waste Heat Fraction of Power Input"]

    @speed_4_rated_waste_heat_fraction_of_power_input.setter
    def speed_4_rated_waste_heat_fraction_of_power_input(self, value=None):
        """Corresponds to IDD field `Speed 4 Rated Waste Heat Fraction of Power
        Input` recoverable waste heat at full load and rated conditions.

        Args:
            value (float): value for IDD Field `Speed 4 Rated Waste Heat Fraction of Power Input`
                Units: dimensionless
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Speed 4 Rated Waste Heat Fraction of Power Input"] = value

    @property
    def speed_4_waste_heat_function_of_temperature_curve_name(self):
        """Get speed_4_waste_heat_function_of_temperature_curve_name.

        Returns:
            str: the value of `speed_4_waste_heat_function_of_temperature_curve_name` or None if not set

        """
        return self["Speed 4 Waste Heat Function of Temperature Curve Name"]

    @speed_4_waste_heat_function_of_temperature_curve_name.setter
    def speed_4_waste_heat_function_of_temperature_curve_name(
            self,
            value=None):
        """  Corresponds to IDD field `Speed 4 Waste Heat Function of Temperature Curve Name`
        Table:TwoIndependentVariables object can also be used
        curve = a + b*odb + c*odb**2 + d*db + e*db**2 + f*odb*db
        odb = Outdoor air dry-bulb temperature (C)
        db = entering coil dry-bulb temperature (C)

        Args:
            value (str): value for IDD Field `Speed 4 Waste Heat Function of Temperature Curve Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Speed 4 Waste Heat Function of Temperature Curve Name"] = value




class CoilHeatingDxVariableSpeed(DataObject):

    """ Corresponds to IDD object `Coil:Heating:DX:VariableSpeed`
        Direct expansion (DX) heating coil (air-to-air heat pump) and compressor unit
        (includes electric compressor and outdoor fan), variable-speed, with defrost
        controls. Requires two to ten sets of performance data and will interpolate between
        speeds.
    """
    schema = {'extensible-fields': OrderedDict(),
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'indoor air inlet node name',
                                      {'name': u'Indoor Air Inlet Node Name',
                                       'pyname': u'indoor_air_inlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'indoor air outlet node name',
                                      {'name': u'Indoor Air Outlet Node Name',
                                       'pyname': u'indoor_air_outlet_node_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'node'}),
                                     (u'number of speeds',
                                      {'name': u'Number of Speeds',
                                       'pyname': u'number_of_speeds',
                                       'default': 2,
                                       'maximum': 10,
                                       'required-field': True,
                                       'autosizable': False,
                                       'minimum': 1,
                                       'autocalculatable': False,
                                       'type': u'integer',
                                       'unit': u'dimensionless'}),
                                     (u'nominal speed level',
                                      {'name': u'Nominal Speed Level',
                                       'pyname': u'nominal_speed_level',
                                       'default': 2,
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'integer',
                                       'unit': u'dimensionless'}),
                                     (u'rated heating capacity at selected nominal speed level',
                                      {'name': u'Rated Heating Capacity At Selected Nominal Speed Level',
                                       'pyname': u'rated_heating_capacity_at_selected_nominal_speed_level',
                                       'default': 'autosize',
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'rated air flow rate at selected nominal speed level',
                                      {'name': u'Rated Air Flow Rate At Selected Nominal Speed Level',
                                       'pyname': u'rated_air_flow_rate_at_selected_nominal_speed_level',
                                       'default': 'autosize',
                                       'required-field': True,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'energy part load fraction curve name',
                                      {'name': u'Energy Part Load Fraction Curve Name',
                                       'pyname': u'energy_part_load_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'defrost energy input ratio function of temperature curve name',
                                      {'name': u'Defrost Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'defrost_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'minimum outdoor dry-bulb temperature for compressor operation',
                                      {'name': u'Minimum Outdoor Dry-Bulb Temperature for Compressor Operation',
                                       'pyname': u'minimum_outdoor_drybulb_temperature_for_compressor_operation',
                                       'default': -8.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': -50.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'outdoor dry-bulb temperature to turn on compressor',
                                      {'name': u'Outdoor Dry-Bulb Temperature to Turn On Compressor',
                                       'pyname': u'outdoor_drybulb_temperature_to_turn_on_compressor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'maximum outdoor dry-bulb temperature for defrost operation',
                                      {'name': u'Maximum Outdoor Dry-Bulb Temperature for Defrost Operation',
                                       'pyname': u'maximum_outdoor_drybulb_temperature_for_defrost_operation',
                                       'default': 5.0,
                                       'maximum': 7.22,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'crankcase heater capacity',
                                      {'name': u'Crankcase Heater Capacity',
                                       'pyname': u'crankcase_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'maximum outdoor dry-bulb temperature for crankcase heater operation',
                                      {'name': u'Maximum Outdoor Dry-Bulb Temperature for Crankcase Heater Operation',
                                       'pyname': u'maximum_outdoor_drybulb_temperature_for_crankcase_heater_operation',
                                       'default': 10.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'defrost strategy',
                                      {'name': u'Defrost Strategy',
                                       'pyname': u'defrost_strategy',
                                       'default': u'ReverseCycle',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'ReverseCycle',
                                                           u'Resistive'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'defrost control',
                                      {'name': u'Defrost Control',
                                       'pyname': u'defrost_control',
                                       'default': u'Timed',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Timed',
                                                           u'OnDemand'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'defrost time period fraction',
                                      {'name': u'Defrost Time Period Fraction',
                                       'pyname': u'defrost_time_period_fraction',
                                       'default': 0.058333,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'resistive defrost heater capacity',
                                      {'name': u'Resistive Defrost Heater Capacity',
                                       'pyname': u'resistive_defrost_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'speed 1 reference unit gross rated heating capacity',
                                      {'name': u'Speed 1 Reference Unit Gross Rated Heating Capacity',
                                       'pyname': u'speed_1_reference_unit_gross_rated_heating_capacity',
                                       'required-field': True,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 1 reference unit gross rated heating cop',
                                      {'name': u'Speed 1 Reference Unit Gross Rated Heating COP',
                                       'pyname': u'speed_1_reference_unit_gross_rated_heating_cop',
                                       'required-field': True,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 1 reference unit rated air flow rate',
                                      {'name': u'Speed 1 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_1_reference_unit_rated_air_flow_rate',
                                       'required-field': True,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 1 heating capacity function of temperature curve name',
                                      {'name': u'Speed 1 Heating Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_1_heating_capacity_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 total  heating capacity function of air flow fraction curve name',
                                      {'name': u'Speed 1 Total  Heating Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_1_total_heating_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 1 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_1_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 1 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 1 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_1_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 reference unit gross rated heating capacity',
                                      {'name': u'Speed 2 Reference Unit Gross Rated Heating Capacity',
                                       'pyname': u'speed_2_reference_unit_gross_rated_heating_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 2 reference unit gross rated heating cop',
                                      {'name': u'Speed 2 Reference Unit Gross Rated Heating COP',
                                       'pyname': u'speed_2_reference_unit_gross_rated_heating_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 2 reference unit rated air flow rate',
                                      {'name': u'Speed 2 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_2_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 2 heating capacity function of temperature curve name',
                                      {'name': u'Speed 2 Heating Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_2_heating_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 total  heating capacity function of air flow fraction curve name',
                                      {'name': u'Speed 2 Total  Heating Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_2_total_heating_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 2 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_2_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 2 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 2 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_2_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 reference unit gross rated heating capacity',
                                      {'name': u'Speed 3 Reference Unit Gross Rated Heating Capacity',
                                       'pyname': u'speed_3_reference_unit_gross_rated_heating_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 3 reference unit gross rated heating cop',
                                      {'name': u'Speed 3 Reference Unit Gross Rated Heating COP',
                                       'pyname': u'speed_3_reference_unit_gross_rated_heating_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 3 reference unit rated air flow rate',
                                      {'name': u'Speed 3 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_3_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 3 heating capacity function of temperature curve name',
                                      {'name': u'Speed 3 Heating Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_3_heating_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 total  heating capacity function of air flow fraction curve name',
                                      {'name': u'Speed 3 Total  Heating Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_3_total_heating_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 3 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_3_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 3 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 3 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_3_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 reference unit gross rated heating capacity',
                                      {'name': u'Speed 4 Reference Unit Gross Rated Heating Capacity',
                                       'pyname': u'speed_4_reference_unit_gross_rated_heating_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 4 reference unit gross rated heating cop',
                                      {'name': u'Speed 4 Reference Unit Gross Rated Heating COP',
                                       'pyname': u'speed_4_reference_unit_gross_rated_heating_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 4 reference unit rated air flow rate',
                                      {'name': u'Speed 4 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_4_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 4 heating capacity function of temperature curve name',
                                      {'name': u'Speed 4 Heating Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_4_heating_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 heating capacity function of air flow fraction curve name',
                                      {'name': u'Speed 4 Heating Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_4_heating_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 4 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_4_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 4 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 4 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_4_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 5 reference unit gross rated heating capacity',
                                      {'name': u'Speed 5 Reference Unit Gross Rated Heating Capacity',
                                       'pyname': u'speed_5_reference_unit_gross_rated_heating_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 5 reference unit gross rated heating cop',
                                      {'name': u'Speed 5 Reference Unit Gross Rated Heating COP',
                                       'pyname': u'speed_5_reference_unit_gross_rated_heating_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 5 reference unit rated air flow rate',
                                      {'name': u'Speed 5 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_5_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 5 heating capacity function of temperature curve name',
                                      {'name': u'Speed 5 Heating Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_5_heating_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 5 heating capacity function of air flow fraction curve name',
                                      {'name': u'Speed 5 Heating Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_5_heating_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 5 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 5 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_5_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 5 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 5 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_5_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 6 reference unit gross rated heating capacity',
                                      {'name': u'Speed 6 Reference Unit Gross Rated Heating Capacity',
                                       'pyname': u'speed_6_reference_unit_gross_rated_heating_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 6 reference unit gross rated heating cop',
                                      {'name': u'Speed 6 Reference Unit Gross Rated Heating COP',
                                       'pyname': u'speed_6_reference_unit_gross_rated_heating_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 6 reference unit rated air flow rate',
                                      {'name': u'Speed 6 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_6_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 6 heating capacity function of temperature curve name',
                                      {'name': u'Speed 6 Heating Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_6_heating_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 6 heating capacity function of air flow fraction curve name',
                                      {'name': u'Speed 6 Heating Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_6_heating_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 6 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 6 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_6_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 6 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 6 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_6_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 7 reference unit gross rated heating capacity',
                                      {'name': u'Speed 7 Reference Unit Gross Rated Heating Capacity',
                                       'pyname': u'speed_7_reference_unit_gross_rated_heating_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 7 reference unit gross rated heating cop',
                                      {'name': u'Speed 7 Reference Unit Gross Rated Heating COP',
                                       'pyname': u'speed_7_reference_unit_gross_rated_heating_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 7 reference unit rated air flow rate',
                                      {'name': u'Speed 7 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_7_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 7 heating capacity function of temperature curve name',
                                      {'name': u'Speed 7 Heating Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_7_heating_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 7 heating capacity function of air flow fraction curve name',
                                      {'name': u'Speed 7 Heating Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_7_heating_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 7 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 7 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_7_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 7 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 7 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_7_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 8 reference unit gross rated heating capacity',
                                      {'name': u'Speed 8 Reference Unit Gross Rated Heating Capacity',
                                       'pyname': u'speed_8_reference_unit_gross_rated_heating_capacity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'w'}),
                                     (u'speed 8 reference unit gross rated heating cop',
                                      {'name': u'Speed 8 Reference Unit Gross Rated Heating COP',
                                       'pyname': u'speed_8_reference_unit_gross_rated_heating_cop',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'speed 8 reference unit rated air flow rate',
                                      {'name': u'Speed 8 Reference Unit Rated Air Flow Rate',
                                       'pyname': u'speed_8_reference_unit_rated_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'speed 8 heating capacity function of temperature curve name',
                                      {'name': u'Speed 8 Heating Capacity Function of Temperature Curve Name',
                                       'pyname': u'speed_8_heating_capacity_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 8 heating capacity function of air flow fraction curve name',
                                      {'name': u'Speed 8 Heating Capacity Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_8_heating_capacity_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 8 energy input ratio function of temperature curve name',
                                      {'name': u'Speed 8 Energy Input Ratio Function of Temperature Curve Name',
                                       'pyname': u'speed_8_energy_input_ratio_function_of_temperature_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'speed 8 energy input ratio function of air flow fraction curve name',
                                      {'name': u'Speed 8 Energy Input Ratio Function of Air Flow Fraction Curve Name',
                                       'pyname': u'speed_8_energy_input_ratio_function_of_air_flow_fraction_curve_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
           