""" Data objects in group "HVAC Templates"
"""

from collections import OrderedDict
import logging
from pyidf.helper import DataObject

logger = logging.getLogger("pyidf")
logger.addHandler(logging.NullHandler())



class HvactemplateThermostat(DataObject):

    """ Corresponds to IDD object `HVACTemplate:Thermostat`
        Zone thermostat control.  Referenced schedules must be
        defined elsewhere in the idf.  Thermostat control type is
        dual setpoint with deadband.  It is not necessary to create
        a thermostat object for every zone, only for each unique
        set of setpoint schedules.  For example, an office building
        may have two thermostat objects, one for "Office" and one
        for "Storage".
    """
    schema = {'min-fields': 5,
              'name': u'HVACTemplate:Thermostat',
              'pyname': u'HvactemplateThermostat',
              'format': None,
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heating setpoint schedule name',
                                      {'name': u'Heating Setpoint Schedule Name',
                                       'pyname': u'heating_setpoint_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'constant heating setpoint',
                                      {'name': u'Constant Heating Setpoint',
                                       'pyname': u'constant_heating_setpoint',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'cooling setpoint schedule name',
                                      {'name': u'Cooling Setpoint Schedule Name',
                                       'pyname': u'cooling_setpoint_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'constant cooling setpoint',
                                      {'name': u'Constant Cooling Setpoint',
                                       'pyname': u'constant_cooling_setpoint',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """  Corresponds to IDD field `Name`
        This name is referenced by HVACTemplate:Zone:* objects

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Name"] = value

    @property
    def heating_setpoint_schedule_name(self):
        """Get heating_setpoint_schedule_name.

        Returns:
            str: the value of `heating_setpoint_schedule_name` or None if not set

        """
        return self["Heating Setpoint Schedule Name"]

    @heating_setpoint_schedule_name.setter
    def heating_setpoint_schedule_name(self, value=None):
        """Corresponds to IDD field `Heating Setpoint Schedule Name` Leave
        blank if constant setpoint specified below, must enter schedule or
        constant setpoint.

        Args:
            value (str): value for IDD Field `Heating Setpoint Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Setpoint Schedule Name"] = value

    @property
    def constant_heating_setpoint(self):
        """Get constant_heating_setpoint.

        Returns:
            float: the value of `constant_heating_setpoint` or None if not set

        """
        return self["Constant Heating Setpoint"]

    @constant_heating_setpoint.setter
    def constant_heating_setpoint(self, value=None):
        """Corresponds to IDD field `Constant Heating Setpoint` Ignored if
        schedule specified above, must enter schedule or constant setpoint.

        Args:
            value (float): value for IDD Field `Constant Heating Setpoint`
                Units: C
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Constant Heating Setpoint"] = value

    @property
    def cooling_setpoint_schedule_name(self):
        """Get cooling_setpoint_schedule_name.

        Returns:
            str: the value of `cooling_setpoint_schedule_name` or None if not set

        """
        return self["Cooling Setpoint Schedule Name"]

    @cooling_setpoint_schedule_name.setter
    def cooling_setpoint_schedule_name(self, value=None):
        """Corresponds to IDD field `Cooling Setpoint Schedule Name` Leave
        blank if constant setpoint specified below, must enter schedule or
        constant setpoint.

        Args:
            value (str): value for IDD Field `Cooling Setpoint Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Setpoint Schedule Name"] = value

    @property
    def constant_cooling_setpoint(self):
        """Get constant_cooling_setpoint.

        Returns:
            float: the value of `constant_cooling_setpoint` or None if not set

        """
        return self["Constant Cooling Setpoint"]

    @constant_cooling_setpoint.setter
    def constant_cooling_setpoint(self, value=None):
        """Corresponds to IDD field `Constant Cooling Setpoint` Ignored if
        schedule specified above, must enter schedule or constant setpoint.

        Args:
            value (float): value for IDD Field `Constant Cooling Setpoint`
                Units: C
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Constant Cooling Setpoint"] = value




class HvactemplateZoneIdealLoadsAirSystem(DataObject):

    """ Corresponds to IDD object `HVACTemplate:Zone:IdealLoadsAirSystem`
        Zone with ideal air system that meets heating or cooling loads
    """
    schema = {'min-fields': 26,
              'name': u'HVACTemplate:Zone:IdealLoadsAirSystem',
              'pyname': u'HvactemplateZoneIdealLoadsAirSystem',
              'format': None,
              'fields': OrderedDict([(u'zone name',
                                      {'name': u'Zone Name',
                                       'pyname': u'zone_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template thermostat name',
                                      {'name': u'Template Thermostat Name',
                                       'pyname': u'template_thermostat_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'system availability schedule name',
                                      {'name': u'System Availability Schedule Name',
                                       'pyname': u'system_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'maximum heating supply air temperature',
                                      {'name': u'Maximum Heating Supply Air Temperature',
                                       'pyname': u'maximum_heating_supply_air_temperature',
                                       'default': 50.0,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'maximum<': 100.0,
                                       'unit': u'C'}),
                                     (u'minimum cooling supply air temperature',
                                      {'name': u'Minimum Cooling Supply Air Temperature',
                                       'pyname': u'minimum_cooling_supply_air_temperature',
                                       'default': 13.0,
                                       'minimum>': -100.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'maximum<': 50.0,
                                       'unit': u'C'}),
                                     (u'maximum heating supply air humidity ratio',
                                      {'name': u'Maximum Heating Supply Air Humidity Ratio',
                                       'pyname': u'maximum_heating_supply_air_humidity_ratio',
                                       'default': 0.0156,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'kgWater/kgDryAir'}),
                                     (u'minimum cooling supply air humidity ratio',
                                      {'name': u'Minimum Cooling Supply Air Humidity Ratio',
                                       'pyname': u'minimum_cooling_supply_air_humidity_ratio',
                                       'default': 0.0077,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'kgWater/kgDryAir'}),
                                     (u'heating limit',
                                      {'name': u'Heating Limit',
                                       'pyname': u'heating_limit',
                                       'default': u'NoLimit',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'NoLimit',
                                                           u'LimitFlowRate',
                                                           u'LimitCapacity',
                                                           u'LimitFlowRateAndCapacity'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'maximum heating air flow rate',
                                      {'name': u'Maximum Heating Air Flow Rate',
                                       'pyname': u'maximum_heating_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'maximum sensible heating capacity',
                                      {'name': u'Maximum Sensible Heating Capacity',
                                       'pyname': u'maximum_sensible_heating_capacity',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'cooling limit',
                                      {'name': u'Cooling Limit',
                                       'pyname': u'cooling_limit',
                                       'default': u'NoLimit',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'NoLimit',
                                                           u'LimitFlowRate',
                                                           u'LimitCapacity',
                                                           u'LimitFlowRateAndCapacity'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'maximum cooling air flow rate',
                                      {'name': u'Maximum Cooling Air Flow Rate',
                                       'pyname': u'maximum_cooling_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'maximum total cooling capacity',
                                      {'name': u'Maximum Total Cooling Capacity',
                                       'pyname': u'maximum_total_cooling_capacity',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'heating availability schedule name',
                                      {'name': u'Heating Availability Schedule Name',
                                       'pyname': u'heating_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'cooling availability schedule name',
                                      {'name': u'Cooling Availability Schedule Name',
                                       'pyname': u'cooling_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'dehumidification control type',
                                      {'name': u'Dehumidification Control Type',
                                       'pyname': u'dehumidification_control_type',
                                       'default': u'ConstantSensibleHeatRatio',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'ConstantSensibleHeatRatio',
                                                           u'Humidistat',
                                                           u'None',
                                                           u'ConstantSupplyHumidityRatio'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'cooling sensible heat ratio',
                                      {'name': u'Cooling Sensible Heat Ratio',
                                       'pyname': u'cooling_sensible_heat_ratio',
                                       'default': 0.7,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'dimensionless'}),
                                     (u'dehumidification setpoint',
                                      {'name': u'Dehumidification Setpoint',
                                       'pyname': u'dehumidification_setpoint',
                                       'default': 60.0,
                                       'maximum': 100.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'percent'}),
                                     (u'humidification control type',
                                      {'name': u'Humidification Control Type',
                                       'pyname': u'humidification_control_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'None',
                                                           u'Humidistat',
                                                           u'ConstantSupplyHumidityRatio'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'humidification setpoint',
                                      {'name': u'Humidification Setpoint',
                                       'pyname': u'humidification_setpoint',
                                       'default': 30.0,
                                       'maximum': 100.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'percent'}),
                                     (u'outdoor air method',
                                      {'name': u'Outdoor Air Method',
                                       'pyname': u'outdoor_air_method',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'None',
                                                           u'Flow/Person',
                                                           u'Flow/Zone',
                                                           u'Flow/Area',
                                                           u'Sum',
                                                           u'Maximum',
                                                           u'DetailedSpecification'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'outdoor air flow rate per person',
                                      {'name': u'Outdoor Air Flow Rate per Person',
                                       'pyname': u'outdoor_air_flow_rate_per_person',
                                       'default': 0.00944,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate per zone floor area',
                                      {'name': u'Outdoor Air Flow Rate per Zone Floor Area',
                                       'pyname': u'outdoor_air_flow_rate_per_zone_floor_area',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s-m2'}),
                                     (u'outdoor air flow rate per zone',
                                      {'name': u'Outdoor Air Flow Rate per Zone',
                                       'pyname': u'outdoor_air_flow_rate_per_zone',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'design specification outdoor air object name',
                                      {'name': u'Design Specification Outdoor Air Object Name',
                                       'pyname': u'design_specification_outdoor_air_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'demand controlled ventilation type',
                                      {'name': u'Demand Controlled Ventilation Type',
                                       'pyname': u'demand_controlled_ventilation_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'None',
                                                           u'OccupancySchedule',
                                                           u'CO2Setpoint'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'outdoor air economizer type',
                                      {'name': u'Outdoor Air Economizer Type',
                                       'pyname': u'outdoor_air_economizer_type',
                                       'default': u'NoEconomizer',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'NoEconomizer',
                                                           u'DifferentialDryBulb',
                                                           u'DifferentialEnthalpy'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heat recovery type',
                                      {'name': u'Heat Recovery Type',
                                       'pyname': u'heat_recovery_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'None',
                                                           u'Sensible',
                                                           u'Enthalpy'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'sensible heat recovery effectiveness',
                                      {'name': u'Sensible Heat Recovery Effectiveness',
                                       'pyname': u'sensible_heat_recovery_effectiveness',
                                       'default': 0.7,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'dimensionless'}),
                                     (u'latent heat recovery effectiveness',
                                      {'name': u'Latent Heat Recovery Effectiveness',
                                       'pyname': u'latent_heat_recovery_effectiveness',
                                       'default': 0.65,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'dimensionless'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def zone_name(self):
        """Get zone_name.

        Returns:
            str: the value of `zone_name` or None if not set

        """
        return self["Zone Name"]

    @zone_name.setter
    def zone_name(self, value=None):
        """Corresponds to IDD field `Zone Name` Zone name must match a building
        zone name.

        Args:
            value (str): value for IDD Field `Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Name"] = value

    @property
    def template_thermostat_name(self):
        """Get template_thermostat_name.

        Returns:
            str: the value of `template_thermostat_name` or None if not set

        """
        return self["Template Thermostat Name"]

    @template_thermostat_name.setter
    def template_thermostat_name(self, value=None):
        """  Corresponds to IDD field `Template Thermostat Name`
        Enter the name of a HVACTemplate:Thermostat object.
        If blank, then it is assumed that standard thermostat objects
        have been defined for this zone.

        Args:
            value (str): value for IDD Field `Template Thermostat Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Thermostat Name"] = value

    @property
    def system_availability_schedule_name(self):
        """Get system_availability_schedule_name.

        Returns:
            str: the value of `system_availability_schedule_name` or None if not set

        """
        return self["System Availability Schedule Name"]

    @system_availability_schedule_name.setter
    def system_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `System Availability Schedule Name` If
        blank, always on.

        Args:
            value (str): value for IDD Field `System Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["System Availability Schedule Name"] = value

    @property
    def maximum_heating_supply_air_temperature(self):
        """Get maximum_heating_supply_air_temperature.

        Returns:
            float: the value of `maximum_heating_supply_air_temperature` or None if not set

        """
        return self["Maximum Heating Supply Air Temperature"]

    @maximum_heating_supply_air_temperature.setter
    def maximum_heating_supply_air_temperature(self, value=50.0):
        """Corresponds to IDD field `Maximum Heating Supply Air Temperature`

        Args:
            value (float): value for IDD Field `Maximum Heating Supply Air Temperature`
                Units: C
                Default value: 50.0
                value < 100.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Maximum Heating Supply Air Temperature"] = value

    @property
    def minimum_cooling_supply_air_temperature(self):
        """Get minimum_cooling_supply_air_temperature.

        Returns:
            float: the value of `minimum_cooling_supply_air_temperature` or None if not set

        """
        return self["Minimum Cooling Supply Air Temperature"]

    @minimum_cooling_supply_air_temperature.setter
    def minimum_cooling_supply_air_temperature(self, value=13.0):
        """Corresponds to IDD field `Minimum Cooling Supply Air Temperature`

        Args:
            value (float): value for IDD Field `Minimum Cooling Supply Air Temperature`
                Units: C
                Default value: 13.0
                value > -100.0
                value < 50.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Minimum Cooling Supply Air Temperature"] = value

    @property
    def maximum_heating_supply_air_humidity_ratio(self):
        """Get maximum_heating_supply_air_humidity_ratio.

        Returns:
            float: the value of `maximum_heating_supply_air_humidity_ratio` or None if not set

        """
        return self["Maximum Heating Supply Air Humidity Ratio"]

    @maximum_heating_supply_air_humidity_ratio.setter
    def maximum_heating_supply_air_humidity_ratio(self, value=0.0156):
        """Corresponds to IDD field `Maximum Heating Supply Air Humidity Ratio`

        Args:
            value (float): value for IDD Field `Maximum Heating Supply Air Humidity Ratio`
                Units: kgWater/kgDryAir
                Default value: 0.0156
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Maximum Heating Supply Air Humidity Ratio"] = value

    @property
    def minimum_cooling_supply_air_humidity_ratio(self):
        """Get minimum_cooling_supply_air_humidity_ratio.

        Returns:
            float: the value of `minimum_cooling_supply_air_humidity_ratio` or None if not set

        """
        return self["Minimum Cooling Supply Air Humidity Ratio"]

    @minimum_cooling_supply_air_humidity_ratio.setter
    def minimum_cooling_supply_air_humidity_ratio(self, value=0.0077):
        """Corresponds to IDD field `Minimum Cooling Supply Air Humidity Ratio`

        Args:
            value (float): value for IDD Field `Minimum Cooling Supply Air Humidity Ratio`
                Units: kgWater/kgDryAir
                Default value: 0.0077
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Minimum Cooling Supply Air Humidity Ratio"] = value

    @property
    def heating_limit(self):
        """Get heating_limit.

        Returns:
            str: the value of `heating_limit` or None if not set

        """
        return self["Heating Limit"]

    @heating_limit.setter
    def heating_limit(self, value="NoLimit"):
        """Corresponds to IDD field `Heating Limit`

        Args:
            value (str): value for IDD Field `Heating Limit`
                Default value: NoLimit
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Limit"] = value

    @property
    def maximum_heating_air_flow_rate(self):
        """Get maximum_heating_air_flow_rate.

        Returns:
            float: the value of `maximum_heating_air_flow_rate` or None if not set

        """
        return self["Maximum Heating Air Flow Rate"]

    @maximum_heating_air_flow_rate.setter
    def maximum_heating_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Maximum Heating Air Flow Rate`
        This field is ignored if Heating Limit = NoLimit
        If this field is blank, there is no limit.

        Args:
            value (float or "Autosize"): value for IDD Field `Maximum Heating Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Maximum Heating Air Flow Rate"] = value

    @property
    def maximum_sensible_heating_capacity(self):
        """Get maximum_sensible_heating_capacity.

        Returns:
            float: the value of `maximum_sensible_heating_capacity` or None if not set

        """
        return self["Maximum Sensible Heating Capacity"]

    @maximum_sensible_heating_capacity.setter
    def maximum_sensible_heating_capacity(self, value=None):
        """  Corresponds to IDD field `Maximum Sensible Heating Capacity`
        This field is ignored if Heating Limit = NoLimit
        If this field is blank, there is no limit.

        Args:
            value (float or "Autosize"): value for IDD Field `Maximum Sensible Heating Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Maximum Sensible Heating Capacity"] = value

    @property
    def cooling_limit(self):
        """Get cooling_limit.

        Returns:
            str: the value of `cooling_limit` or None if not set

        """
        return self["Cooling Limit"]

    @cooling_limit.setter
    def cooling_limit(self, value="NoLimit"):
        """Corresponds to IDD field `Cooling Limit`

        Args:
            value (str): value for IDD Field `Cooling Limit`
                Default value: NoLimit
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Limit"] = value

    @property
    def maximum_cooling_air_flow_rate(self):
        """Get maximum_cooling_air_flow_rate.

        Returns:
            float: the value of `maximum_cooling_air_flow_rate` or None if not set

        """
        return self["Maximum Cooling Air Flow Rate"]

    @maximum_cooling_air_flow_rate.setter
    def maximum_cooling_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Maximum Cooling Air Flow Rate`
        This field is ignored if Cooling Limit = NoLimit
        This field is required if Outdoor Air Economizer Type is anything other than NoEconomizer.

        Args:
            value (float or "Autosize"): value for IDD Field `Maximum Cooling Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Maximum Cooling Air Flow Rate"] = value

    @property
    def maximum_total_cooling_capacity(self):
        """Get maximum_total_cooling_capacity.

        Returns:
            float: the value of `maximum_total_cooling_capacity` or None if not set

        """
        return self["Maximum Total Cooling Capacity"]

    @maximum_total_cooling_capacity.setter
    def maximum_total_cooling_capacity(self, value=None):
        """  Corresponds to IDD field `Maximum Total Cooling Capacity`
        This field is ignored if Cooling Limit = NoLimit

        Args:
            value (float or "Autosize"): value for IDD Field `Maximum Total Cooling Capacity`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Maximum Total Cooling Capacity"] = value

    @property
    def heating_availability_schedule_name(self):
        """Get heating_availability_schedule_name.

        Returns:
            str: the value of `heating_availability_schedule_name` or None if not set

        """
        return self["Heating Availability Schedule Name"]

    @heating_availability_schedule_name.setter
    def heating_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Heating Availability Schedule Name` If
        blank, heating is always available.

        Args:
            value (str): value for IDD Field `Heating Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Availability Schedule Name"] = value

    @property
    def cooling_availability_schedule_name(self):
        """Get cooling_availability_schedule_name.

        Returns:
            str: the value of `cooling_availability_schedule_name` or None if not set

        """
        return self["Cooling Availability Schedule Name"]

    @cooling_availability_schedule_name.setter
    def cooling_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Cooling Availability Schedule Name` If
        blank, cooling is always available.

        Args:
            value (str): value for IDD Field `Cooling Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Availability Schedule Name"] = value

    @property
    def dehumidification_control_type(self):
        """Get dehumidification_control_type.

        Returns:
            str: the value of `dehumidification_control_type` or None if not set

        """
        return self["Dehumidification Control Type"]

    @dehumidification_control_type.setter
    def dehumidification_control_type(self, value="ConstantSensibleHeatRatio"):
        """  Corresponds to IDD field `Dehumidification Control Type`
        ConstantSensibleHeatRatio means that the ideal loads system
        will be controlled to meet the sensible cooling load, and the
        latent cooling rate will be computed using a constant
        sensible heat ratio (SHR)
        Humidistat means that there is a ZoneControl:Humidistat for this
        zone and the ideal loads system will attempt to satisfy the humidistat.
        None means that there is no dehumidification.
        ConstantSupplyHumidityRatio means that during cooling the supply air
        will always be at the Minimum Cooling Supply Humidity Ratio.

        Args:
            value (str): value for IDD Field `Dehumidification Control Type`
                Default value: ConstantSensibleHeatRatio
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Dehumidification Control Type"] = value

    @property
    def cooling_sensible_heat_ratio(self):
        """Get cooling_sensible_heat_ratio.

        Returns:
            float: the value of `cooling_sensible_heat_ratio` or None if not set

        """
        return self["Cooling Sensible Heat Ratio"]

    @cooling_sensible_heat_ratio.setter
    def cooling_sensible_heat_ratio(self, value=0.7):
        """Corresponds to IDD field `Cooling Sensible Heat Ratio` This field is
        applicable only when Dehumidification Control Type is
        ConstantSensibleHeatRatio.

        Args:
            value (float): value for IDD Field `Cooling Sensible Heat Ratio`
                Units: dimensionless
                Default value: 0.7
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Sensible Heat Ratio"] = value

    @property
    def dehumidification_setpoint(self):
        """Get dehumidification_setpoint.

        Returns:
            float: the value of `dehumidification_setpoint` or None if not set

        """
        return self["Dehumidification Setpoint"]

    @dehumidification_setpoint.setter
    def dehumidification_setpoint(self, value=60.0):
        """Corresponds to IDD field `Dehumidification Setpoint` Zone relative
        humidity setpoint in percent (0 to 100)

        Args:
            value (float): value for IDD Field `Dehumidification Setpoint`
                Units: percent
                Default value: 60.0
                value <= 100.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Dehumidification Setpoint"] = value

    @property
    def humidification_control_type(self):
        """Get humidification_control_type.

        Returns:
            str: the value of `humidification_control_type` or None if not set

        """
        return self["Humidification Control Type"]

    @humidification_control_type.setter
    def humidification_control_type(self, value="None"):
        """  Corresponds to IDD field `Humidification Control Type`
        None means that there is no humidification.
        Humidistat means that there is a ZoneControl:Humidistat for this
        zone and the ideal loads system will attempt to satisfy the humidistat.
        ConstantSupplyHumidityRatio means that during heating the supply air
        will always be at the Maximum Heating Supply Humidity Ratio.

        Args:
            value (str): value for IDD Field `Humidification Control Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Humidification Control Type"] = value

    @property
    def humidification_setpoint(self):
        """Get humidification_setpoint.

        Returns:
            float: the value of `humidification_setpoint` or None if not set

        """
        return self["Humidification Setpoint"]

    @humidification_setpoint.setter
    def humidification_setpoint(self, value=30.0):
        """Corresponds to IDD field `Humidification Setpoint` Zone relative
        humidity setpoint in percent (0 to 100)

        Args:
            value (float): value for IDD Field `Humidification Setpoint`
                Units: percent
                Default value: 30.0
                value <= 100.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Humidification Setpoint"] = value

    @property
    def outdoor_air_method(self):
        """Get outdoor_air_method.

        Returns:
            str: the value of `outdoor_air_method` or None if not set

        """
        return self["Outdoor Air Method"]

    @outdoor_air_method.setter
    def outdoor_air_method(self, value="None"):
        """  Corresponds to IDD field `Outdoor Air Method`
        None means there is no outdoor air and all related fields will be ignored
        Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
        fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
        and Outdoor Air Flow Rate per Zone.
        DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
        references design specification objects named in the fields
        Design Specification Outdoor Air Object Name and Design Specification Zone Air
        Distribution Object Name.

        Args:
            value (str): value for IDD Field `Outdoor Air Method`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Method"] = value

    @property
    def outdoor_air_flow_rate_per_person(self):
        """Get outdoor_air_flow_rate_per_person.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_person` or None if not set

        """
        return self["Outdoor Air Flow Rate per Person"]

    @outdoor_air_flow_rate_per_person.setter
    def outdoor_air_flow_rate_per_person(self, value=0.00944):
        """  Corresponds to IDD field `Outdoor Air Flow Rate per Person`
        Default 0.00944 is 20 cfm per person
        This input is used if the field Outdoor Air Method is
        Flow/Person, Sum, or Maximum

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Person`
                Units: m3/s
                Default value: 0.00944
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Flow Rate per Person"] = value

    @property
    def outdoor_air_flow_rate_per_zone_floor_area(self):
        """Get outdoor_air_flow_rate_per_zone_floor_area.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone_floor_area` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone Floor Area"]

    @outdoor_air_flow_rate_per_zone_floor_area.setter
    def outdoor_air_flow_rate_per_zone_floor_area(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone Floor Area`
        This input is used if the field Outdoor Air Method is Flow/Area, Sum,
        or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone Floor Area`
                Units: m3/s-m2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone Floor Area"] = value

    @property
    def outdoor_air_flow_rate_per_zone(self):
        """Get outdoor_air_flow_rate_per_zone.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone"]

    @outdoor_air_flow_rate_per_zone.setter
    def outdoor_air_flow_rate_per_zone(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone` This input
        is used if the field Outdoor Air Method is Flow/Zone, Sum, or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone"] = value

    @property
    def design_specification_outdoor_air_object_name(self):
        """Get design_specification_outdoor_air_object_name.

        Returns:
            str: the value of `design_specification_outdoor_air_object_name` or None if not set

        """
        return self["Design Specification Outdoor Air Object Name"]

    @design_specification_outdoor_air_object_name.setter
    def design_specification_outdoor_air_object_name(self, value=None):
        """  Corresponds to IDD field `Design Specification Outdoor Air Object Name`
        When the name of a DesignSpecification:OutdoorAir object is entered, the minimum
        outdoor air flow rate will be computed using these specifications. The outdoor air
        flow rate will also be affected by the next two fields.
        If this field is blank, there will be no outdoor air and the remaining fields will
        be ignored.

        Args:
            value (str): value for IDD Field `Design Specification Outdoor Air Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Outdoor Air Object Name"] = value

    @property
    def demand_controlled_ventilation_type(self):
        """Get demand_controlled_ventilation_type.

        Returns:
            str: the value of `demand_controlled_ventilation_type` or None if not set

        """
        return self["Demand Controlled Ventilation Type"]

    @demand_controlled_ventilation_type.setter
    def demand_controlled_ventilation_type(self, value="None"):
        """  Corresponds to IDD field `Demand Controlled Ventilation Type`
        This field controls how the minimum outdoor air flow rate is calculated.
        None means that design occupancy will be uased to compute the minimum outdoor air flow rate
        OccupancySchedule means that current occupancy level will be used.
        CO2Setpoint means that the design occupancy will be used to compute the minimum outdoor air flow
        reate and the outdoor air flow rate may be increased if necessary to maintain the indoor air carbon
        dioxide setpoint defined in a ZoneControl:ContaminantController object.

        Args:
            value (str): value for IDD Field `Demand Controlled Ventilation Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Demand Controlled Ventilation Type"] = value

    @property
    def outdoor_air_economizer_type(self):
        """Get outdoor_air_economizer_type.

        Returns:
            str: the value of `outdoor_air_economizer_type` or None if not set

        """
        return self["Outdoor Air Economizer Type"]

    @outdoor_air_economizer_type.setter
    def outdoor_air_economizer_type(self, value="NoEconomizer"):
        """Corresponds to IDD field `Outdoor Air Economizer Type`
        DifferentialDryBulb and DifferentialEnthalpy will increase the outdoor
        air flow rate when there is a cooling load and the outdoor air
        temperature or enthalpy is below the zone exhaust air temperature or
        enthalpy.

        Args:
            value (str): value for IDD Field `Outdoor Air Economizer Type`
                Default value: NoEconomizer
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Economizer Type"] = value

    @property
    def heat_recovery_type(self):
        """Get heat_recovery_type.

        Returns:
            str: the value of `heat_recovery_type` or None if not set

        """
        return self["Heat Recovery Type"]

    @heat_recovery_type.setter
    def heat_recovery_type(self, value="None"):
        """Corresponds to IDD field `Heat Recovery Type`

        Args:
            value (str): value for IDD Field `Heat Recovery Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Recovery Type"] = value

    @property
    def sensible_heat_recovery_effectiveness(self):
        """Get sensible_heat_recovery_effectiveness.

        Returns:
            float: the value of `sensible_heat_recovery_effectiveness` or None if not set

        """
        return self["Sensible Heat Recovery Effectiveness"]

    @sensible_heat_recovery_effectiveness.setter
    def sensible_heat_recovery_effectiveness(self, value=0.7):
        """Corresponds to IDD field `Sensible Heat Recovery Effectiveness`

        Args:
            value (float): value for IDD Field `Sensible Heat Recovery Effectiveness`
                Units: dimensionless
                Default value: 0.7
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Sensible Heat Recovery Effectiveness"] = value

    @property
    def latent_heat_recovery_effectiveness(self):
        """Get latent_heat_recovery_effectiveness.

        Returns:
            float: the value of `latent_heat_recovery_effectiveness` or None if not set

        """
        return self["Latent Heat Recovery Effectiveness"]

    @latent_heat_recovery_effectiveness.setter
    def latent_heat_recovery_effectiveness(self, value=0.65):
        """Corresponds to IDD field `Latent Heat Recovery Effectiveness`
        Applicable only if Heat Recovery Type is Enthalpy.

        Args:
            value (float): value for IDD Field `Latent Heat Recovery Effectiveness`
                Units: dimensionless
                Default value: 0.65
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Latent Heat Recovery Effectiveness"] = value




class HvactemplateZoneBaseboardHeat(DataObject):

    """ Corresponds to IDD object `HVACTemplate:Zone:BaseboardHeat`
        Zone baseboard heating system.
    """
    schema = {'min-fields': 11,
              'name': u'HVACTemplate:Zone:BaseboardHeat',
              'pyname': u'HvactemplateZoneBaseboardHeat',
              'format': None,
              'fields': OrderedDict([(u'zone name',
                                      {'name': u'Zone Name',
                                       'pyname': u'zone_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template thermostat name',
                                      {'name': u'Template Thermostat Name',
                                       'pyname': u'template_thermostat_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'zone heating sizing factor',
                                      {'name': u'Zone Heating Sizing Factor',
                                       'pyname': u'zone_heating_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'baseboard heating type',
                                      {'name': u'Baseboard Heating Type',
                                       'pyname': u'baseboard_heating_type',
                                       'default': u'HotWater',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'baseboard heating availability schedule name',
                                      {'name': u'Baseboard Heating Availability Schedule Name',
                                       'pyname': u'baseboard_heating_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating capacity',
                                      {'name': u'Baseboard Heating Capacity',
                                       'pyname': u'baseboard_heating_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'dedicated outdoor air system name',
                                      {'name': u'Dedicated Outdoor Air System Name',
                                       'pyname': u'dedicated_outdoor_air_system_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'outdoor air method',
                                      {'name': u'Outdoor Air Method',
                                       'pyname': u'outdoor_air_method',
                                       'default': u'Flow/Person',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Flow/Person',
                                                           u'Flow/Zone',
                                                           u'Flow/Area',
                                                           u'Sum',
                                                           u'Maximum',
                                                           u'DetailedSpecification'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'outdoor air flow rate per person',
                                      {'name': u'Outdoor Air Flow Rate per Person',
                                       'pyname': u'outdoor_air_flow_rate_per_person',
                                       'default': 0.00944,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate per zone floor area',
                                      {'name': u'Outdoor Air Flow Rate per Zone Floor Area',
                                       'pyname': u'outdoor_air_flow_rate_per_zone_floor_area',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s-m2'}),
                                     (u'outdoor air flow rate per zone',
                                      {'name': u'Outdoor Air Flow Rate per Zone',
                                       'pyname': u'outdoor_air_flow_rate_per_zone',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'design specification outdoor air object name',
                                      {'name': u'Design Specification Outdoor Air Object name',
                                       'pyname': u'design_specification_outdoor_air_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'design specification zone air distribution object name',
                                      {'name': u'Design Specification Zone Air Distribution Object Name',
                                       'pyname': u'design_specification_zone_air_distribution_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def zone_name(self):
        """Get zone_name.

        Returns:
            str: the value of `zone_name` or None if not set

        """
        return self["Zone Name"]

    @zone_name.setter
    def zone_name(self, value=None):
        """Corresponds to IDD field `Zone Name` Zone name must match a building
        zone name.

        Args:
            value (str): value for IDD Field `Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Name"] = value

    @property
    def template_thermostat_name(self):
        """Get template_thermostat_name.

        Returns:
            str: the value of `template_thermostat_name` or None if not set

        """
        return self["Template Thermostat Name"]

    @template_thermostat_name.setter
    def template_thermostat_name(self, value=None):
        """  Corresponds to IDD field `Template Thermostat Name`
        Enter the name of a HVACTemplate:Thermostat object.
        If blank, then it is assumed that standard thermostat objects
        have been defined for this zone.

        Args:
            value (str): value for IDD Field `Template Thermostat Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Thermostat Name"] = value

    @property
    def zone_heating_sizing_factor(self):
        """Get zone_heating_sizing_factor.

        Returns:
            float: the value of `zone_heating_sizing_factor` or None if not set

        """
        return self["Zone Heating Sizing Factor"]

    @zone_heating_sizing_factor.setter
    def zone_heating_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Heating Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Heating Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Sizing Factor"] = value

    @property
    def baseboard_heating_type(self):
        """Get baseboard_heating_type.

        Returns:
            str: the value of `baseboard_heating_type` or None if not set

        """
        return self["Baseboard Heating Type"]

    @baseboard_heating_type.setter
    def baseboard_heating_type(self, value="HotWater"):
        """Corresponds to IDD field `Baseboard Heating Type`

        Args:
            value (str): value for IDD Field `Baseboard Heating Type`
                Default value: HotWater
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Type"] = value

    @property
    def baseboard_heating_availability_schedule_name(self):
        """Get baseboard_heating_availability_schedule_name.

        Returns:
            str: the value of `baseboard_heating_availability_schedule_name` or None if not set

        """
        return self["Baseboard Heating Availability Schedule Name"]

    @baseboard_heating_availability_schedule_name.setter
    def baseboard_heating_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Baseboard Heating Availability Schedule
        Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Baseboard Heating Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Availability Schedule Name"] = value

    @property
    def baseboard_heating_capacity(self):
        """Get baseboard_heating_capacity.

        Returns:
            float: the value of `baseboard_heating_capacity` or None if not set

        """
        return self["Baseboard Heating Capacity"]

    @baseboard_heating_capacity.setter
    def baseboard_heating_capacity(self, value="autosize"):
        """Corresponds to IDD field `Baseboard Heating Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Baseboard Heating Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Capacity"] = value

    @property
    def dedicated_outdoor_air_system_name(self):
        """Get dedicated_outdoor_air_system_name.

        Returns:
            str: the value of `dedicated_outdoor_air_system_name` or None if not set

        """
        return self["Dedicated Outdoor Air System Name"]

    @dedicated_outdoor_air_system_name.setter
    def dedicated_outdoor_air_system_name(self, value=None):
        """  Corresponds to IDD field `Dedicated Outdoor Air System Name`
        Enter the name of an HVACTemplate:System:DedicatedOutdoorAir object if this
        zone is served by a separate dedicated outdoor air system (DOAS).
        Leave field blank if no DOAS serves this zone.

        Args:
            value (str): value for IDD Field `Dedicated Outdoor Air System Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Dedicated Outdoor Air System Name"] = value

    @property
    def outdoor_air_method(self):
        """Get outdoor_air_method.

        Returns:
            str: the value of `outdoor_air_method` or None if not set

        """
        return self["Outdoor Air Method"]

    @outdoor_air_method.setter
    def outdoor_air_method(self, value="Flow/Person"):
        """  Corresponds to IDD field `Outdoor Air Method`
        Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
        fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
        and Outdoor Air Flow Rate per Zone.
        DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
        references design specification objects named in the fields
        Design Specification Outdoor Air Object Name and Design Specification Zone Air
        Distribution Object Name.

        Args:
            value (str): value for IDD Field `Outdoor Air Method`
                Default value: Flow/Person
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Method"] = value

    @property
    def outdoor_air_flow_rate_per_person(self):
        """Get outdoor_air_flow_rate_per_person.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_person` or None if not set

        """
        return self["Outdoor Air Flow Rate per Person"]

    @outdoor_air_flow_rate_per_person.setter
    def outdoor_air_flow_rate_per_person(self, value=0.00944):
        """  Corresponds to IDD field `Outdoor Air Flow Rate per Person`
        Default 0.00944 is 20 cfm per person
        This input is used if the field Outdoor Air Method is
        Flow/Person, Sum, or Maximum

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Person`
                Units: m3/s
                Default value: 0.00944
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Flow Rate per Person"] = value

    @property
    def outdoor_air_flow_rate_per_zone_floor_area(self):
        """Get outdoor_air_flow_rate_per_zone_floor_area.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone_floor_area` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone Floor Area"]

    @outdoor_air_flow_rate_per_zone_floor_area.setter
    def outdoor_air_flow_rate_per_zone_floor_area(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone Floor Area`
        This input is used if the field Outdoor Air Method is Flow/Area, Sum,
        or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone Floor Area`
                Units: m3/s-m2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone Floor Area"] = value

    @property
    def outdoor_air_flow_rate_per_zone(self):
        """Get outdoor_air_flow_rate_per_zone.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone"]

    @outdoor_air_flow_rate_per_zone.setter
    def outdoor_air_flow_rate_per_zone(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone` This input
        is used if the field Outdoor Air Method is Flow/Zone, Sum, or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone"] = value

    @property
    def design_specification_outdoor_air_object_name(self):
        """Get design_specification_outdoor_air_object_name.

        Returns:
            str: the value of `design_specification_outdoor_air_object_name` or None if not set

        """
        return self["Design Specification Outdoor Air Object name"]

    @design_specification_outdoor_air_object_name.setter
    def design_specification_outdoor_air_object_name(self, value=None):
        """  Corresponds to IDD field `Design Specification Outdoor Air Object name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Outdoor Air Object name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Outdoor Air Object name"] = value

    @property
    def design_specification_zone_air_distribution_object_name(self):
        """Get design_specification_zone_air_distribution_object_name.

        Returns:
            str: the value of `design_specification_zone_air_distribution_object_name` or None if not set

        """
        return self["Design Specification Zone Air Distribution Object Name"]

    @design_specification_zone_air_distribution_object_name.setter
    def design_specification_zone_air_distribution_object_name(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Zone Air Distribution Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Zone Air Distribution Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Zone Air Distribution Object Name"] = value




class HvactemplateZoneFanCoil(DataObject):

    """ Corresponds to IDD object `HVACTemplate:Zone:FanCoil`
        4 pipe fan coil unit with optional outdoor air.
    """
    schema = {'min-fields': 34,
              'name': u'HVACTemplate:Zone:FanCoil',
              'pyname': u'HvactemplateZoneFanCoil',
              'format': None,
              'fields': OrderedDict([(u'zone name',
                                      {'name': u'Zone Name',
                                       'pyname': u'zone_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template thermostat name',
                                      {'name': u'Template Thermostat Name',
                                       'pyname': u'template_thermostat_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply air maximum flow rate',
                                      {'name': u'Supply Air Maximum Flow Rate',
                                       'pyname': u'supply_air_maximum_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'zone heating sizing factor',
                                      {'name': u'Zone Heating Sizing Factor',
                                       'pyname': u'zone_heating_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'zone cooling sizing factor',
                                      {'name': u'Zone Cooling Sizing Factor',
                                       'pyname': u'zone_cooling_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'outdoor air method',
                                      {'name': u'Outdoor Air Method',
                                       'pyname': u'outdoor_air_method',
                                       'default': u'Flow/Person',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Flow/Person',
                                                           u'Flow/Zone',
                                                           u'Flow/Area',
                                                           u'Sum',
                                                           u'Maximum',
                                                           u'DetailedSpecification'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'outdoor air flow rate per person',
                                      {'name': u'Outdoor Air Flow Rate per Person',
                                       'pyname': u'outdoor_air_flow_rate_per_person',
                                       'default': 0.00944,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate per zone floor area',
                                      {'name': u'Outdoor Air Flow Rate per Zone Floor Area',
                                       'pyname': u'outdoor_air_flow_rate_per_zone_floor_area',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s-m2'}),
                                     (u'outdoor air flow rate per zone',
                                      {'name': u'Outdoor Air Flow Rate per Zone',
                                       'pyname': u'outdoor_air_flow_rate_per_zone',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'system availability schedule name',
                                      {'name': u'System Availability Schedule Name',
                                       'pyname': u'system_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply fan total efficiency',
                                      {'name': u'Supply Fan Total Efficiency',
                                       'pyname': u'supply_fan_total_efficiency',
                                       'default': 0.7,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supply fan delta pressure',
                                      {'name': u'Supply Fan Delta Pressure',
                                       'pyname': u'supply_fan_delta_pressure',
                                       'default': 75.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'Pa'}),
                                     (u'supply fan motor efficiency',
                                      {'name': u'Supply Fan Motor Efficiency',
                                       'pyname': u'supply_fan_motor_efficiency',
                                       'default': 0.9,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supply fan motor in air stream fraction',
                                      {'name': u'Supply Fan Motor in Air Stream Fraction',
                                       'pyname': u'supply_fan_motor_in_air_stream_fraction',
                                       'default': 1.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'cooling coil type',
                                      {'name': u'Cooling Coil Type',
                                       'pyname': u'cooling_coil_type',
                                       'default': u'ChilledWater',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'ChilledWater',
                                                           u'ChilledWaterDetailedFlatModel'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'cooling coil availability schedule name',
                                      {'name': u'Cooling Coil Availability Schedule Name',
                                       'pyname': u'cooling_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'cooling coil design setpoint',
                                      {'name': u'Cooling Coil Design Setpoint',
                                       'pyname': u'cooling_coil_design_setpoint',
                                       'default': 14.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'heating coil type',
                                      {'name': u'Heating Coil Type',
                                       'pyname': u'heating_coil_type',
                                       'default': u'HotWater',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heating coil availability schedule name',
                                      {'name': u'Heating Coil Availability Schedule Name',
                                       'pyname': u'heating_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'heating coil design setpoint',
                                      {'name': u'Heating Coil Design Setpoint',
                                       'pyname': u'heating_coil_design_setpoint',
                                       'default': 50.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'dedicated outdoor air system name',
                                      {'name': u'Dedicated Outdoor Air System Name',
                                       'pyname': u'dedicated_outdoor_air_system_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'zone cooling design supply air temperature input method',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_input_method',
                                       'default': u'SupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone cooling design supply air temperature difference',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Difference',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_difference',
                                       'default': 11.11,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'zone heating design supply air temperature input method',
                                      {'name': u'Zone Heating Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_heating_design_supply_air_temperature_input_method',
                                       'default': u'SupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone heating design supply air temperature difference',
                                      {'name': u'Zone Heating Design Supply Air Temperature Difference',
                                       'pyname': u'zone_heating_design_supply_air_temperature_difference',
                                       'default': 30.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'design specification outdoor air object name',
                                      {'name': u'Design Specification Outdoor Air Object Name',
                                       'pyname': u'design_specification_outdoor_air_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'design specification zone air distribution object name',
                                      {'name': u'Design Specification Zone Air Distribution Object Name',
                                       'pyname': u'design_specification_zone_air_distribution_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'capacity control method',
                                      {'name': u'Capacity Control Method',
                                       'pyname': u'capacity_control_method',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'ConstantFanVariableFlow',
                                                           u'CyclingFan',
                                                           u'VariableFanVariableFlow',
                                                           u'VariableFanConstantFlow'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'low speed supply air flow ratio',
                                      {'name': u'Low Speed Supply Air Flow Ratio',
                                       'pyname': u'low_speed_supply_air_flow_ratio',
                                       'default': 0.33,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'medium speed supply air flow ratio',
                                      {'name': u'Medium Speed Supply Air Flow Ratio',
                                       'pyname': u'medium_speed_supply_air_flow_ratio',
                                       'default': 0.66,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'outdoor air schedule name',
                                      {'name': u'Outdoor Air Schedule Name',
                                       'pyname': u'outdoor_air_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating type',
                                      {'name': u'Baseboard Heating Type',
                                       'pyname': u'baseboard_heating_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'baseboard heating availability schedule name',
                                      {'name': u'Baseboard Heating Availability Schedule Name',
                                       'pyname': u'baseboard_heating_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating capacity',
                                      {'name': u'Baseboard Heating Capacity',
                                       'pyname': u'baseboard_heating_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def zone_name(self):
        """Get zone_name.

        Returns:
            str: the value of `zone_name` or None if not set

        """
        return self["Zone Name"]

    @zone_name.setter
    def zone_name(self, value=None):
        """Corresponds to IDD field `Zone Name` Zone name must match a building
        zone name.

        Args:
            value (str): value for IDD Field `Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Name"] = value

    @property
    def template_thermostat_name(self):
        """Get template_thermostat_name.

        Returns:
            str: the value of `template_thermostat_name` or None if not set

        """
        return self["Template Thermostat Name"]

    @template_thermostat_name.setter
    def template_thermostat_name(self, value=None):
        """  Corresponds to IDD field `Template Thermostat Name`
        Enter the name of a HVACTemplate:Thermostat object.
        If blank, then it is assumed that standard thermostat objects
        have been defined for this zone.

        Args:
            value (str): value for IDD Field `Template Thermostat Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Thermostat Name"] = value

    @property
    def supply_air_maximum_flow_rate(self):
        """Get supply_air_maximum_flow_rate.

        Returns:
            float: the value of `supply_air_maximum_flow_rate` or None if not set

        """
        return self["Supply Air Maximum Flow Rate"]

    @supply_air_maximum_flow_rate.setter
    def supply_air_maximum_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Supply Air Maximum Flow Rate` This field
        may be set to "autosize".  If a value is entered, it will be multiplied
        by the Supply Air Sizing Factor and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Supply Air Maximum Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Air Maximum Flow Rate"] = value

    @property
    def zone_heating_sizing_factor(self):
        """Get zone_heating_sizing_factor.

        Returns:
            float: the value of `zone_heating_sizing_factor` or None if not set

        """
        return self["Zone Heating Sizing Factor"]

    @zone_heating_sizing_factor.setter
    def zone_heating_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Heating Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Heating Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Sizing Factor"] = value

    @property
    def zone_cooling_sizing_factor(self):
        """Get zone_cooling_sizing_factor.

        Returns:
            float: the value of `zone_cooling_sizing_factor` or None if not set

        """
        return self["Zone Cooling Sizing Factor"]

    @zone_cooling_sizing_factor.setter
    def zone_cooling_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Cooling Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Cooling Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Sizing Factor"] = value

    @property
    def outdoor_air_method(self):
        """Get outdoor_air_method.

        Returns:
            str: the value of `outdoor_air_method` or None if not set

        """
        return self["Outdoor Air Method"]

    @outdoor_air_method.setter
    def outdoor_air_method(self, value="Flow/Person"):
        """  Corresponds to IDD field `Outdoor Air Method`
        Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
        fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
        and Outdoor Air Flow Rate per Zone.
        DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
        references design specification objects named in the fields
        Design Specification Outdoor Air Object Name and Design Specification Zone Air
        Distribution Object Name.

        Args:
            value (str): value for IDD Field `Outdoor Air Method`
                Default value: Flow/Person
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Method"] = value

    @property
    def outdoor_air_flow_rate_per_person(self):
        """Get outdoor_air_flow_rate_per_person.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_person` or None if not set

        """
        return self["Outdoor Air Flow Rate per Person"]

    @outdoor_air_flow_rate_per_person.setter
    def outdoor_air_flow_rate_per_person(self, value=0.00944):
        """  Corresponds to IDD field `Outdoor Air Flow Rate per Person`
        Default 0.00944 is 20 cfm per person
        This input is used if the field Outdoor Air Method is
        Flow/Person, Sum, or Maximum

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Person`
                Units: m3/s
                Default value: 0.00944
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Flow Rate per Person"] = value

    @property
    def outdoor_air_flow_rate_per_zone_floor_area(self):
        """Get outdoor_air_flow_rate_per_zone_floor_area.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone_floor_area` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone Floor Area"]

    @outdoor_air_flow_rate_per_zone_floor_area.setter
    def outdoor_air_flow_rate_per_zone_floor_area(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone Floor Area`
        This input is used if the field Outdoor Air Method is Flow/Area, Sum,
        or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone Floor Area`
                Units: m3/s-m2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone Floor Area"] = value

    @property
    def outdoor_air_flow_rate_per_zone(self):
        """Get outdoor_air_flow_rate_per_zone.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone"]

    @outdoor_air_flow_rate_per_zone.setter
    def outdoor_air_flow_rate_per_zone(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone` This input
        is used if the field Outdoor Air Method is Flow/Zone, Sum, or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone"] = value

    @property
    def system_availability_schedule_name(self):
        """Get system_availability_schedule_name.

        Returns:
            str: the value of `system_availability_schedule_name` or None if not set

        """
        return self["System Availability Schedule Name"]

    @system_availability_schedule_name.setter
    def system_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `System Availability Schedule Name` If
        blank, always on.

        Args:
            value (str): value for IDD Field `System Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["System Availability Schedule Name"] = value

    @property
    def supply_fan_total_efficiency(self):
        """Get supply_fan_total_efficiency.

        Returns:
            float: the value of `supply_fan_total_efficiency` or None if not set

        """
        return self["Supply Fan Total Efficiency"]

    @supply_fan_total_efficiency.setter
    def supply_fan_total_efficiency(self, value=0.7):
        """Corresponds to IDD field `Supply Fan Total Efficiency`

        Args:
            value (float): value for IDD Field `Supply Fan Total Efficiency`
                Default value: 0.7
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Total Efficiency"] = value

    @property
    def supply_fan_delta_pressure(self):
        """Get supply_fan_delta_pressure.

        Returns:
            float: the value of `supply_fan_delta_pressure` or None if not set

        """
        return self["Supply Fan Delta Pressure"]

    @supply_fan_delta_pressure.setter
    def supply_fan_delta_pressure(self, value=75.0):
        """Corresponds to IDD field `Supply Fan Delta Pressure`

        Args:
            value (float): value for IDD Field `Supply Fan Delta Pressure`
                Units: Pa
                IP-Units: inH2O
                Default value: 75.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Delta Pressure"] = value

    @property
    def supply_fan_motor_efficiency(self):
        """Get supply_fan_motor_efficiency.

        Returns:
            float: the value of `supply_fan_motor_efficiency` or None if not set

        """
        return self["Supply Fan Motor Efficiency"]

    @supply_fan_motor_efficiency.setter
    def supply_fan_motor_efficiency(self, value=0.9):
        """Corresponds to IDD field `Supply Fan Motor Efficiency`

        Args:
            value (float): value for IDD Field `Supply Fan Motor Efficiency`
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Motor Efficiency"] = value

    @property
    def supply_fan_motor_in_air_stream_fraction(self):
        """Get supply_fan_motor_in_air_stream_fraction.

        Returns:
            float: the value of `supply_fan_motor_in_air_stream_fraction` or None if not set

        """
        return self["Supply Fan Motor in Air Stream Fraction"]

    @supply_fan_motor_in_air_stream_fraction.setter
    def supply_fan_motor_in_air_stream_fraction(self, value=1.0):
        """Corresponds to IDD field `Supply Fan Motor in Air Stream Fraction`

        Args:
            value (float): value for IDD Field `Supply Fan Motor in Air Stream Fraction`
                Default value: 1.0
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Motor in Air Stream Fraction"] = value

    @property
    def cooling_coil_type(self):
        """Get cooling_coil_type.

        Returns:
            str: the value of `cooling_coil_type` or None if not set

        """
        return self["Cooling Coil Type"]

    @cooling_coil_type.setter
    def cooling_coil_type(self, value="ChilledWater"):
        """Corresponds to IDD field `Cooling Coil Type`

        Args:
            value (str): value for IDD Field `Cooling Coil Type`
                Default value: ChilledWater
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Type"] = value

    @property
    def cooling_coil_availability_schedule_name(self):
        """Get cooling_coil_availability_schedule_name.

        Returns:
            str: the value of `cooling_coil_availability_schedule_name` or None if not set

        """
        return self["Cooling Coil Availability Schedule Name"]

    @cooling_coil_availability_schedule_name.setter
    def cooling_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Cooling Coil Availability Schedule Name`
        If blank, always on.

        Args:
            value (str): value for IDD Field `Cooling Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Availability Schedule Name"] = value

    @property
    def cooling_coil_design_setpoint(self):
        """Get cooling_coil_design_setpoint.

        Returns:
            float: the value of `cooling_coil_design_setpoint` or None if not set

        """
        return self["Cooling Coil Design Setpoint"]

    @cooling_coil_design_setpoint.setter
    def cooling_coil_design_setpoint(self, value=14.0):
        """  Corresponds to IDD field `Cooling Coil Design Setpoint`
        Used for sizing when Zone Cooling Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Cooling Coil Design Setpoint`
                Units: C
                Default value: 14.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Cooling Coil Design Setpoint"] = value

    @property
    def heating_coil_type(self):
        """Get heating_coil_type.

        Returns:
            str: the value of `heating_coil_type` or None if not set

        """
        return self["Heating Coil Type"]

    @heating_coil_type.setter
    def heating_coil_type(self, value="HotWater"):
        """Corresponds to IDD field `Heating Coil Type`

        Args:
            value (str): value for IDD Field `Heating Coil Type`
                Default value: HotWater
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Coil Type"] = value

    @property
    def heating_coil_availability_schedule_name(self):
        """Get heating_coil_availability_schedule_name.

        Returns:
            str: the value of `heating_coil_availability_schedule_name` or None if not set

        """
        return self["Heating Coil Availability Schedule Name"]

    @heating_coil_availability_schedule_name.setter
    def heating_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Heating Coil Availability Schedule Name`
        If blank, always on.

        Args:
            value (str): value for IDD Field `Heating Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Coil Availability Schedule Name"] = value

    @property
    def heating_coil_design_setpoint(self):
        """Get heating_coil_design_setpoint.

        Returns:
            float: the value of `heating_coil_design_setpoint` or None if not set

        """
        return self["Heating Coil Design Setpoint"]

    @heating_coil_design_setpoint.setter
    def heating_coil_design_setpoint(self, value=50.0):
        """  Corresponds to IDD field `Heating Coil Design Setpoint`
        Used for sizing when Zone Heating Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Heating Coil Design Setpoint`
                Units: C
                Default value: 50.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Heating Coil Design Setpoint"] = value

    @property
    def dedicated_outdoor_air_system_name(self):
        """Get dedicated_outdoor_air_system_name.

        Returns:
            str: the value of `dedicated_outdoor_air_system_name` or None if not set

        """
        return self["Dedicated Outdoor Air System Name"]

    @dedicated_outdoor_air_system_name.setter
    def dedicated_outdoor_air_system_name(self, value=None):
        """  Corresponds to IDD field `Dedicated Outdoor Air System Name`
        Enter the name of an HVACTemplate:System:DedicatedOutdoorAir object if this
        zone is served by a separate dedicated outdoor air system (DOAS).
        Leave field blank if no DOAS serves this zone.

        Args:
            value (str): value for IDD Field `Dedicated Outdoor Air System Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Dedicated Outdoor Air System Name"] = value

    @property
    def zone_cooling_design_supply_air_temperature_input_method(self):
        """Get zone_cooling_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_cooling_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Input Method"]

    @zone_cooling_design_supply_air_temperature_input_method.setter
    def zone_cooling_design_supply_air_temperature_input_method(
            self,
            value="SupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Cooling Coil Design Setpoint (above)
        TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference

        Args:
            value (str): value for IDD Field `Zone Cooling Design Supply Air Temperature Input Method`
                Default value: SupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Input Method"] = value

    @property
    def zone_cooling_design_supply_air_temperature_difference(self):
        """Get zone_cooling_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Difference"]

    @zone_cooling_design_supply_air_temperature_difference.setter
    def zone_cooling_design_supply_air_temperature_difference(
            self,
            value=11.11):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Difference`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be subtracted from the zone temperature
        at peak load to calculate the Zone Cooling Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 11.11
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Difference"] = value

    @property
    def zone_heating_design_supply_air_temperature_input_method(self):
        """Get zone_heating_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_heating_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Input Method"]

    @zone_heating_design_supply_air_temperature_input_method.setter
    def zone_heating_design_supply_air_temperature_input_method(
            self,
            value="SupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Heating Coil Design Setpoint (above)
        TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference

        Args:
            value (str): value for IDD Field `Zone Heating Design Supply Air Temperature Input Method`
                Default value: SupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Input Method"] = value

    @property
    def zone_heating_design_supply_air_temperature_difference(self):
        """Get zone_heating_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Difference"]

    @zone_heating_design_supply_air_temperature_difference.setter
    def zone_heating_design_supply_air_temperature_difference(
            self,
            value=30.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Difference`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be added to the zone temperature
        at peak load to calculate the Zone Heating Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 30.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Difference"] = value

    @property
    def design_specification_outdoor_air_object_name(self):
        """Get design_specification_outdoor_air_object_name.

        Returns:
            str: the value of `design_specification_outdoor_air_object_name` or None if not set

        """
        return self["Design Specification Outdoor Air Object Name"]

    @design_specification_outdoor_air_object_name.setter
    def design_specification_outdoor_air_object_name(self, value=None):
        """  Corresponds to IDD field `Design Specification Outdoor Air Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Outdoor Air Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Outdoor Air Object Name"] = value

    @property
    def design_specification_zone_air_distribution_object_name(self):
        """Get design_specification_zone_air_distribution_object_name.

        Returns:
            str: the value of `design_specification_zone_air_distribution_object_name` or None if not set

        """
        return self["Design Specification Zone Air Distribution Object Name"]

    @design_specification_zone_air_distribution_object_name.setter
    def design_specification_zone_air_distribution_object_name(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Zone Air Distribution Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Zone Air Distribution Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Zone Air Distribution Object Name"] = value

    @property
    def capacity_control_method(self):
        """Get capacity_control_method.

        Returns:
            str: the value of `capacity_control_method` or None if not set

        """
        return self["Capacity Control Method"]

    @capacity_control_method.setter
    def capacity_control_method(self, value=None):
        """Corresponds to IDD field `Capacity Control Method` If this field is
        left blank, it will default to CyclingFan if a Dedicated Outdoor Air
        System is specified (see above), otherwise it will default to
        ConstantFanVariableFlow.

        Args:
            value (str): value for IDD Field `Capacity Control Method`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Capacity Control Method"] = value

    @property
    def low_speed_supply_air_flow_ratio(self):
        """Get low_speed_supply_air_flow_ratio.

        Returns:
            float: the value of `low_speed_supply_air_flow_ratio` or None if not set

        """
        return self["Low Speed Supply Air Flow Ratio"]

    @low_speed_supply_air_flow_ratio.setter
    def low_speed_supply_air_flow_ratio(self, value=0.33):
        """Corresponds to IDD field `Low Speed Supply Air Flow Ratio`

        Args:
            value (float): value for IDD Field `Low Speed Supply Air Flow Ratio`
                Default value: 0.33
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Low Speed Supply Air Flow Ratio"] = value

    @property
    def medium_speed_supply_air_flow_ratio(self):
        """Get medium_speed_supply_air_flow_ratio.

        Returns:
            float: the value of `medium_speed_supply_air_flow_ratio` or None if not set

        """
        return self["Medium Speed Supply Air Flow Ratio"]

    @medium_speed_supply_air_flow_ratio.setter
    def medium_speed_supply_air_flow_ratio(self, value=0.66):
        """Corresponds to IDD field `Medium Speed Supply Air Flow Ratio` Medium
        Speed Supply Air Flow Ratio should be greater than Low Speed Supply Air
        Flow Ratio.

        Args:
            value (float): value for IDD Field `Medium Speed Supply Air Flow Ratio`
                Default value: 0.66
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Medium Speed Supply Air Flow Ratio"] = value

    @property
    def outdoor_air_schedule_name(self):
        """Get outdoor_air_schedule_name.

        Returns:
            str: the value of `outdoor_air_schedule_name` or None if not set

        """
        return self["Outdoor Air Schedule Name"]

    @outdoor_air_schedule_name.setter
    def outdoor_air_schedule_name(self, value=None):
        """Corresponds to IDD field `Outdoor Air Schedule Name` Value of
        schedule multiplies maximum outdoor air flow rate This schedule is
        ignored if this zone is served by an HVACTemplate dedicated outdoor air
        system.

        Args:
            value (str): value for IDD Field `Outdoor Air Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Schedule Name"] = value

    @property
    def baseboard_heating_type(self):
        """Get baseboard_heating_type.

        Returns:
            str: the value of `baseboard_heating_type` or None if not set

        """
        return self["Baseboard Heating Type"]

    @baseboard_heating_type.setter
    def baseboard_heating_type(self, value="None"):
        """Corresponds to IDD field `Baseboard Heating Type`

        Args:
            value (str): value for IDD Field `Baseboard Heating Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Type"] = value

    @property
    def baseboard_heating_availability_schedule_name(self):
        """Get baseboard_heating_availability_schedule_name.

        Returns:
            str: the value of `baseboard_heating_availability_schedule_name` or None if not set

        """
        return self["Baseboard Heating Availability Schedule Name"]

    @baseboard_heating_availability_schedule_name.setter
    def baseboard_heating_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Baseboard Heating Availability Schedule
        Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Baseboard Heating Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Availability Schedule Name"] = value

    @property
    def baseboard_heating_capacity(self):
        """Get baseboard_heating_capacity.

        Returns:
            float: the value of `baseboard_heating_capacity` or None if not set

        """
        return self["Baseboard Heating Capacity"]

    @baseboard_heating_capacity.setter
    def baseboard_heating_capacity(self, value="autosize"):
        """Corresponds to IDD field `Baseboard Heating Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Baseboard Heating Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Capacity"] = value




class HvactemplateZonePtac(DataObject):

    """ Corresponds to IDD object `HVACTemplate:Zone:PTAC`
        Packaged Terminal Air Conditioner
    """
    schema = {'min-fields': 39,
              'name': u'HVACTemplate:Zone:PTAC',
              'pyname': u'HvactemplateZonePtac',
              'format': None,
              'fields': OrderedDict([(u'zone name',
                                      {'name': u'Zone Name',
                                       'pyname': u'zone_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template thermostat name',
                                      {'name': u'Template Thermostat Name',
                                       'pyname': u'template_thermostat_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'cooling supply air flow rate',
                                      {'name': u'Cooling Supply Air Flow Rate',
                                       'pyname': u'cooling_supply_air_flow_rate',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'heating supply air flow rate',
                                      {'name': u'Heating Supply Air Flow Rate',
                                       'pyname': u'heating_supply_air_flow_rate',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'no load supply air flow rate',
                                      {'name': u'No Load Supply Air Flow Rate',
                                       'pyname': u'no_load_supply_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'zone heating sizing factor',
                                      {'name': u'Zone Heating Sizing Factor',
                                       'pyname': u'zone_heating_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'zone cooling sizing factor',
                                      {'name': u'Zone Cooling Sizing Factor',
                                       'pyname': u'zone_cooling_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'outdoor air method',
                                      {'name': u'Outdoor Air Method',
                                       'pyname': u'outdoor_air_method',
                                       'default': u'Flow/Person',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Flow/Person',
                                                           u'Flow/Zone',
                                                           u'Flow/Area',
                                                           u'Sum',
                                                           u'Maximum',
                                                           u'DetailedSpecification'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'outdoor air flow rate per person',
                                      {'name': u'Outdoor Air Flow Rate per Person',
                                       'pyname': u'outdoor_air_flow_rate_per_person',
                                       'default': 0.00944,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate per zone floor area',
                                      {'name': u'Outdoor Air Flow Rate per Zone Floor Area',
                                       'pyname': u'outdoor_air_flow_rate_per_zone_floor_area',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s-m2'}),
                                     (u'outdoor air flow rate per zone',
                                      {'name': u'Outdoor Air Flow Rate per Zone',
                                       'pyname': u'outdoor_air_flow_rate_per_zone',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'system availability schedule name',
                                      {'name': u'System Availability Schedule Name',
                                       'pyname': u'system_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply fan operating mode schedule name',
                                      {'name': u'Supply Fan Operating Mode Schedule Name',
                                       'pyname': u'supply_fan_operating_mode_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply fan placement',
                                      {'name': u'Supply Fan Placement',
                                       'pyname': u'supply_fan_placement',
                                       'default': u'DrawThrough',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'BlowThrough',
                                                           u'DrawThrough'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'supply fan total efficiency',
                                      {'name': u'Supply Fan Total Efficiency',
                                       'pyname': u'supply_fan_total_efficiency',
                                       'default': 0.7,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supply fan delta pressure',
                                      {'name': u'Supply Fan Delta Pressure',
                                       'pyname': u'supply_fan_delta_pressure',
                                       'default': 75.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'Pa'}),
                                     (u'supply fan motor efficiency',
                                      {'name': u'Supply Fan Motor Efficiency',
                                       'pyname': u'supply_fan_motor_efficiency',
                                       'default': 0.9,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'cooling coil type',
                                      {'name': u'Cooling Coil Type',
                                       'pyname': u'cooling_coil_type',
                                       'default': u'SingleSpeedDX',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SingleSpeedDX'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'cooling coil availability schedule name',
                                      {'name': u'Cooling Coil Availability Schedule Name',
                                       'pyname': u'cooling_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'cooling coil gross rated total capacity',
                                      {'name': u'Cooling Coil Gross Rated Total Capacity',
                                       'pyname': u'cooling_coil_gross_rated_total_capacity',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'cooling coil gross rated sensible heat ratio',
                                      {'name': u'Cooling Coil Gross Rated Sensible Heat Ratio',
                                       'pyname': u'cooling_coil_gross_rated_sensible_heat_ratio',
                                       'default': 'autosize',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.5,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'cooling coil gross rated cooling cop',
                                      {'name': u'Cooling Coil Gross Rated Cooling COP',
                                       'pyname': u'cooling_coil_gross_rated_cooling_cop',
                                       'default': 3.0,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'heating coil type',
                                      {'name': u'Heating Coil Type',
                                       'pyname': u'heating_coil_type',
                                       'default': u'Electric',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Electric',
                                                           u'HotWater',
                                                           u'Gas'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heating coil availability schedule name',
                                      {'name': u'Heating Coil Availability Schedule Name',
                                       'pyname': u'heating_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'heating coil capacity',
                                      {'name': u'Heating Coil Capacity',
                                       'pyname': u'heating_coil_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'gas heating coil efficiency',
                                      {'name': u'Gas Heating Coil Efficiency',
                                       'pyname': u'gas_heating_coil_efficiency',
                                       'default': 0.8,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'gas heating coil parasitic electric load',
                                      {'name': u'Gas Heating Coil Parasitic Electric Load',
                                       'pyname': u'gas_heating_coil_parasitic_electric_load',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'dedicated outdoor air system name',
                                      {'name': u'Dedicated Outdoor Air System Name',
                                       'pyname': u'dedicated_outdoor_air_system_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'zone cooling design supply air temperature input method',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_input_method',
                                       'default': u'SupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone cooling design supply air temperature',
                                      {'name': u'Zone Cooling Design Supply Air Temperature',
                                       'pyname': u'zone_cooling_design_supply_air_temperature',
                                       'default': 14.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone cooling design supply air temperature difference',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Difference',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_difference',
                                       'default': 11.11,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'zone heating design supply air temperature input method',
                                      {'name': u'Zone Heating Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_heating_design_supply_air_temperature_input_method',
                                       'default': u'SupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone heating design supply air temperature',
                                      {'name': u'Zone Heating Design Supply Air Temperature',
                                       'pyname': u'zone_heating_design_supply_air_temperature',
                                       'default': 50.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone heating design supply air temperature difference',
                                      {'name': u'Zone Heating Design Supply Air Temperature Difference',
                                       'pyname': u'zone_heating_design_supply_air_temperature_difference',
                                       'default': 30.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'design specification outdoor air object name',
                                      {'name': u'Design Specification Outdoor Air Object Name',
                                       'pyname': u'design_specification_outdoor_air_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'design specification zone air distribution object name',
                                      {'name': u'Design Specification Zone Air Distribution Object Name',
                                       'pyname': u'design_specification_zone_air_distribution_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating type',
                                      {'name': u'Baseboard Heating Type',
                                       'pyname': u'baseboard_heating_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'baseboard heating availability schedule name',
                                      {'name': u'Baseboard Heating Availability Schedule Name',
                                       'pyname': u'baseboard_heating_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating capacity',
                                      {'name': u'Baseboard Heating Capacity',
                                       'pyname': u'baseboard_heating_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def zone_name(self):
        """Get zone_name.

        Returns:
            str: the value of `zone_name` or None if not set

        """
        return self["Zone Name"]

    @zone_name.setter
    def zone_name(self, value=None):
        """Corresponds to IDD field `Zone Name` Zone name must match a building
        zone name.

        Args:
            value (str): value for IDD Field `Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Name"] = value

    @property
    def template_thermostat_name(self):
        """Get template_thermostat_name.

        Returns:
            str: the value of `template_thermostat_name` or None if not set

        """
        return self["Template Thermostat Name"]

    @template_thermostat_name.setter
    def template_thermostat_name(self, value=None):
        """  Corresponds to IDD field `Template Thermostat Name`
        Enter the name of a HVACTemplate:Thermostat object.
        If blank, then it is assumed that standard thermostat objects
        have been defined for this zone.

        Args:
            value (str): value for IDD Field `Template Thermostat Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Thermostat Name"] = value

    @property
    def cooling_supply_air_flow_rate(self):
        """Get cooling_supply_air_flow_rate.

        Returns:
            float: the value of `cooling_supply_air_flow_rate` or None if not set

        """
        return self["Cooling Supply Air Flow Rate"]

    @cooling_supply_air_flow_rate.setter
    def cooling_supply_air_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Cooling Supply Air Flow Rate` Supply air
        flow rate during cooling operation This field may be set to "autosize".
        If a value is entered, it will be multiplied by the Supply Air Sizing
        Factor and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Supply Air Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Supply Air Flow Rate"] = value

    @property
    def heating_supply_air_flow_rate(self):
        """Get heating_supply_air_flow_rate.

        Returns:
            float: the value of `heating_supply_air_flow_rate` or None if not set

        """
        return self["Heating Supply Air Flow Rate"]

    @heating_supply_air_flow_rate.setter
    def heating_supply_air_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Heating Supply Air Flow Rate` Supply air
        flow rate during heating operation This field may be set to "autosize".
        If a value is entered, it will be multiplied by the Supply Air Sizing
        Factor and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Heating Supply Air Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Supply Air Flow Rate"] = value

    @property
    def no_load_supply_air_flow_rate(self):
        """Get no_load_supply_air_flow_rate.

        Returns:
            float: the value of `no_load_supply_air_flow_rate` or None if not set

        """
        return self["No Load Supply Air Flow Rate"]

    @no_load_supply_air_flow_rate.setter
    def no_load_supply_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `No Load Supply Air Flow Rate`
        Supply air flow rate when no cooling or heating is needed
        Only used when heat pump fan operating mode is continuous. This air flow rate
        is used when no heating or cooling is required and the DX coil compressor is off.
        If this field is left blank or zero, the supply air flow rate from the previous on cycle
        (either cooling or heating) is used.
        A value entered in this field will *not* be multiplied by the sizing factor or
        by zone multipliers.  It is best to autosize or leave blank when using zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `No Load Supply Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["No Load Supply Air Flow Rate"] = value

    @property
    def zone_heating_sizing_factor(self):
        """Get zone_heating_sizing_factor.

        Returns:
            float: the value of `zone_heating_sizing_factor` or None if not set

        """
        return self["Zone Heating Sizing Factor"]

    @zone_heating_sizing_factor.setter
    def zone_heating_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Heating Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Heating Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Sizing Factor"] = value

    @property
    def zone_cooling_sizing_factor(self):
        """Get zone_cooling_sizing_factor.

        Returns:
            float: the value of `zone_cooling_sizing_factor` or None if not set

        """
        return self["Zone Cooling Sizing Factor"]

    @zone_cooling_sizing_factor.setter
    def zone_cooling_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Cooling Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Cooling Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Sizing Factor"] = value

    @property
    def outdoor_air_method(self):
        """Get outdoor_air_method.

        Returns:
            str: the value of `outdoor_air_method` or None if not set

        """
        return self["Outdoor Air Method"]

    @outdoor_air_method.setter
    def outdoor_air_method(self, value="Flow/Person"):
        """  Corresponds to IDD field `Outdoor Air Method`
        Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
        fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
        and Outdoor Air Flow Rate per Zone.
        DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
        references design specification objects named in the fields
        Design Specification Outdoor Air Object Name and Design Specification Zone Air
        Distribution Object Name.

        Args:
            value (str): value for IDD Field `Outdoor Air Method`
                Default value: Flow/Person
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Method"] = value

    @property
    def outdoor_air_flow_rate_per_person(self):
        """Get outdoor_air_flow_rate_per_person.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_person` or None if not set

        """
        return self["Outdoor Air Flow Rate per Person"]

    @outdoor_air_flow_rate_per_person.setter
    def outdoor_air_flow_rate_per_person(self, value=0.00944):
        """  Corresponds to IDD field `Outdoor Air Flow Rate per Person`
        Default 0.00944 is 20 cfm per person
        This input is used if the field Outdoor Air Method is
        Flow/Person, Sum, or Maximum

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Person`
                Units: m3/s
                Default value: 0.00944
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Flow Rate per Person"] = value

    @property
    def outdoor_air_flow_rate_per_zone_floor_area(self):
        """Get outdoor_air_flow_rate_per_zone_floor_area.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone_floor_area` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone Floor Area"]

    @outdoor_air_flow_rate_per_zone_floor_area.setter
    def outdoor_air_flow_rate_per_zone_floor_area(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone Floor Area`
        This input is used if the field Outdoor Air Method is Flow/Area, Sum,
        or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone Floor Area`
                Units: m3/s-m2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone Floor Area"] = value

    @property
    def outdoor_air_flow_rate_per_zone(self):
        """Get outdoor_air_flow_rate_per_zone.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone"]

    @outdoor_air_flow_rate_per_zone.setter
    def outdoor_air_flow_rate_per_zone(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone` This input
        is used if the field Outdoor Air Method is Flow/Zone, Sum, or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone"] = value

    @property
    def system_availability_schedule_name(self):
        """Get system_availability_schedule_name.

        Returns:
            str: the value of `system_availability_schedule_name` or None if not set

        """
        return self["System Availability Schedule Name"]

    @system_availability_schedule_name.setter
    def system_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `System Availability Schedule Name` If
        blank, always on.

        Args:
            value (str): value for IDD Field `System Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["System Availability Schedule Name"] = value

    @property
    def supply_fan_operating_mode_schedule_name(self):
        """Get supply_fan_operating_mode_schedule_name.

        Returns:
            str: the value of `supply_fan_operating_mode_schedule_name` or None if not set

        """
        return self["Supply Fan Operating Mode Schedule Name"]

    @supply_fan_operating_mode_schedule_name.setter
    def supply_fan_operating_mode_schedule_name(self, value=None):
        """Corresponds to IDD field `Supply Fan Operating Mode Schedule Name`
        Refers to a schedule to specify unitary supply fan operating mode.
        Schedule Name values of 0 indicate cycling fan (auto) Schedule values
        of 1 indicate continuous fan (on) If this field is left blank, a
        schedule of always zero (cycling fan) will be used.

        Args:
            value (str): value for IDD Field `Supply Fan Operating Mode Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Operating Mode Schedule Name"] = value

    @property
    def supply_fan_placement(self):
        """Get supply_fan_placement.

        Returns:
            str: the value of `supply_fan_placement` or None if not set

        """
        return self["Supply Fan Placement"]

    @supply_fan_placement.setter
    def supply_fan_placement(self, value="DrawThrough"):
        """Corresponds to IDD field `Supply Fan Placement`

        Args:
            value (str): value for IDD Field `Supply Fan Placement`
                Default value: DrawThrough
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Placement"] = value

    @property
    def supply_fan_total_efficiency(self):
        """Get supply_fan_total_efficiency.

        Returns:
            float: the value of `supply_fan_total_efficiency` or None if not set

        """
        return self["Supply Fan Total Efficiency"]

    @supply_fan_total_efficiency.setter
    def supply_fan_total_efficiency(self, value=0.7):
        """Corresponds to IDD field `Supply Fan Total Efficiency`

        Args:
            value (float): value for IDD Field `Supply Fan Total Efficiency`
                Default value: 0.7
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Total Efficiency"] = value

    @property
    def supply_fan_delta_pressure(self):
        """Get supply_fan_delta_pressure.

        Returns:
            float: the value of `supply_fan_delta_pressure` or None if not set

        """
        return self["Supply Fan Delta Pressure"]

    @supply_fan_delta_pressure.setter
    def supply_fan_delta_pressure(self, value=75.0):
        """Corresponds to IDD field `Supply Fan Delta Pressure`

        Args:
            value (float): value for IDD Field `Supply Fan Delta Pressure`
                Units: Pa
                IP-Units: inH2O
                Default value: 75.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Delta Pressure"] = value

    @property
    def supply_fan_motor_efficiency(self):
        """Get supply_fan_motor_efficiency.

        Returns:
            float: the value of `supply_fan_motor_efficiency` or None if not set

        """
        return self["Supply Fan Motor Efficiency"]

    @supply_fan_motor_efficiency.setter
    def supply_fan_motor_efficiency(self, value=0.9):
        """Corresponds to IDD field `Supply Fan Motor Efficiency`

        Args:
            value (float): value for IDD Field `Supply Fan Motor Efficiency`
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Motor Efficiency"] = value

    @property
    def cooling_coil_type(self):
        """Get cooling_coil_type.

        Returns:
            str: the value of `cooling_coil_type` or None if not set

        """
        return self["Cooling Coil Type"]

    @cooling_coil_type.setter
    def cooling_coil_type(self, value="SingleSpeedDX"):
        """Corresponds to IDD field `Cooling Coil Type`

        Args:
            value (str): value for IDD Field `Cooling Coil Type`
                Default value: SingleSpeedDX
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Type"] = value

    @property
    def cooling_coil_availability_schedule_name(self):
        """Get cooling_coil_availability_schedule_name.

        Returns:
            str: the value of `cooling_coil_availability_schedule_name` or None if not set

        """
        return self["Cooling Coil Availability Schedule Name"]

    @cooling_coil_availability_schedule_name.setter
    def cooling_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Cooling Coil Availability Schedule Name`
        If blank, always on.

        Args:
            value (str): value for IDD Field `Cooling Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Availability Schedule Name"] = value

    @property
    def cooling_coil_gross_rated_total_capacity(self):
        """Get cooling_coil_gross_rated_total_capacity.

        Returns:
            float: the value of `cooling_coil_gross_rated_total_capacity` or None if not set

        """
        return self["Cooling Coil Gross Rated Total Capacity"]

    @cooling_coil_gross_rated_total_capacity.setter
    def cooling_coil_gross_rated_total_capacity(self, value="autosize"):
        """  Corresponds to IDD field `Cooling Coil Gross Rated Total Capacity`
        Total cooling capacity not accounting for the effect of supply air fan heat
        Rating point: air entering the cooling coil at 26.7 C dry-bulb/19.4 C wet-bulb, and
        air entering the outdoor condenser coil at 35 C dry-bulb/23.9 C wet-bulb

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Coil Gross Rated Total Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Cooling Coil Gross Rated Total Capacity"] = value

    @property
    def cooling_coil_gross_rated_sensible_heat_ratio(self):
        """Get cooling_coil_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `cooling_coil_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Cooling Coil Gross Rated Sensible Heat Ratio"]

    @cooling_coil_gross_rated_sensible_heat_ratio.setter
    def cooling_coil_gross_rated_sensible_heat_ratio(self, value="autosize"):
        """Corresponds to IDD field `Cooling Coil Gross Rated Sensible Heat
        Ratio` Rated sensible heat ratio (gross sensible capacity/gross total
        capacity) Sensible and total capacities do not include effect of supply
        fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Coil Gross Rated Sensible Heat Ratio`
                Default value: "autosize"
                value >= 0.5
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Gross Rated Sensible Heat Ratio"] = value

    @property
    def cooling_coil_gross_rated_cooling_cop(self):
        """Get cooling_coil_gross_rated_cooling_cop.

        Returns:
            float: the value of `cooling_coil_gross_rated_cooling_cop` or None if not set

        """
        return self["Cooling Coil Gross Rated Cooling COP"]

    @cooling_coil_gross_rated_cooling_cop.setter
    def cooling_coil_gross_rated_cooling_cop(self, value=3.0):
        """Corresponds to IDD field `Cooling Coil Gross Rated Cooling COP`
        Gross cooling capacity divided by power input to the compressor and
        outdoor fan, does not include supply fan heat or supply fan electrical
        energy input.

        Args:
            value (float): value for IDD Field `Cooling Coil Gross Rated Cooling COP`
                Units: W/W
                Default value: 3.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Gross Rated Cooling COP"] = value

    @property
    def heating_coil_type(self):
        """Get heating_coil_type.

        Returns:
            str: the value of `heating_coil_type` or None if not set

        """
        return self["Heating Coil Type"]

    @heating_coil_type.setter
    def heating_coil_type(self, value="Electric"):
        """Corresponds to IDD field `Heating Coil Type`

        Args:
            value (str): value for IDD Field `Heating Coil Type`
                Default value: Electric
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Coil Type"] = value

    @property
    def heating_coil_availability_schedule_name(self):
        """Get heating_coil_availability_schedule_name.

        Returns:
            str: the value of `heating_coil_availability_schedule_name` or None if not set

        """
        return self["Heating Coil Availability Schedule Name"]

    @heating_coil_availability_schedule_name.setter
    def heating_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Heating Coil Availability Schedule Name`
        If blank, always on.

        Args:
            value (str): value for IDD Field `Heating Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Coil Availability Schedule Name"] = value

    @property
    def heating_coil_capacity(self):
        """Get heating_coil_capacity.

        Returns:
            float: the value of `heating_coil_capacity` or None if not set

        """
        return self["Heating Coil Capacity"]

    @heating_coil_capacity.setter
    def heating_coil_capacity(self, value="autosize"):
        """Corresponds to IDD field `Heating Coil Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Heating Coil Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Coil Capacity"] = value

    @property
    def gas_heating_coil_efficiency(self):
        """Get gas_heating_coil_efficiency.

        Returns:
            float: the value of `gas_heating_coil_efficiency` or None if not set

        """
        return self["Gas Heating Coil Efficiency"]

    @gas_heating_coil_efficiency.setter
    def gas_heating_coil_efficiency(self, value=0.8):
        """Corresponds to IDD field `Gas Heating Coil Efficiency` Applies only
        if Heating Coil Type is Gas.

        Args:
            value (float): value for IDD Field `Gas Heating Coil Efficiency`
                Default value: 0.8
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gas Heating Coil Efficiency"] = value

    @property
    def gas_heating_coil_parasitic_electric_load(self):
        """Get gas_heating_coil_parasitic_electric_load.

        Returns:
            float: the value of `gas_heating_coil_parasitic_electric_load` or None if not set

        """
        return self["Gas Heating Coil Parasitic Electric Load"]

    @gas_heating_coil_parasitic_electric_load.setter
    def gas_heating_coil_parasitic_electric_load(self, value=None):
        """Corresponds to IDD field `Gas Heating Coil Parasitic Electric Load`
        Applies only if Heating Coil Type is Gas.

        Args:
            value (float): value for IDD Field `Gas Heating Coil Parasitic Electric Load`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gas Heating Coil Parasitic Electric Load"] = value

    @property
    def dedicated_outdoor_air_system_name(self):
        """Get dedicated_outdoor_air_system_name.

        Returns:
            str: the value of `dedicated_outdoor_air_system_name` or None if not set

        """
        return self["Dedicated Outdoor Air System Name"]

    @dedicated_outdoor_air_system_name.setter
    def dedicated_outdoor_air_system_name(self, value=None):
        """  Corresponds to IDD field `Dedicated Outdoor Air System Name`
        Enter the name of an HVACTemplate:System:DedicatedOutdoorAir object if this
        zone is served by a separate dedicated outdoor air system (DOAS).
        Leave field blank if no DOAS serves this zone.

        Args:
            value (str): value for IDD Field `Dedicated Outdoor Air System Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Dedicated Outdoor Air System Name"] = value

    @property
    def zone_cooling_design_supply_air_temperature_input_method(self):
        """Get zone_cooling_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_cooling_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Input Method"]

    @zone_cooling_design_supply_air_temperature_input_method.setter
    def zone_cooling_design_supply_air_temperature_input_method(
            self,
            value="SupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference

        Args:
            value (str): value for IDD Field `Zone Cooling Design Supply Air Temperature Input Method`
                Default value: SupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Input Method"] = value

    @property
    def zone_cooling_design_supply_air_temperature(self):
        """Get zone_cooling_design_supply_air_temperature.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature"]

    @zone_cooling_design_supply_air_temperature.setter
    def zone_cooling_design_supply_air_temperature(self, value=14.0):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature`
                Units: C
                Default value: 14.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature"] = value

    @property
    def zone_cooling_design_supply_air_temperature_difference(self):
        """Get zone_cooling_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Difference"]

    @zone_cooling_design_supply_air_temperature_difference.setter
    def zone_cooling_design_supply_air_temperature_difference(
            self,
            value=11.11):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Difference`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be subtracted from the zone temperature
        at peak load to calculate the Zone Cooling Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 11.11
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Difference"] = value

    @property
    def zone_heating_design_supply_air_temperature_input_method(self):
        """Get zone_heating_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_heating_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Input Method"]

    @zone_heating_design_supply_air_temperature_input_method.setter
    def zone_heating_design_supply_air_temperature_input_method(
            self,
            value="SupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference

        Args:
            value (str): value for IDD Field `Zone Heating Design Supply Air Temperature Input Method`
                Default value: SupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Input Method"] = value

    @property
    def zone_heating_design_supply_air_temperature(self):
        """Get zone_heating_design_supply_air_temperature.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature"]

    @zone_heating_design_supply_air_temperature.setter
    def zone_heating_design_supply_air_temperature(self, value=50.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature`
                Units: C
                Default value: 50.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature"] = value

    @property
    def zone_heating_design_supply_air_temperature_difference(self):
        """Get zone_heating_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Difference"]

    @zone_heating_design_supply_air_temperature_difference.setter
    def zone_heating_design_supply_air_temperature_difference(
            self,
            value=30.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Difference`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be added to the zone temperature
        at peak load to calculate the Zone Heating Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 30.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Difference"] = value

    @property
    def design_specification_outdoor_air_object_name(self):
        """Get design_specification_outdoor_air_object_name.

        Returns:
            str: the value of `design_specification_outdoor_air_object_name` or None if not set

        """
        return self["Design Specification Outdoor Air Object Name"]

    @design_specification_outdoor_air_object_name.setter
    def design_specification_outdoor_air_object_name(self, value=None):
        """  Corresponds to IDD field `Design Specification Outdoor Air Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Outdoor Air Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Outdoor Air Object Name"] = value

    @property
    def design_specification_zone_air_distribution_object_name(self):
        """Get design_specification_zone_air_distribution_object_name.

        Returns:
            str: the value of `design_specification_zone_air_distribution_object_name` or None if not set

        """
        return self["Design Specification Zone Air Distribution Object Name"]

    @design_specification_zone_air_distribution_object_name.setter
    def design_specification_zone_air_distribution_object_name(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Zone Air Distribution Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Zone Air Distribution Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Zone Air Distribution Object Name"] = value

    @property
    def baseboard_heating_type(self):
        """Get baseboard_heating_type.

        Returns:
            str: the value of `baseboard_heating_type` or None if not set

        """
        return self["Baseboard Heating Type"]

    @baseboard_heating_type.setter
    def baseboard_heating_type(self, value="None"):
        """Corresponds to IDD field `Baseboard Heating Type`

        Args:
            value (str): value for IDD Field `Baseboard Heating Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Type"] = value

    @property
    def baseboard_heating_availability_schedule_name(self):
        """Get baseboard_heating_availability_schedule_name.

        Returns:
            str: the value of `baseboard_heating_availability_schedule_name` or None if not set

        """
        return self["Baseboard Heating Availability Schedule Name"]

    @baseboard_heating_availability_schedule_name.setter
    def baseboard_heating_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Baseboard Heating Availability Schedule
        Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Baseboard Heating Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Availability Schedule Name"] = value

    @property
    def baseboard_heating_capacity(self):
        """Get baseboard_heating_capacity.

        Returns:
            float: the value of `baseboard_heating_capacity` or None if not set

        """
        return self["Baseboard Heating Capacity"]

    @baseboard_heating_capacity.setter
    def baseboard_heating_capacity(self, value="autosize"):
        """Corresponds to IDD field `Baseboard Heating Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Baseboard Heating Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Capacity"] = value




class HvactemplateZonePthp(DataObject):

    """ Corresponds to IDD object `HVACTemplate:Zone:PTHP`
        Packaged Terminal Heat Pump
    """
    schema = {'min-fields': 49,
              'name': u'HVACTemplate:Zone:PTHP',
              'pyname': u'HvactemplateZonePthp',
              'format': None,
              'fields': OrderedDict([(u'zone name',
                                      {'name': u'Zone Name',
                                       'pyname': u'zone_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template thermostat name',
                                      {'name': u'Template Thermostat Name',
                                       'pyname': u'template_thermostat_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'cooling supply air flow rate',
                                      {'name': u'Cooling Supply Air Flow Rate',
                                       'pyname': u'cooling_supply_air_flow_rate',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'heating supply air flow rate',
                                      {'name': u'Heating Supply Air Flow Rate',
                                       'pyname': u'heating_supply_air_flow_rate',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'no load supply air flow rate',
                                      {'name': u'No Load Supply Air Flow Rate',
                                       'pyname': u'no_load_supply_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'zone heating sizing factor',
                                      {'name': u'Zone Heating Sizing Factor',
                                       'pyname': u'zone_heating_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'zone cooling sizing factor',
                                      {'name': u'Zone Cooling Sizing Factor',
                                       'pyname': u'zone_cooling_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'outdoor air method',
                                      {'name': u'Outdoor Air Method',
                                       'pyname': u'outdoor_air_method',
                                       'default': u'Flow/Person',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Flow/Person',
                                                           u'Flow/Zone',
                                                           u'Flow/Area',
                                                           u'Sum',
                                                           u'Maximum',
                                                           u'DetailedSpecification'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'outdoor air flow rate per person',
                                      {'name': u'Outdoor Air Flow Rate per Person',
                                       'pyname': u'outdoor_air_flow_rate_per_person',
                                       'default': 0.00944,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate per zone floor area',
                                      {'name': u'Outdoor Air Flow Rate per Zone Floor Area',
                                       'pyname': u'outdoor_air_flow_rate_per_zone_floor_area',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s-m2'}),
                                     (u'outdoor air flow rate per zone',
                                      {'name': u'Outdoor Air Flow Rate per Zone',
                                       'pyname': u'outdoor_air_flow_rate_per_zone',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'system availability schedule name',
                                      {'name': u'System Availability Schedule Name',
                                       'pyname': u'system_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply fan operating mode schedule name',
                                      {'name': u'Supply Fan Operating Mode Schedule Name',
                                       'pyname': u'supply_fan_operating_mode_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply fan placement',
                                      {'name': u'Supply Fan Placement',
                                       'pyname': u'supply_fan_placement',
                                       'default': u'DrawThrough',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'BlowThrough',
                                                           u'DrawThrough'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'supply fan total efficiency',
                                      {'name': u'Supply Fan Total Efficiency',
                                       'pyname': u'supply_fan_total_efficiency',
                                       'default': 0.7,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supply fan delta pressure',
                                      {'name': u'Supply Fan Delta Pressure',
                                       'pyname': u'supply_fan_delta_pressure',
                                       'default': 75.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'Pa'}),
                                     (u'supply fan motor efficiency',
                                      {'name': u'Supply Fan Motor Efficiency',
                                       'pyname': u'supply_fan_motor_efficiency',
                                       'default': 0.9,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'cooling coil type',
                                      {'name': u'Cooling Coil Type',
                                       'pyname': u'cooling_coil_type',
                                       'default': u'SingleSpeedDX',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SingleSpeedDX'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'cooling coil availability schedule name',
                                      {'name': u'Cooling Coil Availability Schedule Name',
                                       'pyname': u'cooling_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'cooling coil gross rated total capacity',
                                      {'name': u'Cooling Coil Gross Rated Total Capacity',
                                       'pyname': u'cooling_coil_gross_rated_total_capacity',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'cooling coil gross rated sensible heat ratio',
                                      {'name': u'Cooling Coil Gross Rated Sensible Heat Ratio',
                                       'pyname': u'cooling_coil_gross_rated_sensible_heat_ratio',
                                       'default': 'autosize',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.5,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'cooling coil gross rated cop',
                                      {'name': u'Cooling Coil Gross Rated COP',
                                       'pyname': u'cooling_coil_gross_rated_cop',
                                       'default': 3.0,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'heat pump heating coil type',
                                      {'name': u'Heat Pump Heating Coil Type',
                                       'pyname': u'heat_pump_heating_coil_type',
                                       'default': u'SingleSpeedDXHeatPump',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SingleSpeedDXHeatPump'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heat pump heating coil availability schedule name',
                                      {'name': u'Heat Pump Heating Coil Availability Schedule Name',
                                       'pyname': u'heat_pump_heating_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'heat pump heating coil gross rated capacity',
                                      {'name': u'Heat Pump Heating Coil Gross Rated Capacity',
                                       'pyname': u'heat_pump_heating_coil_gross_rated_capacity',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'heat pump heating coil gross rated cop',
                                      {'name': u'Heat Pump Heating Coil Gross Rated COP',
                                       'pyname': u'heat_pump_heating_coil_gross_rated_cop',
                                       'default': 2.75,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W/W'}),
                                     (u'heat pump heating minimum outdoor dry-bulb temperature',
                                      {'name': u'Heat Pump Heating Minimum Outdoor Dry-Bulb Temperature',
                                       'pyname': u'heat_pump_heating_minimum_outdoor_drybulb_temperature',
                                       'default': -8.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': -20.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'heat pump defrost maximum outdoor dry-bulb temperature',
                                      {'name': u'Heat Pump Defrost Maximum Outdoor Dry-Bulb Temperature',
                                       'pyname': u'heat_pump_defrost_maximum_outdoor_drybulb_temperature',
                                       'default': 5.0,
                                       'maximum': 7.22,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'heat pump defrost strategy',
                                      {'name': u'Heat Pump Defrost Strategy',
                                       'pyname': u'heat_pump_defrost_strategy',
                                       'default': u'ReverseCycle',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'ReverseCycle',
                                                           u'Resistive'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heat pump defrost control',
                                      {'name': u'Heat Pump Defrost Control',
                                       'pyname': u'heat_pump_defrost_control',
                                       'default': u'Timed',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Timed',
                                                           u'OnDemand'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heat pump defrost time period fraction',
                                      {'name': u'Heat Pump Defrost Time Period Fraction',
                                       'pyname': u'heat_pump_defrost_time_period_fraction',
                                       'default': 0.058333,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'supplemental heating coil type',
                                      {'name': u'Supplemental Heating Coil Type',
                                       'pyname': u'supplemental_heating_coil_type',
                                       'default': u'Electric',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Electric',
                                                           u'Gas',
                                                           u'HotWater'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'supplemental heating coil availability schedule name',
                                      {'name': u'Supplemental Heating Coil Availability Schedule Name',
                                       'pyname': u'supplemental_heating_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supplemental heating coil capacity',
                                      {'name': u'Supplemental Heating Coil Capacity',
                                       'pyname': u'supplemental_heating_coil_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'supplemental heating coil maximum outdoor dry-bulb temperature',
                                      {'name': u'Supplemental Heating Coil Maximum Outdoor Dry-Bulb Temperature',
                                       'pyname': u'supplemental_heating_coil_maximum_outdoor_drybulb_temperature',
                                       'default': 21.0,
                                       'maximum': 21.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'supplemental gas heating coil efficiency',
                                      {'name': u'Supplemental Gas Heating Coil Efficiency',
                                       'pyname': u'supplemental_gas_heating_coil_efficiency',
                                       'default': 0.8,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supplemental gas heating coil parasitic electric load',
                                      {'name': u'Supplemental Gas Heating Coil Parasitic Electric Load',
                                       'pyname': u'supplemental_gas_heating_coil_parasitic_electric_load',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'dedicated outdoor air system name',
                                      {'name': u'Dedicated Outdoor Air System Name',
                                       'pyname': u'dedicated_outdoor_air_system_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'zone cooling design supply air temperature input method',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_input_method',
                                       'default': u'SupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone cooling design supply air temperature',
                                      {'name': u'Zone Cooling Design Supply Air Temperature',
                                       'pyname': u'zone_cooling_design_supply_air_temperature',
                                       'default': 14.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone cooling design supply air temperature difference',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Difference',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_difference',
                                       'default': 11.11,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'zone heating design supply air temperature input method',
                                      {'name': u'Zone Heating Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_heating_design_supply_air_temperature_input_method',
                                       'default': u'SupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone heating design supply air temperature',
                                      {'name': u'Zone Heating Design Supply Air Temperature',
                                       'pyname': u'zone_heating_design_supply_air_temperature',
                                       'default': 50.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone heating design supply air temperature difference',
                                      {'name': u'Zone Heating Design Supply Air Temperature Difference',
                                       'pyname': u'zone_heating_design_supply_air_temperature_difference',
                                       'default': 30.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'design specification outdoor air object name',
                                      {'name': u'Design Specification Outdoor Air Object Name',
                                       'pyname': u'design_specification_outdoor_air_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'design specification zone air distribution object name',
                                      {'name': u'Design Specification Zone Air Distribution Object Name',
                                       'pyname': u'design_specification_zone_air_distribution_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating type',
                                      {'name': u'Baseboard Heating Type',
                                       'pyname': u'baseboard_heating_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'baseboard heating availability schedule name',
                                      {'name': u'Baseboard Heating Availability Schedule Name',
                                       'pyname': u'baseboard_heating_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating capacity',
                                      {'name': u'Baseboard Heating Capacity',
                                       'pyname': u'baseboard_heating_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def zone_name(self):
        """Get zone_name.

        Returns:
            str: the value of `zone_name` or None if not set

        """
        return self["Zone Name"]

    @zone_name.setter
    def zone_name(self, value=None):
        """Corresponds to IDD field `Zone Name` Zone name must match a building
        zone name.

        Args:
            value (str): value for IDD Field `Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Name"] = value

    @property
    def template_thermostat_name(self):
        """Get template_thermostat_name.

        Returns:
            str: the value of `template_thermostat_name` or None if not set

        """
        return self["Template Thermostat Name"]

    @template_thermostat_name.setter
    def template_thermostat_name(self, value=None):
        """  Corresponds to IDD field `Template Thermostat Name`
        Enter the name of a HVACTemplate:Thermostat object.
        If blank, then it is assumed that standard thermostat objects
        have been defined for this zone.

        Args:
            value (str): value for IDD Field `Template Thermostat Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Thermostat Name"] = value

    @property
    def cooling_supply_air_flow_rate(self):
        """Get cooling_supply_air_flow_rate.

        Returns:
            float: the value of `cooling_supply_air_flow_rate` or None if not set

        """
        return self["Cooling Supply Air Flow Rate"]

    @cooling_supply_air_flow_rate.setter
    def cooling_supply_air_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Cooling Supply Air Flow Rate` Supply air
        flow rate during cooling operation This field may be set to "autosize".
        If a value is entered, it will be multiplied by the Supply Air Sizing
        Factor and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Supply Air Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Supply Air Flow Rate"] = value

    @property
    def heating_supply_air_flow_rate(self):
        """Get heating_supply_air_flow_rate.

        Returns:
            float: the value of `heating_supply_air_flow_rate` or None if not set

        """
        return self["Heating Supply Air Flow Rate"]

    @heating_supply_air_flow_rate.setter
    def heating_supply_air_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Heating Supply Air Flow Rate` Supply air
        flow rate during heating operation This field may be set to "autosize".
        If a value is entered, it will be multiplied by the Supply Air Sizing
        Factor and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Heating Supply Air Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Supply Air Flow Rate"] = value

    @property
    def no_load_supply_air_flow_rate(self):
        """Get no_load_supply_air_flow_rate.

        Returns:
            float: the value of `no_load_supply_air_flow_rate` or None if not set

        """
        return self["No Load Supply Air Flow Rate"]

    @no_load_supply_air_flow_rate.setter
    def no_load_supply_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `No Load Supply Air Flow Rate`
        Supply air flow rate when no cooling or heating is needed
        Only used when heat pump fan operating mode is continuous. This air flow rate
        is used when no heating or cooling is required and the DX coil compressor is off.
        If this field is left blank or zero, the supply air flow rate from the previous on cycle
        (either cooling or heating) is used.
        A value entered in this field will *not* be multiplied by the sizing factor or
        by zone multipliers.  It is best to autosize or leave blank when using zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `No Load Supply Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["No Load Supply Air Flow Rate"] = value

    @property
    def zone_heating_sizing_factor(self):
        """Get zone_heating_sizing_factor.

        Returns:
            float: the value of `zone_heating_sizing_factor` or None if not set

        """
        return self["Zone Heating Sizing Factor"]

    @zone_heating_sizing_factor.setter
    def zone_heating_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Heating Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Heating Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Sizing Factor"] = value

    @property
    def zone_cooling_sizing_factor(self):
        """Get zone_cooling_sizing_factor.

        Returns:
            float: the value of `zone_cooling_sizing_factor` or None if not set

        """
        return self["Zone Cooling Sizing Factor"]

    @zone_cooling_sizing_factor.setter
    def zone_cooling_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Cooling Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Cooling Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Sizing Factor"] = value

    @property
    def outdoor_air_method(self):
        """Get outdoor_air_method.

        Returns:
            str: the value of `outdoor_air_method` or None if not set

        """
        return self["Outdoor Air Method"]

    @outdoor_air_method.setter
    def outdoor_air_method(self, value="Flow/Person"):
        """  Corresponds to IDD field `Outdoor Air Method`
        Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
        fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
        and Outdoor Air Flow Rate per Zone.
        DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
        references design specification objects named in the fields
        Design Specification Outdoor Air Object Name and Design Specification Zone Air
        Distribution Object Name.

        Args:
            value (str): value for IDD Field `Outdoor Air Method`
                Default value: Flow/Person
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Method"] = value

    @property
    def outdoor_air_flow_rate_per_person(self):
        """Get outdoor_air_flow_rate_per_person.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_person` or None if not set

        """
        return self["Outdoor Air Flow Rate per Person"]

    @outdoor_air_flow_rate_per_person.setter
    def outdoor_air_flow_rate_per_person(self, value=0.00944):
        """  Corresponds to IDD field `Outdoor Air Flow Rate per Person`
        Default 0.00944 is 20 cfm per person
        This input is used if the field Outdoor Air Method is
        Flow/Person, Sum, or Maximum

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Person`
                Units: m3/s
                Default value: 0.00944
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Flow Rate per Person"] = value

    @property
    def outdoor_air_flow_rate_per_zone_floor_area(self):
        """Get outdoor_air_flow_rate_per_zone_floor_area.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone_floor_area` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone Floor Area"]

    @outdoor_air_flow_rate_per_zone_floor_area.setter
    def outdoor_air_flow_rate_per_zone_floor_area(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone Floor Area`
        This input is used if the field Outdoor Air Method is Flow/Area, Sum,
        or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone Floor Area`
                Units: m3/s-m2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone Floor Area"] = value

    @property
    def outdoor_air_flow_rate_per_zone(self):
        """Get outdoor_air_flow_rate_per_zone.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone"]

    @outdoor_air_flow_rate_per_zone.setter
    def outdoor_air_flow_rate_per_zone(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone` This input
        is used if the field Outdoor Air Method is Flow/Zone, Sum, or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone"] = value

    @property
    def system_availability_schedule_name(self):
        """Get system_availability_schedule_name.

        Returns:
            str: the value of `system_availability_schedule_name` or None if not set

        """
        return self["System Availability Schedule Name"]

    @system_availability_schedule_name.setter
    def system_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `System Availability Schedule Name` If
        blank, always on.

        Args:
            value (str): value for IDD Field `System Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["System Availability Schedule Name"] = value

    @property
    def supply_fan_operating_mode_schedule_name(self):
        """Get supply_fan_operating_mode_schedule_name.

        Returns:
            str: the value of `supply_fan_operating_mode_schedule_name` or None if not set

        """
        return self["Supply Fan Operating Mode Schedule Name"]

    @supply_fan_operating_mode_schedule_name.setter
    def supply_fan_operating_mode_schedule_name(self, value=None):
        """Corresponds to IDD field `Supply Fan Operating Mode Schedule Name`
        Refers to a schedule to specify unitary supply fan operating mode.
        Schedule values of 0 indicate cycling fan (auto) Schedule values of 1
        indicate continuous fan (on) If this field is left blank, a schedule of
        always zero (cycling fan) will be used.

        Args:
            value (str): value for IDD Field `Supply Fan Operating Mode Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Operating Mode Schedule Name"] = value

    @property
    def supply_fan_placement(self):
        """Get supply_fan_placement.

        Returns:
            str: the value of `supply_fan_placement` or None if not set

        """
        return self["Supply Fan Placement"]

    @supply_fan_placement.setter
    def supply_fan_placement(self, value="DrawThrough"):
        """Corresponds to IDD field `Supply Fan Placement`

        Args:
            value (str): value for IDD Field `Supply Fan Placement`
                Default value: DrawThrough
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Placement"] = value

    @property
    def supply_fan_total_efficiency(self):
        """Get supply_fan_total_efficiency.

        Returns:
            float: the value of `supply_fan_total_efficiency` or None if not set

        """
        return self["Supply Fan Total Efficiency"]

    @supply_fan_total_efficiency.setter
    def supply_fan_total_efficiency(self, value=0.7):
        """Corresponds to IDD field `Supply Fan Total Efficiency`

        Args:
            value (float): value for IDD Field `Supply Fan Total Efficiency`
                Default value: 0.7
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Total Efficiency"] = value

    @property
    def supply_fan_delta_pressure(self):
        """Get supply_fan_delta_pressure.

        Returns:
            float: the value of `supply_fan_delta_pressure` or None if not set

        """
        return self["Supply Fan Delta Pressure"]

    @supply_fan_delta_pressure.setter
    def supply_fan_delta_pressure(self, value=75.0):
        """Corresponds to IDD field `Supply Fan Delta Pressure`

        Args:
            value (float): value for IDD Field `Supply Fan Delta Pressure`
                Units: Pa
                IP-Units: inH2O
                Default value: 75.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Delta Pressure"] = value

    @property
    def supply_fan_motor_efficiency(self):
        """Get supply_fan_motor_efficiency.

        Returns:
            float: the value of `supply_fan_motor_efficiency` or None if not set

        """
        return self["Supply Fan Motor Efficiency"]

    @supply_fan_motor_efficiency.setter
    def supply_fan_motor_efficiency(self, value=0.9):
        """Corresponds to IDD field `Supply Fan Motor Efficiency`

        Args:
            value (float): value for IDD Field `Supply Fan Motor Efficiency`
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Motor Efficiency"] = value

    @property
    def cooling_coil_type(self):
        """Get cooling_coil_type.

        Returns:
            str: the value of `cooling_coil_type` or None if not set

        """
        return self["Cooling Coil Type"]

    @cooling_coil_type.setter
    def cooling_coil_type(self, value="SingleSpeedDX"):
        """Corresponds to IDD field `Cooling Coil Type`

        Args:
            value (str): value for IDD Field `Cooling Coil Type`
                Default value: SingleSpeedDX
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Type"] = value

    @property
    def cooling_coil_availability_schedule_name(self):
        """Get cooling_coil_availability_schedule_name.

        Returns:
            str: the value of `cooling_coil_availability_schedule_name` or None if not set

        """
        return self["Cooling Coil Availability Schedule Name"]

    @cooling_coil_availability_schedule_name.setter
    def cooling_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Cooling Coil Availability Schedule Name`
        If blank, always on.

        Args:
            value (str): value for IDD Field `Cooling Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Availability Schedule Name"] = value

    @property
    def cooling_coil_gross_rated_total_capacity(self):
        """Get cooling_coil_gross_rated_total_capacity.

        Returns:
            float: the value of `cooling_coil_gross_rated_total_capacity` or None if not set

        """
        return self["Cooling Coil Gross Rated Total Capacity"]

    @cooling_coil_gross_rated_total_capacity.setter
    def cooling_coil_gross_rated_total_capacity(self, value="autosize"):
        """  Corresponds to IDD field `Cooling Coil Gross Rated Total Capacity`
        Total cooling capacity not accounting for the effect of supply air fan heat
        Rating point: air entering the cooling coil at 26.7 C dry-bulb/19.4 C wet-bulb, and
        air entering the outdoor condenser coil at 35 C dry-bulb/23.9 C wet-bulb

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Coil Gross Rated Total Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Cooling Coil Gross Rated Total Capacity"] = value

    @property
    def cooling_coil_gross_rated_sensible_heat_ratio(self):
        """Get cooling_coil_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `cooling_coil_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Cooling Coil Gross Rated Sensible Heat Ratio"]

    @cooling_coil_gross_rated_sensible_heat_ratio.setter
    def cooling_coil_gross_rated_sensible_heat_ratio(self, value="autosize"):
        """Corresponds to IDD field `Cooling Coil Gross Rated Sensible Heat
        Ratio` Rated sensible heat ratio (gross sensible capacity/gross total
        capacity) Sensible and total capacities do not include effect of supply
        fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Coil Gross Rated Sensible Heat Ratio`
                Default value: "autosize"
                value >= 0.5
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Gross Rated Sensible Heat Ratio"] = value

    @property
    def cooling_coil_gross_rated_cop(self):
        """Get cooling_coil_gross_rated_cop.

        Returns:
            float: the value of `cooling_coil_gross_rated_cop` or None if not set

        """
        return self["Cooling Coil Gross Rated COP"]

    @cooling_coil_gross_rated_cop.setter
    def cooling_coil_gross_rated_cop(self, value=3.0):
        """Corresponds to IDD field `Cooling Coil Gross Rated COP` Gross
        cooling capacity divided by power input to the compressor and outdoor
        fan, does not include supply fan heat or supply fan electrical energy
        input.

        Args:
            value (float): value for IDD Field `Cooling Coil Gross Rated COP`
                Units: W/W
                Default value: 3.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Gross Rated COP"] = value

    @property
    def heat_pump_heating_coil_type(self):
        """Get heat_pump_heating_coil_type.

        Returns:
            str: the value of `heat_pump_heating_coil_type` or None if not set

        """
        return self["Heat Pump Heating Coil Type"]

    @heat_pump_heating_coil_type.setter
    def heat_pump_heating_coil_type(self, value="SingleSpeedDXHeatPump"):
        """Corresponds to IDD field `Heat Pump Heating Coil Type`

        Args:
            value (str): value for IDD Field `Heat Pump Heating Coil Type`
                Default value: SingleSpeedDXHeatPump
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Heating Coil Type"] = value

    @property
    def heat_pump_heating_coil_availability_schedule_name(self):
        """Get heat_pump_heating_coil_availability_schedule_name.

        Returns:
            str: the value of `heat_pump_heating_coil_availability_schedule_name` or None if not set

        """
        return self["Heat Pump Heating Coil Availability Schedule Name"]

    @heat_pump_heating_coil_availability_schedule_name.setter
    def heat_pump_heating_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Heat Pump Heating Coil Availability
        Schedule Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Heat Pump Heating Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Heating Coil Availability Schedule Name"] = value

    @property
    def heat_pump_heating_coil_gross_rated_capacity(self):
        """Get heat_pump_heating_coil_gross_rated_capacity.

        Returns:
            float: the value of `heat_pump_heating_coil_gross_rated_capacity` or None if not set

        """
        return self["Heat Pump Heating Coil Gross Rated Capacity"]

    @heat_pump_heating_coil_gross_rated_capacity.setter
    def heat_pump_heating_coil_gross_rated_capacity(self, value="autosize"):
        """  Corresponds to IDD field `Heat Pump Heating Coil Gross Rated Capacity`
        Capacity excluding supply air fan heat
        Rating point outdoor dry-bulb temp 8.33 C, outdoor wet-bulb temp 6.11 C
        Rating point heating coil entering air dry-bulb 21.11 C, coil entering wet-bulb 15.55 C

        Args:
            value (float or "Autosize"): value for IDD Field `Heat Pump Heating Coil Gross Rated Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Heat Pump Heating Coil Gross Rated Capacity"] = value

    @property
    def heat_pump_heating_coil_gross_rated_cop(self):
        """Get heat_pump_heating_coil_gross_rated_cop.

        Returns:
            float: the value of `heat_pump_heating_coil_gross_rated_cop` or None if not set

        """
        return self["Heat Pump Heating Coil Gross Rated COP"]

    @heat_pump_heating_coil_gross_rated_cop.setter
    def heat_pump_heating_coil_gross_rated_cop(self, value=2.75):
        """  Corresponds to IDD field `Heat Pump Heating Coil Gross Rated COP`
        Heat Pump Heating Coil Rated Capacity divided by power input to the compressor and outdoor fan,
        Does not include supply air fan heat or supply air fan electrical energy
        Rating point outdoor dry-bulb temp 8.33 C, outdoor wet-bulb temp 6.11 C
        Rating point heating coil entering air dry-bulb 21.11 C, coil entering wet-bulb 15.55 C

        Args:
            value (float): value for IDD Field `Heat Pump Heating Coil Gross Rated COP`
                Units: W/W
                Default value: 2.75
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Heat Pump Heating Coil Gross Rated COP"] = value

    @property
    def heat_pump_heating_minimum_outdoor_drybulb_temperature(self):
        """Get heat_pump_heating_minimum_outdoor_drybulb_temperature.

        Returns:
            float: the value of `heat_pump_heating_minimum_outdoor_drybulb_temperature` or None if not set

        """
        return self["Heat Pump Heating Minimum Outdoor Dry-Bulb Temperature"]

    @heat_pump_heating_minimum_outdoor_drybulb_temperature.setter
    def heat_pump_heating_minimum_outdoor_drybulb_temperature(
            self,
            value=-
            8.0):
        """  Corresponds to IDD field `Heat Pump Heating Minimum Outdoor Dry-Bulb Temperature`

        Args:
            value (float): value for IDD Field `Heat Pump Heating Minimum Outdoor Dry-Bulb Temperature`
                Units: C
                Default value: -8.0
                value >= -20.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Heat Pump Heating Minimum Outdoor Dry-Bulb Temperature"] = value

    @property
    def heat_pump_defrost_maximum_outdoor_drybulb_temperature(self):
        """Get heat_pump_defrost_maximum_outdoor_drybulb_temperature.

        Returns:
            float: the value of `heat_pump_defrost_maximum_outdoor_drybulb_temperature` or None if not set

        """
        return self["Heat Pump Defrost Maximum Outdoor Dry-Bulb Temperature"]

    @heat_pump_defrost_maximum_outdoor_drybulb_temperature.setter
    def heat_pump_defrost_maximum_outdoor_drybulb_temperature(self, value=5.0):
        """  Corresponds to IDD field `Heat Pump Defrost Maximum Outdoor Dry-Bulb Temperature`

        Args:
            value (float): value for IDD Field `Heat Pump Defrost Maximum Outdoor Dry-Bulb Temperature`
                Units: C
                Default value: 5.0
                value <= 7.22
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Heat Pump Defrost Maximum Outdoor Dry-Bulb Temperature"] = value

    @property
    def heat_pump_defrost_strategy(self):
        """Get heat_pump_defrost_strategy.

        Returns:
            str: the value of `heat_pump_defrost_strategy` or None if not set

        """
        return self["Heat Pump Defrost Strategy"]

    @heat_pump_defrost_strategy.setter
    def heat_pump_defrost_strategy(self, value="ReverseCycle"):
        """Corresponds to IDD field `Heat Pump Defrost Strategy`

        Args:
            value (str): value for IDD Field `Heat Pump Defrost Strategy`
                Default value: ReverseCycle
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Defrost Strategy"] = value

    @property
    def heat_pump_defrost_control(self):
        """Get heat_pump_defrost_control.

        Returns:
            str: the value of `heat_pump_defrost_control` or None if not set

        """
        return self["Heat Pump Defrost Control"]

    @heat_pump_defrost_control.setter
    def heat_pump_defrost_control(self, value="Timed"):
        """Corresponds to IDD field `Heat Pump Defrost Control`

        Args:
            value (str): value for IDD Field `Heat Pump Defrost Control`
                Default value: Timed
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Defrost Control"] = value

    @property
    def heat_pump_defrost_time_period_fraction(self):
        """Get heat_pump_defrost_time_period_fraction.

        Returns:
            float: the value of `heat_pump_defrost_time_period_fraction` or None if not set

        """
        return self["Heat Pump Defrost Time Period Fraction"]

    @heat_pump_defrost_time_period_fraction.setter
    def heat_pump_defrost_time_period_fraction(self, value=0.058333):
        """Corresponds to IDD field `Heat Pump Defrost Time Period Fraction`
        Fraction of time in defrost mode only applicable if Timed defrost
        control is specified.

        Args:
            value (float): value for IDD Field `Heat Pump Defrost Time Period Fraction`
                Default value: 0.058333
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Defrost Time Period Fraction"] = value

    @property
    def supplemental_heating_coil_type(self):
        """Get supplemental_heating_coil_type.

        Returns:
            str: the value of `supplemental_heating_coil_type` or None if not set

        """
        return self["Supplemental Heating Coil Type"]

    @supplemental_heating_coil_type.setter
    def supplemental_heating_coil_type(self, value="Electric"):
        """Corresponds to IDD field `Supplemental Heating Coil Type`

        Args:
            value (str): value for IDD Field `Supplemental Heating Coil Type`
                Default value: Electric
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supplemental Heating Coil Type"] = value

    @property
    def supplemental_heating_coil_availability_schedule_name(self):
        """Get supplemental_heating_coil_availability_schedule_name.

        Returns:
            str: the value of `supplemental_heating_coil_availability_schedule_name` or None if not set

        """
        return self["Supplemental Heating Coil Availability Schedule Name"]

    @supplemental_heating_coil_availability_schedule_name.setter
    def supplemental_heating_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Supplemental Heating Coil Availability
        Schedule Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Supplemental Heating Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supplemental Heating Coil Availability Schedule Name"] = value

    @property
    def supplemental_heating_coil_capacity(self):
        """Get supplemental_heating_coil_capacity.

        Returns:
            float: the value of `supplemental_heating_coil_capacity` or None if not set

        """
        return self["Supplemental Heating Coil Capacity"]

    @supplemental_heating_coil_capacity.setter
    def supplemental_heating_coil_capacity(self, value="autosize"):
        """Corresponds to IDD field `Supplemental Heating Coil Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Supplemental Heating Coil Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supplemental Heating Coil Capacity"] = value

    @property
    def supplemental_heating_coil_maximum_outdoor_drybulb_temperature(self):
        """Get supplemental_heating_coil_maximum_outdoor_drybulb_temperature.

        Returns:
            float: the value of `supplemental_heating_coil_maximum_outdoor_drybulb_temperature` or None if not set

        """
        return self[
            "Supplemental Heating Coil Maximum Outdoor Dry-Bulb Temperature"]

    @supplemental_heating_coil_maximum_outdoor_drybulb_temperature.setter
    def supplemental_heating_coil_maximum_outdoor_drybulb_temperature(
            self,
            value=21.0):
        """  Corresponds to IDD field `Supplemental Heating Coil Maximum Outdoor Dry-Bulb Temperature`
        Supplemental heater will not operate when outdoor temperature exceeds this value.

        Args:
            value (float): value for IDD Field `Supplemental Heating Coil Maximum Outdoor Dry-Bulb Temperature`
                Units: C
                Default value: 21.0
                value <= 21.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Supplemental Heating Coil Maximum Outdoor Dry-Bulb Temperature"] = value

    @property
    def supplemental_gas_heating_coil_efficiency(self):
        """Get supplemental_gas_heating_coil_efficiency.

        Returns:
            float: the value of `supplemental_gas_heating_coil_efficiency` or None if not set

        """
        return self["Supplemental Gas Heating Coil Efficiency"]

    @supplemental_gas_heating_coil_efficiency.setter
    def supplemental_gas_heating_coil_efficiency(self, value=0.8):
        """Corresponds to IDD field `Supplemental Gas Heating Coil Efficiency`
        Applies only if Supplemental Heating Coil Type is Gas.

        Args:
            value (float): value for IDD Field `Supplemental Gas Heating Coil Efficiency`
                Default value: 0.8
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supplemental Gas Heating Coil Efficiency"] = value

    @property
    def supplemental_gas_heating_coil_parasitic_electric_load(self):
        """Get supplemental_gas_heating_coil_parasitic_electric_load.

        Returns:
            float: the value of `supplemental_gas_heating_coil_parasitic_electric_load` or None if not set

        """
        return self["Supplemental Gas Heating Coil Parasitic Electric Load"]

    @supplemental_gas_heating_coil_parasitic_electric_load.setter
    def supplemental_gas_heating_coil_parasitic_electric_load(
            self,
            value=None):
        """Corresponds to IDD field `Supplemental Gas Heating Coil Parasitic
        Electric Load` Applies only if Supplemental Heating Coil Type is Gas.

        Args:
            value (float): value for IDD Field `Supplemental Gas Heating Coil Parasitic Electric Load`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supplemental Gas Heating Coil Parasitic Electric Load"] = value

    @property
    def dedicated_outdoor_air_system_name(self):
        """Get dedicated_outdoor_air_system_name.

        Returns:
            str: the value of `dedicated_outdoor_air_system_name` or None if not set

        """
        return self["Dedicated Outdoor Air System Name"]

    @dedicated_outdoor_air_system_name.setter
    def dedicated_outdoor_air_system_name(self, value=None):
        """  Corresponds to IDD field `Dedicated Outdoor Air System Name`
        Enter the name of an HVACTemplate:System:DedicatedOutdoorAir object if this
        zone is served by a separate dedicated outdoor air system (DOAS).
        Leave field blank if no DOAS serves this zone.

        Args:
            value (str): value for IDD Field `Dedicated Outdoor Air System Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Dedicated Outdoor Air System Name"] = value

    @property
    def zone_cooling_design_supply_air_temperature_input_method(self):
        """Get zone_cooling_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_cooling_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Input Method"]

    @zone_cooling_design_supply_air_temperature_input_method.setter
    def zone_cooling_design_supply_air_temperature_input_method(
            self,
            value="SupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference

        Args:
            value (str): value for IDD Field `Zone Cooling Design Supply Air Temperature Input Method`
                Default value: SupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Input Method"] = value

    @property
    def zone_cooling_design_supply_air_temperature(self):
        """Get zone_cooling_design_supply_air_temperature.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature"]

    @zone_cooling_design_supply_air_temperature.setter
    def zone_cooling_design_supply_air_temperature(self, value=14.0):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature`
                Units: C
                Default value: 14.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature"] = value

    @property
    def zone_cooling_design_supply_air_temperature_difference(self):
        """Get zone_cooling_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Difference"]

    @zone_cooling_design_supply_air_temperature_difference.setter
    def zone_cooling_design_supply_air_temperature_difference(
            self,
            value=11.11):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Difference`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be subtracted from the zone temperature
        at peak load to calculate the Zone Cooling Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 11.11
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Difference"] = value

    @property
    def zone_heating_design_supply_air_temperature_input_method(self):
        """Get zone_heating_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_heating_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Input Method"]

    @zone_heating_design_supply_air_temperature_input_method.setter
    def zone_heating_design_supply_air_temperature_input_method(
            self,
            value="SupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference

        Args:
            value (str): value for IDD Field `Zone Heating Design Supply Air Temperature Input Method`
                Default value: SupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Input Method"] = value

    @property
    def zone_heating_design_supply_air_temperature(self):
        """Get zone_heating_design_supply_air_temperature.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature"]

    @zone_heating_design_supply_air_temperature.setter
    def zone_heating_design_supply_air_temperature(self, value=50.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature`
                Units: C
                Default value: 50.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature"] = value

    @property
    def zone_heating_design_supply_air_temperature_difference(self):
        """Get zone_heating_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Difference"]

    @zone_heating_design_supply_air_temperature_difference.setter
    def zone_heating_design_supply_air_temperature_difference(
            self,
            value=30.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Difference`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be added to the zone temperature
        at peak load to calculate the Zone Heating Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 30.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Difference"] = value

    @property
    def design_specification_outdoor_air_object_name(self):
        """Get design_specification_outdoor_air_object_name.

        Returns:
            str: the value of `design_specification_outdoor_air_object_name` or None if not set

        """
        return self["Design Specification Outdoor Air Object Name"]

    @design_specification_outdoor_air_object_name.setter
    def design_specification_outdoor_air_object_name(self, value=None):
        """  Corresponds to IDD field `Design Specification Outdoor Air Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Outdoor Air Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Outdoor Air Object Name"] = value

    @property
    def design_specification_zone_air_distribution_object_name(self):
        """Get design_specification_zone_air_distribution_object_name.

        Returns:
            str: the value of `design_specification_zone_air_distribution_object_name` or None if not set

        """
        return self["Design Specification Zone Air Distribution Object Name"]

    @design_specification_zone_air_distribution_object_name.setter
    def design_specification_zone_air_distribution_object_name(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Zone Air Distribution Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Zone Air Distribution Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Zone Air Distribution Object Name"] = value

    @property
    def baseboard_heating_type(self):
        """Get baseboard_heating_type.

        Returns:
            str: the value of `baseboard_heating_type` or None if not set

        """
        return self["Baseboard Heating Type"]

    @baseboard_heating_type.setter
    def baseboard_heating_type(self, value="None"):
        """Corresponds to IDD field `Baseboard Heating Type`

        Args:
            value (str): value for IDD Field `Baseboard Heating Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Type"] = value

    @property
    def baseboard_heating_availability_schedule_name(self):
        """Get baseboard_heating_availability_schedule_name.

        Returns:
            str: the value of `baseboard_heating_availability_schedule_name` or None if not set

        """
        return self["Baseboard Heating Availability Schedule Name"]

    @baseboard_heating_availability_schedule_name.setter
    def baseboard_heating_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Baseboard Heating Availability Schedule
        Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Baseboard Heating Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Availability Schedule Name"] = value

    @property
    def baseboard_heating_capacity(self):
        """Get baseboard_heating_capacity.

        Returns:
            float: the value of `baseboard_heating_capacity` or None if not set

        """
        return self["Baseboard Heating Capacity"]

    @baseboard_heating_capacity.setter
    def baseboard_heating_capacity(self, value="autosize"):
        """Corresponds to IDD field `Baseboard Heating Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Baseboard Heating Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Capacity"] = value




class HvactemplateZoneWaterToAirHeatPump(DataObject):

    """ Corresponds to IDD object `HVACTemplate:Zone:WaterToAirHeatPump`
        Water to Air Heat Pump to be used with HVACTemplate:Plant:MixedWaterLoop
    """
    schema = {'min-fields': 44,
              'name': u'HVACTemplate:Zone:WaterToAirHeatPump',
              'pyname': u'HvactemplateZoneWaterToAirHeatPump',
              'format': None,
              'fields': OrderedDict([(u'zone name',
                                      {'name': u'Zone Name',
                                       'pyname': u'zone_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template thermostat name',
                                      {'name': u'Template Thermostat Name',
                                       'pyname': u'template_thermostat_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'cooling supply air flow rate',
                                      {'name': u'Cooling Supply Air Flow Rate',
                                       'pyname': u'cooling_supply_air_flow_rate',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'heating supply air flow rate',
                                      {'name': u'Heating Supply Air Flow Rate',
                                       'pyname': u'heating_supply_air_flow_rate',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'no load supply air flow rate',
                                      {'name': u'No Load Supply Air Flow Rate',
                                       'pyname': u'no_load_supply_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'zone heating sizing factor',
                                      {'name': u'Zone Heating Sizing Factor',
                                       'pyname': u'zone_heating_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'zone cooling sizing factor',
                                      {'name': u'Zone Cooling Sizing Factor',
                                       'pyname': u'zone_cooling_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'outdoor air method',
                                      {'name': u'Outdoor Air Method',
                                       'pyname': u'outdoor_air_method',
                                       'default': u'Flow/Person',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Flow/Person',
                                                           u'Flow/Zone',
                                                           u'Flow/Area',
                                                           u'Sum',
                                                           u'Maximum',
                                                           u'DetailedSpecification'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'outdoor air flow rate per person',
                                      {'name': u'Outdoor Air Flow Rate per Person',
                                       'pyname': u'outdoor_air_flow_rate_per_person',
                                       'default': 0.00944,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate per zone floor area',
                                      {'name': u'Outdoor Air Flow Rate per Zone Floor Area',
                                       'pyname': u'outdoor_air_flow_rate_per_zone_floor_area',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s-m2'}),
                                     (u'outdoor air flow rate per zone',
                                      {'name': u'Outdoor Air Flow Rate per Zone',
                                       'pyname': u'outdoor_air_flow_rate_per_zone',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'system availability schedule name',
                                      {'name': u'System Availability Schedule Name',
                                       'pyname': u'system_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply fan operating mode schedule name',
                                      {'name': u'Supply Fan Operating Mode Schedule Name',
                                       'pyname': u'supply_fan_operating_mode_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply fan placement',
                                      {'name': u'Supply Fan Placement',
                                       'pyname': u'supply_fan_placement',
                                       'default': u'DrawThrough',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'BlowThrough',
                                                           u'DrawThrough'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'supply fan total efficiency',
                                      {'name': u'Supply Fan Total Efficiency',
                                       'pyname': u'supply_fan_total_efficiency',
                                       'default': 0.7,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supply fan delta pressure',
                                      {'name': u'Supply Fan Delta Pressure',
                                       'pyname': u'supply_fan_delta_pressure',
                                       'default': 75.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'Pa'}),
                                     (u'supply fan motor efficiency',
                                      {'name': u'Supply Fan Motor Efficiency',
                                       'pyname': u'supply_fan_motor_efficiency',
                                       'default': 0.9,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'cooling coil type',
                                      {'name': u'Cooling Coil Type',
                                       'pyname': u'cooling_coil_type',
                                       'default': u'Coil:Cooling:WaterToAirHeatPump:EquationFit',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Coil:Cooling:WaterToAirHeatPump:EquationFit'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'cooling coil gross rated total capacity',
                                      {'name': u'Cooling Coil Gross Rated Total Capacity',
                                       'pyname': u'cooling_coil_gross_rated_total_capacity',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'cooling coil gross rated sensible heat ratio',
                                      {'name': u'Cooling Coil Gross Rated Sensible Heat Ratio',
                                       'pyname': u'cooling_coil_gross_rated_sensible_heat_ratio',
                                       'default': 'autosize',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.5,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'cooling coil gross rated cop',
                                      {'name': u'Cooling Coil Gross Rated COP',
                                       'pyname': u'cooling_coil_gross_rated_cop',
                                       'default': 3.5,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'heat pump heating coil type',
                                      {'name': u'Heat Pump Heating Coil Type',
                                       'pyname': u'heat_pump_heating_coil_type',
                                       'default': u'Coil:Heating:WaterToAirHeatPump:EquationFit',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Coil:Heating:WaterToAirHeatPump:EquationFit'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heat pump heating coil gross rated capacity',
                                      {'name': u'Heat Pump Heating Coil Gross Rated Capacity',
                                       'pyname': u'heat_pump_heating_coil_gross_rated_capacity',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'heat pump heating coil gross rated cop',
                                      {'name': u'Heat Pump Heating Coil Gross Rated COP',
                                       'pyname': u'heat_pump_heating_coil_gross_rated_cop',
                                       'default': 4.2,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W/W'}),
                                     (u'supplemental heating coil availability schedule name',
                                      {'name': u'Supplemental Heating Coil Availability Schedule Name',
                                       'pyname': u'supplemental_heating_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supplemental heating coil capacity',
                                      {'name': u'Supplemental Heating Coil Capacity',
                                       'pyname': u'supplemental_heating_coil_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'maximum cycling rate',
                                      {'name': u'Maximum Cycling Rate',
                                       'pyname': u'maximum_cycling_rate',
                                       'default': 2.5,
                                       'maximum': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'cycles/hr'}),
                                     (u'heat pump time constant',
                                      {'name': u'Heat Pump Time Constant',
                                       'pyname': u'heat_pump_time_constant',
                                       'default': 60.0,
                                       'maximum': 500.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u's'}),
                                     (u'fraction of on-cycle power use',
                                      {'name': u'Fraction of On-Cycle Power Use',
                                       'pyname': u'fraction_of_oncycle_power_use',
                                       'default': 0.01,
                                       'maximum': 0.05,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'heat pump fan delay time',
                                      {'name': u'Heat Pump Fan Delay Time',
                                       'pyname': u'heat_pump_fan_delay_time',
                                       'default': 60.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u's'}),
                                     (u'dedicated outdoor air system name',
                                      {'name': u'Dedicated Outdoor Air System Name',
                                       'pyname': u'dedicated_outdoor_air_system_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supplemental heating coil type',
                                      {'name': u'Supplemental Heating Coil Type',
                                       'pyname': u'supplemental_heating_coil_type',
                                       'default': u'Electric',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Electric',
                                                           u'HotWater'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone cooling design supply air temperature input method',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_input_method',
                                       'default': u'SupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone cooling design supply air temperature',
                                      {'name': u'Zone Cooling Design Supply Air Temperature',
                                       'pyname': u'zone_cooling_design_supply_air_temperature',
                                       'default': 14.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone cooling design supply air temperature difference',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Difference',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_difference',
                                       'default': 11.11,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'zone heating design supply air temperature input method',
                                      {'name': u'Zone Heating Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_heating_design_supply_air_temperature_input_method',
                                       'default': u'SupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone heating design supply air temperature',
                                      {'name': u'Zone Heating Design Supply Air Temperature',
                                       'pyname': u'zone_heating_design_supply_air_temperature',
                                       'default': 50.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone heating design supply air temperature difference',
                                      {'name': u'Zone Heating Design Supply Air Temperature Difference',
                                       'pyname': u'zone_heating_design_supply_air_temperature_difference',
                                       'default': 30.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'heat pump coil water flow mode',
                                      {'name': u'Heat Pump Coil Water Flow Mode',
                                       'pyname': u'heat_pump_coil_water_flow_mode',
                                       'default': u'Cycling',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Constant',
                                                           u'Cycling',
                                                           u'ConstantOnDemand'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'design specification outdoor air object name',
                                      {'name': u'Design Specification Outdoor Air Object Name',
                                       'pyname': u'design_specification_outdoor_air_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'design specification zone air distribution object name',
                                      {'name': u'Design Specification Zone Air Distribution Object Name',
                                       'pyname': u'design_specification_zone_air_distribution_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating type',
                                      {'name': u'Baseboard Heating Type',
                                       'pyname': u'baseboard_heating_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'baseboard heating availability schedule name',
                                      {'name': u'Baseboard Heating Availability Schedule Name',
                                       'pyname': u'baseboard_heating_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating capacity',
                                      {'name': u'Baseboard Heating Capacity',
                                       'pyname': u'baseboard_heating_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def zone_name(self):
        """Get zone_name.

        Returns:
            str: the value of `zone_name` or None if not set

        """
        return self["Zone Name"]

    @zone_name.setter
    def zone_name(self, value=None):
        """Corresponds to IDD field `Zone Name` Zone name must match a building
        zone name.

        Args:
            value (str): value for IDD Field `Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Name"] = value

    @property
    def template_thermostat_name(self):
        """Get template_thermostat_name.

        Returns:
            str: the value of `template_thermostat_name` or None if not set

        """
        return self["Template Thermostat Name"]

    @template_thermostat_name.setter
    def template_thermostat_name(self, value=None):
        """  Corresponds to IDD field `Template Thermostat Name`
        Enter the name of a HVACTemplate:Thermostat object.
        If blank, then it is assumed that standard thermostat objects
        have been defined for this zone.

        Args:
            value (str): value for IDD Field `Template Thermostat Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Thermostat Name"] = value

    @property
    def cooling_supply_air_flow_rate(self):
        """Get cooling_supply_air_flow_rate.

        Returns:
            float: the value of `cooling_supply_air_flow_rate` or None if not set

        """
        return self["Cooling Supply Air Flow Rate"]

    @cooling_supply_air_flow_rate.setter
    def cooling_supply_air_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Cooling Supply Air Flow Rate` Supply air
        flow rate during cooling operation This field may be set to "autosize".
        If a value is entered, it will be multiplied by the Supply Air Sizing
        Factor and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Supply Air Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Supply Air Flow Rate"] = value

    @property
    def heating_supply_air_flow_rate(self):
        """Get heating_supply_air_flow_rate.

        Returns:
            float: the value of `heating_supply_air_flow_rate` or None if not set

        """
        return self["Heating Supply Air Flow Rate"]

    @heating_supply_air_flow_rate.setter
    def heating_supply_air_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Heating Supply Air Flow Rate` Supply air
        flow rate during heating operation This field may be set to "autosize".
        If a value is entered, it will be multiplied by the Supply Air Sizing
        Factor and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Heating Supply Air Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Supply Air Flow Rate"] = value

    @property
    def no_load_supply_air_flow_rate(self):
        """Get no_load_supply_air_flow_rate.

        Returns:
            float: the value of `no_load_supply_air_flow_rate` or None if not set

        """
        return self["No Load Supply Air Flow Rate"]

    @no_load_supply_air_flow_rate.setter
    def no_load_supply_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `No Load Supply Air Flow Rate`
        Supply air flow rate when no cooling or heating is needed
        Only used when heat pump fan operating mode is continuous. This air flow rate
        is used when no heating or cooling is required.
        If this field is left blank or zero, the supply air flow rate from the previous on cycle
        (either cooling or heating) is used.
        A value entered in this field will *not* be multiplied by the sizing factor or
        by zone multipliers.  It is best to autosize or leave blank when using zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `No Load Supply Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["No Load Supply Air Flow Rate"] = value

    @property
    def zone_heating_sizing_factor(self):
        """Get zone_heating_sizing_factor.

        Returns:
            float: the value of `zone_heating_sizing_factor` or None if not set

        """
        return self["Zone Heating Sizing Factor"]

    @zone_heating_sizing_factor.setter
    def zone_heating_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Heating Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Heating Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Sizing Factor"] = value

    @property
    def zone_cooling_sizing_factor(self):
        """Get zone_cooling_sizing_factor.

        Returns:
            float: the value of `zone_cooling_sizing_factor` or None if not set

        """
        return self["Zone Cooling Sizing Factor"]

    @zone_cooling_sizing_factor.setter
    def zone_cooling_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Cooling Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Cooling Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Sizing Factor"] = value

    @property
    def outdoor_air_method(self):
        """Get outdoor_air_method.

        Returns:
            str: the value of `outdoor_air_method` or None if not set

        """
        return self["Outdoor Air Method"]

    @outdoor_air_method.setter
    def outdoor_air_method(self, value="Flow/Person"):
        """  Corresponds to IDD field `Outdoor Air Method`
        Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
        fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
        and Outdoor Air Flow Rate per Zone.
        DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
        references design specification objects named in the fields
        Design Specification Outdoor Air Object Name and Design Specification Zone Air
        Distribution Object Name.

        Args:
            value (str): value for IDD Field `Outdoor Air Method`
                Default value: Flow/Person
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Method"] = value

    @property
    def outdoor_air_flow_rate_per_person(self):
        """Get outdoor_air_flow_rate_per_person.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_person` or None if not set

        """
        return self["Outdoor Air Flow Rate per Person"]

    @outdoor_air_flow_rate_per_person.setter
    def outdoor_air_flow_rate_per_person(self, value=0.00944):
        """  Corresponds to IDD field `Outdoor Air Flow Rate per Person`
        Default 0.00944 is 20 cfm per person
        This input is used if the field Outdoor Air Method is
        Flow/Person, Sum, or Maximum

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Person`
                Units: m3/s
                Default value: 0.00944
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Flow Rate per Person"] = value

    @property
    def outdoor_air_flow_rate_per_zone_floor_area(self):
        """Get outdoor_air_flow_rate_per_zone_floor_area.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone_floor_area` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone Floor Area"]

    @outdoor_air_flow_rate_per_zone_floor_area.setter
    def outdoor_air_flow_rate_per_zone_floor_area(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone Floor Area`
        This input is used if the field Outdoor Air Method is Flow/Area, Sum,
        or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone Floor Area`
                Units: m3/s-m2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone Floor Area"] = value

    @property
    def outdoor_air_flow_rate_per_zone(self):
        """Get outdoor_air_flow_rate_per_zone.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone"]

    @outdoor_air_flow_rate_per_zone.setter
    def outdoor_air_flow_rate_per_zone(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone` This input
        is used if the field Outdoor Air Method is Flow/Zone, Sum, or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone"] = value

    @property
    def system_availability_schedule_name(self):
        """Get system_availability_schedule_name.

        Returns:
            str: the value of `system_availability_schedule_name` or None if not set

        """
        return self["System Availability Schedule Name"]

    @system_availability_schedule_name.setter
    def system_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `System Availability Schedule Name` If
        blank, always on.

        Args:
            value (str): value for IDD Field `System Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["System Availability Schedule Name"] = value

    @property
    def supply_fan_operating_mode_schedule_name(self):
        """Get supply_fan_operating_mode_schedule_name.

        Returns:
            str: the value of `supply_fan_operating_mode_schedule_name` or None if not set

        """
        return self["Supply Fan Operating Mode Schedule Name"]

    @supply_fan_operating_mode_schedule_name.setter
    def supply_fan_operating_mode_schedule_name(self, value=None):
        """Corresponds to IDD field `Supply Fan Operating Mode Schedule Name`
        Refers to a schedule to specify unitary supply fan operating mode.
        Schedule values of 0 indicate cycling fan (auto) Schedule values of 1
        indicate continuous fan (on) If this field is left blank, a schedule of
        always zero (cycling fan) will be used.

        Args:
            value (str): value for IDD Field `Supply Fan Operating Mode Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Operating Mode Schedule Name"] = value

    @property
    def supply_fan_placement(self):
        """Get supply_fan_placement.

        Returns:
            str: the value of `supply_fan_placement` or None if not set

        """
        return self["Supply Fan Placement"]

    @supply_fan_placement.setter
    def supply_fan_placement(self, value="DrawThrough"):
        """Corresponds to IDD field `Supply Fan Placement`

        Args:
            value (str): value for IDD Field `Supply Fan Placement`
                Default value: DrawThrough
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Placement"] = value

    @property
    def supply_fan_total_efficiency(self):
        """Get supply_fan_total_efficiency.

        Returns:
            float: the value of `supply_fan_total_efficiency` or None if not set

        """
        return self["Supply Fan Total Efficiency"]

    @supply_fan_total_efficiency.setter
    def supply_fan_total_efficiency(self, value=0.7):
        """Corresponds to IDD field `Supply Fan Total Efficiency`

        Args:
            value (float): value for IDD Field `Supply Fan Total Efficiency`
                Default value: 0.7
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Total Efficiency"] = value

    @property
    def supply_fan_delta_pressure(self):
        """Get supply_fan_delta_pressure.

        Returns:
            float: the value of `supply_fan_delta_pressure` or None if not set

        """
        return self["Supply Fan Delta Pressure"]

    @supply_fan_delta_pressure.setter
    def supply_fan_delta_pressure(self, value=75.0):
        """Corresponds to IDD field `Supply Fan Delta Pressure`

        Args:
            value (float): value for IDD Field `Supply Fan Delta Pressure`
                Units: Pa
                IP-Units: inH2O
                Default value: 75.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Delta Pressure"] = value

    @property
    def supply_fan_motor_efficiency(self):
        """Get supply_fan_motor_efficiency.

        Returns:
            float: the value of `supply_fan_motor_efficiency` or None if not set

        """
        return self["Supply Fan Motor Efficiency"]

    @supply_fan_motor_efficiency.setter
    def supply_fan_motor_efficiency(self, value=0.9):
        """Corresponds to IDD field `Supply Fan Motor Efficiency`

        Args:
            value (float): value for IDD Field `Supply Fan Motor Efficiency`
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Motor Efficiency"] = value

    @property
    def cooling_coil_type(self):
        """Get cooling_coil_type.

        Returns:
            str: the value of `cooling_coil_type` or None if not set

        """
        return self["Cooling Coil Type"]

    @cooling_coil_type.setter
    def cooling_coil_type(
            self,
            value="Coil:Cooling:WaterToAirHeatPump:EquationFit"):
        """Corresponds to IDD field `Cooling Coil Type`

        Args:
            value (str): value for IDD Field `Cooling Coil Type`
                Default value: Coil:Cooling:WaterToAirHeatPump:EquationFit
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Type"] = value

    @property
    def cooling_coil_gross_rated_total_capacity(self):
        """Get cooling_coil_gross_rated_total_capacity.

        Returns:
            float: the value of `cooling_coil_gross_rated_total_capacity` or None if not set

        """
        return self["Cooling Coil Gross Rated Total Capacity"]

    @cooling_coil_gross_rated_total_capacity.setter
    def cooling_coil_gross_rated_total_capacity(self, value="autosize"):
        """Corresponds to IDD field `Cooling Coil Gross Rated Total Capacity`
        Total cooling capacity not accounting for the effect of supply air fan
        heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Coil Gross Rated Total Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Gross Rated Total Capacity"] = value

    @property
    def cooling_coil_gross_rated_sensible_heat_ratio(self):
        """Get cooling_coil_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `cooling_coil_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Cooling Coil Gross Rated Sensible Heat Ratio"]

    @cooling_coil_gross_rated_sensible_heat_ratio.setter
    def cooling_coil_gross_rated_sensible_heat_ratio(self, value="autosize"):
        """Corresponds to IDD field `Cooling Coil Gross Rated Sensible Heat
        Ratio` Rated sensible heat ratio (gross sensible capacity/gross total
        capacity) Sensible and total capacities do not include effect of supply
        fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Coil Gross Rated Sensible Heat Ratio`
                Default value: "autosize"
                value >= 0.5
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Gross Rated Sensible Heat Ratio"] = value

    @property
    def cooling_coil_gross_rated_cop(self):
        """Get cooling_coil_gross_rated_cop.

        Returns:
            float: the value of `cooling_coil_gross_rated_cop` or None if not set

        """
        return self["Cooling Coil Gross Rated COP"]

    @cooling_coil_gross_rated_cop.setter
    def cooling_coil_gross_rated_cop(self, value=3.5):
        """Corresponds to IDD field `Cooling Coil Gross Rated COP` Gross
        cooling capacity divided by power input to the compressor and outdoor
        fan, does not include supply fan heat or supply fan electric power
        input.

        Args:
            value (float): value for IDD Field `Cooling Coil Gross Rated COP`
                Units: W/W
                Default value: 3.5
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Gross Rated COP"] = value

    @property
    def heat_pump_heating_coil_type(self):
        """Get heat_pump_heating_coil_type.

        Returns:
            str: the value of `heat_pump_heating_coil_type` or None if not set

        """
        return self["Heat Pump Heating Coil Type"]

    @heat_pump_heating_coil_type.setter
    def heat_pump_heating_coil_type(
            self,
            value="Coil:Heating:WaterToAirHeatPump:EquationFit"):
        """Corresponds to IDD field `Heat Pump Heating Coil Type`

        Args:
            value (str): value for IDD Field `Heat Pump Heating Coil Type`
                Default value: Coil:Heating:WaterToAirHeatPump:EquationFit
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Heating Coil Type"] = value

    @property
    def heat_pump_heating_coil_gross_rated_capacity(self):
        """Get heat_pump_heating_coil_gross_rated_capacity.

        Returns:
            float: the value of `heat_pump_heating_coil_gross_rated_capacity` or None if not set

        """
        return self["Heat Pump Heating Coil Gross Rated Capacity"]

    @heat_pump_heating_coil_gross_rated_capacity.setter
    def heat_pump_heating_coil_gross_rated_capacity(self, value="autosize"):
        """Corresponds to IDD field `Heat Pump Heating Coil Gross Rated
        Capacity` Capacity excluding supply air fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Heat Pump Heating Coil Gross Rated Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Heating Coil Gross Rated Capacity"] = value

    @property
    def heat_pump_heating_coil_gross_rated_cop(self):
        """Get heat_pump_heating_coil_gross_rated_cop.

        Returns:
            float: the value of `heat_pump_heating_coil_gross_rated_cop` or None if not set

        """
        return self["Heat Pump Heating Coil Gross Rated COP"]

    @heat_pump_heating_coil_gross_rated_cop.setter
    def heat_pump_heating_coil_gross_rated_cop(self, value=4.2):
        """Corresponds to IDD field `Heat Pump Heating Coil Gross Rated COP`
        Heat Pump Heating Coil Rated Capacity divided by power input to the
        compressor and outdoor fan, does not include supply air fan heat or
        supply air fan electric power input.

        Args:
            value (float): value for IDD Field `Heat Pump Heating Coil Gross Rated COP`
                Units: W/W
                Default value: 4.2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Heating Coil Gross Rated COP"] = value

    @property
    def supplemental_heating_coil_availability_schedule_name(self):
        """Get supplemental_heating_coil_availability_schedule_name.

        Returns:
            str: the value of `supplemental_heating_coil_availability_schedule_name` or None if not set

        """
        return self["Supplemental Heating Coil Availability Schedule Name"]

    @supplemental_heating_coil_availability_schedule_name.setter
    def supplemental_heating_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Supplemental Heating Coil Availability
        Schedule Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Supplemental Heating Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supplemental Heating Coil Availability Schedule Name"] = value

    @property
    def supplemental_heating_coil_capacity(self):
        """Get supplemental_heating_coil_capacity.

        Returns:
            float: the value of `supplemental_heating_coil_capacity` or None if not set

        """
        return self["Supplemental Heating Coil Capacity"]

    @supplemental_heating_coil_capacity.setter
    def supplemental_heating_coil_capacity(self, value="autosize"):
        """Corresponds to IDD field `Supplemental Heating Coil Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Supplemental Heating Coil Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supplemental Heating Coil Capacity"] = value

    @property
    def maximum_cycling_rate(self):
        """Get maximum_cycling_rate.

        Returns:
            float: the value of `maximum_cycling_rate` or None if not set

        """
        return self["Maximum Cycling Rate"]

    @maximum_cycling_rate.setter
    def maximum_cycling_rate(self, value=2.5):
        """  Corresponds to IDD field `Maximum Cycling Rate`
        The maximum on-off cycling rate for the compressor
        Suggested value is 2.5 for a typical heat pump

        Args:
            value (float): value for IDD Field `Maximum Cycling Rate`
                Units: cycles/hr
                Default value: 2.5
                value <= 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Maximum Cycling Rate"] = value

    @property
    def heat_pump_time_constant(self):
        """Get heat_pump_time_constant.

        Returns:
            float: the value of `heat_pump_time_constant` or None if not set

        """
        return self["Heat Pump Time Constant"]

    @heat_pump_time_constant.setter
    def heat_pump_time_constant(self, value=60.0):
        """Corresponds to IDD field `Heat Pump Time Constant` Time constant for
        the cooling coil's capacity to reach steady state after startup
        Suggested value is 60 for a typical heat pump.

        Args:
            value (float): value for IDD Field `Heat Pump Time Constant`
                Units: s
                Default value: 60.0
                value <= 500.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Time Constant"] = value

    @property
    def fraction_of_oncycle_power_use(self):
        """Get fraction_of_oncycle_power_use.

        Returns:
            float: the value of `fraction_of_oncycle_power_use` or None if not set

        """
        return self["Fraction of On-Cycle Power Use"]

    @fraction_of_oncycle_power_use.setter
    def fraction_of_oncycle_power_use(self, value=0.01):
        """  Corresponds to IDD field `Fraction of On-Cycle Power Use`
        The fraction of on-cycle power use to adjust the part load fraction based on
        the off-cycle power consumption due to crankcase heaters, controls, fans, and etc.
        Suggested value is 0.01 for a typical heat pump

        Args:
            value (float): value for IDD Field `Fraction of On-Cycle Power Use`
                Default value: 0.01
                value <= 0.05
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Fraction of On-Cycle Power Use"] = value

    @property
    def heat_pump_fan_delay_time(self):
        """Get heat_pump_fan_delay_time.

        Returns:
            float: the value of `heat_pump_fan_delay_time` or None if not set

        """
        return self["Heat Pump Fan Delay Time"]

    @heat_pump_fan_delay_time.setter
    def heat_pump_fan_delay_time(self, value=60.0):
        """Corresponds to IDD field `Heat Pump Fan Delay Time` Programmed time
        delay for heat pump fan to shut off after compressor cycle off. Only
        required when fan operating mode is cycling Enter 0 when fan operating
        mode is continuous.

        Args:
            value (float): value for IDD Field `Heat Pump Fan Delay Time`
                Units: s
                Default value: 60.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Fan Delay Time"] = value

    @property
    def dedicated_outdoor_air_system_name(self):
        """Get dedicated_outdoor_air_system_name.

        Returns:
            str: the value of `dedicated_outdoor_air_system_name` or None if not set

        """
        return self["Dedicated Outdoor Air System Name"]

    @dedicated_outdoor_air_system_name.setter
    def dedicated_outdoor_air_system_name(self, value=None):
        """  Corresponds to IDD field `Dedicated Outdoor Air System Name`
        Enter the name of an HVACTemplate:System:DedicatedOutdoorAir object if this
        zone is served by a separate dedicated outdoor air system (DOAS).
        Leave field blank if no DOAS serves this zone.

        Args:
            value (str): value for IDD Field `Dedicated Outdoor Air System Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Dedicated Outdoor Air System Name"] = value

    @property
    def supplemental_heating_coil_type(self):
        """Get supplemental_heating_coil_type.

        Returns:
            str: the value of `supplemental_heating_coil_type` or None if not set

        """
        return self["Supplemental Heating Coil Type"]

    @supplemental_heating_coil_type.setter
    def supplemental_heating_coil_type(self, value="Electric"):
        """Corresponds to IDD field `Supplemental Heating Coil Type`

        Args:
            value (str): value for IDD Field `Supplemental Heating Coil Type`
                Default value: Electric
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supplemental Heating Coil Type"] = value

    @property
    def zone_cooling_design_supply_air_temperature_input_method(self):
        """Get zone_cooling_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_cooling_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Input Method"]

    @zone_cooling_design_supply_air_temperature_input_method.setter
    def zone_cooling_design_supply_air_temperature_input_method(
            self,
            value="SupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference

        Args:
            value (str): value for IDD Field `Zone Cooling Design Supply Air Temperature Input Method`
                Default value: SupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Input Method"] = value

    @property
    def zone_cooling_design_supply_air_temperature(self):
        """Get zone_cooling_design_supply_air_temperature.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature"]

    @zone_cooling_design_supply_air_temperature.setter
    def zone_cooling_design_supply_air_temperature(self, value=14.0):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature`
                Units: C
                Default value: 14.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature"] = value

    @property
    def zone_cooling_design_supply_air_temperature_difference(self):
        """Get zone_cooling_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Difference"]

    @zone_cooling_design_supply_air_temperature_difference.setter
    def zone_cooling_design_supply_air_temperature_difference(
            self,
            value=11.11):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Difference`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be subtracted from the zone temperature
        at peak load to calculate the Zone Cooling Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 11.11
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Difference"] = value

    @property
    def zone_heating_design_supply_air_temperature_input_method(self):
        """Get zone_heating_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_heating_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Input Method"]

    @zone_heating_design_supply_air_temperature_input_method.setter
    def zone_heating_design_supply_air_temperature_input_method(
            self,
            value="SupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference

        Args:
            value (str): value for IDD Field `Zone Heating Design Supply Air Temperature Input Method`
                Default value: SupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Input Method"] = value

    @property
    def zone_heating_design_supply_air_temperature(self):
        """Get zone_heating_design_supply_air_temperature.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature"]

    @zone_heating_design_supply_air_temperature.setter
    def zone_heating_design_supply_air_temperature(self, value=50.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature`
                Units: C
                Default value: 50.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature"] = value

    @property
    def zone_heating_design_supply_air_temperature_difference(self):
        """Get zone_heating_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Difference"]

    @zone_heating_design_supply_air_temperature_difference.setter
    def zone_heating_design_supply_air_temperature_difference(
            self,
            value=30.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Difference`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be added to the zone temperature
        at peak load to calculate the Zone Heating Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 30.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Difference"] = value

    @property
    def heat_pump_coil_water_flow_mode(self):
        """Get heat_pump_coil_water_flow_mode.

        Returns:
            str: the value of `heat_pump_coil_water_flow_mode` or None if not set

        """
        return self["Heat Pump Coil Water Flow Mode"]

    @heat_pump_coil_water_flow_mode.setter
    def heat_pump_coil_water_flow_mode(self, value="Cycling"):
        """  Corresponds to IDD field `Heat Pump Coil Water Flow Mode`
        used only when the heat pump coils are of the type WaterToAirHeatPump:EquationFit
        Constant results in 100% water flow regardless of compressor PLR
        Cycling results in water flow that matches compressor PLR
        ConstantOnDemand results in 100% water flow whenever the coil is on, but is 0% whenever the coil has no load

        Args:
            value (str): value for IDD Field `Heat Pump Coil Water Flow Mode`
                Default value: Cycling
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Heat Pump Coil Water Flow Mode"] = value

    @property
    def design_specification_outdoor_air_object_name(self):
        """Get design_specification_outdoor_air_object_name.

        Returns:
            str: the value of `design_specification_outdoor_air_object_name` or None if not set

        """
        return self["Design Specification Outdoor Air Object Name"]

    @design_specification_outdoor_air_object_name.setter
    def design_specification_outdoor_air_object_name(self, value=None):
        """  Corresponds to IDD field `Design Specification Outdoor Air Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Outdoor Air Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Outdoor Air Object Name"] = value

    @property
    def design_specification_zone_air_distribution_object_name(self):
        """Get design_specification_zone_air_distribution_object_name.

        Returns:
            str: the value of `design_specification_zone_air_distribution_object_name` or None if not set

        """
        return self["Design Specification Zone Air Distribution Object Name"]

    @design_specification_zone_air_distribution_object_name.setter
    def design_specification_zone_air_distribution_object_name(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Zone Air Distribution Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Zone Air Distribution Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Zone Air Distribution Object Name"] = value

    @property
    def baseboard_heating_type(self):
        """Get baseboard_heating_type.

        Returns:
            str: the value of `baseboard_heating_type` or None if not set

        """
        return self["Baseboard Heating Type"]

    @baseboard_heating_type.setter
    def baseboard_heating_type(self, value="None"):
        """Corresponds to IDD field `Baseboard Heating Type`

        Args:
            value (str): value for IDD Field `Baseboard Heating Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Type"] = value

    @property
    def baseboard_heating_availability_schedule_name(self):
        """Get baseboard_heating_availability_schedule_name.

        Returns:
            str: the value of `baseboard_heating_availability_schedule_name` or None if not set

        """
        return self["Baseboard Heating Availability Schedule Name"]

    @baseboard_heating_availability_schedule_name.setter
    def baseboard_heating_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Baseboard Heating Availability Schedule
        Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Baseboard Heating Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Availability Schedule Name"] = value

    @property
    def baseboard_heating_capacity(self):
        """Get baseboard_heating_capacity.

        Returns:
            float: the value of `baseboard_heating_capacity` or None if not set

        """
        return self["Baseboard Heating Capacity"]

    @baseboard_heating_capacity.setter
    def baseboard_heating_capacity(self, value="autosize"):
        """Corresponds to IDD field `Baseboard Heating Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Baseboard Heating Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Capacity"] = value




class HvactemplateZoneVrf(DataObject):

    """ Corresponds to IDD object `HVACTemplate:Zone:VRF`
        Zone terminal unit with variable refrigerant flow (VRF) DX cooling and heating coils
        (air-to-air or water-to-air heat pump). The VRF terminal units are served by an
        HVACTemplate:System:VRF system.
    """
    schema = {'min-fields': 44,
              'name': u'HVACTemplate:Zone:VRF',
              'pyname': u'HvactemplateZoneVrf',
              'format': None,
              'fields': OrderedDict([(u'zone name',
                                      {'name': u'Zone Name',
                                       'pyname': u'zone_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template vrf system name',
                                      {'name': u'Template VRF System Name',
                                       'pyname': u'template_vrf_system_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template thermostat name',
                                      {'name': u'Template Thermostat Name',
                                       'pyname': u'template_thermostat_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'zone heating sizing factor',
                                      {'name': u'Zone Heating Sizing Factor',
                                       'pyname': u'zone_heating_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'zone cooling sizing factor',
                                      {'name': u'Zone Cooling Sizing Factor',
                                       'pyname': u'zone_cooling_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'rated total heating capacity sizing ratio',
                                      {'name': u'Rated Total Heating Capacity Sizing Ratio',
                                       'pyname': u'rated_total_heating_capacity_sizing_ratio',
                                       'default': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 1.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'supply air flow rate during cooling operation',
                                      {'name': u'Supply Air Flow Rate During Cooling Operation',
                                       'pyname': u'supply_air_flow_rate_during_cooling_operation',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'supply air flow rate when no cooling is needed',
                                      {'name': u'Supply Air Flow Rate When No Cooling is Needed',
                                       'pyname': u'supply_air_flow_rate_when_no_cooling_is_needed',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'supply air flow rate during heating operation',
                                      {'name': u'Supply Air Flow Rate During Heating Operation',
                                       'pyname': u'supply_air_flow_rate_during_heating_operation',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'supply air flow rate when no heating is needed',
                                      {'name': u'Supply Air Flow Rate When No Heating is Needed',
                                       'pyname': u'supply_air_flow_rate_when_no_heating_is_needed',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate during cooling operation',
                                      {'name': u'Outdoor Air Flow Rate During Cooling Operation',
                                       'pyname': u'outdoor_air_flow_rate_during_cooling_operation',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate during heating operation',
                                      {'name': u'Outdoor Air Flow Rate During Heating Operation',
                                       'pyname': u'outdoor_air_flow_rate_during_heating_operation',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate when no cooling or heating is needed',
                                      {'name': u'Outdoor Air Flow Rate When No Cooling or Heating is Needed',
                                       'pyname': u'outdoor_air_flow_rate_when_no_cooling_or_heating_is_needed',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air method',
                                      {'name': u'Outdoor Air Method',
                                       'pyname': u'outdoor_air_method',
                                       'default': u'Flow/Person',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Flow/Person',
                                                           u'Flow/Zone',
                                                           u'Flow/Area',
                                                           u'Sum',
                                                           u'Maximum',
                                                           u'DetailedSpecification'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'outdoor air flow rate per person',
                                      {'name': u'Outdoor Air Flow Rate per Person',
                                       'pyname': u'outdoor_air_flow_rate_per_person',
                                       'default': 0.00944,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate per zone floor area',
                                      {'name': u'Outdoor Air Flow Rate per Zone Floor Area',
                                       'pyname': u'outdoor_air_flow_rate_per_zone_floor_area',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s-m2'}),
                                     (u'outdoor air flow rate per zone',
                                      {'name': u'Outdoor Air Flow Rate per Zone',
                                       'pyname': u'outdoor_air_flow_rate_per_zone',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'design specification outdoor air object name',
                                      {'name': u'Design Specification Outdoor Air Object Name',
                                       'pyname': u'design_specification_outdoor_air_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'design specification zone air distribution object name',
                                      {'name': u'Design Specification Zone Air Distribution Object Name',
                                       'pyname': u'design_specification_zone_air_distribution_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'system availability schedule name',
                                      {'name': u'System Availability Schedule Name',
                                       'pyname': u'system_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply fan operating mode schedule name',
                                      {'name': u'Supply Fan Operating Mode Schedule Name',
                                       'pyname': u'supply_fan_operating_mode_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply air fan placement',
                                      {'name': u'Supply Air Fan placement',
                                       'pyname': u'supply_air_fan_placement',
                                       'default': u'BlowThrough',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'BlowThrough',
                                                           u'DrawThrough'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'supply fan total efficiency',
                                      {'name': u'Supply Fan Total Efficiency',
                                       'pyname': u'supply_fan_total_efficiency',
                                       'default': 0.7,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supply fan delta pressure',
                                      {'name': u'Supply Fan Delta Pressure',
                                       'pyname': u'supply_fan_delta_pressure',
                                       'default': 75.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'Pa'}),
                                     (u'supply fan motor efficiency',
                                      {'name': u'Supply Fan Motor Efficiency',
                                       'pyname': u'supply_fan_motor_efficiency',
                                       'default': 0.9,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'cooling coil type',
                                      {'name': u'Cooling Coil Type',
                                       'pyname': u'cooling_coil_type',
                                       'default': u'VariableRefrigerantFlowDX',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'VariableRefrigerantFlowDX',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'cooling coil availability schedule name',
                                      {'name': u'Cooling Coil Availability Schedule Name',
                                       'pyname': u'cooling_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'cooling coil gross rated total capacity',
                                      {'name': u'Cooling Coil Gross Rated Total Capacity',
                                       'pyname': u'cooling_coil_gross_rated_total_capacity',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'cooling coil gross rated sensible heat ratio',
                                      {'name': u'Cooling Coil Gross Rated Sensible Heat Ratio',
                                       'pyname': u'cooling_coil_gross_rated_sensible_heat_ratio',
                                       'default': 'autosize',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.5,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'heat pump heating coil type',
                                      {'name': u'Heat Pump Heating Coil Type',
                                       'pyname': u'heat_pump_heating_coil_type',
                                       'default': u'VariableRefrigerantFlowDX',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'VariableRefrigerantFlowDX',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heat pump heating coil availability schedule name',
                                      {'name': u'Heat Pump Heating Coil Availability Schedule Name',
                                       'pyname': u'heat_pump_heating_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'heat pump heating coil gross rated capacity',
                                      {'name': u'Heat Pump Heating Coil Gross Rated Capacity',
                                       'pyname': u'heat_pump_heating_coil_gross_rated_capacity',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'zone terminal unit on parasitic electric energy use',
                                      {'name': u'Zone Terminal Unit On Parasitic Electric Energy Use',
                                       'pyname': u'zone_terminal_unit_on_parasitic_electric_energy_use',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'zone terminal unit off parasitic electric energy use',
                                      {'name': u'Zone Terminal Unit Off Parasitic Electric Energy Use',
                                       'pyname': u'zone_terminal_unit_off_parasitic_electric_energy_use',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'dedicated outdoor air system name',
                                      {'name': u'Dedicated Outdoor Air System Name',
                                       'pyname': u'dedicated_outdoor_air_system_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'zone cooling design supply air temperature input method',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_input_method',
                                       'default': u'SupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone cooling design supply air temperature',
                                      {'name': u'Zone Cooling Design Supply Air Temperature',
                                       'pyname': u'zone_cooling_design_supply_air_temperature',
                                       'default': 14.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone cooling design supply air temperature difference',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Difference',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_difference',
                                       'default': 11.11,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'zone heating design supply air temperature input method',
                                      {'name': u'Zone Heating Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_heating_design_supply_air_temperature_input_method',
                                       'default': u'SupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone heating design supply air temperature',
                                      {'name': u'Zone Heating Design Supply Air Temperature',
                                       'pyname': u'zone_heating_design_supply_air_temperature',
                                       'default': 50.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone heating design supply air temperature difference',
                                      {'name': u'Zone Heating Design Supply Air Temperature Difference',
                                       'pyname': u'zone_heating_design_supply_air_temperature_difference',
                                       'default': 30.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'baseboard heating type',
                                      {'name': u'Baseboard Heating Type',
                                       'pyname': u'baseboard_heating_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'baseboard heating availability schedule name',
                                      {'name': u'Baseboard Heating Availability Schedule Name',
                                       'pyname': u'baseboard_heating_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating capacity',
                                      {'name': u'Baseboard Heating Capacity',
                                       'pyname': u'baseboard_heating_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def zone_name(self):
        """Get zone_name.

        Returns:
            str: the value of `zone_name` or None if not set

        """
        return self["Zone Name"]

    @zone_name.setter
    def zone_name(self, value=None):
        """Corresponds to IDD field `Zone Name` Zone name must match a building
        zone name.

        Args:
            value (str): value for IDD Field `Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Name"] = value

    @property
    def template_vrf_system_name(self):
        """Get template_vrf_system_name.

        Returns:
            str: the value of `template_vrf_system_name` or None if not set

        """
        return self["Template VRF System Name"]

    @template_vrf_system_name.setter
    def template_vrf_system_name(self, value=None):
        """  Corresponds to IDD field `Template VRF System Name`
        Name of a HVACTemplate:System:VRF object serving this zone

        Args:
            value (str): value for IDD Field `Template VRF System Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template VRF System Name"] = value

    @property
    def template_thermostat_name(self):
        """Get template_thermostat_name.

        Returns:
            str: the value of `template_thermostat_name` or None if not set

        """
        return self["Template Thermostat Name"]

    @template_thermostat_name.setter
    def template_thermostat_name(self, value=None):
        """  Corresponds to IDD field `Template Thermostat Name`
        Enter the name of a HVACTemplate:Thermostat object.
        If blank, then it is assumed that standard thermostat objects
        have been defined for this zone.

        Args:
            value (str): value for IDD Field `Template Thermostat Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Thermostat Name"] = value

    @property
    def zone_heating_sizing_factor(self):
        """Get zone_heating_sizing_factor.

        Returns:
            float: the value of `zone_heating_sizing_factor` or None if not set

        """
        return self["Zone Heating Sizing Factor"]

    @zone_heating_sizing_factor.setter
    def zone_heating_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Heating Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Heating Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Sizing Factor"] = value

    @property
    def zone_cooling_sizing_factor(self):
        """Get zone_cooling_sizing_factor.

        Returns:
            float: the value of `zone_cooling_sizing_factor` or None if not set

        """
        return self["Zone Cooling Sizing Factor"]

    @zone_cooling_sizing_factor.setter
    def zone_cooling_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Cooling Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Cooling Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Sizing Factor"] = value

    @property
    def rated_total_heating_capacity_sizing_ratio(self):
        """Get rated_total_heating_capacity_sizing_ratio.

        Returns:
            float: the value of `rated_total_heating_capacity_sizing_ratio` or None if not set

        """
        return self["Rated Total Heating Capacity Sizing Ratio"]

    @rated_total_heating_capacity_sizing_ratio.setter
    def rated_total_heating_capacity_sizing_ratio(self, value=1.0):
        """  Corresponds to IDD field `Rated Total Heating Capacity Sizing Ratio`
        If this terminal unit's heating coil is autosized, the heating capacity is sized
        to be equal to the cooling capacity multiplied by this sizing ratio.
        This input applies to the terminal unit heating coil and overrides the sizing
        ratio entered in the HVACTemplate:System:VRF object.

        Args:
            value (float): value for IDD Field `Rated Total Heating Capacity Sizing Ratio`
                Units: W/W
                Default value: 1.0
                value >= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Rated Total Heating Capacity Sizing Ratio"] = value

    @property
    def supply_air_flow_rate_during_cooling_operation(self):
        """Get supply_air_flow_rate_during_cooling_operation.

        Returns:
            float: the value of `supply_air_flow_rate_during_cooling_operation` or None if not set

        """
        return self["Supply Air Flow Rate During Cooling Operation"]

    @supply_air_flow_rate_during_cooling_operation.setter
    def supply_air_flow_rate_during_cooling_operation(self, value="autosize"):
        """Corresponds to IDD field `Supply Air Flow Rate During Cooling
        Operation` This field may be set to "autosize".  If a value is entered,
        it will be multiplied by the Supply Air Sizing Factor and by zone
        multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Supply Air Flow Rate During Cooling Operation`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Air Flow Rate During Cooling Operation"] = value

    @property
    def supply_air_flow_rate_when_no_cooling_is_needed(self):
        """Get supply_air_flow_rate_when_no_cooling_is_needed.

        Returns:
            float: the value of `supply_air_flow_rate_when_no_cooling_is_needed` or None if not set

        """
        return self["Supply Air Flow Rate When No Cooling is Needed"]

    @supply_air_flow_rate_when_no_cooling_is_needed.setter
    def supply_air_flow_rate_when_no_cooling_is_needed(self, value="autosize"):
        """Corresponds to IDD field `Supply Air Flow Rate When No Cooling is
        Needed` This flow rate is used when the terminal is not cooling and the
        previous mode was cooling. This field may be set to "autosize".  If a
        value is entered, it will be multiplied by the Supply Air Sizing Factor
        and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Supply Air Flow Rate When No Cooling is Needed`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Air Flow Rate When No Cooling is Needed"] = value

    @property
    def supply_air_flow_rate_during_heating_operation(self):
        """Get supply_air_flow_rate_during_heating_operation.

        Returns:
            float: the value of `supply_air_flow_rate_during_heating_operation` or None if not set

        """
        return self["Supply Air Flow Rate During Heating Operation"]

    @supply_air_flow_rate_during_heating_operation.setter
    def supply_air_flow_rate_during_heating_operation(self, value="autosize"):
        """Corresponds to IDD field `Supply Air Flow Rate During Heating
        Operation` This field may be set to "autosize".  If a value is entered,
        it will be multiplied by the Supply Air Sizing Factor and by zone
        multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Supply Air Flow Rate During Heating Operation`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Air Flow Rate During Heating Operation"] = value

    @property
    def supply_air_flow_rate_when_no_heating_is_needed(self):
        """Get supply_air_flow_rate_when_no_heating_is_needed.

        Returns:
            float: the value of `supply_air_flow_rate_when_no_heating_is_needed` or None if not set

        """
        return self["Supply Air Flow Rate When No Heating is Needed"]

    @supply_air_flow_rate_when_no_heating_is_needed.setter
    def supply_air_flow_rate_when_no_heating_is_needed(self, value="autosize"):
        """Corresponds to IDD field `Supply Air Flow Rate When No Heating is
        Needed` This flow rate is used when the terminal is not heating and the
        previous mode was heating. This field may be set to "autosize".  If a
        value is entered, it will be multiplied by the Supply Air Sizing Factor
        and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Supply Air Flow Rate When No Heating is Needed`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Air Flow Rate When No Heating is Needed"] = value

    @property
    def outdoor_air_flow_rate_during_cooling_operation(self):
        """Get outdoor_air_flow_rate_during_cooling_operation.

        Returns:
            float: the value of `outdoor_air_flow_rate_during_cooling_operation` or None if not set

        """
        return self["Outdoor Air Flow Rate During Cooling Operation"]

    @outdoor_air_flow_rate_during_cooling_operation.setter
    def outdoor_air_flow_rate_during_cooling_operation(self, value="autosize"):
        """Corresponds to IDD field `Outdoor Air Flow Rate During Cooling
        Operation` If this field is set to autosize it will be sized based on
        the outdoor air inputs below, unless a dedicated outdoor air system is
        specified for this zone and then it will be set to zero.

        Args:
            value (float or "Autosize"): value for IDD Field `Outdoor Air Flow Rate During Cooling Operation`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate During Cooling Operation"] = value

    @property
    def outdoor_air_flow_rate_during_heating_operation(self):
        """Get outdoor_air_flow_rate_during_heating_operation.

        Returns:
            float: the value of `outdoor_air_flow_rate_during_heating_operation` or None if not set

        """
        return self["Outdoor Air Flow Rate During Heating Operation"]

    @outdoor_air_flow_rate_during_heating_operation.setter
    def outdoor_air_flow_rate_during_heating_operation(self, value="autosize"):
        """Corresponds to IDD field `Outdoor Air Flow Rate During Heating
        Operation` If this field is set to autosize it will be sized based on
        the outdoor air inputs below, unless a dedicated outdoor air system is
        specified for this zone and then it will be set to zero.

        Args:
            value (float or "Autosize"): value for IDD Field `Outdoor Air Flow Rate During Heating Operation`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate During Heating Operation"] = value

    @property
    def outdoor_air_flow_rate_when_no_cooling_or_heating_is_needed(self):
        """Get outdoor_air_flow_rate_when_no_cooling_or_heating_is_needed.

        Returns:
            float: the value of `outdoor_air_flow_rate_when_no_cooling_or_heating_is_needed` or None if not set

        """
        return self[
            "Outdoor Air Flow Rate When No Cooling or Heating is Needed"]

    @outdoor_air_flow_rate_when_no_cooling_or_heating_is_needed.setter
    def outdoor_air_flow_rate_when_no_cooling_or_heating_is_needed(
            self,
            value="autosize"):
        """Corresponds to IDD field `Outdoor Air Flow Rate When No Cooling or
        Heating is Needed` If this field is set to autosize it will be sized
        based on the outdoor air inputs below, unless a dedicated outdoor air
        system is specified for this zone and then it will be set to zero.

        Args:
            value (float or "Autosize"): value for IDD Field `Outdoor Air Flow Rate When No Cooling or Heating is Needed`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Outdoor Air Flow Rate When No Cooling or Heating is Needed"] = value

    @property
    def outdoor_air_method(self):
        """Get outdoor_air_method.

        Returns:
            str: the value of `outdoor_air_method` or None if not set

        """
        return self["Outdoor Air Method"]

    @outdoor_air_method.setter
    def outdoor_air_method(self, value="Flow/Person"):
        """  Corresponds to IDD field `Outdoor Air Method`
        Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
        fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
        and Outdoor Air Flow Rate per Zone.
        DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
        references design specification objects named in the fields
        Design Specification Outdoor Air Object Name and Design Specification Zone Air
        Distribution Object Name.

        Args:
            value (str): value for IDD Field `Outdoor Air Method`
                Default value: Flow/Person
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Method"] = value

    @property
    def outdoor_air_flow_rate_per_person(self):
        """Get outdoor_air_flow_rate_per_person.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_person` or None if not set

        """
        return self["Outdoor Air Flow Rate per Person"]

    @outdoor_air_flow_rate_per_person.setter
    def outdoor_air_flow_rate_per_person(self, value=0.00944):
        """  Corresponds to IDD field `Outdoor Air Flow Rate per Person`
        Default 0.00944 is 20 cfm per person
        This input is used if the field Outdoor Air Method is
        Flow/Person, Sum, or Maximum

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Person`
                Units: m3/s
                Default value: 0.00944
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Flow Rate per Person"] = value

    @property
    def outdoor_air_flow_rate_per_zone_floor_area(self):
        """Get outdoor_air_flow_rate_per_zone_floor_area.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone_floor_area` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone Floor Area"]

    @outdoor_air_flow_rate_per_zone_floor_area.setter
    def outdoor_air_flow_rate_per_zone_floor_area(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone Floor Area`
        This input is used if the field Outdoor Air Method is Flow/Area, Sum,
        or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone Floor Area`
                Units: m3/s-m2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone Floor Area"] = value

    @property
    def outdoor_air_flow_rate_per_zone(self):
        """Get outdoor_air_flow_rate_per_zone.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone"]

    @outdoor_air_flow_rate_per_zone.setter
    def outdoor_air_flow_rate_per_zone(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone` This input
        is used if the field Outdoor Air Method is Flow/Zone, Sum, or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone"] = value

    @property
    def design_specification_outdoor_air_object_name(self):
        """Get design_specification_outdoor_air_object_name.

        Returns:
            str: the value of `design_specification_outdoor_air_object_name` or None if not set

        """
        return self["Design Specification Outdoor Air Object Name"]

    @design_specification_outdoor_air_object_name.setter
    def design_specification_outdoor_air_object_name(self, value=None):
        """  Corresponds to IDD field `Design Specification Outdoor Air Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Outdoor Air Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Outdoor Air Object Name"] = value

    @property
    def design_specification_zone_air_distribution_object_name(self):
        """Get design_specification_zone_air_distribution_object_name.

        Returns:
            str: the value of `design_specification_zone_air_distribution_object_name` or None if not set

        """
        return self["Design Specification Zone Air Distribution Object Name"]

    @design_specification_zone_air_distribution_object_name.setter
    def design_specification_zone_air_distribution_object_name(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Zone Air Distribution Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Zone Air Distribution Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Zone Air Distribution Object Name"] = value

    @property
    def system_availability_schedule_name(self):
        """Get system_availability_schedule_name.

        Returns:
            str: the value of `system_availability_schedule_name` or None if not set

        """
        return self["System Availability Schedule Name"]

    @system_availability_schedule_name.setter
    def system_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `System Availability Schedule Name` If
        blank, always on.

        Args:
            value (str): value for IDD Field `System Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["System Availability Schedule Name"] = value

    @property
    def supply_fan_operating_mode_schedule_name(self):
        """Get supply_fan_operating_mode_schedule_name.

        Returns:
            str: the value of `supply_fan_operating_mode_schedule_name` or None if not set

        """
        return self["Supply Fan Operating Mode Schedule Name"]

    @supply_fan_operating_mode_schedule_name.setter
    def supply_fan_operating_mode_schedule_name(self, value=None):
        """Corresponds to IDD field `Supply Fan Operating Mode Schedule Name`
        Refers to a schedule to specify unitary supply fan operating mode.
        Schedule values of 0 indicate cycling fan (auto) Schedule values of 1
        indicate continuous fan (on) If this field is left blank, a schedule of
        always zero (cycling fan) will be used.

        Args:
            value (str): value for IDD Field `Supply Fan Operating Mode Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Operating Mode Schedule Name"] = value

    @property
    def supply_air_fan_placement(self):
        """Get supply_air_fan_placement.

        Returns:
            str: the value of `supply_air_fan_placement` or None if not set

        """
        return self["Supply Air Fan placement"]

    @supply_air_fan_placement.setter
    def supply_air_fan_placement(self, value="BlowThrough"):
        """Corresponds to IDD field `Supply Air Fan placement` Select fan
        placement as either blow through or draw through.

        Args:
            value (str): value for IDD Field `Supply Air Fan placement`
                Default value: BlowThrough
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Air Fan placement"] = value

    @property
    def supply_fan_total_efficiency(self):
        """Get supply_fan_total_efficiency.

        Returns:
            float: the value of `supply_fan_total_efficiency` or None if not set

        """
        return self["Supply Fan Total Efficiency"]

    @supply_fan_total_efficiency.setter
    def supply_fan_total_efficiency(self, value=0.7):
        """Corresponds to IDD field `Supply Fan Total Efficiency`

        Args:
            value (float): value for IDD Field `Supply Fan Total Efficiency`
                Default value: 0.7
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Total Efficiency"] = value

    @property
    def supply_fan_delta_pressure(self):
        """Get supply_fan_delta_pressure.

        Returns:
            float: the value of `supply_fan_delta_pressure` or None if not set

        """
        return self["Supply Fan Delta Pressure"]

    @supply_fan_delta_pressure.setter
    def supply_fan_delta_pressure(self, value=75.0):
        """Corresponds to IDD field `Supply Fan Delta Pressure`

        Args:
            value (float): value for IDD Field `Supply Fan Delta Pressure`
                Units: Pa
                IP-Units: inH2O
                Default value: 75.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Delta Pressure"] = value

    @property
    def supply_fan_motor_efficiency(self):
        """Get supply_fan_motor_efficiency.

        Returns:
            float: the value of `supply_fan_motor_efficiency` or None if not set

        """
        return self["Supply Fan Motor Efficiency"]

    @supply_fan_motor_efficiency.setter
    def supply_fan_motor_efficiency(self, value=0.9):
        """Corresponds to IDD field `Supply Fan Motor Efficiency`

        Args:
            value (float): value for IDD Field `Supply Fan Motor Efficiency`
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Motor Efficiency"] = value

    @property
    def cooling_coil_type(self):
        """Get cooling_coil_type.

        Returns:
            str: the value of `cooling_coil_type` or None if not set

        """
        return self["Cooling Coil Type"]

    @cooling_coil_type.setter
    def cooling_coil_type(self, value="VariableRefrigerantFlowDX"):
        """Corresponds to IDD field `Cooling Coil Type`

        Args:
            value (str): value for IDD Field `Cooling Coil Type`
                Default value: VariableRefrigerantFlowDX
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Type"] = value

    @property
    def cooling_coil_availability_schedule_name(self):
        """Get cooling_coil_availability_schedule_name.

        Returns:
            str: the value of `cooling_coil_availability_schedule_name` or None if not set

        """
        return self["Cooling Coil Availability Schedule Name"]

    @cooling_coil_availability_schedule_name.setter
    def cooling_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Cooling Coil Availability Schedule Name`
        If blank, always on.

        Args:
            value (str): value for IDD Field `Cooling Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Availability Schedule Name"] = value

    @property
    def cooling_coil_gross_rated_total_capacity(self):
        """Get cooling_coil_gross_rated_total_capacity.

        Returns:
            float: the value of `cooling_coil_gross_rated_total_capacity` or None if not set

        """
        return self["Cooling Coil Gross Rated Total Capacity"]

    @cooling_coil_gross_rated_total_capacity.setter
    def cooling_coil_gross_rated_total_capacity(self, value="autosize"):
        """  Corresponds to IDD field `Cooling Coil Gross Rated Total Capacity`
        Total cooling capacity not accounting for the effect of supply air fan heat
        Rating point: air entering the cooling coil at 26.7 C dry-bulb/19.4 C wet-bulb, and
        air entering the outdoor condenser coil at 35 C dry-bulb/23.9 C wet-bulb

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Coil Gross Rated Total Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Cooling Coil Gross Rated Total Capacity"] = value

    @property
    def cooling_coil_gross_rated_sensible_heat_ratio(self):
        """Get cooling_coil_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `cooling_coil_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Cooling Coil Gross Rated Sensible Heat Ratio"]

    @cooling_coil_gross_rated_sensible_heat_ratio.setter
    def cooling_coil_gross_rated_sensible_heat_ratio(self, value="autosize"):
        """Corresponds to IDD field `Cooling Coil Gross Rated Sensible Heat
        Ratio` Rated sensible heat ratio (gross sensible capacity/gross total
        capacity) Sensible and total capacities do not include effect of supply
        fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Coil Gross Rated Sensible Heat Ratio`
                Default value: "autosize"
                value >= 0.5
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Gross Rated Sensible Heat Ratio"] = value

    @property
    def heat_pump_heating_coil_type(self):
        """Get heat_pump_heating_coil_type.

        Returns:
            str: the value of `heat_pump_heating_coil_type` or None if not set

        """
        return self["Heat Pump Heating Coil Type"]

    @heat_pump_heating_coil_type.setter
    def heat_pump_heating_coil_type(self, value="VariableRefrigerantFlowDX"):
        """Corresponds to IDD field `Heat Pump Heating Coil Type`

        Args:
            value (str): value for IDD Field `Heat Pump Heating Coil Type`
                Default value: VariableRefrigerantFlowDX
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Heating Coil Type"] = value

    @property
    def heat_pump_heating_coil_availability_schedule_name(self):
        """Get heat_pump_heating_coil_availability_schedule_name.

        Returns:
            str: the value of `heat_pump_heating_coil_availability_schedule_name` or None if not set

        """
        return self["Heat Pump Heating Coil Availability Schedule Name"]

    @heat_pump_heating_coil_availability_schedule_name.setter
    def heat_pump_heating_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Heat Pump Heating Coil Availability
        Schedule Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Heat Pump Heating Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Heating Coil Availability Schedule Name"] = value

    @property
    def heat_pump_heating_coil_gross_rated_capacity(self):
        """Get heat_pump_heating_coil_gross_rated_capacity.

        Returns:
            float: the value of `heat_pump_heating_coil_gross_rated_capacity` or None if not set

        """
        return self["Heat Pump Heating Coil Gross Rated Capacity"]

    @heat_pump_heating_coil_gross_rated_capacity.setter
    def heat_pump_heating_coil_gross_rated_capacity(self, value="autosize"):
        """  Corresponds to IDD field `Heat Pump Heating Coil Gross Rated Capacity`
        Capacity excluding supply air fan heat
        Rating point outdoor dry-bulb temp 8.33 C, outdoor wet-bulb temp 6.11 C
        Rating point heating coil entering air dry-bulb 21.11 C, coil entering wet-bulb 15.55 C

        Args:
            value (float or "Autosize"): value for IDD Field `Heat Pump Heating Coil Gross Rated Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Heat Pump Heating Coil Gross Rated Capacity"] = value

    @property
    def zone_terminal_unit_on_parasitic_electric_energy_use(self):
        """Get zone_terminal_unit_on_parasitic_electric_energy_use.

        Returns:
            float: the value of `zone_terminal_unit_on_parasitic_electric_energy_use` or None if not set

        """
        return self["Zone Terminal Unit On Parasitic Electric Energy Use"]

    @zone_terminal_unit_on_parasitic_electric_energy_use.setter
    def zone_terminal_unit_on_parasitic_electric_energy_use(self, value=None):
        """Corresponds to IDD field `Zone Terminal Unit On Parasitic Electric
        Energy Use`

        Args:
            value (float): value for IDD Field `Zone Terminal Unit On Parasitic Electric Energy Use`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Terminal Unit On Parasitic Electric Energy Use"] = value

    @property
    def zone_terminal_unit_off_parasitic_electric_energy_use(self):
        """Get zone_terminal_unit_off_parasitic_electric_energy_use.

        Returns:
            float: the value of `zone_terminal_unit_off_parasitic_electric_energy_use` or None if not set

        """
        return self["Zone Terminal Unit Off Parasitic Electric Energy Use"]

    @zone_terminal_unit_off_parasitic_electric_energy_use.setter
    def zone_terminal_unit_off_parasitic_electric_energy_use(self, value=None):
        """Corresponds to IDD field `Zone Terminal Unit Off Parasitic Electric
        Energy Use`

        Args:
            value (float): value for IDD Field `Zone Terminal Unit Off Parasitic Electric Energy Use`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Terminal Unit Off Parasitic Electric Energy Use"] = value

    @property
    def dedicated_outdoor_air_system_name(self):
        """Get dedicated_outdoor_air_system_name.

        Returns:
            str: the value of `dedicated_outdoor_air_system_name` or None if not set

        """
        return self["Dedicated Outdoor Air System Name"]

    @dedicated_outdoor_air_system_name.setter
    def dedicated_outdoor_air_system_name(self, value=None):
        """  Corresponds to IDD field `Dedicated Outdoor Air System Name`
        Enter the name of an HVACTemplate:System:DedicatedOutdoorAir object if this
        zone is served by a separate dedicated outdoor air system (DOAS).
        Leave field blank if no DOAS serves this zone.

        Args:
            value (str): value for IDD Field `Dedicated Outdoor Air System Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Dedicated Outdoor Air System Name"] = value

    @property
    def zone_cooling_design_supply_air_temperature_input_method(self):
        """Get zone_cooling_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_cooling_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Input Method"]

    @zone_cooling_design_supply_air_temperature_input_method.setter
    def zone_cooling_design_supply_air_temperature_input_method(
            self,
            value="SupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference

        Args:
            value (str): value for IDD Field `Zone Cooling Design Supply Air Temperature Input Method`
                Default value: SupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Input Method"] = value

    @property
    def zone_cooling_design_supply_air_temperature(self):
        """Get zone_cooling_design_supply_air_temperature.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature"]

    @zone_cooling_design_supply_air_temperature.setter
    def zone_cooling_design_supply_air_temperature(self, value=14.0):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature`
                Units: C
                Default value: 14.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature"] = value

    @property
    def zone_cooling_design_supply_air_temperature_difference(self):
        """Get zone_cooling_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Difference"]

    @zone_cooling_design_supply_air_temperature_difference.setter
    def zone_cooling_design_supply_air_temperature_difference(
            self,
            value=11.11):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Difference`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be subtracted from the zone temperature
        at peak load to calculate the Zone Cooling Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 11.11
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Difference"] = value

    @property
    def zone_heating_design_supply_air_temperature_input_method(self):
        """Get zone_heating_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_heating_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Input Method"]

    @zone_heating_design_supply_air_temperature_input_method.setter
    def zone_heating_design_supply_air_temperature_input_method(
            self,
            value="SupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference

        Args:
            value (str): value for IDD Field `Zone Heating Design Supply Air Temperature Input Method`
                Default value: SupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Input Method"] = value

    @property
    def zone_heating_design_supply_air_temperature(self):
        """Get zone_heating_design_supply_air_temperature.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature"]

    @zone_heating_design_supply_air_temperature.setter
    def zone_heating_design_supply_air_temperature(self, value=50.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature`
                Units: C
                Default value: 50.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature"] = value

    @property
    def zone_heating_design_supply_air_temperature_difference(self):
        """Get zone_heating_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Difference"]

    @zone_heating_design_supply_air_temperature_difference.setter
    def zone_heating_design_supply_air_temperature_difference(
            self,
            value=30.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Difference`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be added to the zone temperature
        at peak load to calculate the Zone Heating Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 30.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Difference"] = value

    @property
    def baseboard_heating_type(self):
        """Get baseboard_heating_type.

        Returns:
            str: the value of `baseboard_heating_type` or None if not set

        """
        return self["Baseboard Heating Type"]

    @baseboard_heating_type.setter
    def baseboard_heating_type(self, value="None"):
        """Corresponds to IDD field `Baseboard Heating Type`

        Args:
            value (str): value for IDD Field `Baseboard Heating Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Type"] = value

    @property
    def baseboard_heating_availability_schedule_name(self):
        """Get baseboard_heating_availability_schedule_name.

        Returns:
            str: the value of `baseboard_heating_availability_schedule_name` or None if not set

        """
        return self["Baseboard Heating Availability Schedule Name"]

    @baseboard_heating_availability_schedule_name.setter
    def baseboard_heating_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Baseboard Heating Availability Schedule
        Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Baseboard Heating Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Availability Schedule Name"] = value

    @property
    def baseboard_heating_capacity(self):
        """Get baseboard_heating_capacity.

        Returns:
            float: the value of `baseboard_heating_capacity` or None if not set

        """
        return self["Baseboard Heating Capacity"]

    @baseboard_heating_capacity.setter
    def baseboard_heating_capacity(self, value="autosize"):
        """Corresponds to IDD field `Baseboard Heating Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Baseboard Heating Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Capacity"] = value




class HvactemplateZoneUnitary(DataObject):

    """ Corresponds to IDD object `HVACTemplate:Zone:Unitary`
        Zone terminal unit, constant volume, no controls.
    """
    schema = {'min-fields': 21,
              'name': u'HVACTemplate:Zone:Unitary',
              'pyname': u'HvactemplateZoneUnitary',
              'format': None,
              'fields': OrderedDict([(u'zone name',
                                      {'name': u'Zone Name',
                                       'pyname': u'zone_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template unitary system name',
                                      {'name': u'Template Unitary System Name',
                                       'pyname': u'template_unitary_system_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template thermostat name',
                                      {'name': u'Template Thermostat Name',
                                       'pyname': u'template_thermostat_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply air maximum flow rate',
                                      {'name': u'Supply Air Maximum Flow Rate',
                                       'pyname': u'supply_air_maximum_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'zone heating sizing factor',
                                      {'name': u'Zone Heating Sizing Factor',
                                       'pyname': u'zone_heating_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'zone cooling sizing factor',
                                      {'name': u'Zone Cooling Sizing Factor',
                                       'pyname': u'zone_cooling_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'outdoor air method',
                                      {'name': u'Outdoor Air Method',
                                       'pyname': u'outdoor_air_method',
                                       'default': u'Flow/Person',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Flow/Person',
                                                           u'Flow/Zone',
                                                           u'Flow/Area',
                                                           u'Sum',
                                                           u'Maximum',
                                                           u'DetailedSpecification'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'outdoor air flow rate per person',
                                      {'name': u'Outdoor Air Flow Rate per Person',
                                       'pyname': u'outdoor_air_flow_rate_per_person',
                                       'default': 0.00944,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate per zone floor area',
                                      {'name': u'Outdoor Air Flow Rate per Zone Floor Area',
                                       'pyname': u'outdoor_air_flow_rate_per_zone_floor_area',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s-m2'}),
                                     (u'outdoor air flow rate per zone',
                                      {'name': u'Outdoor Air Flow Rate per Zone',
                                       'pyname': u'outdoor_air_flow_rate_per_zone',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'supply plenum name',
                                      {'name': u'Supply Plenum Name',
                                       'pyname': u'supply_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'return plenum name',
                                      {'name': u'Return Plenum Name',
                                       'pyname': u'return_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating type',
                                      {'name': u'Baseboard Heating Type',
                                       'pyname': u'baseboard_heating_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'baseboard heating availability schedule name',
                                      {'name': u'Baseboard Heating Availability Schedule Name',
                                       'pyname': u'baseboard_heating_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating capacity',
                                      {'name': u'Baseboard Heating Capacity',
                                       'pyname': u'baseboard_heating_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'zone cooling design supply air temperature input method',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_input_method',
                                       'default': u'SystemSupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference',
                                                           u'SystemSupplyAirTemperature'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone cooling design supply air temperature',
                                      {'name': u'Zone Cooling Design Supply Air Temperature',
                                       'pyname': u'zone_cooling_design_supply_air_temperature',
                                       'default': 12.8,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone cooling design supply air temperature difference',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Difference',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_difference',
                                       'default': 11.11,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'zone heating design supply air temperature input method',
                                      {'name': u'Zone Heating Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_heating_design_supply_air_temperature_input_method',
                                       'default': u'SystemSupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference',
                                                           u'SystemSupplyAirTemperature'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone heating design supply air temperature',
                                      {'name': u'Zone Heating Design Supply Air Temperature',
                                       'pyname': u'zone_heating_design_supply_air_temperature',
                                       'default': 50.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone heating design supply air temperature difference',
                                      {'name': u'Zone Heating Design Supply Air Temperature Difference',
                                       'pyname': u'zone_heating_design_supply_air_temperature_difference',
                                       'default': 30.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'design specification outdoor air object name',
                                      {'name': u'Design Specification Outdoor Air Object Name',
                                       'pyname': u'design_specification_outdoor_air_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'design specification zone air distribution object name',
                                      {'name': u'Design Specification Zone Air Distribution Object Name',
                                       'pyname': u'design_specification_zone_air_distribution_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def zone_name(self):
        """Get zone_name.

        Returns:
            str: the value of `zone_name` or None if not set

        """
        return self["Zone Name"]

    @zone_name.setter
    def zone_name(self, value=None):
        """Corresponds to IDD field `Zone Name` Zone name must match a building
        zone name.

        Args:
            value (str): value for IDD Field `Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Name"] = value

    @property
    def template_unitary_system_name(self):
        """Get template_unitary_system_name.

        Returns:
            str: the value of `template_unitary_system_name` or None if not set

        """
        return self["Template Unitary System Name"]

    @template_unitary_system_name.setter
    def template_unitary_system_name(self, value=None):
        """  Corresponds to IDD field `Template Unitary System Name`
        Enter the name of an HVACTemplate:System:Unitary, HVACTemplate:System:UnitaryHeatPump:AirTtoAir,
        or HVACTemplate:System:UnitarySystem object serving this zone.

        Args:
            value (str): value for IDD Field `Template Unitary System Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Unitary System Name"] = value

    @property
    def template_thermostat_name(self):
        """Get template_thermostat_name.

        Returns:
            str: the value of `template_thermostat_name` or None if not set

        """
        return self["Template Thermostat Name"]

    @template_thermostat_name.setter
    def template_thermostat_name(self, value=None):
        """  Corresponds to IDD field `Template Thermostat Name`
        Enter the name of a HVACTemplate:Thermostat object.
        If blank, then it is assumed that standard thermostat objects
        have been defined for this zone.

        Args:
            value (str): value for IDD Field `Template Thermostat Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Thermostat Name"] = value

    @property
    def supply_air_maximum_flow_rate(self):
        """Get supply_air_maximum_flow_rate.

        Returns:
            float: the value of `supply_air_maximum_flow_rate` or None if not set

        """
        return self["Supply Air Maximum Flow Rate"]

    @supply_air_maximum_flow_rate.setter
    def supply_air_maximum_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Supply Air Maximum Flow Rate` This field
        may be set to "autosize".  If a value is entered, it will be multiplied
        by the Supply Air Sizing Factor and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Supply Air Maximum Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Air Maximum Flow Rate"] = value

    @property
    def zone_heating_sizing_factor(self):
        """Get zone_heating_sizing_factor.

        Returns:
            float: the value of `zone_heating_sizing_factor` or None if not set

        """
        return self["Zone Heating Sizing Factor"]

    @zone_heating_sizing_factor.setter
    def zone_heating_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Heating Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Heating Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Sizing Factor"] = value

    @property
    def zone_cooling_sizing_factor(self):
        """Get zone_cooling_sizing_factor.

        Returns:
            float: the value of `zone_cooling_sizing_factor` or None if not set

        """
        return self["Zone Cooling Sizing Factor"]

    @zone_cooling_sizing_factor.setter
    def zone_cooling_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Cooling Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Cooling Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Sizing Factor"] = value

    @property
    def outdoor_air_method(self):
        """Get outdoor_air_method.

        Returns:
            str: the value of `outdoor_air_method` or None if not set

        """
        return self["Outdoor Air Method"]

    @outdoor_air_method.setter
    def outdoor_air_method(self, value="Flow/Person"):
        """  Corresponds to IDD field `Outdoor Air Method`
        Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
        fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
        and Outdoor Air Flow Rate per Zone.
        DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
        references design specification objects named in the fields
        Design Specification Outdoor Air Object Name and Design Specification Zone Air
        Distribution Object Name.

        Args:
            value (str): value for IDD Field `Outdoor Air Method`
                Default value: Flow/Person
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Method"] = value

    @property
    def outdoor_air_flow_rate_per_person(self):
        """Get outdoor_air_flow_rate_per_person.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_person` or None if not set

        """
        return self["Outdoor Air Flow Rate per Person"]

    @outdoor_air_flow_rate_per_person.setter
    def outdoor_air_flow_rate_per_person(self, value=0.00944):
        """  Corresponds to IDD field `Outdoor Air Flow Rate per Person`
        Default 0.00944 is 20 cfm per person
        This input is used if the field Outdoor Air Method is
        Flow/Person, Sum, or Maximum

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Person`
                Units: m3/s
                Default value: 0.00944
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Flow Rate per Person"] = value

    @property
    def outdoor_air_flow_rate_per_zone_floor_area(self):
        """Get outdoor_air_flow_rate_per_zone_floor_area.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone_floor_area` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone Floor Area"]

    @outdoor_air_flow_rate_per_zone_floor_area.setter
    def outdoor_air_flow_rate_per_zone_floor_area(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone Floor Area`
        This input is used if the field Outdoor Air Method is Flow/Area, Sum,
        or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone Floor Area`
                Units: m3/s-m2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone Floor Area"] = value

    @property
    def outdoor_air_flow_rate_per_zone(self):
        """Get outdoor_air_flow_rate_per_zone.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone"]

    @outdoor_air_flow_rate_per_zone.setter
    def outdoor_air_flow_rate_per_zone(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone` This input
        is used if the field Outdoor Air Method is Flow/Zone, Sum, or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone"] = value

    @property
    def supply_plenum_name(self):
        """Get supply_plenum_name.

        Returns:
            str: the value of `supply_plenum_name` or None if not set

        """
        return self["Supply Plenum Name"]

    @supply_plenum_name.setter
    def supply_plenum_name(self, value=None):
        """Corresponds to IDD field `Supply Plenum Name` Plenum zone name.
        Supply plenum runs through only this zone. Blank if none.

        Args:
            value (str): value for IDD Field `Supply Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Plenum Name"] = value

    @property
    def return_plenum_name(self):
        """Get return_plenum_name.

        Returns:
            str: the value of `return_plenum_name` or None if not set

        """
        return self["Return Plenum Name"]

    @return_plenum_name.setter
    def return_plenum_name(self, value=None):
        """Corresponds to IDD field `Return Plenum Name` Plenum zone name.
        Return plenum runs through only this zone. Blank if none.

        Args:
            value (str): value for IDD Field `Return Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Plenum Name"] = value

    @property
    def baseboard_heating_type(self):
        """Get baseboard_heating_type.

        Returns:
            str: the value of `baseboard_heating_type` or None if not set

        """
        return self["Baseboard Heating Type"]

    @baseboard_heating_type.setter
    def baseboard_heating_type(self, value="None"):
        """Corresponds to IDD field `Baseboard Heating Type`

        Args:
            value (str): value for IDD Field `Baseboard Heating Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Type"] = value

    @property
    def baseboard_heating_availability_schedule_name(self):
        """Get baseboard_heating_availability_schedule_name.

        Returns:
            str: the value of `baseboard_heating_availability_schedule_name` or None if not set

        """
        return self["Baseboard Heating Availability Schedule Name"]

    @baseboard_heating_availability_schedule_name.setter
    def baseboard_heating_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Baseboard Heating Availability Schedule
        Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Baseboard Heating Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Availability Schedule Name"] = value

    @property
    def baseboard_heating_capacity(self):
        """Get baseboard_heating_capacity.

        Returns:
            float: the value of `baseboard_heating_capacity` or None if not set

        """
        return self["Baseboard Heating Capacity"]

    @baseboard_heating_capacity.setter
    def baseboard_heating_capacity(self, value="autosize"):
        """Corresponds to IDD field `Baseboard Heating Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Baseboard Heating Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Capacity"] = value

    @property
    def zone_cooling_design_supply_air_temperature_input_method(self):
        """Get zone_cooling_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_cooling_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Input Method"]

    @zone_cooling_design_supply_air_temperature_input_method.setter
    def zone_cooling_design_supply_air_temperature_input_method(
            self,
            value="SystemSupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference
        SystemSupplyAirTemperature = use the value from HVACTemplate:System:Unitary or HVACTemplate:System:UnitaryHeatPump:AirToAir
        Cooling Design Supply Air Temperature

        Args:
            value (str): value for IDD Field `Zone Cooling Design Supply Air Temperature Input Method`
                Default value: SystemSupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Input Method"] = value

    @property
    def zone_cooling_design_supply_air_temperature(self):
        """Get zone_cooling_design_supply_air_temperature.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature"]

    @zone_cooling_design_supply_air_temperature.setter
    def zone_cooling_design_supply_air_temperature(self, value=12.8):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature`
                Units: C
                Default value: 12.8
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature"] = value

    @property
    def zone_cooling_design_supply_air_temperature_difference(self):
        """Get zone_cooling_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Difference"]

    @zone_cooling_design_supply_air_temperature_difference.setter
    def zone_cooling_design_supply_air_temperature_difference(
            self,
            value=11.11):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Difference`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be subtracted from the zone temperature
        at peak load to calculate the Zone Cooling Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 11.11
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Difference"] = value

    @property
    def zone_heating_design_supply_air_temperature_input_method(self):
        """Get zone_heating_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_heating_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Input Method"]

    @zone_heating_design_supply_air_temperature_input_method.setter
    def zone_heating_design_supply_air_temperature_input_method(
            self,
            value="SystemSupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference
        SystemSupplyAirTemperature = use the value from HVACTemplate:System:Unitary or HVACTemplate:System:UnitaryHeatPump:AirToAir
        Heating Design Supply Air Temperature

        Args:
            value (str): value for IDD Field `Zone Heating Design Supply Air Temperature Input Method`
                Default value: SystemSupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Input Method"] = value

    @property
    def zone_heating_design_supply_air_temperature(self):
        """Get zone_heating_design_supply_air_temperature.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature"]

    @zone_heating_design_supply_air_temperature.setter
    def zone_heating_design_supply_air_temperature(self, value=50.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature`
                Units: C
                Default value: 50.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature"] = value

    @property
    def zone_heating_design_supply_air_temperature_difference(self):
        """Get zone_heating_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Difference"]

    @zone_heating_design_supply_air_temperature_difference.setter
    def zone_heating_design_supply_air_temperature_difference(
            self,
            value=30.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Difference`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be added to the zone temperature
        at peak load to calculate the Zone Heating Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 30.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Difference"] = value

    @property
    def design_specification_outdoor_air_object_name(self):
        """Get design_specification_outdoor_air_object_name.

        Returns:
            str: the value of `design_specification_outdoor_air_object_name` or None if not set

        """
        return self["Design Specification Outdoor Air Object Name"]

    @design_specification_outdoor_air_object_name.setter
    def design_specification_outdoor_air_object_name(self, value=None):
        """  Corresponds to IDD field `Design Specification Outdoor Air Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Outdoor Air Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Outdoor Air Object Name"] = value

    @property
    def design_specification_zone_air_distribution_object_name(self):
        """Get design_specification_zone_air_distribution_object_name.

        Returns:
            str: the value of `design_specification_zone_air_distribution_object_name` or None if not set

        """
        return self["Design Specification Zone Air Distribution Object Name"]

    @design_specification_zone_air_distribution_object_name.setter
    def design_specification_zone_air_distribution_object_name(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Zone Air Distribution Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Zone Air Distribution Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Zone Air Distribution Object Name"] = value




class HvactemplateZoneVav(DataObject):

    """ Corresponds to IDD object `HVACTemplate:Zone:VAV`
        Zone terminal unit, variable volume, reheat optional.
        For heating, this unit activates reheat coil first, then increases airflow (if reverse
        action specified).
    """
    schema = {'min-fields': 32,
              'name': u'HVACTemplate:Zone:VAV',
              'pyname': u'HvactemplateZoneVav',
              'format': None,
              'fields': OrderedDict([(u'zone name',
                                      {'name': u'Zone Name',
                                       'pyname': u'zone_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template vav system name',
                                      {'name': u'Template VAV System Name',
                                       'pyname': u'template_vav_system_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template thermostat name',
                                      {'name': u'Template Thermostat Name',
                                       'pyname': u'template_thermostat_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply air maximum flow rate',
                                      {'name': u'Supply Air Maximum Flow Rate',
                                       'pyname': u'supply_air_maximum_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'zone heating sizing factor',
                                      {'name': u'Zone Heating Sizing Factor',
                                       'pyname': u'zone_heating_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'zone cooling sizing factor',
                                      {'name': u'Zone Cooling Sizing Factor',
                                       'pyname': u'zone_cooling_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'zone minimum air flow input method',
                                      {'name': u'Zone Minimum Air Flow Input Method',
                                       'pyname': u'zone_minimum_air_flow_input_method',
                                       'default': u'Constant',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Constant',
                                                           u'FixedFlowRate',
                                                           u'Scheduled'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'constant minimum air flow fraction',
                                      {'name': u'Constant Minimum Air Flow Fraction',
                                       'pyname': u'constant_minimum_air_flow_fraction',
                                       'default': 0.2,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'fixed minimum air flow rate',
                                      {'name': u'Fixed Minimum Air Flow Rate',
                                       'pyname': u'fixed_minimum_air_flow_rate',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'minimum air flow fraction schedule name',
                                      {'name': u'Minimum Air Flow Fraction Schedule Name',
                                       'pyname': u'minimum_air_flow_fraction_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'outdoor air method',
                                      {'name': u'Outdoor Air Method',
                                       'pyname': u'outdoor_air_method',
                                       'default': u'Flow/Person',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Flow/Person',
                                                           u'Flow/Zone',
                                                           u'Flow/Area',
                                                           u'Sum',
                                                           u'Maximum',
                                                           u'DetailedSpecification'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'outdoor air flow rate per person',
                                      {'name': u'Outdoor Air Flow Rate per Person',
                                       'pyname': u'outdoor_air_flow_rate_per_person',
                                       'default': 0.00944,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate per zone floor area',
                                      {'name': u'Outdoor Air Flow Rate per Zone Floor Area',
                                       'pyname': u'outdoor_air_flow_rate_per_zone_floor_area',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s-m2'}),
                                     (u'outdoor air flow rate per zone',
                                      {'name': u'Outdoor Air Flow Rate per Zone',
                                       'pyname': u'outdoor_air_flow_rate_per_zone',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'reheat coil type',
                                      {'name': u'Reheat Coil Type',
                                       'pyname': u'reheat_coil_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric',
                                                           u'Gas',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'reheat coil availability schedule name',
                                      {'name': u'Reheat Coil Availability Schedule Name',
                                       'pyname': u'reheat_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'damper heating action',
                                      {'name': u'Damper Heating Action',
                                       'pyname': u'damper_heating_action',
                                       'default': u'Reverse',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Normal',
                                                           u'Reverse'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'maximum flow per zone floor area during reheat',
                                      {'name': u'Maximum Flow per Zone Floor Area During Reheat',
                                       'pyname': u'maximum_flow_per_zone_floor_area_during_reheat',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': True,
                                       'type': u'real',
                                       'unit': u'm3/s-m2'}),
                                     (u'maximum flow fraction during reheat',
                                      {'name': u'Maximum Flow Fraction During Reheat',
                                       'pyname': u'maximum_flow_fraction_during_reheat',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': True,
                                       'type': u'real'}),
                                     (u'maximum reheat air temperature',
                                      {'name': u'Maximum Reheat Air Temperature',
                                       'pyname': u'maximum_reheat_air_temperature',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'design specification outdoor air object name for control',
                                      {'name': u'Design Specification Outdoor Air Object Name for Control',
                                       'pyname': u'design_specification_outdoor_air_object_name_for_control',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply plenum name',
                                      {'name': u'Supply Plenum Name',
                                       'pyname': u'supply_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'return plenum name',
                                      {'name': u'Return Plenum Name',
                                       'pyname': u'return_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating type',
                                      {'name': u'Baseboard Heating Type',
                                       'pyname': u'baseboard_heating_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'baseboard heating availability schedule name',
                                      {'name': u'Baseboard Heating Availability Schedule Name',
                                       'pyname': u'baseboard_heating_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating capacity',
                                      {'name': u'Baseboard Heating Capacity',
                                       'pyname': u'baseboard_heating_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'zone cooling design supply air temperature input method',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_input_method',
                                       'default': u'SystemSupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference',
                                                           u'SystemSupplyAirTemperature'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone cooling design supply air temperature',
                                      {'name': u'Zone Cooling Design Supply Air Temperature',
                                       'pyname': u'zone_cooling_design_supply_air_temperature',
                                       'default': 12.8,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone cooling design supply air temperature difference',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Difference',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_difference',
                                       'default': 11.11,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'zone heating design supply air temperature input method',
                                      {'name': u'Zone Heating Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_heating_design_supply_air_temperature_input_method',
                                       'default': u'SupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone heating design supply air temperature',
                                      {'name': u'Zone Heating Design Supply Air Temperature',
                                       'pyname': u'zone_heating_design_supply_air_temperature',
                                       'default': 50.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone heating design supply air temperature difference',
                                      {'name': u'Zone Heating Design Supply Air Temperature Difference',
                                       'pyname': u'zone_heating_design_supply_air_temperature_difference',
                                       'default': 30.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'design specification outdoor air object name for sizing',
                                      {'name': u'Design Specification Outdoor Air Object Name for Sizing',
                                       'pyname': u'design_specification_outdoor_air_object_name_for_sizing',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'design specification zone air distribution object name',
                                      {'name': u'Design Specification Zone Air Distribution Object Name',
                                       'pyname': u'design_specification_zone_air_distribution_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def zone_name(self):
        """Get zone_name.

        Returns:
            str: the value of `zone_name` or None if not set

        """
        return self["Zone Name"]

    @zone_name.setter
    def zone_name(self, value=None):
        """Corresponds to IDD field `Zone Name` Zone name must match a building
        zone name.

        Args:
            value (str): value for IDD Field `Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Name"] = value

    @property
    def template_vav_system_name(self):
        """Get template_vav_system_name.

        Returns:
            str: the value of `template_vav_system_name` or None if not set

        """
        return self["Template VAV System Name"]

    @template_vav_system_name.setter
    def template_vav_system_name(self, value=None):
        """  Corresponds to IDD field `Template VAV System Name`
        Name of a HVACTemplate:System:VAV or HVACTemplate:System:PackagedVAV
        object serving this zone

        Args:
            value (str): value for IDD Field `Template VAV System Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template VAV System Name"] = value

    @property
    def template_thermostat_name(self):
        """Get template_thermostat_name.

        Returns:
            str: the value of `template_thermostat_name` or None if not set

        """
        return self["Template Thermostat Name"]

    @template_thermostat_name.setter
    def template_thermostat_name(self, value=None):
        """  Corresponds to IDD field `Template Thermostat Name`
        Enter the name of a HVACTemplate:Thermostat object.
        If blank, then it is assumed that standard thermostat objects
        have been defined for this zone.

        Args:
            value (str): value for IDD Field `Template Thermostat Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Thermostat Name"] = value

    @property
    def supply_air_maximum_flow_rate(self):
        """Get supply_air_maximum_flow_rate.

        Returns:
            float: the value of `supply_air_maximum_flow_rate` or None if not set

        """
        return self["Supply Air Maximum Flow Rate"]

    @supply_air_maximum_flow_rate.setter
    def supply_air_maximum_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Supply Air Maximum Flow Rate` This field
        may be set to "autosize".  If a value is entered, it will be multiplied
        by the Supply Air Sizing Factor and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Supply Air Maximum Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Air Maximum Flow Rate"] = value

    @property
    def zone_heating_sizing_factor(self):
        """Get zone_heating_sizing_factor.

        Returns:
            float: the value of `zone_heating_sizing_factor` or None if not set

        """
        return self["Zone Heating Sizing Factor"]

    @zone_heating_sizing_factor.setter
    def zone_heating_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Heating Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Heating Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Sizing Factor"] = value

    @property
    def zone_cooling_sizing_factor(self):
        """Get zone_cooling_sizing_factor.

        Returns:
            float: the value of `zone_cooling_sizing_factor` or None if not set

        """
        return self["Zone Cooling Sizing Factor"]

    @zone_cooling_sizing_factor.setter
    def zone_cooling_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Cooling Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Cooling Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Sizing Factor"] = value

    @property
    def zone_minimum_air_flow_input_method(self):
        """Get zone_minimum_air_flow_input_method.

        Returns:
            str: the value of `zone_minimum_air_flow_input_method` or None if not set

        """
        return self["Zone Minimum Air Flow Input Method"]

    @zone_minimum_air_flow_input_method.setter
    def zone_minimum_air_flow_input_method(self, value="Constant"):
        """  Corresponds to IDD field `Zone Minimum Air Flow Input Method`
        Constant = Constant Minimum Air Flow Fraction (a fraction of Maximum Air Flow Rate)
        FixedFlowRate = Fixed Minimum Air Flow Rate (a fixed minimum air volume flow rate)
        Scheduled = Scheduled Minimum Air Flow Fraction (a fraction of Maximum Air Flow

        Args:
            value (str): value for IDD Field `Zone Minimum Air Flow Input Method`
                Default value: Constant
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Minimum Air Flow Input Method"] = value

    @property
    def constant_minimum_air_flow_fraction(self):
        """Get constant_minimum_air_flow_fraction.

        Returns:
            float: the value of `constant_minimum_air_flow_fraction` or None if not set

        """
        return self["Constant Minimum Air Flow Fraction"]

    @constant_minimum_air_flow_fraction.setter
    def constant_minimum_air_flow_fraction(self, value=0.2):
        """  Corresponds to IDD field `Constant Minimum Air Flow Fraction`
        This field is used if the field Zone Minimum Air Flow Input Method is Constant
        If the field Zone Minimum Air Flow Input Method is Scheduled, then this field
        is optional. If a value is entered, then it is used for sizing normal-action reheat coils.
        If both this field and the following field are entered, the larger result is used.

        Args:
            value (float): value for IDD Field `Constant Minimum Air Flow Fraction`
                Default value: 0.2
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Constant Minimum Air Flow Fraction"] = value

    @property
    def fixed_minimum_air_flow_rate(self):
        """Get fixed_minimum_air_flow_rate.

        Returns:
            float: the value of `fixed_minimum_air_flow_rate` or None if not set

        """
        return self["Fixed Minimum Air Flow Rate"]

    @fixed_minimum_air_flow_rate.setter
    def fixed_minimum_air_flow_rate(self, value=None):
        """  Corresponds to IDD field `Fixed Minimum Air Flow Rate`
        This field is used if the field Zone Minimum Air Flow Input Method is FixedFlowRate.
        If the field Zone Minimum Air Flow Input Method is Scheduled, then this field
        is optional. If a value is entered, then it is used for sizing normal-action reheat coils.
        If both this field and the previous field are entered, the larger result is used.

        Args:
            value (float): value for IDD Field `Fixed Minimum Air Flow Rate`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Fixed Minimum Air Flow Rate"] = value

    @property
    def minimum_air_flow_fraction_schedule_name(self):
        """Get minimum_air_flow_fraction_schedule_name.

        Returns:
            str: the value of `minimum_air_flow_fraction_schedule_name` or None if not set

        """
        return self["Minimum Air Flow Fraction Schedule Name"]

    @minimum_air_flow_fraction_schedule_name.setter
    def minimum_air_flow_fraction_schedule_name(self, value=None):
        """  Corresponds to IDD field `Minimum Air Flow Fraction Schedule Name`
        This field is used if the field Zone Minimum Air Flow Input Method is Scheduled
        Schedule values are fractions, 0.0 to 1.0.
        If the field Constant Minimum Air Flow Fraction is blank, then the average of the
        minimum and maximum schedule values is used for sizing normal-action reheat coils.

        Args:
            value (str): value for IDD Field `Minimum Air Flow Fraction Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Minimum Air Flow Fraction Schedule Name"] = value

    @property
    def outdoor_air_method(self):
        """Get outdoor_air_method.

        Returns:
            str: the value of `outdoor_air_method` or None if not set

        """
        return self["Outdoor Air Method"]

    @outdoor_air_method.setter
    def outdoor_air_method(self, value="Flow/Person"):
        """  Corresponds to IDD field `Outdoor Air Method`
        Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
        fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
        and Outdoor Air Flow Rate per Zone.
        DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
        references design specification objects named in the fields
        Design Specification Outdoor Air Object Name and Design Specification Zone Air
        Distribution Object Name.

        Args:
            value (str): value for IDD Field `Outdoor Air Method`
                Default value: Flow/Person
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Method"] = value

    @property
    def outdoor_air_flow_rate_per_person(self):
        """Get outdoor_air_flow_rate_per_person.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_person` or None if not set

        """
        return self["Outdoor Air Flow Rate per Person"]

    @outdoor_air_flow_rate_per_person.setter
    def outdoor_air_flow_rate_per_person(self, value=0.00944):
        """  Corresponds to IDD field `Outdoor Air Flow Rate per Person`
        Default 0.00944 is 20 cfm per person
        This input is used if the field Outdoor Air Method is
        Flow/Person, Sum, or Maximum

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Person`
                Units: m3/s
                Default value: 0.00944
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Flow Rate per Person"] = value

    @property
    def outdoor_air_flow_rate_per_zone_floor_area(self):
        """Get outdoor_air_flow_rate_per_zone_floor_area.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone_floor_area` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone Floor Area"]

    @outdoor_air_flow_rate_per_zone_floor_area.setter
    def outdoor_air_flow_rate_per_zone_floor_area(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone Floor Area`
        This input is used if the field Outdoor Air Method is Flow/Area, Sum,
        or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone Floor Area`
                Units: m3/s-m2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone Floor Area"] = value

    @property
    def outdoor_air_flow_rate_per_zone(self):
        """Get outdoor_air_flow_rate_per_zone.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone"]

    @outdoor_air_flow_rate_per_zone.setter
    def outdoor_air_flow_rate_per_zone(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone` This input
        is used if the field Outdoor Air Method is Flow/Zone, Sum, or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone"] = value

    @property
    def reheat_coil_type(self):
        """Get reheat_coil_type.

        Returns:
            str: the value of `reheat_coil_type` or None if not set

        """
        return self["Reheat Coil Type"]

    @reheat_coil_type.setter
    def reheat_coil_type(self, value="None"):
        """Corresponds to IDD field `Reheat Coil Type`

        Args:
            value (str): value for IDD Field `Reheat Coil Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Reheat Coil Type"] = value

    @property
    def reheat_coil_availability_schedule_name(self):
        """Get reheat_coil_availability_schedule_name.

        Returns:
            str: the value of `reheat_coil_availability_schedule_name` or None if not set

        """
        return self["Reheat Coil Availability Schedule Name"]

    @reheat_coil_availability_schedule_name.setter
    def reheat_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Reheat Coil Availability Schedule Name` If
        blank, always on.

        Args:
            value (str): value for IDD Field `Reheat Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Reheat Coil Availability Schedule Name"] = value

    @property
    def damper_heating_action(self):
        """Get damper_heating_action.

        Returns:
            str: the value of `damper_heating_action` or None if not set

        """
        return self["Damper Heating Action"]

    @damper_heating_action.setter
    def damper_heating_action(self, value="Reverse"):
        """Corresponds to IDD field `Damper Heating Action`

        Args:
            value (str): value for IDD Field `Damper Heating Action`
                Default value: Reverse
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Damper Heating Action"] = value

    @property
    def maximum_flow_per_zone_floor_area_during_reheat(self):
        """Get maximum_flow_per_zone_floor_area_during_reheat.

        Returns:
            float: the value of `maximum_flow_per_zone_floor_area_during_reheat` or None if not set

        """
        return self["Maximum Flow per Zone Floor Area During Reheat"]

    @maximum_flow_per_zone_floor_area_during_reheat.setter
    def maximum_flow_per_zone_floor_area_during_reheat(self, value=None):
        """  Corresponds to IDD field `Maximum Flow per Zone Floor Area During Reheat`
        Used only when Reheat Coil Object Type = Coil:Heating:Water and Damper Heating Action = Reverse
        When autocalculating, the maximum flow per zone is set to 0.002032 m3/s-m2 (0.4 cfm/sqft)
        This optional field limits the maximum flow allowed in reheat mode.
        If this field and the following field are left blank, the maximum flow will not be limited.
        At no time will the maximum flow rate calculated here exceed the value of
        Maximum Air Flow Rate.

        Args:
            value (float or "Autocalculate"): value for IDD Field `Maximum Flow per Zone Floor Area During Reheat`
                Units: m3/s-m2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Maximum Flow per Zone Floor Area During Reheat"] = value

    @property
    def maximum_flow_fraction_during_reheat(self):
        """Get maximum_flow_fraction_during_reheat.

        Returns:
            float: the value of `maximum_flow_fraction_during_reheat` or None if not set

        """
        return self["Maximum Flow Fraction During Reheat"]

    @maximum_flow_fraction_during_reheat.setter
    def maximum_flow_fraction_during_reheat(self, value=None):
        """  Corresponds to IDD field `Maximum Flow Fraction During Reheat`
        Used only when Reheat Coil Object Type = Coil:Heating:Water and Damper Heating Action = Reverse
        When autocalculating, the maximum flow fraction is set to the ratio of
        0.002032 m3/s-m2 (0.4 cfm/sqft) multiplied by the zone floor area and the
        Maximum Air Flow Rate.
        This optional field limits the maximum flow allowed in reheat mode.
        If this field and the previous field are left blank, the maximum flow will not be limited.
        At no time will the maximum flow rate calculated here exceed the value of
        Maximum Air Flow Rate.

        Args:
            value (float or "Autocalculate"): value for IDD Field `Maximum Flow Fraction During Reheat`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Maximum Flow Fraction During Reheat"] = value

    @property
    def maximum_reheat_air_temperature(self):
        """Get maximum_reheat_air_temperature.

        Returns:
            float: the value of `maximum_reheat_air_temperature` or None if not set

        """
        return self["Maximum Reheat Air Temperature"]

    @maximum_reheat_air_temperature.setter
    def maximum_reheat_air_temperature(self, value=None):
        """Corresponds to IDD field `Maximum Reheat Air Temperature` Specifies
        the maximum allowable supply air temperature leaving the reheat coil.
        If left blank, there is no limit and no default. If unknown, 35C (95F)
        is recommended.

        Args:
            value (float): value for IDD Field `Maximum Reheat Air Temperature`
                Units: C
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Maximum Reheat Air Temperature"] = value

    @property
    def design_specification_outdoor_air_object_name_for_control(self):
        """Get design_specification_outdoor_air_object_name_for_control.

        Returns:
            str: the value of `design_specification_outdoor_air_object_name_for_control` or None if not set

        """
        return self["Design Specification Outdoor Air Object Name for Control"]

    @design_specification_outdoor_air_object_name_for_control.setter
    def design_specification_outdoor_air_object_name_for_control(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Outdoor Air Object Name for Control`
        When the name of a DesignSpecification:OutdoorAir object is entered, the terminal
        unit will increase flow as needed to meet this outdoor air requirement.
        If Outdoor Air Flow per Person is non-zero, then the outdoor air requirement will
        be computed based on the current number of occupants in the zone.
        At no time will the supply air flow rate exceed the value for Maximum Air Flow Rate.
        If this field is blank, then the terminal unit will not be controlled for outdoor air flow.
        Note that this field is used only for specifying the design outdoor air flow rate used
        for control. The field Design Specification Outdoor Air Object Name for Sizing
        (see below) is used to specify the design outdoor air flow rate.

        Args:
            value (str): value for IDD Field `Design Specification Outdoor Air Object Name for Control`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Design Specification Outdoor Air Object Name for Control"] = value

    @property
    def supply_plenum_name(self):
        """Get supply_plenum_name.

        Returns:
            str: the value of `supply_plenum_name` or None if not set

        """
        return self["Supply Plenum Name"]

    @supply_plenum_name.setter
    def supply_plenum_name(self, value=None):
        """Corresponds to IDD field `Supply Plenum Name` Plenum zone name.
        Supply plenum runs through only this zone. Blank if none.

        Args:
            value (str): value for IDD Field `Supply Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Plenum Name"] = value

    @property
    def return_plenum_name(self):
        """Get return_plenum_name.

        Returns:
            str: the value of `return_plenum_name` or None if not set

        """
        return self["Return Plenum Name"]

    @return_plenum_name.setter
    def return_plenum_name(self, value=None):
        """Corresponds to IDD field `Return Plenum Name` Plenum zone name.
        Return plenum runs through only this zone. Blank if none.

        Args:
            value (str): value for IDD Field `Return Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Plenum Name"] = value

    @property
    def baseboard_heating_type(self):
        """Get baseboard_heating_type.

        Returns:
            str: the value of `baseboard_heating_type` or None if not set

        """
        return self["Baseboard Heating Type"]

    @baseboard_heating_type.setter
    def baseboard_heating_type(self, value="None"):
        """Corresponds to IDD field `Baseboard Heating Type`

        Args:
            value (str): value for IDD Field `Baseboard Heating Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Type"] = value

    @property
    def baseboard_heating_availability_schedule_name(self):
        """Get baseboard_heating_availability_schedule_name.

        Returns:
            str: the value of `baseboard_heating_availability_schedule_name` or None if not set

        """
        return self["Baseboard Heating Availability Schedule Name"]

    @baseboard_heating_availability_schedule_name.setter
    def baseboard_heating_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Baseboard Heating Availability Schedule
        Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Baseboard Heating Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Availability Schedule Name"] = value

    @property
    def baseboard_heating_capacity(self):
        """Get baseboard_heating_capacity.

        Returns:
            float: the value of `baseboard_heating_capacity` or None if not set

        """
        return self["Baseboard Heating Capacity"]

    @baseboard_heating_capacity.setter
    def baseboard_heating_capacity(self, value="autosize"):
        """Corresponds to IDD field `Baseboard Heating Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Baseboard Heating Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Capacity"] = value

    @property
    def zone_cooling_design_supply_air_temperature_input_method(self):
        """Get zone_cooling_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_cooling_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Input Method"]

    @zone_cooling_design_supply_air_temperature_input_method.setter
    def zone_cooling_design_supply_air_temperature_input_method(
            self,
            value="SystemSupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference
        SystemSupplyAirTemperature = use the value from HVACTemplate:System:VAV Cooling Coil Design Setpoint

        Args:
            value (str): value for IDD Field `Zone Cooling Design Supply Air Temperature Input Method`
                Default value: SystemSupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Input Method"] = value

    @property
    def zone_cooling_design_supply_air_temperature(self):
        """Get zone_cooling_design_supply_air_temperature.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature"]

    @zone_cooling_design_supply_air_temperature.setter
    def zone_cooling_design_supply_air_temperature(self, value=12.8):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature`
                Units: C
                Default value: 12.8
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature"] = value

    @property
    def zone_cooling_design_supply_air_temperature_difference(self):
        """Get zone_cooling_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Difference"]

    @zone_cooling_design_supply_air_temperature_difference.setter
    def zone_cooling_design_supply_air_temperature_difference(
            self,
            value=11.11):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Difference`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be subtracted from the zone temperature
        at peak load to calculate the Zone Cooling Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 11.11
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Difference"] = value

    @property
    def zone_heating_design_supply_air_temperature_input_method(self):
        """Get zone_heating_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_heating_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Input Method"]

    @zone_heating_design_supply_air_temperature_input_method.setter
    def zone_heating_design_supply_air_temperature_input_method(
            self,
            value="SupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference

        Args:
            value (str): value for IDD Field `Zone Heating Design Supply Air Temperature Input Method`
                Default value: SupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Input Method"] = value

    @property
    def zone_heating_design_supply_air_temperature(self):
        """Get zone_heating_design_supply_air_temperature.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature"]

    @zone_heating_design_supply_air_temperature.setter
    def zone_heating_design_supply_air_temperature(self, value=50.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature`
                Units: C
                Default value: 50.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature"] = value

    @property
    def zone_heating_design_supply_air_temperature_difference(self):
        """Get zone_heating_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Difference"]

    @zone_heating_design_supply_air_temperature_difference.setter
    def zone_heating_design_supply_air_temperature_difference(
            self,
            value=30.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Difference`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be added to the zone temperature
        at peak load to calculate the Zone Heating Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 30.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Difference"] = value

    @property
    def design_specification_outdoor_air_object_name_for_sizing(self):
        """Get design_specification_outdoor_air_object_name_for_sizing.

        Returns:
            str: the value of `design_specification_outdoor_air_object_name_for_sizing` or None if not set

        """
        return self["Design Specification Outdoor Air Object Name for Sizing"]

    @design_specification_outdoor_air_object_name_for_sizing.setter
    def design_specification_outdoor_air_object_name_for_sizing(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Outdoor Air Object Name for Sizing`
        This field is used only when Outdoor Air Method=DetailedSpecification.
        Note that this field is used only for specifying the design outdoor air flow rate used
        for sizing. The field Design Specification Outdoor Air Object Name for Control
        (see above) is used to actively control the VAV terminal air flow rate.

        Args:
            value (str): value for IDD Field `Design Specification Outdoor Air Object Name for Sizing`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Outdoor Air Object Name for Sizing"] = value

    @property
    def design_specification_zone_air_distribution_object_name(self):
        """Get design_specification_zone_air_distribution_object_name.

        Returns:
            str: the value of `design_specification_zone_air_distribution_object_name` or None if not set

        """
        return self["Design Specification Zone Air Distribution Object Name"]

    @design_specification_zone_air_distribution_object_name.setter
    def design_specification_zone_air_distribution_object_name(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Zone Air Distribution Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Zone Air Distribution Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Zone Air Distribution Object Name"] = value




class HvactemplateZoneVavFanPowered(DataObject):

    """ Corresponds to IDD object `HVACTemplate:Zone:VAV:FanPowered`
        Zone terminal unit, fan powered variable volume, reheat optional.
        Referenced schedules must be defined elsewhere in the idf.
    """
    schema = {'min-fields': 31,
              'name': u'HVACTemplate:Zone:VAV:FanPowered',
              'pyname': u'HvactemplateZoneVavFanPowered',
              'format': None,
              'fields': OrderedDict([(u'zone name',
                                      {'name': u'Zone Name',
                                       'pyname': u'zone_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template vav system name',
                                      {'name': u'Template VAV System Name',
                                       'pyname': u'template_vav_system_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template thermostat name',
                                      {'name': u'Template Thermostat Name',
                                       'pyname': u'template_thermostat_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'primary supply air maximum flow rate',
                                      {'name': u'Primary Supply Air Maximum Flow Rate',
                                       'pyname': u'primary_supply_air_maximum_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'zone heating sizing factor',
                                      {'name': u'Zone Heating Sizing Factor',
                                       'pyname': u'zone_heating_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'zone cooling sizing factor',
                                      {'name': u'Zone Cooling Sizing Factor',
                                       'pyname': u'zone_cooling_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'primary supply air minimum flow fraction',
                                      {'name': u'Primary Supply Air Minimum Flow Fraction',
                                       'pyname': u'primary_supply_air_minimum_flow_fraction',
                                       'default': 'autosize',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'secondary supply air maximum flow rate',
                                      {'name': u'Secondary Supply Air Maximum Flow Rate',
                                       'pyname': u'secondary_supply_air_maximum_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'flow type',
                                      {'name': u'Flow Type',
                                       'pyname': u'flow_type',
                                       'default': u'Parallel',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Series',
                                                           u'Parallel',
                                                           u'SeriesFromPlenum',
                                                           u'ParallelFromPlenum'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'parallel fan on flow fraction',
                                      {'name': u'Parallel Fan On Flow Fraction',
                                       'pyname': u'parallel_fan_on_flow_fraction',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'outdoor air method',
                                      {'name': u'Outdoor Air Method',
                                       'pyname': u'outdoor_air_method',
                                       'default': u'Flow/Person',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Flow/Person',
                                                           u'Flow/Zone',
                                                           u'Flow/Area',
                                                           u'Sum',
                                                           u'Maximum',
                                                           u'DetailedSpecification'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'outdoor air flow rate per person',
                                      {'name': u'Outdoor Air Flow Rate per Person',
                                       'pyname': u'outdoor_air_flow_rate_per_person',
                                       'default': 0.00944,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate per zone floor area',
                                      {'name': u'Outdoor Air Flow Rate per Zone Floor Area',
                                       'pyname': u'outdoor_air_flow_rate_per_zone_floor_area',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s-m2'}),
                                     (u'outdoor air flow rate per zone',
                                      {'name': u'Outdoor Air Flow Rate per Zone',
                                       'pyname': u'outdoor_air_flow_rate_per_zone',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'reheat coil type',
                                      {'name': u'Reheat Coil Type',
                                       'pyname': u'reheat_coil_type',
                                       'default': u'Electric',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric',
                                                           u'Gas'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'reheat coil availability schedule name',
                                      {'name': u'Reheat Coil Availability Schedule Name',
                                       'pyname': u'reheat_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'fan total efficiency',
                                      {'name': u'Fan Total Efficiency',
                                       'pyname': u'fan_total_efficiency',
                                       'default': 0.7,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'fan delta pressure',
                                      {'name': u'Fan Delta Pressure',
                                       'pyname': u'fan_delta_pressure',
                                       'default': 1000.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'Pa'}),
                                     (u'fan motor efficiency',
                                      {'name': u'Fan Motor Efficiency',
                                       'pyname': u'fan_motor_efficiency',
                                       'default': 0.9,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supply plenum name',
                                      {'name': u'Supply Plenum Name',
                                       'pyname': u'supply_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'return plenum name',
                                      {'name': u'Return Plenum Name',
                                       'pyname': u'return_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating type',
                                      {'name': u'Baseboard Heating Type',
                                       'pyname': u'baseboard_heating_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'baseboard heating availability schedule name',
                                      {'name': u'Baseboard Heating Availability Schedule Name',
                                       'pyname': u'baseboard_heating_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating capacity',
                                      {'name': u'Baseboard Heating Capacity',
                                       'pyname': u'baseboard_heating_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'zone cooling design supply air temperature input method',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_input_method',
                                       'default': u'SystemSupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference',
                                                           u'SystemSupplyAirTemperature'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone cooling design supply air temperature',
                                      {'name': u'Zone Cooling Design Supply Air Temperature',
                                       'pyname': u'zone_cooling_design_supply_air_temperature',
                                       'default': 12.8,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone cooling design supply air temperature difference',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Difference',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_difference',
                                       'default': 11.11,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'zone heating design supply air temperature input method',
                                      {'name': u'Zone Heating Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_heating_design_supply_air_temperature_input_method',
                                       'default': u'SupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone heating design supply air temperature',
                                      {'name': u'Zone Heating Design Supply Air Temperature',
                                       'pyname': u'zone_heating_design_supply_air_temperature',
                                       'default': 50.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone heating design supply air temperature difference',
                                      {'name': u'Zone Heating Design Supply Air Temperature Difference',
                                       'pyname': u'zone_heating_design_supply_air_temperature_difference',
                                       'default': 30.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'zone piu fan schedule name',
                                      {'name': u'Zone PIU Fan Schedule Name',
                                       'pyname': u'zone_piu_fan_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'design specification outdoor air object name',
                                      {'name': u'Design Specification Outdoor Air Object Name',
                                       'pyname': u'design_specification_outdoor_air_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'design specification zone air distribution object name',
                                      {'name': u'Design Specification Zone Air Distribution Object Name',
                                       'pyname': u'design_specification_zone_air_distribution_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def zone_name(self):
        """Get zone_name.

        Returns:
            str: the value of `zone_name` or None if not set

        """
        return self["Zone Name"]

    @zone_name.setter
    def zone_name(self, value=None):
        """Corresponds to IDD field `Zone Name` Zone Name must match a building
        zone name.

        Args:
            value (str): value for IDD Field `Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Name"] = value

    @property
    def template_vav_system_name(self):
        """Get template_vav_system_name.

        Returns:
            str: the value of `template_vav_system_name` or None if not set

        """
        return self["Template VAV System Name"]

    @template_vav_system_name.setter
    def template_vav_system_name(self, value=None):
        """  Corresponds to IDD field `Template VAV System Name`
        Enter the name of a HVACTemplate:System:VAV or HVACTemplate:System:PackagedVAV
        object serving this zone.

        Args:
            value (str): value for IDD Field `Template VAV System Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template VAV System Name"] = value

    @property
    def template_thermostat_name(self):
        """Get template_thermostat_name.

        Returns:
            str: the value of `template_thermostat_name` or None if not set

        """
        return self["Template Thermostat Name"]

    @template_thermostat_name.setter
    def template_thermostat_name(self, value=None):
        """  Corresponds to IDD field `Template Thermostat Name`
        Enter the name of a HVACTemplate:Thermostat object.
        If blank, then it is assumed that standard thermostat objects
        have been defined for this zone.

        Args:
            value (str): value for IDD Field `Template Thermostat Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Thermostat Name"] = value

    @property
    def primary_supply_air_maximum_flow_rate(self):
        """Get primary_supply_air_maximum_flow_rate.

        Returns:
            float: the value of `primary_supply_air_maximum_flow_rate` or None if not set

        """
        return self["Primary Supply Air Maximum Flow Rate"]

    @primary_supply_air_maximum_flow_rate.setter
    def primary_supply_air_maximum_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Primary Supply Air Maximum Flow Rate` This
        field may be set to "autosize".  If a value is entered, it will be
        multiplied by the Supply Air Sizing Factor and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Primary Supply Air Maximum Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Primary Supply Air Maximum Flow Rate"] = value

    @property
    def zone_heating_sizing_factor(self):
        """Get zone_heating_sizing_factor.

        Returns:
            float: the value of `zone_heating_sizing_factor` or None if not set

        """
        return self["Zone Heating Sizing Factor"]

    @zone_heating_sizing_factor.setter
    def zone_heating_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Heating Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Heating Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Sizing Factor"] = value

    @property
    def zone_cooling_sizing_factor(self):
        """Get zone_cooling_sizing_factor.

        Returns:
            float: the value of `zone_cooling_sizing_factor` or None if not set

        """
        return self["Zone Cooling Sizing Factor"]

    @zone_cooling_sizing_factor.setter
    def zone_cooling_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Cooling Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Cooling Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Sizing Factor"] = value

    @property
    def primary_supply_air_minimum_flow_fraction(self):
        """Get primary_supply_air_minimum_flow_fraction.

        Returns:
            float: the value of `primary_supply_air_minimum_flow_fraction` or None if not set

        """
        return self["Primary Supply Air Minimum Flow Fraction"]

    @primary_supply_air_minimum_flow_fraction.setter
    def primary_supply_air_minimum_flow_fraction(self, value="autosize"):
        """Corresponds to IDD field `Primary Supply Air Minimum Flow Fraction`

        Args:
            value (float or "Autosize"): value for IDD Field `Primary Supply Air Minimum Flow Fraction`
                Default value: "autosize"
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Primary Supply Air Minimum Flow Fraction"] = value

    @property
    def secondary_supply_air_maximum_flow_rate(self):
        """Get secondary_supply_air_maximum_flow_rate.

        Returns:
            float: the value of `secondary_supply_air_maximum_flow_rate` or None if not set

        """
        return self["Secondary Supply Air Maximum Flow Rate"]

    @secondary_supply_air_maximum_flow_rate.setter
    def secondary_supply_air_maximum_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Secondary Supply Air Maximum Flow Rate`
        This field may be set to "autosize".  If a value is entered, it will be
        multiplied by the Supply Air Sizing Factor and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Secondary Supply Air Maximum Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Secondary Supply Air Maximum Flow Rate"] = value

    @property
    def flow_type(self):
        """Get flow_type.

        Returns:
            str: the value of `flow_type` or None if not set

        """
        return self["Flow Type"]

    @flow_type.setter
    def flow_type(self, value="Parallel"):
        """Corresponds to IDD field `Flow Type`

        Args:
            value (str): value for IDD Field `Flow Type`
                Default value: Parallel
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Flow Type"] = value

    @property
    def parallel_fan_on_flow_fraction(self):
        """Get parallel_fan_on_flow_fraction.

        Returns:
            float: the value of `parallel_fan_on_flow_fraction` or None if not set

        """
        return self["Parallel Fan On Flow Fraction"]

    @parallel_fan_on_flow_fraction.setter
    def parallel_fan_on_flow_fraction(self, value="autosize"):
        """Corresponds to IDD field `Parallel Fan On Flow Fraction` The
        fraction of the primary air flow at which fan turns on Applicable only
        to Parallel Flow Type.

        Args:
            value (float or "Autosize"): value for IDD Field `Parallel Fan On Flow Fraction`
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Parallel Fan On Flow Fraction"] = value

    @property
    def outdoor_air_method(self):
        """Get outdoor_air_method.

        Returns:
            str: the value of `outdoor_air_method` or None if not set

        """
        return self["Outdoor Air Method"]

    @outdoor_air_method.setter
    def outdoor_air_method(self, value="Flow/Person"):
        """  Corresponds to IDD field `Outdoor Air Method`
        Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
        fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
        and Outdoor Air Flow Rate per Zone.
        DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
        references design specification objects named in the fields
        Design Specification Outdoor Air Object Name and Design Specification Zone Air
        Distribution Object Name.

        Args:
            value (str): value for IDD Field `Outdoor Air Method`
                Default value: Flow/Person
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Method"] = value

    @property
    def outdoor_air_flow_rate_per_person(self):
        """Get outdoor_air_flow_rate_per_person.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_person` or None if not set

        """
        return self["Outdoor Air Flow Rate per Person"]

    @outdoor_air_flow_rate_per_person.setter
    def outdoor_air_flow_rate_per_person(self, value=0.00944):
        """  Corresponds to IDD field `Outdoor Air Flow Rate per Person`
        Default 0.00944 is 20 cfm per person
        This input is used if the field Outdoor Air Method is
        Flow/Person, Sum, or Maximum

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Person`
                Units: m3/s
                Default value: 0.00944
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Flow Rate per Person"] = value

    @property
    def outdoor_air_flow_rate_per_zone_floor_area(self):
        """Get outdoor_air_flow_rate_per_zone_floor_area.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone_floor_area` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone Floor Area"]

    @outdoor_air_flow_rate_per_zone_floor_area.setter
    def outdoor_air_flow_rate_per_zone_floor_area(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone Floor Area`
        This input is used if the field Outdoor Air Method is Flow/area, Sum,
        or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone Floor Area`
                Units: m3/s-m2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone Floor Area"] = value

    @property
    def outdoor_air_flow_rate_per_zone(self):
        """Get outdoor_air_flow_rate_per_zone.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone"]

    @outdoor_air_flow_rate_per_zone.setter
    def outdoor_air_flow_rate_per_zone(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone` This input
        is used if the field Outdoor Air Method is Flow/Zone, Sum, or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone"] = value

    @property
    def reheat_coil_type(self):
        """Get reheat_coil_type.

        Returns:
            str: the value of `reheat_coil_type` or None if not set

        """
        return self["Reheat Coil Type"]

    @reheat_coil_type.setter
    def reheat_coil_type(self, value="Electric"):
        """Corresponds to IDD field `Reheat Coil Type`

        Args:
            value (str): value for IDD Field `Reheat Coil Type`
                Default value: Electric
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Reheat Coil Type"] = value

    @property
    def reheat_coil_availability_schedule_name(self):
        """Get reheat_coil_availability_schedule_name.

        Returns:
            str: the value of `reheat_coil_availability_schedule_name` or None if not set

        """
        return self["Reheat Coil Availability Schedule Name"]

    @reheat_coil_availability_schedule_name.setter
    def reheat_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Reheat Coil Availability Schedule Name` If
        blank, always on.

        Args:
            value (str): value for IDD Field `Reheat Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Reheat Coil Availability Schedule Name"] = value

    @property
    def fan_total_efficiency(self):
        """Get fan_total_efficiency.

        Returns:
            float: the value of `fan_total_efficiency` or None if not set

        """
        return self["Fan Total Efficiency"]

    @fan_total_efficiency.setter
    def fan_total_efficiency(self, value=0.7):
        """Corresponds to IDD field `Fan Total Efficiency`

        Args:
            value (float): value for IDD Field `Fan Total Efficiency`
                Default value: 0.7
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Fan Total Efficiency"] = value

    @property
    def fan_delta_pressure(self):
        """Get fan_delta_pressure.

        Returns:
            float: the value of `fan_delta_pressure` or None if not set

        """
        return self["Fan Delta Pressure"]

    @fan_delta_pressure.setter
    def fan_delta_pressure(self, value=1000.0):
        """Corresponds to IDD field `Fan Delta Pressure`

        Args:
            value (float): value for IDD Field `Fan Delta Pressure`
                Units: Pa
                IP-Units: inH2O
                Default value: 1000.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Fan Delta Pressure"] = value

    @property
    def fan_motor_efficiency(self):
        """Get fan_motor_efficiency.

        Returns:
            float: the value of `fan_motor_efficiency` or None if not set

        """
        return self["Fan Motor Efficiency"]

    @fan_motor_efficiency.setter
    def fan_motor_efficiency(self, value=0.9):
        """Corresponds to IDD field `Fan Motor Efficiency`

        Args:
            value (float): value for IDD Field `Fan Motor Efficiency`
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Fan Motor Efficiency"] = value

    @property
    def supply_plenum_name(self):
        """Get supply_plenum_name.

        Returns:
            str: the value of `supply_plenum_name` or None if not set

        """
        return self["Supply Plenum Name"]

    @supply_plenum_name.setter
    def supply_plenum_name(self, value=None):
        """Corresponds to IDD field `Supply Plenum Name` Plenum zone name.
        Supply plenum runs through only this zone. Blank if none.

        Args:
            value (str): value for IDD Field `Supply Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Plenum Name"] = value

    @property
    def return_plenum_name(self):
        """Get return_plenum_name.

        Returns:
            str: the value of `return_plenum_name` or None if not set

        """
        return self["Return Plenum Name"]

    @return_plenum_name.setter
    def return_plenum_name(self, value=None):
        """Corresponds to IDD field `Return Plenum Name` Plenum zone name.
        Return plenum runs through only this zone. Blank if none.

        Args:
            value (str): value for IDD Field `Return Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Plenum Name"] = value

    @property
    def baseboard_heating_type(self):
        """Get baseboard_heating_type.

        Returns:
            str: the value of `baseboard_heating_type` or None if not set

        """
        return self["Baseboard Heating Type"]

    @baseboard_heating_type.setter
    def baseboard_heating_type(self, value="None"):
        """Corresponds to IDD field `Baseboard Heating Type`

        Args:
            value (str): value for IDD Field `Baseboard Heating Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Type"] = value

    @property
    def baseboard_heating_availability_schedule_name(self):
        """Get baseboard_heating_availability_schedule_name.

        Returns:
            str: the value of `baseboard_heating_availability_schedule_name` or None if not set

        """
        return self["Baseboard Heating Availability Schedule Name"]

    @baseboard_heating_availability_schedule_name.setter
    def baseboard_heating_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Baseboard Heating Availability Schedule
        Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Baseboard Heating Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Availability Schedule Name"] = value

    @property
    def baseboard_heating_capacity(self):
        """Get baseboard_heating_capacity.

        Returns:
            float: the value of `baseboard_heating_capacity` or None if not set

        """
        return self["Baseboard Heating Capacity"]

    @baseboard_heating_capacity.setter
    def baseboard_heating_capacity(self, value="autosize"):
        """Corresponds to IDD field `Baseboard Heating Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Baseboard Heating Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Capacity"] = value

    @property
    def zone_cooling_design_supply_air_temperature_input_method(self):
        """Get zone_cooling_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_cooling_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Input Method"]

    @zone_cooling_design_supply_air_temperature_input_method.setter
    def zone_cooling_design_supply_air_temperature_input_method(
            self,
            value="SystemSupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference
        SystemSupplyAirTemperature = use the value from HVACTemplate:System:VAV Cooling Coil Design Setpoint

        Args:
            value (str): value for IDD Field `Zone Cooling Design Supply Air Temperature Input Method`
                Default value: SystemSupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Input Method"] = value

    @property
    def zone_cooling_design_supply_air_temperature(self):
        """Get zone_cooling_design_supply_air_temperature.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature"]

    @zone_cooling_design_supply_air_temperature.setter
    def zone_cooling_design_supply_air_temperature(self, value=12.8):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature`
                Units: C
                Default value: 12.8
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature"] = value

    @property
    def zone_cooling_design_supply_air_temperature_difference(self):
        """Get zone_cooling_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Difference"]

    @zone_cooling_design_supply_air_temperature_difference.setter
    def zone_cooling_design_supply_air_temperature_difference(
            self,
            value=11.11):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Difference`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be subtracted from the zone temperature
        at peak load to calculate the Zone Cooling Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 11.11
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Difference"] = value

    @property
    def zone_heating_design_supply_air_temperature_input_method(self):
        """Get zone_heating_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_heating_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Input Method"]

    @zone_heating_design_supply_air_temperature_input_method.setter
    def zone_heating_design_supply_air_temperature_input_method(
            self,
            value="SupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference

        Args:
            value (str): value for IDD Field `Zone Heating Design Supply Air Temperature Input Method`
                Default value: SupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Input Method"] = value

    @property
    def zone_heating_design_supply_air_temperature(self):
        """Get zone_heating_design_supply_air_temperature.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature"]

    @zone_heating_design_supply_air_temperature.setter
    def zone_heating_design_supply_air_temperature(self, value=50.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature`
                Units: C
                Default value: 50.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature"] = value

    @property
    def zone_heating_design_supply_air_temperature_difference(self):
        """Get zone_heating_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Difference"]

    @zone_heating_design_supply_air_temperature_difference.setter
    def zone_heating_design_supply_air_temperature_difference(
            self,
            value=30.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Difference`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be added to the zone temperature
        at peak load to calculate the Zone Heating Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 30.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Difference"] = value

    @property
    def zone_piu_fan_schedule_name(self):
        """Get zone_piu_fan_schedule_name.

        Returns:
            str: the value of `zone_piu_fan_schedule_name` or None if not set

        """
        return self["Zone PIU Fan Schedule Name"]

    @zone_piu_fan_schedule_name.setter
    def zone_piu_fan_schedule_name(self, value=None):
        """  Corresponds to IDD field `Zone PIU Fan Schedule Name`
        This is the operating schedule for the zone PIU fan.
        For a parallel PIU, the fan operates only when the primary air flow is below the
        Parallel Fan On Flow Fraction and the Zone PIU Fan Schedule is on, or it is
        activated by an availability manager.
        For a series PIU, the zone fan operates whenever the Zone PIU Fan Schedule is on, or it
        is activated by an availability manager.
        If this field is left blank, the System Availability Schedule for the
        HVACTemplate:System serving this zone will be used.

        Args:
            value (str): value for IDD Field `Zone PIU Fan Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone PIU Fan Schedule Name"] = value

    @property
    def design_specification_outdoor_air_object_name(self):
        """Get design_specification_outdoor_air_object_name.

        Returns:
            str: the value of `design_specification_outdoor_air_object_name` or None if not set

        """
        return self["Design Specification Outdoor Air Object Name"]

    @design_specification_outdoor_air_object_name.setter
    def design_specification_outdoor_air_object_name(self, value=None):
        """Corresponds to IDD field `Design Specification Outdoor Air Object
        Name`

        Args:
            value (str): value for IDD Field `Design Specification Outdoor Air Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Design Specification Outdoor Air Object Name"] = value

    @property
    def design_specification_zone_air_distribution_object_name(self):
        """Get design_specification_zone_air_distribution_object_name.

        Returns:
            str: the value of `design_specification_zone_air_distribution_object_name` or None if not set

        """
        return self["Design Specification Zone Air Distribution Object Name"]

    @design_specification_zone_air_distribution_object_name.setter
    def design_specification_zone_air_distribution_object_name(
            self,
            value=None):
        """Corresponds to IDD field `Design Specification Zone Air Distribution
        Object Name`

        Args:
            value (str): value for IDD Field `Design Specification Zone Air Distribution Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Design Specification Zone Air Distribution Object Name"] = value




class HvactemplateZoneVavHeatAndCool(DataObject):

    """ Corresponds to IDD object `HVACTemplate:Zone:VAV:HeatAndCool`
        VAV system with VAV for both heating and cooling and optional rehaert coil.
        For heating, this unit increases airflow first, then activates reheat coil.
    """
    schema = {'min-fields': 27,
              'name': u'HVACTemplate:Zone:VAV:HeatAndCool',
              'pyname': u'HvactemplateZoneVavHeatAndCool',
              'format': None,
              'fields': OrderedDict([(u'zone name',
                                      {'name': u'Zone Name',
                                       'pyname': u'zone_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template vav system name',
                                      {'name': u'Template VAV System Name',
                                       'pyname': u'template_vav_system_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template thermostat name',
                                      {'name': u'Template Thermostat Name',
                                       'pyname': u'template_thermostat_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply air maximum flow rate',
                                      {'name': u'Supply Air Maximum Flow Rate',
                                       'pyname': u'supply_air_maximum_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'zone heating sizing factor',
                                      {'name': u'Zone Heating Sizing Factor',
                                       'pyname': u'zone_heating_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'zone cooling sizing factor',
                                      {'name': u'Zone Cooling Sizing Factor',
                                       'pyname': u'zone_cooling_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'constant minimum air flow fraction',
                                      {'name': u'Constant Minimum Air Flow Fraction',
                                       'pyname': u'constant_minimum_air_flow_fraction',
                                       'default': 0.2,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'outdoor air method',
                                      {'name': u'Outdoor Air Method',
                                       'pyname': u'outdoor_air_method',
                                       'default': u'Flow/Person',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Flow/Person',
                                                           u'Flow/Zone',
                                                           u'Flow/Area',
                                                           u'Sum',
                                                           u'Maximum',
                                                           u'DetailedSpecification'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'outdoor air flow rate per person',
                                      {'name': u'Outdoor Air Flow Rate per Person',
                                       'pyname': u'outdoor_air_flow_rate_per_person',
                                       'default': 0.00944,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate per zone floor area',
                                      {'name': u'Outdoor Air Flow Rate per Zone Floor Area',
                                       'pyname': u'outdoor_air_flow_rate_per_zone_floor_area',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s-m2'}),
                                     (u'outdoor air flow rate per zone',
                                      {'name': u'Outdoor Air Flow Rate per Zone',
                                       'pyname': u'outdoor_air_flow_rate_per_zone',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'design specification outdoor air object name for sizing',
                                      {'name': u'Design Specification Outdoor Air Object Name for Sizing',
                                       'pyname': u'design_specification_outdoor_air_object_name_for_sizing',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'design specification zone air distribution object name',
                                      {'name': u'Design Specification Zone Air Distribution Object Name',
                                       'pyname': u'design_specification_zone_air_distribution_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'reheat coil type',
                                      {'name': u'Reheat Coil Type',
                                       'pyname': u'reheat_coil_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric',
                                                           u'Gas',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'reheat coil availability schedule name',
                                      {'name': u'Reheat Coil Availability Schedule Name',
                                       'pyname': u'reheat_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'maximum reheat air temperature',
                                      {'name': u'Maximum Reheat Air Temperature',
                                       'pyname': u'maximum_reheat_air_temperature',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'supply plenum name',
                                      {'name': u'Supply Plenum Name',
                                       'pyname': u'supply_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'return plenum name',
                                      {'name': u'Return Plenum Name',
                                       'pyname': u'return_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating type',
                                      {'name': u'Baseboard Heating Type',
                                       'pyname': u'baseboard_heating_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'baseboard heating availability schedule name',
                                      {'name': u'Baseboard Heating Availability Schedule Name',
                                       'pyname': u'baseboard_heating_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating capacity',
                                      {'name': u'Baseboard Heating Capacity',
                                       'pyname': u'baseboard_heating_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'zone cooling design supply air temperature input method',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_input_method',
                                       'default': u'SystemSupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference',
                                                           u'SystemSupplyAirTemperature'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone cooling design supply air temperature',
                                      {'name': u'Zone Cooling Design Supply Air Temperature',
                                       'pyname': u'zone_cooling_design_supply_air_temperature',
                                       'default': 12.8,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone cooling design supply air temperature difference',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Difference',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_difference',
                                       'default': 11.11,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'zone heating design supply air temperature input method',
                                      {'name': u'Zone Heating Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_heating_design_supply_air_temperature_input_method',
                                       'default': u'SupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone heating design supply air temperature',
                                      {'name': u'Zone Heating Design Supply Air Temperature',
                                       'pyname': u'zone_heating_design_supply_air_temperature',
                                       'default': 50.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone heating design supply air temperature difference',
                                      {'name': u'Zone Heating Design Supply Air Temperature Difference',
                                       'pyname': u'zone_heating_design_supply_air_temperature_difference',
                                       'default': 30.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def zone_name(self):
        """Get zone_name.

        Returns:
            str: the value of `zone_name` or None if not set

        """
        return self["Zone Name"]

    @zone_name.setter
    def zone_name(self, value=None):
        """Corresponds to IDD field `Zone Name` Zone name must match a building
        zone name.

        Args:
            value (str): value for IDD Field `Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Name"] = value

    @property
    def template_vav_system_name(self):
        """Get template_vav_system_name.

        Returns:
            str: the value of `template_vav_system_name` or None if not set

        """
        return self["Template VAV System Name"]

    @template_vav_system_name.setter
    def template_vav_system_name(self, value=None):
        """  Corresponds to IDD field `Template VAV System Name`
        Name of a HVACTemplate:System:VAV or HVACTemplate:System:PackagedVAV
        object serving this zone

        Args:
            value (str): value for IDD Field `Template VAV System Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template VAV System Name"] = value

    @property
    def template_thermostat_name(self):
        """Get template_thermostat_name.

        Returns:
            str: the value of `template_thermostat_name` or None if not set

        """
        return self["Template Thermostat Name"]

    @template_thermostat_name.setter
    def template_thermostat_name(self, value=None):
        """  Corresponds to IDD field `Template Thermostat Name`
        Enter the name of a HVACTemplate:Thermostat object.
        If blank, then it is assumed that standard thermostat objects
        have been defined for this zone.

        Args:
            value (str): value for IDD Field `Template Thermostat Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Thermostat Name"] = value

    @property
    def supply_air_maximum_flow_rate(self):
        """Get supply_air_maximum_flow_rate.

        Returns:
            float: the value of `supply_air_maximum_flow_rate` or None if not set

        """
        return self["Supply Air Maximum Flow Rate"]

    @supply_air_maximum_flow_rate.setter
    def supply_air_maximum_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Supply Air Maximum Flow Rate` This field
        may be set to "autosize".  If a value is entered, it will be multiplied
        by the Supply Air Sizing Factor and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Supply Air Maximum Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Air Maximum Flow Rate"] = value

    @property
    def zone_heating_sizing_factor(self):
        """Get zone_heating_sizing_factor.

        Returns:
            float: the value of `zone_heating_sizing_factor` or None if not set

        """
        return self["Zone Heating Sizing Factor"]

    @zone_heating_sizing_factor.setter
    def zone_heating_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Heating Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Heating Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Sizing Factor"] = value

    @property
    def zone_cooling_sizing_factor(self):
        """Get zone_cooling_sizing_factor.

        Returns:
            float: the value of `zone_cooling_sizing_factor` or None if not set

        """
        return self["Zone Cooling Sizing Factor"]

    @zone_cooling_sizing_factor.setter
    def zone_cooling_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Cooling Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Cooling Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Sizing Factor"] = value

    @property
    def constant_minimum_air_flow_fraction(self):
        """Get constant_minimum_air_flow_fraction.

        Returns:
            float: the value of `constant_minimum_air_flow_fraction` or None if not set

        """
        return self["Constant Minimum Air Flow Fraction"]

    @constant_minimum_air_flow_fraction.setter
    def constant_minimum_air_flow_fraction(self, value=0.2):
        """  Corresponds to IDD field `Constant Minimum Air Flow Fraction`
        This field is used if the field Zone Minimum Air Flow Input Method is Constant
        If the field Zone Minimum Air Flow Input Method is Scheduled, then this field
        is optional. If a value is entered, then it is used for sizing normal-action reheat coils.
        If both this field and the following field are entered, the larger result is used.

        Args:
            value (float): value for IDD Field `Constant Minimum Air Flow Fraction`
                Default value: 0.2
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Constant Minimum Air Flow Fraction"] = value

    @property
    def outdoor_air_method(self):
        """Get outdoor_air_method.

        Returns:
            str: the value of `outdoor_air_method` or None if not set

        """
        return self["Outdoor Air Method"]

    @outdoor_air_method.setter
    def outdoor_air_method(self, value="Flow/Person"):
        """  Corresponds to IDD field `Outdoor Air Method`
        Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
        fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
        and Outdoor Air Flow Rate per Zone.
        DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
        references design specification objects named in the fields
        Design Specification Outdoor Air Object Name and Design Specification Zone Air
        Distribution Object Name.

        Args:
            value (str): value for IDD Field `Outdoor Air Method`
                Default value: Flow/Person
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Method"] = value

    @property
    def outdoor_air_flow_rate_per_person(self):
        """Get outdoor_air_flow_rate_per_person.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_person` or None if not set

        """
        return self["Outdoor Air Flow Rate per Person"]

    @outdoor_air_flow_rate_per_person.setter
    def outdoor_air_flow_rate_per_person(self, value=0.00944):
        """  Corresponds to IDD field `Outdoor Air Flow Rate per Person`
        Default 0.00944 is 20 cfm per person
        This input is used if the field Outdoor Air Method is
        Flow/Person, Sum, or Maximum

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Person`
                Units: m3/s
                Default value: 0.00944
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Flow Rate per Person"] = value

    @property
    def outdoor_air_flow_rate_per_zone_floor_area(self):
        """Get outdoor_air_flow_rate_per_zone_floor_area.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone_floor_area` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone Floor Area"]

    @outdoor_air_flow_rate_per_zone_floor_area.setter
    def outdoor_air_flow_rate_per_zone_floor_area(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone Floor Area`
        This input is used if the field Outdoor Air Method is Flow/Area, Sum,
        or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone Floor Area`
                Units: m3/s-m2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone Floor Area"] = value

    @property
    def outdoor_air_flow_rate_per_zone(self):
        """Get outdoor_air_flow_rate_per_zone.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone"]

    @outdoor_air_flow_rate_per_zone.setter
    def outdoor_air_flow_rate_per_zone(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone` This input
        is used if the field Outdoor Air Method is Flow/Zone, Sum, or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone"] = value

    @property
    def design_specification_outdoor_air_object_name_for_sizing(self):
        """Get design_specification_outdoor_air_object_name_for_sizing.

        Returns:
            str: the value of `design_specification_outdoor_air_object_name_for_sizing` or None if not set

        """
        return self["Design Specification Outdoor Air Object Name for Sizing"]

    @design_specification_outdoor_air_object_name_for_sizing.setter
    def design_specification_outdoor_air_object_name_for_sizing(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Outdoor Air Object Name for Sizing`
        This field is used only when Outdoor Air Method=DetailedSpecification.
        Note that this field is used only for specifying the design outdoor air flow rate used
        for sizing. The field Design Specification Outdoor Air Object Name for Control
        (see above) is used to actively control the VAV terminal air flow rate.

        Args:
            value (str): value for IDD Field `Design Specification Outdoor Air Object Name for Sizing`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Outdoor Air Object Name for Sizing"] = value

    @property
    def design_specification_zone_air_distribution_object_name(self):
        """Get design_specification_zone_air_distribution_object_name.

        Returns:
            str: the value of `design_specification_zone_air_distribution_object_name` or None if not set

        """
        return self["Design Specification Zone Air Distribution Object Name"]

    @design_specification_zone_air_distribution_object_name.setter
    def design_specification_zone_air_distribution_object_name(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Zone Air Distribution Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Zone Air Distribution Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Zone Air Distribution Object Name"] = value

    @property
    def reheat_coil_type(self):
        """Get reheat_coil_type.

        Returns:
            str: the value of `reheat_coil_type` or None if not set

        """
        return self["Reheat Coil Type"]

    @reheat_coil_type.setter
    def reheat_coil_type(self, value="None"):
        """Corresponds to IDD field `Reheat Coil Type`

        Args:
            value (str): value for IDD Field `Reheat Coil Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Reheat Coil Type"] = value

    @property
    def reheat_coil_availability_schedule_name(self):
        """Get reheat_coil_availability_schedule_name.

        Returns:
            str: the value of `reheat_coil_availability_schedule_name` or None if not set

        """
        return self["Reheat Coil Availability Schedule Name"]

    @reheat_coil_availability_schedule_name.setter
    def reheat_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Reheat Coil Availability Schedule Name` If
        blank, always on.

        Args:
            value (str): value for IDD Field `Reheat Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Reheat Coil Availability Schedule Name"] = value

    @property
    def maximum_reheat_air_temperature(self):
        """Get maximum_reheat_air_temperature.

        Returns:
            float: the value of `maximum_reheat_air_temperature` or None if not set

        """
        return self["Maximum Reheat Air Temperature"]

    @maximum_reheat_air_temperature.setter
    def maximum_reheat_air_temperature(self, value=None):
        """Corresponds to IDD field `Maximum Reheat Air Temperature` Specifies
        the maximum allowable supply air temperature leaving the reheat coil.
        If left blank, there is no limit and no default. If unknown, 35C (95F)
        is recommended.

        Args:
            value (float): value for IDD Field `Maximum Reheat Air Temperature`
                Units: C
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Maximum Reheat Air Temperature"] = value

    @property
    def supply_plenum_name(self):
        """Get supply_plenum_name.

        Returns:
            str: the value of `supply_plenum_name` or None if not set

        """
        return self["Supply Plenum Name"]

    @supply_plenum_name.setter
    def supply_plenum_name(self, value=None):
        """Corresponds to IDD field `Supply Plenum Name` Plenum zone name.
        Supply plenum runs through only this zone. Blank if none.

        Args:
            value (str): value for IDD Field `Supply Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Plenum Name"] = value

    @property
    def return_plenum_name(self):
        """Get return_plenum_name.

        Returns:
            str: the value of `return_plenum_name` or None if not set

        """
        return self["Return Plenum Name"]

    @return_plenum_name.setter
    def return_plenum_name(self, value=None):
        """Corresponds to IDD field `Return Plenum Name` Plenum zone name.
        Return plenum runs through only this zone. Blank if none.

        Args:
            value (str): value for IDD Field `Return Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Plenum Name"] = value

    @property
    def baseboard_heating_type(self):
        """Get baseboard_heating_type.

        Returns:
            str: the value of `baseboard_heating_type` or None if not set

        """
        return self["Baseboard Heating Type"]

    @baseboard_heating_type.setter
    def baseboard_heating_type(self, value="None"):
        """Corresponds to IDD field `Baseboard Heating Type`

        Args:
            value (str): value for IDD Field `Baseboard Heating Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Type"] = value

    @property
    def baseboard_heating_availability_schedule_name(self):
        """Get baseboard_heating_availability_schedule_name.

        Returns:
            str: the value of `baseboard_heating_availability_schedule_name` or None if not set

        """
        return self["Baseboard Heating Availability Schedule Name"]

    @baseboard_heating_availability_schedule_name.setter
    def baseboard_heating_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Baseboard Heating Availability Schedule
        Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Baseboard Heating Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Availability Schedule Name"] = value

    @property
    def baseboard_heating_capacity(self):
        """Get baseboard_heating_capacity.

        Returns:
            float: the value of `baseboard_heating_capacity` or None if not set

        """
        return self["Baseboard Heating Capacity"]

    @baseboard_heating_capacity.setter
    def baseboard_heating_capacity(self, value="autosize"):
        """Corresponds to IDD field `Baseboard Heating Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Baseboard Heating Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Capacity"] = value

    @property
    def zone_cooling_design_supply_air_temperature_input_method(self):
        """Get zone_cooling_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_cooling_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Input Method"]

    @zone_cooling_design_supply_air_temperature_input_method.setter
    def zone_cooling_design_supply_air_temperature_input_method(
            self,
            value="SystemSupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference
        SystemSupplyAirTemperature = use the value from HVACTemplate:System:VAV Cooling Coil Design Setpoint

        Args:
            value (str): value for IDD Field `Zone Cooling Design Supply Air Temperature Input Method`
                Default value: SystemSupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Input Method"] = value

    @property
    def zone_cooling_design_supply_air_temperature(self):
        """Get zone_cooling_design_supply_air_temperature.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature"]

    @zone_cooling_design_supply_air_temperature.setter
    def zone_cooling_design_supply_air_temperature(self, value=12.8):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature`
                Units: C
                Default value: 12.8
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature"] = value

    @property
    def zone_cooling_design_supply_air_temperature_difference(self):
        """Get zone_cooling_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Difference"]

    @zone_cooling_design_supply_air_temperature_difference.setter
    def zone_cooling_design_supply_air_temperature_difference(
            self,
            value=11.11):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Difference`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be subtracted from the zone temperature
        at peak load to calculate the Zone Cooling Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 11.11
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Difference"] = value

    @property
    def zone_heating_design_supply_air_temperature_input_method(self):
        """Get zone_heating_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_heating_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Input Method"]

    @zone_heating_design_supply_air_temperature_input_method.setter
    def zone_heating_design_supply_air_temperature_input_method(
            self,
            value="SupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
        SystemSupplyAirTemperature = use the value from HVACTemplate:System:VAV Heating Coil Design Setpoint
        TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference

        Args:
            value (str): value for IDD Field `Zone Heating Design Supply Air Temperature Input Method`
                Default value: SupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Input Method"] = value

    @property
    def zone_heating_design_supply_air_temperature(self):
        """Get zone_heating_design_supply_air_temperature.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature"]

    @zone_heating_design_supply_air_temperature.setter
    def zone_heating_design_supply_air_temperature(self, value=50.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature`
                Units: C
                Default value: 50.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature"] = value

    @property
    def zone_heating_design_supply_air_temperature_difference(self):
        """Get zone_heating_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Difference"]

    @zone_heating_design_supply_air_temperature_difference.setter
    def zone_heating_design_supply_air_temperature_difference(
            self,
            value=30.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Difference`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be added to the zone temperature
        at peak load to calculate the Zone Heating Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 30.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Difference"] = value




class HvactemplateZoneConstantVolume(DataObject):

    """ Corresponds to IDD object `HVACTemplate:Zone:ConstantVolume`
        Zone terminal unit, constant volume, reheat optional.
        Referenced schedules must be defined elsewhere in the idf.
    """
    schema = {'min-fields': 24,
              'name': u'HVACTemplate:Zone:ConstantVolume',
              'pyname': u'HvactemplateZoneConstantVolume',
              'format': None,
              'fields': OrderedDict([(u'zone name',
                                      {'name': u'Zone Name',
                                       'pyname': u'zone_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template constant volume system name',
                                      {'name': u'Template Constant Volume System Name',
                                       'pyname': u'template_constant_volume_system_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template thermostat name',
                                      {'name': u'Template Thermostat Name',
                                       'pyname': u'template_thermostat_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply air maximum flow rate',
                                      {'name': u'Supply Air Maximum Flow Rate',
                                       'pyname': u'supply_air_maximum_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'zone heating sizing factor',
                                      {'name': u'Zone Heating Sizing Factor',
                                       'pyname': u'zone_heating_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'zone cooling sizing factor',
                                      {'name': u'Zone Cooling Sizing Factor',
                                       'pyname': u'zone_cooling_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'outdoor air method',
                                      {'name': u'Outdoor Air Method',
                                       'pyname': u'outdoor_air_method',
                                       'default': u'Flow/Person',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Flow/Person',
                                                           u'Flow/Zone',
                                                           u'Flow/Area',
                                                           u'Sum',
                                                           u'Maximum',
                                                           u'DetailedSpecification'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'outdoor air flow rate per person',
                                      {'name': u'Outdoor Air Flow Rate per Person',
                                       'pyname': u'outdoor_air_flow_rate_per_person',
                                       'default': 0.00944,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate per zone floor area',
                                      {'name': u'Outdoor Air Flow Rate per Zone Floor Area',
                                       'pyname': u'outdoor_air_flow_rate_per_zone_floor_area',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s-m2'}),
                                     (u'outdoor air flow rate per zone',
                                      {'name': u'Outdoor Air Flow Rate per Zone',
                                       'pyname': u'outdoor_air_flow_rate_per_zone',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'design specification outdoor air object name',
                                      {'name': u'Design Specification Outdoor Air Object name',
                                       'pyname': u'design_specification_outdoor_air_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'design specification zone air distribution object name',
                                      {'name': u'Design Specification Zone Air Distribution Object Name',
                                       'pyname': u'design_specification_zone_air_distribution_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'reheat coil type',
                                      {'name': u'Reheat Coil Type',
                                       'pyname': u'reheat_coil_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric',
                                                           u'Gas',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'reheat coil availability schedule name',
                                      {'name': u'Reheat Coil Availability Schedule Name',
                                       'pyname': u'reheat_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'maximum reheat air temperature',
                                      {'name': u'Maximum Reheat Air Temperature',
                                       'pyname': u'maximum_reheat_air_temperature',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'supply plenum name',
                                      {'name': u'Supply Plenum Name',
                                       'pyname': u'supply_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'return plenum name',
                                      {'name': u'Return Plenum Name',
                                       'pyname': u'return_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating type',
                                      {'name': u'Baseboard Heating Type',
                                       'pyname': u'baseboard_heating_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'baseboard heating availability schedule name',
                                      {'name': u'Baseboard Heating Availability Schedule Name',
                                       'pyname': u'baseboard_heating_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating capacity',
                                      {'name': u'Baseboard Heating Capacity',
                                       'pyname': u'baseboard_heating_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'zone cooling design supply air temperature input method',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_input_method',
                                       'default': u'SystemSupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference',
                                                           u'SystemSupplyAirTemperature'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone cooling design supply air temperature',
                                      {'name': u'Zone Cooling Design Supply Air Temperature',
                                       'pyname': u'zone_cooling_design_supply_air_temperature',
                                       'default': 12.8,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone cooling design supply air temperature difference',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Difference',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_difference',
                                       'default': 11.11,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'zone heating design supply air temperature input method',
                                      {'name': u'Zone Heating Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_heating_design_supply_air_temperature_input_method',
                                       'default': u'SupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone heating design supply air temperature',
                                      {'name': u'Zone Heating Design Supply Air Temperature',
                                       'pyname': u'zone_heating_design_supply_air_temperature',
                                       'default': 50.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone heating design supply air temperature difference',
                                      {'name': u'Zone Heating Design Supply Air Temperature Difference',
                                       'pyname': u'zone_heating_design_supply_air_temperature_difference',
                                       'default': 30.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def zone_name(self):
        """Get zone_name.

        Returns:
            str: the value of `zone_name` or None if not set

        """
        return self["Zone Name"]

    @zone_name.setter
    def zone_name(self, value=None):
        """Corresponds to IDD field `Zone Name` Zone name must match a building
        zone name.

        Args:
            value (str): value for IDD Field `Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Name"] = value

    @property
    def template_constant_volume_system_name(self):
        """Get template_constant_volume_system_name.

        Returns:
            str: the value of `template_constant_volume_system_name` or None if not set

        """
        return self["Template Constant Volume System Name"]

    @template_constant_volume_system_name.setter
    def template_constant_volume_system_name(self, value=None):
        """  Corresponds to IDD field `Template Constant Volume System Name`
        Name of a HVACTemplate:System:ConstantVolume object serving this zone

        Args:
            value (str): value for IDD Field `Template Constant Volume System Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Constant Volume System Name"] = value

    @property
    def template_thermostat_name(self):
        """Get template_thermostat_name.

        Returns:
            str: the value of `template_thermostat_name` or None if not set

        """
        return self["Template Thermostat Name"]

    @template_thermostat_name.setter
    def template_thermostat_name(self, value=None):
        """  Corresponds to IDD field `Template Thermostat Name`
        Enter the name of a HVACTemplate:Thermostat object.
        If blank, then it is assumed that standard thermostat objects
        have been defined for this zone.

        Args:
            value (str): value for IDD Field `Template Thermostat Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Thermostat Name"] = value

    @property
    def supply_air_maximum_flow_rate(self):
        """Get supply_air_maximum_flow_rate.

        Returns:
            float: the value of `supply_air_maximum_flow_rate` or None if not set

        """
        return self["Supply Air Maximum Flow Rate"]

    @supply_air_maximum_flow_rate.setter
    def supply_air_maximum_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Supply Air Maximum Flow Rate` This field
        may be set to "autosize".  If a value is entered, it will be multiplied
        by the Supply Air Sizing Factor and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Supply Air Maximum Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Air Maximum Flow Rate"] = value

    @property
    def zone_heating_sizing_factor(self):
        """Get zone_heating_sizing_factor.

        Returns:
            float: the value of `zone_heating_sizing_factor` or None if not set

        """
        return self["Zone Heating Sizing Factor"]

    @zone_heating_sizing_factor.setter
    def zone_heating_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Heating Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Heating Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Sizing Factor"] = value

    @property
    def zone_cooling_sizing_factor(self):
        """Get zone_cooling_sizing_factor.

        Returns:
            float: the value of `zone_cooling_sizing_factor` or None if not set

        """
        return self["Zone Cooling Sizing Factor"]

    @zone_cooling_sizing_factor.setter
    def zone_cooling_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Cooling Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Cooling Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Sizing Factor"] = value

    @property
    def outdoor_air_method(self):
        """Get outdoor_air_method.

        Returns:
            str: the value of `outdoor_air_method` or None if not set

        """
        return self["Outdoor Air Method"]

    @outdoor_air_method.setter
    def outdoor_air_method(self, value="Flow/Person"):
        """  Corresponds to IDD field `Outdoor Air Method`
        Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
        fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
        and Outdoor Air Flow Rate per Zone.
        DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
        references design specification objects named in the fields
        Design Specification Outdoor Air Object Name and Design Specification Zone Air
        Distribution Object Name.

        Args:
            value (str): value for IDD Field `Outdoor Air Method`
                Default value: Flow/Person
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Method"] = value

    @property
    def outdoor_air_flow_rate_per_person(self):
        """Get outdoor_air_flow_rate_per_person.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_person` or None if not set

        """
        return self["Outdoor Air Flow Rate per Person"]

    @outdoor_air_flow_rate_per_person.setter
    def outdoor_air_flow_rate_per_person(self, value=0.00944):
        """  Corresponds to IDD field `Outdoor Air Flow Rate per Person`
        Default 0.00944 is 20 cfm per person
        This input is used if the field Outdoor Air Method is
        Flow/Person, Sum, or Maximum

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Person`
                Units: m3/s
                Default value: 0.00944
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Flow Rate per Person"] = value

    @property
    def outdoor_air_flow_rate_per_zone_floor_area(self):
        """Get outdoor_air_flow_rate_per_zone_floor_area.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone_floor_area` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone Floor Area"]

    @outdoor_air_flow_rate_per_zone_floor_area.setter
    def outdoor_air_flow_rate_per_zone_floor_area(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone Floor Area`
        This input is used if the field Outdoor Air Method is Flow/Area, Sum,
        or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone Floor Area`
                Units: m3/s-m2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone Floor Area"] = value

    @property
    def outdoor_air_flow_rate_per_zone(self):
        """Get outdoor_air_flow_rate_per_zone.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone"]

    @outdoor_air_flow_rate_per_zone.setter
    def outdoor_air_flow_rate_per_zone(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone` This input
        is used if the field Outdoor Air Method is Flow/Zone, Sum, or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone"] = value

    @property
    def design_specification_outdoor_air_object_name(self):
        """Get design_specification_outdoor_air_object_name.

        Returns:
            str: the value of `design_specification_outdoor_air_object_name` or None if not set

        """
        return self["Design Specification Outdoor Air Object name"]

    @design_specification_outdoor_air_object_name.setter
    def design_specification_outdoor_air_object_name(self, value=None):
        """  Corresponds to IDD field `Design Specification Outdoor Air Object name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Outdoor Air Object name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Outdoor Air Object name"] = value

    @property
    def design_specification_zone_air_distribution_object_name(self):
        """Get design_specification_zone_air_distribution_object_name.

        Returns:
            str: the value of `design_specification_zone_air_distribution_object_name` or None if not set

        """
        return self["Design Specification Zone Air Distribution Object Name"]

    @design_specification_zone_air_distribution_object_name.setter
    def design_specification_zone_air_distribution_object_name(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Zone Air Distribution Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Zone Air Distribution Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Zone Air Distribution Object Name"] = value

    @property
    def reheat_coil_type(self):
        """Get reheat_coil_type.

        Returns:
            str: the value of `reheat_coil_type` or None if not set

        """
        return self["Reheat Coil Type"]

    @reheat_coil_type.setter
    def reheat_coil_type(self, value="None"):
        """Corresponds to IDD field `Reheat Coil Type`

        Args:
            value (str): value for IDD Field `Reheat Coil Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Reheat Coil Type"] = value

    @property
    def reheat_coil_availability_schedule_name(self):
        """Get reheat_coil_availability_schedule_name.

        Returns:
            str: the value of `reheat_coil_availability_schedule_name` or None if not set

        """
        return self["Reheat Coil Availability Schedule Name"]

    @reheat_coil_availability_schedule_name.setter
    def reheat_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Reheat Coil Availability Schedule Name` If
        blank, always on.

        Args:
            value (str): value for IDD Field `Reheat Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Reheat Coil Availability Schedule Name"] = value

    @property
    def maximum_reheat_air_temperature(self):
        """Get maximum_reheat_air_temperature.

        Returns:
            float: the value of `maximum_reheat_air_temperature` or None if not set

        """
        return self["Maximum Reheat Air Temperature"]

    @maximum_reheat_air_temperature.setter
    def maximum_reheat_air_temperature(self, value=None):
        """Corresponds to IDD field `Maximum Reheat Air Temperature` Specifies
        the maximum allowable supply air temperature leaving the reheat coil.
        If left blank, there is no limit and no default. If unknown, 35C (95F)
        is recommended.

        Args:
            value (float): value for IDD Field `Maximum Reheat Air Temperature`
                Units: C
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Maximum Reheat Air Temperature"] = value

    @property
    def supply_plenum_name(self):
        """Get supply_plenum_name.

        Returns:
            str: the value of `supply_plenum_name` or None if not set

        """
        return self["Supply Plenum Name"]

    @supply_plenum_name.setter
    def supply_plenum_name(self, value=None):
        """Corresponds to IDD field `Supply Plenum Name` Plenum zone name.
        Supply plenum runs through only this zone. Blank if none.

        Args:
            value (str): value for IDD Field `Supply Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Plenum Name"] = value

    @property
    def return_plenum_name(self):
        """Get return_plenum_name.

        Returns:
            str: the value of `return_plenum_name` or None if not set

        """
        return self["Return Plenum Name"]

    @return_plenum_name.setter
    def return_plenum_name(self, value=None):
        """Corresponds to IDD field `Return Plenum Name` Plenum zone name.
        Return plenum runs through only this zone. Blank if none.

        Args:
            value (str): value for IDD Field `Return Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Plenum Name"] = value

    @property
    def baseboard_heating_type(self):
        """Get baseboard_heating_type.

        Returns:
            str: the value of `baseboard_heating_type` or None if not set

        """
        return self["Baseboard Heating Type"]

    @baseboard_heating_type.setter
    def baseboard_heating_type(self, value="None"):
        """Corresponds to IDD field `Baseboard Heating Type`

        Args:
            value (str): value for IDD Field `Baseboard Heating Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Type"] = value

    @property
    def baseboard_heating_availability_schedule_name(self):
        """Get baseboard_heating_availability_schedule_name.

        Returns:
            str: the value of `baseboard_heating_availability_schedule_name` or None if not set

        """
        return self["Baseboard Heating Availability Schedule Name"]

    @baseboard_heating_availability_schedule_name.setter
    def baseboard_heating_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Baseboard Heating Availability Schedule
        Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Baseboard Heating Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Availability Schedule Name"] = value

    @property
    def baseboard_heating_capacity(self):
        """Get baseboard_heating_capacity.

        Returns:
            float: the value of `baseboard_heating_capacity` or None if not set

        """
        return self["Baseboard Heating Capacity"]

    @baseboard_heating_capacity.setter
    def baseboard_heating_capacity(self, value="autosize"):
        """Corresponds to IDD field `Baseboard Heating Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Baseboard Heating Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Capacity"] = value

    @property
    def zone_cooling_design_supply_air_temperature_input_method(self):
        """Get zone_cooling_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_cooling_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Input Method"]

    @zone_cooling_design_supply_air_temperature_input_method.setter
    def zone_cooling_design_supply_air_temperature_input_method(
            self,
            value="SystemSupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference
        SystemSupplyAirTemperature = use the value from HVACTemplate:System:VAV Cooling Coil Design Setpoint

        Args:
            value (str): value for IDD Field `Zone Cooling Design Supply Air Temperature Input Method`
                Default value: SystemSupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Input Method"] = value

    @property
    def zone_cooling_design_supply_air_temperature(self):
        """Get zone_cooling_design_supply_air_temperature.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature"]

    @zone_cooling_design_supply_air_temperature.setter
    def zone_cooling_design_supply_air_temperature(self, value=12.8):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature`
                Units: C
                Default value: 12.8
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature"] = value

    @property
    def zone_cooling_design_supply_air_temperature_difference(self):
        """Get zone_cooling_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Difference"]

    @zone_cooling_design_supply_air_temperature_difference.setter
    def zone_cooling_design_supply_air_temperature_difference(
            self,
            value=11.11):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Difference`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be subtracted from the zone temperature
        at peak load to calculate the Zone Cooling Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 11.11
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Difference"] = value

    @property
    def zone_heating_design_supply_air_temperature_input_method(self):
        """Get zone_heating_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_heating_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Input Method"]

    @zone_heating_design_supply_air_temperature_input_method.setter
    def zone_heating_design_supply_air_temperature_input_method(
            self,
            value="SupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference

        Args:
            value (str): value for IDD Field `Zone Heating Design Supply Air Temperature Input Method`
                Default value: SupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Input Method"] = value

    @property
    def zone_heating_design_supply_air_temperature(self):
        """Get zone_heating_design_supply_air_temperature.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature"]

    @zone_heating_design_supply_air_temperature.setter
    def zone_heating_design_supply_air_temperature(self, value=50.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature`
                Units: C
                Default value: 50.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature"] = value

    @property
    def zone_heating_design_supply_air_temperature_difference(self):
        """Get zone_heating_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Difference"]

    @zone_heating_design_supply_air_temperature_difference.setter
    def zone_heating_design_supply_air_temperature_difference(
            self,
            value=30.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Difference`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be added to the zone temperature
        at peak load to calculate the Zone Heating Design Supply Air Temperature

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 30.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Difference"] = value




class HvactemplateZoneDualDuct(DataObject):

    """ Corresponds to IDD object `HVACTemplate:Zone:DualDuct`
        Zone terminal unit, dual-duct, constant or variable volume.
    """
    schema = {'min-fields': 26,
              'name': u'HVACTemplate:Zone:DualDuct',
              'pyname': u'HvactemplateZoneDualDuct',
              'format': None,
              'fields': OrderedDict([(u'zone name',
                                      {'name': u'Zone Name',
                                       'pyname': u'zone_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template dual duct system name',
                                      {'name': u'Template Dual Duct System Name',
                                       'pyname': u'template_dual_duct_system_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'template thermostat name',
                                      {'name': u'Template Thermostat Name',
                                       'pyname': u'template_thermostat_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply air maximum flow rate',
                                      {'name': u'Supply Air Maximum Flow Rate',
                                       'pyname': u'supply_air_maximum_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'zone heating sizing factor',
                                      {'name': u'Zone Heating Sizing Factor',
                                       'pyname': u'zone_heating_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'zone cooling sizing factor',
                                      {'name': u'Zone Cooling Sizing Factor',
                                       'pyname': u'zone_cooling_sizing_factor',
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'zone minimum air flow fraction',
                                      {'name': u'Zone Minimum Air Flow Fraction',
                                       'pyname': u'zone_minimum_air_flow_fraction',
                                       'default': 0.2,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'outdoor air method',
                                      {'name': u'Outdoor Air Method',
                                       'pyname': u'outdoor_air_method',
                                       'default': u'Flow/Person',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Flow/Person',
                                                           u'Flow/Zone',
                                                           u'Flow/Area',
                                                           u'Sum',
                                                           u'Maximum',
                                                           u'DetailedSpecification'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'outdoor air flow rate per person',
                                      {'name': u'Outdoor Air Flow Rate per Person',
                                       'pyname': u'outdoor_air_flow_rate_per_person',
                                       'default': 0.00944,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'outdoor air flow rate per zone floor area',
                                      {'name': u'Outdoor Air Flow Rate per Zone Floor Area',
                                       'pyname': u'outdoor_air_flow_rate_per_zone_floor_area',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s-m2'}),
                                     (u'outdoor air flow rate per zone',
                                      {'name': u'Outdoor Air Flow Rate per Zone',
                                       'pyname': u'outdoor_air_flow_rate_per_zone',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'design specification outdoor air object name for sizing',
                                      {'name': u'Design Specification Outdoor Air Object Name for Sizing',
                                       'pyname': u'design_specification_outdoor_air_object_name_for_sizing',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'design specification zone air distribution object name',
                                      {'name': u'Design Specification Zone Air Distribution Object Name',
                                       'pyname': u'design_specification_zone_air_distribution_object_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'design specification outdoor air object name for control',
                                      {'name': u'Design Specification Outdoor Air Object Name for Control',
                                       'pyname': u'design_specification_outdoor_air_object_name_for_control',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'cold supply plenum name',
                                      {'name': u'Cold Supply Plenum Name',
                                       'pyname': u'cold_supply_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'hot supply plenum name',
                                      {'name': u'Hot Supply Plenum Name',
                                       'pyname': u'hot_supply_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'return plenum name',
                                      {'name': u'Return Plenum Name',
                                       'pyname': u'return_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating type',
                                      {'name': u'Baseboard Heating Type',
                                       'pyname': u'baseboard_heating_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'HotWater',
                                                           u'Electric',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'baseboard heating availability schedule name',
                                      {'name': u'Baseboard Heating Availability Schedule Name',
                                       'pyname': u'baseboard_heating_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'baseboard heating capacity',
                                      {'name': u'Baseboard Heating Capacity',
                                       'pyname': u'baseboard_heating_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'zone cooling design supply air temperature input method',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_input_method',
                                       'default': u'SystemSupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference',
                                                           u'SystemSupplyAirTemperature'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone cooling design supply air temperature',
                                      {'name': u'Zone Cooling Design Supply Air Temperature',
                                       'pyname': u'zone_cooling_design_supply_air_temperature',
                                       'default': 12.8,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone cooling design supply air temperature difference',
                                      {'name': u'Zone Cooling Design Supply Air Temperature Difference',
                                       'pyname': u'zone_cooling_design_supply_air_temperature_difference',
                                       'default': 11.11,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'}),
                                     (u'zone heating design supply air temperature input method',
                                      {'name': u'Zone Heating Design Supply Air Temperature Input Method',
                                       'pyname': u'zone_heating_design_supply_air_temperature_input_method',
                                       'default': u'SystemSupplyAirTemperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SupplyAirTemperature',
                                                           u'TemperatureDifference',
                                                           u'SystemSupplyAirTemperature'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'zone heating design supply air temperature',
                                      {'name': u'Zone Heating Design Supply Air Temperature',
                                       'pyname': u'zone_heating_design_supply_air_temperature',
                                       'default': 50.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'zone heating design supply air temperature difference',
                                      {'name': u'Zone Heating Design Supply Air Temperature Difference',
                                       'pyname': u'zone_heating_design_supply_air_temperature_difference',
                                       'default': 30.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'deltaC'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def zone_name(self):
        """Get zone_name.

        Returns:
            str: the value of `zone_name` or None if not set

        """
        return self["Zone Name"]

    @zone_name.setter
    def zone_name(self, value=None):
        """Corresponds to IDD field `Zone Name` Zone name must match a building
        zone name.

        Args:
            value (str): value for IDD Field `Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Name"] = value

    @property
    def template_dual_duct_system_name(self):
        """Get template_dual_duct_system_name.

        Returns:
            str: the value of `template_dual_duct_system_name` or None if not set

        """
        return self["Template Dual Duct System Name"]

    @template_dual_duct_system_name.setter
    def template_dual_duct_system_name(self, value=None):
        """  Corresponds to IDD field `Template Dual Duct System Name`
        Name of a HVACTemplate:System:DualDuct object serving this zone

        Args:
            value (str): value for IDD Field `Template Dual Duct System Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Dual Duct System Name"] = value

    @property
    def template_thermostat_name(self):
        """Get template_thermostat_name.

        Returns:
            str: the value of `template_thermostat_name` or None if not set

        """
        return self["Template Thermostat Name"]

    @template_thermostat_name.setter
    def template_thermostat_name(self, value=None):
        """  Corresponds to IDD field `Template Thermostat Name`
        Enter the name of a HVACTemplate:Thermostat object.
        If blank, then it is assumed that standard thermostat objects
        have been defined for this zone.

        Args:
            value (str): value for IDD Field `Template Thermostat Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Template Thermostat Name"] = value

    @property
    def supply_air_maximum_flow_rate(self):
        """Get supply_air_maximum_flow_rate.

        Returns:
            float: the value of `supply_air_maximum_flow_rate` or None if not set

        """
        return self["Supply Air Maximum Flow Rate"]

    @supply_air_maximum_flow_rate.setter
    def supply_air_maximum_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Supply Air Maximum Flow Rate` This field
        may be set to "autosize".  If a value is entered, it will be multiplied
        by the Supply Air Sizing Factor and by zone multipliers.

        Args:
            value (float or "Autosize"): value for IDD Field `Supply Air Maximum Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Air Maximum Flow Rate"] = value

    @property
    def zone_heating_sizing_factor(self):
        """Get zone_heating_sizing_factor.

        Returns:
            float: the value of `zone_heating_sizing_factor` or None if not set

        """
        return self["Zone Heating Sizing Factor"]

    @zone_heating_sizing_factor.setter
    def zone_heating_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Heating Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Heating Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Sizing Factor"] = value

    @property
    def zone_cooling_sizing_factor(self):
        """Get zone_cooling_sizing_factor.

        Returns:
            float: the value of `zone_cooling_sizing_factor` or None if not set

        """
        return self["Zone Cooling Sizing Factor"]

    @zone_cooling_sizing_factor.setter
    def zone_cooling_sizing_factor(self, value=None):
        """  Corresponds to IDD field `Zone Cooling Sizing Factor`
        If blank, value from Sizing:Parameters will be used.

        Args:
            value (float): value for IDD Field `Zone Cooling Sizing Factor`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Sizing Factor"] = value

    @property
    def zone_minimum_air_flow_fraction(self):
        """Get zone_minimum_air_flow_fraction.

        Returns:
            float: the value of `zone_minimum_air_flow_fraction` or None if not set

        """
        return self["Zone Minimum Air Flow Fraction"]

    @zone_minimum_air_flow_fraction.setter
    def zone_minimum_air_flow_fraction(self, value=0.2):
        """Corresponds to IDD field `Zone Minimum Air Flow Fraction` This field
        is the Zone Minimum Air Flow Fraction specified as a fraction of the
        maximum air flow rate. This field is ignored if the system serving this
        zone is constant volume.

        Args:
            value (float): value for IDD Field `Zone Minimum Air Flow Fraction`
                Default value: 0.2
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Minimum Air Flow Fraction"] = value

    @property
    def outdoor_air_method(self):
        """Get outdoor_air_method.

        Returns:
            str: the value of `outdoor_air_method` or None if not set

        """
        return self["Outdoor Air Method"]

    @outdoor_air_method.setter
    def outdoor_air_method(self, value="Flow/Person"):
        """  Corresponds to IDD field `Outdoor Air Method`
        Flow/Person, Flow/Zone, Flow/Area, Sum, and Maximum use the values in the next three
        fields: Outdoor Air Flow Rate per Person, Outdoor Air Flow Rate per Zone Floor Area,
        and Outdoor Air Flow Rate per Zone.
        DetailedSpecification ignores these three Outdoor Air Flow Rate fields and instead
        references design specification objects named in the fields
        Design Specification Outdoor Air Object Name and Design Specification Zone Air
        Distribution Object Name.

        Args:
            value (str): value for IDD Field `Outdoor Air Method`
                Default value: Flow/Person
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Method"] = value

    @property
    def outdoor_air_flow_rate_per_person(self):
        """Get outdoor_air_flow_rate_per_person.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_person` or None if not set

        """
        return self["Outdoor Air Flow Rate per Person"]

    @outdoor_air_flow_rate_per_person.setter
    def outdoor_air_flow_rate_per_person(self, value=0.00944):
        """  Corresponds to IDD field `Outdoor Air Flow Rate per Person`
        Default 0.00944 is 20 cfm per person
        This input is used if the field Outdoor Air Method is
        Flow/Person, Sum, or Maximum

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Person`
                Units: m3/s
                Default value: 0.00944
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Outdoor Air Flow Rate per Person"] = value

    @property
    def outdoor_air_flow_rate_per_zone_floor_area(self):
        """Get outdoor_air_flow_rate_per_zone_floor_area.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone_floor_area` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone Floor Area"]

    @outdoor_air_flow_rate_per_zone_floor_area.setter
    def outdoor_air_flow_rate_per_zone_floor_area(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone Floor Area`
        This input is used if the field Outdoor Air Method is Flow/Area, Sum,
        or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone Floor Area`
                Units: m3/s-m2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone Floor Area"] = value

    @property
    def outdoor_air_flow_rate_per_zone(self):
        """Get outdoor_air_flow_rate_per_zone.

        Returns:
            float: the value of `outdoor_air_flow_rate_per_zone` or None if not set

        """
        return self["Outdoor Air Flow Rate per Zone"]

    @outdoor_air_flow_rate_per_zone.setter
    def outdoor_air_flow_rate_per_zone(self, value=None):
        """Corresponds to IDD field `Outdoor Air Flow Rate per Zone` This input
        is used if the field Outdoor Air Method is Flow/Zone, Sum, or Maximum.

        Args:
            value (float): value for IDD Field `Outdoor Air Flow Rate per Zone`
                Units: m3/s
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Outdoor Air Flow Rate per Zone"] = value

    @property
    def design_specification_outdoor_air_object_name_for_sizing(self):
        """Get design_specification_outdoor_air_object_name_for_sizing.

        Returns:
            str: the value of `design_specification_outdoor_air_object_name_for_sizing` or None if not set

        """
        return self["Design Specification Outdoor Air Object Name for Sizing"]

    @design_specification_outdoor_air_object_name_for_sizing.setter
    def design_specification_outdoor_air_object_name_for_sizing(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Outdoor Air Object Name for Sizing`
        This field is used only when Outdoor Air Method=DetailedSpecification.
        Note that this field is used only for specifying the design outdoor air flow rate used
        for sizing. The field Design Specification Outdoor Air Object Name for Control
        (see above) is used to actively control the VAV terminal air flow rate.

        Args:
            value (str): value for IDD Field `Design Specification Outdoor Air Object Name for Sizing`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Outdoor Air Object Name for Sizing"] = value

    @property
    def design_specification_zone_air_distribution_object_name(self):
        """Get design_specification_zone_air_distribution_object_name.

        Returns:
            str: the value of `design_specification_zone_air_distribution_object_name` or None if not set

        """
        return self["Design Specification Zone Air Distribution Object Name"]

    @design_specification_zone_air_distribution_object_name.setter
    def design_specification_zone_air_distribution_object_name(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Zone Air Distribution Object Name`
        This field is used only when Outdoor Air Method=DetailedSpecification.

        Args:
            value (str): value for IDD Field `Design Specification Zone Air Distribution Object Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Design Specification Zone Air Distribution Object Name"] = value

    @property
    def design_specification_outdoor_air_object_name_for_control(self):
        """Get design_specification_outdoor_air_object_name_for_control.

        Returns:
            str: the value of `design_specification_outdoor_air_object_name_for_control` or None if not set

        """
        return self["Design Specification Outdoor Air Object Name for Control"]

    @design_specification_outdoor_air_object_name_for_control.setter
    def design_specification_outdoor_air_object_name_for_control(
            self,
            value=None):
        """  Corresponds to IDD field `Design Specification Outdoor Air Object Name for Control`
        When the name of a DesignSpecification:OutdoorAir object is entered, the terminal
        unit will increase flow as needed to meet this outdoor air requirement.
        If Outdoor Air Flow per Person is non-zero, then the outdoor air requirement will
        be computed based on the current number of occupants in the zone.
        At no time will the supply air flow rate exceed the value for Maximum Air Flow Rate.
        If this field is blank, then the terminal unit will not be controlled for outdoor air flow.
        Note that this field is used only for specifying the design outdoor air flow rate used
        for control. The field Design Specification Outdoor Air Object Name for Sizing
        (see below) is used to specify the design outdoor air flow rate.

        Args:
            value (str): value for IDD Field `Design Specification Outdoor Air Object Name for Control`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Design Specification Outdoor Air Object Name for Control"] = value

    @property
    def cold_supply_plenum_name(self):
        """Get cold_supply_plenum_name.

        Returns:
            str: the value of `cold_supply_plenum_name` or None if not set

        """
        return self["Cold Supply Plenum Name"]

    @cold_supply_plenum_name.setter
    def cold_supply_plenum_name(self, value=None):
        """Corresponds to IDD field `Cold Supply Plenum Name` Plenum zone name.
        Cold supply plenum that serves only this zone. Blank if none.

        Args:
            value (str): value for IDD Field `Cold Supply Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cold Supply Plenum Name"] = value

    @property
    def hot_supply_plenum_name(self):
        """Get hot_supply_plenum_name.

        Returns:
            str: the value of `hot_supply_plenum_name` or None if not set

        """
        return self["Hot Supply Plenum Name"]

    @hot_supply_plenum_name.setter
    def hot_supply_plenum_name(self, value=None):
        """Corresponds to IDD field `Hot Supply Plenum Name` Plenum zone name.
        Hot supply plenum that serves only this zone. Blank if none.

        Args:
            value (str): value for IDD Field `Hot Supply Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Hot Supply Plenum Name"] = value

    @property
    def return_plenum_name(self):
        """Get return_plenum_name.

        Returns:
            str: the value of `return_plenum_name` or None if not set

        """
        return self["Return Plenum Name"]

    @return_plenum_name.setter
    def return_plenum_name(self, value=None):
        """Corresponds to IDD field `Return Plenum Name` Plenum zone name.
        Return plenum that serves only this zone. Blank if none.

        Args:
            value (str): value for IDD Field `Return Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Plenum Name"] = value

    @property
    def baseboard_heating_type(self):
        """Get baseboard_heating_type.

        Returns:
            str: the value of `baseboard_heating_type` or None if not set

        """
        return self["Baseboard Heating Type"]

    @baseboard_heating_type.setter
    def baseboard_heating_type(self, value="None"):
        """Corresponds to IDD field `Baseboard Heating Type`

        Args:
            value (str): value for IDD Field `Baseboard Heating Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Type"] = value

    @property
    def baseboard_heating_availability_schedule_name(self):
        """Get baseboard_heating_availability_schedule_name.

        Returns:
            str: the value of `baseboard_heating_availability_schedule_name` or None if not set

        """
        return self["Baseboard Heating Availability Schedule Name"]

    @baseboard_heating_availability_schedule_name.setter
    def baseboard_heating_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Baseboard Heating Availability Schedule
        Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Baseboard Heating Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Availability Schedule Name"] = value

    @property
    def baseboard_heating_capacity(self):
        """Get baseboard_heating_capacity.

        Returns:
            float: the value of `baseboard_heating_capacity` or None if not set

        """
        return self["Baseboard Heating Capacity"]

    @baseboard_heating_capacity.setter
    def baseboard_heating_capacity(self, value="autosize"):
        """Corresponds to IDD field `Baseboard Heating Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Baseboard Heating Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Baseboard Heating Capacity"] = value

    @property
    def zone_cooling_design_supply_air_temperature_input_method(self):
        """Get zone_cooling_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_cooling_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Input Method"]

    @zone_cooling_design_supply_air_temperature_input_method.setter
    def zone_cooling_design_supply_air_temperature_input_method(
            self,
            value="SystemSupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Cooling Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Cooling Design Supply Air Temperature Difference
        SystemSupplyAirTemperature = use the value from HVACTemplate:System:DualDuct Cooling Coil Design Setpoint

        Args:
            value (str): value for IDD Field `Zone Cooling Design Supply Air Temperature Input Method`
                Default value: SystemSupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Input Method"] = value

    @property
    def zone_cooling_design_supply_air_temperature(self):
        """Get zone_cooling_design_supply_air_temperature.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature"]

    @zone_cooling_design_supply_air_temperature.setter
    def zone_cooling_design_supply_air_temperature(self, value=12.8):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature`
                Units: C
                Default value: 12.8
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature"] = value

    @property
    def zone_cooling_design_supply_air_temperature_difference(self):
        """Get zone_cooling_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_cooling_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Cooling Design Supply Air Temperature Difference"]

    @zone_cooling_design_supply_air_temperature_difference.setter
    def zone_cooling_design_supply_air_temperature_difference(
            self,
            value=11.11):
        """  Corresponds to IDD field `Zone Cooling Design Supply Air Temperature Difference`
        Zone Cooling Design Supply Air Temperature is only used when Zone Cooling Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be subtracted from the zone temperature
        at peak load to calculate the Zone Cooling Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Cooling Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 11.11
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Cooling Design Supply Air Temperature Difference"] = value

    @property
    def zone_heating_design_supply_air_temperature_input_method(self):
        """Get zone_heating_design_supply_air_temperature_input_method.

        Returns:
            str: the value of `zone_heating_design_supply_air_temperature_input_method` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Input Method"]

    @zone_heating_design_supply_air_temperature_input_method.setter
    def zone_heating_design_supply_air_temperature_input_method(
            self,
            value="SystemSupplyAirTemperature"):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Input Method`
        SupplyAirTemperature = use the value from Zone Heating Design Supply Air Temperature
        TemperatureDifference = use the value from Zone Heating Design Supply Air Temperature Difference
        SystemSupplyAirTemperature = use the value from HVACTemplate:System:DualDuct Heating Coil Design Setpoint

        Args:
            value (str): value for IDD Field `Zone Heating Design Supply Air Temperature Input Method`
                Default value: SystemSupplyAirTemperature
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Input Method"] = value

    @property
    def zone_heating_design_supply_air_temperature(self):
        """Get zone_heating_design_supply_air_temperature.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature"]

    @zone_heating_design_supply_air_temperature.setter
    def zone_heating_design_supply_air_temperature(self, value=50.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = SupplyAirTemperature

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature`
                Units: C
                Default value: 50.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature"] = value

    @property
    def zone_heating_design_supply_air_temperature_difference(self):
        """Get zone_heating_design_supply_air_temperature_difference.

        Returns:
            float: the value of `zone_heating_design_supply_air_temperature_difference` or None if not set

        """
        return self["Zone Heating Design Supply Air Temperature Difference"]

    @zone_heating_design_supply_air_temperature_difference.setter
    def zone_heating_design_supply_air_temperature_difference(
            self,
            value=30.0):
        """  Corresponds to IDD field `Zone Heating Design Supply Air Temperature Difference`
        Zone Heating Design Supply Air Temperature is only used when Zone Heating Design
        Supply Air Temperature Input Method = TemperatureDifference
        The absolute value of this field will be added to the zone temperature
        at peak load to calculate the Zone Heating Design Supply Air Temperature.

        Args:
            value (float): value for IDD Field `Zone Heating Design Supply Air Temperature Difference`
                Units: deltaC
                Default value: 30.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Zone Heating Design Supply Air Temperature Difference"] = value




class HvactemplateSystemVrf(DataObject):

    """ Corresponds to IDD object `HVACTemplate:System:VRF`
        Variable refrigerant flow (VRF) heat pump condensing unit. Serves one or more VRF zone
        terminal units (HVACTemplate:Zone:VRF).
    """
    schema = {'min-fields': 39,
              'name': u'HVACTemplate:System:VRF',
              'pyname': u'HvactemplateSystemVrf',
              'format': None,
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'system availability schedule name',
                                      {'name': u'System Availability Schedule Name',
                                       'pyname': u'system_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'gross rated total cooling capacity',
                                      {'name': u'Gross Rated Total Cooling Capacity',
                                       'pyname': u'gross_rated_total_cooling_capacity',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'gross rated cooling cop',
                                      {'name': u'Gross Rated Cooling COP',
                                       'pyname': u'gross_rated_cooling_cop',
                                       'default': 3.3,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'minimum outdoor temperature in cooling mode',
                                      {'name': u'Minimum Outdoor Temperature in Cooling Mode',
                                       'pyname': u'minimum_outdoor_temperature_in_cooling_mode',
                                       'default': -6.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'maximum outdoor temperature in cooling mode',
                                      {'name': u'Maximum Outdoor Temperature in Cooling Mode',
                                       'pyname': u'maximum_outdoor_temperature_in_cooling_mode',
                                       'default': 43.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'gross rated heating capacity',
                                      {'name': u'Gross Rated Heating Capacity',
                                       'pyname': u'gross_rated_heating_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'rated heating capacity sizing ratio',
                                      {'name': u'Rated Heating Capacity Sizing Ratio',
                                       'pyname': u'rated_heating_capacity_sizing_ratio',
                                       'default': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 1.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'gross rated heating cop',
                                      {'name': u'Gross Rated Heating COP',
                                       'pyname': u'gross_rated_heating_cop',
                                       'default': 3.4,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'minimum outdoor temperature in heating mode',
                                      {'name': u'Minimum Outdoor Temperature in Heating Mode',
                                       'pyname': u'minimum_outdoor_temperature_in_heating_mode',
                                       'default': -20.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'maximum outdoor temperature in heating mode',
                                      {'name': u'Maximum Outdoor Temperature in Heating Mode',
                                       'pyname': u'maximum_outdoor_temperature_in_heating_mode',
                                       'default': 16.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'minimum heat pump part-load ratio',
                                      {'name': u'Minimum Heat Pump Part-Load Ratio',
                                       'pyname': u'minimum_heat_pump_partload_ratio',
                                       'default': 0.15,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'zone name for master thermostat location',
                                      {'name': u'Zone Name for Master Thermostat Location',
                                       'pyname': u'zone_name_for_master_thermostat_location',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'master thermostat priority control type',
                                      {'name': u'Master Thermostat Priority Control Type',
                                       'pyname': u'master_thermostat_priority_control_type',
                                       'default': u'MasterThermostatPriority',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'LoadPriority',
                                                           u'ZonePriority',
                                                           u'ThermostatOffsetPriority',
                                                           u'MasterThermostatPriority',
                                                           u'Scheduled'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'thermostat priority schedule name',
                                      {'name': u'Thermostat Priority Schedule Name',
                                       'pyname': u'thermostat_priority_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'alpha'}),
                                     (u'heat pump waste heat recovery',
                                      {'name': u'Heat Pump Waste Heat Recovery',
                                       'pyname': u'heat_pump_waste_heat_recovery',
                                       'default': u'No',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'No',
                                                           u'Yes'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'equivalent piping length used for piping correction factor in cooling mode',
                                      {'name': u'Equivalent Piping Length used for Piping Correction Factor in Cooling Mode',
                                       'pyname': u'equivalent_piping_length_used_for_piping_correction_factor_in_cooling_mode',
                                       'default': 30.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm'}),
                                     (u'vertical height used for piping correction factor',
                                      {'name': u'Vertical Height used for Piping Correction Factor',
                                       'pyname': u'vertical_height_used_for_piping_correction_factor',
                                       'default': 10.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm'}),
                                     (u'equivalent piping length used for piping correction factor in heating mode',
                                      {'name': u'Equivalent Piping Length used for Piping Correction Factor in Heating Mode',
                                       'pyname': u'equivalent_piping_length_used_for_piping_correction_factor_in_heating_mode',
                                       'default': 30.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm'}),
                                     (u'crankcase heater power per compressor',
                                      {'name': u'Crankcase Heater Power per Compressor',
                                       'pyname': u'crankcase_heater_power_per_compressor',
                                       'default': 33.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'number of compressors',
                                      {'name': u'Number of Compressors',
                                       'pyname': u'number_of_compressors',
                                       'default': 2,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'integer',
                                       'unit': u'dimensionless'}),
                                     (u'ratio of compressor size to total compressor capacity',
                                      {'name': u'Ratio of Compressor Size to Total Compressor Capacity',
                                       'pyname': u'ratio_of_compressor_size_to_total_compressor_capacity',
                                       'default': 0.5,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/W'}),
                                     (u'maximum outdoor dry-bulb temperature for crankcase heater',
                                      {'name': u'Maximum Outdoor Dry-bulb Temperature for Crankcase Heater',
                                       'pyname': u'maximum_outdoor_drybulb_temperature_for_crankcase_heater',
                                       'default': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'defrost strategy',
                                      {'name': u'Defrost Strategy',
                                       'pyname': u'defrost_strategy',
                                       'default': u'Resistive',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'ReverseCycle',
                                                           u'Resistive'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'defrost control',
                                      {'name': u'Defrost Control',
                                       'pyname': u'defrost_control',
                                       'default': u'Timed',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Timed',
                                                           u'OnDemand'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'defrost time period fraction',
                                      {'name': u'Defrost Time Period Fraction',
                                       'pyname': u'defrost_time_period_fraction',
                                       'default': 0.058333,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'resistive defrost heater capacity',
                                      {'name': u'Resistive Defrost Heater Capacity',
                                       'pyname': u'resistive_defrost_heater_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'maximum outdoor dry-bulb temperature for defrost operation',
                                      {'name': u'Maximum Outdoor Dry-bulb Temperature for Defrost Operation',
                                       'pyname': u'maximum_outdoor_drybulb_temperature_for_defrost_operation',
                                       'default': 5.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'condenser type',
                                      {'name': u'Condenser Type',
                                       'pyname': u'condenser_type',
                                       'default': u'AirCooled',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'AirCooled',
                                                           u'EvaporativelyCooled',
                                                           u'WaterCooled'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'water condenser volume flow rate',
                                      {'name': u'Water Condenser Volume Flow Rate',
                                       'pyname': u'water_condenser_volume_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'evaporative condenser effectiveness',
                                      {'name': u'Evaporative Condenser Effectiveness',
                                       'pyname': u'evaporative_condenser_effectiveness',
                                       'default': 0.9,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'dimensionless'}),
                                     (u'evaporative condenser air flow rate',
                                      {'name': u'Evaporative Condenser Air Flow Rate',
                                       'pyname': u'evaporative_condenser_air_flow_rate',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'evaporative condenser pump rated power consumption',
                                      {'name': u'Evaporative Condenser Pump Rated Power Consumption',
                                       'pyname': u'evaporative_condenser_pump_rated_power_consumption',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'basin heater capacity',
                                      {'name': u'Basin Heater Capacity',
                                       'pyname': u'basin_heater_capacity',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W/K'}),
                                     (u'basin heater setpoint temperature',
                                      {'name': u'Basin Heater Setpoint Temperature',
                                       'pyname': u'basin_heater_setpoint_temperature',
                                       'default': 2.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 2.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'basin heater operating schedule name',
                                      {'name': u'Basin Heater Operating Schedule Name',
                                       'pyname': u'basin_heater_operating_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'fuel type',
                                      {'name': u'Fuel Type',
                                       'pyname': u'fuel_type',
                                       'default': u'Electricity',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Electricity',
                                                           u'NaturalGas',
                                                           u'PropaneGas',
                                                           u'Diesel',
                                                           u'Gasoline',
                                                           u'FuelOil#1',
                                                           u'FuelOil#2',
                                                           u'OtherFuel1',
                                                           u'OtherFuel2'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'minimum outdoor temperature in heat recovery mode',
                                      {'name': u'Minimum Outdoor Temperature in Heat Recovery Mode',
                                       'pyname': u'minimum_outdoor_temperature_in_heat_recovery_mode',
                                       'default': -15.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'maximum outdoor temperature in heat recovery mode',
                                      {'name': u'Maximum Outdoor Temperature in Heat Recovery Mode',
                                       'pyname': u'maximum_outdoor_temperature_in_heat_recovery_mode',
                                       'default': 45.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def system_availability_schedule_name(self):
        """Get system_availability_schedule_name.

        Returns:
            str: the value of `system_availability_schedule_name` or None if not set

        """
        return self["System Availability Schedule Name"]

    @system_availability_schedule_name.setter
    def system_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `System Availability Schedule Name`
        Availability schedule name for this system. Schedule value > 0 means
        the system is available. If this field is blank, the system is always
        available.

        Args:
            value (str): value for IDD Field `System Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["System Availability Schedule Name"] = value

    @property
    def gross_rated_total_cooling_capacity(self):
        """Get gross_rated_total_cooling_capacity.

        Returns:
            float: the value of `gross_rated_total_cooling_capacity` or None if not set

        """
        return self["Gross Rated Total Cooling Capacity"]

    @gross_rated_total_cooling_capacity.setter
    def gross_rated_total_cooling_capacity(self, value="autosize"):
        """Corresponds to IDD field `Gross Rated Total Cooling Capacity` Enter
        the total cooling capacity in watts at rated conditions or set to
        autosize. Total cooling capacity not accounting for the effect of
        supply air fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Gross Rated Total Cooling Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gross Rated Total Cooling Capacity"] = value

    @property
    def gross_rated_cooling_cop(self):
        """Get gross_rated_cooling_cop.

        Returns:
            float: the value of `gross_rated_cooling_cop` or None if not set

        """
        return self["Gross Rated Cooling COP"]

    @gross_rated_cooling_cop.setter
    def gross_rated_cooling_cop(self, value=3.3):
        """Corresponds to IDD field `Gross Rated Cooling COP` Enter the
        coefficient of performance at rated conditions or leave blank to use
        default. COP includes compressor and condenser fan electrical energy
        input COP does not include supply fan heat or supply fan electric power
        input.

        Args:
            value (float): value for IDD Field `Gross Rated Cooling COP`
                Units: W/W
                Default value: 3.3
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gross Rated Cooling COP"] = value

    @property
    def minimum_outdoor_temperature_in_cooling_mode(self):
        """Get minimum_outdoor_temperature_in_cooling_mode.

        Returns:
            float: the value of `minimum_outdoor_temperature_in_cooling_mode` or None if not set

        """
        return self["Minimum Outdoor Temperature in Cooling Mode"]

    @minimum_outdoor_temperature_in_cooling_mode.setter
    def minimum_outdoor_temperature_in_cooling_mode(self, value=-6.0):
        """Corresponds to IDD field `Minimum Outdoor Temperature in Cooling
        Mode` Enter the minimum outdoor temperature allowed for cooling
        operation. Cooling is disabled below this temperature.

        Args:
            value (float): value for IDD Field `Minimum Outdoor Temperature in Cooling Mode`
                Units: C
                Default value: -6.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Minimum Outdoor Temperature in Cooling Mode"] = value

    @property
    def maximum_outdoor_temperature_in_cooling_mode(self):
        """Get maximum_outdoor_temperature_in_cooling_mode.

        Returns:
            float: the value of `maximum_outdoor_temperature_in_cooling_mode` or None if not set

        """
        return self["Maximum Outdoor Temperature in Cooling Mode"]

    @maximum_outdoor_temperature_in_cooling_mode.setter
    def maximum_outdoor_temperature_in_cooling_mode(self, value=43.0):
        """Corresponds to IDD field `Maximum Outdoor Temperature in Cooling
        Mode` Enter the maximum outdoor temperature allowed for cooling
        operation. Cooling is disabled above this temperature.

        Args:
            value (float): value for IDD Field `Maximum Outdoor Temperature in Cooling Mode`
                Units: C
                Default value: 43.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Maximum Outdoor Temperature in Cooling Mode"] = value

    @property
    def gross_rated_heating_capacity(self):
        """Get gross_rated_heating_capacity.

        Returns:
            float: the value of `gross_rated_heating_capacity` or None if not set

        """
        return self["Gross Rated Heating Capacity"]

    @gross_rated_heating_capacity.setter
    def gross_rated_heating_capacity(self, value="autosize"):
        """Corresponds to IDD field `Gross Rated Heating Capacity` Enter the
        heating capacity in watts at rated conditions or set to autosize.
        Heating capacity not accounting for the effect of supply air fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Gross Rated Heating Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gross Rated Heating Capacity"] = value

    @property
    def rated_heating_capacity_sizing_ratio(self):
        """Get rated_heating_capacity_sizing_ratio.

        Returns:
            float: the value of `rated_heating_capacity_sizing_ratio` or None if not set

        """
        return self["Rated Heating Capacity Sizing Ratio"]

    @rated_heating_capacity_sizing_ratio.setter
    def rated_heating_capacity_sizing_ratio(self, value=1.0):
        """  Corresponds to IDD field `Rated Heating Capacity Sizing Ratio`
        If the Gross Rated Heating Capacity is autosized, the heating capacity is sized
        to be equal to the cooling capacity multiplied by this sizing ratio. The zone
        terminal unit heating coils are also sized using this ratio unless the sizing
        ratio input in the ZoneHVAC:TerminalUnit:VariableRefrigerantFlow object is entered.

        Args:
            value (float): value for IDD Field `Rated Heating Capacity Sizing Ratio`
                Units: W/W
                Default value: 1.0
                value >= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Rated Heating Capacity Sizing Ratio"] = value

    @property
    def gross_rated_heating_cop(self):
        """Get gross_rated_heating_cop.

        Returns:
            float: the value of `gross_rated_heating_cop` or None if not set

        """
        return self["Gross Rated Heating COP"]

    @gross_rated_heating_cop.setter
    def gross_rated_heating_cop(self, value=3.4):
        """Corresponds to IDD field `Gross Rated Heating COP` COP includes
        compressor and condenser fan electrical energy input COP does not
        include supply fan heat or supply fan electrical energy input.

        Args:
            value (float): value for IDD Field `Gross Rated Heating COP`
                Units: W/W
                Default value: 3.4
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gross Rated Heating COP"] = value

    @property
    def minimum_outdoor_temperature_in_heating_mode(self):
        """Get minimum_outdoor_temperature_in_heating_mode.

        Returns:
            float: the value of `minimum_outdoor_temperature_in_heating_mode` or None if not set

        """
        return self["Minimum Outdoor Temperature in Heating Mode"]

    @minimum_outdoor_temperature_in_heating_mode.setter
    def minimum_outdoor_temperature_in_heating_mode(self, value=-20.0):
        """Corresponds to IDD field `Minimum Outdoor Temperature in Heating
        Mode` Enter the minimum outdoor temperature allowed for heating
        operation.

        Args:
            value (float): value for IDD Field `Minimum Outdoor Temperature in Heating Mode`
                Units: C
                Default value: -20.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Minimum Outdoor Temperature in Heating Mode"] = value

    @property
    def maximum_outdoor_temperature_in_heating_mode(self):
        """Get maximum_outdoor_temperature_in_heating_mode.

        Returns:
            float: the value of `maximum_outdoor_temperature_in_heating_mode` or None if not set

        """
        return self["Maximum Outdoor Temperature in Heating Mode"]

    @maximum_outdoor_temperature_in_heating_mode.setter
    def maximum_outdoor_temperature_in_heating_mode(self, value=16.0):
        """Corresponds to IDD field `Maximum Outdoor Temperature in Heating
        Mode` Enter the maximum outdoor temperature allowed for heating
        operation.

        Args:
            value (float): value for IDD Field `Maximum Outdoor Temperature in Heating Mode`
                Units: C
                Default value: 16.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Maximum Outdoor Temperature in Heating Mode"] = value

    @property
    def minimum_heat_pump_partload_ratio(self):
        """Get minimum_heat_pump_partload_ratio.

        Returns:
            float: the value of `minimum_heat_pump_partload_ratio` or None if not set

        """
        return self["Minimum Heat Pump Part-Load Ratio"]

    @minimum_heat_pump_partload_ratio.setter
    def minimum_heat_pump_partload_ratio(self, value=0.15):
        """  Corresponds to IDD field `Minimum Heat Pump Part-Load Ratio`
        Enter the minimum heat pump part-load ratio (PLR). When the cooling or heating PLR is
        below this value, the heat pump compressor will cycle to meet the cooling or heating
        demand.

        Args:
            value (float): value for IDD Field `Minimum Heat Pump Part-Load Ratio`
                Units: dimensionless
                Default value: 0.15
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Minimum Heat Pump Part-Load Ratio"] = value

    @property
    def zone_name_for_master_thermostat_location(self):
        """Get zone_name_for_master_thermostat_location.

        Returns:
            str: the value of `zone_name_for_master_thermostat_location` or None if not set

        """
        return self["Zone Name for Master Thermostat Location"]

    @zone_name_for_master_thermostat_location.setter
    def zone_name_for_master_thermostat_location(self, value=None):
        """Corresponds to IDD field `Zone Name for Master Thermostat Location`
        Enter the name of the zone where the master thermostat is located.

        Args:
            value (str): value for IDD Field `Zone Name for Master Thermostat Location`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Zone Name for Master Thermostat Location"] = value

    @property
    def master_thermostat_priority_control_type(self):
        """Get master_thermostat_priority_control_type.

        Returns:
            str: the value of `master_thermostat_priority_control_type` or None if not set

        """
        return self["Master Thermostat Priority Control Type"]

    @master_thermostat_priority_control_type.setter
    def master_thermostat_priority_control_type(
            self,
            value="MasterThermostatPriority"):
        """Corresponds to IDD field `Master Thermostat Priority Control Type`
        Choose a thermostat control logic scheme. If these control types fail
        to control zone temperature within a reasonable limit, consider using
        multiple VRF systems.

        Args:
            value (str): value for IDD Field `Master Thermostat Priority Control Type`
                Default value: MasterThermostatPriority
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Master Thermostat Priority Control Type"] = value

    @property
    def thermostat_priority_schedule_name(self):
        """Get thermostat_priority_schedule_name.

        Returns:
            str: the value of `thermostat_priority_schedule_name` or None if not set

        """
        return self["Thermostat Priority Schedule Name"]

    @thermostat_priority_schedule_name.setter
    def thermostat_priority_schedule_name(self, value=None):
        """Corresponds to IDD field `Thermostat Priority Schedule Name` this
        field is required if Master Thermostat Priority Control Type is
        Scheduled. Schedule values of 0 denote cooling, 1 for heating, and all
        other values disable the system.

        Args:
            value (str): value for IDD Field `Thermostat Priority Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Thermostat Priority Schedule Name"] = value

    @property
    def heat_pump_waste_heat_recovery(self):
        """Get heat_pump_waste_heat_recovery.

        Returns:
            str: the value of `heat_pump_waste_heat_recovery` or None if not set

        """
        return self["Heat Pump Waste Heat Recovery"]

    @heat_pump_waste_heat_recovery.setter
    def heat_pump_waste_heat_recovery(self, value="No"):
        """Corresponds to IDD field `Heat Pump Waste Heat Recovery` This field
        is reserved for future use. The only valid choice is No.

        Args:
            value (str): value for IDD Field `Heat Pump Waste Heat Recovery`
                Default value: No
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Waste Heat Recovery"] = value

    @property
    def equivalent_piping_length_used_for_piping_correction_factor_in_cooling_mode(
            self):
        """Get equivalent_piping_length_used_for_piping_correction_factor_in_co
        oling_mode.

        Returns:
            float: the value of `equivalent_piping_length_used_for_piping_correction_factor_in_cooling_mode` or None if not set

        """
        return self[
            "Equivalent Piping Length used for Piping Correction Factor in Cooling Mode"]

    @equivalent_piping_length_used_for_piping_correction_factor_in_cooling_mode.setter
    def equivalent_piping_length_used_for_piping_correction_factor_in_cooling_mode(
            self,
            value=30.0):
        """Corresponds to IDD field `Equivalent Piping Length used for Piping
        Correction Factor in Cooling Mode` Enter the equivalent length of the
        farthest terminal unit from the condenser.

        Args:
            value (float): value for IDD Field `Equivalent Piping Length used for Piping Correction Factor in Cooling Mode`
                Units: m
                Default value: 30.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Equivalent Piping Length used for Piping Correction Factor in Cooling Mode"] = value

    @property
    def vertical_height_used_for_piping_correction_factor(self):
        """Get vertical_height_used_for_piping_correction_factor.

        Returns:
            float: the value of `vertical_height_used_for_piping_correction_factor` or None if not set

        """
        return self["Vertical Height used for Piping Correction Factor"]

    @vertical_height_used_for_piping_correction_factor.setter
    def vertical_height_used_for_piping_correction_factor(self, value=10.0):
        """Corresponds to IDD field `Vertical Height used for Piping Correction
        Factor` Enter the height difference between the highest and lowest
        terminal unit.

        Args:
            value (float): value for IDD Field `Vertical Height used for Piping Correction Factor`
                Units: m
                Default value: 10.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Vertical Height used for Piping Correction Factor"] = value

    @property
    def equivalent_piping_length_used_for_piping_correction_factor_in_heating_mode(
            self):
        """Get equivalent_piping_length_used_for_piping_correction_factor_in_he
        ating_mode.

        Returns:
            float: the value of `equivalent_piping_length_used_for_piping_correction_factor_in_heating_mode` or None if not set

        """
        return self[
            "Equivalent Piping Length used for Piping Correction Factor in Heating Mode"]

    @equivalent_piping_length_used_for_piping_correction_factor_in_heating_mode.setter
    def equivalent_piping_length_used_for_piping_correction_factor_in_heating_mode(
            self,
            value=30.0):
        """Corresponds to IDD field `Equivalent Piping Length used for Piping
        Correction Factor in Heating Mode` Enter the equivalent length of the
        farthest terminal unit from the condenser.

        Args:
            value (float): value for IDD Field `Equivalent Piping Length used for Piping Correction Factor in Heating Mode`
                Units: m
                Default value: 30.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self[
            "Equivalent Piping Length used for Piping Correction Factor in Heating Mode"] = value

    @property
    def crankcase_heater_power_per_compressor(self):
        """Get crankcase_heater_power_per_compressor.

        Returns:
            float: the value of `crankcase_heater_power_per_compressor` or None if not set

        """
        return self["Crankcase Heater Power per Compressor"]

    @crankcase_heater_power_per_compressor.setter
    def crankcase_heater_power_per_compressor(self, value=33.0):
        """Corresponds to IDD field `Crankcase Heater Power per Compressor`
        Enter the value of the resistive heater located in the compressor(s).
        This heater is used to warm the refrigerant and oil when the compressor
        is off.

        Args:
            value (float): value for IDD Field `Crankcase Heater Power per Compressor`
                Units: W
                Default value: 33.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Crankcase Heater Power per Compressor"] = value

    @property
    def number_of_compressors(self):
        """Get number_of_compressors.

        Returns:
            int: the value of `number_of_compressors` or None if not set

        """
        return self["Number of Compressors"]

    @number_of_compressors.setter
    def number_of_compressors(self, value=2):
        """Corresponds to IDD field `Number of Compressors` Enter the total
        number of compressor. This input is used only for crankcase heater
        calculations.

        Args:
            value (int): value for IDD Field `Number of Compressors`
                Units: dimensionless
                Default value: 2
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Number of Compressors"] = value

    @property
    def ratio_of_compressor_size_to_total_compressor_capacity(self):
        """Get ratio_of_compressor_size_to_total_compressor_capacity.

        Returns:
            float: the value of `ratio_of_compressor_size_to_total_compressor_capacity` or None if not set

        """
        return self["Ratio of Compressor Size to Total Compressor Capacity"]

    @ratio_of_compressor_size_to_total_compressor_capacity.setter
    def ratio_of_compressor_size_to_total_compressor_capacity(self, value=0.5):
        """Corresponds to IDD field `Ratio of Compressor Size to Total
        Compressor Capacity` Enter the ratio of the first stage compressor to
        total compressor capacity. All other compressors are assumed to be
        equally sized. This inputs is used only for crankcase heater
        calculations.

        Args:
            value (float): value for IDD Field `Ratio of Compressor Size to Total Compressor Capacity`
                Units: W/W
                Default value: 0.5
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Ratio of Compressor Size to Total Compressor Capacity"] = value

    @property
    def maximum_outdoor_drybulb_temperature_for_crankcase_heater(self):
        """Get maximum_outdoor_drybulb_temperature_for_crankcase_heater.

        Returns:
            float: the value of `maximum_outdoor_drybulb_temperature_for_crankcase_heater` or None if not set

        """
        return self[
            "Maximum Outdoor Dry-bulb Temperature for Crankcase Heater"]

    @maximum_outdoor_drybulb_temperature_for_crankcase_heater.setter
    def maximum_outdoor_drybulb_temperature_for_crankcase_heater(
            self,
            value=5.0):
        """  Corresponds to IDD field `Maximum Outdoor Dry-bulb Temperature for Crankcase Heater`
        Enter the maximum outdoor temperature above which the crankcase heaters are disabled.

        Args:
            value (float): value for IDD Field `Maximum Outdoor Dry-bulb Temperature for Crankcase Heater`
                Units: C
                Default value: 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Maximum Outdoor Dry-bulb Temperature for Crankcase Heater"] = value

    @property
    def defrost_strategy(self):
        """Get defrost_strategy.

        Returns:
            str: the value of `defrost_strategy` or None if not set

        """
        return self["Defrost Strategy"]

    @defrost_strategy.setter
    def defrost_strategy(self, value="Resistive"):
        """Corresponds to IDD field `Defrost Strategy` Select a defrost
        strategy. Reverse cycle reverses the operating mode from heating to
        cooling to melt frost formation on the condenser coil. The resistive
        strategy uses a resitive heater to melt the frost.

        Args:
            value (str): value for IDD Field `Defrost Strategy`
                Default value: Resistive
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Defrost Strategy"] = value

    @property
    def defrost_control(self):
        """Get defrost_control.

        Returns:
            str: the value of `defrost_control` or None if not set

        """
        return self["Defrost Control"]

    @defrost_control.setter
    def defrost_control(self, value="Timed"):
        """Corresponds to IDD field `Defrost Control` Choose a defrost control
        type. Either use a fixed Timed defrost period or select OnDemand to
        defrost only when necessary.

        Args:
            value (str): value for IDD Field `Defrost Control`
                Default value: Timed
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Defrost Control"] = value

    @property
    def defrost_time_period_fraction(self):
        """Get defrost_time_period_fraction.

        Returns:
            float: the value of `defrost_time_period_fraction` or None if not set

        """
        return self["Defrost Time Period Fraction"]

    @defrost_time_period_fraction.setter
    def defrost_time_period_fraction(self, value=0.058333):
        """Corresponds to IDD field `Defrost Time Period Fraction` Fraction of
        time in defrost mode. Only applicable if timed defrost control is
        specified.

        Args:
            value (float): value for IDD Field `Defrost Time Period Fraction`
                Units: dimensionless
                Default value: 0.058333
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Defrost Time Period Fraction"] = value

    @property
    def resistive_defrost_heater_capacity(self):
        """Get resistive_defrost_heater_capacity.

        Returns:
            float: the value of `resistive_defrost_heater_capacity` or None if not set

        """
        return self["Resistive Defrost Heater Capacity"]

    @resistive_defrost_heater_capacity.setter
    def resistive_defrost_heater_capacity(self, value="autosize"):
        """Corresponds to IDD field `Resistive Defrost Heater Capacity` Enter
        the size of the resistive defrost heating element. Only applicable if
        resistive defrost strategy is specified.

        Args:
            value (float or "Autosize"): value for IDD Field `Resistive Defrost Heater Capacity`
                Units: W
                IP-Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Resistive Defrost Heater Capacity"] = value

    @property
    def maximum_outdoor_drybulb_temperature_for_defrost_operation(self):
        """Get maximum_outdoor_drybulb_temperature_for_defrost_operation.

        Returns:
            float: the value of `maximum_outdoor_drybulb_temperature_for_defrost_operation` or None if not set

        """
        return self[
            "Maximum Outdoor Dry-bulb Temperature for Defrost Operation"]

    @maximum_outdoor_drybulb_temperature_for_defrost_operation.setter
    def maximum_outdoor_drybulb_temperature_for_defrost_operation(
            self,
            value=5.0):
        """  Corresponds to IDD field `Maximum Outdoor Dry-bulb Temperature for Defrost Operation`
        Enter the maximum outdoor temperature above which the crankcase heaters are disabled.

        Args:
            value (float): value for IDD Field `Maximum Outdoor Dry-bulb Temperature for Defrost Operation`
                Units: C
                Default value: 5.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Maximum Outdoor Dry-bulb Temperature for Defrost Operation"] = value

    @property
    def condenser_type(self):
        """Get condenser_type.

        Returns:
            str: the value of `condenser_type` or None if not set

        """
        return self["Condenser Type"]

    @condenser_type.setter
    def condenser_type(self, value="AirCooled"):
        """Corresponds to IDD field `Condenser Type` Select either an air
        cooled or evaporatively cooled condenser.

        Args:
            value (str): value for IDD Field `Condenser Type`
                Default value: AirCooled
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Condenser Type"] = value

    @property
    def water_condenser_volume_flow_rate(self):
        """Get water_condenser_volume_flow_rate.

        Returns:
            float: the value of `water_condenser_volume_flow_rate` or None if not set

        """
        return self["Water Condenser Volume Flow Rate"]

    @water_condenser_volume_flow_rate.setter
    def water_condenser_volume_flow_rate(self, value="autosize"):
        """  Corresponds to IDD field `Water Condenser Volume Flow Rate`
        Only used when Condenser Type = WaterCooled.

        Args:
            value (float or "Autosize"): value for IDD Field `Water Condenser Volume Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Water Condenser Volume Flow Rate"] = value

    @property
    def evaporative_condenser_effectiveness(self):
        """Get evaporative_condenser_effectiveness.

        Returns:
            float: the value of `evaporative_condenser_effectiveness` or None if not set

        """
        return self["Evaporative Condenser Effectiveness"]

    @evaporative_condenser_effectiveness.setter
    def evaporative_condenser_effectiveness(self, value=0.9):
        """  Corresponds to IDD field `Evaporative Condenser Effectiveness`
        Enter the effectiveness of the evaporatively cooled condenser.
        This field is only used when the Condenser Type = EvaporativelyCooled.

        Args:
            value (float): value for IDD Field `Evaporative Condenser Effectiveness`
                Units: dimensionless
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Evaporative Condenser Effectiveness"] = value

    @property
    def evaporative_condenser_air_flow_rate(self):
        """Get evaporative_condenser_air_flow_rate.

        Returns:
            float: the value of `evaporative_condenser_air_flow_rate` or None if not set

        """
        return self["Evaporative Condenser Air Flow Rate"]

    @evaporative_condenser_air_flow_rate.setter
    def evaporative_condenser_air_flow_rate(self, value="autosize"):
        """  Corresponds to IDD field `Evaporative Condenser Air Flow Rate`
        Used to calculate evaporative condenser water use.
        This field is only used when the Condenser Type = EvaporativelyCooled.

        Args:
            value (float or "Autosize"): value for IDD Field `Evaporative Condenser Air Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Evaporative Condenser Air Flow Rate"] = value

    @property
    def evaporative_condenser_pump_rated_power_consumption(self):
        """Get evaporative_condenser_pump_rated_power_consumption.

        Returns:
            float: the value of `evaporative_condenser_pump_rated_power_consumption` or None if not set

        """
        return self["Evaporative Condenser Pump Rated Power Consumption"]

    @evaporative_condenser_pump_rated_power_consumption.setter
    def evaporative_condenser_pump_rated_power_consumption(self, value=None):
        """  Corresponds to IDD field `Evaporative Condenser Pump Rated Power Consumption`
        Rated power consumed by the evaporative condenser's water pump.
        This field is only used when the Condenser Type = EvaporativelyCooled.

        Args:
            value (float or "Autosize"): value for IDD Field `Evaporative Condenser Pump Rated Power Consumption`
                Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Evaporative Condenser Pump Rated Power Consumption"] = value

    @property
    def basin_heater_capacity(self):
        """Get basin_heater_capacity.

        Returns:
            float: the value of `basin_heater_capacity` or None if not set

        """
        return self["Basin Heater Capacity"]

    @basin_heater_capacity.setter
    def basin_heater_capacity(self, value=None):
        """  Corresponds to IDD field `Basin Heater Capacity`
        This field is only used for Condenser Type = EvaporativelyCooled and for periods
        when the basin heater is available (field Basin Heater Operating Schedule Name).
        For this situation, the heater maintains the basin water temperature at the basin heater
        setpoint temperature when the outdoor air temperature falls below the setpoint temperature.
        The basin heater only operates when the DX coil is off.

        Args:
            value (float): value for IDD Field `Basin Heater Capacity`
                Units: W/K
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Capacity"] = value

    @property
    def basin_heater_setpoint_temperature(self):
        """Get basin_heater_setpoint_temperature.

        Returns:
            float: the value of `basin_heater_setpoint_temperature` or None if not set

        """
        return self["Basin Heater Setpoint Temperature"]

    @basin_heater_setpoint_temperature.setter
    def basin_heater_setpoint_temperature(self, value=2.0):
        """  Corresponds to IDD field `Basin Heater Setpoint Temperature`
        This field is only used for Condenser Type = EvaporativelyCooled.
        Enter the outdoor dry-bulb temperature when the basin heater turns on.

        Args:
            value (float): value for IDD Field `Basin Heater Setpoint Temperature`
                Units: C
                Default value: 2.0
                value >= 2.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Setpoint Temperature"] = value

    @property
    def basin_heater_operating_schedule_name(self):
        """Get basin_heater_operating_schedule_name.

        Returns:
            str: the value of `basin_heater_operating_schedule_name` or None if not set

        """
        return self["Basin Heater Operating Schedule Name"]

    @basin_heater_operating_schedule_name.setter
    def basin_heater_operating_schedule_name(self, value=None):
        """  Corresponds to IDD field `Basin Heater Operating Schedule Name`
        This field is only used for Condenser Type = EvaporativelyCooled.
        Schedule values greater than 0 allow the basin heater to operate whenever the outdoor
        air dry-bulb temperature is below the basin heater setpoint temperature.
        If a schedule name is not entered, the basin heater is allowed to operate
        throughout the entire simulation.

        Args:
            value (str): value for IDD Field `Basin Heater Operating Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Basin Heater Operating Schedule Name"] = value

    @property
    def fuel_type(self):
        """Get fuel_type.

        Returns:
            str: the value of `fuel_type` or None if not set

        """
        return self["Fuel Type"]

    @fuel_type.setter
    def fuel_type(self, value="Electricity"):
        """Corresponds to IDD field `Fuel Type`

        Args:
            value (str): value for IDD Field `Fuel Type`
                Default value: Electricity
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Fuel Type"] = value

    @property
    def minimum_outdoor_temperature_in_heat_recovery_mode(self):
        """Get minimum_outdoor_temperature_in_heat_recovery_mode.

        Returns:
            float: the value of `minimum_outdoor_temperature_in_heat_recovery_mode` or None if not set

        """
        return self["Minimum Outdoor Temperature in Heat Recovery Mode"]

    @minimum_outdoor_temperature_in_heat_recovery_mode.setter
    def minimum_outdoor_temperature_in_heat_recovery_mode(self, value=-15.0):
        """Corresponds to IDD field `Minimum Outdoor Temperature in Heat
        Recovery Mode` The minimum outdoor temperature below which heat
        recovery mode will not operate.

        Args:
            value (float): value for IDD Field `Minimum Outdoor Temperature in Heat Recovery Mode`
                Units: C
                Default value: -15.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Minimum Outdoor Temperature in Heat Recovery Mode"] = value

    @property
    def maximum_outdoor_temperature_in_heat_recovery_mode(self):
        """Get maximum_outdoor_temperature_in_heat_recovery_mode.

        Returns:
            float: the value of `maximum_outdoor_temperature_in_heat_recovery_mode` or None if not set

        """
        return self["Maximum Outdoor Temperature in Heat Recovery Mode"]

    @maximum_outdoor_temperature_in_heat_recovery_mode.setter
    def maximum_outdoor_temperature_in_heat_recovery_mode(self, value=45.0):
        """Corresponds to IDD field `Maximum Outdoor Temperature in Heat
        Recovery Mode` The maximum outdoor temperature above which heat
        recovery mode will not operate.

        Args:
            value (float): value for IDD Field `Maximum Outdoor Temperature in Heat Recovery Mode`
                Units: C
                Default value: 45.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Maximum Outdoor Temperature in Heat Recovery Mode"] = value




class HvactemplateSystemUnitary(DataObject):

    """ Corresponds to IDD object `HVACTemplate:System:Unitary`
        Unitary furnace with air conditioner
    """
    schema = {'min-fields': 52,
              'name': u'HVACTemplate:System:Unitary',
              'pyname': u'HvactemplateSystemUnitary',
              'format': None,
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'system availability schedule name',
                                      {'name': u'System Availability Schedule Name',
                                       'pyname': u'system_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'control zone or thermostat location name',
                                      {'name': u'Control Zone or Thermostat Location Name',
                                       'pyname': u'control_zone_or_thermostat_location_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply fan maximum flow rate',
                                      {'name': u'Supply Fan Maximum Flow Rate',
                                       'pyname': u'supply_fan_maximum_flow_rate',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'supply fan operating mode schedule name',
                                      {'name': u'Supply Fan Operating Mode Schedule Name',
                                       'pyname': u'supply_fan_operating_mode_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply fan total efficiency',
                                      {'name': u'Supply Fan Total Efficiency',
                                       'pyname': u'supply_fan_total_efficiency',
                                       'default': 0.7,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supply fan delta pressure',
                                      {'name': u'Supply Fan Delta Pressure',
                                       'pyname': u'supply_fan_delta_pressure',
                                       'default': 600.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'Pa'}),
                                     (u'supply fan motor efficiency',
                                      {'name': u'Supply Fan Motor Efficiency',
                                       'pyname': u'supply_fan_motor_efficiency',
                                       'default': 0.9,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supply fan motor in air stream fraction',
                                      {'name': u'Supply Fan Motor in Air Stream Fraction',
                                       'pyname': u'supply_fan_motor_in_air_stream_fraction',
                                       'default': 1.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'cooling coil type',
                                      {'name': u'Cooling Coil Type',
                                       'pyname': u'cooling_coil_type',
                                       'default': u'SingleSpeedDX',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SingleSpeedDX',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'cooling coil availability schedule name',
                                      {'name': u'Cooling Coil Availability Schedule Name',
                                       'pyname': u'cooling_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'cooling design supply air temperature',
                                      {'name': u'Cooling Design Supply Air Temperature',
                                       'pyname': u'cooling_design_supply_air_temperature',
                                       'default': 12.8,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'cooling coil gross rated total capacity',
                                      {'name': u'Cooling Coil Gross Rated Total Capacity',
                                       'pyname': u'cooling_coil_gross_rated_total_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'cooling coil gross rated sensible heat ratio',
                                      {'name': u'Cooling Coil Gross Rated Sensible Heat Ratio',
                                       'pyname': u'cooling_coil_gross_rated_sensible_heat_ratio',
                                       'default': 'autosize',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.5,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'cooling coil gross rated cop',
                                      {'name': u'Cooling Coil Gross Rated COP',
                                       'pyname': u'cooling_coil_gross_rated_cop',
                                       'default': 3.0,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W/W'}),
                                     (u'heating coil type',
                                      {'name': u'Heating Coil Type',
                                       'pyname': u'heating_coil_type',
                                       'required-field': True,
                                       'autosizable': False,
                                       'accepted-values': [u'Electric',
                                                           u'Gas',
                                                           u'HotWater'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heating coil availability schedule name',
                                      {'name': u'Heating Coil Availability Schedule Name',
                                       'pyname': u'heating_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'heating design supply air temperature',
                                      {'name': u'Heating Design Supply Air Temperature',
                                       'pyname': u'heating_design_supply_air_temperature',
                                       'default': 50.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'heating coil capacity',
                                      {'name': u'Heating Coil Capacity',
                                       'pyname': u'heating_coil_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'gas heating coil efficiency',
                                      {'name': u'Gas Heating Coil Efficiency',
                                       'pyname': u'gas_heating_coil_efficiency',
                                       'default': 0.8,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'gas heating coil parasitic electric load',
                                      {'name': u'Gas Heating Coil Parasitic Electric Load',
                                       'pyname': u'gas_heating_coil_parasitic_electric_load',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'maximum outdoor air flow rate',
                                      {'name': u'Maximum Outdoor Air Flow Rate',
                                       'pyname': u'maximum_outdoor_air_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'minimum outdoor air flow rate',
                                      {'name': u'Minimum Outdoor Air Flow Rate',
                                       'pyname': u'minimum_outdoor_air_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'minimum outdoor air schedule name',
                                      {'name': u'Minimum Outdoor Air Schedule Name',
                                       'pyname': u'minimum_outdoor_air_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'economizer type',
                                      {'name': u'Economizer Type',
                                       'pyname': u'economizer_type',
                                       'default': u'NoEconomizer',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'FixedDryBulb',
                                                           u'FixedEnthalpy',
                                                           u'DifferentialDryBulb',
                                                           u'DifferentialEnthalpy',
                                                           u'FixedDewPointAndDryBulb',
                                                           u'ElectronicEnthalpy',
                                                           u'DifferentialDryBulbAndEnthalpy',
                                                           u'NoEconomizer'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'economizer lockout',
                                      {'name': u'Economizer Lockout',
                                       'pyname': u'economizer_lockout',
                                       'default': u'NoLockout',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'NoLockout',
                                                           u'LockoutWithHeating',
                                                           u'LockoutWithCompressor'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'economizer upper temperature limit',
                                      {'name': u'Economizer Upper Temperature Limit',
                                       'pyname': u'economizer_upper_temperature_limit',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'economizer lower temperature limit',
                                      {'name': u'Economizer Lower Temperature Limit',
                                       'pyname': u'economizer_lower_temperature_limit',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'economizer upper enthalpy limit',
                                      {'name': u'Economizer Upper Enthalpy Limit',
                                       'pyname': u'economizer_upper_enthalpy_limit',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'J/kg'}),
                                     (u'economizer maximum limit dewpoint temperature',
                                      {'name': u'Economizer Maximum Limit Dewpoint Temperature',
                                       'pyname': u'economizer_maximum_limit_dewpoint_temperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'supply plenum name',
                                      {'name': u'Supply Plenum Name',
                                       'pyname': u'supply_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'return plenum name',
                                      {'name': u'Return Plenum Name',
                                       'pyname': u'return_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply fan placement',
                                      {'name': u'Supply Fan Placement',
                                       'pyname': u'supply_fan_placement',
                                       'default': u'BlowThrough',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'BlowThrough',
                                                           u'DrawThrough'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'night cycle control',
                                      {'name': u'Night Cycle Control',
                                       'pyname': u'night_cycle_control',
                                       'default': u'StayOff',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'StayOff',
                                                           u'CycleOnAny',
                                                           u'CycleOnControlZone'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'night cycle control zone name',
                                      {'name': u'Night Cycle Control Zone Name',
                                       'pyname': u'night_cycle_control_zone_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'heat recovery type',
                                      {'name': u'Heat Recovery Type',
                                       'pyname': u'heat_recovery_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'None',
                                                           u'Sensible',
                                                           u'Enthalpy'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'sensible heat recovery effectiveness',
                                      {'name': u'Sensible Heat Recovery Effectiveness',
                                       'pyname': u'sensible_heat_recovery_effectiveness',
                                       'default': 0.7,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'latent heat recovery effectiveness',
                                      {'name': u'Latent Heat Recovery Effectiveness',
                                       'pyname': u'latent_heat_recovery_effectiveness',
                                       'default': 0.65,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'dehumidification control type',
                                      {'name': u'Dehumidification Control Type',
                                       'pyname': u'dehumidification_control_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'None',
                                                           u'CoolReheatHeatingCoil',
                                                           u'CoolReheatDesuperheater'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'dehumidification control zone name',
                                      {'name': u'Dehumidification Control Zone Name',
                                       'pyname': u'dehumidification_control_zone_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'dehumidification setpoint',
                                      {'name': u'Dehumidification Setpoint',
                                       'pyname': u'dehumidification_setpoint',
                                       'default': 60.0,
                                       'maximum': 100.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'percent'}),
                                     (u'humidifier type',
                                      {'name': u'Humidifier Type',
                                       'pyname': u'humidifier_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'None',
                                                           u'ElectricSteam'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'humidifier availability schedule name',
                                      {'name': u'Humidifier Availability Schedule Name',
                                       'pyname': u'humidifier_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'humidifier rated capacity',
                                      {'name': u'Humidifier Rated Capacity',
                                       'pyname': u'humidifier_rated_capacity',
                                       'default': 1e-06,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'humidifier rated electric power',
                                      {'name': u'Humidifier Rated Electric Power',
                                       'pyname': u'humidifier_rated_electric_power',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'humidifier control zone name',
                                      {'name': u'Humidifier Control Zone Name',
                                       'pyname': u'humidifier_control_zone_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'humidifier setpoint',
                                      {'name': u'Humidifier Setpoint',
                                       'pyname': u'humidifier_setpoint',
                                       'default': 30.0,
                                       'maximum': 100.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'percent'}),
                                     (u'return fan',
                                      {'name': u'Return Fan',
                                       'pyname': u'return_fan',
                                       'default': u'No',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Yes',
                                                           u'No'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'return fan total efficiency',
                                      {'name': u'Return Fan Total Efficiency',
                                       'pyname': u'return_fan_total_efficiency',
                                       'default': 0.7,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'return fan delta pressure',
                                      {'name': u'Return Fan Delta Pressure',
                                       'pyname': u'return_fan_delta_pressure',
                                       'default': 500.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'Pa'}),
                                     (u'return fan motor efficiency',
                                      {'name': u'Return Fan Motor Efficiency',
                                       'pyname': u'return_fan_motor_efficiency',
                                       'default': 0.9,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'return fan motor in air stream fraction',
                                      {'name': u'Return Fan Motor in Air Stream Fraction',
                                       'pyname': u'return_fan_motor_in_air_stream_fraction',
                                       'default': 1.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def system_availability_schedule_name(self):
        """Get system_availability_schedule_name.

        Returns:
            str: the value of `system_availability_schedule_name` or None if not set

        """
        return self["System Availability Schedule Name"]

    @system_availability_schedule_name.setter
    def system_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `System Availability Schedule Name` If
        blank, always on; Unitary System always on.  Schedule is used in
        availability manager and fan scheduling. Also see "Night Cycle Control"
        field.

        Args:
            value (str): value for IDD Field `System Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["System Availability Schedule Name"] = value

    @property
    def control_zone_or_thermostat_location_name(self):
        """Get control_zone_or_thermostat_location_name.

        Returns:
            str: the value of `control_zone_or_thermostat_location_name` or None if not set

        """
        return self["Control Zone or Thermostat Location Name"]

    @control_zone_or_thermostat_location_name.setter
    def control_zone_or_thermostat_location_name(self, value=None):
        """Corresponds to IDD field `Control Zone or Thermostat Location Name`

        Args:
            value (str): value for IDD Field `Control Zone or Thermostat Location Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Control Zone or Thermostat Location Name"] = value

    @property
    def supply_fan_maximum_flow_rate(self):
        """Get supply_fan_maximum_flow_rate.

        Returns:
            float: the value of `supply_fan_maximum_flow_rate` or None if not set

        """
        return self["Supply Fan Maximum Flow Rate"]

    @supply_fan_maximum_flow_rate.setter
    def supply_fan_maximum_flow_rate(self, value="autosize"):
        """  Corresponds to IDD field `Supply Fan Maximum Flow Rate`
        This field may be set to "autosize".  If a value is entered, it will *not* be
        multiplied by any sizing factor or by zone multipliers.  If using zone multipliers
        a value entered here must be large enough to serve the multiplied zones.

        Args:
            value (float or "Autosize"): value for IDD Field `Supply Fan Maximum Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Supply Fan Maximum Flow Rate"] = value

    @property
    def supply_fan_operating_mode_schedule_name(self):
        """Get supply_fan_operating_mode_schedule_name.

        Returns:
            str: the value of `supply_fan_operating_mode_schedule_name` or None if not set

        """
        return self["Supply Fan Operating Mode Schedule Name"]

    @supply_fan_operating_mode_schedule_name.setter
    def supply_fan_operating_mode_schedule_name(self, value=None):
        """Corresponds to IDD field `Supply Fan Operating Mode Schedule Name`
        Refers to a schedule to specify unitary supply fan operating mode.
        Schedule values of 0 indicate cycling fan (auto) Schedule values of 1
        indicate continuous fan (on) If this field is left blank, a schedule of
        always zero (cycling fan) will be used.

        Args:
            value (str): value for IDD Field `Supply Fan Operating Mode Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Operating Mode Schedule Name"] = value

    @property
    def supply_fan_total_efficiency(self):
        """Get supply_fan_total_efficiency.

        Returns:
            float: the value of `supply_fan_total_efficiency` or None if not set

        """
        return self["Supply Fan Total Efficiency"]

    @supply_fan_total_efficiency.setter
    def supply_fan_total_efficiency(self, value=0.7):
        """Corresponds to IDD field `Supply Fan Total Efficiency`

        Args:
            value (float): value for IDD Field `Supply Fan Total Efficiency`
                Default value: 0.7
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Total Efficiency"] = value

    @property
    def supply_fan_delta_pressure(self):
        """Get supply_fan_delta_pressure.

        Returns:
            float: the value of `supply_fan_delta_pressure` or None if not set

        """
        return self["Supply Fan Delta Pressure"]

    @supply_fan_delta_pressure.setter
    def supply_fan_delta_pressure(self, value=600.0):
        """Corresponds to IDD field `Supply Fan Delta Pressure`

        Args:
            value (float): value for IDD Field `Supply Fan Delta Pressure`
                Units: Pa
                IP-Units: inH2O
                Default value: 600.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Delta Pressure"] = value

    @property
    def supply_fan_motor_efficiency(self):
        """Get supply_fan_motor_efficiency.

        Returns:
            float: the value of `supply_fan_motor_efficiency` or None if not set

        """
        return self["Supply Fan Motor Efficiency"]

    @supply_fan_motor_efficiency.setter
    def supply_fan_motor_efficiency(self, value=0.9):
        """Corresponds to IDD field `Supply Fan Motor Efficiency`

        Args:
            value (float): value for IDD Field `Supply Fan Motor Efficiency`
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Motor Efficiency"] = value

    @property
    def supply_fan_motor_in_air_stream_fraction(self):
        """Get supply_fan_motor_in_air_stream_fraction.

        Returns:
            float: the value of `supply_fan_motor_in_air_stream_fraction` or None if not set

        """
        return self["Supply Fan Motor in Air Stream Fraction"]

    @supply_fan_motor_in_air_stream_fraction.setter
    def supply_fan_motor_in_air_stream_fraction(self, value=1.0):
        """Corresponds to IDD field `Supply Fan Motor in Air Stream Fraction`

        Args:
            value (float): value for IDD Field `Supply Fan Motor in Air Stream Fraction`
                Default value: 1.0
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Motor in Air Stream Fraction"] = value

    @property
    def cooling_coil_type(self):
        """Get cooling_coil_type.

        Returns:
            str: the value of `cooling_coil_type` or None if not set

        """
        return self["Cooling Coil Type"]

    @cooling_coil_type.setter
    def cooling_coil_type(self, value="SingleSpeedDX"):
        """Corresponds to IDD field `Cooling Coil Type`

        Args:
            value (str): value for IDD Field `Cooling Coil Type`
                Default value: SingleSpeedDX
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Type"] = value

    @property
    def cooling_coil_availability_schedule_name(self):
        """Get cooling_coil_availability_schedule_name.

        Returns:
            str: the value of `cooling_coil_availability_schedule_name` or None if not set

        """
        return self["Cooling Coil Availability Schedule Name"]

    @cooling_coil_availability_schedule_name.setter
    def cooling_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Cooling Coil Availability Schedule Name`
        If blank, always on.

        Args:
            value (str): value for IDD Field `Cooling Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Availability Schedule Name"] = value

    @property
    def cooling_design_supply_air_temperature(self):
        """Get cooling_design_supply_air_temperature.

        Returns:
            float: the value of `cooling_design_supply_air_temperature` or None if not set

        """
        return self["Cooling Design Supply Air Temperature"]

    @cooling_design_supply_air_temperature.setter
    def cooling_design_supply_air_temperature(self, value=12.8):
        """Corresponds to IDD field `Cooling Design Supply Air Temperature`
        Used for sizing.

        Args:
            value (float): value for IDD Field `Cooling Design Supply Air Temperature`
                Units: C
                Default value: 12.8
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Design Supply Air Temperature"] = value

    @property
    def cooling_coil_gross_rated_total_capacity(self):
        """Get cooling_coil_gross_rated_total_capacity.

        Returns:
            float: the value of `cooling_coil_gross_rated_total_capacity` or None if not set

        """
        return self["Cooling Coil Gross Rated Total Capacity"]

    @cooling_coil_gross_rated_total_capacity.setter
    def cooling_coil_gross_rated_total_capacity(self, value="autosize"):
        """Corresponds to IDD field `Cooling Coil Gross Rated Total Capacity`
        Total cooling capacity not accounting for the effect of supply air fan
        heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Coil Gross Rated Total Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Gross Rated Total Capacity"] = value

    @property
    def cooling_coil_gross_rated_sensible_heat_ratio(self):
        """Get cooling_coil_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `cooling_coil_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Cooling Coil Gross Rated Sensible Heat Ratio"]

    @cooling_coil_gross_rated_sensible_heat_ratio.setter
    def cooling_coil_gross_rated_sensible_heat_ratio(self, value="autosize"):
        """Corresponds to IDD field `Cooling Coil Gross Rated Sensible Heat
        Ratio` Gross SHR.

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Coil Gross Rated Sensible Heat Ratio`
                Default value: "autosize"
                value >= 0.5
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Gross Rated Sensible Heat Ratio"] = value

    @property
    def cooling_coil_gross_rated_cop(self):
        """Get cooling_coil_gross_rated_cop.

        Returns:
            float: the value of `cooling_coil_gross_rated_cop` or None if not set

        """
        return self["Cooling Coil Gross Rated COP"]

    @cooling_coil_gross_rated_cop.setter
    def cooling_coil_gross_rated_cop(self, value=3.0):
        """Corresponds to IDD field `Cooling Coil Gross Rated COP` Gross
        cooling capacity divided by power input to the compressor and outdoor
        fan, does not include supply air fan heat or supply air fan electric
        power.

        Args:
            value (float): value for IDD Field `Cooling Coil Gross Rated COP`
                Units: W/W
                Default value: 3.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Gross Rated COP"] = value

    @property
    def heating_coil_type(self):
        """Get heating_coil_type.

        Returns:
            str: the value of `heating_coil_type` or None if not set

        """
        return self["Heating Coil Type"]

    @heating_coil_type.setter
    def heating_coil_type(self, value=None):
        """Corresponds to IDD field `Heating Coil Type`

        Args:
            value (str): value for IDD Field `Heating Coil Type`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Coil Type"] = value

    @property
    def heating_coil_availability_schedule_name(self):
        """Get heating_coil_availability_schedule_name.

        Returns:
            str: the value of `heating_coil_availability_schedule_name` or None if not set

        """
        return self["Heating Coil Availability Schedule Name"]

    @heating_coil_availability_schedule_name.setter
    def heating_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Heating Coil Availability Schedule Name`
        If blank, always on.

        Args:
            value (str): value for IDD Field `Heating Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Coil Availability Schedule Name"] = value

    @property
    def heating_design_supply_air_temperature(self):
        """Get heating_design_supply_air_temperature.

        Returns:
            float: the value of `heating_design_supply_air_temperature` or None if not set

        """
        return self["Heating Design Supply Air Temperature"]

    @heating_design_supply_air_temperature.setter
    def heating_design_supply_air_temperature(self, value=50.0):
        """Corresponds to IDD field `Heating Design Supply Air Temperature`
        Used for sizing.

        Args:
            value (float): value for IDD Field `Heating Design Supply Air Temperature`
                Units: C
                Default value: 50.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Design Supply Air Temperature"] = value

    @property
    def heating_coil_capacity(self):
        """Get heating_coil_capacity.

        Returns:
            float: the value of `heating_coil_capacity` or None if not set

        """
        return self["Heating Coil Capacity"]

    @heating_coil_capacity.setter
    def heating_coil_capacity(self, value="autosize"):
        """Corresponds to IDD field `Heating Coil Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Heating Coil Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Coil Capacity"] = value

    @property
    def gas_heating_coil_efficiency(self):
        """Get gas_heating_coil_efficiency.

        Returns:
            float: the value of `gas_heating_coil_efficiency` or None if not set

        """
        return self["Gas Heating Coil Efficiency"]

    @gas_heating_coil_efficiency.setter
    def gas_heating_coil_efficiency(self, value=0.8):
        """Corresponds to IDD field `Gas Heating Coil Efficiency`

        Args:
            value (float): value for IDD Field `Gas Heating Coil Efficiency`
                Default value: 0.8
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gas Heating Coil Efficiency"] = value

    @property
    def gas_heating_coil_parasitic_electric_load(self):
        """Get gas_heating_coil_parasitic_electric_load.

        Returns:
            float: the value of `gas_heating_coil_parasitic_electric_load` or None if not set

        """
        return self["Gas Heating Coil Parasitic Electric Load"]

    @gas_heating_coil_parasitic_electric_load.setter
    def gas_heating_coil_parasitic_electric_load(self, value=None):
        """Corresponds to IDD field `Gas Heating Coil Parasitic Electric Load`

        Args:
            value (float): value for IDD Field `Gas Heating Coil Parasitic Electric Load`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Gas Heating Coil Parasitic Electric Load"] = value

    @property
    def maximum_outdoor_air_flow_rate(self):
        """Get maximum_outdoor_air_flow_rate.

        Returns:
            float: the value of `maximum_outdoor_air_flow_rate` or None if not set

        """
        return self["Maximum Outdoor Air Flow Rate"]

    @maximum_outdoor_air_flow_rate.setter
    def maximum_outdoor_air_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Maximum Outdoor Air Flow Rate`

        Args:
            value (float or "Autosize"): value for IDD Field `Maximum Outdoor Air Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Maximum Outdoor Air Flow Rate"] = value

    @property
    def minimum_outdoor_air_flow_rate(self):
        """Get minimum_outdoor_air_flow_rate.

        Returns:
            float: the value of `minimum_outdoor_air_flow_rate` or None if not set

        """
        return self["Minimum Outdoor Air Flow Rate"]

    @minimum_outdoor_air_flow_rate.setter
    def minimum_outdoor_air_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Minimum Outdoor Air Flow Rate`

        Args:
            value (float or "Autosize"): value for IDD Field `Minimum Outdoor Air Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Minimum Outdoor Air Flow Rate"] = value

    @property
    def minimum_outdoor_air_schedule_name(self):
        """Get minimum_outdoor_air_schedule_name.

        Returns:
            str: the value of `minimum_outdoor_air_schedule_name` or None if not set

        """
        return self["Minimum Outdoor Air Schedule Name"]

    @minimum_outdoor_air_schedule_name.setter
    def minimum_outdoor_air_schedule_name(self, value=None):
        """Corresponds to IDD field `Minimum Outdoor Air Schedule Name`
        Schedule values multiply the minimum outdoor air flow rate If blank,
        always one.

        Args:
            value (str): value for IDD Field `Minimum Outdoor Air Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Minimum Outdoor Air Schedule Name"] = value

    @property
    def economizer_type(self):
        """Get economizer_type.

        Returns:
            str: the value of `economizer_type` or None if not set

        """
        return self["Economizer Type"]

    @economizer_type.setter
    def economizer_type(self, value="NoEconomizer"):
        """Corresponds to IDD field `Economizer Type`

        Args:
            value (str): value for IDD Field `Economizer Type`
                Default value: NoEconomizer
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Economizer Type"] = value

    @property
    def economizer_lockout(self):
        """Get economizer_lockout.

        Returns:
            str: the value of `economizer_lockout` or None if not set

        """
        return self["Economizer Lockout"]

    @economizer_lockout.setter
    def economizer_lockout(self, value="NoLockout"):
        """Corresponds to IDD field `Economizer Lockout`

        Args:
            value (str): value for IDD Field `Economizer Lockout`
                Default value: NoLockout
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Economizer Lockout"] = value

    @property
    def economizer_upper_temperature_limit(self):
        """Get economizer_upper_temperature_limit.

        Returns:
            float: the value of `economizer_upper_temperature_limit` or None if not set

        """
        return self["Economizer Upper Temperature Limit"]

    @economizer_upper_temperature_limit.setter
    def economizer_upper_temperature_limit(self, value=None):
        """Corresponds to IDD field `Economizer Upper Temperature Limit`
        Outdoor temperature above which economizer is disabled and heat
        recovery is enabled (if available). Blank means no limit.

        Args:
            value (float): value for IDD Field `Economizer Upper Temperature Limit`
                Units: C
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Economizer Upper Temperature Limit"] = value

    @property
    def economizer_lower_temperature_limit(self):
        """Get economizer_lower_temperature_limit.

        Returns:
            float: the value of `economizer_lower_temperature_limit` or None if not set

        """
        return self["Economizer Lower Temperature Limit"]

    @economizer_lower_temperature_limit.setter
    def economizer_lower_temperature_limit(self, value=None):
        """Corresponds to IDD field `Economizer Lower Temperature Limit`
        Outdoor temperature below which economizer is disabled and heat
        recovery is enabled (if available). Blank means no limit.

        Args:
            value (float): value for IDD Field `Economizer Lower Temperature Limit`
                Units: C
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Economizer Lower Temperature Limit"] = value

    @property
    def economizer_upper_enthalpy_limit(self):
        """Get economizer_upper_enthalpy_limit.

        Returns:
            float: the value of `economizer_upper_enthalpy_limit` or None if not set

        """
        return self["Economizer Upper Enthalpy Limit"]

    @economizer_upper_enthalpy_limit.setter
    def economizer_upper_enthalpy_limit(self, value=None):
        """Corresponds to IDD field `Economizer Upper Enthalpy Limit` Outdoor
        enthalpy above which economizer is disabled and heat recovery is
        enabled (if available). Blank means no limit.

        Args:
            value (float): value for IDD Field `Economizer Upper Enthalpy Limit`
                Units: J/kg
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Economizer Upper Enthalpy Limit"] = value

    @property
    def economizer_maximum_limit_dewpoint_temperature(self):
        """Get economizer_maximum_limit_dewpoint_temperature.

        Returns:
            float: the value of `economizer_maximum_limit_dewpoint_temperature` or None if not set

        """
        return self["Economizer Maximum Limit Dewpoint Temperature"]

    @economizer_maximum_limit_dewpoint_temperature.setter
    def economizer_maximum_limit_dewpoint_temperature(self, value=None):
        """Corresponds to IDD field `Economizer Maximum Limit Dewpoint
        Temperature` Enter the maximum outdoor dewpoint temperature limit for
        FixedDewPointAndDryBulb economizer control type. No input or blank
        input means this limit is not operative. Limit is applied regardless of
        economizer control type.

        Args:
            value (float): value for IDD Field `Economizer Maximum Limit Dewpoint Temperature`
                Units: C
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Economizer Maximum Limit Dewpoint Temperature"] = value

    @property
    def supply_plenum_name(self):
        """Get supply_plenum_name.

        Returns:
            str: the value of `supply_plenum_name` or None if not set

        """
        return self["Supply Plenum Name"]

    @supply_plenum_name.setter
    def supply_plenum_name(self, value=None):
        """Corresponds to IDD field `Supply Plenum Name` Plenum zone name.
        Supply plenum serves all zones on this system. Blank if none.

        Args:
            value (str): value for IDD Field `Supply Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Plenum Name"] = value

    @property
    def return_plenum_name(self):
        """Get return_plenum_name.

        Returns:
            str: the value of `return_plenum_name` or None if not set

        """
        return self["Return Plenum Name"]

    @return_plenum_name.setter
    def return_plenum_name(self, value=None):
        """Corresponds to IDD field `Return Plenum Name` Plenum zone name.
        Return plenum serves all zones on this system. Blank if none.

        Args:
            value (str): value for IDD Field `Return Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Plenum Name"] = value

    @property
    def supply_fan_placement(self):
        """Get supply_fan_placement.

        Returns:
            str: the value of `supply_fan_placement` or None if not set

        """
        return self["Supply Fan Placement"]

    @supply_fan_placement.setter
    def supply_fan_placement(self, value="BlowThrough"):
        """Corresponds to IDD field `Supply Fan Placement`

        Args:
            value (str): value for IDD Field `Supply Fan Placement`
                Default value: BlowThrough
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Placement"] = value

    @property
    def night_cycle_control(self):
        """Get night_cycle_control.

        Returns:
            str: the value of `night_cycle_control` or None if not set

        """
        return self["Night Cycle Control"]

    @night_cycle_control.setter
    def night_cycle_control(self, value="StayOff"):
        """Corresponds to IDD field `Night Cycle Control`

        Args:
            value (str): value for IDD Field `Night Cycle Control`
                Default value: StayOff
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Night Cycle Control"] = value

    @property
    def night_cycle_control_zone_name(self):
        """Get night_cycle_control_zone_name.

        Returns:
            str: the value of `night_cycle_control_zone_name` or None if not set

        """
        return self["Night Cycle Control Zone Name"]

    @night_cycle_control_zone_name.setter
    def night_cycle_control_zone_name(self, value=None):
        """Corresponds to IDD field `Night Cycle Control Zone Name` Applicable
        only if Night Cycle Control is Cycle On Control Zone.

        Args:
            value (str): value for IDD Field `Night Cycle Control Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Night Cycle Control Zone Name"] = value

    @property
    def heat_recovery_type(self):
        """Get heat_recovery_type.

        Returns:
            str: the value of `heat_recovery_type` or None if not set

        """
        return self["Heat Recovery Type"]

    @heat_recovery_type.setter
    def heat_recovery_type(self, value="None"):
        """Corresponds to IDD field `Heat Recovery Type`

        Args:
            value (str): value for IDD Field `Heat Recovery Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Recovery Type"] = value

    @property
    def sensible_heat_recovery_effectiveness(self):
        """Get sensible_heat_recovery_effectiveness.

        Returns:
            float: the value of `sensible_heat_recovery_effectiveness` or None if not set

        """
        return self["Sensible Heat Recovery Effectiveness"]

    @sensible_heat_recovery_effectiveness.setter
    def sensible_heat_recovery_effectiveness(self, value=0.7):
        """Corresponds to IDD field `Sensible Heat Recovery Effectiveness`

        Args:
            value (float): value for IDD Field `Sensible Heat Recovery Effectiveness`
                Default value: 0.7
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Sensible Heat Recovery Effectiveness"] = value

    @property
    def latent_heat_recovery_effectiveness(self):
        """Get latent_heat_recovery_effectiveness.

        Returns:
            float: the value of `latent_heat_recovery_effectiveness` or None if not set

        """
        return self["Latent Heat Recovery Effectiveness"]

    @latent_heat_recovery_effectiveness.setter
    def latent_heat_recovery_effectiveness(self, value=0.65):
        """Corresponds to IDD field `Latent Heat Recovery Effectiveness`
        Applicable only if Heat Recovery Type is Enthalpy.

        Args:
            value (float): value for IDD Field `Latent Heat Recovery Effectiveness`
                Default value: 0.65
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Latent Heat Recovery Effectiveness"] = value

    @property
    def dehumidification_control_type(self):
        """Get dehumidification_control_type.

        Returns:
            str: the value of `dehumidification_control_type` or None if not set

        """
        return self["Dehumidification Control Type"]

    @dehumidification_control_type.setter
    def dehumidification_control_type(self, value="None"):
        """  Corresponds to IDD field `Dehumidification Control Type`
        None = meet sensible cooling load only
        CoolReheatHeatingCoil = cool beyond the dry-bulb setpoint
        as required to meet the humidity setpoint, reheat with main heating coil.
        CoolReheatDesuperheater = cool beyond the dry-bulb setpoint
        as required to meet the humidity setpoint, reheat with desuperheater coil.

        Args:
            value (str): value for IDD Field `Dehumidification Control Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Dehumidification Control Type"] = value

    @property
    def dehumidification_control_zone_name(self):
        """Get dehumidification_control_zone_name.

        Returns:
            str: the value of `dehumidification_control_zone_name` or None if not set

        """
        return self["Dehumidification Control Zone Name"]

    @dehumidification_control_zone_name.setter
    def dehumidification_control_zone_name(self, value=None):
        """Corresponds to IDD field `Dehumidification Control Zone Name`

        This field is not currently used - the thermostat control zone is also the dehumidification control zone

        Args:
            value (str): value for IDD Field `Dehumidification Control Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Dehumidification Control Zone Name"] = value

    @property
    def dehumidification_setpoint(self):
        """Get dehumidification_setpoint.

        Returns:
            float: the value of `dehumidification_setpoint` or None if not set

        """
        return self["Dehumidification Setpoint"]

    @dehumidification_setpoint.setter
    def dehumidification_setpoint(self, value=60.0):
        """Corresponds to IDD field `Dehumidification Setpoint` Zone relative
        humidity setpoint in percent (0 to 100)

        Args:
            value (float): value for IDD Field `Dehumidification Setpoint`
                Units: percent
                Default value: 60.0
                value <= 100.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Dehumidification Setpoint"] = value

    @property
    def humidifier_type(self):
        """Get humidifier_type.

        Returns:
            str: the value of `humidifier_type` or None if not set

        """
        return self["Humidifier Type"]

    @humidifier_type.setter
    def humidifier_type(self, value="None"):
        """Corresponds to IDD field `Humidifier Type`

        Args:
            value (str): value for IDD Field `Humidifier Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Humidifier Type"] = value

    @property
    def humidifier_availability_schedule_name(self):
        """Get humidifier_availability_schedule_name.

        Returns:
            str: the value of `humidifier_availability_schedule_name` or None if not set

        """
        return self["Humidifier Availability Schedule Name"]

    @humidifier_availability_schedule_name.setter
    def humidifier_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Humidifier Availability Schedule Name` If
        blank, always available.

        Args:
            value (str): value for IDD Field `Humidifier Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Humidifier Availability Schedule Name"] = value

    @property
    def humidifier_rated_capacity(self):
        """Get humidifier_rated_capacity.

        Returns:
            float: the value of `humidifier_rated_capacity` or None if not set

        """
        return self["Humidifier Rated Capacity"]

    @humidifier_rated_capacity.setter
    def humidifier_rated_capacity(self, value=1e-06):
        """Corresponds to IDD field `Humidifier Rated Capacity` Moisture output
        rate at full rated power input. The humidifier does not currently
        autosize, so the default is very large to allow for adequate capacity.

        Args:
            value (float): value for IDD Field `Humidifier Rated Capacity`
                Units: m3/s
                IP-Units: gal/min
                Default value: 1e-06
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Humidifier Rated Capacity"] = value

    @property
    def humidifier_rated_electric_power(self):
        """Get humidifier_rated_electric_power.

        Returns:
            float: the value of `humidifier_rated_electric_power` or None if not set

        """
        return self["Humidifier Rated Electric Power"]

    @humidifier_rated_electric_power.setter
    def humidifier_rated_electric_power(self, value="autosize"):
        """  Corresponds to IDD field `Humidifier Rated Electric Power`
        Electric power input at rated capacity moisture output.
        Power consumption is proportional to moisture output with no part-load penalty.

        Args:
            value (float or "Autosize"): value for IDD Field `Humidifier Rated Electric Power`
                Units: W
                IP-Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Humidifier Rated Electric Power"] = value

    @property
    def humidifier_control_zone_name(self):
        """Get humidifier_control_zone_name.

        Returns:
            str: the value of `humidifier_control_zone_name` or None if not set

        """
        return self["Humidifier Control Zone Name"]

    @humidifier_control_zone_name.setter
    def humidifier_control_zone_name(self, value=None):
        """Corresponds to IDD field `Humidifier Control Zone Name` Zone name
        where humidistat is located.

        Args:
            value (str): value for IDD Field `Humidifier Control Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Humidifier Control Zone Name"] = value

    @property
    def humidifier_setpoint(self):
        """Get humidifier_setpoint.

        Returns:
            float: the value of `humidifier_setpoint` or None if not set

        """
        return self["Humidifier Setpoint"]

    @humidifier_setpoint.setter
    def humidifier_setpoint(self, value=30.0):
        """Corresponds to IDD field `Humidifier Setpoint` Zone relative
        humidity setpoint in percent (0 to 100)

        Args:
            value (float): value for IDD Field `Humidifier Setpoint`
                Units: percent
                Default value: 30.0
                value <= 100.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Humidifier Setpoint"] = value

    @property
    def return_fan(self):
        """Get return_fan.

        Returns:
            str: the value of `return_fan` or None if not set

        """
        return self["Return Fan"]

    @return_fan.setter
    def return_fan(self, value="No"):
        """Corresponds to IDD field `Return Fan` Specifies if the system has a
        return fan.

        Args:
            value (str): value for IDD Field `Return Fan`
                Default value: No
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Fan"] = value

    @property
    def return_fan_total_efficiency(self):
        """Get return_fan_total_efficiency.

        Returns:
            float: the value of `return_fan_total_efficiency` or None if not set

        """
        return self["Return Fan Total Efficiency"]

    @return_fan_total_efficiency.setter
    def return_fan_total_efficiency(self, value=0.7):
        """Corresponds to IDD field `Return Fan Total Efficiency`

        Args:
            value (float): value for IDD Field `Return Fan Total Efficiency`
                Default value: 0.7
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Fan Total Efficiency"] = value

    @property
    def return_fan_delta_pressure(self):
        """Get return_fan_delta_pressure.

        Returns:
            float: the value of `return_fan_delta_pressure` or None if not set

        """
        return self["Return Fan Delta Pressure"]

    @return_fan_delta_pressure.setter
    def return_fan_delta_pressure(self, value=500.0):
        """Corresponds to IDD field `Return Fan Delta Pressure`

        Args:
            value (float): value for IDD Field `Return Fan Delta Pressure`
                Units: Pa
                IP-Units: inH2O
                Default value: 500.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Fan Delta Pressure"] = value

    @property
    def return_fan_motor_efficiency(self):
        """Get return_fan_motor_efficiency.

        Returns:
            float: the value of `return_fan_motor_efficiency` or None if not set

        """
        return self["Return Fan Motor Efficiency"]

    @return_fan_motor_efficiency.setter
    def return_fan_motor_efficiency(self, value=0.9):
        """Corresponds to IDD field `Return Fan Motor Efficiency`

        Args:
            value (float): value for IDD Field `Return Fan Motor Efficiency`
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Fan Motor Efficiency"] = value

    @property
    def return_fan_motor_in_air_stream_fraction(self):
        """Get return_fan_motor_in_air_stream_fraction.

        Returns:
            float: the value of `return_fan_motor_in_air_stream_fraction` or None if not set

        """
        return self["Return Fan Motor in Air Stream Fraction"]

    @return_fan_motor_in_air_stream_fraction.setter
    def return_fan_motor_in_air_stream_fraction(self, value=1.0):
        """Corresponds to IDD field `Return Fan Motor in Air Stream Fraction`

        Args:
            value (float): value for IDD Field `Return Fan Motor in Air Stream Fraction`
                Default value: 1.0
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Fan Motor in Air Stream Fraction"] = value




class HvactemplateSystemUnitaryHeatPumpAirToAir(DataObject):

    """ Corresponds to IDD object `HVACTemplate:System:UnitaryHeatPump:AirToAir`
        Unitary furnace with electric air-to-air heat pump
    """
    schema = {'min-fields': 61,
              'name': u'HVACTemplate:System:UnitaryHeatPump:AirToAir',
              'pyname': u'HvactemplateSystemUnitaryHeatPumpAirToAir',
              'format': None,
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'system availability schedule name',
                                      {'name': u'System Availability Schedule Name',
                                       'pyname': u'system_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'control zone or thermostat location name',
                                      {'name': u'Control Zone or Thermostat Location Name',
                                       'pyname': u'control_zone_or_thermostat_location_name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'cooling supply air flow rate',
                                      {'name': u'Cooling Supply Air Flow Rate',
                                       'pyname': u'cooling_supply_air_flow_rate',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'heating supply air flow rate',
                                      {'name': u'Heating Supply Air Flow Rate',
                                       'pyname': u'heating_supply_air_flow_rate',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'no load supply air flow rate',
                                      {'name': u'No Load Supply Air Flow Rate',
                                       'pyname': u'no_load_supply_air_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'supply fan operating mode schedule name',
                                      {'name': u'Supply Fan Operating Mode Schedule Name',
                                       'pyname': u'supply_fan_operating_mode_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply fan placement',
                                      {'name': u'Supply Fan Placement',
                                       'pyname': u'supply_fan_placement',
                                       'default': u'BlowThrough',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'BlowThrough',
                                                           u'DrawThrough'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'supply fan total efficiency',
                                      {'name': u'Supply Fan Total Efficiency',
                                       'pyname': u'supply_fan_total_efficiency',
                                       'default': 0.7,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supply fan delta pressure',
                                      {'name': u'Supply Fan Delta Pressure',
                                       'pyname': u'supply_fan_delta_pressure',
                                       'default': 600.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'Pa'}),
                                     (u'supply fan motor efficiency',
                                      {'name': u'Supply Fan Motor Efficiency',
                                       'pyname': u'supply_fan_motor_efficiency',
                                       'default': 0.9,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supply fan motor in air stream fraction',
                                      {'name': u'Supply Fan Motor in Air Stream Fraction',
                                       'pyname': u'supply_fan_motor_in_air_stream_fraction',
                                       'default': 1.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'cooling coil type',
                                      {'name': u'Cooling Coil Type',
                                       'pyname': u'cooling_coil_type',
                                       'default': u'SingleSpeedDX',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SingleSpeedDX'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'cooling coil availability schedule name',
                                      {'name': u'Cooling Coil Availability Schedule Name',
                                       'pyname': u'cooling_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'cooling design supply air temperature',
                                      {'name': u'Cooling Design Supply Air Temperature',
                                       'pyname': u'cooling_design_supply_air_temperature',
                                       'default': 12.8,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'cooling coil gross rated total capacity',
                                      {'name': u'Cooling Coil Gross Rated Total Capacity',
                                       'pyname': u'cooling_coil_gross_rated_total_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'cooling coil gross rated sensible heat ratio',
                                      {'name': u'Cooling Coil Gross Rated Sensible Heat Ratio',
                                       'pyname': u'cooling_coil_gross_rated_sensible_heat_ratio',
                                       'default': 'autosize',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.5,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'cooling coil gross rated cop',
                                      {'name': u'Cooling Coil Gross Rated COP',
                                       'pyname': u'cooling_coil_gross_rated_cop',
                                       'default': 3.0,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W/W'}),
                                     (u'heat pump heating coil type',
                                      {'name': u'Heat Pump Heating Coil Type',
                                       'pyname': u'heat_pump_heating_coil_type',
                                       'default': u'SingleSpeedDXHeatPump',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SingleSpeedDXHeatPump'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heat pump heating coil availability schedule name',
                                      {'name': u'Heat Pump Heating Coil Availability Schedule Name',
                                       'pyname': u'heat_pump_heating_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'heating design supply air temperature',
                                      {'name': u'Heating Design Supply Air Temperature',
                                       'pyname': u'heating_design_supply_air_temperature',
                                       'default': 50.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'heat pump heating coil gross rated capacity',
                                      {'name': u'Heat Pump Heating Coil Gross Rated Capacity',
                                       'pyname': u'heat_pump_heating_coil_gross_rated_capacity',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'heat pump heating coil rated cop',
                                      {'name': u'Heat Pump Heating Coil Rated COP',
                                       'pyname': u'heat_pump_heating_coil_rated_cop',
                                       'default': 2.75,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W/W'}),
                                     (u'heat pump heating minimum outdoor dry-bulb temperature',
                                      {'name': u'Heat Pump Heating Minimum Outdoor Dry-Bulb Temperature',
                                       'pyname': u'heat_pump_heating_minimum_outdoor_drybulb_temperature',
                                       'default': -8.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': -20.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'heat pump defrost maximum outdoor dry-bulb temperature',
                                      {'name': u'Heat Pump Defrost Maximum Outdoor Dry-Bulb Temperature',
                                       'pyname': u'heat_pump_defrost_maximum_outdoor_drybulb_temperature',
                                       'default': 5.0,
                                       'maximum': 7.22,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'heat pump defrost strategy',
                                      {'name': u'Heat Pump Defrost Strategy',
                                       'pyname': u'heat_pump_defrost_strategy',
                                       'default': u'ReverseCycle',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'ReverseCycle',
                                                           u'Resistive'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heat pump defrost control',
                                      {'name': u'Heat Pump Defrost Control',
                                       'pyname': u'heat_pump_defrost_control',
                                       'default': u'Timed',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Timed',
                                                           u'OnDemand'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heat pump defrost time period fraction',
                                      {'name': u'Heat Pump Defrost Time Period Fraction',
                                       'pyname': u'heat_pump_defrost_time_period_fraction',
                                       'default': 0.058333,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'supplemental heating coil type',
                                      {'name': u'Supplemental Heating Coil Type',
                                       'pyname': u'supplemental_heating_coil_type',
                                       'default': u'Electric',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Electric',
                                                           u'Gas',
                                                           u'HotWater'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'supplemental heating coil availability schedule name',
                                      {'name': u'Supplemental Heating Coil Availability Schedule Name',
                                       'pyname': u'supplemental_heating_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supplemental heating coil capacity',
                                      {'name': u'Supplemental Heating Coil Capacity',
                                       'pyname': u'supplemental_heating_coil_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'supplemental heating coil maximum outdoor dry-bulb temperature',
                                      {'name': u'Supplemental Heating Coil Maximum Outdoor Dry-Bulb Temperature',
                                       'pyname': u'supplemental_heating_coil_maximum_outdoor_drybulb_temperature',
                                       'default': 21.0,
                                       'maximum': 21.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'supplemental gas heating coil efficiency',
                                      {'name': u'Supplemental Gas Heating Coil Efficiency',
                                       'pyname': u'supplemental_gas_heating_coil_efficiency',
                                       'default': 0.8,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supplemental gas heating coil parasitic electric load',
                                      {'name': u'Supplemental Gas Heating Coil Parasitic Electric Load',
                                       'pyname': u'supplemental_gas_heating_coil_parasitic_electric_load',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'maximum outdoor air flow rate',
                                      {'name': u'Maximum Outdoor Air Flow Rate',
                                       'pyname': u'maximum_outdoor_air_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'minimum outdoor air flow rate',
                                      {'name': u'Minimum Outdoor Air Flow Rate',
                                       'pyname': u'minimum_outdoor_air_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'minimum outdoor air schedule name',
                                      {'name': u'Minimum Outdoor Air Schedule Name',
                                       'pyname': u'minimum_outdoor_air_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'economizer type',
                                      {'name': u'Economizer Type',
                                       'pyname': u'economizer_type',
                                       'default': u'NoEconomizer',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'FixedDryBulb',
                                                           u'FixedEnthalpy',
                                                           u'DifferentialDryBulb',
                                                           u'DifferentialEnthalpy',
                                                           u'FixedDewPointAndDryBulb',
                                                           u'ElectronicEnthalpy',
                                                           u'DifferentialDryBulbAndEnthalpy',
                                                           u'NoEconomizer'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'economizer lockout',
                                      {'name': u'Economizer Lockout',
                                       'pyname': u'economizer_lockout',
                                       'default': u'NoLockout',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'NoLockout',
                                                           u'LockoutWithHeating',
                                                           u'LockoutWithCompressor'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'economizer maximum limit dry-bulb temperature',
                                      {'name': u'Economizer Maximum Limit Dry-Bulb Temperature',
                                       'pyname': u'economizer_maximum_limit_drybulb_temperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'economizer maximum limit enthalpy',
                                      {'name': u'Economizer Maximum Limit Enthalpy',
                                       'pyname': u'economizer_maximum_limit_enthalpy',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'J/kg'}),
                                     (u'economizer maximum limit dewpoint temperature',
                                      {'name': u'Economizer Maximum Limit Dewpoint Temperature',
                                       'pyname': u'economizer_maximum_limit_dewpoint_temperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'economizer minimum limit dry-bulb temperature',
                                      {'name': u'Economizer Minimum Limit Dry-Bulb Temperature',
                                       'pyname': u'economizer_minimum_limit_drybulb_temperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'supply plenum name',
                                      {'name': u'Supply Plenum Name',
                                       'pyname': u'supply_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'return plenum name',
                                      {'name': u'Return Plenum Name',
                                       'pyname': u'return_plenum_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'night cycle control',
                                      {'name': u'Night Cycle Control',
                                       'pyname': u'night_cycle_control',
                                       'default': u'StayOff',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'StayOff',
                                                           u'CycleOnAny',
                                                           u'CycleOnControlZone'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'night cycle control zone name',
                                      {'name': u'Night Cycle Control Zone Name',
                                       'pyname': u'night_cycle_control_zone_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'heat recovery type',
                                      {'name': u'Heat Recovery Type',
                                       'pyname': u'heat_recovery_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'None',
                                                           u'Sensible',
                                                           u'Enthalpy'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'sensible heat recovery effectiveness',
                                      {'name': u'Sensible Heat Recovery Effectiveness',
                                       'pyname': u'sensible_heat_recovery_effectiveness',
                                       'default': 0.7,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'latent heat recovery effectiveness',
                                      {'name': u'Latent Heat Recovery Effectiveness',
                                       'pyname': u'latent_heat_recovery_effectiveness',
                                       'default': 0.65,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'humidifier type',
                                      {'name': u'Humidifier Type',
                                       'pyname': u'humidifier_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'None',
                                                           u'ElectricSteam'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'humidifier availability schedule name',
                                      {'name': u'Humidifier Availability Schedule Name',
                                       'pyname': u'humidifier_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'humidifier rated capacity',
                                      {'name': u'Humidifier Rated Capacity',
                                       'pyname': u'humidifier_rated_capacity',
                                       'default': 1e-06,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'humidifier rated electric power',
                                      {'name': u'Humidifier Rated Electric Power',
                                       'pyname': u'humidifier_rated_electric_power',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'humidifier control zone name',
                                      {'name': u'Humidifier Control Zone Name',
                                       'pyname': u'humidifier_control_zone_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'humidifier setpoint',
                                      {'name': u'Humidifier Setpoint',
                                       'pyname': u'humidifier_setpoint',
                                       'default': 30.0,
                                       'maximum': 100.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'percent'}),
                                     (u'return fan',
                                      {'name': u'Return Fan',
                                       'pyname': u'return_fan',
                                       'default': u'No',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Yes',
                                                           u'No'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'return fan total efficiency',
                                      {'name': u'Return Fan Total Efficiency',
                                       'pyname': u'return_fan_total_efficiency',
                                       'default': 0.7,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'return fan delta pressure',
                                      {'name': u'Return Fan Delta Pressure',
                                       'pyname': u'return_fan_delta_pressure',
                                       'default': 500.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'Pa'}),
                                     (u'return fan motor efficiency',
                                      {'name': u'Return Fan Motor Efficiency',
                                       'pyname': u'return_fan_motor_efficiency',
                                       'default': 0.9,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'return fan motor in air stream fraction',
                                      {'name': u'Return Fan Motor in Air Stream Fraction',
                                       'pyname': u'return_fan_motor_in_air_stream_fraction',
                                       'default': 1.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'})]),
              'extensible-fields': OrderedDict(),
              'unique-object': False,
              'required-object': False,
              'group': u'HVAC Templates'}

    @property
    def name(self):
        """Get name.

        Returns:
            str: the value of `name` or None if not set

        """
        return self["Name"]

    @name.setter
    def name(self, value=None):
        """Corresponds to IDD field `Name`

        Args:
            value (str): value for IDD Field `Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Name"] = value

    @property
    def system_availability_schedule_name(self):
        """Get system_availability_schedule_name.

        Returns:
            str: the value of `system_availability_schedule_name` or None if not set

        """
        return self["System Availability Schedule Name"]

    @system_availability_schedule_name.setter
    def system_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `System Availability Schedule Name` If
        blank, always on; Unitary System always on.  Schedule is used in
        availability manager and fan scheduling. Also see "Night Cycle Control"
        field.

        Args:
            value (str): value for IDD Field `System Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["System Availability Schedule Name"] = value

    @property
    def control_zone_or_thermostat_location_name(self):
        """Get control_zone_or_thermostat_location_name.

        Returns:
            str: the value of `control_zone_or_thermostat_location_name` or None if not set

        """
        return self["Control Zone or Thermostat Location Name"]

    @control_zone_or_thermostat_location_name.setter
    def control_zone_or_thermostat_location_name(self, value=None):
        """Corresponds to IDD field `Control Zone or Thermostat Location Name`

        Args:
            value (str): value for IDD Field `Control Zone or Thermostat Location Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Control Zone or Thermostat Location Name"] = value

    @property
    def cooling_supply_air_flow_rate(self):
        """Get cooling_supply_air_flow_rate.

        Returns:
            float: the value of `cooling_supply_air_flow_rate` or None if not set

        """
        return self["Cooling Supply Air Flow Rate"]

    @cooling_supply_air_flow_rate.setter
    def cooling_supply_air_flow_rate(self, value="autosize"):
        """  Corresponds to IDD field `Cooling Supply Air Flow Rate`
        Supply air flow rate during cooling operation
        This field may be set to "autosize".  If a value is entered, it will *not* be
        multiplied by any sizing factor or by zone multipliers.  If using zone multipliers
        a value entered here must be large enough to serve the multiplied zones.

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Supply Air Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Cooling Supply Air Flow Rate"] = value

    @property
    def heating_supply_air_flow_rate(self):
        """Get heating_supply_air_flow_rate.

        Returns:
            float: the value of `heating_supply_air_flow_rate` or None if not set

        """
        return self["Heating Supply Air Flow Rate"]

    @heating_supply_air_flow_rate.setter
    def heating_supply_air_flow_rate(self, value="autosize"):
        """  Corresponds to IDD field `Heating Supply Air Flow Rate`
        Supply air flow rate during heating operation
        This field may be set to "autosize".  If a value is entered, it will *not* be
        multiplied by any sizing factor or by zone multipliers.  If using zone multipliers
        a value entered here must be large enough to serve the multiplied zones.

        Args:
            value (float or "Autosize"): value for IDD Field `Heating Supply Air Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Heating Supply Air Flow Rate"] = value

    @property
    def no_load_supply_air_flow_rate(self):
        """Get no_load_supply_air_flow_rate.

        Returns:
            float: the value of `no_load_supply_air_flow_rate` or None if not set

        """
        return self["No Load Supply Air Flow Rate"]

    @no_load_supply_air_flow_rate.setter
    def no_load_supply_air_flow_rate(self, value="autosize"):
        """  Corresponds to IDD field `No Load Supply Air Flow Rate`
        Supply air flow rate when no cooling or heating is needed
        Only used when heat pump fan operating mode is Continuous. This air flow rate
        is used when no heating or cooling is required and the DX coil compressor is off.
        If this field is left blank or zero, the supply air flow rate from the previous on cycle
        (either cooling or heating) is used.
        This field may be set to "autosize".  If a value is entered, it will *not* be
        multiplied by any sizing factor or by zone multipliers.  If using zone multipliers
        a value entered here must be large enough to serve the multiplied zones.

        Args:
            value (float or "Autosize"): value for IDD Field `No Load Supply Air Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["No Load Supply Air Flow Rate"] = value

    @property
    def supply_fan_operating_mode_schedule_name(self):
        """Get supply_fan_operating_mode_schedule_name.

        Returns:
            str: the value of `supply_fan_operating_mode_schedule_name` or None if not set

        """
        return self["Supply Fan Operating Mode Schedule Name"]

    @supply_fan_operating_mode_schedule_name.setter
    def supply_fan_operating_mode_schedule_name(self, value=None):
        """Corresponds to IDD field `Supply Fan Operating Mode Schedule Name`
        Refers to a schedule to specify unitary supply fan operating mode.
        Schedule values of 0 indicate cycling fan (auto) Schedule values of 1
        indicate continuous fan (on) If this field is left blank, a schedule of
        always zero (cycling fan) will be used.

        Args:
            value (str): value for IDD Field `Supply Fan Operating Mode Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Operating Mode Schedule Name"] = value

    @property
    def supply_fan_placement(self):
        """Get supply_fan_placement.

        Returns:
            str: the value of `supply_fan_placement` or None if not set

        """
        return self["Supply Fan Placement"]

    @supply_fan_placement.setter
    def supply_fan_placement(self, value="BlowThrough"):
        """Corresponds to IDD field `Supply Fan Placement`

        Args:
            value (str): value for IDD Field `Supply Fan Placement`
                Default value: BlowThrough
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Placement"] = value

    @property
    def supply_fan_total_efficiency(self):
        """Get supply_fan_total_efficiency.

        Returns:
            float: the value of `supply_fan_total_efficiency` or None if not set

        """
        return self["Supply Fan Total Efficiency"]

    @supply_fan_total_efficiency.setter
    def supply_fan_total_efficiency(self, value=0.7):
        """Corresponds to IDD field `Supply Fan Total Efficiency`

        Args:
            value (float): value for IDD Field `Supply Fan Total Efficiency`
                Default value: 0.7
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Total Efficiency"] = value

    @property
    def supply_fan_delta_pressure(self):
        """Get supply_fan_delta_pressure.

        Returns:
            float: the value of `supply_fan_delta_pressure` or None if not set

        """
        return self["Supply Fan Delta Pressure"]

    @supply_fan_delta_pressure.setter
    def supply_fan_delta_pressure(self, value=600.0):
        """Corresponds to IDD field `Supply Fan Delta Pressure`

        Args:
            value (float): value for IDD Field `Supply Fan Delta Pressure`
                Units: Pa
                IP-Units: inH2O
                Default value: 600.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Delta Pressure"] = value

    @property
    def supply_fan_motor_efficiency(self):
        """Get supply_fan_motor_efficiency.

        Returns:
            float: the value of `supply_fan_motor_efficiency` or None if not set

        """
        return self["Supply Fan Motor Efficiency"]

    @supply_fan_motor_efficiency.setter
    def supply_fan_motor_efficiency(self, value=0.9):
        """Corresponds to IDD field `Supply Fan Motor Efficiency`

        Args:
            value (float): value for IDD Field `Supply Fan Motor Efficiency`
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Motor Efficiency"] = value

    @property
    def supply_fan_motor_in_air_stream_fraction(self):
        """Get supply_fan_motor_in_air_stream_fraction.

        Returns:
            float: the value of `supply_fan_motor_in_air_stream_fraction` or None if not set

        """
        return self["Supply Fan Motor in Air Stream Fraction"]

    @supply_fan_motor_in_air_stream_fraction.setter
    def supply_fan_motor_in_air_stream_fraction(self, value=1.0):
        """Corresponds to IDD field `Supply Fan Motor in Air Stream Fraction`

        Args:
            value (float): value for IDD Field `Supply Fan Motor in Air Stream Fraction`
                Default value: 1.0
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Fan Motor in Air Stream Fraction"] = value

    @property
    def cooling_coil_type(self):
        """Get cooling_coil_type.

        Returns:
            str: the value of `cooling_coil_type` or None if not set

        """
        return self["Cooling Coil Type"]

    @cooling_coil_type.setter
    def cooling_coil_type(self, value="SingleSpeedDX"):
        """Corresponds to IDD field `Cooling Coil Type`

        Args:
            value (str): value for IDD Field `Cooling Coil Type`
                Default value: SingleSpeedDX
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Type"] = value

    @property
    def cooling_coil_availability_schedule_name(self):
        """Get cooling_coil_availability_schedule_name.

        Returns:
            str: the value of `cooling_coil_availability_schedule_name` or None if not set

        """
        return self["Cooling Coil Availability Schedule Name"]

    @cooling_coil_availability_schedule_name.setter
    def cooling_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Cooling Coil Availability Schedule Name`
        If blank, always on.

        Args:
            value (str): value for IDD Field `Cooling Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Availability Schedule Name"] = value

    @property
    def cooling_design_supply_air_temperature(self):
        """Get cooling_design_supply_air_temperature.

        Returns:
            float: the value of `cooling_design_supply_air_temperature` or None if not set

        """
        return self["Cooling Design Supply Air Temperature"]

    @cooling_design_supply_air_temperature.setter
    def cooling_design_supply_air_temperature(self, value=12.8):
        """Corresponds to IDD field `Cooling Design Supply Air Temperature`
        Used for sizing.

        Args:
            value (float): value for IDD Field `Cooling Design Supply Air Temperature`
                Units: C
                Default value: 12.8
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Design Supply Air Temperature"] = value

    @property
    def cooling_coil_gross_rated_total_capacity(self):
        """Get cooling_coil_gross_rated_total_capacity.

        Returns:
            float: the value of `cooling_coil_gross_rated_total_capacity` or None if not set

        """
        return self["Cooling Coil Gross Rated Total Capacity"]

    @cooling_coil_gross_rated_total_capacity.setter
    def cooling_coil_gross_rated_total_capacity(self, value="autosize"):
        """  Corresponds to IDD field `Cooling Coil Gross Rated Total Capacity`
        Total cooling capacity not accounting for the effect of supply air fan heat
        Rating point: air entering the cooling coil at 26.7 C dry-bulb/19.4 C wet-bulb, and
        air entering the outdoor condenser coil at 35 C dry-bulb/23.9 C wet-bulb

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Coil Gross Rated Total Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Cooling Coil Gross Rated Total Capacity"] = value

    @property
    def cooling_coil_gross_rated_sensible_heat_ratio(self):
        """Get cooling_coil_gross_rated_sensible_heat_ratio.

        Returns:
            float: the value of `cooling_coil_gross_rated_sensible_heat_ratio` or None if not set

        """
        return self["Cooling Coil Gross Rated Sensible Heat Ratio"]

    @cooling_coil_gross_rated_sensible_heat_ratio.setter
    def cooling_coil_gross_rated_sensible_heat_ratio(self, value="autosize"):
        """Corresponds to IDD field `Cooling Coil Gross Rated Sensible Heat
        Ratio` Rated sensible heat ratio (gross sensible capacity/gross total
        capacity) Sensible and total capacities do not include effect of supply
        fan heat.

        Args:
            value (float or "Autosize"): value for IDD Field `Cooling Coil Gross Rated Sensible Heat Ratio`
                Default value: "autosize"
                value >= 0.5
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Gross Rated Sensible Heat Ratio"] = value

    @property
    def cooling_coil_gross_rated_cop(self):
        """Get cooling_coil_gross_rated_cop.

        Returns:
            float: the value of `cooling_coil_gross_rated_cop` or None if not set

        """
        return self["Cooling Coil Gross Rated COP"]

    @cooling_coil_gross_rated_cop.setter
    def cooling_coil_gross_rated_cop(self, value=3.0):
        """Corresponds to IDD field `Cooling Coil Gross Rated COP` Gross
        cooling capacity divided by power input to the compressor and outdoor
        fan, does not include supply fan heat or supply fan electric power
        input.

        Args:
            value (float): value for IDD Field `Cooling Coil Gross Rated COP`
                Units: W/W
                Default value: 3.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Cooling Coil Gross Rated COP"] = value

    @property
    def heat_pump_heating_coil_type(self):
        """Get heat_pump_heating_coil_type.

        Returns:
            str: the value of `heat_pump_heating_coil_type` or None if not set

        """
        return self["Heat Pump Heating Coil Type"]

    @heat_pump_heating_coil_type.setter
    def heat_pump_heating_coil_type(self, value="SingleSpeedDXHeatPump"):
        """Corresponds to IDD field `Heat Pump Heating Coil Type`

        Args:
            value (str): value for IDD Field `Heat Pump Heating Coil Type`
                Default value: SingleSpeedDXHeatPump
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Heating Coil Type"] = value

    @property
    def heat_pump_heating_coil_availability_schedule_name(self):
        """Get heat_pump_heating_coil_availability_schedule_name.

        Returns:
            str: the value of `heat_pump_heating_coil_availability_schedule_name` or None if not set

        """
        return self["Heat Pump Heating Coil Availability Schedule Name"]

    @heat_pump_heating_coil_availability_schedule_name.setter
    def heat_pump_heating_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Heat Pump Heating Coil Availability
        Schedule Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Heat Pump Heating Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Heating Coil Availability Schedule Name"] = value

    @property
    def heating_design_supply_air_temperature(self):
        """Get heating_design_supply_air_temperature.

        Returns:
            float: the value of `heating_design_supply_air_temperature` or None if not set

        """
        return self["Heating Design Supply Air Temperature"]

    @heating_design_supply_air_temperature.setter
    def heating_design_supply_air_temperature(self, value=50.0):
        """Corresponds to IDD field `Heating Design Supply Air Temperature`
        Used for sizing.

        Args:
            value (float): value for IDD Field `Heating Design Supply Air Temperature`
                Units: C
                Default value: 50.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heating Design Supply Air Temperature"] = value

    @property
    def heat_pump_heating_coil_gross_rated_capacity(self):
        """Get heat_pump_heating_coil_gross_rated_capacity.

        Returns:
            float: the value of `heat_pump_heating_coil_gross_rated_capacity` or None if not set

        """
        return self["Heat Pump Heating Coil Gross Rated Capacity"]

    @heat_pump_heating_coil_gross_rated_capacity.setter
    def heat_pump_heating_coil_gross_rated_capacity(self, value="autosize"):
        """  Corresponds to IDD field `Heat Pump Heating Coil Gross Rated Capacity`
        Rated heating capacity excluding the effect of supply air fan heat
        Rating point outdoor dry-bulb temp 8.33 C, outdoor wet-bulb temp 6.11 C
        Rating point heating coil entering air dry-bulb 21.11 C, coil entering wet-bulb 15.55 C

        Args:
            value (float or "Autosize"): value for IDD Field `Heat Pump Heating Coil Gross Rated Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Heat Pump Heating Coil Gross Rated Capacity"] = value

    @property
    def heat_pump_heating_coil_rated_cop(self):
        """Get heat_pump_heating_coil_rated_cop.

        Returns:
            float: the value of `heat_pump_heating_coil_rated_cop` or None if not set

        """
        return self["Heat Pump Heating Coil Rated COP"]

    @heat_pump_heating_coil_rated_cop.setter
    def heat_pump_heating_coil_rated_cop(self, value=2.75):
        """  Corresponds to IDD field `Heat Pump Heating Coil Rated COP`
        Heat Pump Heating Coil Rated Capacity divided by power input to the compressor and outdoor fan,
        does not include supply air fan heat or supply air fan electrical energy.
        Rating point outdoor dry-bulb temp 8.33 C, outdoor wet-bulb temp 6.11 C
        Rating point heating coil entering air dry-bulb 21.11 C, coil entering wet-bulb 15.55 C

        Args:
            value (float): value for IDD Field `Heat Pump Heating Coil Rated COP`
                Units: W/W
                Default value: 2.75
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Heat Pump Heating Coil Rated COP"] = value

    @property
    def heat_pump_heating_minimum_outdoor_drybulb_temperature(self):
        """Get heat_pump_heating_minimum_outdoor_drybulb_temperature.

        Returns:
            float: the value of `heat_pump_heating_minimum_outdoor_drybulb_temperature` or None if not set

        """
        return self["Heat Pump Heating Minimum Outdoor Dry-Bulb Temperature"]

    @heat_pump_heating_minimum_outdoor_drybulb_temperature.setter
    def heat_pump_heating_minimum_outdoor_drybulb_temperature(
            self,
            value=-
            8.0):
        """  Corresponds to IDD field `Heat Pump Heating Minimum Outdoor Dry-Bulb Temperature`

        Args:
            value (float): value for IDD Field `Heat Pump Heating Minimum Outdoor Dry-Bulb Temperature`
                Units: C
                Default value: -8.0
                value >= -20.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Heat Pump Heating Minimum Outdoor Dry-Bulb Temperature"] = value

    @property
    def heat_pump_defrost_maximum_outdoor_drybulb_temperature(self):
        """Get heat_pump_defrost_maximum_outdoor_drybulb_temperature.

        Returns:
            float: the value of `heat_pump_defrost_maximum_outdoor_drybulb_temperature` or None if not set

        """
        return self["Heat Pump Defrost Maximum Outdoor Dry-Bulb Temperature"]

    @heat_pump_defrost_maximum_outdoor_drybulb_temperature.setter
    def heat_pump_defrost_maximum_outdoor_drybulb_temperature(self, value=5.0):
        """  Corresponds to IDD field `Heat Pump Defrost Maximum Outdoor Dry-Bulb Temperature`

        Args:
            value (float): value for IDD Field `Heat Pump Defrost Maximum Outdoor Dry-Bulb Temperature`
                Units: C
                Default value: 5.0
                value <= 7.22
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Heat Pump Defrost Maximum Outdoor Dry-Bulb Temperature"] = value

    @property
    def heat_pump_defrost_strategy(self):
        """Get heat_pump_defrost_strategy.

        Returns:
            str: the value of `heat_pump_defrost_strategy` or None if not set

        """
        return self["Heat Pump Defrost Strategy"]

    @heat_pump_defrost_strategy.setter
    def heat_pump_defrost_strategy(self, value="ReverseCycle"):
        """Corresponds to IDD field `Heat Pump Defrost Strategy`

        Args:
            value (str): value for IDD Field `Heat Pump Defrost Strategy`
                Default value: ReverseCycle
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Defrost Strategy"] = value

    @property
    def heat_pump_defrost_control(self):
        """Get heat_pump_defrost_control.

        Returns:
            str: the value of `heat_pump_defrost_control` or None if not set

        """
        return self["Heat Pump Defrost Control"]

    @heat_pump_defrost_control.setter
    def heat_pump_defrost_control(self, value="Timed"):
        """Corresponds to IDD field `Heat Pump Defrost Control`

        Args:
            value (str): value for IDD Field `Heat Pump Defrost Control`
                Default value: Timed
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Defrost Control"] = value

    @property
    def heat_pump_defrost_time_period_fraction(self):
        """Get heat_pump_defrost_time_period_fraction.

        Returns:
            float: the value of `heat_pump_defrost_time_period_fraction` or None if not set

        """
        return self["Heat Pump Defrost Time Period Fraction"]

    @heat_pump_defrost_time_period_fraction.setter
    def heat_pump_defrost_time_period_fraction(self, value=0.058333):
        """Corresponds to IDD field `Heat Pump Defrost Time Period Fraction`
        Fraction of time in defrost mode only applicable if Timed defrost
        control is specified.

        Args:
            value (float): value for IDD Field `Heat Pump Defrost Time Period Fraction`
                Default value: 0.058333
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Pump Defrost Time Period Fraction"] = value

    @property
    def supplemental_heating_coil_type(self):
        """Get supplemental_heating_coil_type.

        Returns:
            str: the value of `supplemental_heating_coil_type` or None if not set

        """
        return self["Supplemental Heating Coil Type"]

    @supplemental_heating_coil_type.setter
    def supplemental_heating_coil_type(self, value="Electric"):
        """Corresponds to IDD field `Supplemental Heating Coil Type`

        Args:
            value (str): value for IDD Field `Supplemental Heating Coil Type`
                Default value: Electric
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supplemental Heating Coil Type"] = value

    @property
    def supplemental_heating_coil_availability_schedule_name(self):
        """Get supplemental_heating_coil_availability_schedule_name.

        Returns:
            str: the value of `supplemental_heating_coil_availability_schedule_name` or None if not set

        """
        return self["Supplemental Heating Coil Availability Schedule Name"]

    @supplemental_heating_coil_availability_schedule_name.setter
    def supplemental_heating_coil_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Supplemental Heating Coil Availability
        Schedule Name` If blank, always on.

        Args:
            value (str): value for IDD Field `Supplemental Heating Coil Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supplemental Heating Coil Availability Schedule Name"] = value

    @property
    def supplemental_heating_coil_capacity(self):
        """Get supplemental_heating_coil_capacity.

        Returns:
            float: the value of `supplemental_heating_coil_capacity` or None if not set

        """
        return self["Supplemental Heating Coil Capacity"]

    @supplemental_heating_coil_capacity.setter
    def supplemental_heating_coil_capacity(self, value="autosize"):
        """Corresponds to IDD field `Supplemental Heating Coil Capacity`

        Args:
            value (float or "Autosize"): value for IDD Field `Supplemental Heating Coil Capacity`
                Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supplemental Heating Coil Capacity"] = value

    @property
    def supplemental_heating_coil_maximum_outdoor_drybulb_temperature(self):
        """Get supplemental_heating_coil_maximum_outdoor_drybulb_temperature.

        Returns:
            float: the value of `supplemental_heating_coil_maximum_outdoor_drybulb_temperature` or None if not set

        """
        return self[
            "Supplemental Heating Coil Maximum Outdoor Dry-Bulb Temperature"]

    @supplemental_heating_coil_maximum_outdoor_drybulb_temperature.setter
    def supplemental_heating_coil_maximum_outdoor_drybulb_temperature(
            self,
            value=21.0):
        """  Corresponds to IDD field `Supplemental Heating Coil Maximum Outdoor Dry-Bulb Temperature`
        Supplemental heater will not operate when outdoor temperature exceeds this value.

        Args:
            value (float): value for IDD Field `Supplemental Heating Coil Maximum Outdoor Dry-Bulb Temperature`
                Units: C
                Default value: 21.0
                value <= 21.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self[
            "Supplemental Heating Coil Maximum Outdoor Dry-Bulb Temperature"] = value

    @property
    def supplemental_gas_heating_coil_efficiency(self):
        """Get supplemental_gas_heating_coil_efficiency.

        Returns:
            float: the value of `supplemental_gas_heating_coil_efficiency` or None if not set

        """
        return self["Supplemental Gas Heating Coil Efficiency"]

    @supplemental_gas_heating_coil_efficiency.setter
    def supplemental_gas_heating_coil_efficiency(self, value=0.8):
        """Corresponds to IDD field `Supplemental Gas Heating Coil Efficiency`
        Applies only if Supplemental Heating Coil Type is Gas.

        Args:
            value (float): value for IDD Field `Supplemental Gas Heating Coil Efficiency`
                Default value: 0.8
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supplemental Gas Heating Coil Efficiency"] = value

    @property
    def supplemental_gas_heating_coil_parasitic_electric_load(self):
        """Get supplemental_gas_heating_coil_parasitic_electric_load.

        Returns:
            float: the value of `supplemental_gas_heating_coil_parasitic_electric_load` or None if not set

        """
        return self["Supplemental Gas Heating Coil Parasitic Electric Load"]

    @supplemental_gas_heating_coil_parasitic_electric_load.setter
    def supplemental_gas_heating_coil_parasitic_electric_load(
            self,
            value=None):
        """Corresponds to IDD field `Supplemental Gas Heating Coil Parasitic
        Electric Load` Applies only if Supplemental Heating Coil Type is Gas.

        Args:
            value (float): value for IDD Field `Supplemental Gas Heating Coil Parasitic Electric Load`
                Units: W
                IP-Units: W
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supplemental Gas Heating Coil Parasitic Electric Load"] = value

    @property
    def maximum_outdoor_air_flow_rate(self):
        """Get maximum_outdoor_air_flow_rate.

        Returns:
            float: the value of `maximum_outdoor_air_flow_rate` or None if not set

        """
        return self["Maximum Outdoor Air Flow Rate"]

    @maximum_outdoor_air_flow_rate.setter
    def maximum_outdoor_air_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Maximum Outdoor Air Flow Rate`

        Args:
            value (float or "Autosize"): value for IDD Field `Maximum Outdoor Air Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Maximum Outdoor Air Flow Rate"] = value

    @property
    def minimum_outdoor_air_flow_rate(self):
        """Get minimum_outdoor_air_flow_rate.

        Returns:
            float: the value of `minimum_outdoor_air_flow_rate` or None if not set

        """
        return self["Minimum Outdoor Air Flow Rate"]

    @minimum_outdoor_air_flow_rate.setter
    def minimum_outdoor_air_flow_rate(self, value="autosize"):
        """Corresponds to IDD field `Minimum Outdoor Air Flow Rate`

        Args:
            value (float or "Autosize"): value for IDD Field `Minimum Outdoor Air Flow Rate`
                Units: m3/s
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Minimum Outdoor Air Flow Rate"] = value

    @property
    def minimum_outdoor_air_schedule_name(self):
        """Get minimum_outdoor_air_schedule_name.

        Returns:
            str: the value of `minimum_outdoor_air_schedule_name` or None if not set

        """
        return self["Minimum Outdoor Air Schedule Name"]

    @minimum_outdoor_air_schedule_name.setter
    def minimum_outdoor_air_schedule_name(self, value=None):
        """Corresponds to IDD field `Minimum Outdoor Air Schedule Name`
        Schedule values multiply the minimum outdoor air flow rate If blank,
        multiplier is always one.

        Args:
            value (str): value for IDD Field `Minimum Outdoor Air Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Minimum Outdoor Air Schedule Name"] = value

    @property
    def economizer_type(self):
        """Get economizer_type.

        Returns:
            str: the value of `economizer_type` or None if not set

        """
        return self["Economizer Type"]

    @economizer_type.setter
    def economizer_type(self, value="NoEconomizer"):
        """Corresponds to IDD field `Economizer Type`

        Args:
            value (str): value for IDD Field `Economizer Type`
                Default value: NoEconomizer
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Economizer Type"] = value

    @property
    def economizer_lockout(self):
        """Get economizer_lockout.

        Returns:
            str: the value of `economizer_lockout` or None if not set

        """
        return self["Economizer Lockout"]

    @economizer_lockout.setter
    def economizer_lockout(self, value="NoLockout"):
        """Corresponds to IDD field `Economizer Lockout`

        Args:
            value (str): value for IDD Field `Economizer Lockout`
                Default value: NoLockout
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Economizer Lockout"] = value

    @property
    def economizer_maximum_limit_drybulb_temperature(self):
        """Get economizer_maximum_limit_drybulb_temperature.

        Returns:
            float: the value of `economizer_maximum_limit_drybulb_temperature` or None if not set

        """
        return self["Economizer Maximum Limit Dry-Bulb Temperature"]

    @economizer_maximum_limit_drybulb_temperature.setter
    def economizer_maximum_limit_drybulb_temperature(self, value=None):
        """  Corresponds to IDD field `Economizer Maximum Limit Dry-Bulb Temperature`
        Enter the maximum outdoor dry-bulb temperature limit for FixedDryBulb
        economizer control type. No input or blank input means this limit is
        not operative. Limit is applied regardless of economizer control type.

        Args:
            value (float): value for IDD Field `Economizer Maximum Limit Dry-Bulb Temperature`
                Units: C
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Economizer Maximum Limit Dry-Bulb Temperature"] = value

    @property
    def economizer_maximum_limit_enthalpy(self):
        """Get economizer_maximum_limit_enthalpy.

        Returns:
            float: the value of `economizer_maximum_limit_enthalpy` or None if not set

        """
        return self["Economizer Maximum Limit Enthalpy"]

    @economizer_maximum_limit_enthalpy.setter
    def economizer_maximum_limit_enthalpy(self, value=None):
        """Corresponds to IDD field `Economizer Maximum Limit Enthalpy` Enter
        the maximum outdoor enthalpy limit for FixedEnthalpy economizer control
        type. No input or blank input means this limit is not operative Limit
        is applied regardless of economizer control type.

        Args:
            value (float): value for IDD Field `Economizer Maximum Limit Enthalpy`
                Units: J/kg
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Economizer Maximum Limit Enthalpy"] = value

    @property
    def economizer_maximum_limit_dewpoint_temperature(self):
        """Get economizer_maximum_limit_dewpoint_temperature.

        Returns:
            float: the value of `economizer_maximum_limit_dewpoint_temperature` or None if not set

        """
        return self["Economizer Maximum Limit Dewpoint Temperature"]

    @economizer_maximum_limit_dewpoint_temperature.setter
    def economizer_maximum_limit_dewpoint_temperature(self, value=None):
        """Corresponds to IDD field `Economizer Maximum Limit Dewpoint
        Temperature` Enter the maximum outdoor dewpoint temperature limit for
        FixedDewPointAndDryBulb economizer control type. No input or blank
        input means this limit is not operative. Limit is applied regardless of
        economizer control type.

        Args:
            value (float): value for IDD Field `Economizer Maximum Limit Dewpoint Temperature`
                Units: C
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Economizer Maximum Limit Dewpoint Temperature"] = value

    @property
    def economizer_minimum_limit_drybulb_temperature(self):
        """Get economizer_minimum_limit_drybulb_temperature.

        Returns:
            float: the value of `economizer_minimum_limit_drybulb_temperature` or None if not set

        """
        return self["Economizer Minimum Limit Dry-Bulb Temperature"]

    @economizer_minimum_limit_drybulb_temperature.setter
    def economizer_minimum_limit_drybulb_temperature(self, value=None):
        """  Corresponds to IDD field `Economizer Minimum Limit Dry-Bulb Temperature`
        Enter the minimum outdoor dry-bulb temperature limit for economizer control.
        No input or blank input means this limit is not operative
        Limit is applied regardless of economizer control type.

        Args:
            value (float): value for IDD Field `Economizer Minimum Limit Dry-Bulb Temperature`
                Units: C
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Economizer Minimum Limit Dry-Bulb Temperature"] = value

    @property
    def supply_plenum_name(self):
        """Get supply_plenum_name.

        Returns:
            str: the value of `supply_plenum_name` or None if not set

        """
        return self["Supply Plenum Name"]

    @supply_plenum_name.setter
    def supply_plenum_name(self, value=None):
        """Corresponds to IDD field `Supply Plenum Name` Plenum zone name.
        Supply plenum serves all zones on this system. Blank if none.

        Args:
            value (str): value for IDD Field `Supply Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Supply Plenum Name"] = value

    @property
    def return_plenum_name(self):
        """Get return_plenum_name.

        Returns:
            str: the value of `return_plenum_name` or None if not set

        """
        return self["Return Plenum Name"]

    @return_plenum_name.setter
    def return_plenum_name(self, value=None):
        """Corresponds to IDD field `Return Plenum Name` Plenum zone name.
        Return plenum serves all zones on this system. Blank if none.

        Args:
            value (str): value for IDD Field `Return Plenum Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Plenum Name"] = value

    @property
    def night_cycle_control(self):
        """Get night_cycle_control.

        Returns:
            str: the value of `night_cycle_control` or None if not set

        """
        return self["Night Cycle Control"]

    @night_cycle_control.setter
    def night_cycle_control(self, value="StayOff"):
        """Corresponds to IDD field `Night Cycle Control`

        Args:
            value (str): value for IDD Field `Night Cycle Control`
                Default value: StayOff
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Night Cycle Control"] = value

    @property
    def night_cycle_control_zone_name(self):
        """Get night_cycle_control_zone_name.

        Returns:
            str: the value of `night_cycle_control_zone_name` or None if not set

        """
        return self["Night Cycle Control Zone Name"]

    @night_cycle_control_zone_name.setter
    def night_cycle_control_zone_name(self, value=None):
        """Corresponds to IDD field `Night Cycle Control Zone Name` Applicable
        only if Night Cycle Control is Cycle On Control Zone.

        Args:
            value (str): value for IDD Field `Night Cycle Control Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Night Cycle Control Zone Name"] = value

    @property
    def heat_recovery_type(self):
        """Get heat_recovery_type.

        Returns:
            str: the value of `heat_recovery_type` or None if not set

        """
        return self["Heat Recovery Type"]

    @heat_recovery_type.setter
    def heat_recovery_type(self, value="None"):
        """Corresponds to IDD field `Heat Recovery Type`

        Args:
            value (str): value for IDD Field `Heat Recovery Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Heat Recovery Type"] = value

    @property
    def sensible_heat_recovery_effectiveness(self):
        """Get sensible_heat_recovery_effectiveness.

        Returns:
            float: the value of `sensible_heat_recovery_effectiveness` or None if not set

        """
        return self["Sensible Heat Recovery Effectiveness"]

    @sensible_heat_recovery_effectiveness.setter
    def sensible_heat_recovery_effectiveness(self, value=0.7):
        """Corresponds to IDD field `Sensible Heat Recovery Effectiveness`

        Args:
            value (float): value for IDD Field `Sensible Heat Recovery Effectiveness`
                Default value: 0.7
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Sensible Heat Recovery Effectiveness"] = value

    @property
    def latent_heat_recovery_effectiveness(self):
        """Get latent_heat_recovery_effectiveness.

        Returns:
            float: the value of `latent_heat_recovery_effectiveness` or None if not set

        """
        return self["Latent Heat Recovery Effectiveness"]

    @latent_heat_recovery_effectiveness.setter
    def latent_heat_recovery_effectiveness(self, value=0.65):
        """Corresponds to IDD field `Latent Heat Recovery Effectiveness`
        Applicable only if Heat Recovery Type is Enthalpy.

        Args:
            value (float): value for IDD Field `Latent Heat Recovery Effectiveness`
                Default value: 0.65
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Latent Heat Recovery Effectiveness"] = value

    @property
    def humidifier_type(self):
        """Get humidifier_type.

        Returns:
            str: the value of `humidifier_type` or None if not set

        """
        return self["Humidifier Type"]

    @humidifier_type.setter
    def humidifier_type(self, value="None"):
        """Corresponds to IDD field `Humidifier Type`

        Args:
            value (str): value for IDD Field `Humidifier Type`
                Default value: None
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Humidifier Type"] = value

    @property
    def humidifier_availability_schedule_name(self):
        """Get humidifier_availability_schedule_name.

        Returns:
            str: the value of `humidifier_availability_schedule_name` or None if not set

        """
        return self["Humidifier Availability Schedule Name"]

    @humidifier_availability_schedule_name.setter
    def humidifier_availability_schedule_name(self, value=None):
        """Corresponds to IDD field `Humidifier Availability Schedule Name` If
        blank, always available.

        Args:
            value (str): value for IDD Field `Humidifier Availability Schedule Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Humidifier Availability Schedule Name"] = value

    @property
    def humidifier_rated_capacity(self):
        """Get humidifier_rated_capacity.

        Returns:
            float: the value of `humidifier_rated_capacity` or None if not set

        """
        return self["Humidifier Rated Capacity"]

    @humidifier_rated_capacity.setter
    def humidifier_rated_capacity(self, value=1e-06):
        """Corresponds to IDD field `Humidifier Rated Capacity` Moisture output
        rate at full rated power input. The humidifier does not currently
        autosize, so the default is very large to allow for adequate capacity.

        Args:
            value (float): value for IDD Field `Humidifier Rated Capacity`
                Units: m3/s
                IP-Units: gal/min
                Default value: 1e-06
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Humidifier Rated Capacity"] = value

    @property
    def humidifier_rated_electric_power(self):
        """Get humidifier_rated_electric_power.

        Returns:
            float: the value of `humidifier_rated_electric_power` or None if not set

        """
        return self["Humidifier Rated Electric Power"]

    @humidifier_rated_electric_power.setter
    def humidifier_rated_electric_power(self, value="autosize"):
        """  Corresponds to IDD field `Humidifier Rated Electric Power`
        Electric power input at rated capacity moisture output.
        Power consumption is proportional to moisture output with no part-load penalty.

        Args:
            value (float or "Autosize"): value for IDD Field `Humidifier Rated Electric Power`
                Units: W
                IP-Units: W
                Default value: "autosize"
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value
        """
        self["Humidifier Rated Electric Power"] = value

    @property
    def humidifier_control_zone_name(self):
        """Get humidifier_control_zone_name.

        Returns:
            str: the value of `humidifier_control_zone_name` or None if not set

        """
        return self["Humidifier Control Zone Name"]

    @humidifier_control_zone_name.setter
    def humidifier_control_zone_name(self, value=None):
        """Corresponds to IDD field `Humidifier Control Zone Name` Zone name
        where humidistat is located.

        Args:
            value (str): value for IDD Field `Humidifier Control Zone Name`
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Humidifier Control Zone Name"] = value

    @property
    def humidifier_setpoint(self):
        """Get humidifier_setpoint.

        Returns:
            float: the value of `humidifier_setpoint` or None if not set

        """
        return self["Humidifier Setpoint"]

    @humidifier_setpoint.setter
    def humidifier_setpoint(self, value=30.0):
        """Corresponds to IDD field `Humidifier Setpoint` Zone relative
        humidity setpoint in percent (0 to 100)

        Args:
            value (float): value for IDD Field `Humidifier Setpoint`
                Units: percent
                Default value: 30.0
                value <= 100.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Humidifier Setpoint"] = value

    @property
    def return_fan(self):
        """Get return_fan.

        Returns:
            str: the value of `return_fan` or None if not set

        """
        return self["Return Fan"]

    @return_fan.setter
    def return_fan(self, value="No"):
        """Corresponds to IDD field `Return Fan` Specifies if the system has a
        return fan.

        Args:
            value (str): value for IDD Field `Return Fan`
                Default value: No
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Fan"] = value

    @property
    def return_fan_total_efficiency(self):
        """Get return_fan_total_efficiency.

        Returns:
            float: the value of `return_fan_total_efficiency` or None if not set

        """
        return self["Return Fan Total Efficiency"]

    @return_fan_total_efficiency.setter
    def return_fan_total_efficiency(self, value=0.7):
        """Corresponds to IDD field `Return Fan Total Efficiency`

        Args:
            value (float): value for IDD Field `Return Fan Total Efficiency`
                Default value: 0.7
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Fan Total Efficiency"] = value

    @property
    def return_fan_delta_pressure(self):
        """Get return_fan_delta_pressure.

        Returns:
            float: the value of `return_fan_delta_pressure` or None if not set

        """
        return self["Return Fan Delta Pressure"]

    @return_fan_delta_pressure.setter
    def return_fan_delta_pressure(self, value=500.0):
        """Corresponds to IDD field `Return Fan Delta Pressure`

        Args:
            value (float): value for IDD Field `Return Fan Delta Pressure`
                Units: Pa
                IP-Units: inH2O
                Default value: 500.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Fan Delta Pressure"] = value

    @property
    def return_fan_motor_efficiency(self):
        """Get return_fan_motor_efficiency.

        Returns:
            float: the value of `return_fan_motor_efficiency` or None if not set

        """
        return self["Return Fan Motor Efficiency"]

    @return_fan_motor_efficiency.setter
    def return_fan_motor_efficiency(self, value=0.9):
        """Corresponds to IDD field `Return Fan Motor Efficiency`

        Args:
            value (float): value for IDD Field `Return Fan Motor Efficiency`
                Default value: 0.9
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Fan Motor Efficiency"] = value

    @property
    def return_fan_motor_in_air_stream_fraction(self):
        """Get return_fan_motor_in_air_stream_fraction.

        Returns:
            float: the value of `return_fan_motor_in_air_stream_fraction` or None if not set

        """
        return self["Return Fan Motor in Air Stream Fraction"]

    @return_fan_motor_in_air_stream_fraction.setter
    def return_fan_motor_in_air_stream_fraction(self, value=1.0):
        """Corresponds to IDD field `Return Fan Motor in Air Stream Fraction`

        Args:
            value (float): value for IDD Field `Return Fan Motor in Air Stream Fraction`
                Default value: 1.0
                value <= 1.0
                if `value` is None it will not be checked against the
                specification and is assumed to be a missing value

        Raises:
            ValueError: if `value` is not a valid value

        """
        self["Return Fan Motor in Air Stream Fraction"] = value




class HvactemplateSystemUnitarySystem(DataObject):

    """ Corresponds to IDD object `HVACTemplate:System:UnitarySystem`
        Unitary HVAC system with optional cooling and heating. Supports DX and chilled water,
        cooling, gas, electric, and hot water heating, air-to-air and water-to-air heat pumps.
    """
    schema = {'min-fields': 72,
              'name': u'HVACTemplate:System:UnitarySystem',
              'pyname': u'HvactemplateSystemUnitarySystem',
              'format': None,
              'fields': OrderedDict([(u'name',
                                      {'name': u'Name',
                                       'pyname': u'name',
                                       'required-field': True,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'system availability schedule name',
                                      {'name': u'System Availability Schedule Name',
                                       'pyname': u'system_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'control type',
                                      {'name': u'Control Type',
                                       'pyname': u'control_type',
                                       'default': u'Load',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Load',
                                                           u'SetPoint'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'control zone or thermostat location name',
                                      {'name': u'Control Zone or Thermostat Location Name',
                                       'pyname': u'control_zone_or_thermostat_location_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'cooling supply air flow rate',
                                      {'name': u'Cooling Supply Air Flow Rate',
                                       'pyname': u'cooling_supply_air_flow_rate',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'heating supply air flow rate',
                                      {'name': u'Heating Supply Air Flow Rate',
                                       'pyname': u'heating_supply_air_flow_rate',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'no load supply air flow rate',
                                      {'name': u'No Load Supply Air Flow Rate',
                                       'pyname': u'no_load_supply_air_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'm3/s'}),
                                     (u'supply fan operating mode schedule name',
                                      {'name': u'Supply Fan Operating Mode Schedule Name',
                                       'pyname': u'supply_fan_operating_mode_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supply fan placement',
                                      {'name': u'Supply Fan Placement',
                                       'pyname': u'supply_fan_placement',
                                       'default': u'BlowThrough',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'BlowThrough',
                                                           u'DrawThrough'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'supply fan total efficiency',
                                      {'name': u'Supply Fan Total Efficiency',
                                       'pyname': u'supply_fan_total_efficiency',
                                       'default': 0.7,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supply fan delta pressure',
                                      {'name': u'Supply Fan Delta Pressure',
                                       'pyname': u'supply_fan_delta_pressure',
                                       'default': 600.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'Pa'}),
                                     (u'supply fan motor efficiency',
                                      {'name': u'Supply Fan Motor Efficiency',
                                       'pyname': u'supply_fan_motor_efficiency',
                                       'default': 0.9,
                                       'minimum>': 0.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supply fan motor in air stream fraction',
                                      {'name': u'Supply Fan Motor in Air Stream Fraction',
                                       'pyname': u'supply_fan_motor_in_air_stream_fraction',
                                       'default': 1.0,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'cooling coil type',
                                      {'name': u'Cooling Coil Type',
                                       'pyname': u'cooling_coil_type',
                                       'default': u'SingleSpeedDX',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'SingleSpeedDX',
                                                           u'TwoSpeedDX',
                                                           u'MultiSpeedDX',
                                                           u'TwoStageDX',
                                                           u'TwoStageHumidityControlDX',
                                                           u'HeatExchangerAssistedDX',
                                                           u'SingleSpeedDXWaterCooled',
                                                           u'ChilledWater',
                                                           u'ChilledWaterDetailedFlatModel',
                                                           u'HeatExchangerAssistedChilledWater',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'number of speeds for cooling',
                                      {'name': u'Number of Speeds for Cooling',
                                       'pyname': u'number_of_speeds_for_cooling',
                                       'default': 1,
                                       'maximum': 4,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0,
                                       'autocalculatable': False,
                                       'type': u'integer'}),
                                     (u'cooling coil availability schedule name',
                                      {'name': u'Cooling Coil Availability Schedule Name',
                                       'pyname': u'cooling_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'cooling design supply air temperature',
                                      {'name': u'Cooling Design Supply Air Temperature',
                                       'pyname': u'cooling_design_supply_air_temperature',
                                       'default': 12.8,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'dx cooling coil gross rated total capacity',
                                      {'name': u'DX Cooling Coil Gross Rated Total Capacity',
                                       'pyname': u'dx_cooling_coil_gross_rated_total_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'dx cooling coil gross rated sensible heat ratio',
                                      {'name': u'DX Cooling Coil Gross Rated Sensible Heat Ratio',
                                       'pyname': u'dx_cooling_coil_gross_rated_sensible_heat_ratio',
                                       'default': 'autosize',
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.5,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'dx cooling coil gross rated cop',
                                      {'name': u'DX Cooling Coil Gross Rated COP',
                                       'pyname': u'dx_cooling_coil_gross_rated_cop',
                                       'default': 3.0,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W/W'}),
                                     (u'heating coil type',
                                      {'name': u'Heating Coil Type',
                                       'pyname': u'heating_coil_type',
                                       'default': u'Gas',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Electric',
                                                           u'Gas',
                                                           u'HotWater',
                                                           u'SingleSpeedDXHeatPumpAirSource',
                                                           u'MultiSpeedDXHeatPumpAirSource',
                                                           u'SingleSpeedDXHeatPumpWaterSource',
                                                           u'MultiStageElectric',
                                                           u'MultiStageGas',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'number of speeds or stages for heating',
                                      {'name': u'Number of Speeds or Stages for Heating',
                                       'pyname': u'number_of_speeds_or_stages_for_heating',
                                       'default': 1,
                                       'maximum': 4,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0,
                                       'autocalculatable': False,
                                       'type': u'integer'}),
                                     (u'heating coil availability schedule name',
                                      {'name': u'Heating Coil Availability Schedule Name',
                                       'pyname': u'heating_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'heating design supply air temperature',
                                      {'name': u'Heating Design Supply Air Temperature',
                                       'pyname': u'heating_design_supply_air_temperature',
                                       'default': 50.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'C'}),
                                     (u'heating coil gross rated capacity',
                                      {'name': u'Heating Coil Gross Rated Capacity',
                                       'pyname': u'heating_coil_gross_rated_capacity',
                                       'default': 'autosize',
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'W'}),
                                     (u'gas heating coil efficiency',
                                      {'name': u'Gas Heating Coil Efficiency',
                                       'pyname': u'gas_heating_coil_efficiency',
                                       'default': 0.8,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'gas heating coil parasitic electric load',
                                      {'name': u'Gas Heating Coil Parasitic Electric Load',
                                       'pyname': u'gas_heating_coil_parasitic_electric_load',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'heat pump heating coil gross rated cop',
                                      {'name': u'Heat Pump Heating Coil Gross Rated COP',
                                       'pyname': u'heat_pump_heating_coil_gross_rated_cop',
                                       'default': 2.75,
                                       'minimum>': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W/W'}),
                                     (u'heat pump heating minimum outdoor dry-bulb temperature',
                                      {'name': u'Heat Pump Heating Minimum Outdoor Dry-Bulb Temperature',
                                       'pyname': u'heat_pump_heating_minimum_outdoor_drybulb_temperature',
                                       'default': -8.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': -20.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'heat pump defrost maximum outdoor dry-bulb temperature',
                                      {'name': u'Heat Pump Defrost Maximum Outdoor Dry-Bulb Temperature',
                                       'pyname': u'heat_pump_defrost_maximum_outdoor_drybulb_temperature',
                                       'default': 5.0,
                                       'maximum': 7.22,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'heat pump defrost strategy',
                                      {'name': u'Heat Pump Defrost Strategy',
                                       'pyname': u'heat_pump_defrost_strategy',
                                       'default': u'ReverseCycle',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'ReverseCycle',
                                                           u'Resistive'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heat pump defrost control',
                                      {'name': u'Heat Pump Defrost Control',
                                       'pyname': u'heat_pump_defrost_control',
                                       'default': u'Timed',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Timed',
                                                           u'OnDemand'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'heat pump defrost time period fraction',
                                      {'name': u'Heat Pump Defrost Time Period Fraction',
                                       'pyname': u'heat_pump_defrost_time_period_fraction',
                                       'default': 0.058333,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': u'real'}),
                                     (u'supplemental heating or reheat coil type',
                                      {'name': u'Supplemental Heating or Reheat Coil Type',
                                       'pyname': u'supplemental_heating_or_reheat_coil_type',
                                       'default': u'None',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'Electric',
                                                           u'Gas',
                                                           u'HotWater',
                                                           u'DesuperHeater',
                                                           u'None'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'supplemental heating or reheat coil availability schedule name',
                                      {'name': u'Supplemental Heating or Reheat Coil Availability Schedule Name',
                                       'pyname': u'supplemental_heating_or_reheat_coil_availability_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'supplemental heating or reheat coil capacity',
                                      {'name': u'Supplemental Heating or Reheat Coil Capacity',
                                       'pyname': u'supplemental_heating_or_reheat_coil_capacity',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'supplemental heating or reheat coil maximum outdoor dry-bulb temperature',
                                      {'name': u'Supplemental Heating or Reheat Coil Maximum Outdoor Dry-Bulb Temperature',
                                       'pyname': u'supplemental_heating_or_reheat_coil_maximum_outdoor_drybulb_temperature',
                                       'default': 21.0,
                                       'maximum': 21.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'supplemental gas heating or reheat coil efficiency',
                                      {'name': u'Supplemental Gas Heating or Reheat Coil Efficiency',
                                       'pyname': u'supplemental_gas_heating_or_reheat_coil_efficiency',
                                       'default': 0.8,
                                       'maximum': 1.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real'}),
                                     (u'supplemental gas heating or reheat coil parasitic electric load',
                                      {'name': u'Supplemental Gas Heating or Reheat Coil Parasitic Electric Load',
                                       'pyname': u'supplemental_gas_heating_or_reheat_coil_parasitic_electric_load',
                                       'default': 0.0,
                                       'required-field': False,
                                       'autosizable': False,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'W'}),
                                     (u'maximum outdoor air flow rate',
                                      {'name': u'Maximum Outdoor Air Flow Rate',
                                       'pyname': u'maximum_outdoor_air_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'minimum outdoor air flow rate',
                                      {'name': u'Minimum Outdoor Air Flow Rate',
                                       'pyname': u'minimum_outdoor_air_flow_rate',
                                       'default': 'autosize',
                                       'required-field': False,
                                       'autosizable': True,
                                       'minimum': 0.0,
                                       'autocalculatable': False,
                                       'type': 'real',
                                       'unit': u'm3/s'}),
                                     (u'minimum outdoor air schedule name',
                                      {'name': u'Minimum Outdoor Air Schedule Name',
                                       'pyname': u'minimum_outdoor_air_schedule_name',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'object-list'}),
                                     (u'economizer type',
                                      {'name': u'Economizer Type',
                                       'pyname': u'economizer_type',
                                       'default': u'NoEconomizer',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'FixedDryBulb',
                                                           u'FixedEnthalpy',
                                                           u'DifferentialDryBulb',
                                                           u'DifferentialEnthalpy',
                                                           u'FixedDewPointAndDryBulb',
                                                           u'ElectronicEnthalpy',
                                                           u'DifferentialDryBulbAndEnthalpy',
                                                           u'NoEconomizer'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'economizer lockout',
                                      {'name': u'Economizer Lockout',
                                       'pyname': u'economizer_lockout',
                                       'default': u'NoLockout',
                                       'required-field': False,
                                       'autosizable': False,
                                       'accepted-values': [u'NoLockout',
                                                           u'LockoutWithHeating',
                                                           u'LockoutWithCompressor'],
                                       'autocalculatable': False,
                                       'type': 'alpha'}),
                                     (u'economizer maximum limit dry-bulb temperature',
                                      {'name': u'Economizer Maximum Limit Dry-Bulb Temperature',
                                       'pyname': u'economizer_maximum_limit_drybulb_temperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'economizer maximum limit enthalpy',
                                      {'name': u'Economizer Maximum Limit Enthalpy',
                                       'pyname': u'economizer_maximum_limit_enthalpy',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'J/kg'}),
                                     (u'economizer maximum limit dewpoint temperature',
                                      {'name': u'Economizer Maximum Limit Dewpoint Temperature',
                                       'pyname': u'economizer_maximum_limit_dewpoint_temperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'economizer minimum limit dry-bulb temperature',
                                      {'name': u'Economizer Minimum Limit Dry-Bulb Temperature',
                                       'pyname': u'economizer_minimum_limit_drybulb_temperature',
                                       'required-field': False,
                                       'autosizable': False,
                                       'autocalculatable': False,
                                       'type': u'real',
                                       'unit': u'C'}),
                                     (u'supply plenum name',
                                      {'name': u'Supply Plenum Name',
                                       'pyname': u'supply_pl