# -*- coding: UTF-8 -*-

import httplib, mimetypes
import urllib2

def multipart_call(method, host, protocol, selector, fields, files=None):
    """
    Post fields and files to an http host as multipart/form-data.
    fields is a sequence of (name, value) elements for regular form fields.
    files is a sequence of (name, filename, value) elements for data to be uploaded as files
    Return the server's response page.
    """
    files = files or []
    content_type, body = encode_multipart_formdata(fields, files)
    if protocol == "https":
        h = httplib.HTTPSConnection(host=host)
    elif protocol == "http":
        h = httplib.HTTPConnection(host=host)
    else:
        raise NameError, "unknown protocol"
    headers = {
            'User-Agent': 'INSERT USERAGENTNAME',
            'Content-Type': content_type
        }
    h.request(method, selector, body, headers)
    res = h.getresponse()
    return res

def encode_multipart_formdata(fields, files):
    """
    fields is a sequence of (name, value) elements for regular form fields.
    files is a sequence of (name, filename, value) elements for data to be uploaded as files
    Return (content_type, body) ready for httplib.HTTP instance
    """
    BOUNDARY = '----------ThIs_Is_tHe_bouNdaRY_$'
    CRLF = '\r\n'
    L = []
    for (key, value) in fields:
        L.append('--' + BOUNDARY)
        L.append('Content-Disposition: form-data; name="%s"' % key)
        L.append('')
        L.append(value)
    for (key, filename, value) in files:
        L.append('--' + BOUNDARY)
        L.append('Content-Disposition: form-data; name="%s"; filename="%s"' % (key, filename))
        L.append('Content-Type: %s' % get_content_type(filename))
        L.append('')
        L.append(value)
    L.append('--' + BOUNDARY + '--')
    L.append('')
    body = CRLF.join(L)
    content_type = 'multipart/form-data; boundary=%s' % BOUNDARY
    return content_type, body

def get_content_type(filename):
    return mimetypes.guess_type(filename)[0] or 'application/octet-stream'


