#! /usr/bin/env python

"""
Generate some internal code.
"""

from __future__ import absolute_import
from collections import defaultdict
from os.path import splitext
from pykit.ir import ops

def getorder():
    pos = defaultdict(int) # { 'opname': index }
    fn, ext = splitext(ops.__file__)
    lines = list(open(fn + '.py'))
    for name, op in vars(ops).iteritems():
        if isinstance(op, basestring) and name not in ('__file__', '__name__',
                                                       'constant'):
            for i, line in enumerate(lines):
                if line.startswith(op):
                    pos[op] = i
                    break

    order = sorted((lineno, op) for op, lineno in pos.iteritems())
    return order

order = getorder()

def gen_builder():
    """Generate code for pykit.ir.builder operations"""
    print("    # Generated by pykit.utils._generate")
    for lineno, op in order:
        if op[0].isupper():
            print("    %-20s = _const(ops.%s)" % (op, op))
        else:
            print("    %-20s = _op(ops.%s)" % (op, op))

def gen_visitor():
    """Generate code for any visitor"""
    for lineno, op in order:
        if not op[0].isupper():
            print("    def %s(self, op):\n        pass\n" % (op,))

def gen_ops(lst):
    """Generate ops for ops.py"""
    for name in lst:
        print("%-18s = %r" % (name, name))

if __name__ == "__main__":
    gen_builder()