# -*- coding: utf-8 -*-

"""
    Generated builder methods.
"""

from __future__ import print_function, division, absolute_import

from pykit import types, config
from pykit.ir import Op, Value, Const, ops
from pykit.ir.verification import verify_op_syntax


class GeneratedBuilder(object):
    _const = lambda val: Const(val, types.Opaque)
    _insert_op = lambda self, op: None  # noop

    #===------------------------------------------------------------------===
    # Generated by pykit.utils._generate
    #===------------------------------------------------------------------===
    
    Sin                  = _const(ops.Sin)
    Asin                 = _const(ops.Asin)
    Sinh                 = _const(ops.Sinh)
    Asinh                = _const(ops.Asinh)
    Cos                  = _const(ops.Cos)
    Acos                 = _const(ops.Acos)
    Cosh                 = _const(ops.Cosh)
    Acosh                = _const(ops.Acosh)
    Tan                  = _const(ops.Tan)
    Atan                 = _const(ops.Atan)
    Atan2                = _const(ops.Atan2)
    Tanh                 = _const(ops.Tanh)
    Atanh                = _const(ops.Atanh)
    Log                  = _const(ops.Log)
    Log2                 = _const(ops.Log2)
    Log10                = _const(ops.Log10)
    Log1p                = _const(ops.Log1p)
    Exp                  = _const(ops.Exp)
    Exp2                 = _const(ops.Exp2)
    Expm1                = _const(ops.Expm1)
    Floor                = _const(ops.Floor)
    Ceil                 = _const(ops.Ceil)
    Abs                  = _const(ops.Abs)
    Erfc                 = _const(ops.Erfc)
    Rint                 = _const(ops.Rint)
    Pow                  = _const(ops.Pow)
    Round                = _const(ops.Round)

    def alloca(self, returnType, obj0, **kwds):
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('alloca', returnType, [obj0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def load(self, returnType, value0, **kwds):
        assert isinstance(value0, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('load', returnType, [value0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def store(self, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        returnType = types.Void
        register = kwds.pop('result', None)
        op = Op('store', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def convert(self, returnType, value0, **kwds):
        assert isinstance(value0, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('convert', returnType, [value0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def bitcast(self, returnType, value0, **kwds):
        assert isinstance(value0, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('bitcast', returnType, [value0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def phi(self, returnType, lst0, lst1, **kwds):
        assert isinstance(lst0, list)
        assert isinstance(lst1, list)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('phi', returnType, [lst0, lst1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def exc_setup(self, lst0, **kwds):
        assert isinstance(lst0, list)
        returnType = types.Void
        register = kwds.pop('result', None)
        op = Op('exc_setup', returnType, [lst0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def exc_catch(self, lst0, **kwds):
        assert isinstance(lst0, list)
        returnType = types.Void
        register = kwds.pop('result', None)
        op = Op('exc_catch', returnType, [lst0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def jump(self, value0, **kwds):
        assert isinstance(value0, Value)
        returnType = types.Void
        register = kwds.pop('result', None)
        op = Op('jump', returnType, [value0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def cbranch(self, value0, value1, value2, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert isinstance(value2, Value)
        returnType = types.Void
        register = kwds.pop('result', None)
        op = Op('cbranch', returnType, [value0, value1, value2], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def exc_throw(self, value0, **kwds):
        assert isinstance(value0, Value)
        returnType = types.Void
        register = kwds.pop('result', None)
        op = Op('exc_throw', returnType, [value0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def ret(self, obj0, **kwds):
        returnType = types.Void
        register = kwds.pop('result', None)
        op = Op('ret', returnType, [obj0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def call(self, returnType, value0, lst0, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(lst0, list)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('call', returnType, [value0, lst0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def call_math(self, returnType, obj0, lst0, **kwds):
        assert isinstance(lst0, list)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('call_math', returnType, [obj0, lst0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def add(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('add', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def addressof(self, returnType, value0, **kwds):
        assert isinstance(value0, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('addressof', returnType, [value0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def sizeof(self, returnType, value0, **kwds):
        assert isinstance(value0, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('sizeof', returnType, [value0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def ptradd(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('ptradd', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def ptrload(self, returnType, value0, **kwds):
        assert isinstance(value0, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('ptrload', returnType, [value0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def ptrstore(self, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        returnType = types.Void
        register = kwds.pop('result', None)
        op = Op('ptrstore', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def ptrcast(self, returnType, value0, **kwds):
        assert isinstance(value0, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('ptrcast', returnType, [value0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def ptr_isnull(self, returnType, value0, **kwds):
        assert isinstance(value0, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('ptr_isnull', returnType, [value0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def ge(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('ge', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def get(self, returnType, value0, lst0, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(lst0, list)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('get', returnType, [value0, lst0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def set(self, returnType, value0, value1, lst0, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert isinstance(lst0, list)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('set', returnType, [value0, value1, lst0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def getfield(self, returnType, value0, obj0, **kwds):
        assert isinstance(value0, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('getfield', returnType, [value0, obj0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def setfield(self, value0, obj0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        returnType = types.Void
        register = kwds.pop('result', None)
        op = Op('setfield', returnType, [value0, obj0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def extractfield(self, returnType, value0, obj0, **kwds):
        assert isinstance(value0, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('extractfield', returnType, [value0, obj0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def insertfield(self, returnType, value0, obj0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('insertfield', returnType, [value0, obj0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def shufflevector(self, returnType, value0, value1, value2, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert isinstance(value2, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('shufflevector', returnType, [value0, value1, value2], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def sub(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('sub', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def mul(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('mul', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def div(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('div', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def mod(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('mod', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def lshift(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('lshift', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def rshift(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('rshift', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def bitand(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('bitand', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def bitor(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('bitor', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def bitxor(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('bitxor', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def invert(self, returnType, value0, **kwds):
        assert isinstance(value0, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('invert', returnType, [value0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def not_(self, returnType, value0, **kwds):
        assert isinstance(value0, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('not_', returnType, [value0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def uadd(self, returnType, value0, **kwds):
        assert isinstance(value0, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('uadd', returnType, [value0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def usub(self, returnType, value0, **kwds):
        assert isinstance(value0, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('usub', returnType, [value0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def eq(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('eq', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def ne(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('ne', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def lt(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('lt', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def le(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('le', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def gt(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('gt', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def is_(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('is_', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def check_error(self, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        returnType = types.Void
        register = kwds.pop('result', None)
        op = Op('check_error', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def new_exc(self, returnType, value0, value1, **kwds):
        assert isinstance(value0, Value)
        assert isinstance(value1, Value)
        assert returnType is not None
        register = kwds.pop('result', None)
        op = Op('new_exc', returnType, [value0, value1], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op

    def print(self, value0, **kwds):
        assert isinstance(value0, Value)
        returnType = types.Void
        register = kwds.pop('result', None)
        op = Op('print', returnType, [value0], register, metadata=kwds)
        if config.op_verify:
            verify_op_syntax(op)
        self._insert_op(op)
        return op
