# flake8: NOQA
from time import gmtime, strftime
import datetime

dt = datetime.datetime.now()
SYSLOG_ERROR_LEVELS = ['DEBUG', 'INFO', 'WARNING', 'ERROR', 'CRITICAL']
SYSLOG_ERROR_LEVELS_LOWER = [level.lower() for level in SYSLOG_ERROR_LEVELS]
HTTP_VERBS = ['OPTIONS', 'GET', 'HEAD', 'POST', 'PUT', 'DELETE']
HTTP_VERSIONS = ['HTTP/1.0', 'HTTP/1.1']
HTTP_ERROR_CODES = [
    '100', '101',
    '200', '201', '202', '203', '204', '205', '206',
    '300', '301', '302', '303', '304', '305',
    '400', '401', '402', '403', '404', '405', '406', '407', '408', '409', '410', '411', '412', '413', '414', '415',
    '500', '501', '502', '503', '504', '505'
]
HTTP_MORE_VERBS = [
    'TRACE', 'CONNECT', 'PROPFIND', 'PROPPATCH', 'MKCOL',
    'COPY', 'MOVE', 'LOCK', 'UNLOCK', 'VERSION-CONTROL',
    'REPORT', 'CHECKOUT', 'CHECKIN', 'UNCHECKOUT', 'MKWORKSPACE',
    'UPDATE', 'LABEL', 'MERGE', 'BASELINE-CONTROL', 'MKACTIVITY',
    'ORDERPATCH', 'ACL', 'draft-dusseault-http-patch', 'PATCH',
    'draft-reschke-webdav-search', 'SEARCH'
]
CURRENT_TIME = [str(dt.time().replace(microsecond=0))]
CURRENT_DATE_TIME = [str(dt.replace(microsecond=0))]
CURRENT_DAY_OF_MONTH = [str(dt.strftime("%d"))]
CURRENT_DAY_OF_WEEK_SHORT = [str(dt.strftime("%A")[0:3])]
CURRENT_YEAR = [str(dt.strftime("%y"))]
CURRENT_MONTH_NAME_SHORT = [str(dt.strftime("%B")[0:3])]
CURRENT_TIME_ZONE_NUMBER = [strftime("%z", gmtime())]
TIME_ZONE_NUMBER = [
    '-1200', '-1100', '-1000', '-0900', '-0800', '-0700', '-0600', '-0500', '-0400', '-0300', '-0200', '-0100', '-0000',
    '+1200', '+1100', '+1000', '+0900', '+0800', '+0700', '+0600', '+0500', '+0400', '+0300', '+0200', '+0100', '+0000',
]
MONTH_NAME_SHORT = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec']
DAY_OF_WEEK_SHORT = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat']