# flake8: NOQA
"""Script to run pylog via command line

Usage:
    pylog gen [--config=<path> --transport=<string> --format=<string> --gap=<int> --messages=<int> -v]
    pylog --version

Arguments:
    gen     Generates Logs

Options:
    -h --help                   Show this screen.
    -c --config=<path>          Path to generator config file
    -t --transport=<string>     transport to use
    -f --format=<string>        output format
    -g --gap=<int>              Number of seconds between messages
    -m --messages=<int>         Number of messages to generate
    -v --verbose                a LOT of output
    --version                   Display current version of sandman and exit

"""

from __future__ import absolute_import
from docopt import docopt
from pylog.pylog import init_logger
from pylog.pylog import set_global_verbosity_level
from pylog.pylog import generator

lgr = init_logger()


def ver_check():
    import pkg_resources
    version = None
    try:
        version = pkg_resources.get_distribution('pylog').version
    except Exception as e:
        print(e)
    finally:
        del pkg_resources
    return version


def pylog_run(o):
    generator(config=o.get('--config'),
             transport=o.get('--transport'),
             formatter=o.get('--format'),
             gap=o.get('--gap'),
             messages=o.get('--messages'),
             verbose=o.get('--verbose'))


def pylog(test_options=None):
    """Main entry point for script."""
    version = ver_check()
    options = test_options or docopt(__doc__, version=version)
    set_global_verbosity_level(options.get('--verbose'))
    lgr.debug(options)
    pylog_run(options)


def main():
    pylog()


if __name__ == '__main__':
    main()
