import random
from abc import abstractmethod, ABCMeta


class BaseFormatter(object):

    __metaclass__ = ABCMeta

    @abstractmethod
    def __init__(self, config):
        return

    @abstractmethod
    def generate_data(self):
        return


class CustomFormatter(BaseFormatter):
    def __init__(self, config):
        self.format = config['format']
        self.data = config['data']

    def generate_data(self):
        log = ''
        for field_name in self.format:
            for field in self.data.keys():
                if field_name == field:
                    log += random.choice(self.data[field_name])
        return log


class JsonFormatter(BaseFormatter):
    def __init__(self, config):
        self.data = config['data']

    def generate_data(self):
        log = {}
        for field, data in self.data.items():
            log[field] = random.choice(data)
        return log
