"""
Generated arithmetic methods for numbers.

This file is generated by the src/mk_numbers_methods.py script.
See http://sympycore.googlecode.com/ for more information.

DO NOT CHANGE THIS FILE DIRECTLY!!!
"""

from .numbers import mpqc, mpf, mpq, mpc, inttypes_set, realtypes_set, complextypes_set, numbertypes_set



def fraction_add(self, other, cls=mpq, inttypes_set=inttypes_set):
    t = type(other)
    #IF_CHECK_INT(T=t)
    if t in inttypes_set:
        #ADD_FRACTION_INT(LHS=self; RHS=other)
        p, q = self
        #RETURN_FRACTION(NUMER=p+q*(other); DENOM=q)
        return cls((p+q*(other), q))
    elif t is cls:
        #ADD_FRACTION_FRACTION(LHS=self; RHS=other)
        #ADDOP_FRACTION_FRACTION(LHS=self; RHS=other; SIGN=+; MOD=%)
        p, q = self
        r, s = other
        _tmp30 = p*s + q*r
        if not _tmp30:
            return 0
        #RETURN_FRACTION2(NUMER=_tmp30; DENOM=q*s; MOD=%)
        #FRACTION_NORMALIZE(NUMER=_tmp30; DENOM=q*s; RNUMER=_p; RDENOM=_q; MOD=%)
        _p = _x = _tmp30
        _q = _y = q*s
        while 1:
            _x, _y = _y, _x % _y
            if not _y:
                break
        if _x != 1:
            _p //= _x
            _q //= _x
        if _q == 1:
            return _p
        #RETURN_FRACTION(NUMER=_p; DENOM=_q)
        return cls((_p, _q))
    #IF_CHECK_FLOAT(T=t)
    if t is float:
        return self + mpf(other)
    return NotImplemented

def fraction_sub(self, other, cls=mpq, inttypes_set=inttypes_set):
    t = type(other)
    #IF_CHECK_INT(T=t)
    if t in inttypes_set:
        #SUB_FRACTION_INT(LHS=self; RHS=other)
        p, q = self
        #RETURN_FRACTION(NUMER=p-q*(other); DENOM=q)
        return cls((p-q*(other), q))
    elif t is cls:
        #SUB_FRACTION_FRACTION(LHS=self; RHS=other)
        #ADDOP_FRACTION_FRACTION(LHS=self; RHS=other; SIGN=-; MOD=%)
        p, q = self
        r, s = other
        _tmp93 = p*s - q*r
        if not _tmp93:
            return 0
        #RETURN_FRACTION2(NUMER=_tmp93; DENOM=q*s; MOD=%)
        #FRACTION_NORMALIZE(NUMER=_tmp93; DENOM=q*s; RNUMER=_p; RDENOM=_q; MOD=%)
        _p = _x = _tmp93
        _q = _y = q*s
        while 1:
            _x, _y = _y, _x % _y
            if not _y:
                break
        if _x != 1:
            _p //= _x
            _q //= _x
        if _q == 1:
            return _p
        #RETURN_FRACTION(NUMER=_p; DENOM=_q)
        return cls((_p, _q))
    #IF_CHECK_FLOAT(T=t)
    if t is float:
        return self - mpf(other)
    return NotImplemented

def fraction_rsub(self, other, cls=mpq, inttypes_set=inttypes_set):
    t = type(other)
    #IF_CHECK_INT(T=t)
    if t in inttypes_set:
        #SUB_INT_FRACTION(RHS=self; LHS=other)
        p, q = self
        #RETURN_FRACTION(NUMER=q*(other) - p; DENOM=q)
        return cls((q*(other) - p, q))
    #IF_CHECK_FLOAT(T=t)
    if t is float:
        return mpf(other) - self
    return NotImplemented

def fraction_mul(self, other, cls=mpq, inttypes_set=inttypes_set):
    t = type(other)
    if t is cls:
        #MUL_FRACTION_FRACTION(LHS=self; RHS=other; MOD=%)
        p, q = self
        r, s = other
        #RETURN_FRACTION2(NUMER=p*r; DENOM=q*s; MOD=%)
        #FRACTION_NORMALIZE(NUMER=p*r; DENOM=q*s; RNUMER=_p; RDENOM=_q; MOD=%)
        _p = _x = p*r
        _q = _y = q*s
        while 1:
            _x, _y = _y, _x % _y
            if not _y:
                break
        if _x != 1:
            _p //= _x
            _q //= _x
        if _q == 1:
            return _p
        #RETURN_FRACTION(NUMER=_p; DENOM=_q)
        return cls((_p, _q))
    #IF_CHECK_INT(T=t)
    if t in inttypes_set:
        #MUL_FRACTION_INT(LHS=self; RHS=other; MOD=%)
        p, q = self
        #RETURN_FRACTION2(NUMER=p*other; DENOM=q; MOD=%)
        #FRACTION_NORMALIZE(NUMER=p*other; DENOM=q; RNUMER=_p; RDENOM=_q; MOD=%)
        _p = _x = p*other
        _q = _y = q
        while 1:
            _x, _y = _y, _x % _y
            if not _y:
                break
        if _x != 1:
            _p //= _x
            _q //= _x
        if _q == 1:
            return _p
        #RETURN_FRACTION(NUMER=_p; DENOM=_q)
        return cls((_p, _q))
    #IF_CHECK_FLOAT(T=t)
    if t is float:
        return self * mpf(other)
    return NotImplemented

def fraction_div(self, other, cls=mpq, inttypes_set=inttypes_set):
    t = type(other)
    #IF_CHECK_INT(T=t)
    if t in inttypes_set:
        #DIV_FRACTION_INT(LHS=self; RHS=other; MOD=%)
        p, q = self
        #RETURN_FRACTION2(NUMER=p; DENOM=q*other; MOD=%)
        #FRACTION_NORMALIZE(NUMER=p; DENOM=q*other; RNUMER=_p; RDENOM=_q; MOD=%)
        _p = _x = p
        _q = _y = q*other
        while 1:
            _x, _y = _y, _x % _y
            if not _y:
                break
        if _x != 1:
            _p //= _x
            _q //= _x
        if _q == 1:
            return _p
        #RETURN_FRACTION(NUMER=_p; DENOM=_q)
        return cls((_p, _q))
    elif t is cls:
        #DIV_FRACTION_FRACTION(LHS=self; RHS=other; MOD=%)
        p, q = self
        r, s = other
        #RETURN_FRACTION2(NUMER=p*s; DENOM=q*r; MOD=%)
        #FRACTION_NORMALIZE(NUMER=p*s; DENOM=q*r; RNUMER=_p; RDENOM=_q; MOD=%)
        _p = _x = p*s
        _q = _y = q*r
        while 1:
            _x, _y = _y, _x % _y
            if not _y:
                break
        if _x != 1:
            _p //= _x
            _q //= _x
        if _q == 1:
            return _p
        #RETURN_FRACTION(NUMER=_p; DENOM=_q)
        return cls((_p, _q))
    #IF_CHECK_FLOAT(T=t)
    if t is float:
        return self / mpf(other)
    return NotImplemented

def fraction_rdiv(self, other, cls=mpq, inttypes_set=inttypes_set):
    t = type(other)
    #IF_CHECK_INT(T=t)
    if t in inttypes_set:
        #DIV_INT_FRACTION(RHS=self; LHS=other; MOD=%)
        p, q = self
        #RETURN_FRACTION2(NUMER=other*q; DENOM=p; MOD=%)
        #FRACTION_NORMALIZE(NUMER=other*q; DENOM=p; RNUMER=_p; RDENOM=_q; MOD=%)
        _p = _x = other*q
        _q = _y = p
        while 1:
            _x, _y = _y, _x % _y
            if not _y:
                break
        if _x != 1:
            _p //= _x
            _q //= _x
        if _q == 1:
            return _p
        #RETURN_FRACTION(NUMER=_p; DENOM=_q)
        return cls((_p, _q))
    #IF_CHECK_FLOAT(T=t)
    if t is float:
        return mpf(other) / self
    return NotImplemented

def fraction_pow(self, other, m=None, cls=mpq, inttypes_set=inttypes_set):
    t = type(other)
    #IF_CHECK_INT(T=t)
    if t in inttypes_set:
        if not other:
            return 1
        if other==1:
            return self
        #POW_FRACTION_INT(LHS=self; RHS=other)
        _tmp345 = other
        p, q = self
        if _tmp345 > 0:
            #RETURN_FRACTION(NUMER=p**_tmp345; DENOM=q**_tmp345)
            return cls((p**_tmp345, q**_tmp345))
        _tmp345 = -_tmp345
        if p > 0:
            #RETURN_FRACTION(NUMER=q**_tmp345; DENOM=p**_tmp345)
            return cls((q**_tmp345, p**_tmp345))
        #RETURN_FRACTION(NUMER=(-q)**_tmp345; DENOM=(-p)**_tmp345)
        return cls(((-q)**_tmp345, (-p)**_tmp345))
    #IF_CHECK_FLOAT(T=t)
    if t is float:
        return self ** mpf(other)
    return NotImplemented

def complex_add(self, other, new=object.__new__, cls=mpqc, realtypes_set=realtypes_set, complextypes_set=complextypes_set):
    t = type(other)
    #IF_CHECK_REAL(T=t)
    if t in realtypes_set:
        #ADD_COMPLEX_REAL(LHS=self; RHS=other)
        #RETURN_COMPLEX(REAL=self.real + other; IMAG=self.imag)
        _tmp394 = new(cls)
        _tmp394.real = self.real + other
        _tmp394.imag = self.imag
        return _tmp394
    #IF_CHECK_COMPLEX(T=t)
    if t in complextypes_set:
        #ADD_COMPLEX_COMPLEX(LHS=self; RHS=other)
        #RETURN_COMPLEX2(REAL=self.real + other.real; IMAG=self.imag + other.imag)
        _tmp415 = self.imag + other.imag
        if not _tmp415:
            return self.real + other.real
        #RETURN_COMPLEX(REAL=self.real + other.real; IMAG=_tmp415)
        _tmp422 = new(cls)
        _tmp422.real = self.real + other.real
        _tmp422.imag = _tmp415
        return _tmp422
    return NotImplemented

def complex_sub(self, other, new=object.__new__, cls=mpqc, realtypes_set=realtypes_set, complextypes_set=complextypes_set):
    t = type(other)
    #IF_CHECK_REAL(T=t)
    if t in realtypes_set:
        #SUB_COMPLEX_REAL(LHS=self; RHS=other)
        #RETURN_COMPLEX(REAL=self.real - other; IMAG=self.imag)
        _tmp443 = new(cls)
        _tmp443.real = self.real - other
        _tmp443.imag = self.imag
        return _tmp443
    #IF_CHECK_COMPLEX(T=t)
    if t in complextypes_set:
        #SUB_COMPLEX_COMPLEX(LHS=self; RHS=other)
        #RETURN_COMPLEX2(REAL=self.real - other.real; IMAG=self.imag - other.imag)
        _tmp464 = self.imag - other.imag
        if not _tmp464:
            return self.real - other.real
        #RETURN_COMPLEX(REAL=self.real - other.real; IMAG=_tmp464)
        _tmp471 = new(cls)
        _tmp471.real = self.real - other.real
        _tmp471.imag = _tmp464
        return _tmp471
    return NotImplemented

def complex_rsub(self, other, new=object.__new__, cls=mpqc, realtypes_set=realtypes_set):
    t = type(other)
    #IF_CHECK_REAL(T=t)
    if t in realtypes_set:
        #SUB_REAL_COMPLEX(LHS=other; RHS=self)
        #RETURN_COMPLEX(REAL=other - self.real; IMAG=-self.imag)
        _tmp492 = new(cls)
        _tmp492.real = other - self.real
        _tmp492.imag = -self.imag
        return _tmp492
    if t is complex:
        #SUB_COMPLEX_COMPLEX(LHS=other; RHS=self)
        #RETURN_COMPLEX2(REAL=other.real - self.real; IMAG=other.imag - self.imag)
        _tmp506 = other.imag - self.imag
        if not _tmp506:
            return other.real - self.real
        #RETURN_COMPLEX(REAL=other.real - self.real; IMAG=_tmp506)
        _tmp513 = new(cls)
        _tmp513.real = other.real - self.real
        _tmp513.imag = _tmp506
        return _tmp513
    return NotImplemented

def complex_mul(self, other, new=object.__new__, cls=mpqc, realtypes_set=realtypes_set, complextypes_set=complextypes_set):
    t = type(other)
    #IF_CHECK_COMPLEX(T=t)
    if t in complextypes_set:
        #MUL_COMPLEX_COMPLEX(LHS=self; RHS=other)
        a, b = self.real, self.imag
        c, d = other.real, other.imag
        #RETURN_COMPLEX2(REAL=a*c-b*d; IMAG=b*c+a*d)
        _tmp534 = b*c+a*d
        if not _tmp534:
            return a*c-b*d
        #RETURN_COMPLEX(REAL=a*c-b*d; IMAG=_tmp534)
        _tmp541 = new(cls)
        _tmp541.real = a*c-b*d
        _tmp541.imag = _tmp534
        return _tmp541
    #IF_CHECK_REAL(T=t)
    if t in realtypes_set:
        #MUL_COMPLEX_REAL(LHS=self; RHS=other)
        if not other:
            return 0
        #RETURN_COMPLEX(REAL=self.real*other; IMAG=self.imag*other)
        _tmp562 = new(cls)
        _tmp562.real = self.real*other
        _tmp562.imag = self.imag*other
        return _tmp562
    return NotImplemented

def complex_div(self, other, new=object.__new__, cls=mpqc, realtypes_set=realtypes_set, complextypes_set=complextypes_set):
    t = type(other)
    #IF_CHECK_REAL(T=t)
    if t in realtypes_set:
        #DIV_COMPLEX_REAL(LHS=self; RHS=other; MOD=%)
        #DIV_VALUE_VALUE(LHS=self.real; RHS=other; RESULT=re; MOD=%)
        _p, _q = self.real, other
        if not _q:
            raise ZeroDivisionError(repr(self.real) + " / " + repr(other))
        #IF_CHECK_INT(T=type(_p))
        if type(_p) in inttypes_set:
            #IF_CHECK_INT(T=type(_q))
            if type(_q) in inttypes_set:
                #FRACTION_NORMALIZE(NUMER=_p; DENOM=_q; RNUMER=_rp; RDENOM=_rq; MOD=%)
                _rp = _x = _p
                _rq = _y = _q
                while 1:
                    _x, _y = _y, _x % _y
                    if not _y:
                        break
                if _x != 1:
                    _rp //= _x
                    _rq //= _x
                re = _rp if _rq == 1 else mpq((_rp, _rq))
            else:
                re = _p / _q
        else:
            re = _p / _q
        #DIV_VALUE_VALUE(LHS=self.imag; RHS=other; RESULT=im; MOD=%)
        _p, _q = self.imag, other
        if not _q:
            raise ZeroDivisionError(repr(self.imag) + " / " + repr(other))
        #IF_CHECK_INT(T=type(_p))
        if type(_p) in inttypes_set:
            #IF_CHECK_INT(T=type(_q))
            if type(_q) in inttypes_set:
                #FRACTION_NORMALIZE(NUMER=_p; DENOM=_q; RNUMER=_rp; RDENOM=_rq; MOD=%)
                _rp = _x = _p
                _rq = _y = _q
                while 1:
                    _x, _y = _y, _x % _y
                    if not _y:
                        break
                if _x != 1:
                    _rp //= _x
                    _rq //= _x
                im = _rp if _rq == 1 else mpq((_rp, _rq))
            else:
                im = _p / _q
        else:
            im = _p / _q
        #RETURN_COMPLEX(REAL=re; IMAG=im)
        _tmp639 = new(cls)
        _tmp639.real = re
        _tmp639.imag = im
        return _tmp639
    #IF_CHECK_COMPLEX(T=t)
    if t in complextypes_set:
        #DIV_COMPLEX_COMPLEX(LHS=self; RHS=other; MOD=%)
        a, b = self.real, self.imag
        c, d = other.real, other.imag
        mag = c*c + d*d
        _tmp653 = b*c-a*d
        #DIV_VALUE_VALUE(LHS=a*c+b*d; RHS=mag; RESULT=re; MOD=%)
        _p, _q = a*c+b*d, mag
        if not _q:
            raise ZeroDivisionError(repr(a*c+b*d) + " / " + repr(mag))
        #IF_CHECK_INT(T=type(_p))
        if type(_p) in inttypes_set:
            #IF_CHECK_INT(T=type(_q))
            if type(_q) in inttypes_set:
                #FRACTION_NORMALIZE(NUMER=_p; DENOM=_q; RNUMER=_rp; RDENOM=_rq; MOD=%)
                _rp = _x = _p
                _rq = _y = _q
                while 1:
                    _x, _y = _y, _x % _y
                    if not _y:
                        break
                if _x != 1:
                    _rp //= _x
                    _rq //= _x
                re = _rp if _rq == 1 else mpq((_rp, _rq))
            else:
                re = _p / _q
        else:
            re = _p / _q
        if not _tmp653:
            return re
        #DIV_VALUE_VALUE(LHS=_tmp653; RHS=mag; RESULT=im; MOD=%)
        _p, _q = _tmp653, mag
        if not _q:
            raise ZeroDivisionError(repr(_tmp653) + " / " + repr(mag))
        #IF_CHECK_INT(T=type(_p))
        if type(_p) in inttypes_set:
            #IF_CHECK_INT(T=type(_q))
            if type(_q) in inttypes_set:
                #FRACTION_NORMALIZE(NUMER=_p; DENOM=_q; RNUMER=_rp; RDENOM=_rq; MOD=%)
                _rp = _x = _p
                _rq = _y = _q
                while 1:
                    _x, _y = _y, _x % _y
                    if not _y:
                        break
                if _x != 1:
                    _rp //= _x
                    _rq //= _x
                im = _rp if _rq == 1 else mpq((_rp, _rq))
            else:
                im = _p / _q
        else:
            im = _p / _q
        #RETURN_COMPLEX(REAL=re; IMAG=im)
        _tmp716 = new(cls)
        _tmp716.real = re
        _tmp716.imag = im
        return _tmp716
    return NotImplemented

def complex_rdiv(self, other, new=object.__new__, cls=mpqc, realtypes_set=realtypes_set):
    t = type(other)
    #IF_CHECK_REAL(T=t)
    if t in realtypes_set:
        #DIV_REAL_COMPLEX(LHS=other; RHS=self; MOD=%)
        _tmp730 = other
        c, d = self.real, self.imag
        mag = c*c + d*d
        #DIV_VALUE_VALUE(LHS=-_tmp730*d; RHS=mag; RESULT=im; MOD=%)
        _p, _q = -_tmp730*d, mag
        if not _q:
            raise ZeroDivisionError(repr(-_tmp730*d) + " / " + repr(mag))
        #IF_CHECK_INT(T=type(_p))
        if type(_p) in inttypes_set:
            #IF_CHECK_INT(T=type(_q))
            if type(_q) in inttypes_set:
                #FRACTION_NORMALIZE(NUMER=_p; DENOM=_q; RNUMER=_rp; RDENOM=_rq; MOD=%)
                _rp = _x = _p
                _rq = _y = _q
                while 1:
                    _x, _y = _y, _x % _y
                    if not _y:
                        break
                if _x != 1:
                    _rp //= _x
                    _rq //= _x
                im = _rp if _rq == 1 else mpq((_rp, _rq))
            else:
                im = _p / _q
        else:
            im = _p / _q
        #DIV_VALUE_VALUE(LHS= _tmp730*c; RHS=mag; RESULT=re; MOD=%)
        _p, _q = _tmp730*c, mag
        if not _q:
            raise ZeroDivisionError(repr(_tmp730*c) + " / " + repr(mag))
        #IF_CHECK_INT(T=type(_p))
        if type(_p) in inttypes_set:
            #IF_CHECK_INT(T=type(_q))
            if type(_q) in inttypes_set:
                #FRACTION_NORMALIZE(NUMER=_p; DENOM=_q; RNUMER=_rp; RDENOM=_rq; MOD=%)
                _rp = _x = _p
                _rq = _y = _q
                while 1:
                    _x, _y = _y, _x % _y
                    if not _y:
                        break
                if _x != 1:
                    _rp //= _x
                    _rq //= _x
                re = _rp if _rq == 1 else mpq((_rp, _rq))
            else:
                re = _p / _q
        else:
            re = _p / _q
        #RETURN_COMPLEX(REAL=re; IMAG=im)
        _tmp793 = new(cls)
        _tmp793.real = re
        _tmp793.imag = im
        return _tmp793
    if t is complex:
        #DIV_COMPLEX_COMPLEX(LHS=other; RHS=self; MOD=%)
        a, b = other.real, other.imag
        c, d = self.real, self.imag
        mag = c*c + d*d
        _tmp800 = b*c-a*d
        #DIV_VALUE_VALUE(LHS=a*c+b*d; RHS=mag; RESULT=re; MOD=%)
        _p, _q = a*c+b*d, mag
        if not _q:
            raise ZeroDivisionError(repr(a*c+b*d) + " / " + repr(mag))
        #IF_CHECK_INT(T=type(_p))
        if type(_p) in inttypes_set:
            #IF_CHECK_INT(T=type(_q))
            if type(_q) in inttypes_set:
                #FRACTION_NORMALIZE(NUMER=_p; DENOM=_q; RNUMER=_rp; RDENOM=_rq; MOD=%)
                _rp = _x = _p
                _rq = _y = _q
                while 1:
                    _x, _y = _y, _x % _y
                    if not _y:
                        break
                if _x != 1:
                    _rp //= _x
                    _rq //= _x
                re = _rp if _rq == 1 else mpq((_rp, _rq))
            else:
                re = _p / _q
        else:
            re = _p / _q
        if not _tmp800:
            return re
        #DIV_VALUE_VALUE(LHS=_tmp800; RHS=mag; RESULT=im; MOD=%)
        _p, _q = _tmp800, mag
        if not _q:
            raise ZeroDivisionError(repr(_tmp800) + " / " + repr(mag))
        #IF_CHECK_INT(T=type(_p))
        if type(_p) in inttypes_set:
            #IF_CHECK_INT(T=type(_q))
            if type(_q) in inttypes_set:
                #FRACTION_NORMALIZE(NUMER=_p; DENOM=_q; RNUMER=_rp; RDENOM=_rq; MOD=%)
                _rp = _x = _p
                _rq = _y = _q
                while 1:
                    _x, _y = _y, _x % _y
                    if not _y:
                        break
                if _x != 1:
                    _rp //= _x
                    _rq //= _x
                im = _rp if _rq == 1 else mpq((_rp, _rq))
            else:
                im = _p / _q
        else:
            im = _p / _q
        #RETURN_COMPLEX(REAL=re; IMAG=im)
        _tmp863 = new(cls)
        _tmp863.real = re
        _tmp863.imag = im
        return _tmp863
    return NotImplemented

def complex_pow(self, other, m=None, new=object.__new__, cls=mpqc, inttypes_set=inttypes_set):
    t = type(other)
    #IF_CHECK_INT(T=t)
    if t in inttypes_set:
        if not other:
            return 1
        if other==1:
            return self
        if other==2:
            return self*self
        if other < 0:
            base, exponent = 1/self, -other
        else:
            base, exponent = self, other
        #POW_COMPLEX_INT(LHS=base; RHS=exponent; MOD=%)
        a, b = base.real, base.imag
        n = exponent
        if not a:
            case = n % 4
            if not case:
                return b**n
            elif case == 1:
                #RETURN_COMPLEX(REAL=0; IMAG=b**n)
                _tmp884 = new(cls)
                _tmp884.real = 0
                _tmp884.imag = b**n
                return _tmp884
            elif case == 2:
                return -(b**n)
            else:
                #RETURN_COMPLEX(REAL=0; IMAG=-b**n)
                _tmp891 = new(cls)
                _tmp891.real = 0
                _tmp891.imag = -b**n
                return _tmp891
        ta, tb = type(a), type(b)
        m = 1
        if ta is mpq:
            if tb is mpq:
                m = (a[1] * b[1]) ** n
                a, b = a[0]*b[1], a[1]*b[0]
            #ELIF_CHECK_INT(T=tb)
            elif tb in inttypes_set:
                m = a[1] ** n
                a, b = a[0], a[1]*b
        elif tb is mpq:
            #IF_CHECK_INT(T=ta)
            if ta in inttypes_set:
                m = b[1] ** n
                a, b = a*b[1], b[0]
        c, d = 1, 0
        while 1:
            if n & 1:
                c, d = a*c-b*d, b*c+a*d
                n -= 1
                if not n:
                    break
            a, b = a*a-b*b, 2*a*b
            n //= 2
        if m==1:
            #RETURN_COMPLEX2(REAL=c; IMAG=d)
            _tmp912 = d
            if not _tmp912:
                return c
            #RETURN_COMPLEX(REAL=c; IMAG=_tmp912)
            _tmp919 = new(cls)
            _tmp919.real = c
            _tmp919.imag = _tmp912
            return _tmp919
        # c,d,m are integers
        #FRACTION_NORMALIZE(NUMER=c; DENOM=m; RNUMER=re_p; RDENOM=re_q; MOD=%)
        re_p = _x = c
        re_q = _y = m
        while 1:
            _x, _y = _y, _x % _y
            if not _y:
                break
        if _x != 1:
            re_p //= _x
            re_q //= _x
        re = re_p if re_q==1 else mpq((re_p, re_q))
        if not d:
            return re
        #FRACTION_NORMALIZE(NUMER=d; DENOM=m; RNUMER=im_p; RDENOM=im_q; MOD=%)
        im_p = _x = d
        im_q = _y = m
        while 1:
            _x, _y = _y, _x % _y
            if not _y:
                break
        if _x != 1:
            im_p //= _x
            im_q //= _x
        if im_q==1:
            im = im_p
        else:
            im = mpq((im_p, im_q))
        #RETURN_COMPLEX(REAL=re; IMAG=im)
        _tmp940 = new(cls)
        _tmp940.real = re
        _tmp940.imag = im
        return _tmp940
    return NotImplemented
    
def fraction_lt(self, other, cls=mpq, inttypes_set=inttypes_set):
    p, q = self
    t = type(other)
    #IF_CHECK_INT(T=t)
    if t in inttypes_set:
        return (p < q*other)
    elif t is cls:
        r, s = other
        return p*s < q*r
    return NotImplemented
    
def fraction_le(self, other, cls=mpq, inttypes_set=inttypes_set):
    p, q = self
    t = type(other)
    #IF_CHECK_INT(T=t)
    if t in inttypes_set:
        return (p <= q*other)
    elif t is cls:
        r, s = other
        return p*s <= q*r
    return NotImplemented
    
def fraction_gt(self, other, cls=mpq, inttypes_set=inttypes_set):
    p, q = self
    t = type(other)
    #IF_CHECK_INT(T=t)
    if t in inttypes_set:
        return (p > q*other)
    elif t is cls:
        r, s = other
        return p*s > q*r
    return NotImplemented
    
def fraction_ge(self, other, cls=mpq, inttypes_set=inttypes_set):
    p, q = self
    t = type(other)
    #IF_CHECK_INT(T=t)
    if t in inttypes_set:
        return (p >= q*other)
    elif t is cls:
        r, s = other
        return p*s >= q*r
    return NotImplemented
    
