#!/usr/bin/env python
# $Id$
# Copyright (C) 2004,2008 Igor Belyi <belyi@users.sourceforge.net>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Sample of export and import of keys
# It uses keys for joe@foo.bar generated by genkey.pl script

import sys
from pyme import core

core.check_version(None)

expkey = core.Data()
c = core.Context()
c.set_armor(1)
user = "joe@foo.bar"

print " - Export %s's public keys - " % user
c.op_export(user, 0, expkey)

# print out exported data to see how it looks in armor.
expkey.seek(0,0)
expstring = expkey.read()
if expstring:
    print expstring
else:
    print "No %s's keys to export!" % user
    sys.exit(0)


# delete keys to ensure that they came from our imported data.
# Note that since joe's key has private part as well we can only delete
# both of them. As a side effect joe won't have private key for this
# exported public one. If it's Ok with you uncomment the next 4 lines.
#print " - Delete %s's public keys - " % user
#for thekey in [x for x in c.op_keylist_all(user, 0)]:
#    if not thekey.secret:
#        c.op_delete(thekey, 1)


# initialize import data from a string as if it was read from a file.
newkey = core.Data(expstring)

print " - Import exported keys - "
c.op_import(newkey)
result = c.op_import_result()

# show the import result
if result:
    print " - Result of the import - "
    for k in dir(result):
        if not k in result.__dict__ and not k.startswith("_"):
            if k == "imports":
                print k, ":"
                for impkey in result.__getattr__(k):
                    print "    fpr=%s result=%d status=%x" % \
                          (impkey.fpr, impkey.result, impkey.status)
            else:
                print k, ":", result.__getattr__(k)
else:
    print " - No import result - "
