"""
channel layout definitions.
manually crafted because they are implemented as
a bunch of #defines in libavutil <= 52
"""

from enum import IntEnum

AV_CH_FRONT_LEFT = 0x00000001
AV_CH_FRONT_RIGHT = 0x00000002
AV_CH_FRONT_CENTER = 0x00000004
AV_CH_LOW_FREQUENCY = 0x00000008
AV_CH_BACK_LEFT = 0x00000010
AV_CH_BACK_RIGHT = 0x00000020
AV_CH_FRONT_LEFT_OF_CENTER = 0x00000040
AV_CH_FRONT_RIGHT_OF_CENTER = 0x00000080
AV_CH_BACK_CENTER = 0x00000100
AV_CH_SIDE_LEFT = 0x00000200
AV_CH_SIDE_RIGHT = 0x00000400
AV_CH_TOP_CENTER = 0x00000800
AV_CH_TOP_FRONT_LEFT = 0x00001000
AV_CH_TOP_FRONT_CENTER = 0x00002000
AV_CH_TOP_FRONT_RIGHT = 0x00004000
AV_CH_TOP_BACK_LEFT = 0x00008000
AV_CH_TOP_BACK_CENTER = 0x00010000
AV_CH_TOP_BACK_RIGHT = 0x00020000
AV_CH_STEREO_LEFT = 0x20000000
AV_CH_STEREO_RIGHT = 0x40000000
# python2.7 handles the following just fine
AV_CH_WIDE_LEFT = 0x0000000080000000
AV_CH_WIDE_RIGHT = 0x0000000100000000
AV_CH_SURROUND_DIRECT_LEFT = 0x0000000200000000
AV_CH_SURROUND_DIRECT_RIGHT = 0x0000000400000000
AV_CH_LOW_FREQUENCY_2 = 0x0000000800000000


class ChannelLayout(IntEnum):
    """
    Channel Layout definitions.
    """
    AV_CH_LAYOUT_MONO = AV_CH_FRONT_CENTER
    AV_CH_LAYOUT_STEREO = AV_CH_FRONT_LEFT | AV_CH_FRONT_RIGHT
    AV_CH_LAYOUT_2POINT1 = AV_CH_LAYOUT_STEREO | AV_CH_LOW_FREQUENCY
    AV_CH_LAYOUT_2_1 = AV_CH_LAYOUT_STEREO | AV_CH_BACK_CENTER
    AV_CH_LAYOUT_SURROUND = AV_CH_LAYOUT_STEREO | AV_CH_FRONT_CENTER
    AV_CH_LAYOUT_3POINT1 = AV_CH_LAYOUT_SURROUND | AV_CH_LOW_FREQUENCY
    AV_CH_LAYOUT_4POINT0 = AV_CH_LAYOUT_SURROUND | AV_CH_BACK_CENTER
    AV_CH_LAYOUT_4POINT1 = AV_CH_LAYOUT_4POINT0 | AV_CH_LOW_FREQUENCY
    AV_CH_LAYOUT_2_2 = AV_CH_LAYOUT_STEREO | \
        AV_CH_SIDE_LEFT | AV_CH_SIDE_RIGHT
    AV_CH_LAYOUT_QUAD = AV_CH_LAYOUT_STEREO | \
        AV_CH_BACK_LEFT | AV_CH_BACK_RIGHT
    AV_CH_LAYOUT_5POINT0 = AV_CH_LAYOUT_SURROUND | \
        AV_CH_SIDE_LEFT | AV_CH_SIDE_RIGHT
    AV_CH_LAYOUT_5POINT1 = AV_CH_LAYOUT_5POINT0 | AV_CH_LOW_FREQUENCY
    AV_CH_LAYOUT_5POINT0_BACK = AV_CH_LAYOUT_SURROUND | \
        AV_CH_BACK_LEFT | AV_CH_BACK_RIGHT
    AV_CH_LAYOUT_5POINT1_BACK = AV_CH_LAYOUT_5POINT0_BACK | \
        AV_CH_LOW_FREQUENCY
    AV_CH_LAYOUT_6POINT0 = AV_CH_LAYOUT_5POINT0 | AV_CH_BACK_CENTER
    AV_CH_LAYOUT_6POINT0_FRONT = AV_CH_LAYOUT_2_2 | \
        AV_CH_FRONT_LEFT_OF_CENTER | AV_CH_FRONT_RIGHT_OF_CENTER
    AV_CH_LAYOUT_HEXAGONAL = AV_CH_LAYOUT_5POINT0_BACK | AV_CH_BACK_CENTER
    AV_CH_LAYOUT_6POINT1 = AV_CH_LAYOUT_5POINT1 | AV_CH_BACK_CENTER
    AV_CH_LAYOUT_6POINT1_BACK = AV_CH_LAYOUT_5POINT1_BACK | AV_CH_BACK_CENTER
    AV_CH_LAYOUT_6POINT1_FRONT = AV_CH_LAYOUT_6POINT0_FRONT | \
        AV_CH_LOW_FREQUENCY
    AV_CH_LAYOUT_7POINT0 = AV_CH_LAYOUT_5POINT0 | \
        AV_CH_BACK_LEFT | AV_CH_BACK_RIGHT
    AV_CH_LAYOUT_7POINT0_FRONT = AV_CH_LAYOUT_5POINT0 | \
        AV_CH_FRONT_LEFT_OF_CENTER | AV_CH_FRONT_RIGHT_OF_CENTER
    AV_CH_LAYOUT_7POINT1 = AV_CH_LAYOUT_5POINT1 | \
        AV_CH_BACK_LEFT | AV_CH_BACK_RIGHT
    AV_CH_LAYOUT_7POINT1_WIDE = AV_CH_LAYOUT_5POINT1 | \
        AV_CH_FRONT_LEFT_OF_CENTER | AV_CH_FRONT_RIGHT_OF_CENTER
    AV_CH_LAYOUT_7POINT1_WIDE_BACK = AV_CH_LAYOUT_5POINT1_BACK | \
        AV_CH_FRONT_LEFT_OF_CENTER | AV_CH_FRONT_RIGHT_OF_CENTER
    AV_CH_LAYOUT_OCTAGONAL = AV_CH_LAYOUT_5POINT0 | \
        AV_CH_BACK_LEFT | AV_CH_BACK_CENTER | AV_CH_BACK_RIGHT
    AV_CH_LAYOUT_STEREO_DOWNMIX = AV_CH_STEREO_LEFT | AV_CH_STEREO_RIGHT
