#!/usr/bin/env python
from setuptools import setup, Extension

VERSION_INFO = (1, 2, 0)
DATE_INFO = (2013, 2,  10)  # YEAR, MONTH, DAY
VERSION = '.'.join(str(i) for i in VERSION_INFO)
REVISION = '%04d%02d%02d' % DATE_INFO
BUILD_INFO = "MMSeg v" + VERSION + " (" + REVISION + ")"
AUTHOR = "pluskid & kronuz & zsp007"
AUTHOR_EMAIL = 'pluskid@gmail.com'
URL = 'http://github.com/pluskid/pymmseg-cpp'
DOWNLOAD_URL = 'https://github.com/pluskid/pymmseg-cpp/archive/master.tar.gz'
LICENSE = "MIT"
PROJECT = "pymmseg"


def read(fname):
    import os
    try:
        return open(os.path.join(os.path.dirname(__file__), fname)).read().strip()
    except IOError:
        return ''


extra = {}
import sys
if sys.version_info >= (3, 0):
    extra.update(
        use_2to3=True,
    )

setup(name=PROJECT,
    version=VERSION,
    description=read('DESCRIPTION'),
    long_description=read('README'),
    author=AUTHOR,
    author_email=AUTHOR_EMAIL,
    url=URL,
    download_url=DOWNLOAD_URL,
    license=LICENSE,
    keywords='mmseg chinese word segmentation tokenization',
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Topic :: Text Processing",
        "Topic :: Software Development :: Libraries :: Python Modules"
    ],
    packages=['mmseg'],
    ext_modules=[
        Extension(
            'mmseg._mmseg',
            sources=['mmseg/mmseg-cpp/mmseg.cpp', 'mmseg/mmseg-cpp/algor.cpp', 'mmseg/mmseg-cpp/dict.cpp', 'mmseg/mmseg-cpp/memory.cpp'],
            include_dirs=['mmseg/mmseg-cpp']
        )
    ],
    package_data={'mmseg': ['data/*.dic']},
    scripts=['bin/pymmseg'],
    **extra
)
