from PyObjCTools.TestSupport import *
from CFNetwork import *


class TestCFNetwork (TestCase):

    @min_os_level('10.5')
    def testConstants10_5(self):
        self.failUnlessIsInstance(kCFErrorDomainCFNetwork, unicode)
        self.failUnlessIsInstance(kCFErrorDomainWinSock, unicode)
        self.failUnlessIsInstance(kCFGetAddrInfoFailureKey, unicode)
        self.failUnlessIsInstance(kCFSOCKSStatusCodeKey, unicode)
        self.failUnlessIsInstance(kCFSOCKSVersionKey, unicode)
        self.failUnlessIsInstance(kCFSOCKSNegotiationMethodKey, unicode)
        self.failUnlessIsInstance(kCFDNSServiceFailureKey, unicode)
        self.failUnlessIsInstance(kCFFTPStatusCodeKey, unicode)

    @min_os_level('10.6')
    def testConstants10_6(self):
        self.failUnlessEqual(kCFErrorPACFileAuth, 309)
        self.failUnlessEqual(kCFErrorHTTPSProxyConnectionFailure, 310)

        self.failUnlessEqual(kCFURLErrorUnknown, -998)
        self.failUnlessEqual(kCFURLErrorCancelled, -999)
        self.failUnlessEqual(kCFURLErrorBadURL, -1000)
        self.failUnlessEqual(kCFURLErrorTimedOut, -1001)
        self.failUnlessEqual(kCFURLErrorUnsupportedURL, -1002)
        self.failUnlessEqual(kCFURLErrorCannotFindHost, -1003)
        self.failUnlessEqual(kCFURLErrorCannotConnectToHost, -1004)
        self.failUnlessEqual(kCFURLErrorNetworkConnectionLost, -1005)
        self.failUnlessEqual(kCFURLErrorDNSLookupFailed, -1006)
        self.failUnlessEqual(kCFURLErrorHTTPTooManyRedirects, -1007)
        self.failUnlessEqual(kCFURLErrorResourceUnavailable, -1008)
        self.failUnlessEqual(kCFURLErrorNotConnectedToInternet, -1009)
        self.failUnlessEqual(kCFURLErrorRedirectToNonExistentLocation, -1010)
        self.failUnlessEqual(kCFURLErrorBadServerResponse, -1011)
        self.failUnlessEqual(kCFURLErrorUserCancelledAuthentication, -1012)
        self.failUnlessEqual(kCFURLErrorUserAuthenticationRequired, -1013)
        self.failUnlessEqual(kCFURLErrorZeroByteResource, -1014)
        self.failUnlessEqual(kCFURLErrorCannotDecodeRawData, -1015)
        self.failUnlessEqual(kCFURLErrorCannotDecodeContentData, -1016)
        self.failUnlessEqual(kCFURLErrorCannotParseResponse, -1017)
        self.failUnlessEqual(kCFURLErrorInternationalRoamingOff, -1018)
        self.failUnlessEqual(kCFURLErrorCallIsActive, -1019)
        self.failUnlessEqual(kCFURLErrorDataNotAllowed, -1020)
        self.failUnlessEqual(kCFURLErrorRequestBodyStreamExhausted, -1021)
        self.failUnlessEqual(kCFURLErrorFileDoesNotExist, -1100)
        self.failUnlessEqual(kCFURLErrorFileIsDirectory, -1101)
        self.failUnlessEqual(kCFURLErrorNoPermissionsToReadFile, -1102)
        self.failUnlessEqual(kCFURLErrorDataLengthExceedsMaximum, -1103)
        self.failUnlessEqual(kCFURLErrorSecureConnectionFailed, -1200)
        self.failUnlessEqual(kCFURLErrorServerCertificateHasBadDate, -1201)
        self.failUnlessEqual(kCFURLErrorServerCertificateUntrusted, -1202)
        self.failUnlessEqual(kCFURLErrorServerCertificateHasUnknownRoot, -1203)
        self.failUnlessEqual(kCFURLErrorServerCertificateNotYetValid, -1204)
        self.failUnlessEqual(kCFURLErrorClientCertificateRejected, -1205)
        self.failUnlessEqual(kCFURLErrorClientCertificateRequired, -1206)
        self.failUnlessEqual(kCFURLErrorCannotLoadFromNetwork, -2000)
        self.failUnlessEqual(kCFURLErrorCannotCreateFile, -3000)
        self.failUnlessEqual(kCFURLErrorCannotOpenFile, -3001)
        self.failUnlessEqual(kCFURLErrorCannotCloseFile, -3002)
        self.failUnlessEqual(kCFURLErrorCannotWriteToFile, -3003)
        self.failUnlessEqual(kCFURLErrorCannotRemoveFile, -3004)
        self.failUnlessEqual(kCFURLErrorCannotMoveFile, -3005)
        self.failUnlessEqual(kCFURLErrorDownloadDecodingFailedMidStream, -3006)
        self.failUnlessEqual(kCFURLErrorDownloadDecodingFailedToComplete, -3007)
        self.failUnlessEqual(kCFHTTPCookieCannotParseCookieFile, -4000)

        self.failUnlessIsInstance(kCFURLErrorFailingURLErrorKey, unicode)
        self.failUnlessIsInstance(kCFURLErrorFailingURLStringErrorKey, unicode)


    def testConstants(self):
        self.failUnlessEqual(kCFHostErrorHostNotFound, 1)
        self.failUnlessEqual(kCFHostErrorUnknown, 2)
        self.failUnlessEqual(kCFSOCKSErrorUnknownClientVersion, 100)
        self.failUnlessEqual(kCFSOCKSErrorUnsupportedServerVersion, 101)
        self.failUnlessEqual(kCFSOCKS4ErrorRequestFailed, 110)
        self.failUnlessEqual(kCFSOCKS4ErrorIdentdFailed, 111)
        self.failUnlessEqual(kCFSOCKS4ErrorIdConflict, 112)
        self.failUnlessEqual(kCFSOCKS4ErrorUnknownStatusCode, 113)
        self.failUnlessEqual(kCFSOCKS5ErrorBadState, 120)
        self.failUnlessEqual(kCFSOCKS5ErrorBadResponseAddr, 121)
        self.failUnlessEqual(kCFSOCKS5ErrorBadCredentials, 122)
        self.failUnlessEqual(kCFSOCKS5ErrorUnsupportedNegotiationMethod, 123)
        self.failUnlessEqual(kCFSOCKS5ErrorNoAcceptableMethod, 124)
        self.failUnlessEqual(kCFNetServiceErrorUnknown, -72000)
        self.failUnlessEqual(kCFNetServiceErrorCollision, -72001)
        self.failUnlessEqual(kCFNetServiceErrorNotFound, -72002)
        self.failUnlessEqual(kCFNetServiceErrorInProgress, -72003)
        self.failUnlessEqual(kCFNetServiceErrorBadArgument, -72004)
        self.failUnlessEqual(kCFNetServiceErrorCancel, -72005)
        self.failUnlessEqual(kCFNetServiceErrorInvalid, -72006)
        self.failUnlessEqual(kCFNetServiceErrorTimeout, -72007)
        self.failUnlessEqual(kCFNetServiceErrorDNSServiceFailure, -73000)
        self.failUnlessEqual(kCFFTPErrorUnexpectedStatusCode, 200)
        self.failUnlessEqual(kCFErrorHTTPAuthenticationTypeUnsupported, 300)
        self.failUnlessEqual(kCFErrorHTTPBadCredentials, 301)
        self.failUnlessEqual(kCFErrorHTTPConnectionLost, 302)
        self.failUnlessEqual(kCFErrorHTTPParseFailure, 303)
        self.failUnlessEqual(kCFErrorHTTPRedirectionLoopDetected, 304)
        self.failUnlessEqual(kCFErrorHTTPBadURL, 305)
        self.failUnlessEqual(kCFErrorHTTPProxyConnectionFailure, 306)
        self.failUnlessEqual(kCFErrorHTTPBadProxyCredentials, 307)
        self.failUnlessEqual(kCFErrorPACFileError, 308)

if __name__ == "__main__":
    main()
