''' 
Wrappers for the core Cocoa frameworks: CoreFoundation, Foundation and
AppKit.

These wrappers don't include documentation, please check Apple's documention
for information on how to use these frameworks and PyObjC's documentation
for general tips and tricks regarding the translation between Python
and (Objective-)C frameworks
'''
from pyobjc_setup import setup, Extension

setup(
    name='pyobjc-framework-Cocoa',
    version='2.2',
    description = "Wrappers for the Cocoa frameworks on Mac OS X",
    packages = [ "Cocoa", "CoreFoundation", "Foundation", "AppKit", "PyObjCTools" ],
    namespace_packages = ['PyObjCTools'],
    install_requires = [ 
        'pyobjc-core>=2.2',
    ],
    ext_modules = [
        # CoreFoundation
        Extension('CoreFoundation._inlines', 
                [ 'Modules/_CoreFoundation_inlines.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFCalendar', 
                [ 'Modules/_CoreFoundation_CFCalendar.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFTree', 
                [ 'Modules/_CoreFoundation_CFTree.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFBag', 
                [ 'Modules/_CoreFoundation_CFBag.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFBinaryHeap', 
                [ 'Modules/_CoreFoundation_CFBinaryHeap.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFBitVector', 
                [ 'Modules/_CoreFoundation_CFBitVector.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFDictionary', 
                [ 'Modules/_CoreFoundation_CFDictionary.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFFileDescriptor', 
                [ 'Modules/_CoreFoundation_CFFileDescriptor.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFMachPort', 
                [ 'Modules/_CoreFoundation_CFMachPort.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFMessagePort', 
                [ 'Modules/_CoreFoundation_CFMessagePort.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFNumber', 
                [ 'Modules/_CoreFoundation_CFNumber.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFReadStream', 
                [ 'Modules/_CoreFoundation_CFReadStream.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFSet', 
                [ 'Modules/_CoreFoundation_CFSet.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFSocket', 
                [ 'Modules/_CoreFoundation_CFSocket.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFWriteStream', 
                [ 'Modules/_CoreFoundation_CFWriteStream.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFRunLoopObserver', 
                [ 'Modules/_CoreFoundation_CFRunLoopObserver.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFRunLoopSource', 
                [ 'Modules/_CoreFoundation_CFRunLoopSource.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),
        Extension('CoreFoundation._CFRunLoopTimer', 
                [ 'Modules/_CoreFoundation_CFRunLoopTimer.m' ],
                extra_link_args=['-framework', 'CoreFoundation']),

        # Foundation
        Extension('Foundation._nsinvocation', 
                [ 'Modules/_Foundation_NSInvocation.m' ],
                extra_link_args=['-framework', 'Foundation']),
        Extension('Foundation._NSDecimal', 
                [ 'Modules/_Foundation_NSDecimal.m' ],
                extra_link_args=['-framework', 'Foundation']),
        Extension('Foundation._nscoder', 
                [ 'Modules/_Foundation_nscoder.m' ],
                extra_link_args=['-framework', 'Foundation']),
        Extension('Foundation._typecode', 
                [ 'Modules/_Foundation_typecode.m' ],
                extra_link_args=['-framework', 'Foundation']),
        Extension('Foundation._inlines', 
                [ 'Modules/_Foundation_inlines.m' ],
                extra_link_args=['-framework', 'Foundation']),
        Extension('Foundation._data', 
                [ 'Modules/_Foundation_data.m' ],
                extra_link_args=['-framework', 'Foundation']),
        Extension('Foundation._netservice', 
                [ 'Modules/_Foundation_netservice.m' ],
                extra_link_args=['-framework', 'Foundation']),
        Extension('Foundation._string', 
                [ 'Modules/_Foundation_string.m' ],
                extra_link_args=['-framework', 'Foundation']),

        # AppKit
        Extension("AppKit._inlines",
            [ "Modules/_AppKit_inlines.m" ],
            extra_link_args=["-framework", "AppKit"]),
        Extension("AppKit._appmain",
            [ "Modules/_AppKit_appmain.m" ],
            extra_link_args=["-framework", "AppKit"]),
        Extension("AppKit._nsfont",
            [ "Modules/_AppKit_nsfont.m"],
            extra_link_args=["-framework", "AppKit"]),
        Extension("AppKit._nsquickdrawview",
            [ "Modules/_AppKit_nsquickdrawview.m"],
            extra_link_args=["-framework", "AppKit"]),
        Extension("AppKit._nsbezierpath",
            [ "Modules/_AppKit_nsbezierpath.m"],
            extra_link_args=["-framework", "AppKit"]),
        Extension("AppKit._nsview",
            [ "Modules/_AppKit_nsview.m"],
            extra_link_args=["-framework", "AppKit"]),
        Extension("AppKit._nsbitmap",
            [ "Modules/_AppKit_nsbitmap.m"],
            extra_link_args=["-framework", "AppKit"]),
        Extension("AppKit._nswindow",
            [ "Modules/_AppKit_nswindow.m"],
            extra_link_args=["-framework", "AppKit"]),
        Extension("AppKit._carbon",
            [ "Modules/_AppKit_carbon.m"],
            extra_link_args=["-framework", "AppKit"]),


        #
        # Test support
        #
        Extension("PyObjCTest.testhelper",
            [ "Modules/testhelper.m"],
            extra_link_args=["-framework", "Foundation"]),
    ],
)
