
from PyObjCTools.TestSupport import *
from AppKit import *

class TestNSGraphics (TestCase):
    def testConstants(self):
        self.failUnlessEqual(NSCompositeClear, 0)
        self.failUnlessEqual(NSCompositeCopy, 1)
        self.failUnlessEqual(NSCompositeSourceOver, 2)
        self.failUnlessEqual(NSCompositeSourceIn, 3)
        self.failUnlessEqual(NSCompositeSourceOut, 4)
        self.failUnlessEqual(NSCompositeSourceAtop, 5)
        self.failUnlessEqual(NSCompositeDestinationOver, 6)
        self.failUnlessEqual(NSCompositeDestinationIn, 7)
        self.failUnlessEqual(NSCompositeDestinationOut, 8)
        self.failUnlessEqual(NSCompositeDestinationAtop, 9)
        self.failUnlessEqual(NSCompositeXOR, 10)
        self.failUnlessEqual(NSCompositePlusDarker, 11)
        self.failUnlessEqual(NSCompositeHighlight, 12)
        self.failUnlessEqual(NSCompositePlusLighter, 13)
        self.failUnlessEqual(NSBackingStoreRetained, 0)
        self.failUnlessEqual(NSBackingStoreNonretained, 1)
        self.failUnlessEqual(NSBackingStoreBuffered, 2)
        self.failUnlessEqual(NSWindowAbove,  1)
        self.failUnlessEqual(NSWindowBelow, -1)
        self.failUnlessEqual(NSWindowOut,  0)
        self.failUnlessEqual(NSFocusRingOnly, 0)
        self.failUnlessEqual(NSFocusRingBelow, 1)
        self.failUnlessEqual(NSFocusRingAbove, 2)
        self.failUnlessEqual(NSFocusRingTypeDefault, 0)
        self.failUnlessEqual(NSFocusRingTypeNone, 1)
        self.failUnlessEqual(NSFocusRingTypeExterior, 2)

        self.failUnlessIsInstance(NSCalibratedWhiteColorSpace, unicode)
        self.failUnlessIsInstance(NSCalibratedBlackColorSpace, unicode)
        self.failUnlessIsInstance(NSCalibratedRGBColorSpace, unicode)
        self.failUnlessIsInstance(NSDeviceWhiteColorSpace, unicode)
        self.failUnlessIsInstance(NSDeviceBlackColorSpace, unicode)
        self.failUnlessIsInstance(NSDeviceRGBColorSpace, unicode)
        self.failUnlessIsInstance(NSDeviceCMYKColorSpace, unicode)
        self.failUnlessIsInstance(NSNamedColorSpace, unicode)
        self.failUnlessIsInstance(NSPatternColorSpace, unicode)
        self.failUnlessIsInstance(NSCustomColorSpace, unicode)
        self.failUnlessIsInstance(NSWhite, float)
        self.failUnlessIsInstance(NSLightGray, float)
        self.failUnlessIsInstance(NSDarkGray, float)
        self.failUnlessIsInstance(NSBlack, float)

        self.failUnlessIsInstance(NSDeviceResolution, unicode)
        self.failUnlessIsInstance(NSDeviceColorSpaceName, unicode)
        self.failUnlessIsInstance(NSDeviceBitsPerSample, unicode)
        self.failUnlessIsInstance(NSDeviceIsScreen, unicode)
        self.failUnlessIsInstance(NSDeviceIsPrinter, unicode)
        self.failUnlessIsInstance(NSDeviceSize, unicode)
        self.failUnlessEqual(NSAnimationEffectDisappearingItemDefault, 0)
        self.failUnlessEqual(NSAnimationEffectPoof, 10)


    def testFunctions(self):
        self.fail("APPKIT_EXTERN NSWindowDepth NSBestDepth (NSString *colorSpace, NSInteger bps, NSInteger bpp, BOOL planar, BOOL *exactMatch);")
        self.fail("APPKIT_EXTERN BOOL NSPlanarFromDepth (NSWindowDepth depth);")
        self.fail("APPKIT_EXTERN NSString *NSColorSpaceFromDepth (NSWindowDepth depth);")
        self.fail("APPKIT_EXTERN NSInteger NSBitsPerSampleFromDepth(NSWindowDepth depth);")
        self.fail("APPKIT_EXTERN NSInteger NSBitsPerPixelFromDepth(NSWindowDepth depth);")
        self.fail("APPKIT_EXTERN NSInteger NSNumberOfColorComponents(NSString *colorSpaceName);")
        self.fail("APPKIT_EXTERN const NSWindowDepth *NSAvailableWindowDepths (void); /* 0 terminated */")

        self.fail("APPKIT_EXTERN void NSRectFill(NSRect aRect);")
        self.fail("APPKIT_EXTERN void NSRectFillList(const NSRect *rects, NSInteger count);")
        self.fail("APPKIT_EXTERN void NSRectFillListWithGrays(const NSRect *rects, const CGFloat *grays, NSInteger num);")
        self.fail("APPKIT_EXTERN void NSRectFillListWithColors(const NSRect *rects, NSColor **colors, NSInteger num);")
        self.fail("APPKIT_EXTERN void NSRectFillUsingOperation(NSRect aRect, NSCompositingOperation op);")
        self.fail("APPKIT_EXTERN void NSRectFillListUsingOperation(const NSRect *rects, NSInteger count, NSCompositingOperation op);")
        self.fail("APPKIT_EXTERN void NSRectFillListWithColorsUsingOperation(const NSRect *rects, NSColor **colors, NSInteger num, NSCompositingOperation op);")
        self.fail("APPKIT_EXTERN void NSFrameRect(NSRect aRect);")
        self.fail("APPKIT_EXTERN void NSFrameRectWithWidth(NSRect aRect, CGFloat frameWidth);")
        self.fail("APPKIT_EXTERN void NSFrameRectWithWidthUsingOperation(NSRect aRect, CGFloat frameWidth, NSCompositingOperation op);")
        self.fail("APPKIT_EXTERN void NSRectClip(NSRect aRect);")
        self.fail("APPKIT_EXTERN void NSRectClipList(const NSRect *rects, NSInteger count);")
        self.fail("APPKIT_EXTERN NSRect NSDrawTiledRects(NSRect boundsRect, NSRect clipRect, const NSRectEdge *sides, const CGFloat *grays, NSInteger count);")
        self.fail("APPKIT_EXTERN void NSDrawGrayBezel(NSRect aRect, NSRect clipRect);")
        self.fail("APPKIT_EXTERN void NSDrawGroove(NSRect aRect, NSRect clipRect);")
        self.fail("APPKIT_EXTERN void NSDrawWhiteBezel(NSRect aRect, NSRect clipRect);")
        self.fail("APPKIT_EXTERN void NSDrawButton(NSRect aRect, NSRect clipRect);")
        self.fail("APPKIT_EXTERN void NSEraseRect(NSRect aRect);")
        self.fail("APPKIT_EXTERN NSColor *NSReadPixel(NSPoint passedPoint);")
        self.fail("APPKIT_EXTERN void NSDrawBitmap(NSRect rect, NSInteger width, NSInteger height, NSInteger bps, NSInteger spp, NSInteger bpp, NSInteger bpr, BOOL isPlanar, BOOL hasAlpha, NSString *colorSpaceName, const unsigned char *const data[5]);")
        self.fail("APPKIT_EXTERN void NSCopyBits(NSInteger srcGState, NSRect srcRect, NSPoint destPoint);")
        self.fail("APPKIT_EXTERN void NSHighlightRect(NSRect aRect);")
        self.fail("APPKIT_EXTERN void NSBeep(void);")
        self.fail("APPKIT_EXTERN void NSCountWindows(NSInteger *count);")
        self.fail("APPKIT_EXTERN void NSWindowList(NSInteger size, NSInteger list[]);")
        self.fail("APPKIT_EXTERN void NSCountWindowsForContext(NSInteger context, NSInteger *count);")
        self.fail("APPKIT_EXTERN void NSWindowListForContext(NSInteger context, NSInteger size, NSInteger list[]);")

        self.fail("APPKIT_EXTERN NSInteger NSGetWindowServerMemory(NSInteger context, NSInteger *virtualMemory, NSInteger *windowBackingMemory, NSString **windowDumpString);")

        self.fail("APPKIT_EXTERN NSRect NSDrawColorTiledRects(NSRect boundsRect, NSRect clipRect, const NSRectEdge *sides, NSColor **colors, NSInteger count);")
        self.fail("APPKIT_EXTERN void NSDrawDarkBezel(NSRect aRect, NSRect clipRect);")
        self.fail("APPKIT_EXTERN void NSDrawLightBezel(NSRect aRect, NSRect clipRect);")
        self.fail("APPKIT_EXTERN void NSDottedFrameRect(NSRect aRect);")
        self.fail("APPKIT_EXTERN void NSDrawWindowBackground(NSRect aRect);")
        self.fail("APPKIT_EXTERN void NSSetFocusRingStyle(NSFocusRingPlacement placement);")

        self.fail("APPKIT_EXTERN void NSDisableScreenUpdates(void)	AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER;")
        self.fail("APPKIT_EXTERN void NSEnableScreenUpdates(void)	AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER;")
        self.fail("APPKIT_EXTERN void NSShowAnimationEffect(NSAnimationEffect animationEffect, NSPoint centerLocation, NSSize size, id animationDelegate, SEL didEndSelector, void *contextInfo) AVAILABLE_MAC_OS_X_VERSION_10_3_AND_LATER;")


if __name__ == "__main__":
    main()
