
from PyObjCTools.TestSupport import *
from AppKit import *

class TestNSDocument (TestCase):
    def testConstants(self):
        self.failUnlessEqual(NSChangeDone, 0)
        self.failUnlessEqual(NSChangeUndone, 1)
        self.failUnlessEqual(NSChangeCleared, 2)
        self.failUnlessEqual(NSChangeRedone, 5)
        self.failUnlessEqual(NSChangeReadOtherContents, 3)
        self.failUnlessEqual(NSChangeAutosaved, 4)

        self.failUnlessEqual(NSSaveOperation, 0)
        self.failUnlessEqual(NSSaveAsOperation, 1)
        self.failUnlessEqual(NSSaveToOperation, 2)
        self.failUnlessEqual(NSAutosaveOperation, 3)

    def testMethods(self):
        self.failUnlessArgIsOut(NSDocument.initWithType_error_, 1)
        self.failUnlessArgIsOut(NSDocument.initWithContentsOfURL_ofType_error_, 2)
        self.failUnlessArgIsOut(NSDocument.initForURL_withContentsOfURL_ofType_error_, 3)
        self.failUnlessResultIsBOOL(NSDocument.revertToContentsOfURL_ofType_error_)
        self.failUnlessArgIsOut(NSDocument.revertToContentsOfURL_ofType_error_, 2)
        self.failUnlessResultIsBOOL(NSDocument.readFromURL_ofType_error_)
        self.failUnlessArgIsOut(NSDocument.readFromURL_ofType_error_, 2)
        self.failUnlessResultIsBOOL(NSDocument.readFromFileWrapper_ofType_error_)
        self.failUnlessArgIsOut(NSDocument.readFromFileWrapper_ofType_error_, 2)
        self.failUnlessResultIsBOOL(NSDocument.readFromData_ofType_error_)
        self.failUnlessArgIsOut(NSDocument.readFromData_ofType_error_, 2)
        self.failUnlessResultIsBOOL(NSDocument.writeToURL_ofType_error_)
        self.failUnlessArgIsOut(NSDocument.writeToURL_ofType_error_, 2)
        self.failUnlessArgIsOut(NSDocument.fileWrapperOfType_error_, 1)
        self.failUnlessArgIsOut(NSDocument.dataOfType_error_, 1)
        self.failUnlessResultIsBOOL(NSDocument.writeSafelyToURL_ofType_forSaveOperation_error_)
        self.failUnlessArgIsOut(NSDocument.writeSafelyToURL_ofType_forSaveOperation_error_, 3)
        self.failUnlessResultIsBOOL(NSDocument.writeToURL_ofType_forSaveOperation_originalContentsURL_error_)
        self.failUnlessArgIsOut(NSDocument.writeToURL_ofType_forSaveOperation_originalContentsURL_error_, 4)
        self.failUnlessArgIsOut(NSDocument.fileAttributesToWriteToURL_ofType_forSaveOperation_originalContentsURL_error_, 4)
        self.failUnlessResultIsBOOL(NSDocument.keepBackupFile)
        self.failUnlessArgIsSEL(NSDocument.saveDocumentWithDelegate_didSaveSelector_contextInfo_, 1, "v@:@"+objc._C_NSBOOL+"^v")
        self.failUnlessArgHasType(NSDocument.saveDocumentWithDelegate_didSaveSelector_contextInfo_, 2, "^v")
        self.failUnlessArgIsSEL(NSDocument.runModalSavePanelForSaveOperation_delegate_didSaveSelector_contextInfo_, 2, "v@:@"+objc._C_NSBOOL+"^v")
        self.failUnlessArgHasType(NSDocument.runModalSavePanelForSaveOperation_delegate_didSaveSelector_contextInfo_, 3, "^v")
        self.failUnlessResultIsBOOL(NSDocument.shouldRunSavePanelWithAccessoryView)
        self.failUnlessResultIsBOOL(NSDocument.prepareSavePanel_)
        self.failUnlessResultIsBOOL(NSDocument.fileNameExtensionWasHiddenInLastRunSavePanel)
        self.failUnlessArgIsSEL(NSDocument.saveToURL_ofType_forSaveOperation_delegate_didSaveSelector_contextInfo_, 4, "v@:@"+objc._C_NSBOOL+"^v")
        self.failUnlessArgHasType(NSDocument.saveToURL_ofType_forSaveOperation_delegate_didSaveSelector_contextInfo_, 5, "^v")
        self.failUnlessResultIsBOOL(NSDocument.saveToURL_ofType_forSaveOperation_error_)
        self.failUnlessArgIsOut(NSDocument.saveToURL_ofType_forSaveOperation_error_, 3)
        self.failUnlessResultIsBOOL(NSDocument.hasUnautosavedChanges)
        self.failUnlessArgIsSEL(NSDocument.autosaveDocumentWithDelegate_didAutosaveSelector_contextInfo_, 1, "v@:@"+objc._C_NSBOOL+"^v")
        self.failUnlessArgHasType(NSDocument.autosaveDocumentWithDelegate_didAutosaveSelector_contextInfo_, 2, "^v")
        self.failUnlessArgIsSEL(NSDocument.canCloseDocumentWithDelegate_shouldCloseSelector_contextInfo_, 1, "v@:@"+objc._C_NSBOOL+"^v")
        self.failUnlessArgHasType(NSDocument.canCloseDocumentWithDelegate_shouldCloseSelector_contextInfo_, 2, "^v")
        self.failUnlessArgIsSEL(NSDocument.runModalPageLayoutWithPrintInfo_delegate_didRunSelector_contextInfo_, 2, "v@:@"+objc._C_NSBOOL+"^v")
        self.failUnlessArgHasType(NSDocument.runModalPageLayoutWithPrintInfo_delegate_didRunSelector_contextInfo_, 3, "^v")
        self.failUnlessResultIsBOOL(NSDocument.preparePageLayout_)
        self.failUnlessResultIsBOOL(NSDocument.shouldChangePrintInfo_)
        self.failUnlessArgIsSEL(NSDocument.printDocumentWithSettings_showPrintPanel_delegate_didPrintSelector_contextInfo_, 3, "v@:@"+objc._C_NSBOOL+"^v")
        self.failUnlessArgHasType(NSDocument.printDocumentWithSettings_showPrintPanel_delegate_didPrintSelector_contextInfo_, 4, "^v")
        self.failUnlessArgIsOut(NSDocument.printOperationWithSettings_error_, 1)
        self.failUnlessArgIsSEL(NSDocument.runModalPrintOperation_delegate_didRunSelector_contextInfo_, 2, "v@:@"+objc._C_NSBOOL+"^v")
        self.failUnlessArgHasType(NSDocument.runModalPrintOperation_delegate_didRunSelector_contextInfo_, 3, "^v")
        self.failUnlessResultIsBOOL(NSDocument.isDocumentEdited)
        self.failUnlessResultIsBOOL(NSDocument.hasUndoManager)
        self.failUnlessArgIsBOOL(NSDocument.setHasUndoManager_, 0)
        self.failUnlessResultIsBOOL(NSDocument.presentError_)
        self.failUnlessArgIsSEL(NSDocument.presentError_modalForWindow_delegate_didPresentSelector_contextInfo_, 3, "v@:"+objc._C_NSBOOL+"^v")
        self.failUnlessArgHasType(NSDocument.presentError_modalForWindow_delegate_didPresentSelector_contextInfo_, 4, "^v")
        self.failUnlessArgIsSEL(NSDocument.shouldCloseWindowController_delegate_shouldCloseSelector_contextInfo_, 2, "v@:@"+objc._C_NSBOOL+"^v")
        self.failUnlessArgHasType(NSDocument.shouldCloseWindowController_delegate_shouldCloseSelector_contextInfo_, 3, "^v")
        self.failUnlessResultIsBOOL(NSDocument.isNativeType_)
        self.failUnlessResultIsBOOL(NSDocument.validateUserInterfaceItem_)
        self.failUnlessResultIsBOOL(NSDocument.loadDataRepresentation_ofType_)
        self.failUnlessArgIsBOOL(NSDocument.printShowingPrintPanel_, 0)
        self.failUnlessResultIsBOOL(NSDocument.readFromFile_ofType_)
        self.failUnlessResultIsBOOL(NSDocument.readFromURL_ofType_)
        self.failUnlessResultIsBOOL(NSDocument.revertToSavedFromFile_ofType_)
        self.failUnlessResultIsBOOL(NSDocument.revertToSavedFromURL_ofType_)
        self.failUnlessResultIsBOOL(NSDocument.writeToFile_ofType_)
        self.failUnlessResultIsBOOL(NSDocument.writeToFile_ofType_originalFile_saveOperation_)
        self.failUnlessResultIsBOOL(NSDocument.writeToURL_ofType_)
        self.failUnlessResultIsBOOL(NSDocument.writeWithBackupToFile_ofType_saveOperation_)
        self.failUnlessArgIsSEL(NSDocument.saveToFile_saveOperation_delegate_didSaveSelector_contextInfo_, 3, 'v@:@'+objc._C_NSBOOL+'^v')
        self.failUnlessArgHasType(NSDocument.saveToFile_saveOperation_delegate_didSaveSelector_contextInfo_, 4, '^v')

if __name__ == "__main__":
    main()
