from PyObjCTools.TestSupport import *
from AppKit import *

class TestNSEvent (TestCase):
    def testConstants(self):
        self.failUnlessEqual(NSLeftMouseDown, 1)
        self.failUnlessEqual(NSLeftMouseUp, 2)
        self.failUnlessEqual(NSRightMouseDown, 3)
        self.failUnlessEqual(NSRightMouseUp, 4)
        self.failUnlessEqual(NSMouseMoved, 5)
        self.failUnlessEqual(NSLeftMouseDragged, 6)
        self.failUnlessEqual(NSRightMouseDragged, 7)
        self.failUnlessEqual(NSMouseEntered, 8)
        self.failUnlessEqual(NSMouseExited, 9)
        self.failUnlessEqual(NSKeyDown, 10)
        self.failUnlessEqual(NSKeyUp, 11)
        self.failUnlessEqual(NSFlagsChanged, 12)
        self.failUnlessEqual(NSAppKitDefined, 13)
        self.failUnlessEqual(NSSystemDefined, 14)
        self.failUnlessEqual(NSApplicationDefined, 15)
        self.failUnlessEqual(NSPeriodic, 16)
        self.failUnlessEqual(NSCursorUpdate, 17)
        self.failUnlessEqual(NSScrollWheel, 22)
        self.failUnlessEqual(NSTabletPoint, 23)
        self.failUnlessEqual(NSTabletProximity, 24)
        self.failUnlessEqual(NSOtherMouseDown, 25)
        self.failUnlessEqual(NSOtherMouseUp, 26)
        self.failUnlessEqual(NSOtherMouseDragged, 27)
        self.failUnlessEqual(NSLeftMouseDownMask, 1 << NSLeftMouseDown)
        self.failUnlessEqual(NSLeftMouseUpMask, 1 << NSLeftMouseUp)
        self.failUnlessEqual(NSRightMouseDownMask, 1 << NSRightMouseDown)
        self.failUnlessEqual(NSRightMouseUpMask, 1 << NSRightMouseUp)
        self.failUnlessEqual(NSMouseMovedMask, 1 << NSMouseMoved)
        self.failUnlessEqual(NSLeftMouseDraggedMask, 1 << NSLeftMouseDragged)
        self.failUnlessEqual(NSRightMouseDraggedMask, 1 << NSRightMouseDragged)
        self.failUnlessEqual(NSMouseEnteredMask, 1 << NSMouseEntered)
        self.failUnlessEqual(NSMouseExitedMask, 1 << NSMouseExited)
        self.failUnlessEqual(NSKeyDownMask, 1 << NSKeyDown)
        self.failUnlessEqual(NSKeyUpMask, 1 << NSKeyUp)
        self.failUnlessEqual(NSFlagsChangedMask, 1 << NSFlagsChanged)
        self.failUnlessEqual(NSAppKitDefinedMask, 1 << NSAppKitDefined)
        self.failUnlessEqual(NSSystemDefinedMask, 1 << NSSystemDefined)
        self.failUnlessEqual(NSApplicationDefinedMask, 1 << NSApplicationDefined)
        self.failUnlessEqual(NSPeriodicMask, 1 << NSPeriodic)
        self.failUnlessEqual(NSCursorUpdateMask, 1 << NSCursorUpdate)
        self.failUnlessEqual(NSScrollWheelMask, 1 << NSScrollWheel)
        self.failUnlessEqual(NSTabletPointMask, 1 << NSTabletPoint)
        self.failUnlessEqual(NSTabletProximityMask, 1 << NSTabletProximity)
        self.failUnlessEqual(NSOtherMouseDownMask, 1 << NSOtherMouseDown)
        self.failUnlessEqual(NSOtherMouseUpMask, 1 << NSOtherMouseUp)
        self.failUnlessEqual(NSOtherMouseDraggedMask, 1 << NSOtherMouseDragged)
        self.failUnlessEqual(NSAnyEventMask, -1)

        self.failUnlessEqual(NSAlphaShiftKeyMask, 1 << 16)
        self.failUnlessEqual(NSShiftKeyMask, 1 << 17)
        self.failUnlessEqual(NSControlKeyMask, 1 << 18)
        self.failUnlessEqual(NSAlternateKeyMask, 1 << 19)
        self.failUnlessEqual(NSCommandKeyMask, 1 << 20)
        self.failUnlessEqual(NSNumericPadKeyMask, 1 << 21)
        self.failUnlessEqual(NSHelpKeyMask, 1 << 22)
        self.failUnlessEqual(NSFunctionKeyMask, 1 << 23)
        self.failUnlessEqual(NSDeviceIndependentModifierFlagsMask, -65536)
        self.failUnlessEqual(NSUnknownPointingDevice, 0)
        self.failUnlessEqual(NSPenPointingDevice, 1)
        self.failUnlessEqual(NSCursorPointingDevice, 2)
        self.failUnlessEqual(NSEraserPointingDevice, 3)
        self.failUnlessEqual(NSPenTipMask, 1)
        self.failUnlessEqual(NSPenLowerSideMask, 2)
        self.failUnlessEqual(NSPenUpperSideMask, 4)

        self.failUnlessEqual(NSWindowExposedEventType, 0)
        self.failUnlessEqual(NSApplicationActivatedEventType, 1)
        self.failUnlessEqual(NSApplicationDeactivatedEventType, 2)
        self.failUnlessEqual(NSWindowMovedEventType, 4)
        self.failUnlessEqual(NSScreenChangedEventType, 8)
        self.failUnlessEqual(NSAWTEventType, 16)
        self.failUnlessEqual(NSPowerOffEventType, 1)
        self.failUnlessEqual(NSMouseEventSubtype, 0)
        self.failUnlessEqual(NSTabletPointEventSubtype, 1)
        self.failUnlessEqual(NSTabletProximityEventSubtype, 2)

        self.failUnlessEqual(NSUpArrowFunctionKey, unichr(0xF700))
        self.failUnlessEqual(NSDownArrowFunctionKey, unichr(0xF701))
        self.failUnlessEqual(NSLeftArrowFunctionKey, unichr(0xF702))
        self.failUnlessEqual(NSRightArrowFunctionKey, unichr(0xF703))
        self.failUnlessEqual(NSF1FunctionKey, unichr(0xF704))
        self.failUnlessEqual(NSF2FunctionKey, unichr(0xF705))
        self.failUnlessEqual(NSF3FunctionKey, unichr(0xF706))
        self.failUnlessEqual(NSF4FunctionKey, unichr(0xF707))
        self.failUnlessEqual(NSF5FunctionKey, unichr(0xF708))
        self.failUnlessEqual(NSF6FunctionKey, unichr(0xF709))
        self.failUnlessEqual(NSF7FunctionKey, unichr(0xF70A))
        self.failUnlessEqual(NSF8FunctionKey, unichr(0xF70B))
        self.failUnlessEqual(NSF9FunctionKey, unichr(0xF70C))
        self.failUnlessEqual(NSF10FunctionKey, unichr(0xF70D))
        self.failUnlessEqual(NSF11FunctionKey, unichr(0xF70E))
        self.failUnlessEqual(NSF12FunctionKey, unichr(0xF70F))
        self.failUnlessEqual(NSF13FunctionKey, unichr(0xF710))
        self.failUnlessEqual(NSF14FunctionKey, unichr(0xF711))
        self.failUnlessEqual(NSF15FunctionKey, unichr(0xF712))
        self.failUnlessEqual(NSF16FunctionKey, unichr(0xF713))
        self.failUnlessEqual(NSF17FunctionKey, unichr(0xF714))
        self.failUnlessEqual(NSF18FunctionKey, unichr(0xF715))
        self.failUnlessEqual(NSF19FunctionKey, unichr(0xF716))
        self.failUnlessEqual(NSF20FunctionKey, unichr(0xF717))
        self.failUnlessEqual(NSF21FunctionKey, unichr(0xF718))
        self.failUnlessEqual(NSF22FunctionKey, unichr(0xF719))
        self.failUnlessEqual(NSF23FunctionKey, unichr(0xF71A))
        self.failUnlessEqual(NSF24FunctionKey, unichr(0xF71B))
        self.failUnlessEqual(NSF25FunctionKey, unichr(0xF71C))
        self.failUnlessEqual(NSF26FunctionKey, unichr(0xF71D))
        self.failUnlessEqual(NSF27FunctionKey, unichr(0xF71E))
        self.failUnlessEqual(NSF28FunctionKey, unichr(0xF71F))
        self.failUnlessEqual(NSF29FunctionKey, unichr(0xF720))
        self.failUnlessEqual(NSF30FunctionKey, unichr(0xF721))
        self.failUnlessEqual(NSF31FunctionKey, unichr(0xF722))
        self.failUnlessEqual(NSF32FunctionKey, unichr(0xF723))
        self.failUnlessEqual(NSF33FunctionKey, unichr(0xF724))
        self.failUnlessEqual(NSF34FunctionKey, unichr(0xF725))
        self.failUnlessEqual(NSF35FunctionKey, unichr(0xF726))
        self.failUnlessEqual(NSInsertFunctionKey, unichr(0xF727))
        self.failUnlessEqual(NSDeleteFunctionKey, unichr(0xF728))
        self.failUnlessEqual(NSHomeFunctionKey, unichr(0xF729))
        self.failUnlessEqual(NSBeginFunctionKey, unichr(0xF72A))
        self.failUnlessEqual(NSEndFunctionKey, unichr(0xF72B))
        self.failUnlessEqual(NSPageUpFunctionKey, unichr(0xF72C))
        self.failUnlessEqual(NSPageDownFunctionKey, unichr(0xF72D))
        self.failUnlessEqual(NSPrintScreenFunctionKey, unichr(0xF72E))
        self.failUnlessEqual(NSScrollLockFunctionKey, unichr(0xF72F))
        self.failUnlessEqual(NSPauseFunctionKey, unichr(0xF730))
        self.failUnlessEqual(NSSysReqFunctionKey, unichr(0xF731))
        self.failUnlessEqual(NSBreakFunctionKey, unichr(0xF732))
        self.failUnlessEqual(NSResetFunctionKey, unichr(0xF733))
        self.failUnlessEqual(NSStopFunctionKey, unichr(0xF734))
        self.failUnlessEqual(NSMenuFunctionKey, unichr(0xF735))
        self.failUnlessEqual(NSUserFunctionKey, unichr(0xF736))
        self.failUnlessEqual(NSSystemFunctionKey, unichr(0xF737))
        self.failUnlessEqual(NSPrintFunctionKey, unichr(0xF738))
        self.failUnlessEqual(NSClearLineFunctionKey, unichr(0xF739))
        self.failUnlessEqual(NSClearDisplayFunctionKey, unichr(0xF73A))
        self.failUnlessEqual(NSInsertLineFunctionKey, unichr(0xF73B))
        self.failUnlessEqual(NSDeleteLineFunctionKey, unichr(0xF73C))
        self.failUnlessEqual(NSInsertCharFunctionKey, unichr(0xF73D))
        self.failUnlessEqual(NSDeleteCharFunctionKey, unichr(0xF73E))
        self.failUnlessEqual(NSPrevFunctionKey, unichr(0xF73F))
        self.failUnlessEqual(NSNextFunctionKey, unichr(0xF740))
        self.failUnlessEqual(NSSelectFunctionKey, unichr(0xF741))
        self.failUnlessEqual(NSExecuteFunctionKey, unichr(0xF742))
        self.failUnlessEqual(NSUndoFunctionKey, unichr(0xF743))
        self.failUnlessEqual(NSRedoFunctionKey, unichr(0xF744))
        self.failUnlessEqual(NSFindFunctionKey, unichr(0xF745))
        self.failUnlessEqual(NSHelpFunctionKey, unichr(0xF746))
        self.failUnlessEqual(NSModeSwitchFunctionKey, unichr(0xF747))


    def testFunctions(self):
        v = NSEventMaskFromType(NSLeftMouseDown)
        self.assertEquals(v, NSLeftMouseDownMask)

        v = NSEventMaskFromType(NSOtherMouseDown)
        self.assertEquals(v, NSOtherMouseDownMask)

    @min_os_level('10.5')
    def testMethods10_5(self):
        self.failUnlessResultIsBOOL(NSEvent.isMouseCoalescingEnabled)
        self.failUnlessArgIsBOOL(NSEvent.setMouseCoalescingEnabled_, 0)

    def testMethods(self):
        self.failUnlessResultIsBOOL(NSEvent.isARepeat)
        self.failUnlessResultIsBOOL(NSEvent.isEnteringProximity)

        self.failUnlessArgIsBOOL(NSEvent.keyEventWithType_location_modifierFlags_timestamp_windowNumber_context_characters_charactersIgnoringModifiers_isARepeat_keyCode_, 8)
        self.failUnlessArgHasType(NSEvent.enterExitEventWithType_location_modifierFlags_timestamp_windowNumber_context_eventNumber_trackingNumber_userData_, 8, '^v')


        self.failUnlessResultHasType(NSEvent.userData, '^v')

if __name__ == "__main__":
    main()
