
from PyObjCTools.TestSupport import *
from LaunchServices import *

class TestIconsCore (TestCase):
    def testConstants(self):
        self.failUnlessEqual(kGenericDocumentIconResource, -4000)
        self.failUnlessEqual(kGenericStationeryIconResource, -3985)
        self.failUnlessEqual(kGenericEditionFileIconResource, -3989)
        self.failUnlessEqual(kGenericApplicationIconResource, -3996)
        self.failUnlessEqual(kGenericDeskAccessoryIconResource, -3991)
        self.failUnlessEqual(kGenericFolderIconResource, -3999)
        self.failUnlessEqual(kPrivateFolderIconResource, -3994)
        self.failUnlessEqual(kFloppyIconResource, -3998)
        self.failUnlessEqual(kTrashIconResource, -3993)
        self.failUnlessEqual(kGenericRAMDiskIconResource, -3988)
        self.failUnlessEqual(kGenericCDROMIconResource, -3987)
        self.failUnlessEqual(kDesktopIconResource, -3992)
        self.failUnlessEqual(kOpenFolderIconResource, -3997)
        self.failUnlessEqual(kGenericHardDiskIconResource, -3995)
        self.failUnlessEqual(kGenericFileServerIconResource, -3972)
        self.failUnlessEqual(kGenericSuitcaseIconResource, -3970)
        self.failUnlessEqual(kGenericMoverObjectIconResource, -3969)
        
        self.failUnlessEqual(kGenericPreferencesIconResource, -3971)
        self.failUnlessEqual(kGenericQueryDocumentIconResource, -16506)
        self.failUnlessEqual(kGenericExtensionIconResource, -16415)
        self.failUnlessEqual(kSystemFolderIconResource, -3983)
        self.failUnlessEqual(kHelpIconResource, -20271)
        self.failUnlessEqual(kAppleMenuFolderIconResource, -3982)
        self.failUnlessEqual(genericDocumentIconResource, kGenericDocumentIconResource)
        self.failUnlessEqual(genericStationeryIconResource, kGenericStationeryIconResource)
        self.failUnlessEqual(genericEditionFileIconResource, kGenericEditionFileIconResource)
        self.failUnlessEqual(genericApplicationIconResource, kGenericApplicationIconResource)
        self.failUnlessEqual(genericDeskAccessoryIconResource, kGenericDeskAccessoryIconResource)
        self.failUnlessEqual(genericFolderIconResource, kGenericFolderIconResource)
        self.failUnlessEqual(privateFolderIconResource, kPrivateFolderIconResource)
        self.failUnlessEqual(floppyIconResource, kFloppyIconResource)
        self.failUnlessEqual(trashIconResource, kTrashIconResource)
        self.failUnlessEqual(genericRAMDiskIconResource, kGenericRAMDiskIconResource)
        self.failUnlessEqual(genericCDROMIconResource, kGenericCDROMIconResource)
        self.failUnlessEqual(desktopIconResource, kDesktopIconResource)
        self.failUnlessEqual(openFolderIconResource, kOpenFolderIconResource)
        self.failUnlessEqual(genericHardDiskIconResource, kGenericHardDiskIconResource)
        self.failUnlessEqual(genericFileServerIconResource, kGenericFileServerIconResource)
        self.failUnlessEqual(genericSuitcaseIconResource, kGenericSuitcaseIconResource)
        self.failUnlessEqual(genericMoverObjectIconResource, kGenericMoverObjectIconResource)
        self.failUnlessEqual(genericPreferencesIconResource, kGenericPreferencesIconResource)
        self.failUnlessEqual(genericQueryDocumentIconResource, kGenericQueryDocumentIconResource)
        self.failUnlessEqual(genericExtensionIconResource, kGenericExtensionIconResource)
        self.failUnlessEqual(systemFolderIconResource, kSystemFolderIconResource)
        self.failUnlessEqual(appleMenuFolderIconResource, kAppleMenuFolderIconResource)
        self.failUnlessEqual(kStartupFolderIconResource, -3981)
        self.failUnlessEqual(kOwnedFolderIconResource, -3980)
        self.failUnlessEqual(kDropFolderIconResource, -3979)
        self.failUnlessEqual(kSharedFolderIconResource, -3978)
        self.failUnlessEqual(kMountedFolderIconResource, -3977)
        self.failUnlessEqual(kControlPanelFolderIconResource, -3976)
        self.failUnlessEqual(kPrintMonitorFolderIconResource, -3975)
        self.failUnlessEqual(kPreferencesFolderIconResource, -3974)
        self.failUnlessEqual(kExtensionsFolderIconResource, -3973)
        self.failUnlessEqual(kFontsFolderIconResource, -3968)
        self.failUnlessEqual(kFullTrashIconResource, -3984)
        self.failUnlessEqual(startupFolderIconResource, kStartupFolderIconResource)
        self.failUnlessEqual(ownedFolderIconResource, kOwnedFolderIconResource)
        self.failUnlessEqual(dropFolderIconResource, kDropFolderIconResource)
        self.failUnlessEqual(sharedFolderIconResource, kSharedFolderIconResource)
        self.failUnlessEqual(mountedFolderIconResource, kMountedFolderIconResource)
        self.failUnlessEqual(controlPanelFolderIconResource, kControlPanelFolderIconResource)
        self.failUnlessEqual(printMonitorFolderIconResource, kPrintMonitorFolderIconResource)
        self.failUnlessEqual(preferencesFolderIconResource, kPreferencesFolderIconResource)
        self.failUnlessEqual(extensionsFolderIconResource, kExtensionsFolderIconResource)
        self.failUnlessEqual(fontsFolderIconResource, kFontsFolderIconResource)
        self.failUnlessEqual(fullTrashIconResource, kFullTrashIconResource)
        self.failUnlessEqual(kSystemIconsCreator, fourcc('macs'))

        self.failUnlessEqual(kClipboardIcon, fourcc('CLIP'))
        self.failUnlessEqual(kClippingUnknownTypeIcon, fourcc('clpu'))
        self.failUnlessEqual(kClippingPictureTypeIcon, fourcc('clpp'))
        self.failUnlessEqual(kClippingTextTypeIcon, fourcc('clpt'))
        self.failUnlessEqual(kClippingSoundTypeIcon, fourcc('clps'))
        self.failUnlessEqual(kDesktopIcon, fourcc('desk'))
        self.failUnlessEqual(kFinderIcon, fourcc('FNDR'))
        self.failUnlessEqual(kComputerIcon, fourcc('root'))
        self.failUnlessEqual(kFontSuitcaseIcon, fourcc('FFIL'))
        self.failUnlessEqual(kFullTrashIcon, fourcc('ftrh'))
        self.failUnlessEqual(kGenericApplicationIcon, fourcc('APPL'))
        self.failUnlessEqual(kGenericCDROMIcon, fourcc('cddr'))
        self.failUnlessEqual(kGenericControlPanelIcon, fourcc('APPC'))
        self.failUnlessEqual(kGenericControlStripModuleIcon, fourcc('sdev'))
        self.failUnlessEqual(kGenericComponentIcon, fourcc('thng'))
        self.failUnlessEqual(kGenericDeskAccessoryIcon, fourcc('APPD'))
        self.failUnlessEqual(kGenericDocumentIcon, fourcc('docu'))
        self.failUnlessEqual(kGenericEditionFileIcon, fourcc('edtf'))
        self.failUnlessEqual(kGenericExtensionIcon, fourcc('INIT'))
        self.failUnlessEqual(kGenericFileServerIcon, fourcc('srvr'))
        self.failUnlessEqual(kGenericFontIcon, fourcc('ffil'))
        self.failUnlessEqual(kGenericFontScalerIcon, fourcc('sclr'))
        self.failUnlessEqual(kGenericFloppyIcon, fourcc('flpy'))
        self.failUnlessEqual(kGenericHardDiskIcon, fourcc('hdsk'))
        self.failUnlessEqual(kGenericIDiskIcon, fourcc('idsk'))
        self.failUnlessEqual(kGenericRemovableMediaIcon, fourcc('rmov'))
        self.failUnlessEqual(kGenericMoverObjectIcon, fourcc('movr'))
        self.failUnlessEqual(kGenericPCCardIcon, fourcc('pcmc'))
        self.failUnlessEqual(kGenericPreferencesIcon, fourcc('pref'))
        self.failUnlessEqual(kGenericQueryDocumentIcon, fourcc('qery'))
        self.failUnlessEqual(kGenericRAMDiskIcon, fourcc('ramd'))
        self.failUnlessEqual(kGenericSharedLibaryIcon, fourcc('shlb'))
        self.failUnlessEqual(kGenericStationeryIcon, fourcc('sdoc'))
        self.failUnlessEqual(kGenericSuitcaseIcon, fourcc('suit'))
        self.failUnlessEqual(kGenericURLIcon, fourcc('gurl'))
        self.failUnlessEqual(kGenericWORMIcon, fourcc('worm'))
        self.failUnlessEqual(kInternationalResourcesIcon, fourcc('ifil'))
        self.failUnlessEqual(kKeyboardLayoutIcon, fourcc('kfil'))
        self.failUnlessEqual(kSoundFileIcon, fourcc('sfil'))
        self.failUnlessEqual(kSystemSuitcaseIcon, fourcc('zsys'))
        self.failUnlessEqual(kTrashIcon, fourcc('trsh'))
        self.failUnlessEqual(kTrueTypeFontIcon, fourcc('tfil'))
        self.failUnlessEqual(kTrueTypeFlatFontIcon, fourcc('sfnt'))
        self.failUnlessEqual(kTrueTypeMultiFlatFontIcon, fourcc('ttcf'))
        self.failUnlessEqual(kUserIDiskIcon, fourcc('udsk'))
        self.failUnlessEqual(kUnknownFSObjectIcon, fourcc('unfs'))
        self.failUnlessEqual(kInternationResourcesIcon, kInternationalResourcesIcon)
        self.failUnlessEqual(kInternetLocationHTTPIcon, fourcc('ilht'))
        self.failUnlessEqual(kInternetLocationFTPIcon, fourcc('ilft'))
        self.failUnlessEqual(kInternetLocationAppleShareIcon, fourcc('ilaf'))
        self.failUnlessEqual(kInternetLocationAppleTalkZoneIcon, fourcc('ilat'))
        self.failUnlessEqual(kInternetLocationFileIcon, fourcc('ilfi'))
        self.failUnlessEqual(kInternetLocationMailIcon, fourcc('ilma'))
        self.failUnlessEqual(kInternetLocationNewsIcon, fourcc('ilnw'))
        self.failUnlessEqual(kInternetLocationNSLNeighborhoodIcon, fourcc('ilns'))
        self.failUnlessEqual(kInternetLocationGenericIcon, fourcc('ilge'))
        self.failUnlessEqual(kGenericFolderIcon, fourcc('fldr'))
        self.failUnlessEqual(kDropFolderIcon, fourcc('dbox'))
        self.failUnlessEqual(kMountedFolderIcon, fourcc('mntd'))
        self.failUnlessEqual(kOpenFolderIcon, fourcc('ofld'))
        self.failUnlessEqual(kOwnedFolderIcon, fourcc('ownd'))
        self.failUnlessEqual(kPrivateFolderIcon, fourcc('prvf'))
        self.failUnlessEqual(kSharedFolderIcon, fourcc('shfl'))
        self.failUnlessEqual(kSharingPrivsNotApplicableIcon, fourcc('shna'))
        self.failUnlessEqual(kSharingPrivsReadOnlyIcon, fourcc('shro'))
        self.failUnlessEqual(kSharingPrivsReadWriteIcon, fourcc('shrw'))
        self.failUnlessEqual(kSharingPrivsUnknownIcon, fourcc('shuk'))
        self.failUnlessEqual(kSharingPrivsWritableIcon, fourcc('writ'))
        self.failUnlessEqual(kUserFolderIcon, fourcc('ufld'))
        self.failUnlessEqual(kWorkgroupFolderIcon, fourcc('wfld'))
        self.failUnlessEqual(kGuestUserIcon, fourcc('gusr'))
        self.failUnlessEqual(kUserIcon, fourcc('user'))
        self.failUnlessEqual(kOwnerIcon, fourcc('susr'))
        self.failUnlessEqual(kGroupIcon, fourcc('grup'))
        self.failUnlessEqual(kAppearanceFolderIcon, fourcc('appr'))
        self.failUnlessEqual(kAppleExtrasFolderIcon, cast_int(0x616578C4))
        self.failUnlessEqual(kAppleMenuFolderIcon, fourcc('amnu'))
        self.failUnlessEqual(kApplicationsFolderIcon, fourcc('apps'))
        self.failUnlessEqual(kApplicationSupportFolderIcon, fourcc('asup'))
        self.failUnlessEqual(kAssistantsFolderIcon, cast_int(0x617374C4))
        self.failUnlessEqual(kColorSyncFolderIcon, fourcc('prof'))
        self.failUnlessEqual(kContextualMenuItemsFolderIcon, fourcc('cmnu'))
        self.failUnlessEqual(kControlPanelDisabledFolderIcon, fourcc('ctrD'))
        self.failUnlessEqual(kControlPanelFolderIcon, fourcc('ctrl'))
        self.failUnlessEqual(kControlStripModulesFolderIcon, cast_int(0x736476C4))
        self.failUnlessEqual(kDocumentsFolderIcon, fourcc('docs'))
        self.failUnlessEqual(kExtensionsDisabledFolderIcon, fourcc('extD'))
        self.failUnlessEqual(kExtensionsFolderIcon, fourcc('extn'))
        self.failUnlessEqual(kFavoritesFolderIcon, fourcc('favs'))
        self.failUnlessEqual(kFontsFolderIcon, fourcc('font'))
        self.failUnlessEqual(kHelpFolderIcon, cast_int(0xC4686C70))
        self.failUnlessEqual(kInternetFolderIcon, cast_int(0x696E74C4))
        self.failUnlessEqual(kInternetPlugInFolderIcon, cast_int(0xC46E6574))
        self.failUnlessEqual(kInternetSearchSitesFolderIcon, fourcc('issf'))
        self.failUnlessEqual(kLocalesFolderIcon, cast_int(0xC46C6F63))
        self.failUnlessEqual(kMacOSReadMeFolderIcon, cast_int(0x6D6F72C4))
        self.failUnlessEqual(kPublicFolderIcon, fourcc('pubf'))
        self.failUnlessEqual(kPreferencesFolderIcon, cast_int(0x707266C4))
        self.failUnlessEqual(kPrinterDescriptionFolderIcon, fourcc('ppdf'))
        self.failUnlessEqual(kPrinterDriverFolderIcon, cast_int(0xC4707264))
        self.failUnlessEqual(kPrintMonitorFolderIcon, fourcc('prnt'))
        self.failUnlessEqual(kRecentApplicationsFolderIcon, fourcc('rapp'))
        self.failUnlessEqual(kRecentDocumentsFolderIcon, fourcc('rdoc'))
        self.failUnlessEqual(kRecentServersFolderIcon, fourcc('rsrv'))
        self.failUnlessEqual(kScriptingAdditionsFolderIcon, cast_int(0xC4736372))
        self.failUnlessEqual(kSharedLibrariesFolderIcon, cast_int(0xC46C6962))
        self.failUnlessEqual(kScriptsFolderIcon, cast_int( 0x736372C4))
        self.failUnlessEqual(kShutdownItemsDisabledFolderIcon, fourcc('shdD'))
        self.failUnlessEqual(kShutdownItemsFolderIcon, fourcc('shdf'))
        self.failUnlessEqual(kSpeakableItemsFolder, fourcc('spki'))
        self.failUnlessEqual(kStartupItemsDisabledFolderIcon, fourcc('strD'))
        self.failUnlessEqual(kStartupItemsFolderIcon, fourcc('strt'))
        self.failUnlessEqual(kSystemExtensionDisabledFolderIcon, fourcc('macD'))
        self.failUnlessEqual(kSystemFolderIcon, fourcc('macs'))
        self.failUnlessEqual(kTextEncodingsFolderIcon, cast_int(0xC4746578))
        self.failUnlessEqual(kUsersFolderIcon, cast_int(0x757372C4))
        self.failUnlessEqual(kUtilitiesFolderIcon, cast_int(0x757469C4))
        self.failUnlessEqual(kVoicesFolderIcon, fourcc('fvoc'))
        self.failUnlessEqual(kAppleScriptBadgeIcon, fourcc('scrp'))
        self.failUnlessEqual(kLockedBadgeIcon, fourcc('lbdg'))
        self.failUnlessEqual(kMountedBadgeIcon, fourcc('mbdg'))
        self.failUnlessEqual(kSharedBadgeIcon, fourcc('sbdg'))
        self.failUnlessEqual(kAliasBadgeIcon, fourcc('abdg'))
        self.failUnlessEqual(kAlertCautionBadgeIcon, fourcc('cbdg'))
        self.failUnlessEqual(kAlertNoteIcon, fourcc('note'))
        self.failUnlessEqual(kAlertCautionIcon, fourcc('caut'))
        self.failUnlessEqual(kAlertStopIcon, fourcc('stop'))
        self.failUnlessEqual(kAppleTalkIcon, fourcc('atlk'))
        self.failUnlessEqual(kAppleTalkZoneIcon, fourcc('atzn'))
        self.failUnlessEqual(kAFPServerIcon, fourcc('afps'))
        self.failUnlessEqual(kFTPServerIcon, fourcc('ftps'))
        self.failUnlessEqual(kHTTPServerIcon, fourcc('htps'))
        self.failUnlessEqual(kGenericNetworkIcon, fourcc('gnet'))
        self.failUnlessEqual(kIPFileServerIcon, fourcc('isrv'))
        self.failUnlessEqual(kToolbarCustomizeIcon, fourcc('tcus'))
        self.failUnlessEqual(kToolbarDeleteIcon, fourcc('tdel'))
        self.failUnlessEqual(kToolbarFavoritesIcon, fourcc('tfav'))
        self.failUnlessEqual(kToolbarHomeIcon, fourcc('thom'))
        self.failUnlessEqual(kAppleLogoIcon, fourcc('capl'))
        self.failUnlessEqual(kAppleMenuIcon, fourcc('sapl'))
        self.failUnlessEqual(kBackwardArrowIcon, fourcc('baro'))
        self.failUnlessEqual(kFavoriteItemsIcon, fourcc('favr'))
        self.failUnlessEqual(kForwardArrowIcon, fourcc('faro'))
        self.failUnlessEqual(kGridIcon, fourcc('grid'))
        self.failUnlessEqual(kHelpIcon, fourcc('help'))
        self.failUnlessEqual(kKeepArrangedIcon, fourcc('arng'))
        self.failUnlessEqual(kLockedIcon, fourcc('lock'))
        self.failUnlessEqual(kNoFilesIcon, fourcc('nfil'))
        self.failUnlessEqual(kNoFolderIcon, fourcc('nfld'))
        self.failUnlessEqual(kNoWriteIcon, fourcc('nwrt'))
        self.failUnlessEqual(kProtectedApplicationFolderIcon, fourcc('papp'))
        self.failUnlessEqual(kProtectedSystemFolderIcon, fourcc('psys'))
        self.failUnlessEqual(kRecentItemsIcon, fourcc('rcnt'))
        self.failUnlessEqual(kShortcutIcon, fourcc('shrt'))
        self.failUnlessEqual(kSortAscendingIcon, fourcc('asnd'))
        self.failUnlessEqual(kSortDescendingIcon, fourcc('dsnd'))
        self.failUnlessEqual(kUnlockedIcon, fourcc('ulck'))
        self.failUnlessEqual(kConnectToIcon, fourcc('cnct'))
        self.failUnlessEqual(kGenericWindowIcon, fourcc('gwin'))
        self.failUnlessEqual(kQuestionMarkIcon, fourcc('ques'))
        self.failUnlessEqual(kDeleteAliasIcon, fourcc('dali'))
        self.failUnlessEqual(kEjectMediaIcon, fourcc('ejec'))
        self.failUnlessEqual(kBurningIcon, fourcc('burn'))
        self.failUnlessEqual(kRightContainerArrowIcon, fourcc('rcar'))
        self.failUnlessEqual(kIconServicesNormalUsageFlag, 0)
        self.failUnlessEqual(kIconServicesNoBadgeFlag, 1) 
        self.failUnlessEqual(kIconServicesUpdateIfNeededFlag, 2)
        self.failUnlessEqual(kIconServicesCatalogInfoMask, 531550)
  
    @onlyOn32Bit
    def testFunctions32(self):
        # Not tested, deprecated function
        GetIconRefFromFile
        self.failUnlessArgIsOut(GetIconRefFromFolder, 5)

        RegisterIconRefFromResource
        OverrideIconRefFromResource
        FlushIconRefs
        FlushIconRefsByVolume

        self.failUnlessArgIsOut(RegisterIconRefFromIconFile, 3)

        ReadIconFile
        WriteIconFile
    
    def testFunctions(self):
        self.failUnlessArgIsOut(GetIconRef, 3)
        err, icon = GetIconRef(0, kSystemIconsCreator, kShortcutIcon, None)
        self.failUnlessIsInstance(err, (int, long))
        self.failUnlessIsInstance(icon, IconRef)

        try:
            self.failUnlessArgIsOut(GetIconRefOwners, 1)
            err, cnt = GetIconRefOwners(icon, None)
            self.failUnlessIsInstance(err, (int, long))
            self.failUnlessIsInstance(cnt, (int, long))

            err = AcquireIconRef(icon)
            self.failUnlessEqual(err, 0)

            err = ReleaseIconRef(icon)
            self.failUnlessEqual(err, 0)

            self.failUnlessArgIsOut(GetIconRefFromFolder, 5)

            self.failUnlessArgHasType(GetIconRefFromFileInfo, 2, objc._C_IN + objc._C_PTR + objc._C_UNICHAR)
            self.failUnlessArgIsOut(GetIconRefFromFileInfo, 6)
            self.failUnlessArgIsOut(GetIconRefFromFileInfo, 7)

            self.failUnlessArgIsOut(GetIconRefFromTypeInfo, 5)

            self.failUnlessArgIsIn(GetIconRefFromIconFamilyPtr, 0)
            self.failUnlessArgIsOut(GetIconRefFromIconFamilyPtr, 2)

            self.failUnlessArgIsOut(GetIconRefFromComponent, 1)

            # XXX: Untested for now...
            RegisterIconRefFromIconFamily
            RegisterIconRefFromFSRef
            UnregisterIconRef
            UpdateIconRef
            OverrideIconRef
            RemoveIconRefOverride

            self.failUnlessArgIsOut(CompositeIconRef, 2)

            self.failUnlessArgIsOut(IsIconRefComposite, 1)
            self.failUnlessArgIsOut(IsIconRefComposite, 2)

            self.failUnlessResultIsBOOL(IsValidIconRef)
            self.failUnlessResultIsBOOL(IsDataAvailableInIconRef)

            self.failUnlessArgIsBOOL(SetCustomIconsEnabled, 1)
            self.failUnlessArgIsOut(GetCustomIconsEnabled, 1)
            self.failUnlessArgHasType(GetCustomIconsEnabled, 1, objc._C_OUT + objc._C_PTR + objc._C_NSBOOL)

            
            # Untested...
            ReadIconFromFSRef

        finally:
            err = ReleaseIconRef(icon)
            self.failUnlessEqual(err, 0)

    def testOpaque(self):
        self.failUnlessIsOpaquePointer(IconRef)


if __name__ == "__main__":
    main()
