// This file has been generated by Py++.

#include "boost/python.hpp"
#include "with_ownershiplevel_postcall.hpp"
#include "opencv_headers.hpp"
#include "pyopencvext_free_functions.pypp.hpp"

namespace bp = boost::python;

void register_free_functions(){

    { //::cv::CamShift
    
        typedef ::cv::RotatedRect ( *CamShift_function_type )( ::cv::Mat const &,::cv::Rect &,::cv::TermCriteria );
        
        bp::def( 
            "CamShift"
            , CamShift_function_type( &::cv::CamShift )
            , ( bp::arg("probImage"), bp::arg("window"), bp::arg("criteria") ) );
    
    }

    { //::cv::Canny
    
        typedef void ( *Canny_function_type )( ::cv::Mat const &,::cv::Mat &,double,double,int,bool );
        
        bp::def( 
            "Canny"
            , Canny_function_type( &::cv::Canny )
            , ( bp::arg("image"), bp::arg("edges"), bp::arg("threshold1"), bp::arg("threshold2"), bp::arg("apertureSize")=(int)(3), bp::arg("L2gradient")=(bool)(false) ) );
    
    }

    { //::cv::GaussianBlur
    
        typedef void ( *GaussianBlur_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Size,double,double,int );
        
        bp::def( 
            "GaussianBlur"
            , GaussianBlur_function_type( &::cv::GaussianBlur )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ksize"), bp::arg("sigma1"), bp::arg("sigma2")=0, bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::LSHSize
    
        typedef unsigned int ( *LSHSize_function_type )( ::CvLSH * );
        
        bp::def( 
            "LSHSize"
            , LSHSize_function_type( &::LSHSize )
            , ( bp::arg("lsh") ) );
    
    }

    { //::cv::LUT
    
        typedef void ( *LUT_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "LUT"
            , LUT_function_type( &::cv::LUT )
            , ( bp::arg("a"), bp::arg("lut"), bp::arg("b") ) );
    
    }

    { //::cv::Laplacian
    
        typedef void ( *Laplacian_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,double,double,int );
        
        bp::def( 
            "Laplacian"
            , Laplacian_function_type( &::cv::Laplacian )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ddepth"), bp::arg("ksize")=(int)(1), bp::arg("scale")=1, bp::arg("delta")=0, bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::Mahalanobis
    
        typedef double ( *Mahalanobis_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const & );
        
        bp::def( 
            "Mahalanobis"
            , Mahalanobis_function_type( &::cv::Mahalanobis )
            , ( bp::arg("v1"), bp::arg("v2"), bp::arg("icovar") ) );
    
    }

    { //::cv::Mahalonobis
    
        typedef double ( *Mahalonobis_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const & );
        
        bp::def( 
            "Mahalonobis"
            , Mahalonobis_function_type( &::cv::Mahalonobis )
            , ( bp::arg("v1"), bp::arg("v2"), bp::arg("icovar") ) );
    
    }

    { //::cv::RQDecomp3x3
    
        typedef ::cv::Vec3d ( *RQDecomp3x3_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "RQDecomp3x3"
            , RQDecomp3x3_function_type( &::cv::RQDecomp3x3 )
            , ( bp::arg("M"), bp::arg("R"), bp::arg("Q"), bp::arg("Qx"), bp::arg("Qy"), bp::arg("Qz") ) );
    
    }

    { //::cv::RQDecomp3x3
    
        typedef void ( *RQDecomp3x3_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "RQDecomp3x3"
            , RQDecomp3x3_function_type( &::cv::RQDecomp3x3 )
            , ( bp::arg("M"), bp::arg("R"), bp::arg("Q") ) );
    
    }

    { //::cv::Rodrigues
    
        typedef void ( *Rodrigues_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "Rodrigues"
            , Rodrigues_function_type( &::cv::Rodrigues )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("jacobian") ) );
    
    }

    { //::cv::Rodrigues
    
        typedef void ( *Rodrigues_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "Rodrigues"
            , Rodrigues_function_type( &::cv::Rodrigues )
            , ( bp::arg("src"), bp::arg("dst") ) );
    
    }

    { //::cv::Scharr
    
        typedef void ( *Scharr_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,int,double,double,int );
        
        bp::def( 
            "Scharr"
            , Scharr_function_type( &::cv::Scharr )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ddepth"), bp::arg("dx"), bp::arg("dy"), bp::arg("scale")=1, bp::arg("delta")=0, bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::Sobel
    
        typedef void ( *Sobel_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,int,int,double,double,int );
        
        bp::def( 
            "Sobel"
            , Sobel_function_type( &::cv::Sobel )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ddepth"), bp::arg("dx"), bp::arg("dy"), bp::arg("ksize")=(int)(3), bp::arg("scale")=1, bp::arg("delta")=0, bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::absdiff
    
        typedef void ( *absdiff_function_type )( ::cv::MatND const &,::cv::Scalar const &,::cv::MatND & );
        
        bp::def( 
            "absdiff"
            , absdiff_function_type( &::cv::absdiff )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c") ) );
    
    }

    { //::cv::absdiff
    
        typedef void ( *absdiff_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "absdiff"
            , absdiff_function_type( &::cv::absdiff )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") ) );
    
    }

    { //::cv::absdiff
    
        typedef void ( *absdiff_function_type )( ::cv::Mat const &,::cv::Scalar const &,::cv::Mat & );
        
        bp::def( 
            "absdiff"
            , absdiff_function_type( &::cv::absdiff )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c") ) );
    
    }

    { //::cv::absdiff
    
        typedef void ( *absdiff_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "absdiff"
            , absdiff_function_type( &::cv::absdiff )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") ) );
    
    }

    { //::cv::accumulate
    
        typedef void ( *accumulate_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "accumulate"
            , accumulate_function_type( &::cv::accumulate )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::accumulateProduct
    
        typedef void ( *accumulateProduct_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "accumulateProduct"
            , accumulateProduct_function_type( &::cv::accumulateProduct )
            , ( bp::arg("src1"), bp::arg("src2"), bp::arg("dst"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::accumulateSquare
    
        typedef void ( *accumulateSquare_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "accumulateSquare"
            , accumulateSquare_function_type( &::cv::accumulateSquare )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::accumulateWeighted
    
        typedef void ( *accumulateWeighted_function_type )( ::cv::Mat const &,::cv::Mat &,double,::cv::Mat const & );
        
        bp::def( 
            "accumulateWeighted"
            , accumulateWeighted_function_type( &::cv::accumulateWeighted )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("alpha"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::adaptiveThreshold
    
        typedef void ( *adaptiveThreshold_function_type )( ::cv::Mat const &,::cv::Mat &,double,int,int,int,double );
        
        bp::def( 
            "adaptiveThreshold"
            , adaptiveThreshold_function_type( &::cv::adaptiveThreshold )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("maxValue"), bp::arg("adaptiveMethod"), bp::arg("thresholdType"), bp::arg("blockSize"), bp::arg("C") ) );
    
    }

    { //::cv::add
    
        typedef void ( *add_function_type )( ::cv::MatND const &,::cv::Scalar const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "add"
            , add_function_type( &::cv::add )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::MatND() ) );
    
    }

    { //::cv::add
    
        typedef void ( *add_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "add"
            , add_function_type( &::cv::add )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") ) );
    
    }

    { //::cv::add
    
        typedef void ( *add_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "add"
            , add_function_type( &::cv::add )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask") ) );
    
    }

    { //::cv::add
    
        typedef void ( *add_function_type )( ::cv::Mat const &,::cv::Scalar const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "add"
            , add_function_type( &::cv::add )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::add
    
        typedef void ( *add_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "add"
            , add_function_type( &::cv::add )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") ) );
    
    }

    { //::cv::add
    
        typedef void ( *add_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "add"
            , add_function_type( &::cv::add )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask") ) );
    
    }

    { //::cv::addWeighted
    
        typedef void ( *addWeighted_function_type )( ::cv::MatND const &,double,::cv::MatND const &,double,double,::cv::MatND & );
        
        bp::def( 
            "addWeighted"
            , addWeighted_function_type( &::cv::addWeighted )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("b"), bp::arg("beta"), bp::arg("gamma"), bp::arg("c") ) );
    
    }

    { //::cv::addWeighted
    
        typedef void ( *addWeighted_function_type )( ::cv::Mat const &,double,::cv::Mat const &,double,double,::cv::Mat & );
        
        bp::def( 
            "addWeighted"
            , addWeighted_function_type( &::cv::addWeighted )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("b"), bp::arg("beta"), bp::arg("gamma"), bp::arg("c") ) );
    
    }

    { //::cv::arcLength
    
        typedef double ( *arcLength_function_type )( ::cv::Mat const &,bool );
        
        bp::def( 
            "arcLength"
            , arcLength_function_type( &::cv::arcLength )
            , ( bp::arg("curve"), bp::arg("closed") ) );
    
    }

    { //::cv::bilateralFilter
    
        typedef void ( *bilateralFilter_function_type )( ::cv::Mat const &,::cv::Mat &,int,double,double,int );
        
        bp::def( 
            "bilateralFilter"
            , bilateralFilter_function_type( &::cv::bilateralFilter )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("d"), bp::arg("sigmaColor"), bp::arg("sigmaSpace"), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::bitwise_and
    
        typedef void ( *bitwise_and_function_type )( ::cv::MatND const &,::cv::Scalar const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "bitwise_and"
            , bitwise_and_function_type( &::cv::bitwise_and )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::MatND() ) );
    
    }

    { //::cv::bitwise_and
    
        typedef void ( *bitwise_and_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "bitwise_and"
            , bitwise_and_function_type( &::cv::bitwise_and )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask")=cv::MatND() ) );
    
    }

    { //::cv::bitwise_and
    
        typedef void ( *bitwise_and_function_type )( ::cv::Mat const &,::cv::Scalar const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "bitwise_and"
            , bitwise_and_function_type( &::cv::bitwise_and )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::bitwise_and
    
        typedef void ( *bitwise_and_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "bitwise_and"
            , bitwise_and_function_type( &::cv::bitwise_and )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::bitwise_not
    
        typedef void ( *bitwise_not_function_type )( ::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "bitwise_not"
            , bitwise_not_function_type( &::cv::bitwise_not )
            , ( bp::arg("a"), bp::arg("c") ) );
    
    }

    { //::cv::bitwise_not
    
        typedef void ( *bitwise_not_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "bitwise_not"
            , bitwise_not_function_type( &::cv::bitwise_not )
            , ( bp::arg("a"), bp::arg("c") ) );
    
    }

    { //::cv::bitwise_or
    
        typedef void ( *bitwise_or_function_type )( ::cv::MatND const &,::cv::Scalar const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "bitwise_or"
            , bitwise_or_function_type( &::cv::bitwise_or )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::MatND() ) );
    
    }

    { //::cv::bitwise_or
    
        typedef void ( *bitwise_or_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "bitwise_or"
            , bitwise_or_function_type( &::cv::bitwise_or )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask")=cv::MatND() ) );
    
    }

    { //::cv::bitwise_or
    
        typedef void ( *bitwise_or_function_type )( ::cv::Mat const &,::cv::Scalar const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "bitwise_or"
            , bitwise_or_function_type( &::cv::bitwise_or )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::bitwise_or
    
        typedef void ( *bitwise_or_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "bitwise_or"
            , bitwise_or_function_type( &::cv::bitwise_or )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::bitwise_xor
    
        typedef void ( *bitwise_xor_function_type )( ::cv::MatND const &,::cv::Scalar const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "bitwise_xor"
            , bitwise_xor_function_type( &::cv::bitwise_xor )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::MatND() ) );
    
    }

    { //::cv::bitwise_xor
    
        typedef void ( *bitwise_xor_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "bitwise_xor"
            , bitwise_xor_function_type( &::cv::bitwise_xor )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask")=cv::MatND() ) );
    
    }

    { //::cv::bitwise_xor
    
        typedef void ( *bitwise_xor_function_type )( ::cv::Mat const &,::cv::Scalar const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "bitwise_xor"
            , bitwise_xor_function_type( &::cv::bitwise_xor )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::bitwise_xor
    
        typedef void ( *bitwise_xor_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "bitwise_xor"
            , bitwise_xor_function_type( &::cv::bitwise_xor )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::blur
    
        typedef void ( *blur_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Size,::cv::Point,int );
        
        bp::def( 
            "blur"
            , blur_function_type( &::cv::blur )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ksize"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::borderInterpolate
    
        typedef int ( *borderInterpolate_function_type )( int,int,int );
        
        bp::def( 
            "borderInterpolate"
            , borderInterpolate_function_type( &::cv::borderInterpolate )
            , ( bp::arg("p"), bp::arg("len"), bp::arg("borderType") ) );
    
    }

    { //::cv::boundingRect
    
        typedef ::cv::Rect ( *boundingRect_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "boundingRect"
            , boundingRect_function_type( &::cv::boundingRect )
            , ( bp::arg("points") ) );
    
    }

    { //::cv::boxFilter
    
        typedef void ( *boxFilter_function_type )( ::cv::Mat const &,::cv::Mat &,int,::cv::Size,::cv::Point,bool,int );
        
        bp::def( 
            "boxFilter"
            , boxFilter_function_type( &::cv::boxFilter )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ddepth"), bp::arg("ksize"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("normalize")=(bool)(true), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::calcCovarMatrix
    
        typedef void ( *calcCovarMatrix_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,int,int );
        
        bp::def( 
            "calcCovarMatrix"
            , calcCovarMatrix_function_type( &::cv::calcCovarMatrix )
            , ( bp::arg("samples"), bp::arg("covar"), bp::arg("mean"), bp::arg("flags"), bp::arg("ctype")=(int)(6) ) );
    
    }

    { //::cv::calcGlobalOrientation
    
        typedef double ( *calcGlobalOrientation_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,double,double );
        
        bp::def( 
            "calcGlobalOrientation"
            , calcGlobalOrientation_function_type( &::cv::calcGlobalOrientation )
            , ( bp::arg("orientation"), bp::arg("mask"), bp::arg("mhi"), bp::arg("timestamp"), bp::arg("duration") ) );
    
    }

    { //::cv::calcMotionGradient
    
        typedef void ( *calcMotionGradient_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,double,double,int );
        
        bp::def( 
            "calcMotionGradient"
            , calcMotionGradient_function_type( &::cv::calcMotionGradient )
            , ( bp::arg("mhi"), bp::arg("mask"), bp::arg("orientation"), bp::arg("delta1"), bp::arg("delta2"), bp::arg("apertureSize")=(int)(3) ) );
    
    }

    { //::cv::calcOpticalFlowFarneback
    
        typedef void ( *calcOpticalFlowFarneback_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,double,int,int,int,int,double,int );
        
        bp::def( 
            "calcOpticalFlowFarneback"
            , calcOpticalFlowFarneback_function_type( &::cv::calcOpticalFlowFarneback )
            , ( bp::arg("prev0"), bp::arg("next0"), bp::arg("flow0"), bp::arg("pyr_scale"), bp::arg("levels"), bp::arg("winsize"), bp::arg("iterations"), bp::arg("poly_n"), bp::arg("poly_sigma"), bp::arg("flags") ) );
    
    }

    { //::cv::calibrationMatrixValues
    
        typedef void ( *calibrationMatrixValues_function_type )( ::cv::Mat const &,::cv::Size,double,double,double &,double &,double &,::cv::Point2d &,double & );
        
        bp::def( 
            "calibrationMatrixValues"
            , calibrationMatrixValues_function_type( &::cv::calibrationMatrixValues )
            , ( bp::arg("cameraMatrix"), bp::arg("imageSize"), bp::arg("apertureWidth"), bp::arg("apertureHeight"), bp::arg("fovx"), bp::arg("fovy"), bp::arg("focalLength"), bp::arg("principalPoint"), bp::arg("aspectRatio") ) );
    
    }

    { //::cv::cartToPolar
    
        typedef void ( *cartToPolar_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat &,bool );
        
        bp::def( 
            "cartToPolar"
            , cartToPolar_function_type( &::cv::cartToPolar )
            , ( bp::arg("x"), bp::arg("y"), bp::arg("magnitude"), bp::arg("angle"), bp::arg("angleInDegrees")=(bool)(false) ) );
    
    }

    { //::cv::circle
    
        typedef void ( *circle_function_type )( ::cv::Mat &,::cv::Point,int,::cv::Scalar const &,int,int,int );
        
        bp::def( 
            "circle"
            , circle_function_type( &::cv::circle )
            , ( bp::arg("img"), bp::arg("center"), bp::arg("radius"), bp::arg("color"), bp::arg("thickness")=(int)(1), bp::arg("lineType")=(int)(8), bp::arg("shift")=(int)(0) ) );
    
    }

    { //::cv::clipLine
    
        typedef bool ( *clipLine_function_type )( ::cv::Rect,::cv::Point &,::cv::Point & );
        
        bp::def( 
            "clipLine"
            , clipLine_function_type( &::cv::clipLine )
            , ( bp::arg("img_rect"), bp::arg("pt1"), bp::arg("pt2") ) );
    
    }

    { //::cv::clipLine
    
        typedef bool ( *clipLine_function_type )( ::cv::Size,::cv::Point &,::cv::Point & );
        
        bp::def( 
            "clipLine"
            , clipLine_function_type( &::cv::clipLine )
            , ( bp::arg("imgSize"), bp::arg("pt1"), bp::arg("pt2") ) );
    
    }

    { //::cv::compare
    
        typedef void ( *compare_function_type )( ::cv::MatND const &,double,::cv::MatND &,int );
        
        bp::def( 
            "compare"
            , compare_function_type( &::cv::compare )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("cmpop") ) );
    
    }

    { //::cv::compare
    
        typedef void ( *compare_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,int );
        
        bp::def( 
            "compare"
            , compare_function_type( &::cv::compare )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("cmpop") ) );
    
    }

    { //::cv::compare
    
        typedef void ( *compare_function_type )( ::cv::Mat const &,double,::cv::Mat &,int );
        
        bp::def( 
            "compare"
            , compare_function_type( &::cv::compare )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("cmpop") ) );
    
    }

    { //::cv::compare
    
        typedef void ( *compare_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "compare"
            , compare_function_type( &::cv::compare )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("cmpop") ) );
    
    }

    { //::cv::compareHist
    
        typedef double ( *compareHist_function_type )( ::cv::SparseMat const &,::cv::SparseMat const &,int );
        
        bp::def( 
            "compareHist"
            , compareHist_function_type( &::cv::compareHist )
            , ( bp::arg("H1"), bp::arg("H2"), bp::arg("method") ) );
    
    }

    { //::cv::compareHist
    
        typedef double ( *compareHist_function_type )( ::cv::MatND const &,::cv::MatND const &,int );
        
        bp::def( 
            "compareHist"
            , compareHist_function_type( &::cv::compareHist )
            , ( bp::arg("H1"), bp::arg("H2"), bp::arg("method") ) );
    
    }

    { //::cv::completeSymm
    
        typedef void ( *completeSymm_function_type )( ::cv::Mat &,bool );
        
        bp::def( 
            "completeSymm"
            , completeSymm_function_type( &::cv::completeSymm )
            , ( bp::arg("a"), bp::arg("lowerToUpper")=(bool)(false) ) );
    
    }

    { //::cv::composeRT
    
        typedef void ( *composeRT_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "composeRT"
            , composeRT_function_type( &::cv::composeRT )
            , ( bp::arg("rvec1"), bp::arg("tvec1"), bp::arg("rvec2"), bp::arg("tvec2"), bp::arg("rvec3"), bp::arg("tvec3"), bp::arg("dr3dr1"), bp::arg("dr3dt1"), bp::arg("dr3dr2"), bp::arg("dr3dt2"), bp::arg("dt3dr1"), bp::arg("dt3dt1"), bp::arg("dt3dr2"), bp::arg("dt3dt2") ) );
    
    }

    { //::cv::composeRT
    
        typedef void ( *composeRT_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "composeRT"
            , composeRT_function_type( &::cv::composeRT )
            , ( bp::arg("rvec1"), bp::arg("tvec1"), bp::arg("rvec2"), bp::arg("tvec2"), bp::arg("rvec3"), bp::arg("tvec3") ) );
    
    }

    { //::cv::contourArea
    
        typedef double ( *contourArea_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "contourArea"
            , contourArea_function_type( &::cv::contourArea )
            , ( bp::arg("contour") ) );
    
    }

    { //::cv::convertMaps
    
        typedef void ( *convertMaps_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat &,int,bool );
        
        bp::def( 
            "convertMaps"
            , convertMaps_function_type( &::cv::convertMaps )
            , ( bp::arg("map1"), bp::arg("map2"), bp::arg("dstmap1"), bp::arg("dstmap2"), bp::arg("dstmap1type"), bp::arg("nninterpolation")=(bool)(false) ) );
    
    }

    { //::cv::convertScaleAbs
    
        typedef void ( *convertScaleAbs_function_type )( ::cv::Mat const &,::cv::Mat &,double,double );
        
        bp::def( 
            "convertScaleAbs"
            , convertScaleAbs_function_type( &::cv::convertScaleAbs )
            , ( bp::arg("a"), bp::arg("c"), bp::arg("alpha")=1, bp::arg("beta")=0 ) );
    
    }

    { //::cv::copyMakeBorder
    
        typedef void ( *copyMakeBorder_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,int,int,int,::cv::Scalar const & );
        
        bp::def( 
            "copyMakeBorder"
            , copyMakeBorder_function_type( &::cv::copyMakeBorder )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("top"), bp::arg("bottom"), bp::arg("left"), bp::arg("right"), bp::arg("borderType"), bp::arg("value")=cv::Scalar_<double>() ) );
    
    }

    { //::cv::cornerEigenValsAndVecs
    
        typedef void ( *cornerEigenValsAndVecs_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,int );
        
        bp::def( 
            "cornerEigenValsAndVecs"
            , cornerEigenValsAndVecs_function_type( &::cv::cornerEigenValsAndVecs )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("blockSize"), bp::arg("ksize"), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::cornerHarris
    
        typedef void ( *cornerHarris_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,double,int );
        
        bp::def( 
            "cornerHarris"
            , cornerHarris_function_type( &::cv::cornerHarris )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("blockSize"), bp::arg("ksize"), bp::arg("k"), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::cornerMinEigenVal
    
        typedef void ( *cornerMinEigenVal_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,int );
        
        bp::def( 
            "cornerMinEigenVal"
            , cornerMinEigenVal_function_type( &::cv::cornerMinEigenVal )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("blockSize"), bp::arg("ksize")=(int)(3), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::countNonZero
    
        typedef int ( *countNonZero_function_type )( ::cv::MatND const & );
        
        bp::def( 
            "countNonZero"
            , countNonZero_function_type( &::cv::countNonZero )
            , ( bp::arg("m") ) );
    
    }

    { //::cv::countNonZero
    
        typedef int ( *countNonZero_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "countNonZero"
            , countNonZero_function_type( &::cv::countNonZero )
            , ( bp::arg("m") ) );
    
    }

    { //::cv::createBoxFilter
    
        typedef ::cv::Ptr< cv::FilterEngine > ( *createBoxFilter_function_type )( int,int,::cv::Size,::cv::Point,bool,int );
        
        bp::def( 
            "createBoxFilter"
            , createBoxFilter_function_type( &::cv::createBoxFilter )
            , ( bp::arg("srcType"), bp::arg("dstType"), bp::arg("ksize"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("normalize")=(bool)(true), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::createDerivFilter
    
        typedef ::cv::Ptr< cv::FilterEngine > ( *createDerivFilter_function_type )( int,int,int,int,int,int );
        
        bp::def( 
            "createDerivFilter"
            , createDerivFilter_function_type( &::cv::createDerivFilter )
            , ( bp::arg("srcType"), bp::arg("dstType"), bp::arg("dx"), bp::arg("dy"), bp::arg("ksize"), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::createGaussianFilter
    
        typedef ::cv::Ptr< cv::FilterEngine > ( *createGaussianFilter_function_type )( int,::cv::Size,double,double,int );
        
        bp::def( 
            "createGaussianFilter"
            , createGaussianFilter_function_type( &::cv::createGaussianFilter )
            , ( bp::arg("type"), bp::arg("ksize"), bp::arg("sigma1"), bp::arg("sigma2")=0, bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::createLinearFilter
    
        typedef ::cv::Ptr< cv::FilterEngine > ( *createLinearFilter_function_type )( int,int,::cv::Mat const &,::cv::Point,double,int,int,::cv::Scalar const & );
        
        bp::def( 
            "createLinearFilter"
            , createLinearFilter_function_type( &::cv::createLinearFilter )
            , ( bp::arg("srcType"), bp::arg("dstType"), bp::arg("kernel"), bp::arg("_anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("delta")=0, bp::arg("_rowBorderType")=int(::cv::BORDER_REFLECT_101), bp::arg("_columnBorderType")=(int)(-0x000000001), bp::arg("_borderValue")=cv::Scalar_<double>() ) );
    
    }

    { //::cv::createMorphologyFilter
    
        typedef ::cv::Ptr< cv::FilterEngine > ( *createMorphologyFilter_function_type )( int,int,::cv::Mat const &,::cv::Point,int,int,::cv::Scalar const & );
        
        bp::def( 
            "createMorphologyFilter"
            , createMorphologyFilter_function_type( &::cv::createMorphologyFilter )
            , ( bp::arg("op"), bp::arg("type"), bp::arg("kernel"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("_rowBorderType")=int(::cv::BORDER_CONSTANT), bp::arg("_columnBorderType")=(int)(-0x000000001), bp::arg("_borderValue")=cv::morphologyDefaultBorderValue( ) ) );
    
    }

    { //::cv::createSeparableLinearFilter
    
        typedef ::cv::Ptr< cv::FilterEngine > ( *createSeparableLinearFilter_function_type )( int,int,::cv::Mat const &,::cv::Mat const &,::cv::Point,double,int,int,::cv::Scalar const & );
        
        bp::def( 
            "createSeparableLinearFilter"
            , createSeparableLinearFilter_function_type( &::cv::createSeparableLinearFilter )
            , ( bp::arg("srcType"), bp::arg("dstType"), bp::arg("rowKernel"), bp::arg("columnKernel"), bp::arg("_anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("delta")=0, bp::arg("_rowBorderType")=int(::cv::BORDER_REFLECT_101), bp::arg("_columnBorderType")=(int)(-0x000000001), bp::arg("_borderValue")=cv::Scalar_<double>() ) );
    
    }

    { //::cv::cubeRoot
    
        typedef float ( *cubeRoot_function_type )( float );
        
        bp::def( 
            "cubeRoot"
            , cubeRoot_function_type( &::cv::cubeRoot )
            , ( bp::arg("val") ) );
    
    }

    { //::cvApproxChains
    
        typedef ::CvSeq * ( *approxChains_function_type )( ::CvSeq *,::CvMemStorage *,int,double,int,int );
        
        bp::def( 
            "approxChains"
            , approxChains_function_type( &::cvApproxChains )
            , ( bp::arg("src_seq"), bp::arg("storage"), bp::arg("method")=(int)(2), bp::arg("parameter")=0, bp::arg("minimal_perimeter")=(int)(0), bp::arg("recursive")=(int)(0) )
            , bp::with_custodian_and_ward_postcall< 0, 2, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvApproxChains." );
    
    }

    { //::cvAttrValue
    
        typedef char const * ( *attrValue_function_type )( ::CvAttrList const *,char const * );
        
        bp::def( 
            "attrValue"
            , attrValue_function_type( &::cvAttrValue )
            , ( bp::arg("attr"), bp::arg("attr_name") )
            , "\nWrapped function: cvAttrValue." );
    
    }

    { //::cvBlob
    
        typedef ::CvBlob ( *blob_function_type )( float,float,float,float );
        
        bp::def( 
            "blob"
            , blob_function_type( &::cvBlob )
            , ( bp::arg("x"), bp::arg("y"), bp::arg("w"), bp::arg("h") )
            , "\nWrapped function: cvBlob." );
    
    }

    { //::cvBoxPoints
    
        typedef void ( *boxPoints_function_type )( ::CvBox2D,::CvPoint2D32f * );
        
        bp::def( 
            "boxPoints"
            , boxPoints_function_type( &::cvBoxPoints )
            , ( bp::arg("box"), bp::arg("pt") )
            , "\nWrapped function: cvBoxPoints." );
    
    }

    { //::cvCalcSubdivVoronoi2D
    
        typedef void ( *calcSubdivVoronoi2D_function_type )( ::CvSubdiv2D * );
        
        bp::def( 
            "calcSubdivVoronoi2D"
            , calcSubdivVoronoi2D_function_type( &::cvCalcSubdivVoronoi2D )
            , ( bp::arg("subdiv") )
            , "\nWrapped function: cvCalcSubdivVoronoi2D." );
    
    }

    { //::cvCeil
    
        typedef int ( *ceil_function_type )( double );
        
        bp::def( 
            "ceil"
            , ceil_function_type( &::cvCeil )
            , ( bp::arg("value") )
            , "\nWrapped function: cvCeil." );
    
    }

    { //::cvClearMemStorage
    
        typedef void ( *clearMemStorage_function_type )( ::CvMemStorage * );
        
        bp::def( 
            "clearMemStorage"
            , clearMemStorage_function_type( &::cvClearMemStorage )
            , ( bp::arg("storage") )
            , "\nWrapped function: cvClearMemStorage." );
    
    }

    { //::cvClearSeq
    
        typedef void ( *clearSeq_function_type )( ::CvSeq * );
        
        bp::def( 
            "clearSeq"
            , clearSeq_function_type( &::cvClearSeq )
            , ( bp::arg("seq") )
            , "\nWrapped function: cvClearSeq." );
    
    }

    { //::cvClearSet
    
        typedef void ( *clearSet_function_type )( ::CvSet * );
        
        bp::def( 
            "clearSet"
            , clearSet_function_type( &::cvClearSet )
            , ( bp::arg("set_header") )
            , "\nWrapped function: cvClearSet." );
    
    }

    { //::cvClearSubdivVoronoi2D
    
        typedef void ( *clearSubdivVoronoi2D_function_type )( ::CvSubdiv2D * );
        
        bp::def( 
            "clearSubdivVoronoi2D"
            , clearSubdivVoronoi2D_function_type( &::cvClearSubdivVoronoi2D )
            , ( bp::arg("subdiv") )
            , "\nWrapped function: cvClearSubdivVoronoi2D." );
    
    }

    { //::cvCloneSeq
    
        typedef ::CvSeq * ( *cloneSeq_function_type )( ::CvSeq const *,::CvMemStorage * );
        
        bp::def( 
            "cloneSeq"
            , cloneSeq_function_type( &::cvCloneSeq )
            , ( bp::arg("seq"), bp::arg("storage")=bp::object() )
            , bp::with_custodian_and_ward_postcall< 0, 2, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvCloneSeq." );
    
    }

    { //::cvConDensUpdateByTime
    
        typedef void ( *conDensUpdateByTime_function_type )( ::CvConDensation * );
        
        bp::def( 
            "conDensUpdateByTime"
            , conDensUpdateByTime_function_type( &::cvConDensUpdateByTime )
            , ( bp::arg("condens") )
            , "\nWrapped function: cvConDensUpdateByTime." );
    
    }

    { //::cvContourFromContourTree
    
        typedef ::CvSeq * ( *contourFromContourTree_function_type )( ::CvContourTree const *,::CvMemStorage *,::CvTermCriteria );
        
        bp::def( 
            "contourFromContourTree"
            , contourFromContourTree_function_type( &::cvContourFromContourTree )
            , ( bp::arg("tree"), bp::arg("storage"), bp::arg("criteria") )
            , bp::with_custodian_and_ward_postcall< 0, 2, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvContourFromContourTree." );
    
    }

    { //::cvCreateChildMemStorage
    
        typedef ::CvMemStorage * ( *createChildMemStorage_function_type )( ::CvMemStorage * );
        
        bp::def( 
            "createChildMemStorage"
            , createChildMemStorage_function_type( &::cvCreateChildMemStorage )
            , ( bp::arg("parent") )
            , bp::with_custodian_and_ward_postcall< 0, 1, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvCreateChildMemStorage." );
    
    }

    { //::cvCreateConDensation
    
        typedef ::CvConDensation * ( *createConDensation_function_type )( int,int,int );
        
        bp::def( 
            "createConDensation"
            , createConDensation_function_type( &::cvCreateConDensation )
            , ( bp::arg("dynam_params"), bp::arg("measure_params"), bp::arg("sample_count") )
            , bp::with_ownershiplevel_postcall< 1, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvCreateConDensation." );
    
    }

    { //::cvCreateContourTree
    
        typedef ::CvContourTree * ( *createContourTree_function_type )( ::CvSeq const *,::CvMemStorage *,double );
        
        bp::def( 
            "createContourTree"
            , createContourTree_function_type( &::cvCreateContourTree )
            , ( bp::arg("contour"), bp::arg("storage"), bp::arg("threshold") )
            , bp::with_custodian_and_ward_postcall< 0, 2, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvCreateContourTree." );
    
    }

    { //::cvCreateLSH
    
        typedef ::CvLSH * ( *createLSH_function_type )( ::CvLSHOperations *,int,int,int,int,double,::int64 );
        
        bp::def( 
            "createLSH"
            , createLSH_function_type( &::cvCreateLSH )
            , ( bp::arg("ops"), bp::arg("d"), bp::arg("L")=(int)(10), bp::arg("k")=(int)(10), bp::arg("type")=(int)(6), bp::arg("r")=4, bp::arg("seed")=(::int64)(-0x000000001) )
            , bp::with_ownershiplevel_postcall< 1, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvCreateLSH." );
    
    }

    { //::cvCreateMemStorage
    
        typedef ::CvMemStorage * ( *createMemStorage_function_type )( int );
        
        bp::def( 
            "createMemStorage"
            , createMemStorage_function_type( &::cvCreateMemStorage )
            , ( bp::arg("block_size")=(int)(0) )
            , bp::with_ownershiplevel_postcall< 1, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvCreateMemStorage." );
    
    }

    { //::cvCreateMemoryLSH
    
        typedef ::CvLSH * ( *createMemoryLSH_function_type )( int,int,int,int,int,double,::int64 );
        
        bp::def( 
            "createMemoryLSH"
            , createMemoryLSH_function_type( &::cvCreateMemoryLSH )
            , ( bp::arg("d"), bp::arg("n"), bp::arg("L")=(int)(10), bp::arg("k")=(int)(10), bp::arg("type")=(int)(6), bp::arg("r")=4, bp::arg("seed")=(::int64)(-0x000000001) )
            , bp::with_ownershiplevel_postcall< 1, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvCreateMemoryLSH." );
    
    }

    { //::cvCreatePOSITObject
    
        typedef ::CvPOSITObject * ( *createPOSITObject_function_type )( ::CvPoint3D32f *,int );
        
        bp::def( 
            "createPOSITObject"
            , createPOSITObject_function_type( &::cvCreatePOSITObject )
            , ( bp::arg("points"), bp::arg("point_count") )
            , bp::with_ownershiplevel_postcall< 1, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvCreatePOSITObject." );
    
    }

    { //::cvCreateSeq
    
        typedef ::CvSeq * ( *createSeq_function_type )( int,int,int,::CvMemStorage * );
        
        bp::def( 
            "createSeq"
            , createSeq_function_type( &::cvCreateSeq )
            , ( bp::arg("seq_flags"), bp::arg("header_size"), bp::arg("elem_size"), bp::arg("storage") )
            , bp::with_custodian_and_ward_postcall< 0, 4, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvCreateSeq." );
    
    }

    { //::cvCreateSeqBlock
    
        typedef void ( *createSeqBlock_function_type )( ::CvSeqWriter * );
        
        bp::def( 
            "createSeqBlock"
            , createSeqBlock_function_type( &::cvCreateSeqBlock )
            , ( bp::arg("writer") )
            , "\nWrapped function: cvCreateSeqBlock." );
    
    }

    { //::cvCreateSet
    
        typedef ::CvSet * ( *createSet_function_type )( int,int,int,::CvMemStorage * );
        
        bp::def( 
            "createSet"
            , createSet_function_type( &::cvCreateSet )
            , ( bp::arg("set_flags"), bp::arg("header_size"), bp::arg("elem_size"), bp::arg("storage") )
            , bp::with_custodian_and_ward_postcall< 0, 4, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvCreateSet." );
    
    }

    { //::cvCreateStereoGCState
    
        typedef ::CvStereoGCState * ( *createStereoGCState_function_type )( int,int );
        
        bp::def( 
            "createStereoGCState"
            , createStereoGCState_function_type( &::cvCreateStereoGCState )
            , ( bp::arg("numberOfDisparities"), bp::arg("maxIters") )
            , bp::with_ownershiplevel_postcall< 1, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvCreateStereoGCState." );
    
    }

    { //::cvCreateSubdiv2D
    
        typedef ::CvSubdiv2D * ( *createSubdiv2D_function_type )( int,int,int,int,::CvMemStorage * );
        
        bp::def( 
            "createSubdiv2D"
            , createSubdiv2D_function_type( &::cvCreateSubdiv2D )
            , ( bp::arg("subdiv_type"), bp::arg("header_size"), bp::arg("vtx_size"), bp::arg("quadedge_size"), bp::arg("storage") )
            , bp::with_custodian_and_ward_postcall< 0, 5, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvCreateSubdiv2D." );
    
    }

    { //::cvCreateSubdivDelaunay2D
    
        typedef ::CvSubdiv2D * ( *createSubdivDelaunay2D_function_type )( ::CvRect,::CvMemStorage * );
        
        bp::def( 
            "createSubdivDelaunay2D"
            , createSubdivDelaunay2D_function_type( &::cvCreateSubdivDelaunay2D )
            , ( bp::arg("rect"), bp::arg("storage") )
            , bp::with_custodian_and_ward_postcall< 0, 2, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvCreateSubdivDelaunay2D." );
    
    }

    { //::cvDestroyAllWindows
    
        typedef void ( *_cvDestroyAllWindows_function_type )(  );
        
        bp::def( 
            "_cvDestroyAllWindows"
            , _cvDestroyAllWindows_function_type( &::cvDestroyAllWindows )
            , "\nWrapped function: cvDestroyAllWindows." );
    
    }

    { //::cvDestroyWindow
    
        typedef void ( *_cvDestroyWindow_function_type )( char const * );
        
        bp::def( 
            "_cvDestroyWindow"
            , _cvDestroyWindow_function_type( &::cvDestroyWindow )
            , ( bp::arg("name") )
            , "\nWrapped function: cvDestroyWindow." );
    
    }

    { //::cvDetectedBlob
    
        typedef ::CvDetectedBlob ( *detectedBlob_function_type )( float,float,float,float,int,float );
        
        bp::def( 
            "detectedBlob"
            , detectedBlob_function_type( &::cvDetectedBlob )
            , ( bp::arg("x"), bp::arg("y"), bp::arg("w"), bp::arg("h"), bp::arg("ID")=(int)(0), bp::arg("response")=0.0f )
            , "\nWrapped function: cvDetectedBlob." );
    
    }

    { //::cvEndFindContours
    
        typedef ::CvSeq * ( *_cvEndFindContours_function_type )( ::CvContourScanner * );
        
        bp::def( 
            "_cvEndFindContours"
            , _cvEndFindContours_function_type( &::cvEndFindContours )
            , ( bp::arg("scanner") )
            , bp::with_custodian_and_ward_postcall< 0, 1, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvEndFindContours." );
    
    }

    { //::cvEndWriteSeq
    
        typedef ::CvSeq * ( *endWriteSeq_function_type )( ::CvSeqWriter * );
        
        bp::def( 
            "endWriteSeq"
            , endWriteSeq_function_type( &::cvEndWriteSeq )
            , ( bp::arg("writer") )
            , bp::with_custodian_and_ward_postcall< 0, 1, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvEndWriteSeq." );
    
    }

    { //::cvError
    
        typedef void ( *error_function_type )( int,char const *,char const *,char const *,int );
        
        bp::def( 
            "error"
            , error_function_type( &::cvError )
            , ( bp::arg("status"), bp::arg("func_name"), bp::arg("err_msg"), bp::arg("file_name"), bp::arg("line") )
            , "\nWrapped function: cvError." );
    
    }

    { //::cvErrorFromIppStatus
    
        typedef int ( *errorFromIppStatus_function_type )( int );
        
        bp::def( 
            "errorFromIppStatus"
            , errorFromIppStatus_function_type( &::cvErrorFromIppStatus )
            , ( bp::arg("ipp_status") )
            , "\nWrapped function: cvErrorFromIppStatus." );
    
    }

    { //::cvErrorStr
    
        typedef char const * ( *errorStr_function_type )( int );
        
        bp::def( 
            "errorStr"
            , errorStr_function_type( &::cvErrorStr )
            , ( bp::arg("status") )
            , "\nWrapped function: cvErrorStr." );
    
    }

    { //::cvFindDominantPoints
    
        typedef ::CvSeq * ( *findDominantPoints_function_type )( ::CvSeq *,::CvMemStorage *,int,double,double,double,double );
        
        bp::def( 
            "findDominantPoints"
            , findDominantPoints_function_type( &::cvFindDominantPoints )
            , ( bp::arg("contour"), bp::arg("storage"), bp::arg("method")=(int)(1), bp::arg("parameter1")=0, bp::arg("parameter2")=0, bp::arg("parameter3")=0, bp::arg("parameter4")=0 )
            , bp::with_custodian_and_ward_postcall< 0, 2, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvFindDominantPoints." );
    
    }

    { //::cvFindNextContour
    
        typedef ::CvSeq * ( *findNextContour_function_type )( ::CvContourScanner );
        
        bp::def( 
            "findNextContour"
            , findNextContour_function_type( &::cvFindNextContour )
            , ( bp::arg("scanner") )
            , bp::with_custodian_and_ward_postcall< 0, 1, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvFindNextContour." );
    
    }

    { //::cvFindType
    
        typedef ::CvTypeInfo * ( *findType_function_type )( char const * );
        
        bp::def( 
            "findType"
            , findType_function_type( &::cvFindType )
            , ( bp::arg("type_name") )
            , bp::return_value_policy< bp::reference_existing_object >()
            , "\nWrapped function: cvFindType." );
    
    }

    { //::cvFirstType
    
        typedef ::CvTypeInfo * ( *firstType_function_type )(  );
        
        bp::def( 
            "firstType"
            , firstType_function_type( &::cvFirstType )
            , bp::return_value_policy< bp::reference_existing_object >()
            , "\nWrapped function: cvFirstType." );
    
    }

    { //::cvFloor
    
        typedef int ( *floor_function_type )( double );
        
        bp::def( 
            "floor"
            , floor_function_type( &::cvFloor )
            , ( bp::arg("value") )
            , "\nWrapped function: cvFloor." );
    
    }

    { //::cvFlushSeqWriter
    
        typedef void ( *flushSeqWriter_function_type )( ::CvSeqWriter * );
        
        bp::def( 
            "flushSeqWriter"
            , flushSeqWriter_function_type( &::cvFlushSeqWriter )
            , ( bp::arg("writer") )
            , "\nWrapped function: cvFlushSeqWriter." );
    
    }

    { //::cvGetErrMode
    
        typedef int ( *getErrMode_function_type )(  );
        
        bp::def( 
            "getErrMode"
            , getErrMode_function_type( &::cvGetErrMode )
            , "\nWrapped function: cvGetErrMode." );
    
    }

    { //::cvGetErrStatus
    
        typedef int ( *getErrStatus_function_type )(  );
        
        bp::def( 
            "getErrStatus"
            , getErrStatus_function_type( &::cvGetErrStatus )
            , "\nWrapped function: cvGetErrStatus." );
    
    }

    { //::cvGetNumThreads
    
        typedef int ( *getNumThreads_function_type )(  );
        
        bp::def( 
            "getNumThreads"
            , getNumThreads_function_type( &::cvGetNumThreads )
            , "\nWrapped function: cvGetNumThreads." );
    
    }

    { //::cvGetRootFileNode
    
        typedef ::CvFileNode * ( *getRootFileNode_function_type )( ::CvFileStorage const *,int );
        
        bp::def( 
            "getRootFileNode"
            , getRootFileNode_function_type( &::cvGetRootFileNode )
            , ( bp::arg("fs"), bp::arg("stream_index")=(int)(0) )
            , bp::with_custodian_and_ward_postcall< 0, 1, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvGetRootFileNode." );
    
    }

    { //::cvGetSeqReaderPos
    
        typedef int ( *getSeqReaderPos_function_type )( ::CvSeqReader * );
        
        bp::def( 
            "getSeqReaderPos"
            , getSeqReaderPos_function_type( &::cvGetSeqReaderPos )
            , ( bp::arg("reader") )
            , "\nWrapped function: cvGetSeqReaderPos." );
    
    }

    { //::cvGetSetElem
    
        typedef ::CvSetElem * ( *getSetElem_function_type )( ::CvSet const *,int );
        
        bp::def( 
            "getSetElem"
            , getSetElem_function_type( &::cvGetSetElem )
            , ( bp::arg("set_header"), bp::arg("index") )
            , bp::with_custodian_and_ward_postcall< 0, 1, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvGetSetElem." );
    
    }

    { //::cvGetThreadNum
    
        typedef int ( *getThreadNum_function_type )(  );
        
        bp::def( 
            "getThreadNum"
            , getThreadNum_function_type( &::cvGetThreadNum )
            , "\nWrapped function: cvGetThreadNum." );
    
    }

    { //::cvGetTickCount
    
        typedef ::int64 ( *getTickCount_function_type )(  );
        
        bp::def( 
            "getTickCount"
            , getTickCount_function_type( &::cvGetTickCount )
            , "\nWrapped function: cvGetTickCount." );
    
    }

    { //::cvGetTickFrequency
    
        typedef double ( *getTickFrequency_function_type )(  );
        
        bp::def( 
            "getTickFrequency"
            , getTickFrequency_function_type( &::cvGetTickFrequency )
            , "\nWrapped function: cvGetTickFrequency." );
    
    }

    { //::cvGetTrackbarPos
    
        typedef int ( *getTrackbarPos_function_type )( char const *,char const * );
        
        bp::def( 
            "getTrackbarPos"
            , getTrackbarPos_function_type( &::cvGetTrackbarPos )
            , ( bp::arg("trackbar_name"), bp::arg("window_name") )
            , "\nWrapped function: cvGetTrackbarPos." );
    
    }

    { //::cvGetWindowName
    
        typedef char const * ( *getWindowName_function_type )( void * );
        
        bp::def( 
            "getWindowName"
            , getWindowName_function_type( &::cvGetWindowName )
            , ( bp::arg("window_handle") )
            , "\nWrapped function: cvGetWindowName." );
    
    }

    { //::cvInitSubdivDelaunay2D
    
        typedef void ( *initSubdivDelaunay2D_function_type )( ::CvSubdiv2D *,::CvRect );
        
        bp::def( 
            "initSubdivDelaunay2D"
            , initSubdivDelaunay2D_function_type( &::cvInitSubdivDelaunay2D )
            , ( bp::arg("subdiv"), bp::arg("rect") )
            , "\nWrapped function: cvInitSubdivDelaunay2D." );
    
    }

    { //::cvIsInf
    
        typedef int ( *isInf_function_type )( double );
        
        bp::def( 
            "isInf"
            , isInf_function_type( &::cvIsInf )
            , ( bp::arg("value") )
            , "\nWrapped function: cvIsInf." );
    
    }

    { //::cvIsNaN
    
        typedef int ( *isNaN_function_type )( double );
        
        bp::def( 
            "isNaN"
            , isNaN_function_type( &::cvIsNaN )
            , ( bp::arg("value") )
            , "\nWrapped function: cvIsNaN." );
    
    }

    { //::cvMatchContourTrees
    
        typedef double ( *matchContourTrees_function_type )( ::CvContourTree const *,::CvContourTree const *,int,double );
        
        bp::def( 
            "matchContourTrees"
            , matchContourTrees_function_type( &::cvMatchContourTrees )
            , ( bp::arg("tree1"), bp::arg("tree2"), bp::arg("method"), bp::arg("threshold") )
            , "\nWrapped function: cvMatchContourTrees." );
    
    }

    { //::cvMaxRect
    
        typedef ::CvRect ( *maxRect_function_type )( ::CvRect const *,::CvRect const * );
        
        bp::def( 
            "maxRect"
            , maxRect_function_type( &::cvMaxRect )
            , ( bp::arg("rect1"), bp::arg("rect2") )
            , "\nWrapped function: cvMaxRect." );
    
    }

    { //::cvMemStorageAllocString
    
        typedef ::CvString ( *memStorageAllocString_function_type )( ::CvMemStorage *,char const *,int );
        
        bp::def( 
            "memStorageAllocString"
            , memStorageAllocString_function_type( &::cvMemStorageAllocString )
            , ( bp::arg("storage"), bp::arg("ptr"), bp::arg("len")=(int)(-0x000000001) )
            , bp::with_custodian_and_ward_postcall< 0, 1 >()
            , "\nWrapped function: cvMemStorageAllocString." );
    
    }

    { //::cvMoveWindow
    
        typedef void ( *moveWindow_function_type )( char const *,int,int );
        
        bp::def( 
            "moveWindow"
            , moveWindow_function_type( &::cvMoveWindow )
            , ( bp::arg("name"), bp::arg("x"), bp::arg("y") )
            , "\nWrapped function: cvMoveWindow." );
    
    }

    { //::cvNextNArraySlice
    
        typedef int ( *nextNArraySlice_function_type )( ::CvNArrayIterator * );
        
        bp::def( 
            "nextNArraySlice"
            , nextNArraySlice_function_type( &::cvNextNArraySlice )
            , ( bp::arg("array_iterator") )
            , "\nWrapped function: cvNextNArraySlice." );
    
    }

    { //::cvOpenFileStorage
    
        typedef ::CvFileStorage * ( *openFileStorage_function_type )( char const *,::CvMemStorage *,int );
        
        bp::def( 
            "openFileStorage"
            , openFileStorage_function_type( &::cvOpenFileStorage )
            , ( bp::arg("filename"), bp::arg("memstorage"), bp::arg("flags") )
            , bp::with_ownershiplevel_postcall< 1, bp::with_custodian_and_ward_postcall< 0, 2, bp::return_value_policy< bp::reference_existing_object > > >()
            , "\nWrapped function: cvOpenFileStorage." );
    
    }

    { //::cvPOSIT
    
        typedef void ( *POSIT_function_type )( ::CvPOSITObject *,::CvPoint2D32f *,double,::CvTermCriteria,::CvMatr32f,::CvVect32f );
        
        bp::def( 
            "POSIT"
            , POSIT_function_type( &::cvPOSIT )
            , ( bp::arg("posit_object"), bp::arg("image_points"), bp::arg("focal_length"), bp::arg("criteria"), bp::arg("rotation_matrix"), bp::arg("translation_vector") )
            , "\nWrapped function: cvPOSIT." );
    
    }

    { //::cvRANSACUpdateNumIters
    
        typedef int ( *RANSACUpdateNumIters_function_type )( double,double,int,int );
        
        bp::def( 
            "RANSACUpdateNumIters"
            , RANSACUpdateNumIters_function_type( &::cvRANSACUpdateNumIters )
            , ( bp::arg("p"), bp::arg("err_prob"), bp::arg("model_points"), bp::arg("max_iters") )
            , "\nWrapped function: cvRANSACUpdateNumIters." );
    
    }

    { //::cvReadChainPoint
    
        typedef ::CvPoint ( *readChainPoint_function_type )( ::CvChainPtReader * );
        
        bp::def( 
            "readChainPoint"
            , readChainPoint_function_type( &::cvReadChainPoint )
            , ( bp::arg("reader") )
            , "\nWrapped function: cvReadChainPoint." );
    
    }

    { //::cvRegisterModule
    
        typedef int ( *registerModule_function_type )( ::CvModuleInfo const * );
        
        bp::def( 
            "registerModule"
            , registerModule_function_type( &::cvRegisterModule )
            , ( bp::arg("module_info") )
            , "\nWrapped function: cvRegisterModule." );
    
    }

    { //::cvRegisterType
    
        typedef void ( *registerType_function_type )( ::CvTypeInfo const * );
        
        bp::def( 
            "registerType"
            , registerType_function_type( &::cvRegisterType )
            , ( bp::arg("info") )
            , "\nWrapped function: cvRegisterType." );
    
    }

    { //::cvReleaseFeatureTree
    
        typedef void ( *_cvReleaseFeatureTree_function_type )( ::CvFeatureTree * );
        
        bp::def( 
            "_cvReleaseFeatureTree"
            , _cvReleaseFeatureTree_function_type( &::cvReleaseFeatureTree )
            , ( bp::arg("tr") )
            , "\nWrapped function: cvReleaseFeatureTree." );
    
    }

    { //::cvReleaseLSH
    
        typedef void ( *_cvReleaseLSH_function_type )( ::CvLSH * * );
        
        bp::def( 
            "_cvReleaseLSH"
            , _cvReleaseLSH_function_type( &::cvReleaseLSH )
            , ( bp::arg("lsh") )
            , "\nWrapped function: cvReleaseLSH." );
    
    }

    { //::cvResizeWindow
    
        typedef void ( *resizeWindow_function_type )( char const *,int,int );
        
        bp::def( 
            "resizeWindow"
            , resizeWindow_function_type( &::cvResizeWindow )
            , ( bp::arg("name"), bp::arg("width"), bp::arg("height") )
            , "\nWrapped function: cvResizeWindow." );
    
    }

    { //::cvRestoreMemStoragePos
    
        typedef void ( *restoreMemStoragePos_function_type )( ::CvMemStorage *,::CvMemStoragePos * );
        
        bp::def( 
            "restoreMemStoragePos"
            , restoreMemStoragePos_function_type( &::cvRestoreMemStoragePos )
            , ( bp::arg("storage"), bp::arg("pos") )
            , "\nWrapped function: cvRestoreMemStoragePos." );
    
    }

    { //::cvRound
    
        typedef int ( *round_function_type )( double );
        
        bp::def( 
            "round"
            , round_function_type( &::cvRound )
            , ( bp::arg("value") )
            , "\nWrapped function: cvRound." );
    
    }

    { //::cvSaveMemStoragePos
    
        typedef void ( *saveMemStoragePos_function_type )( ::CvMemStorage const *,::CvMemStoragePos * );
        
        bp::def( 
            "saveMemStoragePos"
            , saveMemStoragePos_function_type( &::cvSaveMemStoragePos )
            , ( bp::arg("storage"), bp::arg("pos") )
            , "\nWrapped function: cvSaveMemStoragePos." );
    
    }

    { //::cvSeqInvert
    
        typedef void ( *seqInvert_function_type )( ::CvSeq * );
        
        bp::def( 
            "seqInvert"
            , seqInvert_function_type( &::cvSeqInvert )
            , ( bp::arg("seq") )
            , "\nWrapped function: cvSeqInvert." );
    
    }

    { //::cvSeqRemove
    
        typedef void ( *seqRemove_function_type )( ::CvSeq *,int );
        
        bp::def( 
            "seqRemove"
            , seqRemove_function_type( &::cvSeqRemove )
            , ( bp::arg("seq"), bp::arg("index") )
            , "\nWrapped function: cvSeqRemove." );
    
    }

    { //::cvSeqRemoveSlice
    
        typedef void ( *seqRemoveSlice_function_type )( ::CvSeq *,::CvSlice );
        
        bp::def( 
            "seqRemoveSlice"
            , seqRemoveSlice_function_type( &::cvSeqRemoveSlice )
            , ( bp::arg("seq"), bp::arg("slice") )
            , "\nWrapped function: cvSeqRemoveSlice." );
    
    }

    { //::cvSeqSlice
    
        typedef ::CvSeq * ( *seqSlice_function_type )( ::CvSeq const *,::CvSlice,::CvMemStorage *,int );
        
        bp::def( 
            "seqSlice"
            , seqSlice_function_type( &::cvSeqSlice )
            , ( bp::arg("seq"), bp::arg("slice"), bp::arg("storage")=bp::object(), bp::arg("copy_data")=(int)(0) )
            , bp::with_custodian_and_ward_postcall< 0, 3, bp::return_value_policy< bp::reference_existing_object > >()
            , "\nWrapped function: cvSeqSlice." );
    
    }

    { //::cvSetErrMode
    
        typedef int ( *setErrMode_function_type )( int );
        
        bp::def( 
            "setErrMode"
            , setErrMode_function_type( &::cvSetErrMode )
            , ( bp::arg("mode") )
            , "\nWrapped function: cvSetErrMode." );
    
    }

    { //::cvSetErrStatus
    
        typedef void ( *setErrStatus_function_type )( int );
        
        bp::def( 
            "setErrStatus"
            , setErrStatus_function_type( &::cvSetErrStatus )
            , ( bp::arg("status") )
            , "\nWrapped function: cvSetErrStatus." );
    
    }

    { //::cvSetNumThreads
    
        typedef void ( *setNumThreads_function_type )( int );
        
        bp::def( 
            "setNumThreads"
            , setNumThreads_function_type( &::cvSetNumThreads )
            , ( bp::arg("threads")=(int)(0) )
            , "\nWrapped function: cvSetNumThreads." );
    
    }

    { //::cvSetRemove
    
        typedef void ( *setRemove_function_type )( ::CvSet *,int );
        
        bp::def( 
            "setRemove"
            , setRemove_function_type( &::cvSetRemove )
            , ( bp::arg("set_header"), bp::arg("index") )
            , "\nWrapped function: cvSetRemove." );
    
    }

    { //::cvSetSeqBlockSize
    
        typedef void ( *setSeqBlockSize_function_type )( ::CvSeq *,int );
        
        bp::def( 
            "setSeqBlockSize"
            , setSeqBlockSize_function_type( &::cvSetSeqBlockSize )
            , ( bp::arg("seq"), bp::arg("delta_elems") )
            , "\nWrapped function: cvSetSeqBlockSize." );
    
    }

    { //::cvSetSeqReaderPos
    
        typedef void ( *setSeqReaderPos_function_type )( ::CvSeqReader *,int,int );
        
        bp::def( 
            "setSeqReaderPos"
            , setSeqReaderPos_function_type( &::cvSetSeqReaderPos )
            , ( bp::arg("reader"), bp::arg("index"), bp::arg("is_relative")=(int)(0) )
            , "\nWrapped function: cvSetSeqReaderPos." );
    
    }

    { //::cvSetTrackbarPos
    
        typedef void ( *setTrackbarPos_function_type )( char const *,char const *,int );
        
        bp::def( 
            "setTrackbarPos"
            , setTrackbarPos_function_type( &::cvSetTrackbarPos )
            , ( bp::arg("trackbar_name"), bp::arg("window_name"), bp::arg("pos") )
            , "\nWrapped function: cvSetTrackbarPos." );
    
    }

    { //::cvSliceLength
    
        typedef int ( *sliceLength_function_type )( ::CvSlice,::CvSeq const * );
        
        bp::def( 
            "sliceLength"
            , sliceLength_function_type( &::cvSliceLength )
            , ( bp::arg("slice"), bp::arg("seq") )
            , "\nWrapped function: cvSliceLength." );
    
    }

    { //::cvStarKeypoint
    
        typedef ::CvStarKeypoint ( *starKeypoint_function_type )( ::CvPoint,int,float );
        
        bp::def( 
            "starKeypoint"
            , starKeypoint_function_type( &::cvStarKeypoint )
            , ( bp::arg("pt"), bp::arg("size"), bp::arg("response") )
            , "\nWrapped function: cvStarKeypoint." );
    
    }

    { //::cvStartAppendToSeq
    
        typedef void ( *startAppendToSeq_function_type )( ::CvSeq *,::CvSeqWriter * );
        
        bp::def( 
            "startAppendToSeq"
            , startAppendToSeq_function_type( &::cvStartAppendToSeq )
            , ( bp::arg("seq"), bp::arg("writer") )
            , "\nWrapped function: cvStartAppendToSeq." );
    
    }

    { //::cvStartReadChainPoints
    
        typedef void ( *startReadChainPoints_function_type )( ::CvChain *,::CvChainPtReader * );
        
        bp::def( 
            "startReadChainPoints"
            , startReadChainPoints_function_type( &::cvStartReadChainPoints )
            , ( bp::arg("chain"), bp::arg("reader") )
            , "\nWrapped function: cvStartReadChainPoints." );
    
    }

    { //::cvStartReadSeq
    
        typedef void ( *startReadSeq_function_type )( ::CvSeq const *,::CvSeqReader *,int );
        
        bp::def( 
            "startReadSeq"
            , startReadSeq_function_type( &::cvStartReadSeq )
            , ( bp::arg("seq"), bp::arg("reader"), bp::arg("reverse")=(int)(0) )
            , "\nWrapped function: cvStartReadSeq." );
    
    }

    { //::cvStartWindowThread
    
        typedef int ( *startWindowThread_function_type )(  );
        
        bp::def( 
            "startWindowThread"
            , startWindowThread_function_type( &::cvStartWindowThread )
            , "\nWrapped function: cvStartWindowThread." );
    
    }

    { //::cvStartWriteSeq
    
        typedef void ( *startWriteSeq_function_type )( int,int,int,::CvMemStorage *,::CvSeqWriter * );
        
        bp::def( 
            "startWriteSeq"
            , startWriteSeq_function_type( &::cvStartWriteSeq )
            , ( bp::arg("seq_flags"), bp::arg("header_size"), bp::arg("elem_size"), bp::arg("storage"), bp::arg("writer") )
            , "\nWrapped function: cvStartWriteSeq." );
    
    }

    { //::cvSubdiv2DEdgeDst
    
        typedef ::CvSubdiv2DPoint * ( *subdiv2DEdgeDst_function_type )( ::CvSubdiv2DEdge );
        
        bp::def( 
            "subdiv2DEdgeDst"
            , subdiv2DEdgeDst_function_type( &::cvSubdiv2DEdgeDst )
            , ( bp::arg("edge") )
            , bp::return_value_policy< bp::reference_existing_object >()
            , "\nWrapped function: cvSubdiv2DEdgeDst." );
    
    }

    { //::cvSubdiv2DEdgeOrg
    
        typedef ::CvSubdiv2DPoint * ( *subdiv2DEdgeOrg_function_type )( ::CvSubdiv2DEdge );
        
        bp::def( 
            "subdiv2DEdgeOrg"
            , subdiv2DEdgeOrg_function_type( &::cvSubdiv2DEdgeOrg )
            , ( bp::arg("edge") )
            , bp::return_value_policy< bp::reference_existing_object >()
            , "\nWrapped function: cvSubdiv2DEdgeOrg." );
    
    }

    { //::cvSubdiv2DGetEdge
    
        typedef ::CvSubdiv2DEdge ( *subdiv2DGetEdge_function_type )( ::CvSubdiv2DEdge,::CvNextEdgeType );
        
        bp::def( 
            "subdiv2DGetEdge"
            , subdiv2DGetEdge_function_type( &::cvSubdiv2DGetEdge )
            , ( bp::arg("edge"), bp::arg("type") )
            , "\nWrapped function: cvSubdiv2DGetEdge." );
    
    }

    { //::cvSubdiv2DNextEdge
    
        typedef ::CvSubdiv2DEdge ( *subdiv2DNextEdge_function_type )( ::CvSubdiv2DEdge );
        
        bp::def( 
            "subdiv2DNextEdge"
            , subdiv2DNextEdge_function_type( &::cvSubdiv2DNextEdge )
            , ( bp::arg("edge") )
            , "\nWrapped function: cvSubdiv2DNextEdge." );
    
    }

    { //::cvSubdiv2DRotateEdge
    
        typedef ::CvSubdiv2DEdge ( *subdiv2DRotateEdge_function_type )( ::CvSubdiv2DEdge,int );
        
        bp::def( 
            "subdiv2DRotateEdge"
            , subdiv2DRotateEdge_function_type( &::cvSubdiv2DRotateEdge )
            , ( bp::arg("edge"), bp::arg("rotate") )
            , "\nWrapped function: cvSubdiv2DRotateEdge." );
    
    }

    { //::cvSubdiv2DSymEdge
    
        typedef ::CvSubdiv2DEdge ( *subdiv2DSymEdge_function_type )( ::CvSubdiv2DEdge );
        
        bp::def( 
            "subdiv2DSymEdge"
            , subdiv2DSymEdge_function_type( &::cvSubdiv2DSymEdge )
            , ( bp::arg("edge") )
            , "\nWrapped function: cvSubdiv2DSymEdge." );
    
    }

    { //::cvSubstituteContour
    
        typedef void ( *substituteContour_function_type )( ::CvContourScanner,::CvSeq * );
        
        bp::def( 
            "substituteContour"
            , substituteContour_function_type( &::cvSubstituteContour )
            , ( bp::arg("scanner"), bp::arg("new_contour") )
            , "\nWrapped function: cvSubstituteContour." );
    
    }

    { //::cvUnregisterType
    
        typedef void ( *unregisterType_function_type )( char const * );
        
        bp::def( 
            "unregisterType"
            , unregisterType_function_type( &::cvUnregisterType )
            , ( bp::arg("type_name") )
            , "\nWrapped function: cvUnregisterType." );
    
    }

    { //::cvUseOptimized
    
        typedef int ( *useOptimized_function_type )( int );
        
        bp::def( 
            "useOptimized"
            , useOptimized_function_type( &::cvUseOptimized )
            , ( bp::arg("on_off") )
            , "\nWrapped function: cvUseOptimized." );
    
    }

    { //::cv::cvtColor
    
        typedef void ( *cvtColor_function_type )( ::cv::Mat const &,::cv::Mat &,int,int );
        
        bp::def( 
            "cvtColor"
            , cvtColor_function_type( &::cv::cvtColor )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("code"), bp::arg("dstCn")=(int)(0) ) );
    
    }

    { //::cv::dct
    
        typedef void ( *dct_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "dct"
            , dct_function_type( &::cv::dct )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("flags")=(int)(0) ) );
    
    }

    { //::cv::decomposeProjectionMatrix
    
        typedef void ( *decomposeProjectionMatrix_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Vec3d & );
        
        bp::def( 
            "decomposeProjectionMatrix"
            , decomposeProjectionMatrix_function_type( &::cv::decomposeProjectionMatrix )
            , ( bp::arg("projMatrix"), bp::arg("cameraMatrix"), bp::arg("rotMatrix"), bp::arg("transVect"), bp::arg("rotMatrixX"), bp::arg("rotMatrixY"), bp::arg("rotMatrixZ"), bp::arg("eulerAngles") ) );
    
    }

    { //::cv::decomposeProjectionMatrix
    
        typedef void ( *decomposeProjectionMatrix_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "decomposeProjectionMatrix"
            , decomposeProjectionMatrix_function_type( &::cv::decomposeProjectionMatrix )
            , ( bp::arg("projMatrix"), bp::arg("cameraMatrix"), bp::arg("rotMatrix"), bp::arg("transVect") ) );
    
    }

    { //::cv::determinant
    
        typedef double ( *determinant_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "determinant"
            , determinant_function_type( &::cv::determinant )
            , ( bp::arg("m") ) );
    
    }

    { //::cv::dft
    
        typedef void ( *dft_function_type )( ::cv::Mat const &,::cv::Mat &,int,int );
        
        bp::def( 
            "dft"
            , dft_function_type( &::cv::dft )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("flags")=(int)(0), bp::arg("nonzeroRows")=(int)(0) ) );
    
    }

    { //::cv::dilate
    
        typedef void ( *dilate_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,::cv::Point,int,int,::cv::Scalar const & );
        
        bp::def( 
            "dilate"
            , dilate_function_type( &::cv::dilate )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("kernel"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("iterations")=(int)(1), bp::arg("borderType")=int(::cv::BORDER_CONSTANT), bp::arg("borderValue")=cv::morphologyDefaultBorderValue( ) ) );
    
    }

    { //::cv::distanceTransform
    
        typedef void ( *distanceTransform_function_type )( ::cv::Mat const &,::cv::Mat &,int,int );
        
        bp::def( 
            "distanceTransform"
            , distanceTransform_function_type( &::cv::distanceTransform )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("distanceType"), bp::arg("maskSize") ) );
    
    }

    { //::cv::distanceTransform
    
        typedef void ( *distanceTransform_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,int,int );
        
        bp::def( 
            "distanceTransform"
            , distanceTransform_function_type( &::cv::distanceTransform )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("labels"), bp::arg("distanceType"), bp::arg("maskSize") ) );
    
    }

    { //::cv::divide
    
        typedef void ( *divide_function_type )( double,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "divide"
            , divide_function_type( &::cv::divide )
            , ( bp::arg("scale"), bp::arg("b"), bp::arg("c") ) );
    
    }

    { //::cv::divide
    
        typedef void ( *divide_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,double );
        
        bp::def( 
            "divide"
            , divide_function_type( &::cv::divide )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("scale")=1 ) );
    
    }

    { //::cv::divide
    
        typedef void ( *divide_function_type )( double,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "divide"
            , divide_function_type( &::cv::divide )
            , ( bp::arg("scale"), bp::arg("b"), bp::arg("c") ) );
    
    }

    { //::cv::divide
    
        typedef void ( *divide_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,double );
        
        bp::def( 
            "divide"
            , divide_function_type( &::cv::divide )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("scale")=1 ) );
    
    }

    { //::cv::drawChessboardCorners
    
        typedef void ( *drawChessboardCorners_function_type )( ::cv::Mat &,::cv::Size,::cv::Mat const &,bool );
        
        bp::def( 
            "drawChessboardCorners"
            , drawChessboardCorners_function_type( &::cv::drawChessboardCorners )
            , ( bp::arg("image"), bp::arg("patternSize"), bp::arg("corners"), bp::arg("patternWasFound") ) );
    
    }

    { //::cv::eigen
    
        typedef bool ( *eigen_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,int,int );
        
        bp::def( 
            "eigen"
            , eigen_function_type( &::cv::eigen )
            , ( bp::arg("a"), bp::arg("eigenvalues"), bp::arg("eigenvectors"), bp::arg("lowindex")=(int)(-0x000000001), bp::arg("highindex")=(int)(-0x000000001) ) );
    
    }

    { //::cv::eigen
    
        typedef bool ( *eigen_function_type )( ::cv::Mat const &,::cv::Mat &,int,int );
        
        bp::def( 
            "eigen"
            , eigen_function_type( &::cv::eigen )
            , ( bp::arg("a"), bp::arg("eigenvalues"), bp::arg("lowindex")=(int)(-0x000000001), bp::arg("highindex")=(int)(-0x000000001) ) );
    
    }

    { //::cv::ellipse
    
        typedef void ( *ellipse_function_type )( ::cv::Mat &,::cv::RotatedRect const &,::cv::Scalar const &,int,int );
        
        bp::def( 
            "ellipse"
            , ellipse_function_type( &::cv::ellipse )
            , ( bp::arg("img"), bp::arg("box"), bp::arg("color"), bp::arg("thickness")=(int)(1), bp::arg("lineType")=(int)(8) ) );
    
    }

    { //::cv::ellipse
    
        typedef void ( *ellipse_function_type )( ::cv::Mat &,::cv::Point,::cv::Size,double,double,double,::cv::Scalar const &,int,int,int );
        
        bp::def( 
            "ellipse"
            , ellipse_function_type( &::cv::ellipse )
            , ( bp::arg("img"), bp::arg("center"), bp::arg("axes"), bp::arg("angle"), bp::arg("startAngle"), bp::arg("endAngle"), bp::arg("color"), bp::arg("thickness")=(int)(1), bp::arg("lineType")=(int)(8), bp::arg("shift")=(int)(0) ) );
    
    }

    { //::cv::equalizeHist
    
        typedef void ( *equalizeHist_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "equalizeHist"
            , equalizeHist_function_type( &::cv::equalizeHist )
            , ( bp::arg("src"), bp::arg("dst") ) );
    
    }

    { //::cv::erode
    
        typedef void ( *erode_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,::cv::Point,int,int,::cv::Scalar const & );
        
        bp::def( 
            "erode"
            , erode_function_type( &::cv::erode )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("kernel"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("iterations")=(int)(1), bp::arg("borderType")=int(::cv::BORDER_CONSTANT), bp::arg("borderValue")=cv::morphologyDefaultBorderValue( ) ) );
    
    }

    { //::std::exp
    
        typedef long double ( *exp_function_type )( long double );
        
        bp::def( 
            "exp"
            , exp_function_type( &::std::exp )
            , ( bp::arg("__x") ) );
    
    }

    { //::std::exp
    
        typedef float ( *exp_function_type )( float );
        
        bp::def( 
            "exp"
            , exp_function_type( &::std::exp )
            , ( bp::arg("__x") ) );
    
    }

    { //::exp
    
        typedef double ( *exp_function_type )( double );
        
        bp::def( 
            "exp"
            , exp_function_type( &::exp )
            , ( bp::arg("arg0") ) );
    
    }

    { //::cv::exp
    
        typedef void ( *exp_function_type )( ::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "exp"
            , exp_function_type( &::cv::exp )
            , ( bp::arg("a"), bp::arg("b") ) );
    
    }

    { //::cv::exp
    
        typedef void ( *exp_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "exp"
            , exp_function_type( &::cv::exp )
            , ( bp::arg("a"), bp::arg("b") ) );
    
    }

    { //::cv::fastAtan2
    
        typedef float ( *fastAtan2_function_type )( float,float );
        
        bp::def( 
            "fastAtan2"
            , fastAtan2_function_type( &::cv::fastAtan2 )
            , ( bp::arg("y"), bp::arg("x") ) );
    
    }

    { //::cv::filter2D
    
        typedef void ( *filter2D_function_type )( ::cv::Mat const &,::cv::Mat &,int,::cv::Mat const &,::cv::Point,double,int );
        
        bp::def( 
            "filter2D"
            , filter2D_function_type( &::cv::filter2D )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ddepth"), bp::arg("kernel"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("delta")=0, bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::findFundamentalMat
    
        typedef ::cv::Mat ( *findFundamentalMat_function_type )( ::cv::Mat const &,::cv::Mat const &,int,double,double );
        
        bp::def( 
            "findFundamentalMat"
            , findFundamentalMat_function_type( &::cv::findFundamentalMat )
            , ( bp::arg("points1"), bp::arg("points2"), bp::arg("method")=int(::cv::FM_RANSAC), bp::arg("param1")=3.0e+0, bp::arg("param2")=9.89999999999999991118215802998747676610946655273e-1 ) );
    
    }

    { //::cv::findHomography
    
        typedef ::cv::Mat ( *findHomography_function_type )( ::cv::Mat const &,::cv::Mat const &,int,double );
        
        bp::def( 
            "findHomography"
            , findHomography_function_type( &::cv::findHomography )
            , ( bp::arg("srcPoints"), bp::arg("dstPoints"), bp::arg("method")=(int)(0), bp::arg("ransacReprojThreshold")=0 ) );
    
    }

    { //::cv::fitEllipse
    
        typedef ::cv::RotatedRect ( *fitEllipse_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "fitEllipse"
            , fitEllipse_function_type( &::cv::fitEllipse )
            , ( bp::arg("points") ) );
    
    }

    { //::cv::fitLine
    
        typedef void ( *fitLine_function_type )( ::cv::Mat const &,::cv::Vec6f &,int,double,double,double );
        
        bp::def( 
            "fitLine"
            , fitLine_function_type( &::cv::fitLine )
            , ( bp::arg("points"), bp::arg("line"), bp::arg("distType"), bp::arg("param"), bp::arg("reps"), bp::arg("aeps") ) );
    
    }

    { //::cv::fitLine
    
        typedef void ( *fitLine_function_type )( ::cv::Mat const &,::cv::Vec4f &,int,double,double,double );
        
        bp::def( 
            "fitLine"
            , fitLine_function_type( &::cv::fitLine )
            , ( bp::arg("points"), bp::arg("line"), bp::arg("distType"), bp::arg("param"), bp::arg("reps"), bp::arg("aeps") ) );
    
    }

    { //::cv::flip
    
        typedef void ( *flip_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "flip"
            , flip_function_type( &::cv::flip )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("flipCode") ) );
    
    }

    { //::cv::fromUtf16
    
        typedef ::std::string ( *fromUtf16_function_type )( ::cv::WString const & );
        
        bp::def( 
            "fromUtf16"
            , fromUtf16_function_type( &::cv::fromUtf16 )
            , ( bp::arg("str") ) );
    
    }

    { //::cv::gemm
    
        typedef void ( *gemm_function_type )( ::cv::Mat const &,::cv::Mat const &,double,::cv::Mat const &,double,::cv::Mat &,int );
        
        bp::def( 
            "gemm"
            , gemm_function_type( &::cv::gemm )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("alpha"), bp::arg("c"), bp::arg("gamma"), bp::arg("d"), bp::arg("flags")=(int)(0) ) );
    
    }

    { //::cv::getColumnSumFilter
    
        typedef ::cv::Ptr< cv::BaseColumnFilter > ( *getColumnSumFilter_function_type )( int,int,int,int,double );
        
        bp::def( 
            "getColumnSumFilter"
            , getColumnSumFilter_function_type( &::cv::getColumnSumFilter )
            , ( bp::arg("sumType"), bp::arg("dstType"), bp::arg("ksize"), bp::arg("anchor")=(int)(-0x000000001), bp::arg("scale")=1 ) );
    
    }

    { //::cv::getDefaultNewCameraMatrix
    
        typedef ::cv::Mat ( *getDefaultNewCameraMatrix_function_type )( ::cv::Mat const &,::cv::Size,bool );
        
        bp::def( 
            "getDefaultNewCameraMatrix"
            , getDefaultNewCameraMatrix_function_type( &::cv::getDefaultNewCameraMatrix )
            , ( bp::arg("cameraMatrix"), bp::arg("imgsize")=cv::Size_<int>(), bp::arg("centerPrincipalPoint")=(bool)(false) ) );
    
    }

    { //::cv::getDerivKernels
    
        typedef void ( *getDerivKernels_function_type )( ::cv::Mat &,::cv::Mat &,int,int,int,bool,int );
        
        bp::def( 
            "getDerivKernels"
            , getDerivKernels_function_type( &::cv::getDerivKernels )
            , ( bp::arg("kx"), bp::arg("ky"), bp::arg("dx"), bp::arg("dy"), bp::arg("ksize"), bp::arg("normalize")=(bool)(false), bp::arg("ktype")=(int)(5) ) );
    
    }

    { //::cv::getElemSize
    
        typedef ::size_t ( *getElemSize_function_type )( int );
        
        bp::def( 
            "getElemSize"
            , getElemSize_function_type( &::cv::getElemSize )
            , ( bp::arg("type") ) );
    
    }

    { //::cv::getGaussianKernel
    
        typedef ::cv::Mat ( *getGaussianKernel_function_type )( int,double,int );
        
        bp::def( 
            "getGaussianKernel"
            , getGaussianKernel_function_type( &::cv::getGaussianKernel )
            , ( bp::arg("ksize"), bp::arg("sigma"), bp::arg("ktype")=(int)(6) ) );
    
    }

    { //::cv::getKernelType
    
        typedef int ( *getKernelType_function_type )( ::cv::Mat const &,::cv::Point );
        
        bp::def( 
            "getKernelType"
            , getKernelType_function_type( &::cv::getKernelType )
            , ( bp::arg("kernel"), bp::arg("anchor") ) );
    
    }

    { //::cv::getLinearColumnFilter
    
        typedef ::cv::Ptr< cv::BaseColumnFilter > ( *getLinearColumnFilter_function_type )( int,int,::cv::Mat const &,int,int,double,int );
        
        bp::def( 
            "getLinearColumnFilter"
            , getLinearColumnFilter_function_type( &::cv::getLinearColumnFilter )
            , ( bp::arg("bufType"), bp::arg("dstType"), bp::arg("kernel"), bp::arg("anchor"), bp::arg("symmetryType"), bp::arg("delta")=0, bp::arg("bits")=(int)(0) ) );
    
    }

    { //::cv::getLinearFilter
    
        typedef ::cv::Ptr< cv::BaseFilter > ( *getLinearFilter_function_type )( int,int,::cv::Mat const &,::cv::Point,double,int );
        
        bp::def( 
            "getLinearFilter"
            , getLinearFilter_function_type( &::cv::getLinearFilter )
            , ( bp::arg("srcType"), bp::arg("dstType"), bp::arg("kernel"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("delta")=0, bp::arg("bits")=(int)(0) ) );
    
    }

    { //::cv::getLinearRowFilter
    
        typedef ::cv::Ptr< cv::BaseRowFilter > ( *getLinearRowFilter_function_type )( int,int,::cv::Mat const &,int,int );
        
        bp::def( 
            "getLinearRowFilter"
            , getLinearRowFilter_function_type( &::cv::getLinearRowFilter )
            , ( bp::arg("srcType"), bp::arg("bufType"), bp::arg("kernel"), bp::arg("anchor"), bp::arg("symmetryType") ) );
    
    }

    { //::cv::getMorphologyColumnFilter
    
        typedef ::cv::Ptr< cv::BaseColumnFilter > ( *getMorphologyColumnFilter_function_type )( int,int,int,int );
        
        bp::def( 
            "getMorphologyColumnFilter"
            , getMorphologyColumnFilter_function_type( &::cv::getMorphologyColumnFilter )
            , ( bp::arg("op"), bp::arg("type"), bp::arg("ksize"), bp::arg("anchor")=(int)(-0x000000001) ) );
    
    }

    { //::cv::getMorphologyFilter
    
        typedef ::cv::Ptr< cv::BaseFilter > ( *getMorphologyFilter_function_type )( int,int,::cv::Mat const &,::cv::Point );
        
        bp::def( 
            "getMorphologyFilter"
            , getMorphologyFilter_function_type( &::cv::getMorphologyFilter )
            , ( bp::arg("op"), bp::arg("type"), bp::arg("kernel"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001) ) );
    
    }

    { //::cv::getMorphologyRowFilter
    
        typedef ::cv::Ptr< cv::BaseRowFilter > ( *getMorphologyRowFilter_function_type )( int,int,int,int );
        
        bp::def( 
            "getMorphologyRowFilter"
            , getMorphologyRowFilter_function_type( &::cv::getMorphologyRowFilter )
            , ( bp::arg("op"), bp::arg("type"), bp::arg("ksize"), bp::arg("anchor")=(int)(-0x000000001) ) );
    
    }

    { //::cv::getNumThreads
    
        typedef int ( *getNumThreads_function_type )(  );
        
        bp::def( 
            "getNumThreads"
            , getNumThreads_function_type( &::cv::getNumThreads ) );
    
    }

    { //::cv::getOptimalDFTSize
    
        typedef int ( *getOptimalDFTSize_function_type )( int );
        
        bp::def( 
            "getOptimalDFTSize"
            , getOptimalDFTSize_function_type( &::cv::getOptimalDFTSize )
            , ( bp::arg("vecsize") ) );
    
    }

    { //::cv::getRectSubPix
    
        typedef void ( *getRectSubPix_function_type )( ::cv::Mat const &,::cv::Size,::cv::Point2f,::cv::Mat &,int );
        
        bp::def( 
            "getRectSubPix"
            , getRectSubPix_function_type( &::cv::getRectSubPix )
            , ( bp::arg("image"), bp::arg("patchSize"), bp::arg("center"), bp::arg("patch"), bp::arg("patchType")=(int)(-0x000000001) ) );
    
    }

    { //::cv::getRotationMatrix2D
    
        typedef ::cv::Mat ( *getRotationMatrix2D_function_type )( ::cv::Point2f,double,double );
        
        bp::def( 
            "getRotationMatrix2D"
            , getRotationMatrix2D_function_type( &::cv::getRotationMatrix2D )
            , ( bp::arg("center"), bp::arg("angle"), bp::arg("scale") ) );
    
    }

    { //::cv::getRowSumFilter
    
        typedef ::cv::Ptr< cv::BaseRowFilter > ( *getRowSumFilter_function_type )( int,int,int,int );
        
        bp::def( 
            "getRowSumFilter"
            , getRowSumFilter_function_type( &::cv::getRowSumFilter )
            , ( bp::arg("srcType"), bp::arg("sumType"), bp::arg("ksize"), bp::arg("anchor")=(int)(-0x000000001) ) );
    
    }

    { //::cv::getStructuringElement
    
        typedef ::cv::Mat ( *getStructuringElement_function_type )( int,::cv::Size,::cv::Point );
        
        bp::def( 
            "getStructuringElement"
            , getStructuringElement_function_type( &::cv::getStructuringElement )
            , ( bp::arg("shape"), bp::arg("ksize"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001) ) );
    
    }

    { //::cv::getThreadNum
    
        typedef int ( *getThreadNum_function_type )(  );
        
        bp::def( 
            "getThreadNum"
            , getThreadNum_function_type( &::cv::getThreadNum ) );
    
    }

    { //::cv::getTickCount
    
        typedef ::int64 ( *getTickCount_function_type )(  );
        
        bp::def( 
            "getTickCount"
            , getTickCount_function_type( &::cv::getTickCount ) );
    
    }

    { //::cv::getTickFrequency
    
        typedef double ( *getTickFrequency_function_type )(  );
        
        bp::def( 
            "getTickFrequency"
            , getTickFrequency_function_type( &::cv::getTickFrequency ) );
    
    }

    { //::cv::flann::hierarchicalClustering
    
        typedef int ( *hierarchicalClustering_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::flann::KMeansIndexParams const & );
        
        bp::def( 
            "hierarchicalClustering"
            , hierarchicalClustering_function_type( &::cv::flann::hierarchicalClustering )
            , ( bp::arg("features"), bp::arg("centers"), bp::arg("params") ) );
    
    }

    { //::cv::idct
    
        typedef void ( *idct_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "idct"
            , idct_function_type( &::cv::idct )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("flags")=(int)(0) ) );
    
    }

    { //::cv::idft
    
        typedef void ( *idft_function_type )( ::cv::Mat const &,::cv::Mat &,int,int );
        
        bp::def( 
            "idft"
            , idft_function_type( &::cv::idft )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("flags")=(int)(0), bp::arg("nonzeroRows")=(int)(0) ) );
    
    }

    { //::cv::imdecode
    
        typedef ::cv::Mat ( *imdecode_function_type )( ::cv::Mat const &,int );
        
        bp::def( 
            "imdecode"
            , imdecode_function_type( &::cv::imdecode )
            , ( bp::arg("buf"), bp::arg("flags") ) );
    
    }

    { //::cv::imread
    
        typedef ::cv::Mat ( *imread_function_type )( ::std::string const &,int );
        
        bp::def( 
            "imread"
            , imread_function_type( &::cv::imread )
            , ( bp::arg("filename"), bp::arg("flags")=(int)(1) ) );
    
    }

    { //::cv::imshow
    
        typedef void ( *imshow_function_type )( ::std::string const &,::cv::Mat const & );
        
        bp::def( 
            "imshow"
            , imshow_function_type( &::cv::imshow )
            , ( bp::arg("winname"), bp::arg("mat") ) );
    
    }

    { //::cv::inRange
    
        typedef void ( *inRange_function_type )( ::cv::MatND const &,::cv::Scalar const &,::cv::Scalar const &,::cv::MatND & );
        
        bp::def( 
            "inRange"
            , inRange_function_type( &::cv::inRange )
            , ( bp::arg("src"), bp::arg("lowerb"), bp::arg("upperb"), bp::arg("dst") ) );
    
    }

    { //::cv::inRange
    
        typedef void ( *inRange_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "inRange"
            , inRange_function_type( &::cv::inRange )
            , ( bp::arg("src"), bp::arg("lowerb"), bp::arg("upperb"), bp::arg("dst") ) );
    
    }

    { //::cv::inRange
    
        typedef void ( *inRange_function_type )( ::cv::Mat const &,::cv::Scalar const &,::cv::Scalar const &,::cv::Mat & );
        
        bp::def( 
            "inRange"
            , inRange_function_type( &::cv::inRange )
            , ( bp::arg("src"), bp::arg("lowerb"), bp::arg("upperb"), bp::arg("dst") ) );
    
    }

    { //::cv::inRange
    
        typedef void ( *inRange_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "inRange"
            , inRange_function_type( &::cv::inRange )
            , ( bp::arg("src"), bp::arg("lowerb"), bp::arg("upperb"), bp::arg("dst") ) );
    
    }

    { //::cv::initUndistortRectifyMap
    
        typedef void ( *initUndistortRectifyMap_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Size,int,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "initUndistortRectifyMap"
            , initUndistortRectifyMap_function_type( &::cv::initUndistortRectifyMap )
            , ( bp::arg("cameraMatrix"), bp::arg("distCoeffs"), bp::arg("R"), bp::arg("newCameraMatrix"), bp::arg("size"), bp::arg("m1type"), bp::arg("map1"), bp::arg("map2") ) );
    
    }

    { //::cv::inpaint
    
        typedef void ( *inpaint_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,double,int );
        
        bp::def( 
            "inpaint"
            , inpaint_function_type( &::cv::inpaint )
            , ( bp::arg("src"), bp::arg("inpaintMask"), bp::arg("dst"), bp::arg("inpaintRange"), bp::arg("flags") ) );
    
    }

    { //::cv::integral
    
        typedef void ( *integral_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,::cv::Mat &,int );
        
        bp::def( 
            "integral"
            , integral_function_type( &::cv::integral )
            , ( bp::arg("src"), bp::arg("sum"), bp::arg("sqsum"), bp::arg("tilted"), bp::arg("sdepth")=(int)(-0x000000001) ) );
    
    }

    { //::cv::integral
    
        typedef void ( *integral_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,int );
        
        bp::def( 
            "integral"
            , integral_function_type( &::cv::integral )
            , ( bp::arg("src"), bp::arg("sum"), bp::arg("sqsum"), bp::arg("sdepth")=(int)(-0x000000001) ) );
    
    }

    { //::cv::integral
    
        typedef void ( *integral_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "integral"
            , integral_function_type( &::cv::integral )
            , ( bp::arg("src"), bp::arg("sum"), bp::arg("sdepth")=(int)(-0x000000001) ) );
    
    }

    { //::cv::invert
    
        typedef double ( *invert_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "invert"
            , invert_function_type( &::cv::invert )
            , ( bp::arg("a"), bp::arg("c"), bp::arg("flags")=int(::cv::DECOMP_LU) ) );
    
    }

    { //::cv::invertAffineTransform
    
        typedef void ( *invertAffineTransform_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "invertAffineTransform"
            , invertAffineTransform_function_type( &::cv::invertAffineTransform )
            , ( bp::arg("M"), bp::arg("iM") ) );
    
    }

    { //::cv::isContourConvex
    
        typedef bool ( *isContourConvex_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "isContourConvex"
            , isContourConvex_function_type( &::cv::isContourConvex )
            , ( bp::arg("contour") ) );
    
    }

    { //::cv::line
    
        typedef void ( *line_function_type )( ::cv::Mat &,::cv::Point,::cv::Point,::cv::Scalar const &,int,int,int );
        
        bp::def( 
            "line"
            , line_function_type( &::cv::line )
            , ( bp::arg("img"), bp::arg("pt1"), bp::arg("pt2"), bp::arg("color"), bp::arg("thickness")=(int)(1), bp::arg("lineType")=(int)(8), bp::arg("shift")=(int)(0) ) );
    
    }

    { //::std::log
    
        typedef long double ( *log_function_type )( long double );
        
        bp::def( 
            "log"
            , log_function_type( &::std::log )
            , ( bp::arg("__x") ) );
    
    }

    { //::std::log
    
        typedef float ( *log_function_type )( float );
        
        bp::def( 
            "log"
            , log_function_type( &::std::log )
            , ( bp::arg("__x") ) );
    
    }

    { //::cv::log
    
        typedef void ( *log_function_type )( ::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "log"
            , log_function_type( &::cv::log )
            , ( bp::arg("a"), bp::arg("b") ) );
    
    }

    { //::cv::log
    
        typedef void ( *log_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "log"
            , log_function_type( &::cv::log )
            , ( bp::arg("a"), bp::arg("b") ) );
    
    }

    { //::log
    
        typedef double ( *log_function_type )( double );
        
        bp::def( 
            "log"
            , log_function_type( &::log )
            , ( bp::arg("arg0") ) );
    
    }

    { //::cv::magnitude
    
        typedef void ( *magnitude_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "magnitude"
            , magnitude_function_type( &::cv::magnitude )
            , ( bp::arg("x"), bp::arg("y"), bp::arg("magnitude") ) );
    
    }

    { //::cv::matMulDeriv
    
        typedef void ( *matMulDeriv_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "matMulDeriv"
            , matMulDeriv_function_type( &::cv::matMulDeriv )
            , ( bp::arg("A"), bp::arg("B"), bp::arg("dABdA"), bp::arg("dABdB") ) );
    
    }

    { //::cv::matchShapes
    
        typedef double ( *matchShapes_function_type )( ::cv::Mat const &,::cv::Mat const &,int,double );
        
        bp::def( 
            "matchShapes"
            , matchShapes_function_type( &::cv::matchShapes )
            , ( bp::arg("contour1"), bp::arg("contour2"), bp::arg("method"), bp::arg("parameter") ) );
    
    }

    { //::cv::matchTemplate
    
        typedef void ( *matchTemplate_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "matchTemplate"
            , matchTemplate_function_type( &::cv::matchTemplate )
            , ( bp::arg("image"), bp::arg("templ"), bp::arg("result"), bp::arg("method") ) );
    
    }

    { //::std::max
    
        typedef int const & ( *max_function_type )( int const &,int const & );
        
        bp::def( 
            "max"
            , max_function_type( &::std::max )
            , ( bp::arg("__a"), bp::arg("__b") )
            , bp::return_value_policy< bp::copy_const_reference >() );
    
    }

    { //::std::max
    
        typedef ::size_t const & ( *max_function_type )( ::size_t const &,::size_t const & );
        
        bp::def( 
            "max"
            , max_function_type( &::std::max )
            , ( bp::arg("__a"), bp::arg("__b") )
            , bp::return_value_policy< bp::copy_const_reference >() );
    
    }

    { //::std::max
    
        typedef float const & ( *max_function_type )( float const &,float const & );
        
        bp::def( 
            "max"
            , max_function_type( &::std::max )
            , ( bp::arg("__a"), bp::arg("__b") )
            , bp::return_value_policy< bp::copy_const_reference >() );
    
    }

    { //::cv::max
    
        typedef ::cv::MatExpr_< cv::MatExpr_Op3_< cv::Mat, cv::Mat, int, cv::Mat, cv::MatOp_Bin_< cv::Mat > >, cv::Mat > ( *max_function_type )( ::cv::Mat const &,::cv::Mat const & );
        
        bp::def( 
            "max"
            , max_function_type( &::cv::max )
            , ( bp::arg("a"), bp::arg("b") ) );
    
    }

    { //::cv::max
    
        typedef void ( *max_function_type )( ::cv::MatND const &,double,::cv::MatND & );
        
        bp::def( 
            "max"
            , max_function_type( &::cv::max )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("c") ) );
    
    }

    { //::cv::max
    
        typedef void ( *max_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "max"
            , max_function_type( &::cv::max )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") ) );
    
    }

    { //::cv::max
    
        typedef void ( *max_function_type )( ::cv::Mat const &,double,::cv::Mat & );
        
        bp::def( 
            "max"
            , max_function_type( &::cv::max )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("c") ) );
    
    }

    { //::cv::max
    
        typedef void ( *max_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "max"
            , max_function_type( &::cv::max )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") ) );
    
    }

    { //::cv::mean
    
        typedef ::cv::Scalar ( *mean_function_type )( ::cv::MatND const &,::cv::MatND const & );
        
        bp::def( 
            "mean"
            , mean_function_type( &::cv::mean )
            , ( bp::arg("m"), bp::arg("mask") ) );
    
    }

    { //::cv::mean
    
        typedef ::cv::Scalar ( *mean_function_type )( ::cv::MatND const & );
        
        bp::def( 
            "mean"
            , mean_function_type( &::cv::mean )
            , ( bp::arg("m") ) );
    
    }

    { //::cv::mean
    
        typedef ::cv::Scalar ( *mean_function_type )( ::cv::Mat const &,::cv::Mat const & );
        
        bp::def( 
            "mean"
            , mean_function_type( &::cv::mean )
            , ( bp::arg("m"), bp::arg("mask") ) );
    
    }

    { //::cv::mean
    
        typedef ::cv::Scalar ( *mean_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "mean"
            , mean_function_type( &::cv::mean )
            , ( bp::arg("m") ) );
    
    }

    { //::cv::meanShift
    
        typedef int ( *meanShift_function_type )( ::cv::Mat const &,::cv::Rect &,::cv::TermCriteria );
        
        bp::def( 
            "meanShift"
            , meanShift_function_type( &::cv::meanShift )
            , ( bp::arg("probImage"), bp::arg("window"), bp::arg("criteria") ) );
    
    }

    { //::cv::meanStdDev
    
        typedef void ( *meanStdDev_function_type )( ::cv::MatND const &,::cv::Scalar &,::cv::Scalar &,::cv::MatND const & );
        
        bp::def( 
            "meanStdDev"
            , meanStdDev_function_type( &::cv::meanStdDev )
            , ( bp::arg("m"), bp::arg("mean"), bp::arg("stddev"), bp::arg("mask")=cv::MatND() ) );
    
    }

    { //::cv::meanStdDev
    
        typedef void ( *meanStdDev_function_type )( ::cv::Mat const &,::cv::Scalar &,::cv::Scalar &,::cv::Mat const & );
        
        bp::def( 
            "meanStdDev"
            , meanStdDev_function_type( &::cv::meanStdDev )
            , ( bp::arg("m"), bp::arg("mean"), bp::arg("stddev"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::medianBlur
    
        typedef void ( *medianBlur_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "medianBlur"
            , medianBlur_function_type( &::cv::medianBlur )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ksize") ) );
    
    }

    { //::std::min
    
        typedef ::std::streamsize const & ( *min_function_type )( ::std::streamsize const &,::std::streamsize const & );
        
        bp::def( 
            "min"
            , min_function_type( &::std::min )
            , ( bp::arg("__a"), bp::arg("__b") )
            , bp::return_value_policy< bp::copy_const_reference >() );
    
    }

    { //::std::min
    
        typedef ::size_t const & ( *min_function_type )( ::size_t const &,::size_t const & );
        
        bp::def( 
            "min"
            , min_function_type( &::std::min )
            , ( bp::arg("__a"), bp::arg("__b") )
            , bp::return_value_policy< bp::copy_const_reference >() );
    
    }

    { //::std::min
    
        typedef float const & ( *min_function_type )( float const &,float const & );
        
        bp::def( 
            "min"
            , min_function_type( &::std::min )
            , ( bp::arg("__a"), bp::arg("__b") )
            , bp::return_value_policy< bp::copy_const_reference >() );
    
    }

    { //::cv::min
    
        typedef ::cv::MatExpr_< cv::MatExpr_Op3_< cv::Mat, cv::Mat, int, cv::Mat, cv::MatOp_Bin_< cv::Mat > >, cv::Mat > ( *min_function_type )( ::cv::Mat const &,::cv::Mat const & );
        
        bp::def( 
            "min"
            , min_function_type( &::cv::min )
            , ( bp::arg("a"), bp::arg("b") ) );
    
    }

    { //::cv::min
    
        typedef void ( *min_function_type )( ::cv::MatND const &,double,::cv::MatND & );
        
        bp::def( 
            "min"
            , min_function_type( &::cv::min )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("c") ) );
    
    }

    { //::cv::min
    
        typedef void ( *min_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "min"
            , min_function_type( &::cv::min )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") ) );
    
    }

    { //::cv::min
    
        typedef void ( *min_function_type )( ::cv::Mat const &,double,::cv::Mat & );
        
        bp::def( 
            "min"
            , min_function_type( &::cv::min )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("c") ) );
    
    }

    { //::cv::min
    
        typedef void ( *min_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "min"
            , min_function_type( &::cv::min )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") ) );
    
    }

    { //::cv::minAreaRect
    
        typedef ::cv::RotatedRect ( *minAreaRect_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "minAreaRect"
            , minAreaRect_function_type( &::cv::minAreaRect )
            , ( bp::arg("points") ) );
    
    }

    { //::cv::minEnclosingCircle
    
        typedef void ( *minEnclosingCircle_function_type )( ::cv::Mat const &,::cv::Point2f &,float & );
        
        bp::def( 
            "minEnclosingCircle"
            , minEnclosingCircle_function_type( &::cv::minEnclosingCircle )
            , ( bp::arg("points"), bp::arg("center"), bp::arg("radius") ) );
    
    }

    { //::cv::moments
    
        typedef ::cv::Moments ( *moments_function_type )( ::cv::Mat const &,bool );
        
        bp::def( 
            "moments"
            , moments_function_type( &::cv::moments )
            , ( bp::arg("array"), bp::arg("binaryImage")=(bool)(false) ) );
    
    }

    { //::cv::morphologyDefaultBorderValue
    
        typedef ::cv::Scalar ( *morphologyDefaultBorderValue_function_type )(  );
        
        bp::def( 
            "morphologyDefaultBorderValue"
            , morphologyDefaultBorderValue_function_type( &::cv::morphologyDefaultBorderValue ) );
    
    }

    { //::cv::morphologyEx
    
        typedef void ( *morphologyEx_function_type )( ::cv::Mat const &,::cv::Mat &,int,::cv::Mat const &,::cv::Point,int,int,::cv::Scalar const & );
        
        bp::def( 
            "morphologyEx"
            , morphologyEx_function_type( &::cv::morphologyEx )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("op"), bp::arg("kernel"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("iterations")=(int)(1), bp::arg("borderType")=int(::cv::BORDER_CONSTANT), bp::arg("borderValue")=cv::morphologyDefaultBorderValue( ) ) );
    
    }

    { //::cv::mulSpectrums
    
        typedef void ( *mulSpectrums_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,int,bool );
        
        bp::def( 
            "mulSpectrums"
            , mulSpectrums_function_type( &::cv::mulSpectrums )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("flags"), bp::arg("conjB")=(bool)(false) ) );
    
    }

    { //::cv::mulTransposed
    
        typedef void ( *mulTransposed_function_type )( ::cv::Mat const &,::cv::Mat &,bool,::cv::Mat const &,double,int );
        
        bp::def( 
            "mulTransposed"
            , mulTransposed_function_type( &::cv::mulTransposed )
            , ( bp::arg("a"), bp::arg("c"), bp::arg("aTa"), bp::arg("delta")=cv::Mat(), bp::arg("scale")=1, bp::arg("rtype")=(int)(-0x000000001) ) );
    
    }

    { //::cv::multiply
    
        typedef void ( *multiply_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,double );
        
        bp::def( 
            "multiply"
            , multiply_function_type( &::cv::multiply )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("scale")=1 ) );
    
    }

    { //::cv::multiply
    
        typedef void ( *multiply_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,double );
        
        bp::def( 
            "multiply"
            , multiply_function_type( &::cv::multiply )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("scale")=1 ) );
    
    }

    { //::cv::namedWindow
    
        typedef void ( *namedWindow_function_type )( ::std::string const &,int );
        
        bp::def( 
            "namedWindow"
            , namedWindow_function_type( &::cv::namedWindow )
            , ( bp::arg("winname"), bp::arg("flags") ) );
    
    }

    { //::cv::norm
    
        typedef double ( *norm_function_type )( ::cv::SparseMat const &,int );
        
        bp::def( 
            "norm"
            , norm_function_type( &::cv::norm )
            , ( bp::arg("src"), bp::arg("normType") ) );
    
    }

    { //::cv::norm
    
        typedef double ( *norm_function_type )( ::cv::MatND const &,::cv::MatND const &,int,::cv::MatND const & );
        
        bp::def( 
            "norm"
            , norm_function_type( &::cv::norm )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("normType")=int(::cv::NORM_L2), bp::arg("mask")=cv::MatND() ) );
    
    }

    { //::cv::norm
    
        typedef double ( *norm_function_type )( ::cv::MatND const &,int,::cv::MatND const & );
        
        bp::def( 
            "norm"
            , norm_function_type( &::cv::norm )
            , ( bp::arg("a"), bp::arg("normType")=int(::cv::NORM_L2), bp::arg("mask")=cv::MatND() ) );
    
    }

    { //::cv::norm
    
        typedef double ( *norm_function_type )( ::cv::Mat const &,::cv::Mat const &,int,::cv::Mat const & );
        
        bp::def( 
            "norm"
            , norm_function_type( &::cv::norm )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("normType"), bp::arg("mask") ) );
    
    }

    { //::cv::norm
    
        typedef double ( *norm_function_type )( ::cv::Mat const &,int,::cv::Mat const & );
        
        bp::def( 
            "norm"
            , norm_function_type( &::cv::norm )
            , ( bp::arg("a"), bp::arg("normType"), bp::arg("mask") ) );
    
    }

    { //::cv::norm
    
        typedef double ( *norm_function_type )( ::cv::Mat const &,::cv::Mat const &,int );
        
        bp::def( 
            "norm"
            , norm_function_type( &::cv::norm )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("normType")=int(::cv::NORM_L2) ) );
    
    }

    { //::cv::norm
    
        typedef double ( *norm_function_type )( ::cv::Mat const &,int );
        
        bp::def( 
            "norm"
            , norm_function_type( &::cv::norm )
            , ( bp::arg("a"), bp::arg("normType")=int(::cv::NORM_L2) ) );
    
    }

    { //::cv::normalize
    
        typedef void ( *normalize_function_type )( ::cv::SparseMat const &,::cv::SparseMat &,double,int );
        
        bp::def( 
            "normalize"
            , normalize_function_type( &::cv::normalize )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("alpha"), bp::arg("normType") ) );
    
    }

    { //::cv::normalize
    
        typedef void ( *normalize_function_type )( ::cv::MatND const &,::cv::MatND &,double,double,int,int,::cv::MatND const & );
        
        bp::def( 
            "normalize"
            , normalize_function_type( &::cv::normalize )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("alpha")=1, bp::arg("beta")=0, bp::arg("norm_type")=int(::cv::NORM_L2), bp::arg("rtype")=(int)(-0x000000001), bp::arg("mask")=cv::MatND() ) );
    
    }

    { //::cv::normalize
    
        typedef void ( *normalize_function_type )( ::cv::Mat const &,::cv::Mat &,double,double,int,int,::cv::Mat const & );
        
        bp::def( 
            "normalize"
            , normalize_function_type( &::cv::normalize )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("alpha")=1, bp::arg("beta")=0, bp::arg("norm_type")=int(::cv::NORM_L2), bp::arg("rtype")=(int)(-0x000000001), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::sdopencv::patchBasedStdDev
    
        typedef void ( *patchBasedStdDev_function_type )( ::cv::Mat const &,::cv::Size_< int > const &,::cv::Mat & );
        
        bp::def( 
            "patchBasedStdDev"
            , patchBasedStdDev_function_type( &::sdopencv::patchBasedStdDev )
            , ( bp::arg("in_image"), bp::arg("patch_size"), bp::arg("out_image") ) );
    
    }

    { //::cv::perspectiveTransform
    
        typedef void ( *perspectiveTransform_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "perspectiveTransform"
            , perspectiveTransform_function_type( &::cv::perspectiveTransform )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("m") ) );
    
    }

    { //::cv::phase
    
        typedef void ( *phase_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,bool );
        
        bp::def( 
            "phase"
            , phase_function_type( &::cv::phase )
            , ( bp::arg("x"), bp::arg("y"), bp::arg("angle"), bp::arg("angleInDegrees")=(bool)(false) ) );
    
    }

    { //::cv::pointPolygonTest
    
        typedef double ( *pointPolygonTest_function_type )( ::cv::Mat const &,::cv::Point2f,bool );
        
        bp::def( 
            "pointPolygonTest"
            , pointPolygonTest_function_type( &::cv::pointPolygonTest )
            , ( bp::arg("contour"), bp::arg("pt"), bp::arg("measureDist") ) );
    
    }

    { //::cv::polarToCart
    
        typedef void ( *polarToCart_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat &,bool );
        
        bp::def( 
            "polarToCart"
            , polarToCart_function_type( &::cv::polarToCart )
            , ( bp::arg("magnitude"), bp::arg("angle"), bp::arg("x"), bp::arg("y"), bp::arg("angleInDegrees")=(bool)(false) ) );
    
    }

    { //::std::pow
    
        typedef long double ( *pow_function_type )( long double,int );
        
        bp::def( 
            "pow"
            , pow_function_type( &::std::pow )
            , ( bp::arg("__x"), bp::arg("__n") ) );
    
    }

    { //::std::pow
    
        typedef float ( *pow_function_type )( float,int );
        
        bp::def( 
            "pow"
            , pow_function_type( &::std::pow )
            , ( bp::arg("__x"), bp::arg("__n") ) );
    
    }

    { //::std::pow
    
        typedef double ( *pow_function_type )( double,int );
        
        bp::def( 
            "pow"
            , pow_function_type( &::std::pow )
            , ( bp::arg("__x"), bp::arg("__i") ) );
    
    }

    { //::std::pow
    
        typedef long double ( *pow_function_type )( long double,long double );
        
        bp::def( 
            "pow"
            , pow_function_type( &::std::pow )
            , ( bp::arg("__x"), bp::arg("__y") ) );
    
    }

    { //::std::pow
    
        typedef float ( *pow_function_type )( float,float );
        
        bp::def( 
            "pow"
            , pow_function_type( &::std::pow )
            , ( bp::arg("__x"), bp::arg("__y") ) );
    
    }

    { //::cv::pow
    
        typedef void ( *pow_function_type )( ::cv::MatND const &,double,::cv::MatND & );
        
        bp::def( 
            "pow"
            , pow_function_type( &::cv::pow )
            , ( bp::arg("a"), bp::arg("power"), bp::arg("b") ) );
    
    }

    { //::cv::pow
    
        typedef void ( *pow_function_type )( ::cv::Mat const &,double,::cv::Mat & );
        
        bp::def( 
            "pow"
            , pow_function_type( &::cv::pow )
            , ( bp::arg("a"), bp::arg("power"), bp::arg("b") ) );
    
    }

    { //::pow
    
        typedef double ( *pow_function_type )( double,double );
        
        bp::def( 
            "pow"
            , pow_function_type( &::pow )
            , ( bp::arg("arg0"), bp::arg("arg1") ) );
    
    }

    { //::cv::preCornerDetect
    
        typedef void ( *preCornerDetect_function_type )( ::cv::Mat const &,::cv::Mat &,int,int );
        
        bp::def( 
            "preCornerDetect"
            , preCornerDetect_function_type( &::cv::preCornerDetect )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ksize"), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::putText
    
        typedef void ( *putText_function_type )( ::cv::Mat &,::std::string const &,::cv::Point,int,double,::cv::Scalar,int,int,bool );
        
        bp::def( 
            "putText"
            , putText_function_type( &::cv::putText )
            , ( bp::arg("img"), bp::arg("text"), bp::arg("org"), bp::arg("fontFace"), bp::arg("fontScale"), bp::arg("color"), bp::arg("thickness")=(int)(1), bp::arg("linetype")=(int)(8), bp::arg("bottomLeftOrigin")=(bool)(false) ) );
    
    }

    { //::cv::pyrDown
    
        typedef void ( *pyrDown_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Size const & );
        
        bp::def( 
            "pyrDown"
            , pyrDown_function_type( &::cv::pyrDown )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("dstsize")=cv::Size_<int>() ) );
    
    }

    { //::cv::pyrUp
    
        typedef void ( *pyrUp_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Size const & );
        
        bp::def( 
            "pyrUp"
            , pyrUp_function_type( &::cv::pyrUp )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("dstsize")=cv::Size_<int>() ) );
    
    }

    { //::cv::randShuffle
    
        typedef void ( *randShuffle_function_type )( ::cv::Mat &,double,::cv::RNG * );
        
        bp::def( 
            "randShuffle"
            , randShuffle_function_type( &::cv::randShuffle )
            , ( bp::arg("dst"), bp::arg("iterFactor")=1.0e+0, bp::arg("rng")=bp::object() ) );
    
    }

    { //::cv::randn
    
        typedef void ( *randn_function_type )( ::cv::Mat &,::cv::Scalar const &,::cv::Scalar const & );
        
        bp::def( 
            "randn"
            , randn_function_type( &::cv::randn )
            , ( bp::arg("dst"), bp::arg("mean"), bp::arg("stddev") ) );
    
    }

    { //::cv::randu
    
        typedef void ( *randu_function_type )( ::cv::Mat &,::cv::Scalar const &,::cv::Scalar const & );
        
        bp::def( 
            "randu"
            , randu_function_type( &::cv::randu )
            , ( bp::arg("dst"), bp::arg("low"), bp::arg("high") ) );
    
    }

    { //::cv::rectangle
    
        typedef void ( *rectangle_function_type )( ::cv::Mat &,::cv::Point,::cv::Point,::cv::Scalar const &,int,int,int );
        
        bp::def( 
            "rectangle"
            , rectangle_function_type( &::cv::rectangle )
            , ( bp::arg("img"), bp::arg("pt1"), bp::arg("pt2"), bp::arg("color"), bp::arg("thickness")=(int)(1), bp::arg("lineType")=(int)(8), bp::arg("shift")=(int)(0) ) );
    
    }

    { //::cv::reduce
    
        typedef void ( *reduce_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,int );
        
        bp::def( 
            "reduce"
            , reduce_function_type( &::cv::reduce )
            , ( bp::arg("m"), bp::arg("dst"), bp::arg("dim"), bp::arg("rtype"), bp::arg("dtype")=(int)(-0x000000001) ) );
    
    }

    { //::cv::remap
    
        typedef void ( *remap_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,::cv::Mat const &,int,int,::cv::Scalar const & );
        
        bp::def( 
            "remap"
            , remap_function_type( &::cv::remap )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("map1"), bp::arg("map2"), bp::arg("interpolation"), bp::arg("borderMode")=int(::cv::BORDER_CONSTANT), bp::arg("borderValue")=cv::Scalar_<double>() ) );
    
    }

    { //::cv::repeat
    
        typedef ::cv::Mat ( *repeat_function_type )( ::cv::Mat const &,int,int );
        
        bp::def( 
            "repeat"
            , repeat_function_type( &::cv::repeat )
            , ( bp::arg("src"), bp::arg("ny"), bp::arg("nx") ) );
    
    }

    { //::cv::repeat
    
        typedef void ( *repeat_function_type )( ::cv::Mat const &,int,int,::cv::Mat & );
        
        bp::def( 
            "repeat"
            , repeat_function_type( &::cv::repeat )
            , ( bp::arg("a"), bp::arg("ny"), bp::arg("nx"), bp::arg("b") ) );
    
    }

    { //::cv::reprojectImageTo3D
    
        typedef void ( *reprojectImageTo3D_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,bool );
        
        bp::def( 
            "reprojectImageTo3D"
            , reprojectImageTo3D_function_type( &::cv::reprojectImageTo3D )
            , ( bp::arg("disparity"), bp::arg("_3dImage"), bp::arg("Q"), bp::arg("handleMissingValues")=(bool)(false) ) );
    
    }

    { //::cv::resize
    
        typedef void ( *resize_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Size,double,double,int );
        
        bp::def( 
            "resize"
            , resize_function_type( &::cv::resize )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("dsize")=cv::Size_<int>(), bp::arg("fx")=0, bp::arg("fy")=0, bp::arg("interpolation")=int(::cv::INTER_LINEAR) ) );
    
    }

    { //::cv::scaleAdd
    
        typedef void ( *scaleAdd_function_type )( ::cv::MatND const &,double,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "scaleAdd"
            , scaleAdd_function_type( &::cv::scaleAdd )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("b"), bp::arg("c") ) );
    
    }

    { //::cv::scaleAdd
    
        typedef void ( *scaleAdd_function_type )( ::cv::Mat const &,double,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "scaleAdd"
            , scaleAdd_function_type( &::cv::scaleAdd )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("b"), bp::arg("c") ) );
    
    }

    { //::cv::sepFilter2D
    
        typedef void ( *sepFilter2D_function_type )( ::cv::Mat const &,::cv::Mat &,int,::cv::Mat const &,::cv::Mat const &,::cv::Point,double,int );
        
        bp::def( 
            "sepFilter2D"
            , sepFilter2D_function_type( &::cv::sepFilter2D )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ddepth"), bp::arg("kernelX"), bp::arg("kernelY"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("delta")=0, bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::setIdentity
    
        typedef void ( *setIdentity_function_type )( ::cv::Mat &,::cv::Scalar const & );
        
        bp::def( 
            "setIdentity"
            , setIdentity_function_type( &::cv::setIdentity )
            , ( bp::arg("c"), bp::arg("s")=cv::Scalar_<double>(1.0e+0) ) );
    
    }

    { //::cv::setNumThreads
    
        typedef void ( *setNumThreads_function_type )( int );
        
        bp::def( 
            "setNumThreads"
            , setNumThreads_function_type( &::cv::setNumThreads )
            , ( bp::arg("arg0") ) );
    
    }

    { //::cv::setUseOptimized
    
        typedef void ( *setUseOptimized_function_type )( bool );
        
        bp::def( 
            "setUseOptimized"
            , setUseOptimized_function_type( &::cv::setUseOptimized )
            , ( bp::arg("arg0") ) );
    
    }

    { //::cv::solve
    
        typedef bool ( *solve_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "solve"
            , solve_function_type( &::cv::solve )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("x"), bp::arg("flags")=int(::cv::DECOMP_LU) ) );
    
    }

    { //::cv::solvePnP
    
        typedef void ( *solvePnP_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat &,bool );
        
        bp::def( 
            "solvePnP"
            , solvePnP_function_type( &::cv::solvePnP )
            , ( bp::arg("objectPoints"), bp::arg("imagePoints"), bp::arg("cameraMatrix"), bp::arg("distCoeffs"), bp::arg("rvec"), bp::arg("tvec"), bp::arg("useExtrinsicGuess")=(bool)(false) ) );
    
    }

    { //::cv::sort
    
        typedef void ( *sort_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "sort"
            , sort_function_type( &::cv::sort )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("flags") ) );
    
    }

    { //::cv::sortIdx
    
        typedef void ( *sortIdx_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "sortIdx"
            , sortIdx_function_type( &::cv::sortIdx )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("flags") ) );
    
    }

    { //::std::sqrt
    
        typedef long double ( *sqrt_function_type )( long double );
        
        bp::def( 
            "sqrt"
            , sqrt_function_type( &::std::sqrt )
            , ( bp::arg("__x") ) );
    
    }

    { //::std::sqrt
    
        typedef float ( *sqrt_function_type )( float );
        
        bp::def( 
            "sqrt"
            , sqrt_function_type( &::std::sqrt )
            , ( bp::arg("__x") ) );
    
    }

    { //::sqrt
    
        typedef double ( *sqrt_function_type )( double );
        
        bp::def( 
            "sqrt"
            , sqrt_function_type( &::sqrt )
            , ( bp::arg("arg0") ) );
    
    }

    { //::cv::sqrt
    
        typedef void ( *sqrt_function_type )( ::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "sqrt"
            , sqrt_function_type( &::cv::sqrt )
            , ( bp::arg("a"), bp::arg("b") ) );
    
    }

    { //::cv::sqrt
    
        typedef void ( *sqrt_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "sqrt"
            , sqrt_function_type( &::cv::sqrt )
            , ( bp::arg("a"), bp::arg("b") ) );
    
    }

    { //::cv::stereoRectify
    
        typedef void ( *stereoRectify_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Size,::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,int );
        
        bp::def( 
            "stereoRectify"
            , stereoRectify_function_type( &::cv::stereoRectify )
            , ( bp::arg("cameraMatrix1"), bp::arg("distCoeffs1"), bp::arg("cameraMatrix2"), bp::arg("distCoeffs2"), bp::arg("imageSize"), bp::arg("R"), bp::arg("T"), bp::arg("R1"), bp::arg("R2"), bp::arg("P1"), bp::arg("P2"), bp::arg("Q"), bp::arg("flags")=int(::cv::CALIB_ZERO_DISPARITY) ) );
    
    }

    { //::cv::stereoRectifyUncalibrated
    
        typedef bool ( *stereoRectifyUncalibrated_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Size,::cv::Mat &,::cv::Mat &,double );
        
        bp::def( 
            "stereoRectifyUncalibrated"
            , stereoRectifyUncalibrated_function_type( &::cv::stereoRectifyUncalibrated )
            , ( bp::arg("points1"), bp::arg("points2"), bp::arg("F"), bp::arg("imgSize"), bp::arg("H1"), bp::arg("H2"), bp::arg("threshold")=5 ) );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::MatND const &,::cv::Scalar const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::MatND() ) );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::Scalar const &,::cv::MatND const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("s"), bp::arg("a"), bp::arg("c"), bp::arg("mask")=cv::MatND() ) );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") ) );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask") ) );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::Scalar const &,::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("s"), bp::arg("a"), bp::arg("c"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::Mat const &,::cv::Scalar const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") ) );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask") ) );
    
    }

    { //::cv::sum
    
        typedef ::cv::Scalar ( *sum_function_type )( ::cv::MatND const & );
        
        bp::def( 
            "sum"
            , sum_function_type( &::cv::sum )
            , ( bp::arg("m") ) );
    
    }

    { //::cv::sum
    
        typedef ::cv::Scalar ( *sum_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "sum"
            , sum_function_type( &::cv::sum )
            , ( bp::arg("m") ) );
    
    }

    { //::cv::theRNG
    
        typedef ::cv::RNG & ( *theRNG_function_type )(  );
        
        bp::def( 
            "theRNG"
            , theRNG_function_type( &::cv::theRNG )
            , bp::return_value_policy< bp::reference_existing_object >() );
    
    }

    { //::cv::threshold
    
        typedef double ( *threshold_function_type )( ::cv::Mat const &,::cv::Mat &,double,double,int );
        
        bp::def( 
            "threshold"
            , threshold_function_type( &::cv::threshold )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("thresh"), bp::arg("maxval"), bp::arg("type") ) );
    
    }

    { //::cv::toUtf16
    
        typedef ::cv::WString ( *toUtf16_function_type )( ::std::string const & );
        
        bp::def( 
            "toUtf16"
            , toUtf16_function_type( &::cv::toUtf16 )
            , ( bp::arg("str") ) );
    
    }

    { //::cv::trace
    
        typedef ::cv::Scalar ( *trace_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "trace"
            , trace_function_type( &::cv::trace )
            , ( bp::arg("m") ) );
    
    }

    { //::cv::transform
    
        typedef void ( *transform_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "transform"
            , transform_function_type( &::cv::transform )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("m") ) );
    
    }

    { //::cv::transpose
    
        typedef void ( *transpose_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "transpose"
            , transpose_function_type( &::cv::transpose )
            , ( bp::arg("a"), bp::arg("b") ) );
    
    }

    { //::cv::undistort
    
        typedef void ( *undistort_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const & );
        
        bp::def( 
            "undistort"
            , undistort_function_type( &::cv::undistort )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("cameraMatrix"), bp::arg("distCoeffs"), bp::arg("newCameraMatrix")=cv::Mat() ) );
    
    }

    { //::cv::undistortPoints
    
        typedef void ( *undistortPoints_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const & );
        
        bp::def( 
            "undistortPoints"
            , undistortPoints_function_type( &::cv::undistortPoints )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("cameraMatrix"), bp::arg("distCoeffs"), bp::arg("R")=cv::Mat(), bp::arg("P")=cv::Mat() ) );
    
    }

    { //::cv::updateMotionHistory
    
        typedef void ( *updateMotionHistory_function_type )( ::cv::Mat const &,::cv::Mat &,double,double );
        
        bp::def( 
            "updateMotionHistory"
            , updateMotionHistory_function_type( &::cv::updateMotionHistory )
            , ( bp::arg("silhouette"), bp::arg("mhi"), bp::arg("timestamp"), bp::arg("duration") ) );
    
    }

    { //::cv::useOptimized
    
        typedef bool ( *useOptimized_function_type )(  );
        
        bp::def( 
            "useOptimized"
            , useOptimized_function_type( &::cv::useOptimized ) );
    
    }

    { //::cv::waitKey
    
        typedef int ( *waitKey_function_type )( int );
        
        bp::def( 
            "waitKey"
            , waitKey_function_type( &::cv::waitKey )
            , ( bp::arg("delay")=(int)(0) ) );
    
    }

    { //::cv::warpAffine
    
        typedef void ( *warpAffine_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,::cv::Size,int,int,::cv::Scalar const & );
        
        bp::def( 
            "warpAffine"
            , warpAffine_function_type( &::cv::warpAffine )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("M"), bp::arg("dsize"), bp::arg("flags")=int(::cv::INTER_LINEAR), bp::arg("borderMode")=int(::cv::BORDER_CONSTANT), bp::arg("borderValue")=cv::Scalar_<double>() ) );
    
    }

    { //::cv::warpPerspective
    
        typedef void ( *warpPerspective_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,::cv::Size,int,int,::cv::Scalar const & );
        
        bp::def( 
            "warpPerspective"
            , warpPerspective_function_type( &::cv::warpPerspective )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("M"), bp::arg("dsize"), bp::arg("flags")=int(::cv::INTER_LINEAR), bp::arg("borderMode")=int(::cv::BORDER_CONSTANT), bp::arg("borderValue")=cv::Scalar_<double>() ) );
    
    }

    { //::cv::watershed
    
        typedef void ( *watershed_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "watershed"
            , watershed_function_type( &::cv::watershed )
            , ( bp::arg("image"), bp::arg("markers") ) );
    
    }

    { //::cv::write
    
        typedef void ( *write_function_type )( ::cv::FileStorage &,::std::string const &,::cv::SparseMat const & );
        
        bp::def( 
            "write"
            , write_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("value") ) );
    
    }

    { //::cv::write
    
        typedef void ( *write_function_type )( ::cv::FileStorage &,::std::string const &,::cv::MatND const & );
        
        bp::def( 
            "write"
            , write_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("value") ) );
    
    }

    { //::cv::write
    
        typedef void ( *write_function_type )( ::cv::FileStorage &,::std::string const &,::cv::Mat const & );
        
        bp::def( 
            "write"
            , write_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("value") ) );
    
    }

    { //::cv::write
    
        typedef void ( *write_function_type )( ::cv::FileStorage &,::std::string const &,::cv::Range const & );
        
        bp::def( 
            "write"
            , write_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("r") ) );
    
    }

    { //::cv::write
    
        typedef void ( *write_function_type )( ::cv::FileStorage &,::cv::Range const & );
        
        bp::def( 
            "write"
            , write_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("r") ) );
    
    }

    { //::cv::write
    
        typedef void ( *write_function_type )( ::cv::FileStorage &,int const & );
        
        bp::def( 
            "write"
            , write_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("value") ) );
    
    }

    { //::cv::write
    
        typedef void ( *write_function_type )( ::cv::FileStorage &,::std::string const & );
        
        bp::def( 
            "write"
            , write_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("value") ) );
    
    }

    { //::cv::write
    
        typedef void ( *write_function_type )( ::cv::FileStorage &,double const & );
        
        bp::def( 
            "write"
            , write_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("value") ) );
    
    }

    { //::cv::write
    
        typedef void ( *write_function_type )( ::cv::FileStorage &,float const & );
        
        bp::def( 
            "write"
            , write_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("value") ) );
    
    }

    { //::cv::write
    
        typedef void ( *write_function_type )( ::cv::FileStorage &,::std::string const &,::std::string const & );
        
        bp::def( 
            "write"
            , write_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("value") ) );
    
    }

    { //::cv::write
    
        typedef void ( *write_function_type )( ::cv::FileStorage &,::std::string const &,double );
        
        bp::def( 
            "write"
            , write_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("value") ) );
    
    }

    { //::cv::write
    
        typedef void ( *write_function_type )( ::cv::FileStorage &,::std::string const &,float );
        
        bp::def( 
            "write"
            , write_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("value") ) );
    
    }

    { //::cv::write
    
        typedef void ( *write_function_type )( ::cv::FileStorage &,::std::string const &,int );
        
        bp::def( 
            "write"
            , write_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("value") ) );
    
    }

}
