// This file has been generated by Py++.

#include "boost/python.hpp"
#include "__call_policies.pypp.hpp"
#include "__convenience.pypp.hpp"
#include "__ctypes_integration.pypp.hpp"
#include "opencv_headers.hpp"
#include "CvEM.pypp.hpp"

namespace bp = boost::python;

struct CvEM_wrapper : CvEM, bp::wrapper< CvEM > {

    CvEM_wrapper(CvEM const & arg )
    : CvEM( arg )
      , bp::wrapper< CvEM >(){
        // copy constructor
        
    }

    CvEM_wrapper( )
    : CvEM( )
      , bp::wrapper< CvEM >(){
        // null constructor
    
    }

    CvEM_wrapper(::cv::Mat const & samples, ::cv::Mat const & sample_idx=cv::Mat(), ::CvEMParams params=::CvEMParams( ), ::cv::Mat * labels=0 )
    : CvEM( boost::ref(samples), boost::ref(sample_idx), params, boost::python::ptr(labels) )
      , bp::wrapper< CvEM >(){
        // constructor
    
    }

    virtual void clear(  ) {
        if( bp::override func_clear = this->get_override( "clear" ) )
            func_clear(  );
        else{
            this->CvEM::clear(  );
        }
    }
    
    void default_clear(  ) {
        CvEM::clear( );
    }

    virtual float predict( ::cv::Mat const & sample, ::cv::Mat * probs ) const  {
        if( bp::override func_predict = this->get_override( "predict" ) )
            return func_predict( boost::ref(sample), boost::python::ptr(probs) );
        else{
            return this->CvEM::predict( boost::ref(sample), boost::python::ptr(probs) );
        }
    }
    
    float default_predict( ::cv::Mat const & sample, ::cv::Mat * probs ) const  {
        return CvEM::predict( boost::ref(sample), boost::python::ptr(probs) );
    }

    virtual bool train( ::cv::Mat const & samples, ::cv::Mat const & sample_idx=cv::Mat(), ::CvEMParams params=::CvEMParams( ), ::cv::Mat * labels=0 ) {
        if( bp::override func_train = this->get_override( "train" ) )
            return func_train( boost::ref(samples), boost::ref(sample_idx), params, boost::python::ptr(labels) );
        else{
            return this->CvEM::train( boost::ref(samples), boost::ref(sample_idx), params, boost::python::ptr(labels) );
        }
    }
    
    bool default_train( ::cv::Mat const & samples, ::cv::Mat const & sample_idx=cv::Mat(), ::CvEMParams params=::CvEMParams( ), ::cv::Mat * labels=0 ) {
        return CvEM::train( boost::ref(samples), boost::ref(sample_idx), params, boost::python::ptr(labels) );
    }

    virtual void load( char const * filename, char const * name=0 ) {
        if( bp::override func_load = this->get_override( "load" ) )
            func_load( filename, name );
        else{
            this->CvStatModel::load( filename, name );
        }
    }
    
    void default_load( char const * filename, char const * name=0 ) {
        CvStatModel::load( filename, name );
    }

    virtual void read( ::CvFileStorage * storage, ::CvFileNode * node ) {
        namespace bpl = boost::python;
        if( bpl::override func_read = this->get_override( "read" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_read.ptr(), storage, node );
        }
        else{
            CvStatModel::read( boost::python::ptr(storage), boost::python::ptr(node) );
        }
    }
    
    static void default_read( ::CvStatModel & inst, ::cv::FileStorage & storage, ::cv::FileNode & node ){
        if( dynamic_cast< CvEM_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvStatModel::read(storage.fs, *(node));
        }
        else{
            inst.read(storage.fs, *(node));
        }
    }

    virtual void save( char const * filename, char const * name=0 ) const  {
        if( bp::override func_save = this->get_override( "save" ) )
            func_save( filename, name );
        else{
            this->CvStatModel::save( filename, name );
        }
    }
    
    void default_save( char const * filename, char const * name=0 ) const  {
        CvStatModel::save( filename, name );
    }

    virtual void write( ::CvFileStorage * storage, char const * name ) const  {
        namespace bpl = boost::python;
        if( bpl::override func_write = this->get_override( "write" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_write.ptr(), storage, name );
        }
        else{
            CvStatModel::write( boost::python::ptr(storage), name );
        }
    }
    
    static void default_write( ::CvStatModel const & inst, ::cv::FileStorage & storage, char const * name ){
        if( dynamic_cast< CvEM_wrapper const* >( boost::addressof( inst ) ) ){
            inst.::CvStatModel::write(storage.fs, name);
        }
        else{
            inst.write(storage.fs, name);
        }
    }

};

void register_CvEM_class(){

    { //::CvEM
        typedef bp::class_< CvEM_wrapper, bp::bases< CvStatModel > > CvEM_exposer_t;
        CvEM_exposer_t CvEM_exposer = CvEM_exposer_t( "CvEM", bp::init< >() );
        bp::scope CvEM_scope( CvEM_exposer );
        CvEM_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< CvEM >() );
        bp::scope().attr("COV_MAT_SPHERICAL") = (int)CvEM::COV_MAT_SPHERICAL;
        bp::scope().attr("COV_MAT_DIAGONAL") = (int)CvEM::COV_MAT_DIAGONAL;
        bp::scope().attr("COV_MAT_GENERIC") = (int)CvEM::COV_MAT_GENERIC;
        bp::scope().attr("START_E_STEP") = (int)CvEM::START_E_STEP;
        bp::scope().attr("START_M_STEP") = (int)CvEM::START_M_STEP;
        bp::scope().attr("START_AUTO_STEP") = (int)CvEM::START_AUTO_STEP;
        CvEM_exposer.def( bp::init< cv::Mat const &, bp::optional< cv::Mat const &, CvEMParams, cv::Mat * > >(( bp::arg("samples"), bp::arg("sample_idx")=cv::Mat(), bp::arg("params")=::CvEMParams( ), bp::arg("labels")=bp::object() )) );
        bp::implicitly_convertible< cv::Mat const &, CvEM >();
        { //::CvEM::clear
        
            typedef void ( ::CvEM::*clear_function_type )(  ) ;
            typedef void ( CvEM_wrapper::*default_clear_function_type )(  ) ;
            
            CvEM_exposer.def( 
                "clear"
                , clear_function_type(&::CvEM::clear)
                , default_clear_function_type(&CvEM_wrapper::default_clear) );
        
        }
        { //::CvEM::get_log_likelihood
        
            typedef double ( ::CvEM::*get_log_likelihood_function_type )(  ) const;
            
            CvEM_exposer.def( 
                "get_log_likelihood"
                , get_log_likelihood_function_type( &::CvEM::get_log_likelihood ) );
        
        }
        { //::CvEM::get_nclusters
        
            typedef int ( ::CvEM::*get_nclusters_function_type )(  ) const;
            
            CvEM_exposer.def( 
                "get_nclusters"
                , get_nclusters_function_type( &::CvEM::get_nclusters ) );
        
        }
        { //::CvEM::predict
        
            typedef float ( ::CvEM::*predict_function_type )( ::cv::Mat const &,::cv::Mat * ) const;
            typedef float ( CvEM_wrapper::*default_predict_function_type )( ::cv::Mat const &,::cv::Mat * ) const;
            
            CvEM_exposer.def( 
                "predict"
                , predict_function_type(&::CvEM::predict)
                , default_predict_function_type(&CvEM_wrapper::default_predict)
                , ( bp::arg("sample"), bp::arg("probs") ) );
        
        }
        { //::CvEM::train
        
            typedef bool ( ::CvEM::*train_function_type )( ::cv::Mat const &,::cv::Mat const &,::CvEMParams,::cv::Mat * ) ;
            typedef bool ( CvEM_wrapper::*default_train_function_type )( ::cv::Mat const &,::cv::Mat const &,::CvEMParams,::cv::Mat * ) ;
            
            CvEM_exposer.def( 
                "train"
                , train_function_type(&::CvEM::train)
                , default_train_function_type(&CvEM_wrapper::default_train)
                , ( bp::arg("samples"), bp::arg("sample_idx")=cv::Mat(), bp::arg("params")=::CvEMParams( ), bp::arg("labels")=bp::object() ) );
        
        }
        { //::CvStatModel::load
        
            typedef void ( ::CvStatModel::*load_function_type )( char const *,char const * ) ;
            typedef void ( CvEM_wrapper::*default_load_function_type )( char const *,char const * ) ;
            
            CvEM_exposer.def( 
                "load"
                , load_function_type(&::CvStatModel::load)
                , default_load_function_type(&CvEM_wrapper::default_load)
                , ( bp::arg("filename"), bp::arg("name")=bp::object() ) );
        
        }
        { //::CvStatModel::read
        
            typedef void ( *default_read_function_type )( ::CvStatModel &,::cv::FileStorage &,::cv::FileNode & );
            
            CvEM_exposer.def( 
                "read"
                , default_read_function_type( &CvEM_wrapper::default_read )
                , ( bp::arg("inst"), bp::arg("storage"), bp::arg("node") )
                , "\nArgument 'node':"\
    "\n    C/C++ type: ::CvFileNode *."\
    "\n    Python type: FileNode."\
    "\nArgument 'storage':"\
    "\n    C/C++ type: ::CvFileStorage *."\
    "\n    Python type: FileStorage." );
        
        }
        { //::CvStatModel::save
        
            typedef void ( ::CvStatModel::*save_function_type )( char const *,char const * ) const;
            typedef void ( CvEM_wrapper::*default_save_function_type )( char const *,char const * ) const;
            
            CvEM_exposer.def( 
                "save"
                , save_function_type(&::CvStatModel::save)
                , default_save_function_type(&CvEM_wrapper::default_save)
                , ( bp::arg("filename"), bp::arg("name")=bp::object() ) );
        
        }
        { //::CvStatModel::write
        
            typedef void ( *default_write_function_type )( ::CvStatModel const &,::cv::FileStorage &,char const * );
            
            CvEM_exposer.def( 
                "write"
                , default_write_function_type( &CvEM_wrapper::default_write )
                , ( bp::arg("inst"), bp::arg("storage"), bp::arg("name") )
                , "\nArgument 'storage':"\
    "\n    C/C++ type: ::CvFileStorage *."\
    "\n    Python type: FileStorage." );
        
        }
    }

}
