// This file has been generated by Py++.

#include "boost/python.hpp"
#include "__array_1.pypp.hpp"
#include "__ctypes_integration.pypp.hpp"
#include "cv_h_wrapper.hpp"
#include "boost/python/object.hpp"
#include "boost/python/list.hpp"
#include "boost/python/tuple.hpp"
#include "boost/python/str.hpp"
#include "opencv_converters.hpp"
#include "cv_h_ext_classes_3.pypp.hpp"

namespace bp = boost::python;

struct CvQuadEdge2D_wrapper : CvQuadEdge2D, bp::wrapper< CvQuadEdge2D > {

    CvQuadEdge2D_wrapper(CvQuadEdge2D const & arg )
    : CvQuadEdge2D( arg )
      , bp::wrapper< CvQuadEdge2D >(){
        // copy constructor
        
    }

    CvQuadEdge2D_wrapper()
    : CvQuadEdge2D()
      , bp::wrapper< CvQuadEdge2D >(){
        // null constructor
        
    }

    static pyplusplus::containers::static_sized::array_1_t< size_t, 4>
    pyplusplus_next_wrapper( CvQuadEdge2D & inst ){
        return pyplusplus::containers::static_sized::array_1_t< size_t, 4>( inst.next );
    }

};

static bp::object get_CvQuadEdge2D_pt( CvQuadEdge2D const & inst ){
    bp::list l;
    for(int i = 0; i < 4; ++i)
        l.append(inst.pt[i]);
    return bp::tuple(l);
}

static cv::Point_<float> *get_CvSURFPoint_pt(CvSURFPoint const &inst) { return (cv::Point_<float> *)(&inst.pt); }

static cv::Point_<int> *get_CvStarKeypoint_pt(CvStarKeypoint const &inst) { return (cv::Point_<int> *)(&inst.pt); }

struct CvStereoBMState_wrapper : CvStereoBMState, bp::wrapper< CvStereoBMState > {

    CvStereoBMState_wrapper(CvStereoBMState const & arg )
    : CvStereoBMState( arg )
      , bp::wrapper< CvStereoBMState >(){
        // copy constructor
        
    }

    CvStereoBMState_wrapper()
    : CvStereoBMState()
      , bp::wrapper< CvStereoBMState >(){
        // null constructor
        
    }

    cv::Mat preFilteredImg0_as_Mat;
    CvMat preFilteredImg0_as_CvMat;
    void update_preFilteredImg0()
    {
        if(preFilteredImg0_as_Mat.empty()) preFilteredImg0 = 0; // NULL pointer
        else
        {
            preFilteredImg0_as_CvMat = preFilteredImg0_as_Mat; // to ensure preFilteredImg0 points to a valid CvMat
            preFilteredImg0 = &preFilteredImg0_as_CvMat;
        }
    }
    void set_preFilteredImg0(cv::Mat const &new_preFilteredImg0)
    {
        preFilteredImg0_as_Mat = new_preFilteredImg0; // to keep a reference to preFilteredImg0
        update_preFilteredImg0();
    }
    cv::Mat & get_CvStereoBMState_preFilteredImg0()
    {
        update_preFilteredImg0();
        return preFilteredImg0_as_Mat;
    }

    cv::Mat preFilteredImg1_as_Mat;
    CvMat preFilteredImg1_as_CvMat;
    void update_preFilteredImg1()
    {
        if(preFilteredImg1_as_Mat.empty()) preFilteredImg1 = 0; // NULL pointer
        else
        {
            preFilteredImg1_as_CvMat = preFilteredImg1_as_Mat; // to ensure preFilteredImg1 points to a valid CvMat
            preFilteredImg1 = &preFilteredImg1_as_CvMat;
        }
    }
    void set_preFilteredImg1(cv::Mat const &new_preFilteredImg1)
    {
        preFilteredImg1_as_Mat = new_preFilteredImg1; // to keep a reference to preFilteredImg1
        update_preFilteredImg1();
    }
    cv::Mat & get_CvStereoBMState_preFilteredImg1()
    {
        update_preFilteredImg1();
        return preFilteredImg1_as_Mat;
    }

    cv::Mat slidingSumBuf_as_Mat;
    CvMat slidingSumBuf_as_CvMat;
    void update_slidingSumBuf()
    {
        if(slidingSumBuf_as_Mat.empty()) slidingSumBuf = 0; // NULL pointer
        else
        {
            slidingSumBuf_as_CvMat = slidingSumBuf_as_Mat; // to ensure slidingSumBuf points to a valid CvMat
            slidingSumBuf = &slidingSumBuf_as_CvMat;
        }
    }
    void set_slidingSumBuf(cv::Mat const &new_slidingSumBuf)
    {
        slidingSumBuf_as_Mat = new_slidingSumBuf; // to keep a reference to slidingSumBuf
        update_slidingSumBuf();
    }
    cv::Mat & get_CvStereoBMState_slidingSumBuf()
    {
        update_slidingSumBuf();
        return slidingSumBuf_as_Mat;
    }

    cv::Mat cost_as_Mat;
    CvMat cost_as_CvMat;
    void update_cost()
    {
        if(cost_as_Mat.empty()) cost = 0; // NULL pointer
        else
        {
            cost_as_CvMat = cost_as_Mat; // to ensure cost points to a valid CvMat
            cost = &cost_as_CvMat;
        }
    }
    void set_cost(cv::Mat const &new_cost)
    {
        cost_as_Mat = new_cost; // to keep a reference to cost
        update_cost();
    }
    cv::Mat & get_CvStereoBMState_cost()
    {
        update_cost();
        return cost_as_Mat;
    }

    cv::Mat disp_as_Mat;
    CvMat disp_as_CvMat;
    void update_disp()
    {
        if(disp_as_Mat.empty()) disp = 0; // NULL pointer
        else
        {
            disp_as_CvMat = disp_as_Mat; // to ensure disp points to a valid CvMat
            disp = &disp_as_CvMat;
        }
    }
    void set_disp(cv::Mat const &new_disp)
    {
        disp_as_Mat = new_disp; // to keep a reference to disp
        update_disp();
    }
    cv::Mat & get_CvStereoBMState_disp()
    {
        update_disp();
        return disp_as_Mat;
    }

};

static cv::Rect_<int> *get_CvStereoBMState_roi1(CvStereoBMState const &inst) { return (cv::Rect_<int> *)(&inst.roi1); }

static cv::Rect_<int> *get_CvStereoBMState_roi2(CvStereoBMState const &inst) { return (cv::Rect_<int> *)(&inst.roi2); }

struct CvStereoGCState_wrapper : CvStereoGCState, bp::wrapper< CvStereoGCState > {

    CvStereoGCState_wrapper(CvStereoGCState const & arg )
    : CvStereoGCState( arg )
      , bp::wrapper< CvStereoGCState >(){
        // copy constructor
        
    }

    CvStereoGCState_wrapper()
    : CvStereoGCState()
      , bp::wrapper< CvStereoGCState >(){
        // null constructor
        
    }

    cv::Mat left_as_Mat;
    CvMat left_as_CvMat;
    void update_left()
    {
        if(left_as_Mat.empty()) left = 0; // NULL pointer
        else
        {
            left_as_CvMat = left_as_Mat; // to ensure left points to a valid CvMat
            left = &left_as_CvMat;
        }
    }
    void set_left(cv::Mat const &new_left)
    {
        left_as_Mat = new_left; // to keep a reference to left
        update_left();
    }
    cv::Mat & get_CvStereoGCState_left()
    {
        update_left();
        return left_as_Mat;
    }

    cv::Mat right_as_Mat;
    CvMat right_as_CvMat;
    void update_right()
    {
        if(right_as_Mat.empty()) right = 0; // NULL pointer
        else
        {
            right_as_CvMat = right_as_Mat; // to ensure right points to a valid CvMat
            right = &right_as_CvMat;
        }
    }
    void set_right(cv::Mat const &new_right)
    {
        right_as_Mat = new_right; // to keep a reference to right
        update_right();
    }
    cv::Mat & get_CvStereoGCState_right()
    {
        update_right();
        return right_as_Mat;
    }

    cv::Mat dispLeft_as_Mat;
    CvMat dispLeft_as_CvMat;
    void update_dispLeft()
    {
        if(dispLeft_as_Mat.empty()) dispLeft = 0; // NULL pointer
        else
        {
            dispLeft_as_CvMat = dispLeft_as_Mat; // to ensure dispLeft points to a valid CvMat
            dispLeft = &dispLeft_as_CvMat;
        }
    }
    void set_dispLeft(cv::Mat const &new_dispLeft)
    {
        dispLeft_as_Mat = new_dispLeft; // to keep a reference to dispLeft
        update_dispLeft();
    }
    cv::Mat & get_CvStereoGCState_dispLeft()
    {
        update_dispLeft();
        return dispLeft_as_Mat;
    }

    cv::Mat dispRight_as_Mat;
    CvMat dispRight_as_CvMat;
    void update_dispRight()
    {
        if(dispRight_as_Mat.empty()) dispRight = 0; // NULL pointer
        else
        {
            dispRight_as_CvMat = dispRight_as_Mat; // to ensure dispRight points to a valid CvMat
            dispRight = &dispRight_as_CvMat;
        }
    }
    void set_dispRight(cv::Mat const &new_dispRight)
    {
        dispRight_as_Mat = new_dispRight; // to keep a reference to dispRight
        update_dispRight();
    }
    cv::Mat & get_CvStereoGCState_dispRight()
    {
        update_dispRight();
        return dispRight_as_Mat;
    }

    cv::Mat ptrLeft_as_Mat;
    CvMat ptrLeft_as_CvMat;
    void update_ptrLeft()
    {
        if(ptrLeft_as_Mat.empty()) ptrLeft = 0; // NULL pointer
        else
        {
            ptrLeft_as_CvMat = ptrLeft_as_Mat; // to ensure ptrLeft points to a valid CvMat
            ptrLeft = &ptrLeft_as_CvMat;
        }
    }
    void set_ptrLeft(cv::Mat const &new_ptrLeft)
    {
        ptrLeft_as_Mat = new_ptrLeft; // to keep a reference to ptrLeft
        update_ptrLeft();
    }
    cv::Mat & get_CvStereoGCState_ptrLeft()
    {
        update_ptrLeft();
        return ptrLeft_as_Mat;
    }

    cv::Mat ptrRight_as_Mat;
    CvMat ptrRight_as_CvMat;
    void update_ptrRight()
    {
        if(ptrRight_as_Mat.empty()) ptrRight = 0; // NULL pointer
        else
        {
            ptrRight_as_CvMat = ptrRight_as_Mat; // to ensure ptrRight points to a valid CvMat
            ptrRight = &ptrRight_as_CvMat;
        }
    }
    void set_ptrRight(cv::Mat const &new_ptrRight)
    {
        ptrRight_as_Mat = new_ptrRight; // to keep a reference to ptrRight
        update_ptrRight();
    }
    cv::Mat & get_CvStereoGCState_ptrRight()
    {
        update_ptrRight();
        return ptrRight_as_Mat;
    }

    cv::Mat vtxBuf_as_Mat;
    CvMat vtxBuf_as_CvMat;
    void update_vtxBuf()
    {
        if(vtxBuf_as_Mat.empty()) vtxBuf = 0; // NULL pointer
        else
        {
            vtxBuf_as_CvMat = vtxBuf_as_Mat; // to ensure vtxBuf points to a valid CvMat
            vtxBuf = &vtxBuf_as_CvMat;
        }
    }
    void set_vtxBuf(cv::Mat const &new_vtxBuf)
    {
        vtxBuf_as_Mat = new_vtxBuf; // to keep a reference to vtxBuf
        update_vtxBuf();
    }
    cv::Mat & get_CvStereoGCState_vtxBuf()
    {
        update_vtxBuf();
        return vtxBuf_as_Mat;
    }

    cv::Mat edgeBuf_as_Mat;
    CvMat edgeBuf_as_CvMat;
    void update_edgeBuf()
    {
        if(edgeBuf_as_Mat.empty()) edgeBuf = 0; // NULL pointer
        else
        {
            edgeBuf_as_CvMat = edgeBuf_as_Mat; // to ensure edgeBuf points to a valid CvMat
            edgeBuf = &edgeBuf_as_CvMat;
        }
    }
    void set_edgeBuf(cv::Mat const &new_edgeBuf)
    {
        edgeBuf_as_Mat = new_edgeBuf; // to keep a reference to edgeBuf
        update_edgeBuf();
    }
    cv::Mat & get_CvStereoGCState_edgeBuf()
    {
        update_edgeBuf();
        return edgeBuf_as_Mat;
    }

};

static CvSeq * get_CvSubdiv2D_h_prev( CvSubdiv2D const & inst ) { return inst.h_prev; }

static CvSeq * get_CvSubdiv2D_h_next( CvSubdiv2D const & inst ) { return inst.h_next; }

static CvSeq * get_CvSubdiv2D_v_prev( CvSubdiv2D const & inst ) { return inst.v_prev; }

static CvSeq * get_CvSubdiv2D_v_next( CvSubdiv2D const & inst ) { return inst.v_next; }

static ::CvSeqBlock * get_CvSubdiv2D_free_blocks( CvSubdiv2D const & inst ) { return inst.free_blocks; }

static ::CvSeqBlock * get_CvSubdiv2D_first( CvSubdiv2D const & inst ) { return inst.first; }

static bp::object get_CvSubdiv2D_block_max( CvSubdiv2D const & inst ){        
    return inst.block_max? bp::str(inst.block_max): bp::object();
}

static bp::object get_CvSubdiv2D_ptr( CvSubdiv2D const & inst ){        
    return inst.ptr? bp::str(inst.ptr): bp::object();
}

static ::CvSetElem * get_CvSubdiv2D_free_elems( CvSubdiv2D const & inst ) { return inst.free_elems; }

static ::CvSet * get_CvSubdiv2D_edges( CvSubdiv2D const & inst ) { return inst.edges; }

static cv::MemStorage get_CvSubdiv2D_storage(CvSubdiv2D const &inst) { return cv::MemStorage(inst.storage); }

static cv::Point_<float> *get_CvSubdiv2D_topleft(CvSubdiv2D const &inst) { return (cv::Point_<float> *)(&inst.topleft); }

static cv::Point_<float> *get_CvSubdiv2D_bottomright(CvSubdiv2D const &inst) { return (cv::Point_<float> *)(&inst.bottomright); }

static cv::Point_<float> *get_CvSubdiv2DPoint_pt(CvSubdiv2DPoint const &inst) { return (cv::Point_<float> *)(&inst.pt); }

static size_t Seq_CvConnectedComp_len(cv::Seq<CvConnectedComp> const &inst) { return inst.size(); }

static ::CvSeq * get_Seq_CvConnectedComp_seq( cv::Seq<CvConnectedComp> const & inst ) { return inst.seq; }

static size_t Seq_CvSURFPoint_len(cv::Seq<CvSURFPoint> const &inst) { return inst.size(); }

static ::CvSeq * get_Seq_CvSURFPoint_seq( cv::Seq<CvSURFPoint> const & inst ) { return inst.seq; }

void register_classes_3(){

    { //::CvQuadEdge2D
        typedef bp::class_< CvQuadEdge2D_wrapper > CvQuadEdge2D_exposer_t;
        CvQuadEdge2D_exposer_t CvQuadEdge2D_exposer = CvQuadEdge2D_exposer_t( "CvQuadEdge2D" );
        bp::scope CvQuadEdge2D_scope( CvQuadEdge2D_exposer );
        CvQuadEdge2D_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< CvQuadEdge2D >() );
        CvQuadEdge2D_exposer.def_readwrite( "flags", &CvQuadEdge2D::flags );
        pyplusplus::containers::static_sized::register_array_1< size_t, 4 >( "__array_1_size_t_4" );
        { //CvQuadEdge2D::next [variable], type=CvSubdiv2DEdge[4]
        
            typedef pyplusplus::containers::static_sized::array_1_t< size_t, 4> ( *array_wrapper_creator )( CvQuadEdge2D & );
            
            CvQuadEdge2D_exposer.add_property( "next"
                , bp::make_function( array_wrapper_creator(&CvQuadEdge2D_wrapper::pyplusplus_next_wrapper)
                                    , bp::with_custodian_and_ward_postcall< 0, 1 >() ) );
        }
        CvQuadEdge2D_exposer.add_property( "pt", &::get_CvQuadEdge2D_pt );
    }

    bp::class_< CvSURFParams >( "CvSURFParams" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvSURFParams >() )    
        .def_readwrite( "extended", &CvSURFParams::extended )    
        .def_readwrite( "hessianThreshold", &CvSURFParams::hessianThreshold )    
        .def_readwrite( "nOctaveLayers", &CvSURFParams::nOctaveLayers )    
        .def_readwrite( "nOctaves", &CvSURFParams::nOctaves );

    bp::class_< CvSURFPoint >( "CvSURFPoint" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvSURFPoint >() )    
        .def_readwrite( "dir", &CvSURFPoint::dir )    
        .def_readwrite( "hessian", &CvSURFPoint::hessian )    
        .def_readwrite( "laplacian", &CvSURFPoint::laplacian )    
        .def_readwrite( "size", &CvSURFPoint::size )    
        .add_property( "pt", bp::make_function(&::get_CvSURFPoint_pt, bp::return_internal_reference<>()) );

    bp::class_< CvStarKeypoint >( "CvStarKeypoint" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvStarKeypoint >() )    
        .def_readwrite( "response", &CvStarKeypoint::response )    
        .def_readwrite( "size", &CvStarKeypoint::size )    
        .add_property( "pt", bp::make_function(&::get_CvStarKeypoint_pt, bp::return_internal_reference<>()) );

    bp::class_< CvStereoBMState_wrapper >( "CvStereoBMState" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvStereoBMState >() )    
        .def_readwrite( "SADWindowSize", &CvStereoBMState::SADWindowSize )    
        .def_readwrite( "disp12MaxDiff", &CvStereoBMState::disp12MaxDiff )    
        .def_readwrite( "minDisparity", &CvStereoBMState::minDisparity )    
        .def_readwrite( "numberOfDisparities", &CvStereoBMState::numberOfDisparities )    
        .def_readwrite( "preFilterCap", &CvStereoBMState::preFilterCap )    
        .def_readwrite( "preFilterSize", &CvStereoBMState::preFilterSize )    
        .def_readwrite( "preFilterType", &CvStereoBMState::preFilterType )    
        .def_readwrite( "speckleRange", &CvStereoBMState::speckleRange )    
        .def_readwrite( "speckleWindowSize", &CvStereoBMState::speckleWindowSize )    
        .def_readwrite( "textureThreshold", &CvStereoBMState::textureThreshold )    
        .def_readwrite( "trySmallerWindows", &CvStereoBMState::trySmallerWindows )    
        .def_readwrite( "uniquenessRatio", &CvStereoBMState::uniquenessRatio )    
        .add_property( "roi1", bp::make_function(&::get_CvStereoBMState_roi1, bp::return_internal_reference<>()) )    
        .add_property( "roi2", bp::make_function(&::get_CvStereoBMState_roi2, bp::return_internal_reference<>()) )    
        .add_property( "preFilteredImg0", bp::make_function(&CvStereoBMState_wrapper::get_CvStereoBMState_preFilteredImg0, bp::return_internal_reference<>()),
            &CvStereoBMState_wrapper::set_preFilteredImg0)    
        .def( "validate_preFilteredImg0", &CvStereoBMState_wrapper::update_preFilteredImg0, "Updates the internal C pointer that represents 'preFilteredImg0'. The function should be called every time the header of 'preFilteredImg0' is modified by the user." )    
        .add_property( "preFilteredImg1", bp::make_function(&CvStereoBMState_wrapper::get_CvStereoBMState_preFilteredImg1, bp::return_internal_reference<>()),
            &CvStereoBMState_wrapper::set_preFilteredImg1)    
        .def( "validate_preFilteredImg1", &CvStereoBMState_wrapper::update_preFilteredImg1, "Updates the internal C pointer that represents 'preFilteredImg1'. The function should be called every time the header of 'preFilteredImg1' is modified by the user." )    
        .add_property( "slidingSumBuf", bp::make_function(&CvStereoBMState_wrapper::get_CvStereoBMState_slidingSumBuf, bp::return_internal_reference<>()),
            &CvStereoBMState_wrapper::set_slidingSumBuf)    
        .def( "validate_slidingSumBuf", &CvStereoBMState_wrapper::update_slidingSumBuf, "Updates the internal C pointer that represents 'slidingSumBuf'. The function should be called every time the header of 'slidingSumBuf' is modified by the user." )    
        .add_property( "cost", bp::make_function(&CvStereoBMState_wrapper::get_CvStereoBMState_cost, bp::return_internal_reference<>()),
            &CvStereoBMState_wrapper::set_cost)    
        .def( "validate_cost", &CvStereoBMState_wrapper::update_cost, "Updates the internal C pointer that represents 'cost'. The function should be called every time the header of 'cost' is modified by the user." )    
        .add_property( "disp", bp::make_function(&CvStereoBMState_wrapper::get_CvStereoBMState_disp, bp::return_internal_reference<>()),
            &CvStereoBMState_wrapper::set_disp)    
        .def( "validate_disp", &CvStereoBMState_wrapper::update_disp, "Updates the internal C pointer that represents 'disp'. The function should be called every time the header of 'disp' is modified by the user." );

    bp::class_< CvStereoGCState_wrapper >( "CvStereoGCState" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvStereoGCState >() )    
        .def_readwrite( "Ithreshold", &CvStereoGCState::Ithreshold )    
        .def_readwrite( "K", &CvStereoGCState::K )    
        .def_readwrite( "interactionRadius", &CvStereoGCState::interactionRadius )    
        .def_readwrite( "lambda", &CvStereoGCState::lambda )    
        .def_readwrite( "lambda1", &CvStereoGCState::lambda1 )    
        .def_readwrite( "lambda2", &CvStereoGCState::lambda2 )    
        .def_readwrite( "maxIters", &CvStereoGCState::maxIters )    
        .def_readwrite( "minDisparity", &CvStereoGCState::minDisparity )    
        .def_readwrite( "numberOfDisparities", &CvStereoGCState::numberOfDisparities )    
        .def_readwrite( "occlusionCost", &CvStereoGCState::occlusionCost )    
        .add_property( "left", bp::make_function(&CvStereoGCState_wrapper::get_CvStereoGCState_left, bp::return_internal_reference<>()),
            &CvStereoGCState_wrapper::set_left)    
        .def( "validate_left", &CvStereoGCState_wrapper::update_left, "Updates the internal C pointer that represents 'left'. The function should be called every time the header of 'left' is modified by the user." )    
        .add_property( "right", bp::make_function(&CvStereoGCState_wrapper::get_CvStereoGCState_right, bp::return_internal_reference<>()),
            &CvStereoGCState_wrapper::set_right)    
        .def( "validate_right", &CvStereoGCState_wrapper::update_right, "Updates the internal C pointer that represents 'right'. The function should be called every time the header of 'right' is modified by the user." )    
        .add_property( "dispLeft", bp::make_function(&CvStereoGCState_wrapper::get_CvStereoGCState_dispLeft, bp::return_internal_reference<>()),
            &CvStereoGCState_wrapper::set_dispLeft)    
        .def( "validate_dispLeft", &CvStereoGCState_wrapper::update_dispLeft, "Updates the internal C pointer that represents 'dispLeft'. The function should be called every time the header of 'dispLeft' is modified by the user." )    
        .add_property( "dispRight", bp::make_function(&CvStereoGCState_wrapper::get_CvStereoGCState_dispRight, bp::return_internal_reference<>()),
            &CvStereoGCState_wrapper::set_dispRight)    
        .def( "validate_dispRight", &CvStereoGCState_wrapper::update_dispRight, "Updates the internal C pointer that represents 'dispRight'. The function should be called every time the header of 'dispRight' is modified by the user." )    
        .add_property( "ptrLeft", bp::make_function(&CvStereoGCState_wrapper::get_CvStereoGCState_ptrLeft, bp::return_internal_reference<>()),
            &CvStereoGCState_wrapper::set_ptrLeft)    
        .def( "validate_ptrLeft", &CvStereoGCState_wrapper::update_ptrLeft, "Updates the internal C pointer that represents 'ptrLeft'. The function should be called every time the header of 'ptrLeft' is modified by the user." )    
        .add_property( "ptrRight", bp::make_function(&CvStereoGCState_wrapper::get_CvStereoGCState_ptrRight, bp::return_internal_reference<>()),
            &CvStereoGCState_wrapper::set_ptrRight)    
        .def( "validate_ptrRight", &CvStereoGCState_wrapper::update_ptrRight, "Updates the internal C pointer that represents 'ptrRight'. The function should be called every time the header of 'ptrRight' is modified by the user." )    
        .add_property( "vtxBuf", bp::make_function(&CvStereoGCState_wrapper::get_CvStereoGCState_vtxBuf, bp::return_internal_reference<>()),
            &CvStereoGCState_wrapper::set_vtxBuf)    
        .def( "validate_vtxBuf", &CvStereoGCState_wrapper::update_vtxBuf, "Updates the internal C pointer that represents 'vtxBuf'. The function should be called every time the header of 'vtxBuf' is modified by the user." )    
        .add_property( "edgeBuf", bp::make_function(&CvStereoGCState_wrapper::get_CvStereoGCState_edgeBuf, bp::return_internal_reference<>()),
            &CvStereoGCState_wrapper::set_edgeBuf)    
        .def( "validate_edgeBuf", &CvStereoGCState_wrapper::update_edgeBuf, "Updates the internal C pointer that represents 'edgeBuf'. The function should be called every time the header of 'edgeBuf' is modified by the user." );

    bp::class_< CvSubdiv2D >( "CvSubdiv2D" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvSubdiv2D >() )    
        .def_readwrite( "active_count", &CvSubdiv2D::active_count )    
        .def_readwrite( "delta_elems", &CvSubdiv2D::delta_elems )    
        .def_readwrite( "elem_size", &CvSubdiv2D::elem_size )    
        .def_readwrite( "flags", &CvSubdiv2D::flags )    
        .def_readwrite( "header_size", &CvSubdiv2D::header_size )    
        .def_readwrite( "is_geometry_valid", &CvSubdiv2D::is_geometry_valid )    
        .def_readwrite( "quad_edges", &CvSubdiv2D::quad_edges )    
        .def_readwrite( "recent_edge", &CvSubdiv2D::recent_edge )    
        .def_readwrite( "total", &CvSubdiv2D::total )    
        .add_property( "h_prev", bp::make_function(&::get_CvSubdiv2D_h_prev, bp::return_internal_reference<>()) )    
        .add_property( "h_next", bp::make_function(&::get_CvSubdiv2D_h_next, bp::return_internal_reference<>()) )    
        .add_property( "v_prev", bp::make_function(&::get_CvSubdiv2D_v_prev, bp::return_internal_reference<>()) )    
        .add_property( "v_next", bp::make_function(&::get_CvSubdiv2D_v_next, bp::return_internal_reference<>()) )    
        .add_property( "free_blocks", bp::make_function(&::get_CvSubdiv2D_free_blocks, bp::return_internal_reference<>()) )    
        .add_property( "first", bp::make_function(&::get_CvSubdiv2D_first, bp::return_internal_reference<>()) )    
        .add_property( "block_max", &::get_CvSubdiv2D_block_max )    
        .add_property( "ptr", &::get_CvSubdiv2D_ptr )    
        .add_property( "free_elems", bp::make_function(&::get_CvSubdiv2D_free_elems, bp::return_internal_reference<>()) )    
        .add_property( "edges", bp::make_function(&::get_CvSubdiv2D_edges, bp::return_internal_reference<>()) )    
        .add_property( "storage", bp::make_function(&::get_CvSubdiv2D_storage, bp::with_custodian_and_ward_postcall<0, 1>()) )    
        .add_property( "topleft", bp::make_function(&::get_CvSubdiv2D_topleft, bp::return_internal_reference<>()) )    
        .add_property( "bottomright", bp::make_function(&::get_CvSubdiv2D_bottomright, bp::return_internal_reference<>()) );

    bp::class_< CvSubdiv2DPoint >( "CvSubdiv2DPoint" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvSubdiv2DPoint >() )    
        .def_readwrite( "first", &CvSubdiv2DPoint::first )    
        .def_readwrite( "flags", &CvSubdiv2DPoint::flags )    
        .def_readwrite( "id", &CvSubdiv2DPoint::id )    
        .add_property( "pt", bp::make_function(&::get_CvSubdiv2DPoint_pt, bp::return_internal_reference<>()) );

    bp::class_< _CvContourScanner >( "CvContourScanner" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< _CvContourScanner >() );

    { //::cv::Seq< CvConnectedComp >
        typedef bp::class_< cv::Seq< CvConnectedComp > > Seq_CvConnectedComp_exposer_t;
        Seq_CvConnectedComp_exposer_t Seq_CvConnectedComp_exposer = Seq_CvConnectedComp_exposer_t( "Seq_CvConnectedComp", bp::init< >() );
        bp::scope Seq_CvConnectedComp_scope( Seq_CvConnectedComp_exposer );
        Seq_CvConnectedComp_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Seq< CvConnectedComp > >() );
        Seq_CvConnectedComp_exposer.def( bp::init< CvSeq const * >(( bp::arg("_seq") )) );
        bp::implicitly_convertible< CvSeq const *, cv::Seq< CvConnectedComp > >();
        Seq_CvConnectedComp_exposer.def( bp::init< cv::Ptr< CvMemStorage > &, bp::optional< int > >(( bp::arg("storage"), bp::arg("headerSize")=(int)(56u) )) );
        bp::implicitly_convertible< cv::Ptr< CvMemStorage > &, cv::Seq< CvConnectedComp > >();
        { //::cv::Seq< CvConnectedComp >::channels
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef int ( exported_class_t::*channels_function_type )(  ) const;
            
            Seq_CvConnectedComp_exposer.def( 
                "channels"
                , channels_function_type( &::cv::Seq< CvConnectedComp >::channels ) );
        
        }
        { //::cv::Seq< CvConnectedComp >::clear
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef void ( exported_class_t::*clear_function_type )(  ) ;
            
            Seq_CvConnectedComp_exposer.def( 
                "clear"
                , clear_function_type( &::cv::Seq< CvConnectedComp >::clear ) );
        
        }
        { //::cv::Seq< CvConnectedComp >::copyTo
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef void ( exported_class_t::*copyTo_function_type )( ::std::vector< CvConnectedComp > &,::cv::Range const & ) const;
            
            Seq_CvConnectedComp_exposer.def( 
                "copyTo"
                , copyTo_function_type( &::cv::Seq< CvConnectedComp >::copyTo )
                , ( bp::arg("vec"), bp::arg("range")=cv::Range::all() ) );
        
        }
        { //::cv::Seq< CvConnectedComp >::depth
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef int ( exported_class_t::*depth_function_type )(  ) const;
            
            Seq_CvConnectedComp_exposer.def( 
                "depth"
                , depth_function_type( &::cv::Seq< CvConnectedComp >::depth ) );
        
        }
        { //::cv::Seq< CvConnectedComp >::elemSize
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef ::size_t ( exported_class_t::*elemSize_function_type )(  ) const;
            
            Seq_CvConnectedComp_exposer.def( 
                "elemSize"
                , elemSize_function_type( &::cv::Seq< CvConnectedComp >::elemSize ) );
        
        }
        { //::cv::Seq< CvConnectedComp >::empty
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef bool ( exported_class_t::*empty_function_type )(  ) const;
            
            Seq_CvConnectedComp_exposer.def( 
                "empty"
                , empty_function_type( &::cv::Seq< CvConnectedComp >::empty ) );
        
        }
        { //::cv::Seq< CvConnectedComp >::index
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef ::size_t ( exported_class_t::*index_function_type )( ::CvConnectedComp const & ) const;
            
            Seq_CvConnectedComp_exposer.def( 
                "index"
                , index_function_type( &::cv::Seq< CvConnectedComp >::index )
                , ( bp::arg("elem") ) );
        
        }
        { //::cv::Seq< CvConnectedComp >::insert
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef void ( exported_class_t::*insert_function_type )( int,::CvConnectedComp const & ) ;
            
            Seq_CvConnectedComp_exposer.def( 
                "insert"
                , insert_function_type( &::cv::Seq< CvConnectedComp >::insert )
                , ( bp::arg("idx"), bp::arg("elem") ) );
        
        }
        Seq_CvConnectedComp_exposer.def( "__temp_func", &cv::Seq< CvConnectedComp >::operator ::std::vector< CvConnectedComp > , "\nWrapped function:"
    "\n    operator ::std::vector<CvConnectedComp, "
    "\n    std::allocator<CvConnectedComp> >" );
        { //::cv::Seq< CvConnectedComp >::operator[]
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef ::CvConnectedComp & ( exported_class_t::*__getitem___function_type )( int ) ;
            
            Seq_CvConnectedComp_exposer.def( 
                "__getitem__"
                , __getitem___function_type( &::cv::Seq< CvConnectedComp >::operator[] )
                , ( bp::arg("idx") )
                , bp::return_internal_reference< >()
                , "\nWrapped function:"
    "\n    operator[]" );
        
        }
        { //::cv::Seq< CvConnectedComp >::operator[]
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef ::CvConnectedComp const & ( exported_class_t::*__getitem___function_type )( int ) const;
            
            Seq_CvConnectedComp_exposer.def( 
                "__getitem__"
                , __getitem___function_type( &::cv::Seq< CvConnectedComp >::operator[] )
                , ( bp::arg("idx") )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "\nWrapped function:"
    "\n    operator[]" );
        
        }
        { //::cv::Seq< CvConnectedComp >::pop_back
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef void ( exported_class_t::*pop_back_function_type )(  ) ;
            
            Seq_CvConnectedComp_exposer.def( 
                "pop_back"
                , pop_back_function_type( &::cv::Seq< CvConnectedComp >::pop_back ) );
        
        }
        { //::cv::Seq< CvConnectedComp >::pop_front
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef void ( exported_class_t::*pop_front_function_type )(  ) ;
            
            Seq_CvConnectedComp_exposer.def( 
                "pop_front"
                , pop_front_function_type( &::cv::Seq< CvConnectedComp >::pop_front ) );
        
        }
        { //::cv::Seq< CvConnectedComp >::push_back
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef void ( exported_class_t::*push_back_function_type )( ::CvConnectedComp const & ) ;
            
            Seq_CvConnectedComp_exposer.def( 
                "push_back"
                , push_back_function_type( &::cv::Seq< CvConnectedComp >::push_back )
                , ( bp::arg("elem") ) );
        
        }
        { //::cv::Seq< CvConnectedComp >::push_front
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef void ( exported_class_t::*push_front_function_type )( ::CvConnectedComp const & ) ;
            
            Seq_CvConnectedComp_exposer.def( 
                "push_front"
                , push_front_function_type( &::cv::Seq< CvConnectedComp >::push_front )
                , ( bp::arg("elem") ) );
        
        }
        { //::cv::Seq< CvConnectedComp >::remove
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef void ( exported_class_t::*remove_function_type )( int ) ;
            
            Seq_CvConnectedComp_exposer.def( 
                "remove"
                , remove_function_type( &::cv::Seq< CvConnectedComp >::remove )
                , ( bp::arg("idx") ) );
        
        }
        { //::cv::Seq< CvConnectedComp >::remove
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef void ( exported_class_t::*remove_function_type )( ::cv::Range const & ) ;
            
            Seq_CvConnectedComp_exposer.def( 
                "remove"
                , remove_function_type( &::cv::Seq< CvConnectedComp >::remove )
                , ( bp::arg("r") ) );
        
        }
        { //::cv::Seq< CvConnectedComp >::size
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef ::size_t ( exported_class_t::*size_function_type )(  ) const;
            
            Seq_CvConnectedComp_exposer.def( 
                "size"
                , size_function_type( &::cv::Seq< CvConnectedComp >::size ) );
        
        }
        { //::cv::Seq< CvConnectedComp >::type
        
            typedef cv::Seq< CvConnectedComp > exported_class_t;
            typedef int ( exported_class_t::*type_function_type )(  ) const;
            
            Seq_CvConnectedComp_exposer.def( 
                "type"
                , type_function_type( &::cv::Seq< CvConnectedComp >::type ) );
        
        }
        Seq_CvConnectedComp_exposer.def("__len__", &::Seq_CvConnectedComp_len);
        Seq_CvConnectedComp_exposer.add_property( "seq", bp::make_function(&::get_Seq_CvConnectedComp_seq, bp::return_internal_reference<>()) );
    }

    { //::cv::Seq< CvSURFPoint >
        typedef bp::class_< cv::Seq< CvSURFPoint > > Seq_CvSURFPoint_exposer_t;
        Seq_CvSURFPoint_exposer_t Seq_CvSURFPoint_exposer = Seq_CvSURFPoint_exposer_t( "Seq_CvSURFPoint", bp::init< >() );
        bp::scope Seq_CvSURFPoint_scope( Seq_CvSURFPoint_exposer );
        Seq_CvSURFPoint_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Seq< CvSURFPoint > >() );
        Seq_CvSURFPoint_exposer.def( bp::init< CvSeq const * >(( bp::arg("_seq") )) );
        bp::implicitly_convertible< CvSeq const *, cv::Seq< CvSURFPoint > >();
        Seq_CvSURFPoint_exposer.def( bp::init< cv::Ptr< CvMemStorage > &, bp::optional< int > >(( bp::arg("storage"), bp::arg("headerSize")=(int)(56u) )) );
        bp::implicitly_convertible< cv::Ptr< CvMemStorage > &, cv::Seq< CvSURFPoint > >();
        { //::cv::Seq< CvSURFPoint >::channels
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef int ( exported_class_t::*channels_function_type )(  ) const;
            
            Seq_CvSURFPoint_exposer.def( 
                "channels"
                , channels_function_type( &::cv::Seq< CvSURFPoint >::channels ) );
        
        }
        { //::cv::Seq< CvSURFPoint >::clear
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef void ( exported_class_t::*clear_function_type )(  ) ;
            
            Seq_CvSURFPoint_exposer.def( 
                "clear"
                , clear_function_type( &::cv::Seq< CvSURFPoint >::clear ) );
        
        }
        { //::cv::Seq< CvSURFPoint >::copyTo
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef void ( exported_class_t::*copyTo_function_type )( ::std::vector< CvSURFPoint > &,::cv::Range const & ) const;
            
            Seq_CvSURFPoint_exposer.def( 
                "copyTo"
                , copyTo_function_type( &::cv::Seq< CvSURFPoint >::copyTo )
                , ( bp::arg("vec"), bp::arg("range")=cv::Range::all() ) );
        
        }
        { //::cv::Seq< CvSURFPoint >::depth
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef int ( exported_class_t::*depth_function_type )(  ) const;
            
            Seq_CvSURFPoint_exposer.def( 
                "depth"
                , depth_function_type( &::cv::Seq< CvSURFPoint >::depth ) );
        
        }
        { //::cv::Seq< CvSURFPoint >::elemSize
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef ::size_t ( exported_class_t::*elemSize_function_type )(  ) const;
            
            Seq_CvSURFPoint_exposer.def( 
                "elemSize"
                , elemSize_function_type( &::cv::Seq< CvSURFPoint >::elemSize ) );
        
        }
        { //::cv::Seq< CvSURFPoint >::empty
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef bool ( exported_class_t::*empty_function_type )(  ) const;
            
            Seq_CvSURFPoint_exposer.def( 
                "empty"
                , empty_function_type( &::cv::Seq< CvSURFPoint >::empty ) );
        
        }
        { //::cv::Seq< CvSURFPoint >::index
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef ::size_t ( exported_class_t::*index_function_type )( ::CvSURFPoint const & ) const;
            
            Seq_CvSURFPoint_exposer.def( 
                "index"
                , index_function_type( &::cv::Seq< CvSURFPoint >::index )
                , ( bp::arg("elem") ) );
        
        }
        { //::cv::Seq< CvSURFPoint >::insert
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef void ( exported_class_t::*insert_function_type )( int,::CvSURFPoint const & ) ;
            
            Seq_CvSURFPoint_exposer.def( 
                "insert"
                , insert_function_type( &::cv::Seq< CvSURFPoint >::insert )
                , ( bp::arg("idx"), bp::arg("elem") ) );
        
        }
        Seq_CvSURFPoint_exposer.def( "__temp_func", &cv::Seq< CvSURFPoint >::operator ::std::vector< CvSURFPoint > , "\nWrapped function:"
    "\n    operator ::std::vector<CvSURFPoint, std::allocator<CvSURFPoint> >" );
        { //::cv::Seq< CvSURFPoint >::operator[]
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef ::CvSURFPoint & ( exported_class_t::*__getitem___function_type )( int ) ;
            
            Seq_CvSURFPoint_exposer.def( 
                "__getitem__"
                , __getitem___function_type( &::cv::Seq< CvSURFPoint >::operator[] )
                , ( bp::arg("idx") )
                , bp::return_internal_reference< >()
                , "\nWrapped function:"
    "\n    operator[]" );
        
        }
        { //::cv::Seq< CvSURFPoint >::operator[]
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef ::CvSURFPoint const & ( exported_class_t::*__getitem___function_type )( int ) const;
            
            Seq_CvSURFPoint_exposer.def( 
                "__getitem__"
                , __getitem___function_type( &::cv::Seq< CvSURFPoint >::operator[] )
                , ( bp::arg("idx") )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "\nWrapped function:"
    "\n    operator[]" );
        
        }
        { //::cv::Seq< CvSURFPoint >::pop_back
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef void ( exported_class_t::*pop_back_function_type )(  ) ;
            
            Seq_CvSURFPoint_exposer.def( 
                "pop_back"
                , pop_back_function_type( &::cv::Seq< CvSURFPoint >::pop_back ) );
        
        }
        { //::cv::Seq< CvSURFPoint >::pop_front
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef void ( exported_class_t::*pop_front_function_type )(  ) ;
            
            Seq_CvSURFPoint_exposer.def( 
                "pop_front"
                , pop_front_function_type( &::cv::Seq< CvSURFPoint >::pop_front ) );
        
        }
        { //::cv::Seq< CvSURFPoint >::push_back
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef void ( exported_class_t::*push_back_function_type )( ::CvSURFPoint const & ) ;
            
            Seq_CvSURFPoint_exposer.def( 
                "push_back"
                , push_back_function_type( &::cv::Seq< CvSURFPoint >::push_back )
                , ( bp::arg("elem") ) );
        
        }
        { //::cv::Seq< CvSURFPoint >::push_front
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef void ( exported_class_t::*push_front_function_type )( ::CvSURFPoint const & ) ;
            
            Seq_CvSURFPoint_exposer.def( 
                "push_front"
                , push_front_function_type( &::cv::Seq< CvSURFPoint >::push_front )
                , ( bp::arg("elem") ) );
        
        }
        { //::cv::Seq< CvSURFPoint >::remove
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef void ( exported_class_t::*remove_function_type )( int ) ;
            
            Seq_CvSURFPoint_exposer.def( 
                "remove"
                , remove_function_type( &::cv::Seq< CvSURFPoint >::remove )
                , ( bp::arg("idx") ) );
        
        }
        { //::cv::Seq< CvSURFPoint >::remove
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef void ( exported_class_t::*remove_function_type )( ::cv::Range const & ) ;
            
            Seq_CvSURFPoint_exposer.def( 
                "remove"
                , remove_function_type( &::cv::Seq< CvSURFPoint >::remove )
                , ( bp::arg("r") ) );
        
        }
        { //::cv::Seq< CvSURFPoint >::size
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef ::size_t ( exported_class_t::*size_function_type )(  ) const;
            
            Seq_CvSURFPoint_exposer.def( 
                "size"
                , size_function_type( &::cv::Seq< CvSURFPoint >::size ) );
        
        }
        { //::cv::Seq< CvSURFPoint >::type
        
            typedef cv::Seq< CvSURFPoint > exported_class_t;
            typedef int ( exported_class_t::*type_function_type )(  ) const;
            
            Seq_CvSURFPoint_exposer.def( 
                "type"
                , type_function_type( &::cv::Seq< CvSURFPoint >::type ) );
        
        }
        Seq_CvSURFPoint_exposer.def("__len__", &::Seq_CvSURFPoint_len);
        Seq_CvSURFPoint_exposer.add_property( "seq", bp::make_function(&::get_Seq_CvSURFPoint_seq, bp::return_internal_reference<>()) );
    }

    { //::cv_h_dummy_struct
        typedef bp::class_< cv_h_dummy_struct > __cv_h_dummy_struct_exposer_t;
        __cv_h_dummy_struct_exposer_t __cv_h_dummy_struct_exposer = __cv_h_dummy_struct_exposer_t( "__cv_h_dummy_struct" );
        bp::scope __cv_h_dummy_struct_scope( __cv_h_dummy_struct_exposer );
        __cv_h_dummy_struct_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv_h_dummy_struct >() );
        bp::class_< cv_h_dummy_struct::dummy_struct2 >( "dummy_struct2" )    
            .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv_h_dummy_struct::dummy_struct2 >() );
        __cv_h_dummy_struct_exposer.setattr("v0", 0);
    }
    {
        
        bp::def("convert_Seq_CvConnectedComp_to_vector_CvConnectedComp", &::normal_cast< ::cv::Seq< CvConnectedComp >, ::std::vector< CvConnectedComp > >, (bp::arg("inst_Seq_CvConnectedComp")));
        bp::def("convert_Seq_CvSURFPoint_to_vector_CvSURFPoint", &::normal_cast< ::cv::Seq< CvSURFPoint >, ::std::vector< CvSURFPoint > >, (bp::arg("inst_Seq_CvSURFPoint")));;
    }

}
