// This file has been generated by Py++.

#include "boost/python.hpp"

#include "__call_policies.pypp.hpp"

#include "__convenience.pypp.hpp"

#include "opencv_converters.hpp"

#include "ndarray.hpp"

#include "boost/python/suite/indexing/vector_indexing_suite.hpp"

#include "__ctypes_integration.pypp.hpp"

#include "cv_hpp_wrapper.hpp"

#include "cv_hpp_ext/cv_hpp_ext_classes_1.pypp.hpp"

#include "cv_hpp_ext/cv_hpp_ext_classes_2.pypp.hpp"

#include "cv_hpp_ext/cv_hpp_ext_classes_3.pypp.hpp"

#include "cv_hpp_ext/cv_hpp_ext_free_functions.pypp.hpp"

#include "cv_hpp_ext/cv_hpp_ext_global_variables.pypp.hpp"

namespace bp = boost::python;

static boost::python::object HoughCircles_ea2999473356200d9d2fc8b7258555b0( ::cv::Mat const & image, int method, double dp, double minDist, double param1=100, double param2=100, int minRadius=0, int maxRadius=0 ){
    std::vector<cv::Vec<float,3> > circles2;
    ::cv::HoughCircles(image, circles2, method, dp, minDist, param1, param2, minRadius, maxRadius);
    return bp::object( circles2 );
}

static boost::python::object HoughLines_deaa796a20e753a0b781de4a4d81ba3d( ::cv::Mat const & image, double rho, double theta, int threshold, double srn=0, double stn=0 ){
    std::vector<cv::Vec<float,2> > lines2;
    ::cv::HoughLines(image, lines2, rho, theta, threshold, srn, stn);
    return bp::object( lines2 );
}

static boost::python::object HoughLinesP_7e83e90590dfee49ad9ee8d704d1cfcb( ::cv::Mat & image, double rho, double theta, int threshold, double minLineLength=0, double maxLineGap=0 ){
    std::vector<cv::Vec<int,4> > lines2;
    ::cv::HoughLinesP(image, lines2, rho, theta, threshold, minLineLength, maxLineGap);
    return bp::object( lines2 );
}

static boost::python::object HuMoments_646f4ee3824db566d9124eee2bb204ab( ::cv::Moments const & moments ){
    double native_hu[7];
    boost::python::list py_hu;
    ::cv::HuMoments(moments, native_hu);
    pyplus_conv::copy_container( native_hu, native_hu + 7, pyplus_conv::list_inserter( py_hu ) );
    return bp::object( py_hu );
}

static boost::python::object approxPolyDP_6246fabc9452f087130300d2a52e2a7d( ::cv::Mat const & curve, double epsilon, bool closed ){
    std::vector<cv::Point_<float> > approxCurve2;
    ::cv::approxPolyDP(curve, approxCurve2, epsilon, closed);
    return bp::object( approxCurve2 );
}

static boost::python::object approxPolyDP_d6c85380d14cce99fc92c414781ada55( ::cv::Mat const & curve, double epsilon, bool closed ){
    std::vector<cv::Point_<int> > approxCurve2;
    ::cv::approxPolyDP(curve, approxCurve2, epsilon, closed);
    return bp::object( approxCurve2 );
}

static void calcBackProject_fe6cdc6fffc26e8d864a094a2b14971b( std::vector<cv::Mat> const & images, std::vector<int> const & channels, ::cv::SparseMat const & hist, ::cv::Mat & backProject, std::vector<std::vector<float> > const & ranges, double scale=1, bool uniform=true ){
    size_t n0_ranges = ranges.size();
    std::vector< float * > buf_ranges(n0_ranges);
    std::vector<size_t> n1_ranges(n0_ranges);
    for(size_t i_ranges = 0; i_ranges<n0_ranges; ++i_ranges)
    {
        buf_ranges[i_ranges] = (float *)(&ranges[i_ranges][0]);
        n1_ranges[i_ranges] = ranges[i_ranges].size();
    }
        
    ::cv::calcBackProject((::cv::Mat const *)(&images[0]), (int)(images.size()), (int const *)(&channels[0]), hist, backProject, (float const * *)(&buf_ranges[0]), scale, uniform);
}

static void calcBackProject_84908d355b9d9fa6b6e1e0115efb65f8( std::vector<cv::Mat> const & images, std::vector<int> const & channels, ::cv::MatND const & hist, ::cv::Mat & backProject, std::vector<std::vector<float> > const & ranges, double scale=1, bool uniform=true ){
    size_t n0_ranges = ranges.size();
    std::vector< float * > buf_ranges(n0_ranges);
    std::vector<size_t> n1_ranges(n0_ranges);
    for(size_t i_ranges = 0; i_ranges<n0_ranges; ++i_ranges)
    {
        buf_ranges[i_ranges] = (float *)(&ranges[i_ranges][0]);
        n1_ranges[i_ranges] = ranges[i_ranges].size();
    }
        
    ::cv::calcBackProject((::cv::Mat const *)(&images[0]), (int)(images.size()), (int const *)(&channels[0]), hist, backProject, (float const * *)(&buf_ranges[0]), scale, uniform);
}

static void calcHist_8e436c4da97e1e09468541e1bed60274( std::vector<cv::Mat> const & images, std::vector<int> const & channels, ::cv::Mat const & mask, ::cv::SparseMat & hist, std::vector<int> const & histSize, std::vector<std::vector<float> > const & ranges, bool uniform=true, bool accumulate=false ){
    size_t n0_ranges = ranges.size();
    std::vector< float * > buf_ranges(n0_ranges);
    std::vector<size_t> n1_ranges(n0_ranges);
    for(size_t i_ranges = 0; i_ranges<n0_ranges; ++i_ranges)
    {
        buf_ranges[i_ranges] = (float *)(&ranges[i_ranges][0]);
        n1_ranges[i_ranges] = ranges[i_ranges].size();
    }
        
    ::cv::calcHist((::cv::Mat const *)(&images[0]), (int)(images.size()), (int const *)(&channels[0]), mask, hist, (int)(histSize.size()), (int const *)(&histSize[0]), (float const * *)(&buf_ranges[0]), uniform, accumulate);
}

static void calcHist_a4cce9bdd9689d0fb0adf901f467bfa0( std::vector<cv::Mat> const & images, std::vector<int> const & channels, ::cv::Mat const & mask, ::cv::MatND & hist, std::vector<int> const & histSize, std::vector<std::vector<float> > const & ranges, bool uniform=true, bool accumulate=false ){
    size_t n0_ranges = ranges.size();
    std::vector< float * > buf_ranges(n0_ranges);
    std::vector<size_t> n1_ranges(n0_ranges);
    for(size_t i_ranges = 0; i_ranges<n0_ranges; ++i_ranges)
    {
        buf_ranges[i_ranges] = (float *)(&ranges[i_ranges][0]);
        n1_ranges[i_ranges] = ranges[i_ranges].size();
    }
        
    ::cv::calcHist((::cv::Mat const *)(&images[0]), (int)(images.size()), (int const *)(&channels[0]), mask, hist, (int)(histSize.size()), (int const *)(&histSize[0]), (float const * *)(&buf_ranges[0]), uniform, accumulate);
}

static boost::python::tuple calibrateCamera_e3c243276629b1246626096d8ff70485( ::std::vector< std::vector< cv::Point3_<float> > > const & objectPoints, ::std::vector< std::vector< cv::Point_<float> > > const & imagePoints, ::cv::Size imageSize, ::cv::Mat & cameraMatrix, ::cv::Mat & distCoeffs, int flags=0 ){
    std::vector<cv::Mat> rvecs2;
    std::vector<cv::Mat> tvecs2;
    double result = ::cv::calibrateCamera(objectPoints, imagePoints, imageSize, cameraMatrix, distCoeffs, rvecs2, tvecs2, flags);
    return bp::make_tuple( result, rvecs2, tvecs2 );
}

static boost::python::object computeCorrespondEpilines_c5fa9f4742dac0ce300bb37345eb1f07( ::cv::Mat const & points1, int whichImage, ::cv::Mat const & F ){
    std::vector<cv::Vec<float,3> > lines2;
    ::cv::computeCorrespondEpilines(points1, whichImage, F, lines2);
    return bp::object( lines2 );
}

static boost::python::object convertPointsHomogeneous_a80a768ed55e897cac15946457cd1696( ::cv::Mat const & src ){
    std::vector<cv::Point_<float> > dst2;
    ::cv::convertPointsHomogeneous(src, dst2);
    return bp::object( dst2 );
}

static boost::python::object convertPointsHomogeneous_d220e3269e8c59fdb5b2dc2f830579b0( ::cv::Mat const & src ){
    std::vector<cv::Point3_<float> > dst2;
    ::cv::convertPointsHomogeneous(src, dst2);
    return bp::object( dst2 );
}

static boost::python::object convexHull_42e8e723b1326dae78cb20a5c349e4e6( ::cv::Mat const & points, bool clockwise=false ){
    std::vector<cv::Point_<float> > hull2;
    ::cv::convexHull(points, hull2, clockwise);
    return bp::object( hull2 );
}

static boost::python::object convexHull_bf35caecb3465c45234b484233937f99( ::cv::Mat const & points, bool clockwise=false ){
    std::vector<cv::Point_<int> > hull2;
    ::cv::convexHull(points, hull2, clockwise);
    return bp::object( hull2 );
}

static boost::python::object convexHull_a7bf196b869588f11c69529c43975a42( ::cv::Mat const & points, bool clockwise=false ){
    std::vector<int> hull2;
    ::cv::convexHull(points, hull2, clockwise);
    return bp::object( hull2 );
}

static boost::python::tuple findChessboardCorners_dbf15a4ace0e613206118382aa1793ea( ::cv::Mat const & image, ::cv::Size patternSize, int flags=3 ){
    std::vector<cv::Point_<float> > corners2;
    bool result = ::cv::findChessboardCorners(image, patternSize, corners2, flags);
    return bp::make_tuple( result, corners2 );
}

static boost::python::object findContours_664763de08e36b95bc7d4fcebc9ccbf7( ::cv::Mat & image, int mode, int method, ::cv::Point offset=cv::Point_<int>() ){
    std::vector<std::vector<cv::Point_<int> > > contours2;
    ::cv::findContours(image, contours2, mode, method, offset);
    return bp::object( contours2 );
}

static boost::python::tuple findContours_369c42510a246d95804d68f7fdfbd8aa( ::cv::Mat & image, int mode, int method, ::cv::Point offset=cv::Point_<int>() ){
    std::vector<std::vector<cv::Point_<int> > > contours2;
    std::vector<cv::Vec<int,4> > hierarchy2;
    ::cv::findContours(image, contours2, hierarchy2, mode, method, offset);
    return bp::make_tuple( contours2, hierarchy2 );
}

static boost::python::tuple findFundamentalMat_4b8947da99452ee36abb2b044e941f4a( ::cv::Mat const & points1, ::cv::Mat const & points2, int method=int(::cv::FM_RANSAC), double param1=3.0e+0, double param2=9.89999999999999991118215802998747676610946655273e-1 ){
    std::vector<unsigned char> mask2;
    cv::Mat result = ::cv::findFundamentalMat(points1, points2, mask2, method, param1, param2);
    return bp::make_tuple( result, mask2 );
}

static boost::python::tuple findHomography_43999ba4bb258d7c74f144c8915f1665( ::cv::Mat const & srcPoints, ::cv::Mat const & dstPoints, int method=0, double ransacReprojThreshold=0 ){
    std::vector<unsigned char> mask2;
    cv::Mat result = ::cv::findHomography(srcPoints, dstPoints, mask2, method, ransacReprojThreshold);
    return bp::make_tuple( result, mask2 );
}

static boost::python::tuple floodFill_a833ccdf7b45572779d5c63d9adc2b15( ::cv::Mat & image, ::cv::Mat & mask, ::cv::Point seedPoint, ::cv::Scalar newVal, ::cv::Scalar loDiff=cv::Scalar_<double>(), ::cv::Scalar upDiff=cv::Scalar_<double>(), int flags=4 ){
    cv::Rect_<int> rect2;
    int result = ::cv::floodFill(image, mask, seedPoint, newVal, &rect2, loDiff, upDiff, flags);
    return bp::make_tuple( result, rect2 );
}

static boost::python::tuple floodFill_75a8a8f3e3e22b4d281bb304a7881151( ::cv::Mat & image, ::cv::Point seedPoint, ::cv::Scalar newVal, ::cv::Scalar loDiff=cv::Scalar_<double>(), ::cv::Scalar upDiff=cv::Scalar_<double>(), int flags=4 ){
    cv::Rect_<int> rect2;
    int result = ::cv::floodFill(image, seedPoint, newVal, &rect2, loDiff, upDiff, flags);
    return bp::make_tuple( result, rect2 );
}

static boost::python::object getAffineTransform_aa493630c3e4efe1ff49141fe5060922( std::vector<cv::Point_<float> > const & src, std::vector<cv::Point_<float> > const & dst ){
    cv::Mat result = ::cv::getAffineTransform((::cv::Point2f const *)(&src[0]), (::cv::Point2f const *)(&dst[0]));
    return bp::object( result );
}

static boost::python::tuple getOptimalNewCameraMatrix_e98b8ab28b52edfb3a210046fcf0527e( ::cv::Mat const & cameraMatrix, ::cv::Mat const & distCoeffs, ::cv::Size imageSize, double alpha, ::cv::Size newImgSize=cv::Size_<int>() ){
    cv::Rect_<int> validPixROI2;
    cv::Mat result = ::cv::getOptimalNewCameraMatrix(cameraMatrix, distCoeffs, imageSize, alpha, newImgSize, &validPixROI2);
    return bp::make_tuple( result, validPixROI2 );
}

static boost::python::object getPerspectiveTransform_c06a0392152cb20f6b57ae1ff2ac2c11( std::vector<cv::Point_<float> > const & src, std::vector<cv::Point_<float> > const & dst ){
    cv::Mat result = ::cv::getPerspectiveTransform((::cv::Point2f const *)(&src[0]), (::cv::Point2f const *)(&dst[0]));
    return bp::object( result );
}

static boost::python::object goodFeaturesToTrack_a887e3eb7b667339b1ac0c1a02f5735c( ::cv::Mat const & image, int maxCorners, double qualityLevel, double minDistance, ::cv::Mat const & mask=cv::Mat(), int blockSize=3, bool useHarrisDetector=false, double k=4.00000000000000008326672684688674053177237510681e-2 ){
    std::vector<cv::Point_<float> > corners2;
    ::cv::goodFeaturesToTrack(image, corners2, maxCorners, qualityLevel, minDistance, mask, blockSize, useHarrisDetector, k);
    return bp::object( corners2 );
}

static boost::python::tuple minEnclosingCircle_04c547ead09a6b2caad74e0f21cc5a6c( ::cv::Mat const & points ){
    cv::Point_<float> center2;
    float radius2;
    ::cv::minEnclosingCircle(points, center2, radius2);
    return bp::make_tuple( center2, radius2 );
}

static boost::python::object projectPoints_c3cbd5f3e0c4a976b617302062632da4( ::cv::Mat const & objectPoints, ::cv::Mat const & rvec, ::cv::Mat const & tvec, ::cv::Mat const & cameraMatrix, ::cv::Mat const & distCoeffs, ::cv::Mat & dpdrot, ::cv::Mat & dpdt, ::cv::Mat & dpdf, ::cv::Mat & dpdc, ::cv::Mat & dpddist, double aspectRatio=0 ){
    std::vector<cv::Point_<float> > imagePoints2;
    ::cv::projectPoints(objectPoints, rvec, tvec, cameraMatrix, distCoeffs, imagePoints2, dpdrot, dpdt, dpdf, dpdc, dpddist, aspectRatio);
    return bp::object( imagePoints2 );
}

static boost::python::object projectPoints_ce9cea7b4fadb5986d2a47a4d012fac0( ::cv::Mat const & objectPoints, ::cv::Mat const & rvec, ::cv::Mat const & tvec, ::cv::Mat const & cameraMatrix, ::cv::Mat const & distCoeffs ){
    std::vector<cv::Point_<float> > imagePoints2;
    ::cv::projectPoints(objectPoints, rvec, tvec, cameraMatrix, distCoeffs, imagePoints2);
    return bp::object( imagePoints2 );
}

static boost::python::object read_19f776a07d0494421b17575379bc2106( ::cv::FileNode const & node ){
    std::vector<cv::KeyPoint> keypoints2;
    ::cv::read(node, keypoints2);
    return bp::object( keypoints2 );
}

static boost::python::object read_70c5e2668ef6bb953f654143837a7095( ::cv::FileNode const & node, ::cv::SparseMat const & default_mat=cv::SparseMat() ){
    cv::SparseMat mat2;
    ::cv::read(node, mat2, default_mat);
    return bp::object( mat2 );
}

static boost::python::object read_fcf3602693271e7c8a4e15ff65aede4c( ::cv::FileNode const & node, ::cv::MatND const & default_mat=cv::MatND() ){
    cv::MatND mat2;
    ::cv::read(node, mat2, default_mat);
    return bp::object( mat2 );
}

static boost::python::object read_fd962997898e5b5f59cbef9efc942bcd( ::cv::FileNode const & node, ::cv::Mat const & default_mat=cv::Mat() ){
    cv::Mat mat2;
    ::cv::read(node, mat2, default_mat);
    return bp::object( mat2 );
}

static boost::python::object read_31e582223a7f98972af6d67b7558569e( ::cv::FileNode const & node, ::std::string const & default_value ){
    std::string value2;
    ::cv::read(node, value2, default_value);
    return bp::object( value2 );
}

static boost::python::object read_9a054275260bdb7b0741c9b9e8cf5aae( ::cv::FileNode const & node, double default_value ){
    double value2;
    ::cv::read(node, value2, default_value);
    return bp::object( value2 );
}

static boost::python::object read_9b06f36c44aa0d63d7f9f36cebc8d25f( ::cv::FileNode const & node, float default_value ){
    float value2;
    ::cv::read(node, value2, default_value);
    return bp::object( value2 );
}

static boost::python::object read_29c2b389d482b9f6d13cfbe5d7264926( ::cv::FileNode const & node, int default_value ){
    int value2;
    ::cv::read(node, value2, default_value);
    return bp::object( value2 );
}

static boost::python::object read_62eac78db6563e1e714f1e282bf790db( ::cv::FileNode const & node, short int default_value ){
    short int value2;
    ::cv::read(node, value2, default_value);
    return bp::object( value2 );
}

static boost::python::object read_81b0a1f4d595a311c77148001bd0046d( ::cv::FileNode const & node, ::ushort default_value ){
    short unsigned int value2;
    ::cv::read(node, value2, default_value);
    return bp::object( value2 );
}

static boost::python::object read_b68923bb48bf8de904fed0f0570414f5( ::cv::FileNode const & node, ::schar default_value ){
    signed char value2;
    ::cv::read(node, value2, default_value);
    return bp::object( value2 );
}

static boost::python::object read_e3dbdb6033985682cd13b98ac06df84e( ::cv::FileNode const & node, ::uchar default_value ){
    unsigned char value2;
    ::cv::read(node, value2, default_value);
    return bp::object( value2 );
}

static boost::python::object read_2ba57a356ec17a70685f21fbad5a9438( ::cv::FileNode const & node, bool default_value ){
    bool value2;
    ::cv::read(node, value2, default_value);
    return bp::object( value2 );
}

static boost::python::tuple stereoRectify_82767028a891c6d71aa41b85e724aef7( ::cv::Mat const & cameraMatrix1, ::cv::Mat const & distCoeffs1, ::cv::Mat const & cameraMatrix2, ::cv::Mat const & distCoeffs2, ::cv::Size imageSize, ::cv::Mat const & R, ::cv::Mat const & T, ::cv::Mat & R1, ::cv::Mat & R2, ::cv::Mat & P1, ::cv::Mat & P2, ::cv::Mat & Q, double alpha, ::cv::Size newImageSize=cv::Size_<int>(), int flags=int(::cv::CALIB_ZERO_DISPARITY) ){
    cv::Rect_<int> validPixROI12;
    cv::Rect_<int> validPixROI22;
    ::cv::stereoRectify(cameraMatrix1, distCoeffs1, cameraMatrix2, distCoeffs2, imageSize, R, T, R1, R2, P1, P2, Q, alpha, newImageSize, &validPixROI12, &validPixROI22, flags);
    return bp::make_tuple( validPixROI12, validPixROI22 );
}

static boost::python::object undistortPoints_e5fdbe55500ffb118c2a9845da49f34b( ::cv::Mat const & src, ::cv::Mat const & cameraMatrix, ::cv::Mat const & distCoeffs, ::cv::Mat const & R=cv::Mat(), ::cv::Mat const & P=cv::Mat() ){
    std::vector<cv::Point_<float> > dst2;
    ::cv::undistortPoints(src, dst2, cameraMatrix, distCoeffs, R, P);
    return bp::object( dst2 );
}

BOOST_PYTHON_MODULE(cv_hpp_ext){
    { //::cv::HoughCircles
    
        typedef boost::python::object ( *HoughCircles_function_type )( cv::Mat const &,int,double,double,double,double,int,int );
        
        bp::def( 
            "HoughCircles"
            , HoughCircles_function_type( &HoughCircles_ea2999473356200d9d2fc8b7258555b0 )
            , ( bp::arg("image"), bp::arg("method"), bp::arg("dp"), bp::arg("minDist"), bp::arg("param1")=100, bp::arg("param2")=100, bp::arg("minRadius")=(int)(0), bp::arg("maxRadius")=(int)(0) )
            , "\nArgument 'circles':"\
    "\n    C++ type: ::std::vector< cv::Vec<float, 3> > &"\
    "\n    Python type: vector_Vec3f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    circles" );
    
    }

    { //::cv::HoughLines
    
        typedef boost::python::object ( *HoughLines_function_type )( cv::Mat const &,double,double,int,double,double );
        
        bp::def( 
            "HoughLines"
            , HoughLines_function_type( &HoughLines_deaa796a20e753a0b781de4a4d81ba3d )
            , ( bp::arg("image"), bp::arg("rho"), bp::arg("theta"), bp::arg("threshold"), bp::arg("srn")=0, bp::arg("stn")=0 )
            , "\nArgument 'lines':"\
    "\n    C++ type: ::std::vector< cv::Vec<float, 2> > &"\
    "\n    Python type: vector_Vec2f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    lines" );
    
    }

    { //::cv::HoughLinesP
    
        typedef boost::python::object ( *HoughLinesP_function_type )( cv::Mat &,double,double,int,double,double );
        
        bp::def( 
            "HoughLinesP"
            , HoughLinesP_function_type( &HoughLinesP_7e83e90590dfee49ad9ee8d704d1cfcb )
            , ( bp::arg("image"), bp::arg("rho"), bp::arg("theta"), bp::arg("threshold"), bp::arg("minLineLength")=0, bp::arg("maxLineGap")=0 )
            , "\nArgument 'lines':"\
    "\n    C++ type: ::std::vector< cv::Vec<int, 4> > &"\
    "\n    Python type: vector_Vec4i"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    lines" );
    
    }

    { //::cv::HuMoments
    
        typedef boost::python::object ( *HuMoments_function_type )( cv::Moments const & );
        
        bp::def( 
            "HuMoments"
            , HuMoments_function_type( &HuMoments_646f4ee3824db566d9124eee2bb204ab )
            , ( bp::arg("moments") ) );
    
    }

    { //::cv::approxPolyDP
    
        typedef boost::python::object ( *approxPolyDP_float32_function_type )( cv::Mat const &,double,bool );
        
        bp::def( 
            "approxPolyDP_float32"
            , approxPolyDP_float32_function_type( &approxPolyDP_6246fabc9452f087130300d2a52e2a7d )
            , ( bp::arg("curve"), bp::arg("epsilon"), bp::arg("closed") )
            , "\nWrapped function:"
    "\n    approxPolyDP"
    "\nArgument 'approxCurve':"\
    "\n    C++ type: ::std::vector< cv::Point_<float> > &"\
    "\n    Python type: vector_Point2f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    approxCurve" );
    
    }

    { //::cv::approxPolyDP
    
        typedef boost::python::object ( *approxPolyDP_int_function_type )( cv::Mat const &,double,bool );
        
        bp::def( 
            "approxPolyDP_int"
            , approxPolyDP_int_function_type( &approxPolyDP_d6c85380d14cce99fc92c414781ada55 )
            , ( bp::arg("curve"), bp::arg("epsilon"), bp::arg("closed") )
            , "\nWrapped function:"
    "\n    approxPolyDP"
    "\nArgument 'approxCurve':"\
    "\n    C++ type: ::std::vector< cv::Point_<int> > &"\
    "\n    Python type: vector_Point2i"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    approxCurve" );
    
    }

    { //::cv::calcBackProject
    
        typedef void ( *calcBackProject_function_type )( std::vector<cv::Mat> const &,std::vector<int> const &,cv::SparseMat const &,cv::Mat &,std::vector<std::vector<float> > const &,double,bool );
        
        bp::def( 
            "calcBackProject"
            , calcBackProject_function_type( &calcBackProject_fe6cdc6fffc26e8d864a094a2b14971b )
            , ( bp::arg("images"), bp::arg("channels"), bp::arg("hist"), bp::arg("backProject"), bp::arg("ranges"), bp::arg("scale")=1, bp::arg("uniform")=(bool)(true) )
            , "\nArgument 'images':"\
    "\n    C++ type: ::cv::Mat const *"\
    "\n    Python type: vector_Mat"\
    "\nArgument 'nimages':"\
    "\n    Dependent argument: omitted from input. Its value is derived from "\
    "\n    argument 'images'."\
    "\nArgument 'channels':"\
    "\n    C++ type: int const *"\
    "\n    Python type: vector_int"\
    "\nArgument 'ranges':"\
    "\n    C++ type: float const * *"\
    "\n    Python type: vector_vector_float32" );
    
    }

    { //::cv::calcBackProject
    
        typedef void ( *calcBackProject_function_type )( std::vector<cv::Mat> const &,std::vector<int> const &,cv::MatND const &,cv::Mat &,std::vector<std::vector<float> > const &,double,bool );
        
        bp::def( 
            "calcBackProject"
            , calcBackProject_function_type( &calcBackProject_84908d355b9d9fa6b6e1e0115efb65f8 )
            , ( bp::arg("images"), bp::arg("channels"), bp::arg("hist"), bp::arg("backProject"), bp::arg("ranges"), bp::arg("scale")=1, bp::arg("uniform")=(bool)(true) )
            , "\nArgument 'images':"\
    "\n    C++ type: ::cv::Mat const *"\
    "\n    Python type: vector_Mat"\
    "\nArgument 'nimages':"\
    "\n    Dependent argument: omitted from input. Its value is derived from "\
    "\n    argument 'images'."\
    "\nArgument 'channels':"\
    "\n    C++ type: int const *"\
    "\n    Python type: vector_int"\
    "\nArgument 'ranges':"\
    "\n    C++ type: float const * *"\
    "\n    Python type: vector_vector_float32" );
    
    }

    { //::cv::calcHist
    
        typedef void ( *calcHist_function_type )( std::vector<cv::Mat> const &,std::vector<int> const &,cv::Mat const &,cv::SparseMat &,std::vector<int> const &,std::vector<std::vector<float> > const &,bool,bool );
        
        bp::def( 
            "calcHist"
            , calcHist_function_type( &calcHist_8e436c4da97e1e09468541e1bed60274 )
            , ( bp::arg("images"), bp::arg("channels"), bp::arg("mask"), bp::arg("hist"), bp::arg("histSize"), bp::arg("ranges"), bp::arg("uniform")=(bool)(true), bp::arg("accumulate")=(bool)(false) )
            , "\nArgument 'images':"\
    "\n    C++ type: ::cv::Mat const *"\
    "\n    Python type: vector_Mat"\
    "\nArgument 'nimages':"\
    "\n    Dependent argument: omitted from input. Its value is derived from "\
    "\n    argument 'images'."\
    "\nArgument 'channels':"\
    "\n    C++ type: int const *"\
    "\n    Python type: vector_int"\
    "\nArgument 'dims':"\
    "\n    Dependent argument: omitted from input. Its value is derived from "\
    "\n    argument 'histSize'."\
    "\nArgument 'histSize':"\
    "\n    C++ type: int const *"\
    "\n    Python type: vector_int"\
    "\nArgument 'ranges':"\
    "\n    C++ type: float const * *"\
    "\n    Python type: vector_vector_float32" );
    
    }

    { //::cv::calcHist
    
        typedef void ( *calcHist_function_type )( std::vector<cv::Mat> const &,std::vector<int> const &,cv::Mat const &,cv::MatND &,std::vector<int> const &,std::vector<std::vector<float> > const &,bool,bool );
        
        bp::def( 
            "calcHist"
            , calcHist_function_type( &calcHist_a4cce9bdd9689d0fb0adf901f467bfa0 )
            , ( bp::arg("images"), bp::arg("channels"), bp::arg("mask"), bp::arg("hist"), bp::arg("histSize"), bp::arg("ranges"), bp::arg("uniform")=(bool)(true), bp::arg("accumulate")=(bool)(false) )
            , "\nArgument 'images':"\
    "\n    C++ type: ::cv::Mat const *"\
    "\n    Python type: vector_Mat"\
    "\nArgument 'nimages':"\
    "\n    Dependent argument: omitted from input. Its value is derived from "\
    "\n    argument 'images'."\
    "\nArgument 'channels':"\
    "\n    C++ type: int const *"\
    "\n    Python type: vector_int"\
    "\nArgument 'dims':"\
    "\n    Dependent argument: omitted from input. Its value is derived from "\
    "\n    argument 'histSize'."\
    "\nArgument 'histSize':"\
    "\n    C++ type: int const *"\
    "\n    Python type: vector_int"\
    "\nArgument 'ranges':"\
    "\n    C++ type: float const * *"\
    "\n    Python type: vector_vector_float32" );
    
    }

    { //::cv::calibrateCamera
    
        typedef boost::python::tuple ( *calibrateCamera_function_type )( std::vector<std::vector<cv::Point3_<float> > > const &,std::vector<std::vector<cv::Point_<float> > > const &,::cv::Size,cv::Mat &,cv::Mat &,int );
        
        bp::def( 
            "calibrateCamera"
            , calibrateCamera_function_type( &calibrateCamera_e3c243276629b1246626096d8ff70485 )
            , ( bp::arg("objectPoints"), bp::arg("imagePoints"), bp::arg("imageSize"), bp::arg("cameraMatrix"), bp::arg("distCoeffs"), bp::arg("flags")=(int)(0) )
            , "\nArgument 'rvecs':"\
    "\n    C++ type: ::std::vector< cv::Mat > &"\
    "\n    Python type: vector_Mat"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nArgument 'tvecs':"\
    "\n    C++ type: ::std::vector< cv::Mat > &"\
    "\n    Python type: vector_Mat"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    ((float64), rvecs, tvecs)" );
    
    }

    { //::cv::computeCorrespondEpilines
    
        typedef boost::python::object ( *computeCorrespondEpilines_function_type )( cv::Mat const &,int,cv::Mat const & );
        
        bp::def( 
            "computeCorrespondEpilines"
            , computeCorrespondEpilines_function_type( &computeCorrespondEpilines_c5fa9f4742dac0ce300bb37345eb1f07 )
            , ( bp::arg("points1"), bp::arg("whichImage"), bp::arg("F") )
            , "\nArgument 'lines':"\
    "\n    C++ type: ::std::vector< cv::Vec<float, 3> > &"\
    "\n    Python type: vector_Vec3f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    lines" );
    
    }

    { //::cv::convertPointsHomogeneous
    
        typedef boost::python::object ( *convertPointsHomogeneous2D_function_type )( cv::Mat const & );
        
        bp::def( 
            "convertPointsHomogeneous2D"
            , convertPointsHomogeneous2D_function_type( &convertPointsHomogeneous_a80a768ed55e897cac15946457cd1696 )
            , ( bp::arg("src") )
            , "\nWrapped function:"
    "\n    convertPointsHomogeneous"
    "\nArgument 'dst':"\
    "\n    C++ type: ::std::vector< cv::Point_<float> > &"\
    "\n    Python type: vector_Point2f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    dst" );
    
    }

    { //::cv::convertPointsHomogeneous
    
        typedef boost::python::object ( *convertPointsHomogeneous3D_function_type )( cv::Mat const & );
        
        bp::def( 
            "convertPointsHomogeneous3D"
            , convertPointsHomogeneous3D_function_type( &convertPointsHomogeneous_d220e3269e8c59fdb5b2dc2f830579b0 )
            , ( bp::arg("src") )
            , "\nWrapped function:"
    "\n    convertPointsHomogeneous"
    "\nArgument 'dst':"\
    "\n    C++ type: ::std::vector< cv::Point3_<float> > &"\
    "\n    Python type: vector_Point3f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    dst" );
    
    }

    { //::cv::convexHull
    
        typedef boost::python::object ( *convexHull_float32_function_type )( cv::Mat const &,bool );
        
        bp::def( 
            "convexHull_float32"
            , convexHull_float32_function_type( &convexHull_42e8e723b1326dae78cb20a5c349e4e6 )
            , ( bp::arg("points"), bp::arg("clockwise")=(bool)(false) )
            , "\nWrapped function:"
    "\n    convexHull"
    "\nArgument 'hull':"\
    "\n    C++ type: ::std::vector< cv::Point_<float> > &"\
    "\n    Python type: vector_Point2f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    hull" );
    
    }

    { //::cv::convexHull
    
        typedef boost::python::object ( *convexHull_int_function_type )( cv::Mat const &,bool );
        
        bp::def( 
            "convexHull_int"
            , convexHull_int_function_type( &convexHull_bf35caecb3465c45234b484233937f99 )
            , ( bp::arg("points"), bp::arg("clockwise")=(bool)(false) )
            , "\nWrapped function:"
    "\n    convexHull"
    "\nArgument 'hull':"\
    "\n    C++ type: ::std::vector< cv::Point_<int> > &"\
    "\n    Python type: vector_Point2i"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    hull" );
    
    }

    { //::cv::convexHull
    
        typedef boost::python::object ( *convexHullIdx_function_type )( cv::Mat const &,bool );
        
        bp::def( 
            "convexHullIdx"
            , convexHullIdx_function_type( &convexHull_a7bf196b869588f11c69529c43975a42 )
            , ( bp::arg("points"), bp::arg("clockwise")=(bool)(false) )
            , "\nWrapped function:"
    "\n    convexHull"
    "\nArgument 'hull':"\
    "\n    C++ type: ::std::vector< int > &"\
    "\n    Python type: vector_int"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    hull" );
    
    }

    { //::cv::findChessboardCorners
    
        typedef boost::python::tuple ( *findChessboardCorners_function_type )( cv::Mat const &,::cv::Size,int );
        
        bp::def( 
            "findChessboardCorners"
            , findChessboardCorners_function_type( &findChessboardCorners_dbf15a4ace0e613206118382aa1793ea )
            , ( bp::arg("image"), bp::arg("patternSize"), bp::arg("flags")=(int)(3) )
            , "\nArgument 'corners':"\
    "\n    C++ type: ::std::vector< cv::Point_<float> > &"\
    "\n    Python type: vector_Point2f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    ((bool), corners)" );
    
    }

    { //::cv::findContours
    
        typedef boost::python::object ( *findContours_function_type )( cv::Mat &,int,int,::cv::Point );
        
        bp::def( 
            "findContours"
            , findContours_function_type( &findContours_664763de08e36b95bc7d4fcebc9ccbf7 )
            , ( bp::arg("image"), bp::arg("mode"), bp::arg("method"), bp::arg("offset")=cv::Point_<int>() )
            , "\nArgument 'contours':"\
    "\n    C++ type: ::std::vector< std::vector< cv::Point_<int> > > &"\
    "\n    Python type: vector_vector_Point2i"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    contours" );
    
    }

    { //::cv::findContours
    
        typedef boost::python::tuple ( *findContours_function_type )( cv::Mat &,int,int,::cv::Point );
        
        bp::def( 
            "findContours"
            , findContours_function_type( &findContours_369c42510a246d95804d68f7fdfbd8aa )
            , ( bp::arg("image"), bp::arg("mode"), bp::arg("method"), bp::arg("offset")=cv::Point_<int>() )
            , "\nArgument 'contours':"\
    "\n    C++ type: ::std::vector< std::vector< cv::Point_<int> > > &"\
    "\n    Python type: vector_vector_Point2i"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nArgument 'hierarchy':"\
    "\n    C++ type: ::std::vector< cv::Vec<int, 4> > &"\
    "\n    Python type: vector_Vec4i"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    (contours, hierarchy)" );
    
    }

    { //::cv::findFundamentalMat
    
        typedef boost::python::tuple ( *findFundamentalMat2_function_type )( cv::Mat const &,cv::Mat const &,int,double,double );
        
        bp::def( 
            "findFundamentalMat2"
            , findFundamentalMat2_function_type( &findFundamentalMat_4b8947da99452ee36abb2b044e941f4a )
            , ( bp::arg("points1"), bp::arg("points2"), bp::arg("method")=int(::cv::FM_RANSAC), bp::arg("param1")=3.0e+0, bp::arg("param2")=9.89999999999999991118215802998747676610946655273e-1 )
            , "\nWrapped function:"
    "\n    findFundamentalMat"
    "\nArgument 'mask':"\
    "\n    C++ type: ::std::vector< unsigned char > &"\
    "\n    Python type: vector_uint8"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    ((Mat), mask)" );
    
    }

    { //::cv::findHomography
    
        typedef boost::python::tuple ( *findHomography2_function_type )( cv::Mat const &,cv::Mat const &,int,double );
        
        bp::def( 
            "findHomography2"
            , findHomography2_function_type( &findHomography_43999ba4bb258d7c74f144c8915f1665 )
            , ( bp::arg("srcPoints"), bp::arg("dstPoints"), bp::arg("method")=(int)(0), bp::arg("ransacReprojThreshold")=0 )
            , "\nWrapped function:"
    "\n    findHomography"
    "\nArgument 'mask':"\
    "\n    C++ type: ::std::vector< unsigned char > &"\
    "\n    Python type: vector_uint8"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    ((Mat), mask)" );
    
    }

    { //::cv::floodFill
    
        typedef boost::python::tuple ( *floodFill_function_type )( cv::Mat &,cv::Mat &,::cv::Point,::cv::Scalar,::cv::Scalar,::cv::Scalar,int );
        
        bp::def( 
            "floodFill"
            , floodFill_function_type( &floodFill_a833ccdf7b45572779d5c63d9adc2b15 )
            , ( bp::arg("image"), bp::arg("mask"), bp::arg("seedPoint"), bp::arg("newVal"), bp::arg("loDiff")=cv::Scalar_<double>(), bp::arg("upDiff")=cv::Scalar_<double>(), bp::arg("flags")=(int)(4) )
            , "\nArgument 'rect':"\
    "\n    C++ type: ::cv::Rect *"\
    "\n    Python type: Rect"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    ((int), rect)" );
    
    }

    { //::cv::floodFill
    
        typedef boost::python::tuple ( *floodFill_function_type )( cv::Mat &,::cv::Point,::cv::Scalar,::cv::Scalar,::cv::Scalar,int );
        
        bp::def( 
            "floodFill"
            , floodFill_function_type( &floodFill_75a8a8f3e3e22b4d281bb304a7881151 )
            , ( bp::arg("image"), bp::arg("seedPoint"), bp::arg("newVal"), bp::arg("loDiff")=cv::Scalar_<double>(), bp::arg("upDiff")=cv::Scalar_<double>(), bp::arg("flags")=(int)(4) )
            , "\nArgument 'rect':"\
    "\n    C++ type: ::cv::Rect *"\
    "\n    Python type: Rect"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    ((int), rect)" );
    
    }

    { //::cv::getAffineTransform
    
        typedef boost::python::object ( *getAffineTransform_function_type )( std::vector<cv::Point_<float> > const &,std::vector<cv::Point_<float> > const & );
        
        bp::def( 
            "getAffineTransform"
            , getAffineTransform_function_type( &getAffineTransform_aa493630c3e4efe1ff49141fe5060922 )
            , ( bp::arg("src"), bp::arg("dst") )
            , "\nArgument 'src':"\
    "\n    C++ type: ::cv::Point2f const *"\
    "\n    Python type: vector_Point2f"\
    "\nArgument 'dst':"\
    "\n    C++ type: ::cv::Point2f const *"\
    "\n    Python type: vector_Point2f" );
    
    }

    { //::cv::getOptimalNewCameraMatrix
    
        typedef boost::python::tuple ( *getOptimalNewCameraMatrix_function_type )( cv::Mat const &,cv::Mat const &,::cv::Size,double,::cv::Size );
        
        bp::def( 
            "getOptimalNewCameraMatrix"
            , getOptimalNewCameraMatrix_function_type( &getOptimalNewCameraMatrix_e98b8ab28b52edfb3a210046fcf0527e )
            , ( bp::arg("cameraMatrix"), bp::arg("distCoeffs"), bp::arg("imageSize"), bp::arg("alpha"), bp::arg("newImgSize")=cv::Size_<int>() )
            , "\nArgument 'validPixROI':"\
    "\n    C++ type: ::cv::Rect *"\
    "\n    Python type: Rect"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    ((Mat), validPixROI)" );
    
    }

    { //::cv::getPerspectiveTransform
    
        typedef boost::python::object ( *getPerspectiveTransform_function_type )( std::vector<cv::Point_<float> > const &,std::vector<cv::Point_<float> > const & );
        
        bp::def( 
            "getPerspectiveTransform"
            , getPerspectiveTransform_function_type( &getPerspectiveTransform_c06a0392152cb20f6b57ae1ff2ac2c11 )
            , ( bp::arg("src"), bp::arg("dst") )
            , "\nArgument 'src':"\
    "\n    C++ type: ::cv::Point2f const *"\
    "\n    Python type: vector_Point2f"\
    "\nArgument 'dst':"\
    "\n    C++ type: ::cv::Point2f const *"\
    "\n    Python type: vector_Point2f" );
    
    }

    { //::cv::goodFeaturesToTrack
    
        typedef boost::python::object ( *goodFeaturesToTrack_function_type )( cv::Mat const &,int,double,double,cv::Mat const &,int,bool,double );
        
        bp::def( 
            "goodFeaturesToTrack"
            , goodFeaturesToTrack_function_type( &goodFeaturesToTrack_a887e3eb7b667339b1ac0c1a02f5735c )
            , ( bp::arg("image"), bp::arg("maxCorners"), bp::arg("qualityLevel"), bp::arg("minDistance"), bp::arg("mask")=cv::Mat(), bp::arg("blockSize")=(int)(3), bp::arg("useHarrisDetector")=(bool)(false), bp::arg("k")=4.00000000000000008326672684688674053177237510681e-2 )
            , "\nArgument 'corners':"\
    "\n    C++ type: ::std::vector< cv::Point_<float> > &"\
    "\n    Python type: vector_Point2f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    corners" );
    
    }

    { //::cv::minEnclosingCircle
    
        typedef boost::python::tuple ( *minEnclosingCircle_function_type )( cv::Mat const & );
        
        bp::def( 
            "minEnclosingCircle"
            , minEnclosingCircle_function_type( &minEnclosingCircle_04c547ead09a6b2caad74e0f21cc5a6c )
            , ( bp::arg("points") )
            , "\nArgument 'center':"\
    "\n    C++ type: ::cv::Point2f &"\
    "\n    Python type: Point2f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nArgument 'radius':"\
    "\n    C++ type: float &"\
    "\n    Python type: float32"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    (center, radius)" );
    
    }

    { //::cv::projectPoints
    
        typedef boost::python::object ( *projectPoints2_function_type )( cv::Mat const &,cv::Mat const &,cv::Mat const &,cv::Mat const &,cv::Mat const &,cv::Mat &,cv::Mat &,cv::Mat &,cv::Mat &,cv::Mat &,double );
        
        bp::def( 
            "projectPoints2"
            , projectPoints2_function_type( &projectPoints_c3cbd5f3e0c4a976b617302062632da4 )
            , ( bp::arg("objectPoints"), bp::arg("rvec"), bp::arg("tvec"), bp::arg("cameraMatrix"), bp::arg("distCoeffs"), bp::arg("dpdrot"), bp::arg("dpdt"), bp::arg("dpdf"), bp::arg("dpdc"), bp::arg("dpddist"), bp::arg("aspectRatio")=0 )
            , "\nWrapped function:"
    "\n    projectPoints"
    "\nArgument 'imagePoints':"\
    "\n    C++ type: ::std::vector< cv::Point_<float> > &"\
    "\n    Python type: vector_Point2f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    imagePoints" );
    
    }

    { //::cv::projectPoints
    
        typedef boost::python::object ( *projectPoints_function_type )( cv::Mat const &,cv::Mat const &,cv::Mat const &,cv::Mat const &,cv::Mat const & );
        
        bp::def( 
            "projectPoints"
            , projectPoints_function_type( &projectPoints_ce9cea7b4fadb5986d2a47a4d012fac0 )
            , ( bp::arg("objectPoints"), bp::arg("rvec"), bp::arg("tvec"), bp::arg("cameraMatrix"), bp::arg("distCoeffs") )
            , "\nArgument 'imagePoints':"\
    "\n    C++ type: ::std::vector< cv::Point_<float> > &"\
    "\n    Python type: vector_Point2f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    imagePoints" );
    
    }

    { //::cv::read
    
        typedef boost::python::object ( *read_list_of_KeyPoint_function_type )( cv::FileNode const & );
        
        bp::def( 
            "read_list_of_KeyPoint"
            , read_list_of_KeyPoint_function_type( &read_19f776a07d0494421b17575379bc2106 )
            , ( bp::arg("node") )
            , "\nWrapped function:"
    "\n    read"
    "\nArgument 'keypoints':"\
    "\n    C++ type: ::std::vector< cv::KeyPoint > &"\
    "\n    Python type: vector_KeyPoint"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    keypoints" );
    
    }

    { //::cv::read
    
        typedef boost::python::object ( *read_SparseMat_function_type )( cv::FileNode const &,cv::SparseMat const & );
        
        bp::def( 
            "read_SparseMat"
            , read_SparseMat_function_type( &read_70c5e2668ef6bb953f654143837a7095 )
            , ( bp::arg("node"), bp::arg("default_mat")=cv::SparseMat() )
            , "\nWrapped function:"
    "\n    read"
    "\nArgument 'mat':"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    mat" );
    
    }

    { //::cv::read
    
        typedef boost::python::object ( *read_MatND_function_type )( cv::FileNode const &,cv::MatND const & );
        
        bp::def( 
            "read_MatND"
            , read_MatND_function_type( &read_fcf3602693271e7c8a4e15ff65aede4c )
            , ( bp::arg("node"), bp::arg("default_mat")=cv::MatND() )
            , "\nWrapped function:"
    "\n    read"
    "\nArgument 'mat':"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    mat" );
    
    }

    { //::cv::read
    
        typedef boost::python::object ( *read_Mat_function_type )( cv::FileNode const &,cv::Mat const & );
        
        bp::def( 
            "read_Mat"
            , read_Mat_function_type( &read_fd962997898e5b5f59cbef9efc942bcd )
            , ( bp::arg("node"), bp::arg("default_mat")=cv::Mat() )
            , "\nWrapped function:"
    "\n    read"
    "\nArgument 'mat':"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    mat" );
    
    }

    { //::cv::read
    
        typedef boost::python::object ( *read_str_function_type )( cv::FileNode const &,::std::string const & );
        
        bp::def( 
            "read_str"
            , read_str_function_type( &read_31e582223a7f98972af6d67b7558569e )
            , ( bp::arg("node"), bp::arg("default_value") )
            , "\nWrapped function:"
    "\n    read"
    "\nArgument 'value':"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    value" );
    
    }

    { //::cv::read
    
        typedef boost::python::object ( *read_float64_function_type )( cv::FileNode const &,double );
        
        bp::def( 
            "read_float64"
            , read_float64_function_type( &read_9a054275260bdb7b0741c9b9e8cf5aae )
            , ( bp::arg("node"), bp::arg("default_value") )
            , "\nWrapped function:"
    "\n    read"
    "\nArgument 'value':"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    value" );
    
    }

    { //::cv::read
    
        typedef boost::python::object ( *read_float32_function_type )( cv::FileNode const &,float );
        
        bp::def( 
            "read_float32"
            , read_float32_function_type( &read_9b06f36c44aa0d63d7f9f36cebc8d25f )
            , ( bp::arg("node"), bp::arg("default_value") )
            , "\nWrapped function:"
    "\n    read"
    "\nArgument 'value':"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    value" );
    
    }

    { //::cv::read
    
        typedef boost::python::object ( *read_int_function_type )( cv::FileNode const &,int );
        
        bp::def( 
            "read_int"
            , read_int_function_type( &read_29c2b389d482b9f6d13cfbe5d7264926 )
            , ( bp::arg("node"), bp::arg("default_value") )
            , "\nWrapped function:"
    "\n    read"
    "\nArgument 'value':"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    value" );
    
    }

    { //::cv::read
    
        typedef boost::python::object ( *read_int16_function_type )( cv::FileNode const &,short int );
        
        bp::def( 
            "read_int16"
            , read_int16_function_type( &read_62eac78db6563e1e714f1e282bf790db )
            , ( bp::arg("node"), bp::arg("default_value") )
            , "\nWrapped function:"
    "\n    read"
    "\nArgument 'value':"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    value" );
    
    }

    { //::cv::read
    
        typedef boost::python::object ( *read_uint16_function_type )( cv::FileNode const &,::ushort );
        
        bp::def( 
            "read_uint16"
            , read_uint16_function_type( &read_81b0a1f4d595a311c77148001bd0046d )
            , ( bp::arg("node"), bp::arg("default_value") )
            , "\nWrapped function:"
    "\n    read"
    "\nArgument 'value':"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    value" );
    
    }

    { //::cv::read
    
        typedef boost::python::object ( *read_int8_function_type )( cv::FileNode const &,::schar );
        
        bp::def( 
            "read_int8"
            , read_int8_function_type( &read_b68923bb48bf8de904fed0f0570414f5 )
            , ( bp::arg("node"), bp::arg("default_value") )
            , "\nWrapped function:"
    "\n    read"
    "\nArgument 'value':"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    value" );
    
    }

    { //::cv::read
    
        typedef boost::python::object ( *read_uint8_function_type )( cv::FileNode const &,::uchar );
        
        bp::def( 
            "read_uint8"
            , read_uint8_function_type( &read_e3dbdb6033985682cd13b98ac06df84e )
            , ( bp::arg("node"), bp::arg("default_value") )
            , "\nWrapped function:"
    "\n    read"
    "\nArgument 'value':"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    value" );
    
    }

    { //::cv::read
    
        typedef boost::python::object ( *read_bool_function_type )( cv::FileNode const &,bool );
        
        bp::def( 
            "read_bool"
            , read_bool_function_type( &read_2ba57a356ec17a70685f21fbad5a9438 )
            , ( bp::arg("node"), bp::arg("default_value") )
            , "\nWrapped function:"
    "\n    read"
    "\nArgument 'value':"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    value" );
    
    }

    { //::cv::stereoRectify
    
        typedef boost::python::tuple ( *stereoRectify2_function_type )( cv::Mat const &,cv::Mat const &,cv::Mat const &,cv::Mat const &,::cv::Size,cv::Mat const &,cv::Mat const &,cv::Mat &,cv::Mat &,cv::Mat &,cv::Mat &,cv::Mat &,double,::cv::Size,int );
        
        bp::def( 
            "stereoRectify2"
            , stereoRectify2_function_type( &stereoRectify_82767028a891c6d71aa41b85e724aef7 )
            , ( bp::arg("cameraMatrix1"), bp::arg("distCoeffs1"), bp::arg("cameraMatrix2"), bp::arg("distCoeffs2"), bp::arg("imageSize"), bp::arg("R"), bp::arg("T"), bp::arg("R1"), bp::arg("R2"), bp::arg("P1"), bp::arg("P2"), bp::arg("Q"), bp::arg("alpha"), bp::arg("newImageSize")=cv::Size_<int>(), bp::arg("flags")=int(::cv::CALIB_ZERO_DISPARITY) )
            , "\nWrapped function:"
    "\n    stereoRectify"
    "\nArgument 'validPixROI1':"\
    "\n    C++ type: ::cv::Rect *"\
    "\n    Python type: Rect"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nArgument 'validPixROI2':"\
    "\n    C++ type: ::cv::Rect *"\
    "\n    Python type: Rect"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    (validPixROI1, validPixROI2)" );
    
    }

    { //::cv::undistortPoints
    
        typedef boost::python::object ( *undistortPoints2_function_type )( cv::Mat const &,cv::Mat const &,cv::Mat const &,cv::Mat const &,cv::Mat const & );
        
        bp::def( 
            "undistortPoints2"
            , undistortPoints2_function_type( &undistortPoints_e5fdbe55500ffb118c2a9845da49f34b )
            , ( bp::arg("src"), bp::arg("cameraMatrix"), bp::arg("distCoeffs"), bp::arg("R")=cv::Mat(), bp::arg("P")=cv::Mat() )
            , "\nWrapped function:"
    "\n    undistortPoints"
    "\nArgument 'dst':"\
    "\n    C++ type: ::std::vector< cv::Point_<float> > &"\
    "\n    Python type: vector_Point2f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    dst" );
    
    }

    register_classes_1();

    register_classes_2();

    register_classes_3();

    register_global_variables();

    register_free_functions();
}

