// This file has been generated by Py++.

#include "boost/python.hpp"
#include "opencv_converters.hpp"
#include "__call_policies.pypp.hpp"
#include "__convenience.pypp.hpp"
#include "ndarray.hpp"
#include "__array_1.pypp.hpp"
#include "__ctypes_integration.pypp.hpp"
#include "cxcore_hpp_wrapper.hpp"
#include "boost/python/object.hpp"
#include "ndarray.hpp"
#include "opencv_converters.hpp"
#include "boost/python/make_function.hpp"
#include "cxcore_hpp_ext_classes_4.pypp.hpp"

namespace bp = boost::python;

static size_t Seq_int_len(cv::Seq<int> const &inst) { return inst.size(); }

static ::CvSeq * get_Seq_int_seq( cv::Seq<int> const & inst ) { return inst.seq; }

struct SparseMat_wrapper : cv::SparseMat, bp::wrapper< cv::SparseMat > {

    struct Hdr_wrapper : cv::SparseMat::Hdr, bp::wrapper< cv::SparseMat::Hdr > {
    
        Hdr_wrapper(cv::SparseMat::Hdr const & arg )
        : cv::SparseMat::Hdr( arg )
          , bp::wrapper< cv::SparseMat::Hdr >(){
            // copy constructor
            
        }
    
        static pyplusplus::containers::static_sized::array_1_t< int, 32>
        pyplusplus_size_wrapper( cv::SparseMat::Hdr & inst ){
            return pyplusplus::containers::static_sized::array_1_t< int, 32>( inst.size );
        }
    
    };

    struct Node_wrapper : cv::SparseMat::Node, bp::wrapper< cv::SparseMat::Node > {
    
        Node_wrapper(cv::SparseMat::Node const & arg )
        : cv::SparseMat::Node( arg )
          , bp::wrapper< cv::SparseMat::Node >(){
            // copy constructor
            
        }
    
        Node_wrapper()
        : cv::SparseMat::Node()
          , bp::wrapper< cv::SparseMat::Node >(){
            // null constructor
            
        }
    
        static pyplusplus::containers::static_sized::array_1_t< int, 32>
        pyplusplus_idx_wrapper( cv::SparseMat::Node & inst ){
            return pyplusplus::containers::static_sized::array_1_t< int, 32>( inst.idx );
        }
    
    };

    SparseMat_wrapper(::cv::Mat const & m, bool try1d=false )
    : cv::SparseMat( boost::ref(m), try1d )
      , bp::wrapper< cv::SparseMat >(){
        // constructor
    
    }

    SparseMat_wrapper(::cv::MatND const & m )
    : cv::SparseMat( boost::ref(m) )
      , bp::wrapper< cv::SparseMat >(){
        // constructor
    
    }

    SparseMat_wrapper( )
    : cv::SparseMat( )
      , bp::wrapper< cv::SparseMat >(){
        // null constructor
    
    }

    SparseMat_wrapper(::cv::SparseMat const & m )
    : cv::SparseMat( boost::ref(m) )
      , bp::wrapper< cv::SparseMat >(){
        // copy constructor
    
    }

    static void create( ::cv::SparseMat & inst, std::vector<int> const & _sizes, int _type ){
        inst.create((int)(_sizes.size()), (int const *)(&_sizes[0]), _type);
    }

    static boost::python::object erase_ce64effe5fbeb3e9588310d12240ddce( ::cv::SparseMat & inst, int i0, int i1 ){
        size_t hashval2;
        inst.erase(i0, i1, &hashval2);
        return bp::object( hashval2 );
    }

    static boost::python::object erase_ca8730dab3cfc35be7d8c7cfc84bf06f( ::cv::SparseMat & inst, int i0, int i1, int i2 ){
        size_t hashval2;
        inst.erase(i0, i1, i2, &hashval2);
        return bp::object( hashval2 );
    }

    static boost::python::object erase_7ee4e9a1250db62333754bd289edbba8( ::cv::SparseMat & inst, std::vector<int> const & idx ){
        size_t hashval2;
        inst.erase((int const *)(&idx[0]), &hashval2);
        return bp::object( hashval2 );
    }

    static boost::python::object hash_19477be6a05d6299f1601326adc61332( ::cv::SparseMat const & inst, std::vector<int> const & idx ){
        ::size_t result = inst.hash((int const *)(&idx[0]));
        return bp::object( result );
    }

    static cv::SparseMat::Hdr * get_hdr(cv::SparseMat const & inst ){
        return inst.hdr;
    }
    
    static void set_hdr( cv::SparseMat & inst, cv::SparseMat::Hdr * new_value ){ 
        inst.hdr = new_value;
    }

};

static boost::shared_ptr<cv::SparseMat> SparseMat__init1__(std::vector<int> const &_sizes, int _type)
{
    return boost::shared_ptr<cv::SparseMat>(new cv::SparseMat(_sizes.size(), &_sizes[0], _type));
}

static bp::object SparseMat_size(cv::SparseMat const &inst, int i = -1)
{
    if(i >= 0) return bp::object(inst.size(i));
    
    const int *sz = inst.size();
    if(!sz) return bp::object();
    
    std::vector<int> result(inst.dims());
    for(i = 0; i < inst.dims(); ++i) result[i] = sz[i];
    return bp::object(result);
}

static boost::shared_ptr<cv::SparseMat::Hdr> SparseMat_Hdr__init1__(std::vector<int> const &_sizes, int _type)
{
    return boost::shared_ptr<cv::SparseMat::Hdr>(new cv::SparseMat::Hdr(_sizes.size(), &_sizes[0], _type));
}

struct SparseMatIterator_wrapper : cv::SparseMatIterator, bp::wrapper< cv::SparseMatIterator > {

    SparseMatIterator_wrapper( )
    : cv::SparseMatIterator( )
      , bp::wrapper< cv::SparseMatIterator >(){
        // null constructor
    
    }

    SparseMatIterator_wrapper(::cv::SparseMat * _m )
    : cv::SparseMatIterator( boost::python::ptr(_m) )
      , bp::wrapper< cv::SparseMatIterator >(){
        // constructor
    
    }

    SparseMatIterator_wrapper(::cv::SparseMatIterator const & it )
    : cv::SparseMatIterator( boost::ref(it) )
      , bp::wrapper< cv::SparseMatIterator >(){
        // copy constructor
    
    }

    SparseMatIterator_wrapper const &iter() { return *this; }
    
    cv::SparseMat::Node *next()
    {
        if(!m || !ptr || !m->hdr)
        {
            PyErr_SetString(PyExc_StopIteration, "No more node.");
            throw bp::error_already_set(); 
        }
        
        cv::SparseMat::Node *result = node();
        ++(*this);
        return result;
    }

};

void register_classes_4(){

    { //::cv::Seq< int >
        typedef bp::class_< cv::Seq< int > > Seq_int_exposer_t;
        Seq_int_exposer_t Seq_int_exposer = Seq_int_exposer_t( "Seq_int", bp::init< >() );
        bp::scope Seq_int_scope( Seq_int_exposer );
        Seq_int_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Seq< int > >() );
        Seq_int_exposer.def( bp::init< CvSeq const * >(( bp::arg("_seq") )) );
        bp::implicitly_convertible< CvSeq const *, cv::Seq< int > >();
        Seq_int_exposer.def( bp::init< cv::Ptr< CvMemStorage > &, bp::optional< int > >(( bp::arg("storage"), bp::arg("headerSize")=(int)(56u) )) );
        bp::implicitly_convertible< cv::Ptr< CvMemStorage > &, cv::Seq< int > >();
        { //::cv::Seq< int >::channels
        
            typedef cv::Seq< int > exported_class_t;
            typedef int ( exported_class_t::*channels_function_type )(  ) const;
            
            Seq_int_exposer.def( 
                "channels"
                , channels_function_type( &::cv::Seq< int >::channels ) );
        
        }
        { //::cv::Seq< int >::clear
        
            typedef cv::Seq< int > exported_class_t;
            typedef void ( exported_class_t::*clear_function_type )(  ) ;
            
            Seq_int_exposer.def( 
                "clear"
                , clear_function_type( &::cv::Seq< int >::clear ) );
        
        }
        { //::cv::Seq< int >::copyTo
        
            typedef cv::Seq< int > exported_class_t;
            typedef void ( exported_class_t::*copyTo_function_type )( ::std::vector< int > &,::cv::Range const & ) const;
            
            Seq_int_exposer.def( 
                "copyTo"
                , copyTo_function_type( &::cv::Seq< int >::copyTo )
                , ( bp::arg("vec"), bp::arg("range")=cv::Range::all() ) );
        
        }
        { //::cv::Seq< int >::depth
        
            typedef cv::Seq< int > exported_class_t;
            typedef int ( exported_class_t::*depth_function_type )(  ) const;
            
            Seq_int_exposer.def( 
                "depth"
                , depth_function_type( &::cv::Seq< int >::depth ) );
        
        }
        { //::cv::Seq< int >::elemSize
        
            typedef cv::Seq< int > exported_class_t;
            typedef ::size_t ( exported_class_t::*elemSize_function_type )(  ) const;
            
            Seq_int_exposer.def( 
                "elemSize"
                , elemSize_function_type( &::cv::Seq< int >::elemSize ) );
        
        }
        { //::cv::Seq< int >::empty
        
            typedef cv::Seq< int > exported_class_t;
            typedef bool ( exported_class_t::*empty_function_type )(  ) const;
            
            Seq_int_exposer.def( 
                "empty"
                , empty_function_type( &::cv::Seq< int >::empty ) );
        
        }
        { //::cv::Seq< int >::index
        
            typedef cv::Seq< int > exported_class_t;
            typedef ::size_t ( exported_class_t::*index_function_type )( int const & ) const;
            
            Seq_int_exposer.def( 
                "index"
                , index_function_type( &::cv::Seq< int >::index )
                , ( bp::arg("elem") ) );
        
        }
        { //::cv::Seq< int >::insert
        
            typedef cv::Seq< int > exported_class_t;
            typedef void ( exported_class_t::*insert_function_type )( int,int const & ) ;
            
            Seq_int_exposer.def( 
                "insert"
                , insert_function_type( &::cv::Seq< int >::insert )
                , ( bp::arg("idx"), bp::arg("elem") ) );
        
        }
        Seq_int_exposer.def( "__temp_func", &cv::Seq< int >::operator ::std::vector< int > , "\nWrapped function:"
    "\n    operator ::std::vector<int, std::allocator<int> >" );
        { //::cv::Seq< int >::operator[]
        
            typedef cv::Seq< int > exported_class_t;
            typedef int & ( exported_class_t::*__getitem___function_type )( int ) ;
            
            Seq_int_exposer.def( 
                "__getitem__"
                , __getitem___function_type( &::cv::Seq< int >::operator[] )
                , ( bp::arg("idx") )
                , bp::return_value_policy< bp::copy_non_const_reference >()
                , "\nWrapped function:"
    "\n    operator[]" );
        
        }
        { //::cv::Seq< int >::operator[]
        
            typedef cv::Seq< int > exported_class_t;
            typedef int const & ( exported_class_t::*__getitem___function_type )( int ) const;
            
            Seq_int_exposer.def( 
                "__getitem__"
                , __getitem___function_type( &::cv::Seq< int >::operator[] )
                , ( bp::arg("idx") )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "\nWrapped function:"
    "\n    operator[]" );
        
        }
        { //::cv::Seq< int >::pop_back
        
            typedef cv::Seq< int > exported_class_t;
            typedef void ( exported_class_t::*pop_back_function_type )(  ) ;
            
            Seq_int_exposer.def( 
                "pop_back"
                , pop_back_function_type( &::cv::Seq< int >::pop_back ) );
        
        }
        { //::cv::Seq< int >::pop_front
        
            typedef cv::Seq< int > exported_class_t;
            typedef void ( exported_class_t::*pop_front_function_type )(  ) ;
            
            Seq_int_exposer.def( 
                "pop_front"
                , pop_front_function_type( &::cv::Seq< int >::pop_front ) );
        
        }
        { //::cv::Seq< int >::push_back
        
            typedef cv::Seq< int > exported_class_t;
            typedef void ( exported_class_t::*push_back_function_type )( int const & ) ;
            
            Seq_int_exposer.def( 
                "push_back"
                , push_back_function_type( &::cv::Seq< int >::push_back )
                , ( bp::arg("elem") ) );
        
        }
        { //::cv::Seq< int >::push_front
        
            typedef cv::Seq< int > exported_class_t;
            typedef void ( exported_class_t::*push_front_function_type )( int const & ) ;
            
            Seq_int_exposer.def( 
                "push_front"
                , push_front_function_type( &::cv::Seq< int >::push_front )
                , ( bp::arg("elem") ) );
        
        }
        { //::cv::Seq< int >::remove
        
            typedef cv::Seq< int > exported_class_t;
            typedef void ( exported_class_t::*remove_function_type )( int ) ;
            
            Seq_int_exposer.def( 
                "remove"
                , remove_function_type( &::cv::Seq< int >::remove )
                , ( bp::arg("idx") ) );
        
        }
        { //::cv::Seq< int >::remove
        
            typedef cv::Seq< int > exported_class_t;
            typedef void ( exported_class_t::*remove_function_type )( ::cv::Range const & ) ;
            
            Seq_int_exposer.def( 
                "remove"
                , remove_function_type( &::cv::Seq< int >::remove )
                , ( bp::arg("r") ) );
        
        }
        { //::cv::Seq< int >::size
        
            typedef cv::Seq< int > exported_class_t;
            typedef ::size_t ( exported_class_t::*size_function_type )(  ) const;
            
            Seq_int_exposer.def( 
                "size"
                , size_function_type( &::cv::Seq< int >::size ) );
        
        }
        { //::cv::Seq< int >::type
        
            typedef cv::Seq< int > exported_class_t;
            typedef int ( exported_class_t::*type_function_type )(  ) const;
            
            Seq_int_exposer.def( 
                "type"
                , type_function_type( &::cv::Seq< int >::type ) );
        
        }
        Seq_int_exposer.def("__len__", &::Seq_int_len);
        Seq_int_exposer.add_property( "seq", bp::make_function(&::get_Seq_int_seq, bp::return_internal_reference<>()) );
    }

    { //::cv::Size_< float >
        typedef bp::class_< cv::Size_< float > > Size2f_exposer_t;
        Size2f_exposer_t Size2f_exposer = Size2f_exposer_t( "Size2f", bp::init< >() );
        bp::scope Size2f_scope( Size2f_exposer );
        Size2f_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Size_< float > >() );
        Size2f_exposer.def( bp::init< float, float >(( bp::arg("_width"), bp::arg("_height") )) );
        Size2f_exposer.def( bp::init< cv::Size_< float > const & >(( bp::arg("sz") )) );
        Size2f_exposer.def( bp::init< cv::Point_< float > const & >(( bp::arg("pt") )) );
        bp::implicitly_convertible< cv::Point_< float > const &, cv::Size_< float > >();
        { //::cv::Size_< float >::area
        
            typedef cv::Size_< float > exported_class_t;
            typedef float ( exported_class_t::*area_function_type )(  ) const;
            
            Size2f_exposer.def( 
                "area"
                , area_function_type( &::cv::Size_< float >::area ) );
        
        }
        { //::cv::Size_< float >::operator=
        
            typedef cv::Size_< float > exported_class_t;
            typedef ::cv::Size_< float > & ( exported_class_t::*assign_function_type )( ::cv::Size_< float > const & ) ;
            
            Size2f_exposer.def( 
                "assign"
                , assign_function_type( &::cv::Size_< float >::operator= )
                , ( bp::arg("sz") )
                , bp::return_self< >()
                , "\nWrapped function:"
    "\n    operator=" );
        
        }
        Size2f_exposer.def_readwrite( "height", &cv::Size_< float >::height );
        Size2f_exposer.def_readwrite( "width", &cv::Size_< float >::width );
        Size2f_exposer.add_property("ndarray", &sdcpp::as_ndarray< cv::Size_<float> >);
        Size2f_exposer.def("__iadd__", &__iadd__<cv::Size2f, cv::Size2f>, bp::return_self<>() );
        Size2f_exposer.def("__isub__", &__isub__<cv::Size2f, cv::Size2f>, bp::return_self<>() );
        Size2f_exposer.def("__add__", &__add__<cv::Size2f, cv::Size2f> );
        Size2f_exposer.def("__sub__", &__sub__<cv::Size2f, cv::Size2f> );
        Size2f_exposer.def("__eq__", &__eq__<cv::Size2f, cv::Size2f> );
        Size2f_exposer.def("__ne__", &__ne__<cv::Size2f, cv::Size2f> );
        Size2f_exposer.def("__mul__", &__mul__<cv::Size2f, float> );
    }

    { //::cv::Size_< int >
        typedef bp::class_< cv::Size_< int > > Size2i_exposer_t;
        Size2i_exposer_t Size2i_exposer = Size2i_exposer_t( "Size2i", bp::init< >() );
        bp::scope Size2i_scope( Size2i_exposer );
        Size2i_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Size_< int > >() );
        Size2i_exposer.def( bp::init< int, int >(( bp::arg("_width"), bp::arg("_height") )) );
        Size2i_exposer.def( bp::init< cv::Size_< int > const & >(( bp::arg("sz") )) );
        Size2i_exposer.def( bp::init< cv::Point_< int > const & >(( bp::arg("pt") )) );
        bp::implicitly_convertible< cv::Point_< int > const &, cv::Size_< int > >();
        { //::cv::Size_< int >::area
        
            typedef cv::Size_< int > exported_class_t;
            typedef int ( exported_class_t::*area_function_type )(  ) const;
            
            Size2i_exposer.def( 
                "area"
                , area_function_type( &::cv::Size_< int >::area ) );
        
        }
        { //::cv::Size_< int >::operator=
        
            typedef cv::Size_< int > exported_class_t;
            typedef ::cv::Size_< int > & ( exported_class_t::*assign_function_type )( ::cv::Size_< int > const & ) ;
            
            Size2i_exposer.def( 
                "assign"
                , assign_function_type( &::cv::Size_< int >::operator= )
                , ( bp::arg("sz") )
                , bp::return_self< >()
                , "\nWrapped function:"
    "\n    operator=" );
        
        }
        Size2i_exposer.def_readwrite( "height", &cv::Size_< int >::height );
        Size2i_exposer.def_readwrite( "width", &cv::Size_< int >::width );
        Size2i_exposer.add_property("ndarray", &sdcpp::as_ndarray< cv::Size_<int> >);
        Size2i_exposer.def("__iadd__", &__iadd__<cv::Size2i, cv::Size2i>, bp::return_self<>() );
        Size2i_exposer.def("__isub__", &__isub__<cv::Size2i, cv::Size2i>, bp::return_self<>() );
        Size2i_exposer.def("__add__", &__add__<cv::Size2i, cv::Size2i> );
        Size2i_exposer.def("__sub__", &__sub__<cv::Size2i, cv::Size2i> );
        Size2i_exposer.def("__eq__", &__eq__<cv::Size2i, cv::Size2i> );
        Size2i_exposer.def("__ne__", &__ne__<cv::Size2i, cv::Size2i> );
        Size2i_exposer.def("__mul__", &__mul__<cv::Size2i, int> );
    }

    { //::cv::SparseMat
        typedef bp::class_< SparseMat_wrapper > SparseMat_exposer_t;
        SparseMat_exposer_t SparseMat_exposer = SparseMat_exposer_t( "SparseMat", bp::init< cv::Mat const &, bp::optional< bool > >(( bp::arg("m"), bp::arg("try1d")=(bool)(false) )) );
        bp::scope SparseMat_scope( SparseMat_exposer );
        SparseMat_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::SparseMat >() );
        bp::scope().attr("MAGIC_VAL") = (int)cv::SparseMat::MAGIC_VAL;
        bp::scope().attr("MAX_DIM") = (int)cv::SparseMat::MAX_DIM;
        bp::scope().attr("HASH_SCALE") = (int)cv::SparseMat::HASH_SCALE;
        bp::scope().attr("HASH_BIT") = (int)cv::SparseMat::HASH_BIT;
        { //::cv::SparseMat::Hdr
            typedef bp::class_< SparseMat_wrapper::Hdr_wrapper > Hdr_exposer_t;
            Hdr_exposer_t Hdr_exposer = Hdr_exposer_t( "Hdr", bp::no_init );
            bp::scope Hdr_scope( Hdr_exposer );
            Hdr_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::SparseMat::Hdr >() );
            { //::cv::SparseMat::Hdr::clear
            
                typedef void ( ::cv::SparseMat::Hdr::*clear_function_type )(  ) ;
                
                Hdr_exposer.def( 
                    "clear"
                    , clear_function_type( &::cv::SparseMat::Hdr::clear ) );
            
            }
            Hdr_exposer.def_readwrite( "dims", &cv::SparseMat::Hdr::dims );
            Hdr_exposer.def_readwrite( "freeList", &cv::SparseMat::Hdr::freeList );
            Hdr_exposer.def_readwrite( "hashtab", &cv::SparseMat::Hdr::hashtab );
            Hdr_exposer.def_readwrite( "nodeCount", &cv::SparseMat::Hdr::nodeCount );
            Hdr_exposer.def_readwrite( "nodeSize", &cv::SparseMat::Hdr::nodeSize );
            Hdr_exposer.def_readwrite( "pool", &cv::SparseMat::Hdr::pool );
            Hdr_exposer.def_readwrite( "refcount", &cv::SparseMat::Hdr::refcount );
            pyplusplus::containers::static_sized::register_array_1< int, 32 >( "__array_1_int_32" );
            { //cv::SparseMat::Hdr::size [variable], type=int[32]
            
                typedef pyplusplus::containers::static_sized::array_1_t< int, 32> ( *array_wrapper_creator )( cv::SparseMat::Hdr & );
                
                Hdr_exposer.add_property( "size"
                    , bp::make_function( array_wrapper_creator(&SparseMat_wrapper::Hdr_wrapper::pyplusplus_size_wrapper)
                                        , bp::with_custodian_and_ward_postcall< 0, 1 >() ) );
            }
            Hdr_exposer.def_readwrite( "valueOffset", &cv::SparseMat::Hdr::valueOffset );
            Hdr_exposer.def("__init__", bp::make_constructor(&SparseMat_Hdr__init1__, bp::default_call_policies(), ( bp::arg("_sizes"), bp::arg("_type") )));
        }
        { //::cv::SparseMat::Node
            typedef bp::class_< SparseMat_wrapper::Node_wrapper > Node_exposer_t;
            Node_exposer_t Node_exposer = Node_exposer_t( "Node" );
            bp::scope Node_scope( Node_exposer );
            Node_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::SparseMat::Node >() );
            Node_exposer.def_readwrite( "hashval", &cv::SparseMat::Node::hashval );
            { //cv::SparseMat::Node::idx [variable], type=int[32]
            
                typedef pyplusplus::containers::static_sized::array_1_t< int, 32> ( *array_wrapper_creator )( cv::SparseMat::Node & );
                
                Node_exposer.add_property( "idx"
                    , bp::make_function( array_wrapper_creator(&SparseMat_wrapper::Node_wrapper::pyplusplus_idx_wrapper)
                                        , bp::with_custodian_and_ward_postcall< 0, 1 >() ) );
            }
            Node_exposer.def_readwrite( "next", &cv::SparseMat::Node::next );
        }
        bp::implicitly_convertible< cv::Mat const &, cv::SparseMat >();
        SparseMat_exposer.def( bp::init< cv::MatND const & >(( bp::arg("m") )) );
        bp::implicitly_convertible< cv::MatND const &, cv::SparseMat >();
        SparseMat_exposer.def( bp::init< >() );
        SparseMat_exposer.def( bp::init< cv::SparseMat const & >(( bp::arg("m") )) );
        { //::cv::SparseMat::assignTo
        
            typedef void ( ::cv::SparseMat::*assignTo_function_type )( ::cv::SparseMat &,int ) const;
            
            SparseMat_exposer.def( 
                "assignTo"
                , assignTo_function_type( &::cv::SparseMat::assignTo )
                , ( bp::arg("m"), bp::arg("type")=(int)(-0x000000001) ) );
        
        }
        { //::cv::SparseMat::begin
        
            typedef ::cv::SparseMatIterator ( ::cv::SparseMat::*__iter___function_type )(  ) ;
            
            SparseMat_exposer.def( 
                "__iter__"
                , __iter___function_type( &::cv::SparseMat::begin )
                , "\nWrapped function:"
    "\n    begin" );
        
        }
        { //::cv::SparseMat::channels
        
            typedef int ( ::cv::SparseMat::*channels_function_type )(  ) const;
            
            SparseMat_exposer.def( 
                "channels"
                , channels_function_type( &::cv::SparseMat::channels ) );
        
        }
        { //::cv::SparseMat::clear
        
            typedef void ( ::cv::SparseMat::*clear_function_type )(  ) ;
            
            SparseMat_exposer.def( 
                "clear"
                , clear_function_type( &::cv::SparseMat::clear ) );
        
        }
        { //::cv::SparseMat::clone
        
            typedef ::cv::SparseMat ( ::cv::SparseMat::*clone_function_type )(  ) const;
            
            SparseMat_exposer.def( 
                "clone"
                , clone_function_type( &::cv::SparseMat::clone ) );
        
        }
        { //::cv::SparseMat::convertTo
        
            typedef void ( ::cv::SparseMat::*convertTo_function_type )( ::cv::SparseMat &,int,double ) const;
            
            SparseMat_exposer.def( 
                "convertTo"
                , convertTo_function_type( &::cv::SparseMat::convertTo )
                , ( bp::arg("m"), bp::arg("rtype"), bp::arg("alpha")=1 ) );
        
        }
        { //::cv::SparseMat::convertTo
        
            typedef void ( ::cv::SparseMat::*convertTo_function_type )( ::cv::Mat &,int,double,double ) const;
            
            SparseMat_exposer.def( 
                "convertTo"
                , convertTo_function_type( &::cv::SparseMat::convertTo )
                , ( bp::arg("m"), bp::arg("rtype"), bp::arg("alpha")=1, bp::arg("beta")=0 ) );
        
        }
        { //::cv::SparseMat::convertTo
        
            typedef void ( ::cv::SparseMat::*convertTo_function_type )( ::cv::MatND &,int,double,double ) const;
            
            SparseMat_exposer.def( 
                "convertTo"
                , convertTo_function_type( &::cv::SparseMat::convertTo )
                , ( bp::arg("m"), bp::arg("rtype"), bp::arg("alpha")=1, bp::arg("beta")=0 ) );
        
        }
        { //::cv::SparseMat::copyTo
        
            typedef void ( ::cv::SparseMat::*copyTo_function_type )( ::cv::SparseMat & ) const;
            
            SparseMat_exposer.def( 
                "copyTo"
                , copyTo_function_type( &::cv::SparseMat::copyTo )
                , ( bp::arg("m") ) );
        
        }
        { //::cv::SparseMat::copyTo
        
            typedef void ( ::cv::SparseMat::*copyTo_function_type )( ::cv::Mat & ) const;
            
            SparseMat_exposer.def( 
                "copyTo"
                , copyTo_function_type( &::cv::SparseMat::copyTo )
                , ( bp::arg("m") ) );
        
        }
        { //::cv::SparseMat::copyTo
        
            typedef void ( ::cv::SparseMat::*copyTo_function_type )( ::cv::MatND & ) const;
            
            SparseMat_exposer.def( 
                "copyTo"
                , copyTo_function_type( &::cv::SparseMat::copyTo )
                , ( bp::arg("m") ) );
        
        }
        { //::cv::SparseMat::create
        
            typedef void ( *create_function_type )( cv::SparseMat &,std::vector<int> const &,int );
            
            SparseMat_exposer.def( 
                "create"
                , create_function_type( &SparseMat_wrapper::create )
                , ( bp::arg("inst"), bp::arg("_sizes"), bp::arg("_type") )
                , "\nArgument 'dims':"\
    "\n    Dependent argument: omitted from input. Its value is derived from "\
    "\n    argument '_sizes'."\
    "\nArgument '_sizes':"\
    "\n    C++ type: int const *"\
    "\n    Python type: vector_int" );
        
        }
        { //::cv::SparseMat::depth
        
            typedef int ( ::cv::SparseMat::*depth_function_type )(  ) const;
            
            SparseMat_exposer.def( 
                "depth"
                , depth_function_type( &::cv::SparseMat::depth ) );
        
        }
        { //::cv::SparseMat::dims
        
            typedef int ( ::cv::SparseMat::*dims_function_type )(  ) const;
            
            SparseMat_exposer.def( 
                "dims"
                , dims_function_type( &::cv::SparseMat::dims ) );
        
        }
        { //::cv::SparseMat::elemSize
        
            typedef ::size_t ( ::cv::SparseMat::*elemSize_function_type )(  ) const;
            
            SparseMat_exposer.def( 
                "elemSize"
                , elemSize_function_type( &::cv::SparseMat::elemSize ) );
        
        }
        { //::cv::SparseMat::elemSize1
        
            typedef ::size_t ( ::cv::SparseMat::*elemSize1_function_type )(  ) const;
            
            SparseMat_exposer.def( 
                "elemSize1"
                , elemSize1_function_type( &::cv::SparseMat::elemSize1 ) );
        
        }
        { //::cv::SparseMat::erase
        
            typedef boost::python::object ( *erase_ce64effe5fbeb3e9588310d12240ddce_function_type )( cv::SparseMat &,int,int );
            
            SparseMat_exposer.def( 
                "erase_ce64effe5fbeb3e9588310d12240ddce"
                , erase_ce64effe5fbeb3e9588310d12240ddce_function_type( &SparseMat_wrapper::erase_ce64effe5fbeb3e9588310d12240ddce )
                , ( bp::arg("inst"), bp::arg("i0"), bp::arg("i1") )
                , "\nWrapped function:"
    "\n    erase"
    "\nArgument 'hashval':"\
    "\n    C++ type: ::size_t *"\
    "\n    Python type: uint"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    hashval" );
        
        }
        { //::cv::SparseMat::erase
        
            typedef boost::python::object ( *erase_ca8730dab3cfc35be7d8c7cfc84bf06f_function_type )( cv::SparseMat &,int,int,int );
            
            SparseMat_exposer.def( 
                "erase_ca8730dab3cfc35be7d8c7cfc84bf06f"
                , erase_ca8730dab3cfc35be7d8c7cfc84bf06f_function_type( &SparseMat_wrapper::erase_ca8730dab3cfc35be7d8c7cfc84bf06f )
                , ( bp::arg("inst"), bp::arg("i0"), bp::arg("i1"), bp::arg("i2") )
                , "\nWrapped function:"
    "\n    erase"
    "\nArgument 'hashval':"\
    "\n    C++ type: ::size_t *"\
    "\n    Python type: uint"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    hashval" );
        
        }
        { //::cv::SparseMat::erase
        
            typedef boost::python::object ( *erase_7ee4e9a1250db62333754bd289edbba8_function_type )( cv::SparseMat &,std::vector<int> const & );
            
            SparseMat_exposer.def( 
                "erase_7ee4e9a1250db62333754bd289edbba8"
                , erase_7ee4e9a1250db62333754bd289edbba8_function_type( &SparseMat_wrapper::erase_7ee4e9a1250db62333754bd289edbba8 )
                , ( bp::arg("inst"), bp::arg("idx") )
                , "\nWrapped function:"
    "\n    erase"
    "\nArgument 'idx':"\
    "\n    C++ type: int const *"\
    "\n    Python type: vector_int"\
    "\nArgument 'hashval':"\
    "\n    C++ type: ::size_t *"\
    "\n    Python type: uint"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    hashval" );
        
        }
        { //::cv::SparseMat::hash
        
            typedef ::size_t ( ::cv::SparseMat::*hash_function_type )( int ) const;
            
            SparseMat_exposer.def( 
                "hash"
                , hash_function_type( &::cv::SparseMat::hash )
                , ( bp::arg("i0") ) );
        
        }
        { //::cv::SparseMat::hash
        
            typedef ::size_t ( ::cv::SparseMat::*hash_function_type )( int,int ) const;
            
            SparseMat_exposer.def( 
                "hash"
                , hash_function_type( &::cv::SparseMat::hash )
                , ( bp::arg("i0"), bp::arg("i1") ) );
        
        }
        { //::cv::SparseMat::hash
        
            typedef ::size_t ( ::cv::SparseMat::*hash_function_type )( int,int,int ) const;
            
            SparseMat_exposer.def( 
                "hash"
                , hash_function_type( &::cv::SparseMat::hash )
                , ( bp::arg("i0"), bp::arg("i1"), bp::arg("i2") ) );
        
        }
        { //::cv::SparseMat::hash
        
            typedef boost::python::object ( *hash_19477be6a05d6299f1601326adc61332_function_type )( cv::SparseMat const &,std::vector<int> const & );
            
            SparseMat_exposer.def( 
                "hash_19477be6a05d6299f1601326adc61332"
                , hash_19477be6a05d6299f1601326adc61332_function_type( &SparseMat_wrapper::hash_19477be6a05d6299f1601326adc61332 )
                , ( bp::arg("inst"), bp::arg("idx") )
                , "\nWrapped function:"
    "\n    hash"
    "\nArgument 'idx':"\
    "\n    C++ type: int const *"\
    "\n    Python type: vector_int" );
        
        }
        { //::cv::SparseMat::node
        
            typedef ::cv::SparseMat::Node * ( ::cv::SparseMat::*node_function_type )( ::size_t ) ;
            
            SparseMat_exposer.def( 
                "node"
                , node_function_type( &::cv::SparseMat::node )
                , ( bp::arg("nidx") )
                , bp::return_internal_reference< >() );
        
        }
        { //::cv::SparseMat::node
        
            typedef ::cv::SparseMat::Node const * ( ::cv::SparseMat::*node_function_type )( ::size_t ) const;
            
            SparseMat_exposer.def( 
                "node"
                , node_function_type( &::cv::SparseMat::node )
                , ( bp::arg("nidx") )
                , bp::return_internal_reference< >() );
        
        }
        { //::cv::SparseMat::nzcount
        
            typedef ::size_t ( ::cv::SparseMat::*nzcount_function_type )(  ) const;
            
            SparseMat_exposer.def( 
                "nzcount"
                , nzcount_function_type( &::cv::SparseMat::nzcount ) );
        
        }
        { //::cv::SparseMat::operator=
        
            typedef ::cv::SparseMat & ( ::cv::SparseMat::*assign_function_type )( ::cv::SparseMat const & ) ;
            
            SparseMat_exposer.def( 
                "assign"
                , assign_function_type( &::cv::SparseMat::operator= )
                , ( bp::arg("m") )
                , bp::return_self< >()
                , "\nWrapped function:"
    "\n    operator=" );
        
        }
        { //::cv::SparseMat::operator=
        
            typedef ::cv::SparseMat & ( ::cv::SparseMat::*assign_function_type )( ::cv::Mat const & ) ;
            
            SparseMat_exposer.def( 
                "assign"
                , assign_function_type( &::cv::SparseMat::operator= )
                , ( bp::arg("m") )
                , bp::return_self< >()
                , "\nWrapped function:"
    "\n    operator=" );
        
        }
        { //::cv::SparseMat::operator=
        
            typedef ::cv::SparseMat & ( ::cv::SparseMat::*assign_function_type )( ::cv::MatND const & ) ;
            
            SparseMat_exposer.def( 
                "assign"
                , assign_function_type( &::cv::SparseMat::operator= )
                , ( bp::arg("m") )
                , bp::return_self< >()
                , "\nWrapped function:"
    "\n    operator=" );
        
        }
        { //::cv::SparseMat::removeNode
        
            typedef void ( ::cv::SparseMat::*removeNode_function_type )( ::size_t,::size_t,::size_t ) ;
            
            SparseMat_exposer.def( 
                "removeNode"
                , removeNode_function_type( &::cv::SparseMat::removeNode )
                , ( bp::arg("hidx"), bp::arg("nidx"), bp::arg("previdx") ) );
        
        }
        { //::cv::SparseMat::resizeHashTab
        
            typedef void ( ::cv::SparseMat::*resizeHashTab_function_type )( ::size_t ) ;
            
            SparseMat_exposer.def( 
                "resizeHashTab"
                , resizeHashTab_function_type( &::cv::SparseMat::resizeHashTab )
                , ( bp::arg("newsize") ) );
        
        }
        { //::cv::SparseMat::type
        
            typedef int ( ::cv::SparseMat::*type_function_type )(  ) const;
            
            SparseMat_exposer.def( 
                "type"
                , type_function_type( &::cv::SparseMat::type ) );
        
        }
        SparseMat_exposer.def_readwrite( "flags", &cv::SparseMat::flags );
        SparseMat_exposer.add_property( "hdr"
                    , bp::make_function( (::cv::SparseMat::Hdr * (*)( ::cv::SparseMat const & ))(&SparseMat_wrapper::get_hdr), bp::return_internal_reference< >() )
                    , bp::make_function( (void (*)( ::cv::SparseMat &,::cv::SparseMat::Hdr * ))(&SparseMat_wrapper::set_hdr), bp::with_custodian_and_ward_postcall< 1, 2 >() ) );
        SparseMat_exposer.def("__init__", bp::make_constructor(&SparseMat__init1__, bp::default_call_policies(), ( bp::arg("_sizes"), bp::arg("_type") )));
        SparseMat_exposer.def("size", &::SparseMat_size, (bp::arg("i")=bp::object(-1)));
    }

    { //::cv::SparseMatIterator
        typedef bp::class_< SparseMatIterator_wrapper > SparseMatIterator_exposer_t;
        SparseMatIterator_exposer_t SparseMatIterator_exposer = SparseMatIterator_exposer_t( "SparseMatIterator", bp::init< >() );
        bp::scope SparseMatIterator_scope( SparseMatIterator_exposer );
        SparseMatIterator_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::SparseMatIterator >() );
        SparseMatIterator_exposer.def( bp::init< cv::SparseMat * >(( bp::arg("_m") )) );
        bp::implicitly_convertible< cv::SparseMat *, cv::SparseMatIterator >();
        SparseMatIterator_exposer.def( bp::init< cv::SparseMatIterator const & >(( bp::arg("it") )) );
        { //::cv::SparseMatIterator::node
        
            typedef ::cv::SparseMat::Node * ( ::cv::SparseMatIterator::*node_function_type )(  ) const;
            
            SparseMatIterator_exposer.def( 
                "node"
                , node_function_type( &::cv::SparseMatIterator::node )
                , bp::return_internal_reference< >() );
        
        }
        { //::cv::SparseMatIterator::operator=
        
            typedef ::cv::SparseMatIterator & ( ::cv::SparseMatIterator::*assign_function_type )( ::cv::SparseMatIterator const & ) ;
            
            SparseMatIterator_exposer.def( 
                "assign"
                , assign_function_type( &::cv::SparseMatIterator::operator= )
                , ( bp::arg("it") )
                , bp::return_self< >()
                , "\nWrapped function:"
    "\n    operator=" );
        
        }
        SparseMatIterator_exposer.def("__iter__", &SparseMatIterator_wrapper::iter, bp::return_self<>());
        SparseMatIterator_exposer.def("next", &SparseMatIterator_wrapper::next, bp::return_internal_reference<>());
    }

    { //::cv::TermCriteria
        typedef bp::class_< cv::TermCriteria > TermCriteria_exposer_t;
        TermCriteria_exposer_t TermCriteria_exposer = TermCriteria_exposer_t( "TermCriteria", bp::init< >() );
        bp::scope TermCriteria_scope( TermCriteria_exposer );
        TermCriteria_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::TermCriteria >() );
        bp::scope().attr("COUNT") = (int)cv::TermCriteria::COUNT;
        bp::scope().attr("MAX_ITER") = (int)cv::TermCriteria::MAX_ITER;
        bp::scope().attr("EPS") = (int)cv::TermCriteria::EPS;
        TermCriteria_exposer.def( bp::init< int, int, double >(( bp::arg("_type"), bp::arg("_maxCount"), bp::arg("_epsilon") )) );
        TermCriteria_exposer.def_readwrite( "epsilon", &cv::TermCriteria::epsilon );
        TermCriteria_exposer.def_readwrite( "maxCount", &cv::TermCriteria::maxCount );
        TermCriteria_exposer.def_readwrite( "type", &cv::TermCriteria::type );
    }

    { //::cxcore_hpp_dummy_struct
        typedef bp::class_< cxcore_hpp_dummy_struct > __cxcore_hpp_dummy_struct_exposer_t;
        __cxcore_hpp_dummy_struct_exposer_t __cxcore_hpp_dummy_struct_exposer = __cxcore_hpp_dummy_struct_exposer_t( "__cxcore_hpp_dummy_struct" );
        bp::scope __cxcore_hpp_dummy_struct_scope( __cxcore_hpp_dummy_struct_exposer );
        __cxcore_hpp_dummy_struct_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cxcore_hpp_dummy_struct >() );
        bp::class_< cxcore_hpp_dummy_struct::dummy_struct2 >( "dummy_struct2" )    
            .add_property( "this", pyplus_conv::make_addressof_inst_getter< cxcore_hpp_dummy_struct::dummy_struct2 >() );
        __cxcore_hpp_dummy_struct_exposer.setattr("v0", 0);
    }
    {
        
        bp::def("convert_Size2i_to_Size2f", &::normal_cast< ::cv::Size_<int>, ::cv::Size_<float> >, (bp::arg("inst_Size2i")));
        bp::def("convert_Size2f_to_Size2i", &::normal_cast< ::cv::Size_<float>, ::cv::Size_<int> >, (bp::arg("inst_Size2f")));
        bp::def("convert_vector_Rect_to_ndarray", &sdcpp::vector_to_ndarray2< cv::Rect_< int > >, (bp::arg("inst_vector_Rect")) );
        bp::def("convert_ndarray_to_vector_Rect", &sdcpp::ndarray_to_vector2< cv::Rect_< int > >, (bp::arg("inst_ndarray")) );
        bp::def("convert_vector_RotatedRect_to_ndarray", &sdcpp::vector_to_ndarray2< cv::RotatedRect >, (bp::arg("inst_vector_RotatedRect")) );
        bp::def("convert_ndarray_to_vector_RotatedRect", &sdcpp::ndarray_to_vector2< cv::RotatedRect >, (bp::arg("inst_ndarray")) );
        bp::def("convert_Seq_int_to_vector_int", &::normal_cast< ::cv::Seq< int >, ::std::vector< int > >, (bp::arg("inst_Seq_int")));;
    }

}
