// This file has been generated by Py++.

#include "boost/python.hpp"
#include "__ctypes_integration.pypp.hpp"
#include "cv_h_wrapper.hpp"
#include "boost/python/object.hpp"
#include "boost/python/list.hpp"
#include "boost/python/tuple.hpp"
#include "opencv_converters.hpp"
#include "cv_h_ext_classes_2.pypp.hpp"

namespace bp = boost::python;

static cv::Rect *CvHaarFeature_get_rect(CvHaarFeature const &inst, int i)
{
    return (cv::Rect *)&inst.rect[i].r;
}

static float CvHaarFeature_get_rect_weight(CvHaarFeature const &inst, int i)
{
    return inst.rect[i].weight;
}

static void CvHaarFeature_set_rect_weight(CvHaarFeature &inst, int i, float _weight)
{
    inst.rect[i].weight = _weight;
}

static bp::object get_CvHaarStageClassifier_classifier( CvHaarStageClassifier const & inst ){
    bp::list l;
    for(int i = 0; i < inst.count; ++i)
        l.append(inst.classifier[i]);
    return bp::tuple(l);
}

static bp::object get_CvHidHaarClassifier_node( CvHidHaarClassifier const & inst ){
    bp::list l;
    for(int i = 0; i < inst.count; ++i)
        l.append(inst.node[i]);
    return bp::tuple(l);
}

static cv::Mat get_CvHidHaarClassifier_alpha(CvHidHaarClassifier const &inst)
{
    cv::Mat alpha2;
    convert_from_array_of_T_to_Mat(inst.alpha, inst.count+1, alpha2);
    return alpha2;
}

static bp::object get_CvHidHaarClassifierCascade_stage_classifier( CvHidHaarClassifierCascade const & inst ){
    bp::list l;
    for(int i = 0; i < inst.count; ++i)
        l.append(inst.stage_classifier[i]);
    return bp::tuple(l);
}

static float CvHidHaarFeature_get_rect_weight(CvHidHaarFeature const &inst, int i)
{
    return inst.rect[i].weight;
}

static void CvHidHaarFeature_set_rect_weight(CvHidHaarFeature &inst, int i, float _weight)
{
    inst.rect[i].weight = _weight;
}

static bp::object get_CvHidHaarStageClassifier_classifier( CvHidHaarStageClassifier const & inst ){
    bp::list l;
    for(int i = 0; i < inst.count; ++i)
        l.append(inst.classifier[i]);
    return bp::tuple(l);
}

static CvHidHaarStageClassifier * get_CvHidHaarStageClassifier_next( CvHidHaarStageClassifier const & inst ) { return inst.next; }

static CvHidHaarStageClassifier * get_CvHidHaarStageClassifier_parent( CvHidHaarStageClassifier const & inst ) { return inst.parent; }

static CvHidHaarStageClassifier * get_CvHidHaarStageClassifier_child( CvHidHaarStageClassifier const & inst ) { return inst.child; }

void register_classes_2(){

    bp::class_< CvHaarFeature >( "CvHaarFeature" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvHaarFeature >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvHaarFeature >() )    
        .def_readwrite( "tilted", &CvHaarFeature::tilted )    
        .def("get_rect", &::CvHaarFeature_get_rect, bp::return_internal_reference<>())    
        .def("get_rect_weight", &::CvHaarFeature_get_rect_weight)    
        .def("set_rect_weight", &::CvHaarFeature_set_rect_weight);

    bp::class_< CvHaarStageClassifier >( "CvHaarStageClassifier" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvHaarStageClassifier >() )    
        .def_readwrite( "child", &CvHaarStageClassifier::child )    
        .def_readwrite( "count", &CvHaarStageClassifier::count )    
        .def_readwrite( "next", &CvHaarStageClassifier::next )    
        .def_readwrite( "parent", &CvHaarStageClassifier::parent )    
        .def_readwrite( "threshold", &CvHaarStageClassifier::threshold )    
        .add_property( "classifier", &::get_CvHaarStageClassifier_classifier );

    bp::class_< CvHidHaarClassifier >( "CvHidHaarClassifier" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvHidHaarClassifier >() )    
        .def_readwrite( "count", &CvHidHaarClassifier::count )    
        .add_property( "node", &::get_CvHidHaarClassifier_node )    
        .add_property( "alpha", &::get_CvHidHaarClassifier_alpha);

    bp::class_< CvHidHaarClassifierCascade >( "CvHidHaarClassifierCascade" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvHidHaarClassifierCascade >() )    
        .def_readwrite( "count", &CvHidHaarClassifierCascade::count )    
        .def_readwrite( "has_tilted_features", &CvHidHaarClassifierCascade::has_tilted_features )    
        .def_readwrite( "inv_window_area", &CvHidHaarClassifierCascade::inv_window_area )    
        .def_readwrite( "is_stump_based", &CvHidHaarClassifierCascade::is_stump_based )    
        .def_readwrite( "is_tree", &CvHidHaarClassifierCascade::is_tree )    
        .def_readwrite( "sqsum", &CvHidHaarClassifierCascade::sqsum )    
        .def_readwrite( "sum", &CvHidHaarClassifierCascade::sum )    
        .def_readwrite( "tilted", &CvHidHaarClassifierCascade::tilted )    
        .add_property( "stage_classifier", &::get_CvHidHaarClassifierCascade_stage_classifier );

    bp::class_< CvHidHaarFeature >( "CvHidHaarFeature" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvHidHaarFeature >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvHidHaarFeature >() )    
        .def("get_rect_weight", &::CvHidHaarFeature_get_rect_weight)    
        .def("set_rect_weight", &::CvHidHaarFeature_set_rect_weight);

    bp::class_< CvHidHaarStageClassifier >( "CvHidHaarStageClassifier" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvHidHaarStageClassifier >() )    
        .def_readwrite( "count", &CvHidHaarStageClassifier::count )    
        .def_readwrite( "threshold", &CvHidHaarStageClassifier::threshold )    
        .def_readwrite( "two_rects", &CvHidHaarStageClassifier::two_rects )    
        .add_property( "classifier", &::get_CvHidHaarStageClassifier_classifier )    
        .add_property( "next", bp::make_function(&::get_CvHidHaarStageClassifier_next, bp::return_internal_reference<>()) )    
        .add_property( "parent", bp::make_function(&::get_CvHidHaarStageClassifier_parent, bp::return_internal_reference<>()) )    
        .add_property( "child", bp::make_function(&::get_CvHidHaarStageClassifier_child, bp::return_internal_reference<>()) );

    bp::class_< CvHidHaarTreeNode >( "CvHidHaarTreeNode" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvHidHaarTreeNode >() )    
        .def_readwrite( "feature", &CvHidHaarTreeNode::feature )    
        .def_readwrite( "left", &CvHidHaarTreeNode::left )    
        .def_readwrite( "right", &CvHidHaarTreeNode::right )    
        .def_readwrite( "threshold", &CvHidHaarTreeNode::threshold );

    bp::class_< CvLSH >( "CvLSH" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvLSH >() );

    bp::class_< CvMSERParams >( "CvMSERParams" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvMSERParams >() )    
        .def_readwrite( "areaThreshold", &CvMSERParams::areaThreshold )    
        .def_readwrite( "delta", &CvMSERParams::delta )    
        .def_readwrite( "edgeBlurSize", &CvMSERParams::edgeBlurSize )    
        .def_readwrite( "maxArea", &CvMSERParams::maxArea )    
        .def_readwrite( "maxEvolution", &CvMSERParams::maxEvolution )    
        .def_readwrite( "maxVariation", &CvMSERParams::maxVariation )    
        .def_readwrite( "minArea", &CvMSERParams::minArea )    
        .def_readwrite( "minDiversity", &CvMSERParams::minDiversity )    
        .def_readwrite( "minMargin", &CvMSERParams::minMargin );

    bp::class_< CvPOSITObject >( "CvPOSITObject" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvPOSITObject >() );

}
