// This file has been generated by Py++.

#include "boost/python.hpp"
#include "__call_policies.pypp.hpp"
#include "__ctypes_integration.pypp.hpp"
#include "cv_hpp_wrapper.hpp"
#include "boost/python/object/life_support.hpp"
#include "cv_hpp_ext_classes_2.pypp.hpp"

namespace bp = boost::python;

struct CascadeClassifier_wrapper : cv::CascadeClassifier, bp::wrapper< cv::CascadeClassifier > {

    CascadeClassifier_wrapper(cv::CascadeClassifier const & arg )
    : cv::CascadeClassifier( arg )
      , bp::wrapper< cv::CascadeClassifier >(){
        // copy constructor
        
    }

    CascadeClassifier_wrapper( )
    : cv::CascadeClassifier( )
      , bp::wrapper< cv::CascadeClassifier >(){
        // null constructor
    
    }

    CascadeClassifier_wrapper(::std::string const & filename )
    : cv::CascadeClassifier( boost::ref(filename) )
      , bp::wrapper< cv::CascadeClassifier >(){
        // constructor
    
    }

    static boost::python::object detectMultiScale( ::cv::CascadeClassifier & inst, ::cv::Mat const & image, double scaleFactor=1.10000000000000008881784197001252323389053344727e+0, int minNeighbors=3, int flags=0, ::cv::Size minSize=cv::Size_<int>() ){
        std::vector<cv::Rect_<int> > objects2;
        inst.detectMultiScale(image, objects2, scaleFactor, minNeighbors, flags, minSize);
        return bp::object( objects2 );
    }

    cv::Mat sum, tilted, sqsum;
    CvMat _sum, _sqsum, _tilted;
    
    int my_runAt( cv::Ptr<cv::FeatureEvaluator> &_feval, const cv::Point &pt )
    {
        if( !oldCascade.empty() )
            return cvRunHaarClassifierCascade(oldCascade, pt, 0);
            
        return runAt(_feval, pt);
    }

        
    bool my_setImage( cv::Ptr<cv::FeatureEvaluator> &_feval, const cv::Mat& image )
    {
        if( !oldCascade.empty() )
        {
            sum.create(image.rows+1, image.cols+1, CV_32S);
            tilted.create(image.rows+1, image.cols+1, CV_32S);
            sqsum.create(image.rows+1, image.cols+1, CV_64F);
            cv::integral(image, sum, sqsum, tilted);
            _sum = sum; _sqsum = sqsum; _tilted = tilted;
            cvSetImagesForHaarClassifierCascade( oldCascade, &_sum, &_sqsum, &_tilted, 1. );
            return true;
        }
        
        return setImage(_feval, image);
    }
    
    std::vector<cv::Point> my_dryRun(const cv::Mat &image)
    {
        std::vector<cv::Point> pts;
        my_setImage(feval, image);
        float bias=0.0001f;
        CvHidHaarClassifierCascade* cascade = oldCascade->hid_cascade;
        int i;
        for(i = 0; i < cascade->count; ++i)
            cascade->stage_classifier[i].threshold += bias;
        cv::Point pt;
        int w1 = oldCascade->orig_window_size.width;
        int h1 = oldCascade->orig_window_size.height;
        int w = image.cols-w1;
        int h = image.rows-h1;
        double mean, var;
        for(pt.y = 0; pt.y < h; ++pt.y)
            for(pt.x = 0; pt.x < w; ++pt.x)
            {
                // mean = ((double)(sum.at<int>(pt.y, pt.x) + sum.at<int>(pt.y+h1, pt.x+w1)
                    // - sum.at<int>(pt.y+h1, pt.x) - sum.at<int>(pt.y, pt.x+w1))) / 
                    // (w1*h1);
                // var = ((double)(sqsum.at<int>(pt.y, pt.x) + sqsum.at<int>(pt.y+h1, pt.x+w1)
                    // - sqsum.at<int>(pt.y+h1, pt.x) - sqsum.at<int>(pt.y, pt.x+w1))) / 
                    // (w1*h1) - mean*mean;
                // if(var <= bias) continue;
                if(my_runAt(feval, pt) > 0) pts.push_back(pt);
            }
        for(i = 0; i < cascade->count; ++i)
            cascade->stage_classifier[i].threshold -= bias;
        return pts;
    }

};

struct FeatureEvaluator_wrapper : cv::FeatureEvaluator, bp::wrapper< cv::FeatureEvaluator > {

    FeatureEvaluator_wrapper(cv::FeatureEvaluator const & arg )
    : cv::FeatureEvaluator( arg )
      , bp::wrapper< cv::FeatureEvaluator >(){
        // copy constructor
        
    }

    FeatureEvaluator_wrapper()
    : cv::FeatureEvaluator()
      , bp::wrapper< cv::FeatureEvaluator >(){
        // null constructor
        
    }

    virtual int calcCat( int featureIdx ) const  {
        if( bp::override func_calcCat = this->get_override( "calcCat" ) )
            return func_calcCat( featureIdx );
        else{
            return this->cv::FeatureEvaluator::calcCat( featureIdx );
        }
    }
    
    int default_calcCat( int featureIdx ) const  {
        return cv::FeatureEvaluator::calcCat( featureIdx );
    }

    virtual double calcOrd( int featureIdx ) const  {
        if( bp::override func_calcOrd = this->get_override( "calcOrd" ) )
            return func_calcOrd( featureIdx );
        else{
            return this->cv::FeatureEvaluator::calcOrd( featureIdx );
        }
    }
    
    double default_calcOrd( int featureIdx ) const  {
        return cv::FeatureEvaluator::calcOrd( featureIdx );
    }

    virtual ::cv::Ptr< cv::FeatureEvaluator > clone(  ) const  {
        if( bp::override func_clone = this->get_override( "clone" ) )
            return func_clone(  );
        else{
            return this->cv::FeatureEvaluator::clone(  );
        }
    }
    
    ::cv::Ptr< cv::FeatureEvaluator > default_clone(  ) const  {
        return cv::FeatureEvaluator::clone( );
    }

    virtual int getFeatureType(  ) const  {
        if( bp::override func_getFeatureType = this->get_override( "getFeatureType" ) )
            return func_getFeatureType(  );
        else{
            return this->cv::FeatureEvaluator::getFeatureType(  );
        }
    }
    
    int default_getFeatureType(  ) const  {
        return cv::FeatureEvaluator::getFeatureType( );
    }

    virtual bool read( ::cv::FileNode const & node ) {
        if( bp::override func_read = this->get_override( "read" ) )
            return func_read( boost::ref(node) );
        else{
            return this->cv::FeatureEvaluator::read( boost::ref(node) );
        }
    }
    
    bool default_read( ::cv::FileNode const & node ) {
        return cv::FeatureEvaluator::read( boost::ref(node) );
    }

    virtual bool setImage( ::cv::Mat const & arg0, ::cv::Size origWinSize ) {
        if( bp::override func_setImage = this->get_override( "setImage" ) )
            return func_setImage( boost::ref(arg0), origWinSize );
        else{
            return this->cv::FeatureEvaluator::setImage( boost::ref(arg0), origWinSize );
        }
    }
    
    bool default_setImage( ::cv::Mat const & arg0, ::cv::Size origWinSize ) {
        return cv::FeatureEvaluator::setImage( boost::ref(arg0), origWinSize );
    }

    virtual bool setWindow( ::cv::Point p ) {
        if( bp::override func_setWindow = this->get_override( "setWindow" ) )
            return func_setWindow( p );
        else{
            return this->cv::FeatureEvaluator::setWindow( p );
        }
    }
    
    bool default_setWindow( ::cv::Point p ) {
        return cv::FeatureEvaluator::setWindow( p );
    }

};

struct FilterEngine_wrapper : cv::FilterEngine, bp::wrapper< cv::FilterEngine > {

    FilterEngine_wrapper(cv::FilterEngine const & arg )
    : cv::FilterEngine( arg )
      , bp::wrapper< cv::FilterEngine >(){
        // copy constructor
        
    }

    FilterEngine_wrapper( )
    : cv::FilterEngine( )
      , bp::wrapper< cv::FilterEngine >(){
        // null constructor
    
    }

    FilterEngine_wrapper(::cv::Ptr< cv::BaseFilter > const & _filter2D, ::cv::Ptr< cv::BaseRowFilter > const & _rowFilter, ::cv::Ptr< cv::BaseColumnFilter > const & _columnFilter, int srcType, int dstType, int bufType, int _rowBorderType=int(::cv::BORDER_REPLICATE), int _columnBorderType=-0x000000001, ::cv::Scalar const & _borderValue=cv::Scalar_<double>() )
    : cv::FilterEngine( boost::ref(_filter2D), boost::ref(_rowFilter), boost::ref(_columnFilter), srcType, dstType, bufType, _rowBorderType, _columnBorderType, boost::ref(_borderValue) )
      , bp::wrapper< cv::FilterEngine >(){
        // constructor
    
    }

    virtual void apply( ::cv::Mat const & src, ::cv::Mat & dst, ::cv::Rect const & srcRoi=cv::Rect_<int>(0, 0, -0x000000001, -0x000000001), ::cv::Point dstOfs=cv::Point_<int>(0, 0), bool isolated=false ) {
        if( bp::override func_apply = this->get_override( "apply" ) )
            func_apply( boost::ref(src), boost::ref(dst), boost::ref(srcRoi), dstOfs, isolated );
        else{
            this->cv::FilterEngine::apply( boost::ref(src), boost::ref(dst), boost::ref(srcRoi), dstOfs, isolated );
        }
    }
    
    void default_apply( ::cv::Mat const & src, ::cv::Mat & dst, ::cv::Rect const & srcRoi=cv::Rect_<int>(0, 0, -0x000000001, -0x000000001), ::cv::Point dstOfs=cv::Point_<int>(0, 0), bool isolated=false ) {
        cv::FilterEngine::apply( boost::ref(src), boost::ref(dst), boost::ref(srcRoi), dstOfs, isolated );
    }

    virtual int start( ::cv::Size wholeSize, ::cv::Rect roi, int maxBufRows=-0x000000001 ) {
        if( bp::override func_start = this->get_override( "start" ) )
            return func_start( wholeSize, roi, maxBufRows );
        else{
            return this->cv::FilterEngine::start( wholeSize, roi, maxBufRows );
        }
    }
    
    int default_start( ::cv::Size wholeSize, ::cv::Rect roi, int maxBufRows=-0x000000001 ) {
        return cv::FilterEngine::start( wholeSize, roi, maxBufRows );
    }

    virtual int start( ::cv::Mat const & src, ::cv::Rect const & srcRoi=cv::Rect_<int>(0, 0, -0x000000001, -0x000000001), bool isolated=false, int maxBufRows=-0x000000001 ) {
        if( bp::override func_start = this->get_override( "start" ) )
            return func_start( boost::ref(src), boost::ref(srcRoi), isolated, maxBufRows );
        else{
            return this->cv::FilterEngine::start( boost::ref(src), boost::ref(srcRoi), isolated, maxBufRows );
        }
    }
    
    int default_start( ::cv::Mat const & src, ::cv::Rect const & srcRoi=cv::Rect_<int>(0, 0, -0x000000001, -0x000000001), bool isolated=false, int maxBufRows=-0x000000001 ) {
        return cv::FilterEngine::start( boost::ref(src), boost::ref(srcRoi), isolated, maxBufRows );
    }

};

static boost::python::object __call___3db7f85e36cc2236e94ccc0caba03336( ::cv::MSER const & inst, ::cv::Mat const & image, ::cv::Mat const & mask ){
    std::vector<std::vector<cv::Point_<int> > > msers2;
    inst.operator()(image, msers2, mask);
    return bp::object( msers2 );
}

static bp::object Ptr_CvHaarClassifierCascade_from_CvHaarClassifierCascade(bp::object const &inst_CvHaarClassifierCascade)
{
    bp::extract<CvHaarClassifierCascade *> elem(inst_CvHaarClassifierCascade);
    if(!elem.check())
    {
        char s[300];
        sprintf( s, "Argument 'inst_CvHaarClassifierCascade' must contain an object of type CvHaarClassifierCascade." );
        PyErr_SetString(PyExc_TypeError, s);
        throw bp::error_already_set();
    }

    bp::object result = bp::object(::cv::Ptr< CvHaarClassifierCascade >(elem()));
    result.attr("_depends") = inst_CvHaarClassifierCascade;
    return result;
}

static CvHaarClassifierCascade const &Ptr_CvHaarClassifierCascade_pointee(::cv::Ptr< CvHaarClassifierCascade > const &inst) { return *((CvHaarClassifierCascade const *)inst); }

static bp::object Ptr_CvStereoBMState_from_CvStereoBMState(bp::object const &inst_CvStereoBMState)
{
    bp::extract<CvStereoBMState *> elem(inst_CvStereoBMState);
    if(!elem.check())
    {
        char s[300];
        sprintf( s, "Argument 'inst_CvStereoBMState' must contain an object of type CvStereoBMState." );
        PyErr_SetString(PyExc_TypeError, s);
        throw bp::error_already_set();
    }

    bp::object result = bp::object(::cv::Ptr< CvStereoBMState >(elem()));
    result.attr("_depends") = inst_CvStereoBMState;
    return result;
}

static CvStereoBMState const &Ptr_CvStereoBMState_pointee(::cv::Ptr< CvStereoBMState > const &inst) { return *((CvStereoBMState const *)inst); }

static bp::object Ptr_BaseColumnFilter_from_BaseColumnFilter(bp::object const &inst_BaseColumnFilter)
{
    bp::extract<cv::BaseColumnFilter *> elem(inst_BaseColumnFilter);
    if(!elem.check())
    {
        char s[300];
        sprintf( s, "Argument 'inst_BaseColumnFilter' must contain an object of type BaseColumnFilter." );
        PyErr_SetString(PyExc_TypeError, s);
        throw bp::error_already_set();
    }

    bp::object result = bp::object(::cv::Ptr< cv::BaseColumnFilter >(elem()));
    result.attr("_depends") = inst_BaseColumnFilter;
    return result;
}

static cv::BaseColumnFilter const &Ptr_BaseColumnFilter_pointee(::cv::Ptr< cv::BaseColumnFilter > const &inst) { return *((cv::BaseColumnFilter const *)inst); }

void register_classes_2(){

    { //::cv::CascadeClassifier
        typedef bp::class_< CascadeClassifier_wrapper > CascadeClassifier_exposer_t;
        CascadeClassifier_exposer_t CascadeClassifier_exposer = CascadeClassifier_exposer_t( "CascadeClassifier", bp::init< >() );
        bp::scope CascadeClassifier_scope( CascadeClassifier_exposer );
        CascadeClassifier_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::CascadeClassifier >() );
        bp::scope().attr("BOOST") = (int)cv::CascadeClassifier::BOOST;
        bp::scope().attr("DO_CANNY_PRUNING") = (int)cv::CascadeClassifier::DO_CANNY_PRUNING;
        bp::scope().attr("SCALE_IMAGE") = (int)cv::CascadeClassifier::SCALE_IMAGE;
        bp::scope().attr("FIND_BIGGEST_OBJECT") = (int)cv::CascadeClassifier::FIND_BIGGEST_OBJECT;
        bp::scope().attr("DO_ROUGH_SEARCH") = (int)cv::CascadeClassifier::DO_ROUGH_SEARCH;
        bp::class_< cv::CascadeClassifier::DTree >( "DTree" )    
            .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::CascadeClassifier::DTree >() )    
            .def_readwrite( "nodeCount", &cv::CascadeClassifier::DTree::nodeCount );
        bp::class_< cv::CascadeClassifier::DTreeNode >( "DTreeNode" )    
            .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::CascadeClassifier::DTreeNode >() )    
            .def_readwrite( "featureIdx", &cv::CascadeClassifier::DTreeNode::featureIdx )    
            .def_readwrite( "left", &cv::CascadeClassifier::DTreeNode::left )    
            .def_readwrite( "right", &cv::CascadeClassifier::DTreeNode::right )    
            .def_readwrite( "threshold", &cv::CascadeClassifier::DTreeNode::threshold );
        bp::class_< cv::CascadeClassifier::Stage >( "Stage" )    
            .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::CascadeClassifier::Stage >() )    
            .def_readwrite( "first", &cv::CascadeClassifier::Stage::first )    
            .def_readwrite( "ntrees", &cv::CascadeClassifier::Stage::ntrees )    
            .def_readwrite( "threshold", &cv::CascadeClassifier::Stage::threshold );
        CascadeClassifier_exposer.def( bp::init< std::string const & >(( bp::arg("filename") )) );
        bp::implicitly_convertible< std::string const &, cv::CascadeClassifier >();
        { //::cv::CascadeClassifier::detectMultiScale
        
            typedef boost::python::object ( *detectMultiScale_function_type )( cv::CascadeClassifier &,cv::Mat const &,double,int,int,::cv::Size );
            
            CascadeClassifier_exposer.def( 
                "detectMultiScale"
                , detectMultiScale_function_type( &CascadeClassifier_wrapper::detectMultiScale )
                , ( bp::arg("inst"), bp::arg("image"), bp::arg("scaleFactor")=1.10000000000000008881784197001252323389053344727e+0, bp::arg("minNeighbors")=(int)(3), bp::arg("flags")=(int)(0), bp::arg("minSize")=cv::Size_<int>() )
                , "\nArgument 'objects':"\
    "\n    C++ type: ::std::vector< cv::Rect_<int> > &"\
    "\n    Python type: vector_Rect"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    objects" );
        
        }
        { //::cv::CascadeClassifier::empty
        
            typedef bool ( ::cv::CascadeClassifier::*empty_function_type )(  ) const;
            
            CascadeClassifier_exposer.def( 
                "empty"
                , empty_function_type( &::cv::CascadeClassifier::empty ) );
        
        }
        { //::cv::CascadeClassifier::load
        
            typedef bool ( ::cv::CascadeClassifier::*load_function_type )( ::std::string const & ) ;
            
            CascadeClassifier_exposer.def( 
                "load"
                , load_function_type( &::cv::CascadeClassifier::load )
                , ( bp::arg("filename") ) );
        
        }
        { //::cv::CascadeClassifier::read
        
            typedef bool ( ::cv::CascadeClassifier::*read_function_type )( ::cv::FileNode const & ) ;
            
            CascadeClassifier_exposer.def( 
                "read"
                , read_function_type( &::cv::CascadeClassifier::read )
                , ( bp::arg("node") ) );
        
        }
        CascadeClassifier_exposer.def_readwrite( "classifiers", &cv::CascadeClassifier::classifiers );
        CascadeClassifier_exposer.def_readwrite( "featureType", &cv::CascadeClassifier::featureType );
        CascadeClassifier_exposer.def_readwrite( "feval", &cv::CascadeClassifier::feval );
        CascadeClassifier_exposer.def_readwrite( "is_stump_based", &cv::CascadeClassifier::is_stump_based );
        CascadeClassifier_exposer.def_readwrite( "leaves", &cv::CascadeClassifier::leaves );
        CascadeClassifier_exposer.def_readwrite( "ncategories", &cv::CascadeClassifier::ncategories );
        CascadeClassifier_exposer.def_readwrite( "nodes", &cv::CascadeClassifier::nodes );
        CascadeClassifier_exposer.def_readwrite( "oldCascade", &cv::CascadeClassifier::oldCascade );
        CascadeClassifier_exposer.def_readwrite( "origWinSize", &cv::CascadeClassifier::origWinSize );
        CascadeClassifier_exposer.def_readwrite( "stageType", &cv::CascadeClassifier::stageType );
        CascadeClassifier_exposer.def_readwrite( "stages", &cv::CascadeClassifier::stages );
        CascadeClassifier_exposer.def_readwrite( "subsets", &cv::CascadeClassifier::subsets );
        CascadeClassifier_exposer.def("runAt", &::CascadeClassifier_wrapper::my_runAt, ( bp::arg("_feval"), bp::arg("pt") ) );
        CascadeClassifier_exposer.def("setImage", &::CascadeClassifier_wrapper::my_setImage, ( bp::arg("_feval"), bp::arg("image") ) );
        CascadeClassifier_exposer.def("runCascade", &::CascadeClassifier_wrapper::my_dryRun, ( bp::arg("image") ) );
    }

    { //::cv::FeatureEvaluator
        typedef bp::class_< FeatureEvaluator_wrapper > FeatureEvaluator_exposer_t;
        FeatureEvaluator_exposer_t FeatureEvaluator_exposer = FeatureEvaluator_exposer_t( "FeatureEvaluator" );
        bp::scope FeatureEvaluator_scope( FeatureEvaluator_exposer );
        FeatureEvaluator_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::FeatureEvaluator >() );
        bp::scope().attr("HAAR") = (int)cv::FeatureEvaluator::HAAR;
        bp::scope().attr("LBP") = (int)cv::FeatureEvaluator::LBP;
        { //::cv::FeatureEvaluator::calcCat
        
            typedef int ( ::cv::FeatureEvaluator::*calcCat_function_type )( int ) const;
            typedef int ( FeatureEvaluator_wrapper::*default_calcCat_function_type )( int ) const;
            
            FeatureEvaluator_exposer.def( 
                "calcCat"
                , calcCat_function_type(&::cv::FeatureEvaluator::calcCat)
                , default_calcCat_function_type(&FeatureEvaluator_wrapper::default_calcCat)
                , ( bp::arg("featureIdx") ) );
        
        }
        { //::cv::FeatureEvaluator::calcOrd
        
            typedef double ( ::cv::FeatureEvaluator::*calcOrd_function_type )( int ) const;
            typedef double ( FeatureEvaluator_wrapper::*default_calcOrd_function_type )( int ) const;
            
            FeatureEvaluator_exposer.def( 
                "calcOrd"
                , calcOrd_function_type(&::cv::FeatureEvaluator::calcOrd)
                , default_calcOrd_function_type(&FeatureEvaluator_wrapper::default_calcOrd)
                , ( bp::arg("featureIdx") ) );
        
        }
        { //::cv::FeatureEvaluator::clone
        
            typedef ::cv::Ptr< cv::FeatureEvaluator > ( ::cv::FeatureEvaluator::*clone_function_type )(  ) const;
            typedef ::cv::Ptr< cv::FeatureEvaluator > ( FeatureEvaluator_wrapper::*default_clone_function_type )(  ) const;
            
            FeatureEvaluator_exposer.def( 
                "clone"
                , clone_function_type(&::cv::FeatureEvaluator::clone)
                , default_clone_function_type(&FeatureEvaluator_wrapper::default_clone) );
        
        }
        { //::cv::FeatureEvaluator::create
        
            typedef ::cv::Ptr< cv::FeatureEvaluator > ( *create_function_type )( int );
            
            FeatureEvaluator_exposer.def( 
                "create"
                , create_function_type( &::cv::FeatureEvaluator::create )
                , ( bp::arg("type") ) );
        
        }
        { //::cv::FeatureEvaluator::getFeatureType
        
            typedef int ( ::cv::FeatureEvaluator::*getFeatureType_function_type )(  ) const;
            typedef int ( FeatureEvaluator_wrapper::*default_getFeatureType_function_type )(  ) const;
            
            FeatureEvaluator_exposer.def( 
                "getFeatureType"
                , getFeatureType_function_type(&::cv::FeatureEvaluator::getFeatureType)
                , default_getFeatureType_function_type(&FeatureEvaluator_wrapper::default_getFeatureType) );
        
        }
        { //::cv::FeatureEvaluator::read
        
            typedef bool ( ::cv::FeatureEvaluator::*read_function_type )( ::cv::FileNode const & ) ;
            typedef bool ( FeatureEvaluator_wrapper::*default_read_function_type )( ::cv::FileNode const & ) ;
            
            FeatureEvaluator_exposer.def( 
                "read"
                , read_function_type(&::cv::FeatureEvaluator::read)
                , default_read_function_type(&FeatureEvaluator_wrapper::default_read)
                , ( bp::arg("node") ) );
        
        }
        { //::cv::FeatureEvaluator::setImage
        
            typedef bool ( ::cv::FeatureEvaluator::*setImage_function_type )( ::cv::Mat const &,::cv::Size ) ;
            typedef bool ( FeatureEvaluator_wrapper::*default_setImage_function_type )( ::cv::Mat const &,::cv::Size ) ;
            
            FeatureEvaluator_exposer.def( 
                "setImage"
                , setImage_function_type(&::cv::FeatureEvaluator::setImage)
                , default_setImage_function_type(&FeatureEvaluator_wrapper::default_setImage)
                , ( bp::arg("arg0"), bp::arg("origWinSize") ) );
        
        }
        { //::cv::FeatureEvaluator::setWindow
        
            typedef bool ( ::cv::FeatureEvaluator::*setWindow_function_type )( ::cv::Point ) ;
            typedef bool ( FeatureEvaluator_wrapper::*default_setWindow_function_type )( ::cv::Point ) ;
            
            FeatureEvaluator_exposer.def( 
                "setWindow"
                , setWindow_function_type(&::cv::FeatureEvaluator::setWindow)
                , default_setWindow_function_type(&FeatureEvaluator_wrapper::default_setWindow)
                , ( bp::arg("p") ) );
        
        }
        FeatureEvaluator_exposer.staticmethod( "create" );
    }

    bp::class_< FilterEngine_wrapper >( "FilterEngine", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::FilterEngine >() )    
        .def( bp::init< cv::Ptr< cv::BaseFilter > const &, cv::Ptr< cv::BaseRowFilter > const &, cv::Ptr< cv::BaseColumnFilter > const &, int, int, int, bp::optional< int, int, cv::Scalar const & > >(( bp::arg("_filter2D"), bp::arg("_rowFilter"), bp::arg("_columnFilter"), bp::arg("srcType"), bp::arg("dstType"), bp::arg("bufType"), bp::arg("_rowBorderType")=int(::cv::BORDER_REPLICATE), bp::arg("_columnBorderType")=(int)(-0x000000001), bp::arg("_borderValue")=cv::Scalar_<double>() )) )    
        .def( 
            "apply"
            , (void ( cv::FilterEngine::* )( ::cv::Mat const &,::cv::Mat &,::cv::Rect const &,::cv::Point,bool ) )(&::cv::FilterEngine::apply)
            , (void ( FilterEngine_wrapper::* )( ::cv::Mat const &,::cv::Mat &,::cv::Rect const &,::cv::Point,bool ) )(&FilterEngine_wrapper::default_apply)
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("srcRoi")=cv::Rect_<int>(0, 0, -0x000000001, -0x000000001), bp::arg("dstOfs")=cv::Point_<int>(0, 0), bp::arg("isolated")=(bool)(false) ) )    
        .def( 
            "init"
            , (void ( cv::FilterEngine::* )( ::cv::Ptr< cv::BaseFilter > const &,::cv::Ptr< cv::BaseRowFilter > const &,::cv::Ptr< cv::BaseColumnFilter > const &,int,int,int,int,int,::cv::Scalar const & ) )( &::cv::FilterEngine::init )
            , ( bp::arg("_filter2D"), bp::arg("_rowFilter"), bp::arg("_columnFilter"), bp::arg("srcType"), bp::arg("dstType"), bp::arg("bufType"), bp::arg("_rowBorderType")=int(::cv::BORDER_REPLICATE), bp::arg("_columnBorderType")=(int)(-0x000000001), bp::arg("_borderValue")=cv::Scalar_<double>() ) )    
        .def( 
            "isSeparable"
            , (bool ( cv::FilterEngine::* )(  ) const)( &::cv::FilterEngine::isSeparable ) )    
        .def( 
            "remainingInputRows"
            , (int ( cv::FilterEngine::* )(  ) const)( &::cv::FilterEngine::remainingInputRows ) )    
        .def( 
            "remainingOutputRows"
            , (int ( cv::FilterEngine::* )(  ) const)( &::cv::FilterEngine::remainingOutputRows ) )    
        .def( 
            "start"
            , (int ( cv::FilterEngine::* )( ::cv::Size,::cv::Rect,int ) )(&::cv::FilterEngine::start)
            , (int ( FilterEngine_wrapper::* )( ::cv::Size,::cv::Rect,int ) )(&FilterEngine_wrapper::default_start)
            , ( bp::arg("wholeSize"), bp::arg("roi"), bp::arg("maxBufRows")=(int)(-0x000000001) ) )    
        .def( 
            "start"
            , (int ( cv::FilterEngine::* )( ::cv::Mat const &,::cv::Rect const &,bool,int ) )(&::cv::FilterEngine::start)
            , (int ( FilterEngine_wrapper::* )( ::cv::Mat const &,::cv::Rect const &,bool,int ) )(&FilterEngine_wrapper::default_start)
            , ( bp::arg("src"), bp::arg("srcRoi")=cv::Rect_<int>(0, 0, -0x000000001, -0x000000001), bp::arg("isolated")=(bool)(false), bp::arg("maxBufRows")=(int)(-0x000000001) ) )    
        .def_readwrite( "anchor", &cv::FilterEngine::anchor )    
        .def_readwrite( "borderElemSize", &cv::FilterEngine::borderElemSize )    
        .def_readwrite( "borderTab", &cv::FilterEngine::borderTab )    
        .def_readwrite( "bufStep", &cv::FilterEngine::bufStep )    
        .def_readwrite( "bufType", &cv::FilterEngine::bufType )    
        .def_readwrite( "columnBorderType", &cv::FilterEngine::columnBorderType )    
        .def_readwrite( "columnFilter", &cv::FilterEngine::columnFilter )    
        .def_readwrite( "constBorderRow", &cv::FilterEngine::constBorderRow )    
        .def_readwrite( "constBorderValue", &cv::FilterEngine::constBorderValue )    
        .def_readwrite( "dstType", &cv::FilterEngine::dstType )    
        .def_readwrite( "dstY", &cv::FilterEngine::dstY )    
        .def_readwrite( "dx1", &cv::FilterEngine::dx1 )    
        .def_readwrite( "dx2", &cv::FilterEngine::dx2 )    
        .def_readwrite( "endY", &cv::FilterEngine::endY )    
        .def_readwrite( "filter2D", &cv::FilterEngine::filter2D )    
        .def_readwrite( "ksize", &cv::FilterEngine::ksize )    
        .def_readwrite( "maxWidth", &cv::FilterEngine::maxWidth )    
        .def_readwrite( "ringBuf", &cv::FilterEngine::ringBuf )    
        .def_readwrite( "roi", &cv::FilterEngine::roi )    
        .def_readwrite( "rowBorderType", &cv::FilterEngine::rowBorderType )    
        .def_readwrite( "rowCount", &cv::FilterEngine::rowCount )    
        .def_readwrite( "rowFilter", &cv::FilterEngine::rowFilter )    
        .def_readwrite( "srcRow", &cv::FilterEngine::srcRow )    
        .def_readwrite( "srcType", &cv::FilterEngine::srcType )    
        .def_readwrite( "startY", &cv::FilterEngine::startY )    
        .def_readwrite( "startY0", &cv::FilterEngine::startY0 )    
        .def_readwrite( "wholeSize", &cv::FilterEngine::wholeSize );

    bp::class_< cv::KalmanFilter >( "KalmanFilter", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::KalmanFilter >() )    
        .def( bp::init< int, int, bp::optional< int > >(( bp::arg("dynamParams"), bp::arg("measureParams"), bp::arg("controlParams")=(int)(0) )) )    
        .def( 
            "correct"
            , (::cv::Mat const & ( cv::KalmanFilter::* )( ::cv::Mat const & ) )( &::cv::KalmanFilter::correct )
            , ( bp::arg("measurement") )
            , bp::return_self< >() )    
        .def( 
            "init"
            , (void ( cv::KalmanFilter::* )( int,int,int ) )( &::cv::KalmanFilter::init )
            , ( bp::arg("dynamParams"), bp::arg("measureParams"), bp::arg("controlParams")=(int)(0) ) )    
        .def( 
            "predict"
            , (::cv::Mat const & ( cv::KalmanFilter::* )( ::cv::Mat const & ) )( &::cv::KalmanFilter::predict )
            , ( bp::arg("control")=cv::Mat() )
            , bp::return_self< >() )    
        .def_readwrite( "controlMatrix", &cv::KalmanFilter::controlMatrix )    
        .def_readwrite( "errorCovPost", &cv::KalmanFilter::errorCovPost )    
        .def_readwrite( "errorCovPre", &cv::KalmanFilter::errorCovPre )    
        .def_readwrite( "gain", &cv::KalmanFilter::gain )    
        .def_readwrite( "measurementMatrix", &cv::KalmanFilter::measurementMatrix )    
        .def_readwrite( "measurementNoiseCov", &cv::KalmanFilter::measurementNoiseCov )    
        .def_readwrite( "processNoiseCov", &cv::KalmanFilter::processNoiseCov )    
        .def_readwrite( "statePost", &cv::KalmanFilter::statePost )    
        .def_readwrite( "statePre", &cv::KalmanFilter::statePre )    
        .def_readwrite( "temp1", &cv::KalmanFilter::temp1 )    
        .def_readwrite( "temp2", &cv::KalmanFilter::temp2 )    
        .def_readwrite( "temp3", &cv::KalmanFilter::temp3 )    
        .def_readwrite( "temp4", &cv::KalmanFilter::temp4 )    
        .def_readwrite( "temp5", &cv::KalmanFilter::temp5 )    
        .def_readwrite( "transitionMatrix", &cv::KalmanFilter::transitionMatrix );

    bp::class_< cv::KeyPoint >( "KeyPoint", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::KeyPoint >() )    
        .def( bp::init< cv::Point2f, float, bp::optional< float, float, int, int > >(( bp::arg("_pt"), bp::arg("_size"), bp::arg("_angle")=-0x000000001, bp::arg("_response")=0, bp::arg("_octave")=(int)(0), bp::arg("_class_id")=(int)(-0x000000001) )) )    
        .def( bp::init< float, float, float, bp::optional< float, float, int, int > >(( bp::arg("x"), bp::arg("y"), bp::arg("_size"), bp::arg("_angle")=-0x000000001, bp::arg("_response")=0, bp::arg("_octave")=(int)(0), bp::arg("_class_id")=(int)(-0x000000001) )) )    
        .def_readwrite( "angle", &cv::KeyPoint::angle )    
        .def_readwrite( "class_id", &cv::KeyPoint::class_id )    
        .def_readwrite( "octave", &cv::KeyPoint::octave )    
        .def_readwrite( "pt", &cv::KeyPoint::pt )    
        .def_readwrite( "response", &cv::KeyPoint::response )    
        .def_readwrite( "size", &cv::KeyPoint::size );

    bp::class_< cv::MSER >( "MSER", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::MSER >() )    
        .def( bp::init< int, int, int, float, float, int, double, double, int >(( bp::arg("_delta"), bp::arg("_min_area"), bp::arg("_max_area"), bp::arg("_max_variation"), bp::arg("_min_diversity"), bp::arg("_max_evolution"), bp::arg("_area_threshold"), bp::arg("_min_margin"), bp::arg("_edge_blur_size") )) )    
        .def( 
            "__call__"
            , (boost::python::object (*)( cv::MSER const &,cv::Mat const &,cv::Mat const & ))( &__call___3db7f85e36cc2236e94ccc0caba03336 )
            , ( bp::arg("inst"), bp::arg("image"), bp::arg("mask") )
            , "\nWrapped function:"
    "\n    operator()"
    "\nArgument 'msers':"\
    "\n    C++ type: ::std::vector< std::vector< cv::Point_<int> > > &"\
    "\n    Python type: vector_vector_Point2i"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    msers" );

    bp::class_< cv::Moments >( "Moments", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Moments >() )    
        .def( bp::init< double, double, double, double, double, double, double, double, double, double >(( bp::arg("m00"), bp::arg("m10"), bp::arg("m01"), bp::arg("m20"), bp::arg("m11"), bp::arg("m02"), bp::arg("m30"), bp::arg("m21"), bp::arg("m12"), bp::arg("m03") )) )    
        .def_readwrite( "m00", &cv::Moments::m00 )    
        .def_readwrite( "m01", &cv::Moments::m01 )    
        .def_readwrite( "m02", &cv::Moments::m02 )    
        .def_readwrite( "m03", &cv::Moments::m03 )    
        .def_readwrite( "m10", &cv::Moments::m10 )    
        .def_readwrite( "m11", &cv::Moments::m11 )    
        .def_readwrite( "m12", &cv::Moments::m12 )    
        .def_readwrite( "m20", &cv::Moments::m20 )    
        .def_readwrite( "m21", &cv::Moments::m21 )    
        .def_readwrite( "m30", &cv::Moments::m30 )    
        .def_readwrite( "mu02", &cv::Moments::mu02 )    
        .def_readwrite( "mu03", &cv::Moments::mu03 )    
        .def_readwrite( "mu11", &cv::Moments::mu11 )    
        .def_readwrite( "mu12", &cv::Moments::mu12 )    
        .def_readwrite( "mu20", &cv::Moments::mu20 )    
        .def_readwrite( "mu21", &cv::Moments::mu21 )    
        .def_readwrite( "mu30", &cv::Moments::mu30 )    
        .def_readwrite( "nu02", &cv::Moments::nu02 )    
        .def_readwrite( "nu03", &cv::Moments::nu03 )    
        .def_readwrite( "nu11", &cv::Moments::nu11 )    
        .def_readwrite( "nu12", &cv::Moments::nu12 )    
        .def_readwrite( "nu20", &cv::Moments::nu20 )    
        .def_readwrite( "nu21", &cv::Moments::nu21 )    
        .def_readwrite( "nu30", &cv::Moments::nu30 );

    { //::cv::Ptr< CvHaarClassifierCascade >
        typedef bp::class_< cv::Ptr< CvHaarClassifierCascade > > Ptr_CvHaarClassifierCascade_exposer_t;
        Ptr_CvHaarClassifierCascade_exposer_t Ptr_CvHaarClassifierCascade_exposer = Ptr_CvHaarClassifierCascade_exposer_t( "Ptr_CvHaarClassifierCascade", bp::init< >() );
        bp::scope Ptr_CvHaarClassifierCascade_scope( Ptr_CvHaarClassifierCascade_exposer );
        Ptr_CvHaarClassifierCascade_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Ptr< CvHaarClassifierCascade > >() );
        { //::cv::Ptr< CvHaarClassifierCascade >::addref
        
            typedef cv::Ptr< CvHaarClassifierCascade > exported_class_t;
            typedef void ( exported_class_t::*addref_function_type )(  ) ;
            
            Ptr_CvHaarClassifierCascade_exposer.def( 
                "addref"
                , addref_function_type( &::cv::Ptr< CvHaarClassifierCascade >::addref ) );
        
        }
        { //::cv::Ptr< CvHaarClassifierCascade >::delete_obj
        
            typedef cv::Ptr< CvHaarClassifierCascade > exported_class_t;
            typedef void ( exported_class_t::*delete_obj_function_type )(  ) ;
            
            Ptr_CvHaarClassifierCascade_exposer.def( 
                "delete_obj"
                , delete_obj_function_type( &::cv::Ptr< CvHaarClassifierCascade >::delete_obj ) );
        
        }
        { //::cv::Ptr< CvHaarClassifierCascade >::empty
        
            typedef cv::Ptr< CvHaarClassifierCascade > exported_class_t;
            typedef bool ( exported_class_t::*empty_function_type )(  ) const;
            
            Ptr_CvHaarClassifierCascade_exposer.def( 
                "empty"
                , empty_function_type( &::cv::Ptr< CvHaarClassifierCascade >::empty ) );
        
        }
        { //::cv::Ptr< CvHaarClassifierCascade >::release
        
            typedef cv::Ptr< CvHaarClassifierCascade > exported_class_t;
            typedef void ( exported_class_t::*release_function_type )(  ) ;
            
            Ptr_CvHaarClassifierCascade_exposer.def( 
                "release"
                , release_function_type( &::cv::Ptr< CvHaarClassifierCascade >::release ) );
        
        }
        Ptr_CvHaarClassifierCascade_exposer.def("fromCvHaarClassifierCascade", &::Ptr_CvHaarClassifierCascade_from_CvHaarClassifierCascade, (bp::arg("inst_CvHaarClassifierCascade")));
        Ptr_CvHaarClassifierCascade_exposer.staticmethod("fromCvHaarClassifierCascade");
        Ptr_CvHaarClassifierCascade_exposer.add_property("pointee", bp::make_function(&::Ptr_CvHaarClassifierCascade_pointee, bp::return_internal_reference<>()));
    }

    { //::cv::Ptr< CvStereoBMState >
        typedef bp::class_< cv::Ptr< CvStereoBMState > > Ptr_CvStereoBMState_exposer_t;
        Ptr_CvStereoBMState_exposer_t Ptr_CvStereoBMState_exposer = Ptr_CvStereoBMState_exposer_t( "Ptr_CvStereoBMState", bp::init< >() );
        bp::scope Ptr_CvStereoBMState_scope( Ptr_CvStereoBMState_exposer );
        Ptr_CvStereoBMState_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Ptr< CvStereoBMState > >() );
        { //::cv::Ptr< CvStereoBMState >::addref
        
            typedef cv::Ptr< CvStereoBMState > exported_class_t;
            typedef void ( exported_class_t::*addref_function_type )(  ) ;
            
            Ptr_CvStereoBMState_exposer.def( 
                "addref"
                , addref_function_type( &::cv::Ptr< CvStereoBMState >::addref ) );
        
        }
        { //::cv::Ptr< CvStereoBMState >::delete_obj
        
            typedef cv::Ptr< CvStereoBMState > exported_class_t;
            typedef void ( exported_class_t::*delete_obj_function_type )(  ) ;
            
            Ptr_CvStereoBMState_exposer.def( 
                "delete_obj"
                , delete_obj_function_type( &::cv::Ptr< CvStereoBMState >::delete_obj ) );
        
        }
        { //::cv::Ptr< CvStereoBMState >::empty
        
            typedef cv::Ptr< CvStereoBMState > exported_class_t;
            typedef bool ( exported_class_t::*empty_function_type )(  ) const;
            
            Ptr_CvStereoBMState_exposer.def( 
                "empty"
                , empty_function_type( &::cv::Ptr< CvStereoBMState >::empty ) );
        
        }
        { //::cv::Ptr< CvStereoBMState >::release
        
            typedef cv::Ptr< CvStereoBMState > exported_class_t;
            typedef void ( exported_class_t::*release_function_type )(  ) ;
            
            Ptr_CvStereoBMState_exposer.def( 
                "release"
                , release_function_type( &::cv::Ptr< CvStereoBMState >::release ) );
        
        }
        Ptr_CvStereoBMState_exposer.def("fromCvStereoBMState", &::Ptr_CvStereoBMState_from_CvStereoBMState, (bp::arg("inst_CvStereoBMState")));
        Ptr_CvStereoBMState_exposer.staticmethod("fromCvStereoBMState");
        Ptr_CvStereoBMState_exposer.add_property("pointee", bp::make_function(&::Ptr_CvStereoBMState_pointee, bp::return_internal_reference<>()));
    }

    { //::cv::Ptr< cv::BaseColumnFilter >
        typedef bp::class_< cv::Ptr< cv::BaseColumnFilter > > Ptr_BaseColumnFilter_exposer_t;
        Ptr_BaseColumnFilter_exposer_t Ptr_BaseColumnFilter_exposer = Ptr_BaseColumnFilter_exposer_t( "Ptr_BaseColumnFilter", bp::init< >() );
        bp::scope Ptr_BaseColumnFilter_scope( Ptr_BaseColumnFilter_exposer );
        Ptr_BaseColumnFilter_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Ptr< cv::BaseColumnFilter > >() );
        { //::cv::Ptr< cv::BaseColumnFilter >::addref
        
            typedef cv::Ptr< cv::BaseColumnFilter > exported_class_t;
            typedef void ( exported_class_t::*addref_function_type )(  ) ;
            
            Ptr_BaseColumnFilter_exposer.def( 
                "addref"
                , addref_function_type( &::cv::Ptr< cv::BaseColumnFilter >::addref ) );
        
        }
        { //::cv::Ptr< cv::BaseColumnFilter >::delete_obj
        
            typedef cv::Ptr< cv::BaseColumnFilter > exported_class_t;
            typedef void ( exported_class_t::*delete_obj_function_type )(  ) ;
            
            Ptr_BaseColumnFilter_exposer.def( 
                "delete_obj"
                , delete_obj_function_type( &::cv::Ptr< cv::BaseColumnFilter >::delete_obj ) );
        
        }
        { //::cv::Ptr< cv::BaseColumnFilter >::empty
        
            typedef cv::Ptr< cv::BaseColumnFilter > exported_class_t;
            typedef bool ( exported_class_t::*empty_function_type )(  ) const;
            
            Ptr_BaseColumnFilter_exposer.def( 
                "empty"
                , empty_function_type( &::cv::Ptr< cv::BaseColumnFilter >::empty ) );
        
        }
        { //::cv::Ptr< cv::BaseColumnFilter >::release
        
            typedef cv::Ptr< cv::BaseColumnFilter > exported_class_t;
            typedef void ( exported_class_t::*release_function_type )(  ) ;
            
            Ptr_BaseColumnFilter_exposer.def( 
                "release"
                , release_function_type( &::cv::Ptr< cv::BaseColumnFilter >::release ) );
        
        }
        Ptr_BaseColumnFilter_exposer.def("fromBaseColumnFilter", &::Ptr_BaseColumnFilter_from_BaseColumnFilter, (bp::arg("inst_BaseColumnFilter")));
        Ptr_BaseColumnFilter_exposer.staticmethod("fromBaseColumnFilter");
        Ptr_BaseColumnFilter_exposer.add_property("pointee", bp::make_function(&::Ptr_BaseColumnFilter_pointee, bp::return_internal_reference<>()));
    }

}
