// This file has been generated by Py++.

#include "boost/python.hpp"
#include "cxcore_hpp_wrapper.hpp"
#include "cxcore_hpp_ext_free_functions.pypp.hpp"

namespace bp = boost::python;

void register_free_functions(){

    { //::cv::LUT
    
        typedef void ( *LUT_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "LUT"
            , LUT_function_type( &::cv::LUT )
            , ( bp::arg("a"), bp::arg("lut"), bp::arg("b") )
            , "\nPerforms a look-up table transform of an array."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-lut" );
    
    }

    { //::cv::Mahalanobis
    
        typedef double ( *Mahalanobis_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const & );
        
        bp::def( 
            "Mahalanobis"
            , Mahalanobis_function_type( &::cv::Mahalanobis )
            , ( bp::arg("v1"), bp::arg("v2"), bp::arg("icovar") )
            , "\nCalculates the Mahalanobis distance between two vectors."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-mahalanobis" );
    
    }

    { //::cv::Mahalonobis
    
        typedef double ( *Mahalonobis_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const & );
        
        bp::def( 
            "Mahalonobis"
            , Mahalonobis_function_type( &::cv::Mahalonobis )
            , ( bp::arg("v1"), bp::arg("v2"), bp::arg("icovar") ) );
    
    }

    { //::cv::absdiff
    
        typedef void ( *absdiff_function_type )( ::cv::MatND const &,::cv::Scalar const &,::cv::MatND & );
        
        bp::def( 
            "absdiff"
            , absdiff_function_type( &::cv::absdiff )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c") )
            , "\nComputes per-element absolute difference between 2 arrays or between "
    "\narray and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#absdiff" );
    
    }

    { //::cv::absdiff
    
        typedef void ( *absdiff_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "absdiff"
            , absdiff_function_type( &::cv::absdiff )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
            , "\nComputes per-element absolute difference between 2 arrays or between "
    "\narray and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#absdiff" );
    
    }

    { //::cv::absdiff
    
        typedef void ( *absdiff_function_type )( ::cv::Mat const &,::cv::Scalar const &,::cv::Mat & );
        
        bp::def( 
            "absdiff"
            , absdiff_function_type( &::cv::absdiff )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c") )
            , "\nComputes per-element absolute difference between 2 arrays or between "
    "\narray and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#absdiff" );
    
    }

    { //::cv::absdiff
    
        typedef void ( *absdiff_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "absdiff"
            , absdiff_function_type( &::cv::absdiff )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
            , "\nComputes per-element absolute difference between 2 arrays or between "
    "\narray and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#absdiff" );
    
    }

    { //::cv::add
    
        typedef void ( *add_function_type )( ::cv::MatND const &,::cv::Scalar const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "add"
            , add_function_type( &::cv::add )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::MatND() )
            , "\nComputes the per-element sum of two arrays or an array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#add" );
    
    }

    { //::cv::add
    
        typedef void ( *add_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "add"
            , add_function_type( &::cv::add )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
            , "\nComputes the per-element sum of two arrays or an array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#add" );
    
    }

    { //::cv::add
    
        typedef void ( *add_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "add"
            , add_function_type( &::cv::add )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask") )
            , "\nComputes the per-element sum of two arrays or an array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#add" );
    
    }

    { //::cv::add
    
        typedef void ( *add_function_type )( ::cv::Mat const &,::cv::Scalar const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "add"
            , add_function_type( &::cv::add )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::Mat() )
            , "\nComputes the per-element sum of two arrays or an array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#add" );
    
    }

    { //::cv::add
    
        typedef void ( *add_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "add"
            , add_function_type( &::cv::add )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
            , "\nComputes the per-element sum of two arrays or an array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#add" );
    
    }

    { //::cv::add
    
        typedef void ( *add_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "add"
            , add_function_type( &::cv::add )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask") )
            , "\nComputes the per-element sum of two arrays or an array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#add" );
    
    }

    { //::cv::addWeighted
    
        typedef void ( *addWeighted_function_type )( ::cv::MatND const &,double,::cv::MatND const &,double,double,::cv::MatND & );
        
        bp::def( 
            "addWeighted"
            , addWeighted_function_type( &::cv::addWeighted )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("b"), bp::arg("beta"), bp::arg("gamma"), bp::arg("c") )
            , "\nComputes the weighted sum of two arrays."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#addweighted" );
    
    }

    { //::cv::addWeighted
    
        typedef void ( *addWeighted_function_type )( ::cv::Mat const &,double,::cv::Mat const &,double,double,::cv::Mat & );
        
        bp::def( 
            "addWeighted"
            , addWeighted_function_type( &::cv::addWeighted )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("b"), bp::arg("beta"), bp::arg("gamma"), bp::arg("c") )
            , "\nComputes the weighted sum of two arrays."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#addweighted" );
    
    }

    { //::cv::bitwise_and
    
        typedef void ( *bitwise_and_function_type )( ::cv::MatND const &,::cv::Scalar const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "bitwise_and"
            , bitwise_and_function_type( &::cv::bitwise_and )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::MatND() )
            , "\nCalculates per-element bit-wise conjunction of two arrays and an "
    "\narray and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-bitwise-and" );
    
    }

    { //::cv::bitwise_and
    
        typedef void ( *bitwise_and_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "bitwise_and"
            , bitwise_and_function_type( &::cv::bitwise_and )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask")=cv::MatND() )
            , "\nCalculates per-element bit-wise conjunction of two arrays and an "
    "\narray and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-bitwise-and" );
    
    }

    { //::cv::bitwise_and
    
        typedef void ( *bitwise_and_function_type )( ::cv::Mat const &,::cv::Scalar const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "bitwise_and"
            , bitwise_and_function_type( &::cv::bitwise_and )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::Mat() )
            , "\nCalculates per-element bit-wise conjunction of two arrays and an "
    "\narray and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-bitwise-and" );
    
    }

    { //::cv::bitwise_and
    
        typedef void ( *bitwise_and_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "bitwise_and"
            , bitwise_and_function_type( &::cv::bitwise_and )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask")=cv::Mat() )
            , "\nCalculates per-element bit-wise conjunction of two arrays and an "
    "\narray and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-bitwise-and" );
    
    }

    { //::cv::bitwise_not
    
        typedef void ( *bitwise_not_function_type )( ::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "bitwise_not"
            , bitwise_not_function_type( &::cv::bitwise_not )
            , ( bp::arg("a"), bp::arg("c") )
            , "\nInverts every bit of array."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-bitwise-not" );
    
    }

    { //::cv::bitwise_not
    
        typedef void ( *bitwise_not_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "bitwise_not"
            , bitwise_not_function_type( &::cv::bitwise_not )
            , ( bp::arg("a"), bp::arg("c") )
            , "\nInverts every bit of array."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-bitwise-not" );
    
    }

    { //::cv::bitwise_or
    
        typedef void ( *bitwise_or_function_type )( ::cv::MatND const &,::cv::Scalar const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "bitwise_or"
            , bitwise_or_function_type( &::cv::bitwise_or )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::MatND() )
            , "\nCalculates per-element bit-wise disjunction of two arrays and an "
    "\narray and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-bitwise-or" );
    
    }

    { //::cv::bitwise_or
    
        typedef void ( *bitwise_or_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "bitwise_or"
            , bitwise_or_function_type( &::cv::bitwise_or )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask")=cv::MatND() )
            , "\nCalculates per-element bit-wise disjunction of two arrays and an "
    "\narray and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-bitwise-or" );
    
    }

    { //::cv::bitwise_or
    
        typedef void ( *bitwise_or_function_type )( ::cv::Mat const &,::cv::Scalar const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "bitwise_or"
            , bitwise_or_function_type( &::cv::bitwise_or )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::Mat() )
            , "\nCalculates per-element bit-wise disjunction of two arrays and an "
    "\narray and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-bitwise-or" );
    
    }

    { //::cv::bitwise_or
    
        typedef void ( *bitwise_or_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "bitwise_or"
            , bitwise_or_function_type( &::cv::bitwise_or )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask")=cv::Mat() )
            , "\nCalculates per-element bit-wise disjunction of two arrays and an "
    "\narray and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-bitwise-or" );
    
    }

    { //::cv::bitwise_xor
    
        typedef void ( *bitwise_xor_function_type )( ::cv::MatND const &,::cv::Scalar const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "bitwise_xor"
            , bitwise_xor_function_type( &::cv::bitwise_xor )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::MatND() )
            , "\nCalculates per-element bit-wise 'exclusive or' operation on two "
    "\narrays and an array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-bitwise-xor" );
    
    }

    { //::cv::bitwise_xor
    
        typedef void ( *bitwise_xor_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "bitwise_xor"
            , bitwise_xor_function_type( &::cv::bitwise_xor )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask")=cv::MatND() )
            , "\nCalculates per-element bit-wise 'exclusive or' operation on two "
    "\narrays and an array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-bitwise-xor" );
    
    }

    { //::cv::bitwise_xor
    
        typedef void ( *bitwise_xor_function_type )( ::cv::Mat const &,::cv::Scalar const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "bitwise_xor"
            , bitwise_xor_function_type( &::cv::bitwise_xor )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::Mat() )
            , "\nCalculates per-element bit-wise 'exclusive or' operation on two "
    "\narrays and an array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-bitwise-xor" );
    
    }

    { //::cv::bitwise_xor
    
        typedef void ( *bitwise_xor_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "bitwise_xor"
            , bitwise_xor_function_type( &::cv::bitwise_xor )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask")=cv::Mat() )
            , "\nCalculates per-element bit-wise 'exclusive or' operation on two "
    "\narrays and an array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-bitwise-xor" );
    
    }

    { //::cv::calcCovarMatrix
    
        typedef void ( *calcCovarMatrix_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,int,int );
        
        bp::def( 
            "calcCovarMatrix"
            , calcCovarMatrix_function_type( &::cv::calcCovarMatrix )
            , ( bp::arg("samples"), bp::arg("covar"), bp::arg("mean"), bp::arg("flags"), bp::arg("ctype")=(int)(6) )
            , "\nCalculates covariation matrix of a set of vectors."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#calccovarmatrix" );
    
    }

    { //::cv::calcCovarMatrix
    
        typedef void ( *calcCovarMatrix_function_type )( ::cv::Mat const *,int,::cv::Mat &,::cv::Mat &,int,int );
        
        bp::def( 
            "calcCovarMatrix"
            , calcCovarMatrix_function_type( &::cv::calcCovarMatrix )
            , ( bp::arg("samples"), bp::arg("nsamples"), bp::arg("covar"), bp::arg("mean"), bp::arg("flags"), bp::arg("ctype")=(int)(6) )
            , "\nCalculates covariation matrix of a set of vectors."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#calccovarmatrix" );
    
    }

    { //::cv::cartToPolar
    
        typedef void ( *cartToPolar_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat &,bool );
        
        bp::def( 
            "cartToPolar"
            , cartToPolar_function_type( &::cv::cartToPolar )
            , ( bp::arg("x"), bp::arg("y"), bp::arg("magnitude"), bp::arg("angle"), bp::arg("angleInDegrees")=(bool)(false) )
            , "\nCalculates the magnitude and angle of 2d vectors."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#carttopolar" );
    
    }

    { //::cv::checkHardwareSupport
    
        typedef bool ( *checkHardwareSupport_function_type )( int );
        
        bp::def( 
            "checkHardwareSupport"
            , checkHardwareSupport_function_type( &::cv::checkHardwareSupport )
            , ( bp::arg("feature") ) );
    
    }

    { //::cv::circle
    
        typedef void ( *circle_function_type )( ::cv::Mat &,::cv::Point,int,::cv::Scalar const &,int,int,int );
        
        bp::def( 
            "circle"
            , circle_function_type( &::cv::circle )
            , ( bp::arg("img"), bp::arg("center"), bp::arg("radius"), bp::arg("color"), bp::arg("thickness")=(int)(1), bp::arg("lineType")=(int)(8), bp::arg("shift")=(int)(0) )
            , "\nDraws a circle."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/drawing_functions.html#cv-circle" );
    
    }

    { //::cv::clipLine
    
        typedef bool ( *clipLine_function_type )( ::cv::Rect,::cv::Point &,::cv::Point & );
        
        bp::def( 
            "clipLine"
            , clipLine_function_type( &::cv::clipLine )
            , ( bp::arg("img_rect"), bp::arg("pt1"), bp::arg("pt2") )
            , "\nClips the line against the image rectangle."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/drawing_functions.html#cv-clipline" );
    
    }

    { //::cv::clipLine
    
        typedef bool ( *clipLine_function_type )( ::cv::Size,::cv::Point &,::cv::Point & );
        
        bp::def( 
            "clipLine"
            , clipLine_function_type( &::cv::clipLine )
            , ( bp::arg("imgSize"), bp::arg("pt1"), bp::arg("pt2") )
            , "\nClips the line against the image rectangle."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/drawing_functions.html#cv-clipline" );
    
    }

    { //::cv::compare
    
        typedef void ( *compare_function_type )( ::cv::MatND const &,double,::cv::MatND &,int );
        
        bp::def( 
            "compare"
            , compare_function_type( &::cv::compare )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("cmpop") )
            , "\nPerforms per-element comparison of two arrays or an array and scalar "
    "\nvalue."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#compare" );
    
    }

    { //::cv::compare
    
        typedef void ( *compare_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,int );
        
        bp::def( 
            "compare"
            , compare_function_type( &::cv::compare )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("cmpop") )
            , "\nPerforms per-element comparison of two arrays or an array and scalar "
    "\nvalue."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#compare" );
    
    }

    { //::cv::compare
    
        typedef void ( *compare_function_type )( ::cv::Mat const &,double,::cv::Mat &,int );
        
        bp::def( 
            "compare"
            , compare_function_type( &::cv::compare )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("cmpop") )
            , "\nPerforms per-element comparison of two arrays or an array and scalar "
    "\nvalue."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#compare" );
    
    }

    { //::cv::compare
    
        typedef void ( *compare_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "compare"
            , compare_function_type( &::cv::compare )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("cmpop") )
            , "\nPerforms per-element comparison of two arrays or an array and scalar "
    "\nvalue."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#compare" );
    
    }

    { //::cv::completeSymm
    
        typedef void ( *completeSymm_function_type )( ::cv::Mat &,bool );
        
        bp::def( 
            "completeSymm"
            , completeSymm_function_type( &::cv::completeSymm )
            , ( bp::arg("a"), bp::arg("lowerToUpper")=(bool)(false) )
            , "\nCopies the lower or the upper half of a square matrix to another half."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#completesymm" );
    
    }

    { //::cv::convertScaleAbs
    
        typedef void ( *convertScaleAbs_function_type )( ::cv::Mat const &,::cv::Mat &,double,double );
        
        bp::def( 
            "convertScaleAbs"
            , convertScaleAbs_function_type( &::cv::convertScaleAbs )
            , ( bp::arg("a"), bp::arg("c"), bp::arg("alpha")=1, bp::arg("beta")=0 )
            , "\nScales, computes absolute values and converts the result to 8-bit."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#convertscaleabs" );
    
    }

    { //::cv::countNonZero
    
        typedef int ( *countNonZero_function_type )( ::cv::MatND const & );
        
        bp::def( 
            "countNonZero"
            , countNonZero_function_type( &::cv::countNonZero )
            , ( bp::arg("m") )
            , "\nCounts non-zero array elements."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#countnonzero" );
    
    }

    { //::cv::countNonZero
    
        typedef int ( *countNonZero_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "countNonZero"
            , countNonZero_function_type( &::cv::countNonZero )
            , ( bp::arg("m") )
            , "\nCounts non-zero array elements."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#countnonzero" );
    
    }

    { //::cv::cubeRoot
    
        typedef float ( *cubeRoot_function_type )( float );
        
        bp::def( 
            "cubeRoot"
            , cubeRoot_function_type( &::cv::cubeRoot )
            , ( bp::arg("val") )
            , "\nComputes cube root of the argument."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-cuberoot" );
    
    }

    { //::cv::dct
    
        typedef void ( *dct_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "dct"
            , dct_function_type( &::cv::dct )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("flags")=(int)(0) )
            , "\nPerforms a forward or inverse discrete cosine transform of 1D or 2D "
    "\narray."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-dct" );
    
    }

    { //::cv::determinant
    
        typedef double ( *determinant_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "determinant"
            , determinant_function_type( &::cv::determinant )
            , ( bp::arg("m") )
            , "\nReturns determinant of a square floating-point matrix."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-determinant" );
    
    }

    { //::cv::dft
    
        typedef void ( *dft_function_type )( ::cv::Mat const &,::cv::Mat &,int,int );
        
        bp::def( 
            "dft"
            , dft_function_type( &::cv::dft )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("flags")=(int)(0), bp::arg("nonzeroRows")=(int)(0) )
            , "\nPerforms a forward or inverse Discrete Fourier transform of 1D or 2D "
    "\nfloating-point array."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-dft" );
    
    }

    { //::cv::divide
    
        typedef void ( *divide_function_type )( double,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "divide"
            , divide_function_type( &::cv::divide )
            , ( bp::arg("scale"), bp::arg("b"), bp::arg("c") )
            , "\nPerforms per-element division of two arrays or a scalar by an array."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-divide" );
    
    }

    { //::cv::divide
    
        typedef void ( *divide_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,double );
        
        bp::def( 
            "divide"
            , divide_function_type( &::cv::divide )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("scale")=1 )
            , "\nPerforms per-element division of two arrays or a scalar by an array."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-divide" );
    
    }

    { //::cv::divide
    
        typedef void ( *divide_function_type )( double,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "divide"
            , divide_function_type( &::cv::divide )
            , ( bp::arg("scale"), bp::arg("b"), bp::arg("c") )
            , "\nPerforms per-element division of two arrays or a scalar by an array."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-divide" );
    
    }

    { //::cv::divide
    
        typedef void ( *divide_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,double );
        
        bp::def( 
            "divide"
            , divide_function_type( &::cv::divide )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("scale")=1 )
            , "\nPerforms per-element division of two arrays or a scalar by an array."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-divide" );
    
    }

    { //::cv::eigen
    
        typedef bool ( *eigen_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,int,int );
        
        bp::def( 
            "eigen"
            , eigen_function_type( &::cv::eigen )
            , ( bp::arg("a"), bp::arg("eigenvalues"), bp::arg("eigenvectors"), bp::arg("lowindex")=(int)(-0x000000001), bp::arg("highindex")=(int)(-0x000000001) )
            , "\nComputes eigenvalues and eigenvectors of a symmetric matrix."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-eigen" );
    
    }

    { //::cv::eigen
    
        typedef bool ( *eigen_function_type )( ::cv::Mat const &,::cv::Mat &,int,int );
        
        bp::def( 
            "eigen"
            , eigen_function_type( &::cv::eigen )
            , ( bp::arg("a"), bp::arg("eigenvalues"), bp::arg("lowindex")=(int)(-0x000000001), bp::arg("highindex")=(int)(-0x000000001) )
            , "\nComputes eigenvalues and eigenvectors of a symmetric matrix."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-eigen" );
    
    }

    { //::cv::ellipse
    
        typedef void ( *ellipse_function_type )( ::cv::Mat &,::cv::RotatedRect const &,::cv::Scalar const &,int,int );
        
        bp::def( 
            "ellipse"
            , ellipse_function_type( &::cv::ellipse )
            , ( bp::arg("img"), bp::arg("box"), bp::arg("color"), bp::arg("thickness")=(int)(1), bp::arg("lineType")=(int)(8) ) );
    
    }

    { //::cv::ellipse
    
        typedef void ( *ellipse_function_type )( ::cv::Mat &,::cv::Point,::cv::Size,double,double,double,::cv::Scalar const &,int,int,int );
        
        bp::def( 
            "ellipse"
            , ellipse_function_type( &::cv::ellipse )
            , ( bp::arg("img"), bp::arg("center"), bp::arg("axes"), bp::arg("angle"), bp::arg("startAngle"), bp::arg("endAngle"), bp::arg("color"), bp::arg("thickness")=(int)(1), bp::arg("lineType")=(int)(8), bp::arg("shift")=(int)(0) ) );
    
    }

    { //::cv::ellipse2Poly
    
        typedef void ( *ellipse2Poly_function_type )( ::cv::Point,::cv::Size,int,int,int,int,::std::vector< cv::Point_<int> > & );
        
        bp::def( 
            "ellipse2Poly"
            , ellipse2Poly_function_type( &::cv::ellipse2Poly )
            , ( bp::arg("center"), bp::arg("axes"), bp::arg("angle"), bp::arg("arcStart"), bp::arg("arcEnd"), bp::arg("delta"), bp::arg("pts") )
            , "\nApproximates an elliptic arc with a polyline."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/drawing_functions.html#cv-ellipse2poly" );
    
    }

    { //::cv::exp
    
        typedef void ( *exp_function_type )( ::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "exp"
            , exp_function_type( &::cv::exp )
            , ( bp::arg("a"), bp::arg("b") )
            , "\nCalculates the exponent of every array element."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-exp" );
    
    }

    { //::cv::exp
    
        typedef void ( *exp_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "exp"
            , exp_function_type( &::cv::exp )
            , ( bp::arg("a"), bp::arg("b") )
            , "\nCalculates the exponent of every array element."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-exp" );
    
    }

    { //::cv::fastAtan2
    
        typedef float ( *fastAtan2_function_type )( float,float );
        
        bp::def( 
            "fastAtan2"
            , fastAtan2_function_type( &::cv::fastAtan2 )
            , ( bp::arg("y"), bp::arg("x") )
            , "\nCalculates the angle of a 2D vector in degrees."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-fastatan2" );
    
    }

    { //::cv::flip
    
        typedef void ( *flip_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "flip"
            , flip_function_type( &::cv::flip )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("flipCode") )
            , "\nFlips a 2D array around vertical, horizontal or both axes."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-flip" );
    
    }

    { //::cv::fromUtf16
    
        typedef ::std::string ( *fromUtf16_function_type )( ::cv::WString const & );
        
        bp::def( 
            "fromUtf16"
            , fromUtf16_function_type( &::cv::fromUtf16 )
            , ( bp::arg("str") ) );
    
    }

    { //::cv::gemm
    
        typedef void ( *gemm_function_type )( ::cv::Mat const &,::cv::Mat const &,double,::cv::Mat const &,double,::cv::Mat &,int );
        
        bp::def( 
            "gemm"
            , gemm_function_type( &::cv::gemm )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("alpha"), bp::arg("c"), bp::arg("gamma"), bp::arg("d"), bp::arg("flags")=(int)(0) )
            , "\nPerforms generalized matrix multiplication."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-gemm" );
    
    }

    { //::cv::getCPUTickCount
    
        typedef ::int64 ( *getCPUTickCount_function_type )(  );
        
        bp::def( 
            "getCPUTickCount"
            , getCPUTickCount_function_type( &::cv::getCPUTickCount ) );
    
    }

    { //::cv::getElemSize
    
        typedef ::size_t ( *getElemSize_function_type )( int );
        
        bp::def( 
            "getElemSize"
            , getElemSize_function_type( &::cv::getElemSize )
            , ( bp::arg("type") ) );
    
    }

    { //::cv::getNumThreads
    
        typedef int ( *getNumThreads_function_type )(  );
        
        bp::def( 
            "getNumThreads"
            , getNumThreads_function_type( &::cv::getNumThreads ) );
    
    }

    { //::cv::getOptimalDFTSize
    
        typedef int ( *getOptimalDFTSize_function_type )( int );
        
        bp::def( 
            "getOptimalDFTSize"
            , getOptimalDFTSize_function_type( &::cv::getOptimalDFTSize )
            , ( bp::arg("vecsize") )
            , "\nReturns optimal DFT size for a given vector size."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-getoptimaldftsize" );
    
    }

    { //::cv::getThreadNum
    
        typedef int ( *getThreadNum_function_type )(  );
        
        bp::def( 
            "getThreadNum"
            , getThreadNum_function_type( &::cv::getThreadNum ) );
    
    }

    { //::cv::getTickCount
    
        typedef ::int64 ( *getTickCount_function_type )(  );
        
        bp::def( 
            "getTickCount"
            , getTickCount_function_type( &::cv::getTickCount ) );
    
    }

    { //::cv::getTickFrequency
    
        typedef double ( *getTickFrequency_function_type )(  );
        
        bp::def( 
            "getTickFrequency"
            , getTickFrequency_function_type( &::cv::getTickFrequency ) );
    
    }

    { //::cv::idct
    
        typedef void ( *idct_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "idct"
            , idct_function_type( &::cv::idct )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("flags")=(int)(0) )
            , "\nComputes inverse Discrete Cosine Transform of a 1D or 2D array."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-idct" );
    
    }

    { //::cv::idft
    
        typedef void ( *idft_function_type )( ::cv::Mat const &,::cv::Mat &,int,int );
        
        bp::def( 
            "idft"
            , idft_function_type( &::cv::idft )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("flags")=(int)(0), bp::arg("nonzeroRows")=(int)(0) )
            , "\nComputes inverse Discrete Fourier Transform of a 1D or 2D array."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-idft" );
    
    }

    { //::cv::inRange
    
        typedef void ( *inRange_function_type )( ::cv::MatND const &,::cv::Scalar const &,::cv::Scalar const &,::cv::MatND & );
        
        bp::def( 
            "inRange"
            , inRange_function_type( &::cv::inRange )
            , ( bp::arg("src"), bp::arg("lowerb"), bp::arg("upperb"), bp::arg("dst") )
            , "\nChecks if array elements lie between the elements of two other arrays."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-inrange" );
    
    }

    { //::cv::inRange
    
        typedef void ( *inRange_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "inRange"
            , inRange_function_type( &::cv::inRange )
            , ( bp::arg("src"), bp::arg("lowerb"), bp::arg("upperb"), bp::arg("dst") )
            , "\nChecks if array elements lie between the elements of two other arrays."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-inrange" );
    
    }

    { //::cv::inRange
    
        typedef void ( *inRange_function_type )( ::cv::Mat const &,::cv::Scalar const &,::cv::Scalar const &,::cv::Mat & );
        
        bp::def( 
            "inRange"
            , inRange_function_type( &::cv::inRange )
            , ( bp::arg("src"), bp::arg("lowerb"), bp::arg("upperb"), bp::arg("dst") )
            , "\nChecks if array elements lie between the elements of two other arrays."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-inrange" );
    
    }

    { //::cv::inRange
    
        typedef void ( *inRange_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "inRange"
            , inRange_function_type( &::cv::inRange )
            , ( bp::arg("src"), bp::arg("lowerb"), bp::arg("upperb"), bp::arg("dst") )
            , "\nChecks if array elements lie between the elements of two other arrays."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-inrange" );
    
    }

    { //::cv::invert
    
        typedef double ( *invert_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "invert"
            , invert_function_type( &::cv::invert )
            , ( bp::arg("a"), bp::arg("c"), bp::arg("flags")=int(::cv::DECOMP_LU) )
            , "\nFinds the inverse or pseudo-inverse of a matrix."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-invert" );
    
    }

    { //::cv::line
    
        typedef void ( *line_function_type )( ::cv::Mat &,::cv::Point,::cv::Point,::cv::Scalar const &,int,int,int );
        
        bp::def( 
            "line"
            , line_function_type( &::cv::line )
            , ( bp::arg("img"), bp::arg("pt1"), bp::arg("pt2"), bp::arg("color"), bp::arg("thickness")=(int)(1), bp::arg("lineType")=(int)(8), bp::arg("shift")=(int)(0) )
            , "\nDraws a line segment connecting two points."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/drawing_functions.html#cv-line" );
    
    }

    { //::cv::log
    
        typedef void ( *log_function_type )( ::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "log"
            , log_function_type( &::cv::log )
            , ( bp::arg("a"), bp::arg("b") )
            , "\nCalculates the natural logarithm of every array element."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-log" );
    
    }

    { //::cv::log
    
        typedef void ( *log_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "log"
            , log_function_type( &::cv::log )
            , ( bp::arg("a"), bp::arg("b") )
            , "\nCalculates the natural logarithm of every array element."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-log" );
    
    }

    { //::cv::magnitude
    
        typedef void ( *magnitude_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "magnitude"
            , magnitude_function_type( &::cv::magnitude )
            , ( bp::arg("x"), bp::arg("y"), bp::arg("magnitude") )
            , "\nCalculates magnitude of 2D vectors."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-magnitude" );
    
    }

    { //::cv::max
    
        typedef void ( *max_function_type )( ::cv::MatND const &,double,::cv::MatND & );
        
        bp::def( 
            "max"
            , max_function_type( &::cv::max )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("c") )
            , "\nCalculates per-element maximum of two arrays or array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-max" );
    
    }

    { //::cv::max
    
        typedef void ( *max_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "max"
            , max_function_type( &::cv::max )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
            , "\nCalculates per-element maximum of two arrays or array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-max" );
    
    }

    { //::cv::max
    
        typedef void ( *max_function_type )( ::cv::Mat const &,double,::cv::Mat & );
        
        bp::def( 
            "max"
            , max_function_type( &::cv::max )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("c") )
            , "\nCalculates per-element maximum of two arrays or array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-max" );
    
    }

    { //::cv::max
    
        typedef void ( *max_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "max"
            , max_function_type( &::cv::max )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
            , "\nCalculates per-element maximum of two arrays or array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-max" );
    
    }

    { //::cv::mean
    
        typedef ::cv::Scalar ( *mean_function_type )( ::cv::MatND const &,::cv::MatND const & );
        
        bp::def( 
            "mean"
            , mean_function_type( &::cv::mean )
            , ( bp::arg("m"), bp::arg("mask") )
            , "\nCalculates average (mean) of array elements."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-mean" );
    
    }

    { //::cv::mean
    
        typedef ::cv::Scalar ( *mean_function_type )( ::cv::MatND const & );
        
        bp::def( 
            "mean"
            , mean_function_type( &::cv::mean )
            , ( bp::arg("m") )
            , "\nCalculates average (mean) of array elements."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-mean" );
    
    }

    { //::cv::mean
    
        typedef ::cv::Scalar ( *mean_function_type )( ::cv::Mat const &,::cv::Mat const & );
        
        bp::def( 
            "mean"
            , mean_function_type( &::cv::mean )
            , ( bp::arg("m"), bp::arg("mask") )
            , "\nCalculates average (mean) of array elements."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-mean" );
    
    }

    { //::cv::mean
    
        typedef ::cv::Scalar ( *mean_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "mean"
            , mean_function_type( &::cv::mean )
            , ( bp::arg("m") )
            , "\nCalculates average (mean) of array elements."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-mean" );
    
    }

    { //::cv::meanStdDev
    
        typedef void ( *meanStdDev_function_type )( ::cv::MatND const &,::cv::Scalar &,::cv::Scalar &,::cv::MatND const & );
        
        bp::def( 
            "meanStdDev"
            , meanStdDev_function_type( &::cv::meanStdDev )
            , ( bp::arg("m"), bp::arg("mean"), bp::arg("stddev"), bp::arg("mask")=cv::MatND() )
            , "\nCalculates mean and standard deviation of array elements."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-meanstddev" );
    
    }

    { //::cv::meanStdDev
    
        typedef void ( *meanStdDev_function_type )( ::cv::Mat const &,::cv::Scalar &,::cv::Scalar &,::cv::Mat const & );
        
        bp::def( 
            "meanStdDev"
            , meanStdDev_function_type( &::cv::meanStdDev )
            , ( bp::arg("m"), bp::arg("mean"), bp::arg("stddev"), bp::arg("mask")=cv::Mat() )
            , "\nCalculates mean and standard deviation of array elements."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-meanstddev" );
    
    }

    { //::cv::merge
    
        typedef void ( *merge_function_type )( ::std::vector< cv::MatND > const &,::cv::MatND & );
        
        bp::def( 
            "merge"
            , merge_function_type( &::cv::merge )
            , ( bp::arg("mv"), bp::arg("dst") )
            , "\nComposes a multi-channel array from several single-channel arrays."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-merge" );
    
    }

    { //::cv::merge
    
        typedef void ( *merge_function_type )( ::std::vector< cv::Mat > const &,::cv::Mat & );
        
        bp::def( 
            "merge"
            , merge_function_type( &::cv::merge )
            , ( bp::arg("mv"), bp::arg("dst") )
            , "\nComposes a multi-channel array from several single-channel arrays."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-merge" );
    
    }

    { //::cv::min
    
        typedef void ( *min_function_type )( ::cv::MatND const &,double,::cv::MatND & );
        
        bp::def( 
            "min"
            , min_function_type( &::cv::min )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("c") )
            , "\nCalculates per-element minimum of two arrays or array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-min" );
    
    }

    { //::cv::min
    
        typedef void ( *min_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "min"
            , min_function_type( &::cv::min )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
            , "\nCalculates per-element minimum of two arrays or array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-min" );
    
    }

    { //::cv::min
    
        typedef void ( *min_function_type )( ::cv::Mat const &,double,::cv::Mat & );
        
        bp::def( 
            "min"
            , min_function_type( &::cv::min )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("c") )
            , "\nCalculates per-element minimum of two arrays or array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-min" );
    
    }

    { //::cv::min
    
        typedef void ( *min_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "min"
            , min_function_type( &::cv::min )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
            , "\nCalculates per-element minimum of two arrays or array and a scalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-min" );
    
    }

    { //::cv::mulSpectrums
    
        typedef void ( *mulSpectrums_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,int,bool );
        
        bp::def( 
            "mulSpectrums"
            , mulSpectrums_function_type( &::cv::mulSpectrums )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("flags"), bp::arg("conjB")=(bool)(false) )
            , "\nPerforms per-element multiplication of two Fourier spectrums."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-mulspectrums" );
    
    }

    { //::cv::mulTransposed
    
        typedef void ( *mulTransposed_function_type )( ::cv::Mat const &,::cv::Mat &,bool,::cv::Mat const &,double,int );
        
        bp::def( 
            "mulTransposed"
            , mulTransposed_function_type( &::cv::mulTransposed )
            , ( bp::arg("a"), bp::arg("c"), bp::arg("aTa"), bp::arg("delta")=cv::Mat(), bp::arg("scale")=1, bp::arg("rtype")=(int)(-0x000000001) )
            , "\nCalculates the product of a matrix and its transposition."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-multransposed" );
    
    }

    { //::cv::multiply
    
        typedef void ( *multiply_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,double );
        
        bp::def( 
            "multiply"
            , multiply_function_type( &::cv::multiply )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("scale")=1 )
            , "\nCalculates the per-element scaled product of two arrays."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-multiply" );
    
    }

    { //::cv::multiply
    
        typedef void ( *multiply_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,double );
        
        bp::def( 
            "multiply"
            , multiply_function_type( &::cv::multiply )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("scale")=1 )
            , "\nCalculates the per-element scaled product of two arrays."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-multiply" );
    
    }

    { //::cv::norm
    
        typedef double ( *norm_function_type )( ::cv::SparseMat const &,int );
        
        bp::def( 
            "norm"
            , norm_function_type( &::cv::norm )
            , ( bp::arg("src"), bp::arg("normType") )
            , "\nCalculates absolute array norm, absolute difference norm, or relative "
    "\ndifference norm."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-norm" );
    
    }

    { //::cv::norm
    
        typedef double ( *norm_function_type )( ::cv::MatND const &,::cv::MatND const &,int,::cv::MatND const & );
        
        bp::def( 
            "norm"
            , norm_function_type( &::cv::norm )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("normType")=int(::cv::NORM_L2), bp::arg("mask")=cv::MatND() )
            , "\nCalculates absolute array norm, absolute difference norm, or relative "
    "\ndifference norm."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-norm" );
    
    }

    { //::cv::norm
    
        typedef double ( *norm_function_type )( ::cv::MatND const &,int,::cv::MatND const & );
        
        bp::def( 
            "norm"
            , norm_function_type( &::cv::norm )
            , ( bp::arg("a"), bp::arg("normType")=int(::cv::NORM_L2), bp::arg("mask")=cv::MatND() )
            , "\nCalculates absolute array norm, absolute difference norm, or relative "
    "\ndifference norm."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-norm" );
    
    }

    { //::cv::norm
    
        typedef double ( *norm_function_type )( ::cv::Mat const &,::cv::Mat const &,int,::cv::Mat const & );
        
        bp::def( 
            "norm"
            , norm_function_type( &::cv::norm )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("normType"), bp::arg("mask") )
            , "\nCalculates absolute array norm, absolute difference norm, or relative "
    "\ndifference norm."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-norm" );
    
    }

    { //::cv::norm
    
        typedef double ( *norm_function_type )( ::cv::Mat const &,int,::cv::Mat const & );
        
        bp::def( 
            "norm"
            , norm_function_type( &::cv::norm )
            , ( bp::arg("a"), bp::arg("normType"), bp::arg("mask") )
            , "\nCalculates absolute array norm, absolute difference norm, or relative "
    "\ndifference norm."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-norm" );
    
    }

    { //::cv::norm
    
        typedef double ( *norm_function_type )( ::cv::Mat const &,::cv::Mat const &,int );
        
        bp::def( 
            "norm"
            , norm_function_type( &::cv::norm )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("normType")=int(::cv::NORM_L2) )
            , "\nCalculates absolute array norm, absolute difference norm, or relative "
    "\ndifference norm."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-norm" );
    
    }

    { //::cv::norm
    
        typedef double ( *norm_function_type )( ::cv::Mat const &,int );
        
        bp::def( 
            "norm"
            , norm_function_type( &::cv::norm )
            , ( bp::arg("a"), bp::arg("normType")=int(::cv::NORM_L2) )
            , "\nCalculates absolute array norm, absolute difference norm, or relative "
    "\ndifference norm."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-norm" );
    
    }

    { //::cv::normalize
    
        typedef void ( *normalize_function_type )( ::cv::SparseMat const &,::cv::SparseMat &,double,int );
        
        bp::def( 
            "normalize"
            , normalize_function_type( &::cv::normalize )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("alpha"), bp::arg("normType") )
            , "\nNormalizes array's norm or the range."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-normalize" );
    
    }

    { //::cv::normalize
    
        typedef void ( *normalize_function_type )( ::cv::MatND const &,::cv::MatND &,double,double,int,int,::cv::MatND const & );
        
        bp::def( 
            "normalize"
            , normalize_function_type( &::cv::normalize )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("alpha")=1, bp::arg("beta")=0, bp::arg("norm_type")=int(::cv::NORM_L2), bp::arg("rtype")=(int)(-0x000000001), bp::arg("mask")=cv::MatND() )
            , "\nNormalizes array's norm or the range."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-normalize" );
    
    }

    { //::cv::normalize
    
        typedef void ( *normalize_function_type )( ::cv::Mat const &,::cv::Mat &,double,double,int,int,::cv::Mat const & );
        
        bp::def( 
            "normalize"
            , normalize_function_type( &::cv::normalize )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("alpha")=1, bp::arg("beta")=0, bp::arg("norm_type")=int(::cv::NORM_L2), bp::arg("rtype")=(int)(-0x000000001), bp::arg("mask")=cv::Mat() )
            , "\nNormalizes array's norm or the range."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-normalize" );
    
    }

    { //::cv::perspectiveTransform
    
        typedef void ( *perspectiveTransform_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "perspectiveTransform"
            , perspectiveTransform_function_type( &::cv::perspectiveTransform )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("m") )
            , "\nPerforms perspective matrix transformation of vectors."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-perspectivetransform" );
    
    }

    { //::cv::phase
    
        typedef void ( *phase_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,bool );
        
        bp::def( 
            "phase"
            , phase_function_type( &::cv::phase )
            , ( bp::arg("x"), bp::arg("y"), bp::arg("angle"), bp::arg("angleInDegrees")=(bool)(false) )
            , "\nCalculates the rotation angle of 2d vectors."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-phase" );
    
    }

    { //::cv::polarToCart
    
        typedef void ( *polarToCart_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat &,bool );
        
        bp::def( 
            "polarToCart"
            , polarToCart_function_type( &::cv::polarToCart )
            , ( bp::arg("magnitude"), bp::arg("angle"), bp::arg("x"), bp::arg("y"), bp::arg("angleInDegrees")=(bool)(false) )
            , "\nComputes x and y coordinates of 2D vectors from their magnitude and "
    "\nangle."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-polartocart" );
    
    }

    { //::cv::pow
    
        typedef void ( *pow_function_type )( ::cv::MatND const &,double,::cv::MatND & );
        
        bp::def( 
            "pow"
            , pow_function_type( &::cv::pow )
            , ( bp::arg("a"), bp::arg("power"), bp::arg("b") )
            , "\nRaises every array element to a power."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-pow" );
    
    }

    { //::cv::pow
    
        typedef void ( *pow_function_type )( ::cv::Mat const &,double,::cv::Mat & );
        
        bp::def( 
            "pow"
            , pow_function_type( &::cv::pow )
            , ( bp::arg("a"), bp::arg("power"), bp::arg("b") )
            , "\nRaises every array element to a power."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-pow" );
    
    }

    { //::cv::putText
    
        typedef void ( *putText_function_type )( ::cv::Mat &,::std::string const &,::cv::Point,int,double,::cv::Scalar,int,int,bool );
        
        bp::def( 
            "putText"
            , putText_function_type( &::cv::putText )
            , ( bp::arg("img"), bp::arg("text"), bp::arg("org"), bp::arg("fontFace"), bp::arg("fontScale"), bp::arg("color"), bp::arg("thickness")=(int)(1), bp::arg("linetype")=(int)(8), bp::arg("bottomLeftOrigin")=(bool)(false) )
            , "\nDraws a text string."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/drawing_functions.html#cv-puttext" );
    
    }

    { //::cv::randShuffle
    
        typedef void ( *randShuffle_function_type )( ::cv::Mat &,double,::cv::RNG * );
        
        bp::def( 
            "randShuffle"
            , randShuffle_function_type( &::cv::randShuffle )
            , ( bp::arg("dst"), bp::arg("iterFactor")=1.0e+0, bp::arg("rng")=bp::object() )
            , "\nShuffles the array elements randomly."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-randshuffle" );
    
    }

    { //::cv::randn
    
        typedef void ( *randn_function_type )( ::cv::Mat &,::cv::Scalar const &,::cv::Scalar const & );
        
        bp::def( 
            "randn"
            , randn_function_type( &::cv::randn )
            , ( bp::arg("dst"), bp::arg("mean"), bp::arg("stddev") )
            , "\nFills array with normally distributed random numbers."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-randn" );
    
    }

    { //::cv::randu
    
        typedef void ( *randu_function_type )( ::cv::Mat &,::cv::Scalar const &,::cv::Scalar const & );
        
        bp::def( 
            "randu"
            , randu_function_type( &::cv::randu )
            , ( bp::arg("dst"), bp::arg("low"), bp::arg("high") )
            , "\nGenerates a single uniformly-distributed random number or array of "
    "\nrandom numbers."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-randu" );
    
    }

    { //::cv::rectangle
    
        typedef void ( *rectangle_function_type )( ::cv::Mat &,::cv::Rect,::cv::Scalar const &,int,int,int );
        
        bp::def( 
            "rectangle"
            , rectangle_function_type( &::cv::rectangle )
            , ( bp::arg("img"), bp::arg("rec"), bp::arg("color"), bp::arg("thickness")=(int)(1), bp::arg("lineType")=(int)(8), bp::arg("shift")=(int)(0) )
            , "\nDraws a simple, thick, or filled up-right rectangle."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/drawing_functions.html#cv-rectangle" );
    
    }

    { //::cv::rectangle
    
        typedef void ( *rectangle_function_type )( ::cv::Mat &,::cv::Point,::cv::Point,::cv::Scalar const &,int,int,int );
        
        bp::def( 
            "rectangle"
            , rectangle_function_type( &::cv::rectangle )
            , ( bp::arg("img"), bp::arg("pt1"), bp::arg("pt2"), bp::arg("color"), bp::arg("thickness")=(int)(1), bp::arg("lineType")=(int)(8), bp::arg("shift")=(int)(0) )
            , "\nDraws a simple, thick, or filled up-right rectangle."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/drawing_functions.html#cv-rectangle" );
    
    }

    { //::cv::reduce
    
        typedef void ( *reduce_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,int );
        
        bp::def( 
            "reduce"
            , reduce_function_type( &::cv::reduce )
            , ( bp::arg("m"), bp::arg("dst"), bp::arg("dim"), bp::arg("rtype"), bp::arg("dtype")=(int)(-0x000000001) )
            , "\nReduces a matrix to a vector."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-reduce" );
    
    }

    { //::cv::repeat
    
        typedef ::cv::Mat ( *repeat_function_type )( ::cv::Mat const &,int,int );
        
        bp::def( 
            "repeat"
            , repeat_function_type( &::cv::repeat )
            , ( bp::arg("src"), bp::arg("ny"), bp::arg("nx") )
            , "\nFill the destination array with repeated copies of the source array."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-repeat" );
    
    }

    { //::cv::repeat
    
        typedef void ( *repeat_function_type )( ::cv::Mat const &,int,int,::cv::Mat & );
        
        bp::def( 
            "repeat"
            , repeat_function_type( &::cv::repeat )
            , ( bp::arg("a"), bp::arg("ny"), bp::arg("nx"), bp::arg("b") )
            , "\nFill the destination array with repeated copies of the source array."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-repeat" );
    
    }

    { //::cv::scaleAdd
    
        typedef void ( *scaleAdd_function_type )( ::cv::MatND const &,double,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "scaleAdd"
            , scaleAdd_function_type( &::cv::scaleAdd )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("b"), bp::arg("c") )
            , "\nCalculates the sum of a scaled array and another array."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-scaleadd" );
    
    }

    { //::cv::scaleAdd
    
        typedef void ( *scaleAdd_function_type )( ::cv::Mat const &,double,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "scaleAdd"
            , scaleAdd_function_type( &::cv::scaleAdd )
            , ( bp::arg("a"), bp::arg("alpha"), bp::arg("b"), bp::arg("c") )
            , "\nCalculates the sum of a scaled array and another array."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-scaleadd" );
    
    }

    { //::cv::setIdentity
    
        typedef void ( *setIdentity_function_type )( ::cv::Mat &,::cv::Scalar const & );
        
        bp::def( 
            "setIdentity"
            , setIdentity_function_type( &::cv::setIdentity )
            , ( bp::arg("c"), bp::arg("s")=cv::Scalar_<double>(1.0e+0) )
            , "\nInitializes a scaled identity matrix."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-setidentity" );
    
    }

    { //::cv::setNumThreads
    
        typedef void ( *setNumThreads_function_type )( int );
        
        bp::def( 
            "setNumThreads"
            , setNumThreads_function_type( &::cv::setNumThreads )
            , ( bp::arg("arg0") ) );
    
    }

    { //::cv::setUseOptimized
    
        typedef void ( *setUseOptimized_function_type )( bool );
        
        bp::def( 
            "setUseOptimized"
            , setUseOptimized_function_type( &::cv::setUseOptimized )
            , ( bp::arg("arg0") ) );
    
    }

    { //::cv::solve
    
        typedef bool ( *solve_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "solve"
            , solve_function_type( &::cv::solve )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("x"), bp::arg("flags")=int(::cv::DECOMP_LU) )
            , "\nSolves one or more linear systems or least-squares problems."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-solve" );
    
    }

    { //::cv::sort
    
        typedef void ( *sort_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "sort"
            , sort_function_type( &::cv::sort )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("flags") )
            , "\nSorts each row or each column of a matrix."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-sort" );
    
    }

    { //::cv::sortIdx
    
        typedef void ( *sortIdx_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "sortIdx"
            , sortIdx_function_type( &::cv::sortIdx )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("flags") )
            , "\nSorts each row or each column of a matrix."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-sortIdx" );
    
    }

    { //::cv::split
    
        typedef void ( *split_function_type )( ::cv::MatND const &,::std::vector< cv::MatND > & );
        
        bp::def( 
            "split"
            , split_function_type( &::cv::split )
            , ( bp::arg("m"), bp::arg("mv") )
            , "\nDivides multi-channel array into several single-channel arrays."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-split" );
    
    }

    { //::cv::split
    
        typedef void ( *split_function_type )( ::cv::Mat const &,::std::vector< cv::Mat > & );
        
        bp::def( 
            "split"
            , split_function_type( &::cv::split )
            , ( bp::arg("m"), bp::arg("mv") )
            , "\nDivides multi-channel array into several single-channel arrays."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-split" );
    
    }

    { //::cv::sqrt
    
        typedef void ( *sqrt_function_type )( ::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "sqrt"
            , sqrt_function_type( &::cv::sqrt )
            , ( bp::arg("a"), bp::arg("b") )
            , "\nCalculates square root of array elements."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-sqrt" );
    
    }

    { //::cv::sqrt
    
        typedef void ( *sqrt_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "sqrt"
            , sqrt_function_type( &::cv::sqrt )
            , ( bp::arg("a"), bp::arg("b") )
            , "\nCalculates square root of array elements."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-sqrt" );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::MatND const &,::cv::Scalar const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::MatND() )
            , "\nCalculates per-element difference between two arrays or array and a "
    "\nscalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-subtract" );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::Scalar const &,::cv::MatND const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("s"), bp::arg("a"), bp::arg("c"), bp::arg("mask")=cv::MatND() )
            , "\nCalculates per-element difference between two arrays or array and a "
    "\nscalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-subtract" );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
            , "\nCalculates per-element difference between two arrays or array and a "
    "\nscalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-subtract" );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::MatND const &,::cv::MatND const &,::cv::MatND &,::cv::MatND const & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask") )
            , "\nCalculates per-element difference between two arrays or array and a "
    "\nscalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-subtract" );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::Scalar const &,::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("s"), bp::arg("a"), bp::arg("c"), bp::arg("mask")=cv::Mat() )
            , "\nCalculates per-element difference between two arrays or array and a "
    "\nscalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-subtract" );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::Mat const &,::cv::Scalar const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("a"), bp::arg("s"), bp::arg("c"), bp::arg("mask")=cv::Mat() )
            , "\nCalculates per-element difference between two arrays or array and a "
    "\nscalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-subtract" );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c") )
            , "\nCalculates per-element difference between two arrays or array and a "
    "\nscalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-subtract" );
    
    }

    { //::cv::subtract
    
        typedef void ( *subtract_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "subtract"
            , subtract_function_type( &::cv::subtract )
            , ( bp::arg("a"), bp::arg("b"), bp::arg("c"), bp::arg("mask") )
            , "\nCalculates per-element difference between two arrays or array and a "
    "\nscalar."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-subtract" );
    
    }

    { //::cv::sum
    
        typedef ::cv::Scalar ( *sum_function_type )( ::cv::MatND const & );
        
        bp::def( 
            "sum"
            , sum_function_type( &::cv::sum )
            , ( bp::arg("m") )
            , "\nCalculates sum of array elements."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-sum" );
    
    }

    { //::cv::sum
    
        typedef ::cv::Scalar ( *sum_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "sum"
            , sum_function_type( &::cv::sum )
            , ( bp::arg("m") )
            , "\nCalculates sum of array elements."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-sum" );
    
    }

    { //::cv::theRNG
    
        typedef ::cv::RNG & ( *theRNG_function_type )(  );
        
        bp::def( 
            "theRNG"
            , theRNG_function_type( &::cv::theRNG )
            , bp::return_value_policy< bp::reference_existing_object >()
            , "\nReturns the default random number generator."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-therng" );
    
    }

    { //::cv::toUtf16
    
        typedef ::cv::WString ( *toUtf16_function_type )( ::std::string const & );
        
        bp::def( 
            "toUtf16"
            , toUtf16_function_type( &::cv::toUtf16 )
            , ( bp::arg("str") ) );
    
    }

    { //::cv::trace
    
        typedef ::cv::Scalar ( *trace_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "trace"
            , trace_function_type( &::cv::trace )
            , ( bp::arg("m") )
            , "\nReturns the trace of a matrix."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-trace" );
    
    }

    { //::cv::transform
    
        typedef void ( *transform_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "transform"
            , transform_function_type( &::cv::transform )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("m") )
            , "\nPerforms matrix transformation of every array element."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-transform" );
    
    }

    { //::cv::transpose
    
        typedef void ( *transpose_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "transpose"
            , transpose_function_type( &::cv::transpose )
            , ( bp::arg("a"), bp::arg("b") )
            , "\nTransposes a matrix."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/operations_on_arrays.html#cv-transpose" );
    
    }

    { //::cv::useOptimized
    
        typedef bool ( *useOptimized_function_type )(  );
        
        bp::def( 
            "useOptimized"
            , useOptimized_function_type( &::cv::useOptimized ) );
    
    }

}
