// This file has been generated by Py++.

#include "boost/python.hpp"
#include "opencv_converters.hpp"
#include "__call_policies.pypp.hpp"
#include "__array_1.pypp.hpp"
#include "__ctypes_integration.pypp.hpp"
#include "cxcore_hpp_point_wrapper.hpp"
#include "boost/python/make_function.hpp"
#include "opencv_converters.hpp"
#include "boost/python/str.hpp"
#include "ndarray.hpp"
#include "boost/python/object/life_support.hpp"
#include "boost/python/object.hpp"
#include "cxcore_hpp_point_ext_classes_3.pypp.hpp"

namespace bp = boost::python;

struct MatND_wrapper : cv::MatND, bp::wrapper< cv::MatND > {

    MatND_wrapper( )
    : cv::MatND( )
      , bp::wrapper< cv::MatND >(){
        // null constructor
    
    }

    MatND_wrapper(::cv::MatND const & m )
    : cv::MatND( boost::ref(m) )
      , bp::wrapper< cv::MatND >(){
        // copy constructor
    
    }

    MatND_wrapper(::cv::Mat const & m )
    : cv::MatND( boost::ref(m) )
      , bp::wrapper< cv::MatND >(){
        // constructor
    
    }

    static void create( ::cv::MatND & inst, std::vector<int> const & _sizes, int _type ){
        inst.create((int)(_sizes.size()), (int const *)(&_sizes[0]), _type);
    }

    static boost::python::object reshape( ::cv::MatND const & inst, int _newcn, std::vector<int> const & _newsz=std::vector<int>() ){
        cv::MatND result = inst.reshape(_newcn, (int)(_newsz.size()), (int const *)(&_newsz[0]));
        return bp::object( result );
    }

    static pyplusplus::containers::static_sized::array_1_t< int, 32>
    pyplusplus_size_wrapper( cv::MatND & inst ){
        return pyplusplus::containers::static_sized::array_1_t< int, 32>( inst.size );
    }

    static pyplusplus::containers::static_sized::array_1_t< size_t, 32>
    pyplusplus_step_wrapper( cv::MatND & inst ){
        return pyplusplus::containers::static_sized::array_1_t< size_t, 32>( inst.step );
    }

};

static boost::shared_ptr<cv::MatND> MatND__init1__(std::vector<int> const &_sizes, int _type)
{
    return boost::shared_ptr<cv::MatND>(new cv::MatND(_sizes.size(), &_sizes[0], _type));
}

static boost::shared_ptr<cv::MatND> MatND__init2__(std::vector<int> const &_sizes, int _type, const cv::Scalar& _s)
{
    return boost::shared_ptr<cv::MatND>(new cv::MatND(_sizes.size(), &_sizes[0], _type, _s));
}

static boost::shared_ptr<cv::MatND> MatND__init3__(const cv::MatND& m, std::vector<cv::Range> const &ranges)
{
    return boost::shared_ptr<cv::MatND>(new cv::MatND(m, &ranges[0]));
}

static cv::MatND MatND__call__(const cv::MatND& inst, std::vector<cv::Range> const &ranges)
{
    return inst(&ranges[0]);
}

static bp::object MatND_get_data(cv::MatND const &inst)
{
    return sdcpp::get_new_object(
        PyBuffer_FromReadWriteMemory(
            (void*)(inst.data), 
            (size_t)(inst.size[0]*inst.step[0])));
}

static bp::object Ptr_Mat_from_Mat(bp::object const &inst_Mat)
{
    bp::extract<cv::Mat *> elem(inst_Mat);
    if(!elem.check())
    {
        char s[300];
        sprintf( s, "Argument 'inst_Mat' must contain an object of type Mat." );
        PyErr_SetString(PyExc_TypeError, s);
        throw bp::error_already_set();
    }

    bp::object result = bp::object(::cv::Ptr< cv::Mat >(elem()));
    result.attr("_depends") = inst_Mat;
    return result;
}

static cv::Mat const &Ptr_Mat_pointee(::cv::Ptr< cv::Mat > const &inst) { return *((cv::Mat const *)inst); }

static size_t Seq_Point2i_len(cv::Seq<cv::Point_<int> > const &inst) { return inst.size(); }

static ::CvSeq * get_Seq_Point2i_seq( cv::Seq<cv::Point_<int> > const & inst ) { return inst.seq; }

template<> inline ::cv::Mat normal_cast( ::CvMat const &inst ) { return cv::Mat((CvMat const *)&inst); }

template<> inline ::std::vector< cv::Vec<float, 4> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec4f>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<float, 4> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec4f>(inst); }

template<> inline ::std::vector< short > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<short>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< short > const &inst ) { return convert_from_vector_of_T_to_Mat<short>(inst); }

template<> inline ::std::vector< cv::Vec<unsigned char, 4> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec4b>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<unsigned char, 4> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec4b>(inst); }

template<> inline ::std::vector< int > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<int>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< int > const &inst ) { return convert_from_vector_of_T_to_Mat<int>(inst); }

template<> inline ::std::vector< std::vector< int > > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_vector_of_T<int>(inst); }

template<> inline ::std::vector< unsigned char > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<unsigned char>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< unsigned char > const &inst ) { return convert_from_vector_of_T_to_Mat<unsigned char>(inst); }

template<> inline ::std::vector< cv::Vec<int, 4> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec4i>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<int, 4> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec4i>(inst); }

template<> inline ::std::vector< cv::Vec<unsigned short, 4> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec4w>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<unsigned short, 4> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec4w>(inst); }

template<> inline ::std::vector< cv::Point3_<int> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Point3i>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Point3_<int> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Point3i>(inst); }

template<> inline ::std::vector< std::vector< cv::Point3_<int> > > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_vector_of_T<cv::Point3i>(inst); }

template<> inline ::std::vector< cv::Point_<int> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Point2i>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Point_<int> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Point2i>(inst); }

template<> inline ::std::vector< std::vector< cv::Point_<int> > > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_vector_of_T<cv::Point2i>(inst); }

template<> inline ::std::vector< cv::Vec<double, 4> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec4d>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<double, 4> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec4d>(inst); }

template<> inline ::std::vector< cv::Vec<short, 4> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec4s>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<short, 4> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec4s>(inst); }

template<> inline ::std::vector< cv::Vec<float, 2> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec2f>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<float, 2> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec2f>(inst); }

template<> inline ::std::vector< cv::Range > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Range>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Range > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Range>(inst); }

template<> inline ::std::vector< cv::Point3_<double> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Point3d>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Point3_<double> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Point3d>(inst); }

template<> inline ::std::vector< std::vector< cv::Point3_<double> > > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_vector_of_T<cv::Point3d>(inst); }

template<> inline ::std::vector< char > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<char>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< char > const &inst ) { return convert_from_vector_of_T_to_Mat<char>(inst); }

template<> inline ::std::vector< cv::Point3_<float> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Point3f>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Point3_<float> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Point3f>(inst); }

template<> inline ::std::vector< std::vector< cv::Point3_<float> > > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_vector_of_T<cv::Point3f>(inst); }

template<> inline ::std::vector< cv::Point_<double> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Point2d>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Point_<double> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Point2d>(inst); }

template<> inline ::std::vector< std::vector< cv::Point_<double> > > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_vector_of_T<cv::Point2d>(inst); }

template<> inline ::std::vector< cv::Vec<unsigned short, 3> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec3w>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<unsigned short, 3> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec3w>(inst); }

template<> inline ::std::vector< cv::Vec<unsigned short, 2> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec2w>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<unsigned short, 2> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec2w>(inst); }

template<> inline ::std::vector< cv::Vec<short, 3> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec3s>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<short, 3> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec3s>(inst); }

template<> inline ::std::vector< cv::Vec<short, 2> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec2s>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<short, 2> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec2s>(inst); }

template<> inline ::std::vector< double > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<double>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< double > const &inst ) { return convert_from_vector_of_T_to_Mat<double>(inst); }

template<> inline ::std::vector< cv::Scalar_<double> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Scalar>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Scalar_<double> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Scalar>(inst); }

template<> inline ::std::vector< cv::Point_<float> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Point2f>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Point_<float> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Point2f>(inst); }

template<> inline ::std::vector< std::vector< cv::Point_<float> > > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_vector_of_T<cv::Point2f>(inst); }

template<> inline ::std::vector< cv::Vec<float, 3> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec3f>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<float, 3> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec3f>(inst); }

template<> inline ::std::vector< cv::Vec<double, 2> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec2d>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<double, 2> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec2d>(inst); }

template<> inline ::std::vector< cv::Vec<double, 3> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec3d>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<double, 3> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec3d>(inst); }

template<> inline ::std::vector< unsigned short > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<unsigned short>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< unsigned short > const &inst ) { return convert_from_vector_of_T_to_Mat<unsigned short>(inst); }

template<> inline ::std::vector< cv::Vec<unsigned char, 3> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec3b>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<unsigned char, 3> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec3b>(inst); }

template<> inline ::std::vector< cv::Vec<unsigned char, 2> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec2b>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<unsigned char, 2> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec2b>(inst); }

template<> inline ::std::vector< cv::Vec<float, 6> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec6f>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<float, 6> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec6f>(inst); }

template<> inline ::std::vector< cv::Vec<int, 2> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec2i>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<int, 2> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec2i>(inst); }

template<> inline ::std::vector< std::vector< cv::Vec<int, 2> > > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_vector_of_T<cv::Vec2i>(inst); }

template<> inline ::std::vector< cv::Vec<double, 6> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec6d>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<double, 6> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec6d>(inst); }

template<> inline ::std::vector< float > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<float>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< float > const &inst ) { return convert_from_vector_of_T_to_Mat<float>(inst); }

template<> inline ::std::vector< std::vector< float > > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_vector_of_T<float>(inst); }

template<> inline ::std::vector< cv::Vec<int, 3> > normal_cast( ::cv::Mat const &inst ) { return convert_from_Mat_to_vector_of_T<cv::Vec3i>(inst); }

template<> inline ::cv::Mat normal_cast( ::std::vector< cv::Vec<int, 3> > const &inst ) { return convert_from_vector_of_T_to_Mat<cv::Vec3i>(inst); }

void register_classes_3(){

    { //::cv::MatND
        typedef bp::class_< MatND_wrapper > MatND_exposer_t;
        MatND_exposer_t MatND_exposer = MatND_exposer_t( "MatND", bp::init< >() );
        bp::scope MatND_scope( MatND_exposer );
        MatND_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::MatND >() );
        bp::scope().attr("MAGIC_VAL") = (int)cv::MatND::MAGIC_VAL;
        bp::scope().attr("AUTO_STEP") = (int)cv::MatND::AUTO_STEP;
        bp::scope().attr("CONTINUOUS_FLAG") = (int)cv::MatND::CONTINUOUS_FLAG;
        bp::scope().attr("MAX_DIM") = (int)cv::MatND::MAX_DIM;
        MatND_exposer.def( bp::init< cv::MatND const & >(( bp::arg("m") )) );
        MatND_exposer.def( bp::init< cv::Mat const & >(( bp::arg("m") )) );
        bp::implicitly_convertible< cv::Mat const &, cv::MatND >();
        { //::cv::MatND::assignTo
        
            typedef void ( ::cv::MatND::*assignTo_function_type )( ::cv::MatND &,int ) const;
            
            MatND_exposer.def( 
                "assignTo"
                , assignTo_function_type( &::cv::MatND::assignTo )
                , ( bp::arg("m"), bp::arg("type") ) );
        
        }
        { //::cv::MatND::channels
        
            typedef int ( ::cv::MatND::*channels_function_type )(  ) const;
            
            MatND_exposer.def( 
                "channels"
                , channels_function_type( &::cv::MatND::channels ) );
        
        }
        { //::cv::MatND::clone
        
            typedef ::cv::MatND ( ::cv::MatND::*clone_function_type )(  ) const;
            
            MatND_exposer.def( 
                "clone"
                , clone_function_type( &::cv::MatND::clone ) );
        
        }
        { //::cv::MatND::convertTo
        
            typedef void ( ::cv::MatND::*convertTo_function_type )( ::cv::MatND &,int,double,double ) const;
            
            MatND_exposer.def( 
                "convertTo"
                , convertTo_function_type( &::cv::MatND::convertTo )
                , ( bp::arg("m"), bp::arg("rtype"), bp::arg("alpha")=1, bp::arg("beta")=0 ) );
        
        }
        { //::cv::MatND::copyTo
        
            typedef void ( ::cv::MatND::*copyTo_function_type )( ::cv::MatND & ) const;
            
            MatND_exposer.def( 
                "copyTo"
                , copyTo_function_type( &::cv::MatND::copyTo )
                , ( bp::arg("m") ) );
        
        }
        { //::cv::MatND::copyTo
        
            typedef void ( ::cv::MatND::*copyTo_function_type )( ::cv::MatND &,::cv::MatND const & ) const;
            
            MatND_exposer.def( 
                "copyTo"
                , copyTo_function_type( &::cv::MatND::copyTo )
                , ( bp::arg("m"), bp::arg("mask") ) );
        
        }
        { //::cv::MatND::create
        
            typedef void ( *create_function_type )( cv::MatND &,std::vector<int> const &,int );
            
            MatND_exposer.def( 
                "create"
                , create_function_type( &MatND_wrapper::create )
                , ( bp::arg("inst"), bp::arg("_sizes"), bp::arg("_type") )
                , "\nArgument '_ndims':"\
    "\n    Dependent argument: omitted from input. Its value is derived from "\
    "\n    argument '_sizes'."\
    "\nArgument '_sizes':"\
    "\n    C++ type: int const *"\
    "\n    Python type: vector_int" );
        
        }
        { //::cv::MatND::depth
        
            typedef int ( ::cv::MatND::*depth_function_type )(  ) const;
            
            MatND_exposer.def( 
                "depth"
                , depth_function_type( &::cv::MatND::depth ) );
        
        }
        { //::cv::MatND::elemSize
        
            typedef ::size_t ( ::cv::MatND::*elemSize_function_type )(  ) const;
            
            MatND_exposer.def( 
                "elemSize"
                , elemSize_function_type( &::cv::MatND::elemSize ) );
        
        }
        { //::cv::MatND::elemSize1
        
            typedef ::size_t ( ::cv::MatND::*elemSize1_function_type )(  ) const;
            
            MatND_exposer.def( 
                "elemSize1"
                , elemSize1_function_type( &::cv::MatND::elemSize1 ) );
        
        }
        { //::cv::MatND::isContinuous
        
            typedef bool ( ::cv::MatND::*isContinuous_function_type )(  ) const;
            
            MatND_exposer.def( 
                "isContinuous"
                , isContinuous_function_type( &::cv::MatND::isContinuous ) );
        
        }
        MatND_exposer.def( "__temp_func", &cv::MatND::operator ::cv::Mat , "\nWrapped function:"
    "\n    operator ::cv::Mat" );
        { //::cv::MatND::operator=
        
            typedef ::cv::MatND & ( ::cv::MatND::*assign_function_type )( ::cv::MatND const & ) ;
            
            MatND_exposer.def( 
                "assign"
                , assign_function_type( &::cv::MatND::operator= )
                , ( bp::arg("m") )
                , bp::return_self< >()
                , "\nWrapped function:"
    "\n    operator=" );
        
        }
        { //::cv::MatND::operator=
        
            typedef ::cv::MatND & ( ::cv::MatND::*assign_function_type )( ::cv::Scalar const & ) ;
            
            MatND_exposer.def( 
                "assign"
                , assign_function_type( &::cv::MatND::operator= )
                , ( bp::arg("s") )
                , bp::return_self< >()
                , "\nWrapped function:"
    "\n    operator=" );
        
        }
        { //::cv::MatND::reshape
        
            typedef boost::python::object ( *reshape_function_type )( cv::MatND const &,int,std::vector<int> const & );
            
            MatND_exposer.def( 
                "reshape"
                , reshape_function_type( &MatND_wrapper::reshape )
                , ( bp::arg("inst"), bp::arg("_newcn"), bp::arg("_newsz")=std::vector<int>() )
                , "\nArgument '_newndims':"\
    "\n    Dependent argument: omitted from input. Its value is derived from "\
    "\n    argument '_newsz'."\
    "\nArgument '_newsz':"\
    "\n    C++ type: int const *"\
    "\n    Python type: vector_int" );
        
        }
        { //::cv::MatND::setTo
        
            typedef ::cv::MatND & ( ::cv::MatND::*setTo_function_type )( ::cv::Scalar const &,::cv::MatND const & ) ;
            
            MatND_exposer.def( 
                "setTo"
                , setTo_function_type( &::cv::MatND::setTo )
                , ( bp::arg("s"), bp::arg("mask")=cv::MatND() )
                , bp::return_self< >() );
        
        }
        { //::cv::MatND::step1
        
            typedef ::size_t ( ::cv::MatND::*step1_function_type )( int ) const;
            
            MatND_exposer.def( 
                "step1"
                , step1_function_type( &::cv::MatND::step1 )
                , ( bp::arg("i") ) );
        
        }
        { //::cv::MatND::type
        
            typedef int ( ::cv::MatND::*type_function_type )(  ) const;
            
            MatND_exposer.def( 
                "type"
                , type_function_type( &::cv::MatND::type ) );
        
        }
        MatND_exposer.def_readwrite( "dims", &cv::MatND::dims );
        MatND_exposer.def_readwrite( "flags", &cv::MatND::flags );
        pyplusplus::containers::static_sized::register_array_1< int, 32 >( "__array_1_int_32" );
        { //cv::MatND::size [variable], type=int[32]
        
            typedef pyplusplus::containers::static_sized::array_1_t< int, 32> ( *array_wrapper_creator )( cv::MatND & );
            
            MatND_exposer.add_property( "size"
                , bp::make_function( array_wrapper_creator(&MatND_wrapper::pyplusplus_size_wrapper)
                                    , bp::with_custodian_and_ward_postcall< 0, 1 >() ) );
        }
        pyplusplus::containers::static_sized::register_array_1< size_t, 32 >( "__array_1_size_t_32" );
        { //cv::MatND::step [variable], type=size_t[32]
        
            typedef pyplusplus::containers::static_sized::array_1_t< size_t, 32> ( *array_wrapper_creator )( cv::MatND & );
            
            MatND_exposer.add_property( "step"
                , bp::make_function( array_wrapper_creator(&MatND_wrapper::pyplusplus_step_wrapper)
                                    , bp::with_custodian_and_ward_postcall< 0, 1 >() ) );
        }
        MatND_exposer.def("__init__", bp::make_constructor(&MatND__init1__, bp::default_call_policies(), ( bp::arg("_sizes"), bp::arg("_type") )));
        MatND_exposer.def("__init__", bp::make_constructor(&MatND__init2__, bp::default_call_policies(), ( bp::arg("_sizes"), bp::arg("_type"), bp::arg("s") )));
        MatND_exposer.def("__init__", bp::make_constructor(&MatND__init3__, bp::default_call_policies(), ( bp::arg("m"), bp::arg("ranges") )));
        MatND_exposer.def("__call__", bp::make_function(&MatND__call__, bp::default_call_policies(), (bp::arg("ranges"))));
        MatND_exposer.add_property("data", &::MatND_get_data);
        MatND_exposer.add_property("ndarray", &sdcpp::as_ndarray< cv::MatND >);
    }

    { //::cv::Point3_< double >
        typedef bp::class_< cv::Point3_< double > > Point3d_exposer_t;
        Point3d_exposer_t Point3d_exposer = Point3d_exposer_t( "Point3d", bp::init< >() );
        bp::scope Point3d_scope( Point3d_exposer );
        Point3d_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Point3_< double > >() );
        Point3d_exposer.def( bp::init< double, double, double >(( bp::arg("_x"), bp::arg("_y"), bp::arg("_z") )) );
        Point3d_exposer.def( bp::init< cv::Point3_< double > const & >(( bp::arg("pt") )) );
        Point3d_exposer.def( bp::init< cv::Point_< double > const & >(( bp::arg("pt") )) );
        bp::implicitly_convertible< cv::Point_< double > const &, cv::Point3_< double > >();
        Point3d_exposer.def( bp::init< CvPoint3D32f const & >(( bp::arg("pt") )) );
        bp::implicitly_convertible< CvPoint3D32f const &, cv::Point3_< double > >();
        Point3d_exposer.def( bp::init< cv::Vec< double, 3 > const & >(( bp::arg("v") )) );
        bp::implicitly_convertible< cv::Vec< double, 3 > const &, cv::Point3_< double > >();
        { //::cv::Point3_< double >::ddot
        
            typedef cv::Point3_< double > exported_class_t;
            typedef double ( exported_class_t::*ddot_function_type )( ::cv::Point3_< double > const & ) const;
            
            Point3d_exposer.def( 
                "ddot"
                , ddot_function_type( &::cv::Point3_< double >::ddot )
                , ( bp::arg("pt") ) );
        
        }
        { //::cv::Point3_< double >::dot
        
            typedef cv::Point3_< double > exported_class_t;
            typedef double ( exported_class_t::*dot_function_type )( ::cv::Point3_< double > const & ) const;
            
            Point3d_exposer.def( 
                "dot"
                , dot_function_type( &::cv::Point3_< double >::dot )
                , ( bp::arg("pt") ) );
        
        }
        Point3d_exposer.def( "__temp_func", &cv::Point3_< double >::operator ::CvPoint3D32f , "\nWrapped function:"
    "\n    operator ::CvPoint3D32f" );
        Point3d_exposer.def( "__temp_func", &cv::Point3_< double >::operator ::cv::Vec< double, 3 > , "\nWrapped function:"
    "\n    operator ::cv::Vec<double, 3>" );
        { //::cv::Point3_< double >::operator=
        
            typedef cv::Point3_< double > exported_class_t;
            typedef ::cv::Point3_< double > & ( exported_class_t::*assign_function_type )( ::cv::Point3_< double > const & ) ;
            
            Point3d_exposer.def( 
                "assign"
                , assign_function_type( &::cv::Point3_< double >::operator= )
                , ( bp::arg("pt") )
                , bp::return_self< >()
                , "\nWrapped function:"
    "\n    operator=" );
        
        }
        Point3d_exposer.def_readwrite( "x", &cv::Point3_< double >::x );
        Point3d_exposer.def_readwrite( "y", &cv::Point3_< double >::y );
        Point3d_exposer.def_readwrite( "z", &cv::Point3_< double >::z );
        Point3d_exposer.add_property("ndarray", &sdcpp::as_ndarray< cv::Point3_<double> >);
        Point3d_exposer.def("__iadd__", &__iadd__<cv::Point3d, cv::Point3d>, bp::return_self<>() );
        Point3d_exposer.def("__isub__", &__isub__<cv::Point3d, cv::Point3d>, bp::return_self<>() );
        Point3d_exposer.def("__imul__", &__imul__<cv::Point3d, double>, bp::return_self<>() );
        Point3d_exposer.def("__add__", &__add__<cv::Point3d, cv::Point3d> );
        Point3d_exposer.def("__sub__", &__sub__<cv::Point3d, cv::Point3d> );
        Point3d_exposer.def("__eq__", &__eq__<cv::Point3d, cv::Point3d> );
        Point3d_exposer.def("__neg__", &__neg__<cv::Point3d> );
        Point3d_exposer.def("__mul__", &__mul__<cv::Point3d, double> );
        Point3d_exposer.def("__rmul__", &__rmul__<double, cv::Point3d> );
    }

    { //::cv::Point3_< float >
        typedef bp::class_< cv::Point3_< float > > Point3f_exposer_t;
        Point3f_exposer_t Point3f_exposer = Point3f_exposer_t( "Point3f", bp::init< >() );
        bp::scope Point3f_scope( Point3f_exposer );
        Point3f_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Point3_< float > >() );
        Point3f_exposer.def( bp::init< float, float, float >(( bp::arg("_x"), bp::arg("_y"), bp::arg("_z") )) );
        Point3f_exposer.def( bp::init< cv::Point3_< float > const & >(( bp::arg("pt") )) );
        Point3f_exposer.def( bp::init< cv::Point_< float > const & >(( bp::arg("pt") )) );
        bp::implicitly_convertible< cv::Point_< float > const &, cv::Point3_< float > >();
        Point3f_exposer.def( bp::init< CvPoint3D32f const & >(( bp::arg("pt") )) );
        bp::implicitly_convertible< CvPoint3D32f const &, cv::Point3_< float > >();
        Point3f_exposer.def( bp::init< cv::Vec< float, 3 > const & >(( bp::arg("v") )) );
        bp::implicitly_convertible< cv::Vec< float, 3 > const &, cv::Point3_< float > >();
        { //::cv::Point3_< float >::ddot
        
            typedef cv::Point3_< float > exported_class_t;
            typedef double ( exported_class_t::*ddot_function_type )( ::cv::Point3_< float > const & ) const;
            
            Point3f_exposer.def( 
                "ddot"
                , ddot_function_type( &::cv::Point3_< float >::ddot )
                , ( bp::arg("pt") ) );
        
        }
        { //::cv::Point3_< float >::dot
        
            typedef cv::Point3_< float > exported_class_t;
            typedef float ( exported_class_t::*dot_function_type )( ::cv::Point3_< float > const & ) const;
            
            Point3f_exposer.def( 
                "dot"
                , dot_function_type( &::cv::Point3_< float >::dot )
                , ( bp::arg("pt") ) );
        
        }
        Point3f_exposer.def( "__temp_func", &cv::Point3_< float >::operator ::CvPoint3D32f , "\nWrapped function:"
    "\n    operator ::CvPoint3D32f" );
        Point3f_exposer.def( "__temp_func", &cv::Point3_< float >::operator ::cv::Vec< float, 3 > , "\nWrapped function:"
    "\n    operator ::cv::Vec<float, 3>" );
        { //::cv::Point3_< float >::operator=
        
            typedef cv::Point3_< float > exported_class_t;
            typedef ::cv::Point3_< float > & ( exported_class_t::*assign_function_type )( ::cv::Point3_< float > const & ) ;
            
            Point3f_exposer.def( 
                "assign"
                , assign_function_type( &::cv::Point3_< float >::operator= )
                , ( bp::arg("pt") )
                , bp::return_self< >()
                , "\nWrapped function:"
    "\n    operator=" );
        
        }
        Point3f_exposer.def_readwrite( "x", &cv::Point3_< float >::x );
        Point3f_exposer.def_readwrite( "y", &cv::Point3_< float >::y );
        Point3f_exposer.def_readwrite( "z", &cv::Point3_< float >::z );
        Point3f_exposer.add_property("ndarray", &sdcpp::as_ndarray< cv::Point3_<float> >);
        Point3f_exposer.def("__iadd__", &__iadd__<cv::Point3f, cv::Point3f>, bp::return_self<>() );
        Point3f_exposer.def("__isub__", &__isub__<cv::Point3f, cv::Point3f>, bp::return_self<>() );
        Point3f_exposer.def("__imul__", &__imul__<cv::Point3f, double>, bp::return_self<>() );
        Point3f_exposer.def("__add__", &__add__<cv::Point3f, cv::Point3f> );
        Point3f_exposer.def("__sub__", &__sub__<cv::Point3f, cv::Point3f> );
        Point3f_exposer.def("__eq__", &__eq__<cv::Point3f, cv::Point3f> );
        Point3f_exposer.def("__neg__", &__neg__<cv::Point3f> );
        Point3f_exposer.def("__mul__", &__mul__<cv::Point3f, double> );
        Point3f_exposer.def("__rmul__", &__rmul__<double, cv::Point3f> );
    }

    { //::cv::Point3_< int >
        typedef bp::class_< cv::Point3_< int > > Point3i_exposer_t;
        Point3i_exposer_t Point3i_exposer = Point3i_exposer_t( "Point3i", bp::init< >() );
        bp::scope Point3i_scope( Point3i_exposer );
        Point3i_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Point3_< int > >() );
        Point3i_exposer.def( bp::init< int, int, int >(( bp::arg("_x"), bp::arg("_y"), bp::arg("_z") )) );
        Point3i_exposer.def( bp::init< cv::Point3_< int > const & >(( bp::arg("pt") )) );
        Point3i_exposer.def( bp::init< cv::Point_< int > const & >(( bp::arg("pt") )) );
        bp::implicitly_convertible< cv::Point_< int > const &, cv::Point3_< int > >();
        Point3i_exposer.def( bp::init< CvPoint3D32f const & >(( bp::arg("pt") )) );
        bp::implicitly_convertible< CvPoint3D32f const &, cv::Point3_< int > >();
        Point3i_exposer.def( bp::init< cv::Vec< int, 3 > const & >(( bp::arg("v") )) );
        bp::implicitly_convertible< cv::Vec< int, 3 > const &, cv::Point3_< int > >();
        { //::cv::Point3_< int >::ddot
        
            typedef cv::Point3_< int > exported_class_t;
            typedef double ( exported_class_t::*ddot_function_type )( ::cv::Point3_< int > const & ) const;
            
            Point3i_exposer.def( 
                "ddot"
                , ddot_function_type( &::cv::Point3_< int >::ddot )
                , ( bp::arg("pt") ) );
        
        }
        { //::cv::Point3_< int >::dot
        
            typedef cv::Point3_< int > exported_class_t;
            typedef int ( exported_class_t::*dot_function_type )( ::cv::Point3_< int > const & ) const;
            
            Point3i_exposer.def( 
                "dot"
                , dot_function_type( &::cv::Point3_< int >::dot )
                , ( bp::arg("pt") ) );
        
        }
        Point3i_exposer.def( "__temp_func", &cv::Point3_< int >::operator ::CvPoint3D32f , "\nWrapped function:"
    "\n    operator ::CvPoint3D32f" );
        Point3i_exposer.def( "__temp_func", &cv::Point3_< int >::operator ::cv::Vec< int, 3 > , "\nWrapped function:"
    "\n    operator ::cv::Vec<int, 3>" );
        { //::cv::Point3_< int >::operator=
        
            typedef cv::Point3_< int > exported_class_t;
            typedef ::cv::Point3_< int > & ( exported_class_t::*assign_function_type )( ::cv::Point3_< int > const & ) ;
            
            Point3i_exposer.def( 
                "assign"
                , assign_function_type( &::cv::Point3_< int >::operator= )
                , ( bp::arg("pt") )
                , bp::return_self< >()
                , "\nWrapped function:"
    "\n    operator=" );
        
        }
        Point3i_exposer.def_readwrite( "x", &cv::Point3_< int >::x );
        Point3i_exposer.def_readwrite( "y", &cv::Point3_< int >::y );
        Point3i_exposer.def_readwrite( "z", &cv::Point3_< int >::z );
        Point3i_exposer.add_property("ndarray", &sdcpp::as_ndarray< cv::Point3_<int> >);
        Point3i_exposer.def("__iadd__", &__iadd__<cv::Point3i, cv::Point3i>, bp::return_self<>() );
        Point3i_exposer.def("__isub__", &__isub__<cv::Point3i, cv::Point3i>, bp::return_self<>() );
        Point3i_exposer.def("__imul__", &__imul__<cv::Point3i, double>, bp::return_self<>() );
        Point3i_exposer.def("__add__", &__add__<cv::Point3i, cv::Point3i> );
        Point3i_exposer.def("__sub__", &__sub__<cv::Point3i, cv::Point3i> );
        Point3i_exposer.def("__eq__", &__eq__<cv::Point3i, cv::Point3i> );
        Point3i_exposer.def("__neg__", &__neg__<cv::Point3i> );
        Point3i_exposer.def("__mul__", &__mul__<cv::Point3i, double> );
        Point3i_exposer.def("__rmul__", &__rmul__<double, cv::Point3i> );
    }

    { //::cv::Point_< double >
        typedef bp::class_< cv::Point_< double > > Point2d_exposer_t;
        Point2d_exposer_t Point2d_exposer = Point2d_exposer_t( "Point2d", bp::init< >() );
        bp::scope Point2d_scope( Point2d_exposer );
        Point2d_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Point_< double > >() );
        Point2d_exposer.def( bp::init< double, double >(( bp::arg("_x"), bp::arg("_y") )) );
        Point2d_exposer.def( bp::init< cv::Point_< double > const & >(( bp::arg("pt") )) );
        Point2d_exposer.def( bp::init< CvPoint const & >(( bp::arg("pt") )) );
        bp::implicitly_convertible< CvPoint const &, cv::Point_< double > >();
        Point2d_exposer.def( bp::init< CvPoint2D32f const & >(( bp::arg("pt") )) );
        bp::implicitly_convertible< CvPoint2D32f const &, cv::Point_< double > >();
        Point2d_exposer.def( bp::init< cv::Size_< double > const & >(( bp::arg("sz") )) );
        bp::implicitly_convertible< cv::Size_< double > const &, cv::Point_< double > >();
        Point2d_exposer.def( bp::init< cv::Vec< double, 2 > const & >(( bp::arg("v") )) );
        bp::implicitly_convertible< cv::Vec< double, 2 > const &, cv::Point_< double > >();
        { //::cv::Point_< double >::ddot
        
            typedef cv::Point_< double > exported_class_t;
            typedef double ( exported_class_t::*ddot_function_type )( ::cv::Point_< double > const & ) const;
            
            Point2d_exposer.def( 
                "ddot"
                , ddot_function_type( &::cv::Point_< double >::ddot )
                , ( bp::arg("pt") ) );
        
        }
        { //::cv::Point_< double >::dot
        
            typedef cv::Point_< double > exported_class_t;
            typedef double ( exported_class_t::*dot_function_type )( ::cv::Point_< double > const & ) const;
            
            Point2d_exposer.def( 
                "dot"
                , dot_function_type( &::cv::Point_< double >::dot )
                , ( bp::arg("pt") ) );
        
        }
        { //::cv::Point_< double >::inside
        
            typedef cv::Point_< double > exported_class_t;
            typedef bool ( exported_class_t::*inside_function_type )( ::cv::Rect_< double > const & ) const;
            
            Point2d_exposer.def( 
                "inside"
                , inside_function_type( &::cv::Point_< double >::inside )
                , ( bp::arg("r") ) );
        
        }
        Point2d_exposer.def( "__temp_func", &cv::Point_< double >::operator ::CvPoint , "\nWrapped function:"
    "\n    operator ::CvPoint" );
        Point2d_exposer.def( "__temp_func", &cv::Point_< double >::operator ::CvPoint2D32f , "\nWrapped function:"
    "\n    operator ::CvPoint2D32f" );
        Point2d_exposer.def( "__temp_func", &cv::Point_< double >::operator ::cv::Vec< double, 2 > , "\nWrapped function:"
    "\n    operator ::cv::Vec<double, 2>" );
        { //::cv::Point_< double >::operator=
        
            typedef cv::Point_< double > exported_class_t;
            typedef ::cv::Point_< double > & ( exported_class_t::*assign_function_type )( ::cv::Point_< double > const & ) ;
            
            Point2d_exposer.def( 
                "assign"
                , assign_function_type( &::cv::Point_< double >::operator= )
                , ( bp::arg("pt") )
                , bp::return_self< >()
                , "\nWrapped function:"
    "\n    operator=" );
        
        }
        Point2d_exposer.def_readwrite( "x", &cv::Point_< double >::x );
        Point2d_exposer.def_readwrite( "y", &cv::Point_< double >::y );
        Point2d_exposer.add_property("ndarray", &sdcpp::as_ndarray< cv::Point_<double> >);
        Point2d_exposer.def("__iadd__", &__iadd__<cv::Point2d, cv::Point2d>, bp::return_self<>() );
        Point2d_exposer.def("__isub__", &__isub__<cv::Point2d, cv::Point2d>, bp::return_self<>() );
        Point2d_exposer.def("__imul__", &__imul__<cv::Point2d, double>, bp::return_self<>() );
        Point2d_exposer.def("__add__", &__add__<cv::Point2d, cv::Point2d> );
        Point2d_exposer.def("__sub__", &__sub__<cv::Point2d, cv::Point2d> );
        Point2d_exposer.def("__eq__", &__eq__<cv::Point2d, cv::Point2d> );
        Point2d_exposer.def("__neg__", &__neg__<cv::Point2d> );
        Point2d_exposer.def("__mul__", &__mul__<cv::Point2d, double> );
        Point2d_exposer.def("__rmul__", &__rmul__<double, cv::Point2d> );
    }

    { //::cv::Point_< float >
        typedef bp::class_< cv::Point_< float > > Point2f_exposer_t;
        Point2f_exposer_t Point2f_exposer = Point2f_exposer_t( "Point2f", bp::init< >() );
        bp::scope Point2f_scope( Point2f_exposer );
        Point2f_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Point_< float > >() );
        Point2f_exposer.def( bp::init< float, float >(( bp::arg("_x"), bp::arg("_y") )) );
        Point2f_exposer.def( bp::init< cv::Point_< float > const & >(( bp::arg("pt") )) );
        Point2f_exposer.def( bp::init< CvPoint const & >(( bp::arg("pt") )) );
        bp::implicitly_convertible< CvPoint const &, cv::Point_< float > >();
        Point2f_exposer.def( bp::init< CvPoint2D32f const & >(( bp::arg("pt") )) );
        bp::implicitly_convertible< CvPoint2D32f const &, cv::Point_< float > >();
        Point2f_exposer.def( bp::init< cv::Size_< float > const & >(( bp::arg("sz") )) );
        bp::implicitly_convertible< cv::Size_< float > const &, cv::Point_< float > >();
        Point2f_exposer.def( bp::init< cv::Vec< float, 2 > const & >(( bp::arg("v") )) );
        bp::implicitly_convertible< cv::Vec< float, 2 > const &, cv::Point_< float > >();
        { //::cv::Point_< float >::ddot
        
            typedef cv::Point_< float > exported_class_t;
            typedef double ( exported_class_t::*ddot_function_type )( ::cv::Point_< float > const & ) const;
            
            Point2f_exposer.def( 
                "ddot"
                , ddot_function_type( &::cv::Point_< float >::ddot )
                , ( bp::arg("pt") ) );
        
        }
        { //::cv::Point_< float >::dot
        
            typedef cv::Point_< float > exported_class_t;
            typedef float ( exported_class_t::*dot_function_type )( ::cv::Point_< float > const & ) const;
            
            Point2f_exposer.def( 
                "dot"
                , dot_function_type( &::cv::Point_< float >::dot )
                , ( bp::arg("pt") ) );
        
        }
        { //::cv::Point_< float >::inside
        
            typedef cv::Point_< float > exported_class_t;
            typedef bool ( exported_class_t::*inside_function_type )( ::cv::Rect_< float > const & ) const;
            
            Point2f_exposer.def( 
                "inside"
                , inside_function_type( &::cv::Point_< float >::inside )
                , ( bp::arg("r") ) );
        
        }
        Point2f_exposer.def( "__temp_func", &cv::Point_< float >::operator ::CvPoint , "\nWrapped function:"
    "\n    operator ::CvPoint" );
        Point2f_exposer.def( "__temp_func", &cv::Point_< float >::operator ::CvPoint2D32f , "\nWrapped function:"
    "\n    operator ::CvPoint2D32f" );
        Point2f_exposer.def( "__temp_func", &cv::Point_< float >::operator ::cv::Vec< float, 2 > , "\nWrapped function:"
    "\n    operator ::cv::Vec<float, 2>" );
        { //::cv::Point_< float >::operator=
        
            typedef cv::Point_< float > exported_class_t;
            typedef ::cv::Point_< float > & ( exported_class_t::*assign_function_type )( ::cv::Point_< float > const & ) ;
            
            Point2f_exposer.def( 
                "assign"
                , assign_function_type( &::cv::Point_< float >::operator= )
                , ( bp::arg("pt") )
                , bp::return_self< >()
                , "\nWrapped function:"
    "\n    operator=" );
        
        }
        Point2f_exposer.def_readwrite( "x", &cv::Point_< float >::x );
        Point2f_exposer.def_readwrite( "y", &cv::Point_< float >::y );
        Point2f_exposer.add_property("ndarray", &sdcpp::as_ndarray< cv::Point_<float> >);
        Point2f_exposer.def("__iadd__", &__iadd__<cv::Point2f, cv::Point2f>, bp::return_self<>() );
        Point2f_exposer.def("__isub__", &__isub__<cv::Point2f, cv::Point2f>, bp::return_self<>() );
        Point2f_exposer.def("__imul__", &__imul__<cv::Point2f, double>, bp::return_self<>() );
        Point2f_exposer.def("__add__", &__add__<cv::Point2f, cv::Point2f> );
        Point2f_exposer.def("__sub__", &__sub__<cv::Point2f, cv::Point2f> );
        Point2f_exposer.def("__eq__", &__eq__<cv::Point2f, cv::Point2f> );
        Point2f_exposer.def("__neg__", &__neg__<cv::Point2f> );
        Point2f_exposer.def("__mul__", &__mul__<cv::Point2f, double> );
        Point2f_exposer.def("__rmul__", &__rmul__<double, cv::Point2f> );
    }

    { //::cv::Point_< int >
        typedef bp::class_< cv::Point_< int > > Point2i_exposer_t;
        Point2i_exposer_t Point2i_exposer = Point2i_exposer_t( "Point2i", bp::init< >() );
        bp::scope Point2i_scope( Point2i_exposer );
        Point2i_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Point_< int > >() );
        Point2i_exposer.def( bp::init< int, int >(( bp::arg("_x"), bp::arg("_y") )) );
        Point2i_exposer.def( bp::init< cv::Point_< int > const & >(( bp::arg("pt") )) );
        Point2i_exposer.def( bp::init< CvPoint const & >(( bp::arg("pt") )) );
        bp::implicitly_convertible< CvPoint const &, cv::Point_< int > >();
        Point2i_exposer.def( bp::init< CvPoint2D32f const & >(( bp::arg("pt") )) );
        bp::implicitly_convertible< CvPoint2D32f const &, cv::Point_< int > >();
        Point2i_exposer.def( bp::init< cv::Size_< int > const & >(( bp::arg("sz") )) );
        bp::implicitly_convertible< cv::Size_< int > const &, cv::Point_< int > >();
        Point2i_exposer.def( bp::init< cv::Vec< int, 2 > const & >(( bp::arg("v") )) );
        bp::implicitly_convertible< cv::Vec< int, 2 > const &, cv::Point_< int > >();
        { //::cv::Point_< int >::ddot
        
            typedef cv::Point_< int > exported_class_t;
            typedef double ( exported_class_t::*ddot_function_type )( ::cv::Point_< int > const & ) const;
            
            Point2i_exposer.def( 
                "ddot"
                , ddot_function_type( &::cv::Point_< int >::ddot )
                , ( bp::arg("pt") ) );
        
        }
        { //::cv::Point_< int >::dot
        
            typedef cv::Point_< int > exported_class_t;
            typedef int ( exported_class_t::*dot_function_type )( ::cv::Point_< int > const & ) const;
            
            Point2i_exposer.def( 
                "dot"
                , dot_function_type( &::cv::Point_< int >::dot )
                , ( bp::arg("pt") ) );
        
        }
        { //::cv::Point_< int >::inside
        
            typedef cv::Point_< int > exported_class_t;
            typedef bool ( exported_class_t::*inside_function_type )( ::cv::Rect_< int > const & ) const;
            
            Point2i_exposer.def( 
                "inside"
                , inside_function_type( &::cv::Point_< int >::inside )
                , ( bp::arg("r") ) );
        
        }
        Point2i_exposer.def( "__temp_func", &cv::Point_< int >::operator ::CvPoint , "\nWrapped function:"
    "\n    operator ::CvPoint" );
        Point2i_exposer.def( "__temp_func", &cv::Point_< int >::operator ::CvPoint2D32f , "\nWrapped function:"
    "\n    operator ::CvPoint2D32f" );
        Point2i_exposer.def( "__temp_func", &cv::Point_< int >::operator ::cv::Vec< int, 2 > , "\nWrapped function:"
    "\n    operator ::cv::Vec<int, 2>" );
        { //::cv::Point_< int >::operator=
        
            typedef cv::Point_< int > exported_class_t;
            typedef ::cv::Point_< int > & ( exported_class_t::*assign_function_type )( ::cv::Point_< int > const & ) ;
            
            Point2i_exposer.def( 
                "assign"
                , assign_function_type( &::cv::Point_< int >::operator= )
                , ( bp::arg("pt") )
                , bp::return_self< >()
                , "\nWrapped function:"
    "\n    operator=" );
        
        }
        Point2i_exposer.def_readwrite( "x", &cv::Point_< int >::x );
        Point2i_exposer.def_readwrite( "y", &cv::Point_< int >::y );
        Point2i_exposer.add_property("ndarray", &sdcpp::as_ndarray< cv::Point_<int> >);
        Point2i_exposer.def("__iadd__", &__iadd__<cv::Point2i, cv::Point2i>, bp::return_self<>() );
        Point2i_exposer.def("__isub__", &__isub__<cv::Point2i, cv::Point2i>, bp::return_self<>() );
        Point2i_exposer.def("__imul__", &__imul__<cv::Point2i, double>, bp::return_self<>() );
        Point2i_exposer.def("__add__", &__add__<cv::Point2i, cv::Point2i> );
        Point2i_exposer.def("__sub__", &__sub__<cv::Point2i, cv::Point2i> );
        Point2i_exposer.def("__eq__", &__eq__<cv::Point2i, cv::Point2i> );
        Point2i_exposer.def("__neg__", &__neg__<cv::Point2i> );
        Point2i_exposer.def("__mul__", &__mul__<cv::Point2i, double> );
        Point2i_exposer.def("__rmul__", &__rmul__<double, cv::Point2i> );
    }

    { //::cv::Ptr< cv::Mat >
        typedef bp::class_< cv::Ptr< cv::Mat > > Ptr_Mat_exposer_t;
        Ptr_Mat_exposer_t Ptr_Mat_exposer = Ptr_Mat_exposer_t( "Ptr_Mat", bp::init< >() );
        bp::scope Ptr_Mat_scope( Ptr_Mat_exposer );
        Ptr_Mat_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Ptr< cv::Mat > >() );
        { //::cv::Ptr< cv::Mat >::addref
        
            typedef cv::Ptr< cv::Mat > exported_class_t;
            typedef void ( exported_class_t::*addref_function_type )(  ) ;
            
            Ptr_Mat_exposer.def( 
                "addref"
                , addref_function_type( &::cv::Ptr< cv::Mat >::addref ) );
        
        }
        { //::cv::Ptr< cv::Mat >::delete_obj
        
            typedef cv::Ptr< cv::Mat > exported_class_t;
            typedef void ( exported_class_t::*delete_obj_function_type )(  ) ;
            
            Ptr_Mat_exposer.def( 
                "delete_obj"
                , delete_obj_function_type( &::cv::Ptr< cv::Mat >::delete_obj ) );
        
        }
        { //::cv::Ptr< cv::Mat >::empty
        
            typedef cv::Ptr< cv::Mat > exported_class_t;
            typedef bool ( exported_class_t::*empty_function_type )(  ) const;
            
            Ptr_Mat_exposer.def( 
                "empty"
                , empty_function_type( &::cv::Ptr< cv::Mat >::empty ) );
        
        }
        { //::cv::Ptr< cv::Mat >::release
        
            typedef cv::Ptr< cv::Mat > exported_class_t;
            typedef void ( exported_class_t::*release_function_type )(  ) ;
            
            Ptr_Mat_exposer.def( 
                "release"
                , release_function_type( &::cv::Ptr< cv::Mat >::release ) );
        
        }
        Ptr_Mat_exposer.def("fromMat", &::Ptr_Mat_from_Mat, (bp::arg("inst_Mat")));
        Ptr_Mat_exposer.staticmethod("fromMat");
        Ptr_Mat_exposer.add_property("pointee", bp::make_function(&::Ptr_Mat_pointee, bp::return_internal_reference<>()));
    }

    { //::cv::Seq< cv::Point_< int > >
        typedef bp::class_< cv::Seq< cv::Point_< int > > > Seq_Point2i_exposer_t;
        Seq_Point2i_exposer_t Seq_Point2i_exposer = Seq_Point2i_exposer_t( "Seq_Point2i", bp::init< >() );
        bp::scope Seq_Point2i_scope( Seq_Point2i_exposer );
        Seq_Point2i_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Seq< cv::Point_< int > > >() );
        Seq_Point2i_exposer.def( bp::init< CvSeq const * >(( bp::arg("_seq") )) );
        bp::implicitly_convertible< CvSeq const *, cv::Seq< cv::Point_< int > > >();
        Seq_Point2i_exposer.def( bp::init< cv::Ptr< CvMemStorage > &, bp::optional< int > >(( bp::arg("storage"), bp::arg("headerSize")=(int)(56u) )) );
        bp::implicitly_convertible< cv::Ptr< CvMemStorage > &, cv::Seq< cv::Point_< int > > >();
        { //::cv::Seq< cv::Point_< int > >::channels
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef int ( exported_class_t::*channels_function_type )(  ) const;
            
            Seq_Point2i_exposer.def( 
                "channels"
                , channels_function_type( &::cv::Seq< cv::Point_< int > >::channels ) );
        
        }
        { //::cv::Seq< cv::Point_< int > >::clear
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef void ( exported_class_t::*clear_function_type )(  ) ;
            
            Seq_Point2i_exposer.def( 
                "clear"
                , clear_function_type( &::cv::Seq< cv::Point_< int > >::clear ) );
        
        }
        { //::cv::Seq< cv::Point_< int > >::copyTo
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef void ( exported_class_t::*copyTo_function_type )( ::std::vector< cv::Point_<int> > &,::cv::Range const & ) const;
            
            Seq_Point2i_exposer.def( 
                "copyTo"
                , copyTo_function_type( &::cv::Seq< cv::Point_< int > >::copyTo )
                , ( bp::arg("vec"), bp::arg("range")=cv::Range::all() ) );
        
        }
        { //::cv::Seq< cv::Point_< int > >::depth
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef int ( exported_class_t::*depth_function_type )(  ) const;
            
            Seq_Point2i_exposer.def( 
                "depth"
                , depth_function_type( &::cv::Seq< cv::Point_< int > >::depth ) );
        
        }
        { //::cv::Seq< cv::Point_< int > >::elemSize
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef ::size_t ( exported_class_t::*elemSize_function_type )(  ) const;
            
            Seq_Point2i_exposer.def( 
                "elemSize"
                , elemSize_function_type( &::cv::Seq< cv::Point_< int > >::elemSize ) );
        
        }
        { //::cv::Seq< cv::Point_< int > >::empty
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef bool ( exported_class_t::*empty_function_type )(  ) const;
            
            Seq_Point2i_exposer.def( 
                "empty"
                , empty_function_type( &::cv::Seq< cv::Point_< int > >::empty ) );
        
        }
        { //::cv::Seq< cv::Point_< int > >::index
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef ::size_t ( exported_class_t::*index_function_type )( ::cv::Point_< int > const & ) const;
            
            Seq_Point2i_exposer.def( 
                "index"
                , index_function_type( &::cv::Seq< cv::Point_< int > >::index )
                , ( bp::arg("elem") ) );
        
        }
        { //::cv::Seq< cv::Point_< int > >::insert
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef void ( exported_class_t::*insert_function_type )( int,::cv::Point_< int > const & ) ;
            
            Seq_Point2i_exposer.def( 
                "insert"
                , insert_function_type( &::cv::Seq< cv::Point_< int > >::insert )
                , ( bp::arg("idx"), bp::arg("elem") ) );
        
        }
        Seq_Point2i_exposer.def( "__temp_func", &cv::Seq< cv::Point_< int > >::operator ::std::vector< cv::Point_<int> > , "\nWrapped function:"
    "\n    operator ::std::vector<cv::Point_<int>, "
    "\n    std::allocator<cv::Point_<int> > >" );
        { //::cv::Seq< cv::Point_< int > >::operator[]
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef ::cv::Point_< int > & ( exported_class_t::*__getitem___function_type )( int ) ;
            
            Seq_Point2i_exposer.def( 
                "__getitem__"
                , __getitem___function_type( &::cv::Seq< cv::Point_< int > >::operator[] )
                , ( bp::arg("idx") )
                , bp::return_internal_reference< >()
                , "\nWrapped function:"
    "\n    operator[]" );
        
        }
        { //::cv::Seq< cv::Point_< int > >::operator[]
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef ::cv::Point_< int > const & ( exported_class_t::*__getitem___function_type )( int ) const;
            
            Seq_Point2i_exposer.def( 
                "__getitem__"
                , __getitem___function_type( &::cv::Seq< cv::Point_< int > >::operator[] )
                , ( bp::arg("idx") )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "\nWrapped function:"
    "\n    operator[]" );
        
        }
        { //::cv::Seq< cv::Point_< int > >::pop_back
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef void ( exported_class_t::*pop_back_function_type )(  ) ;
            
            Seq_Point2i_exposer.def( 
                "pop_back"
                , pop_back_function_type( &::cv::Seq< cv::Point_< int > >::pop_back ) );
        
        }
        { //::cv::Seq< cv::Point_< int > >::pop_front
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef void ( exported_class_t::*pop_front_function_type )(  ) ;
            
            Seq_Point2i_exposer.def( 
                "pop_front"
                , pop_front_function_type( &::cv::Seq< cv::Point_< int > >::pop_front ) );
        
        }
        { //::cv::Seq< cv::Point_< int > >::push_back
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef void ( exported_class_t::*push_back_function_type )( ::cv::Point_< int > const & ) ;
            
            Seq_Point2i_exposer.def( 
                "push_back"
                , push_back_function_type( &::cv::Seq< cv::Point_< int > >::push_back )
                , ( bp::arg("elem") ) );
        
        }
        { //::cv::Seq< cv::Point_< int > >::push_front
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef void ( exported_class_t::*push_front_function_type )( ::cv::Point_< int > const & ) ;
            
            Seq_Point2i_exposer.def( 
                "push_front"
                , push_front_function_type( &::cv::Seq< cv::Point_< int > >::push_front )
                , ( bp::arg("elem") ) );
        
        }
        { //::cv::Seq< cv::Point_< int > >::remove
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef void ( exported_class_t::*remove_function_type )( int ) ;
            
            Seq_Point2i_exposer.def( 
                "remove"
                , remove_function_type( &::cv::Seq< cv::Point_< int > >::remove )
                , ( bp::arg("idx") ) );
        
        }
        { //::cv::Seq< cv::Point_< int > >::remove
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef void ( exported_class_t::*remove_function_type )( ::cv::Range const & ) ;
            
            Seq_Point2i_exposer.def( 
                "remove"
                , remove_function_type( &::cv::Seq< cv::Point_< int > >::remove )
                , ( bp::arg("r") ) );
        
        }
        { //::cv::Seq< cv::Point_< int > >::size
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef ::size_t ( exported_class_t::*size_function_type )(  ) const;
            
            Seq_Point2i_exposer.def( 
                "size"
                , size_function_type( &::cv::Seq< cv::Point_< int > >::size ) );
        
        }
        { //::cv::Seq< cv::Point_< int > >::type
        
            typedef cv::Seq< cv::Point_< int > > exported_class_t;
            typedef int ( exported_class_t::*type_function_type )(  ) const;
            
            Seq_Point2i_exposer.def( 
                "type"
                , type_function_type( &::cv::Seq< cv::Point_< int > >::type ) );
        
        }
        Seq_Point2i_exposer.def("__len__", &::Seq_Point2i_len);
        Seq_Point2i_exposer.add_property( "seq", bp::make_function(&::get_Seq_Point2i_seq, bp::return_internal_reference<>()) );
    }

    { //::cxcore_hpp_point_dummy_struct
        typedef bp::class_< cxcore_hpp_point_dummy_struct > __cxcore_hpp_point_dummy_struct_exposer_t;
        __cxcore_hpp_point_dummy_struct_exposer_t __cxcore_hpp_point_dummy_struct_exposer = __cxcore_hpp_point_dummy_struct_exposer_t( "__cxcore_hpp_point_dummy_struct" );
        bp::scope __cxcore_hpp_point_dummy_struct_scope( __cxcore_hpp_point_dummy_struct_exposer );
        __cxcore_hpp_point_dummy_struct_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cxcore_hpp_point_dummy_struct >() );
        bp::class_< cxcore_hpp_point_dummy_struct::dummy_struct2 >( "dummy_struct2" )    
            .add_property( "this", pyplus_conv::make_addressof_inst_getter< cxcore_hpp_point_dummy_struct::dummy_struct2 >() );
        __cxcore_hpp_point_dummy_struct_exposer.setattr("v0", 0);
    }
    {
        
        bp::def("convert_vector_Point2i_to_ndarray", &sdcpp::vector_to_ndarray2< cv::Point_< int > >, (bp::arg("inst_vector_Point2i")) );
        bp::def("convert_ndarray_to_vector_Point2i", &sdcpp::ndarray_to_vector2< cv::Point_< int > >, (bp::arg("inst_ndarray")) );
        bp::def("convert_Point2i_to_CvPoint", &::normal_cast< ::cv::Point_< int >, ::CvPoint >, (bp::arg("inst_Point2i")));
        bp::def("convert_Point2i_to_CvPoint2D32f", &::normal_cast< ::cv::Point_< int >, ::CvPoint2D32f >, (bp::arg("inst_Point2i")));
        bp::def("convert_Point2i_to_Vec2i", &::normal_cast< ::cv::Point_< int >, ::cv::Vec< int, 2 > >, (bp::arg("inst_Point2i")));
        bp::def("convert_vector_Point2f_to_ndarray", &sdcpp::vector_to_ndarray2< cv::Point_< float > >, (bp::arg("inst_vector_Point2f")) );
        bp::def("convert_ndarray_to_vector_Point2f", &sdcpp::ndarray_to_vector2< cv::Point_< float > >, (bp::arg("inst_ndarray")) );
        bp::def("convert_Point2f_to_CvPoint", &::normal_cast< ::cv::Point_< float >, ::CvPoint >, (bp::arg("inst_Point2f")));
        bp::def("convert_Point2f_to_CvPoint2D32f", &::normal_cast< ::cv::Point_< float >, ::CvPoint2D32f >, (bp::arg("inst_Point2f")));
        bp::def("convert_Point2f_to_Vec2f", &::normal_cast< ::cv::Point_< float >, ::cv::Vec< float, 2 > >, (bp::arg("inst_Point2f")));
        bp::def("convert_vector_Point2d_to_ndarray", &sdcpp::vector_to_ndarray2< cv::Point_< double > >, (bp::arg("inst_vector_Point2d")) );
        bp::def("convert_ndarray_to_vector_Point2d", &sdcpp::ndarray_to_vector2< cv::Point_< double > >, (bp::arg("inst_ndarray")) );
        bp::def("convert_Point2d_to_CvPoint", &::normal_cast< ::cv::Point_< double >, ::CvPoint >, (bp::arg("inst_Point2d")));
        bp::def("convert_Point2d_to_CvPoint2D32f", &::normal_cast< ::cv::Point_< double >, ::CvPoint2D32f >, (bp::arg("inst_Point2d")));
        bp::def("convert_Point2d_to_Vec2d", &::normal_cast< ::cv::Point_< double >, ::cv::Vec< double, 2 > >, (bp::arg("inst_Point2d")));
        bp::def("convert_Seq_Point2i_to_vector_Point2i", &::normal_cast< ::cv::Seq< cv::Point_< int > >, ::std::vector< cv::Point_<int> > >, (bp::arg("inst_Seq_Point2i")));
        bp::def("convert_Point2i_to_Point2f", &::normal_cast< ::cv::Point_<int>, ::cv::Point_<float> >, (bp::arg("inst_Point2i")));
        bp::def("convert_Point2i_to_Point2d", &::normal_cast< ::cv::Point_<int>, ::cv::Point_<double> >, (bp::arg("inst_Point2i")));
        bp::def("convert_Point2f_to_Point2i", &::normal_cast< ::cv::Point_<float>, ::cv::Point_<int> >, (bp::arg("inst_Point2f")));
        bp::def("convert_Point2f_to_Point2d", &::normal_cast< ::cv::Point_<float>, ::cv::Point_<double> >, (bp::arg("inst_Point2f")));
        bp::def("convert_Point2d_to_Point2i", &::normal_cast< ::cv::Point_<double>, ::cv::Point_<int> >, (bp::arg("inst_Point2d")));
        bp::def("convert_Point2d_to_Point2f", &::normal_cast< ::cv::Point_<double>, ::cv::Point_<float> >, (bp::arg("inst_Point2d")));
        bp::def("convert_vector_Point3i_to_ndarray", &sdcpp::vector_to_ndarray2< cv::Point3_< int > >, (bp::arg("inst_vector_Point3i")) );
        bp::def("convert_ndarray_to_vector_Point3i", &sdcpp::ndarray_to_vector2< cv::Point3_< int > >, (bp::arg("inst_ndarray")) );
        bp::def("convert_Point3i_to_CvPoint3D32f", &::normal_cast< ::cv::Point3_< int >, ::CvPoint3D32f >, (bp::arg("inst_Point3i")));
        bp::def("convert_Point3i_to_Vec3i", &::normal_cast< ::cv::Point3_< int >, ::cv::Vec< int, 3 > >, (bp::arg("inst_Point3i")));
        bp::def("convert_vector_Point3f_to_ndarray", &sdcpp::vector_to_ndarray2< cv::Point3_< float > >, (bp::arg("inst_vector_Point3f")) );
        bp::def("convert_ndarray_to_vector_Point3f", &sdcpp::ndarray_to_vector2< cv::Point3_< float > >, (bp::arg("inst_ndarray")) );
        bp::def("convert_Point3f_to_CvPoint3D32f", &::normal_cast< ::cv::Point3_< float >, ::CvPoint3D32f >, (bp::arg("inst_Point3f")));
        bp::def("convert_Point3f_to_Vec3f", &::normal_cast< ::cv::Point3_< float >, ::cv::Vec< float, 3 > >, (bp::arg("inst_Point3f")));
        bp::def("convert_vector_Point3d_to_ndarray", &sdcpp::vector_to_ndarray2< cv::Point3_< double > >, (bp::arg("inst_vector_Point3d")) );
        bp::def("convert_ndarray_to_vector_Point3d", &sdcpp::ndarray_to_vector2< cv::Point3_< double > >, (bp::arg("inst_ndarray")) );
        bp::def("convert_Point3d_to_CvPoint3D32f", &::normal_cast< ::cv::Point3_< double >, ::CvPoint3D32f >, (bp::arg("inst_Point3d")));
        bp::def("convert_Point3d_to_Vec3d", &::normal_cast< ::cv::Point3_< double >, ::cv::Vec< double, 3 > >, (bp::arg("inst_Point3d")));
        bp::def("convert_Point3i_to_Point3f", &::normal_cast< ::cv::Point3_<int>, ::cv::Point3_<float> >, (bp::arg("inst_Point3i")));
        bp::def("convert_Point3i_to_Point3d", &::normal_cast< ::cv::Point3_<int>, ::cv::Point3_<double> >, (bp::arg("inst_Point3i")));
        bp::def("convert_Point3f_to_Point3i", &::normal_cast< ::cv::Point3_<float>, ::cv::Point3_<int> >, (bp::arg("inst_Point3f")));
        bp::def("convert_Point3f_to_Point3d", &::normal_cast< ::cv::Point3_<float>, ::cv::Point3_<double> >, (bp::arg("inst_Point3f")));
        bp::def("convert_Point3d_to_Point3i", &::normal_cast< ::cv::Point3_<double>, ::cv::Point3_<int> >, (bp::arg("inst_Point3d")));
        bp::def("convert_Point3d_to_Point3f", &::normal_cast< ::cv::Point3_<double>, ::cv::Point3_<float> >, (bp::arg("inst_Point3d")));
        bp::def("convert_Mat_to_CvMat", &::normal_cast< ::cv::Mat, ::CvMat >, (bp::arg("inst_Mat")));
        bp::def("convert_CvMat_to_Mat", &::normal_cast< ::CvMat, ::cv::Mat >, (bp::arg("inst_CvMat")));
        bp::def("convert_Mat_to_vector_Vec4f", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<float, 4> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec4f_to_Mat", &::normal_cast< ::std::vector< cv::Vec<float, 4> >, ::cv::Mat >, (bp::arg("inst_vector_Vec4f")));
        bp::def("convert_Mat_to_vector_int16", &::normal_cast< ::cv::Mat, ::std::vector< short > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_int16_to_Mat", &::normal_cast< ::std::vector< short >, ::cv::Mat >, (bp::arg("inst_vector_int16")));
        bp::def("convert_Mat_to_vector_Vec4b", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<unsigned char, 4> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec4b_to_Mat", &::normal_cast< ::std::vector< cv::Vec<unsigned char, 4> >, ::cv::Mat >, (bp::arg("inst_vector_Vec4b")));
        bp::def("convert_Mat_to_vector_int", &::normal_cast< ::cv::Mat, ::std::vector< int > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_int_to_Mat", &::normal_cast< ::std::vector< int >, ::cv::Mat >, (bp::arg("inst_vector_int")));
        bp::def("convert_Mat_to_vector_vector_int", &::normal_cast< ::cv::Mat, ::std::vector< std::vector< int > > >, (bp::arg("inst_Mat")));
        bp::def("convert_Mat_to_vector_uint8", &::normal_cast< ::cv::Mat, ::std::vector< unsigned char > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_uint8_to_Mat", &::normal_cast< ::std::vector< unsigned char >, ::cv::Mat >, (bp::arg("inst_vector_uint8")));
        bp::def("convert_Mat_to_vector_Vec4i", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<int, 4> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec4i_to_Mat", &::normal_cast< ::std::vector< cv::Vec<int, 4> >, ::cv::Mat >, (bp::arg("inst_vector_Vec4i")));
        bp::def("convert_Mat_to_vector_Vec4w", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<unsigned short, 4> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec4w_to_Mat", &::normal_cast< ::std::vector< cv::Vec<unsigned short, 4> >, ::cv::Mat >, (bp::arg("inst_vector_Vec4w")));
        bp::def("convert_Mat_to_vector_Point3i", &::normal_cast< ::cv::Mat, ::std::vector< cv::Point3_<int> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Point3i_to_Mat", &::normal_cast< ::std::vector< cv::Point3_<int> >, ::cv::Mat >, (bp::arg("inst_vector_Point3i")));
        bp::def("convert_Mat_to_vector_vector_Point3i", &::normal_cast< ::cv::Mat, ::std::vector< std::vector< cv::Point3_<int> > > >, (bp::arg("inst_Mat")));
        bp::def("convert_Mat_to_vector_Point2i", &::normal_cast< ::cv::Mat, ::std::vector< cv::Point_<int> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Point2i_to_Mat", &::normal_cast< ::std::vector< cv::Point_<int> >, ::cv::Mat >, (bp::arg("inst_vector_Point2i")));
        bp::def("convert_Mat_to_vector_vector_Point2i", &::normal_cast< ::cv::Mat, ::std::vector< std::vector< cv::Point_<int> > > >, (bp::arg("inst_Mat")));
        bp::def("convert_Mat_to_vector_Vec4d", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<double, 4> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec4d_to_Mat", &::normal_cast< ::std::vector< cv::Vec<double, 4> >, ::cv::Mat >, (bp::arg("inst_vector_Vec4d")));
        bp::def("convert_Mat_to_vector_Vec4s", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<short, 4> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec4s_to_Mat", &::normal_cast< ::std::vector< cv::Vec<short, 4> >, ::cv::Mat >, (bp::arg("inst_vector_Vec4s")));
        bp::def("convert_Mat_to_vector_Vec2f", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<float, 2> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec2f_to_Mat", &::normal_cast< ::std::vector< cv::Vec<float, 2> >, ::cv::Mat >, (bp::arg("inst_vector_Vec2f")));
        bp::def("convert_Mat_to_vector_Range", &::normal_cast< ::cv::Mat, ::std::vector< cv::Range > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Range_to_Mat", &::normal_cast< ::std::vector< cv::Range >, ::cv::Mat >, (bp::arg("inst_vector_Range")));
        bp::def("convert_Mat_to_vector_Point3d", &::normal_cast< ::cv::Mat, ::std::vector< cv::Point3_<double> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Point3d_to_Mat", &::normal_cast< ::std::vector< cv::Point3_<double> >, ::cv::Mat >, (bp::arg("inst_vector_Point3d")));
        bp::def("convert_Mat_to_vector_vector_Point3d", &::normal_cast< ::cv::Mat, ::std::vector< std::vector< cv::Point3_<double> > > >, (bp::arg("inst_Mat")));
        bp::def("convert_Mat_to_vector_int8", &::normal_cast< ::cv::Mat, ::std::vector< char > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_int8_to_Mat", &::normal_cast< ::std::vector< char >, ::cv::Mat >, (bp::arg("inst_vector_int8")));
        bp::def("convert_Mat_to_vector_Point3f", &::normal_cast< ::cv::Mat, ::std::vector< cv::Point3_<float> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Point3f_to_Mat", &::normal_cast< ::std::vector< cv::Point3_<float> >, ::cv::Mat >, (bp::arg("inst_vector_Point3f")));
        bp::def("convert_Mat_to_vector_vector_Point3f", &::normal_cast< ::cv::Mat, ::std::vector< std::vector< cv::Point3_<float> > > >, (bp::arg("inst_Mat")));
        bp::def("convert_Mat_to_vector_Point2d", &::normal_cast< ::cv::Mat, ::std::vector< cv::Point_<double> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Point2d_to_Mat", &::normal_cast< ::std::vector< cv::Point_<double> >, ::cv::Mat >, (bp::arg("inst_vector_Point2d")));
        bp::def("convert_Mat_to_vector_vector_Point2d", &::normal_cast< ::cv::Mat, ::std::vector< std::vector< cv::Point_<double> > > >, (bp::arg("inst_Mat")));
        bp::def("convert_Mat_to_vector_Vec3w", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<unsigned short, 3> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec3w_to_Mat", &::normal_cast< ::std::vector< cv::Vec<unsigned short, 3> >, ::cv::Mat >, (bp::arg("inst_vector_Vec3w")));
        bp::def("convert_Mat_to_vector_Vec2w", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<unsigned short, 2> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec2w_to_Mat", &::normal_cast< ::std::vector< cv::Vec<unsigned short, 2> >, ::cv::Mat >, (bp::arg("inst_vector_Vec2w")));
        bp::def("convert_Mat_to_vector_Vec3s", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<short, 3> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec3s_to_Mat", &::normal_cast< ::std::vector< cv::Vec<short, 3> >, ::cv::Mat >, (bp::arg("inst_vector_Vec3s")));
        bp::def("convert_Mat_to_vector_Vec2s", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<short, 2> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec2s_to_Mat", &::normal_cast< ::std::vector< cv::Vec<short, 2> >, ::cv::Mat >, (bp::arg("inst_vector_Vec2s")));
        bp::def("convert_Mat_to_vector_float64", &::normal_cast< ::cv::Mat, ::std::vector< double > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_float64_to_Mat", &::normal_cast< ::std::vector< double >, ::cv::Mat >, (bp::arg("inst_vector_float64")));
        bp::def("convert_Mat_to_vector_Scalar", &::normal_cast< ::cv::Mat, ::std::vector< cv::Scalar_<double> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Scalar_to_Mat", &::normal_cast< ::std::vector< cv::Scalar_<double> >, ::cv::Mat >, (bp::arg("inst_vector_Scalar")));
        bp::def("convert_Mat_to_vector_Point2f", &::normal_cast< ::cv::Mat, ::std::vector< cv::Point_<float> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Point2f_to_Mat", &::normal_cast< ::std::vector< cv::Point_<float> >, ::cv::Mat >, (bp::arg("inst_vector_Point2f")));
        bp::def("convert_Mat_to_vector_vector_Point2f", &::normal_cast< ::cv::Mat, ::std::vector< std::vector< cv::Point_<float> > > >, (bp::arg("inst_Mat")));
        bp::def("convert_Mat_to_vector_Vec3f", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<float, 3> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec3f_to_Mat", &::normal_cast< ::std::vector< cv::Vec<float, 3> >, ::cv::Mat >, (bp::arg("inst_vector_Vec3f")));
        bp::def("convert_Mat_to_vector_Vec2d", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<double, 2> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec2d_to_Mat", &::normal_cast< ::std::vector< cv::Vec<double, 2> >, ::cv::Mat >, (bp::arg("inst_vector_Vec2d")));
        bp::def("convert_Mat_to_vector_Vec3d", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<double, 3> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec3d_to_Mat", &::normal_cast< ::std::vector< cv::Vec<double, 3> >, ::cv::Mat >, (bp::arg("inst_vector_Vec3d")));
        bp::def("convert_Mat_to_vector_uint16", &::normal_cast< ::cv::Mat, ::std::vector< unsigned short > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_uint16_to_Mat", &::normal_cast< ::std::vector< unsigned short >, ::cv::Mat >, (bp::arg("inst_vector_uint16")));
        bp::def("convert_Mat_to_vector_Vec3b", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<unsigned char, 3> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec3b_to_Mat", &::normal_cast< ::std::vector< cv::Vec<unsigned char, 3> >, ::cv::Mat >, (bp::arg("inst_vector_Vec3b")));
        bp::def("convert_Mat_to_vector_Vec2b", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<unsigned char, 2> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec2b_to_Mat", &::normal_cast< ::std::vector< cv::Vec<unsigned char, 2> >, ::cv::Mat >, (bp::arg("inst_vector_Vec2b")));
        bp::def("convert_Mat_to_vector_Vec6f", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<float, 6> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec6f_to_Mat", &::normal_cast< ::std::vector< cv::Vec<float, 6> >, ::cv::Mat >, (bp::arg("inst_vector_Vec6f")));
        bp::def("convert_Mat_to_vector_Vec2i", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<int, 2> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec2i_to_Mat", &::normal_cast< ::std::vector< cv::Vec<int, 2> >, ::cv::Mat >, (bp::arg("inst_vector_Vec2i")));
        bp::def("convert_Mat_to_vector_vector_Vec2i", &::normal_cast< ::cv::Mat, ::std::vector< std::vector< cv::Vec<int, 2> > > >, (bp::arg("inst_Mat")));
        bp::def("convert_Mat_to_vector_Vec6d", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<double, 6> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec6d_to_Mat", &::normal_cast< ::std::vector< cv::Vec<double, 6> >, ::cv::Mat >, (bp::arg("inst_vector_Vec6d")));
        bp::def("convert_Mat_to_vector_float32", &::normal_cast< ::cv::Mat, ::std::vector< float > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_float32_to_Mat", &::normal_cast< ::std::vector< float >, ::cv::Mat >, (bp::arg("inst_vector_float32")));
        bp::def("convert_Mat_to_vector_vector_float32", &::normal_cast< ::cv::Mat, ::std::vector< std::vector< float > > >, (bp::arg("inst_Mat")));
        bp::def("convert_Mat_to_vector_Vec3i", &::normal_cast< ::cv::Mat, ::std::vector< cv::Vec<int, 3> > >, (bp::arg("inst_Mat")));
        bp::def("convert_vector_Vec3i_to_Mat", &::normal_cast< ::std::vector< cv::Vec<int, 3> >, ::cv::Mat >, (bp::arg("inst_vector_Vec3i")));
        bp::def("convert_MatND_to_Mat", &::normal_cast< ::cv::MatND, ::cv::Mat >, (bp::arg("inst_MatND")));;
    }

}
