// This file has been generated by Py++.

#include "boost/python.hpp"
#include "__call_policies.pypp.hpp"
#include "__convenience.pypp.hpp"
#include "opencv_converters.hpp"
#include "__ctypes_integration.pypp.hpp"
#include "ml_wrapper.hpp"
#include "arrayobject.h"
#include "ndarray.hpp"
#include "boost/python/object.hpp"
#include "ml_ext_classes_4.pypp.hpp"

namespace bp = boost::python;

struct CvDTreeTrainData_wrapper : CvDTreeTrainData, bp::wrapper< CvDTreeTrainData > {

    CvDTreeTrainData_wrapper(CvDTreeTrainData const & arg )
    : CvDTreeTrainData( arg )
      , bp::wrapper< CvDTreeTrainData >(){
        // copy constructor
        
    }

    CvDTreeTrainData_wrapper( )
    : CvDTreeTrainData( )
      , bp::wrapper< CvDTreeTrainData >(){
        // null constructor
    
    }

    CvDTreeTrainData_wrapper(::CvMat const * _train_data, int _tflag, ::CvMat const * _responses, ::CvMat const * _var_idx=0, ::CvMat const * _sample_idx=0, ::CvMat const * _var_type=0, ::CvMat const * _missing_mask=0, ::CvDTreeParams const & _params=::CvDTreeParams( ), bool _shared=false, bool _add_labels=false )
    : CvDTreeTrainData( boost::python::ptr(_train_data), _tflag, boost::python::ptr(_responses), boost::python::ptr(_var_idx), boost::python::ptr(_sample_idx), boost::python::ptr(_var_type), boost::python::ptr(_missing_mask), boost::ref(_params), _shared, _add_labels )
      , bp::wrapper< CvDTreeTrainData >(){
        // constructor
    
    }

    virtual void clear(  ) {
        if( bp::override func_clear = this->get_override( "clear" ) )
            func_clear(  );
        else{
            this->CvDTreeTrainData::clear(  );
        }
    }
    
    void default_clear(  ) {
        CvDTreeTrainData::clear( );
    }

    virtual void do_responses_copy(  ) {
        if( bp::override func_do_responses_copy = this->get_override( "do_responses_copy" ) )
            func_do_responses_copy(  );
        else{
            this->CvDTreeTrainData::do_responses_copy(  );
        }
    }
    
    void default_do_responses_copy(  ) {
        CvDTreeTrainData::do_responses_copy( );
    }

    virtual void free_node( ::CvDTreeNode * node ) {
        if( bp::override func_free_node = this->get_override( "free_node" ) )
            func_free_node( boost::python::ptr(node) );
        else{
            this->CvDTreeTrainData::free_node( boost::python::ptr(node) );
        }
    }
    
    void default_free_node( ::CvDTreeNode * node ) {
        CvDTreeTrainData::free_node( boost::python::ptr(node) );
    }

    virtual void free_node_data( ::CvDTreeNode * node ) {
        if( bp::override func_free_node_data = this->get_override( "free_node_data" ) )
            func_free_node_data( boost::python::ptr(node) );
        else{
            this->CvDTreeTrainData::free_node_data( boost::python::ptr(node) );
        }
    }
    
    void default_free_node_data( ::CvDTreeNode * node ) {
        CvDTreeTrainData::free_node_data( boost::python::ptr(node) );
    }

    virtual void free_train_data(  ) {
        if( bp::override func_free_train_data = this->get_override( "free_train_data" ) )
            func_free_train_data(  );
        else{
            this->CvDTreeTrainData::free_train_data(  );
        }
    }
    
    void default_free_train_data(  ) {
        CvDTreeTrainData::free_train_data( );
    }

    virtual int get_child_buf_idx( ::CvDTreeNode * n ) {
        if( bp::override func_get_child_buf_idx = this->get_override( "get_child_buf_idx" ) )
            return func_get_child_buf_idx( boost::python::ptr(n) );
        else{
            return this->CvDTreeTrainData::get_child_buf_idx( boost::python::ptr(n) );
        }
    }
    
    int default_get_child_buf_idx( ::CvDTreeNode * n ) {
        return CvDTreeTrainData::get_child_buf_idx( boost::python::ptr(n) );
    }

    virtual void get_vectors( ::CvMat const * _subsample_idx, float * values, ::uchar * missing, float * responses, bool get_class_idx=false ) {
        namespace bpl = boost::python;
        if( bpl::override func_get_vectors = this->get_override( "get_vectors" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_get_vectors.ptr(), _subsample_idx, values, missing, responses, get_class_idx );
        }
        else{
            CvDTreeTrainData::get_vectors( boost::python::ptr(_subsample_idx), values, missing, responses, get_class_idx );
        }
    }
    
    static void default_get_vectors( ::CvDTreeTrainData & inst, ::cv::Mat & _subsample_idx, std::vector<float> const & values, std::vector<unsigned char> const & missing, std::vector<float> const & responses, bool get_class_idx=false ){
        if( dynamic_cast< CvDTreeTrainData_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvDTreeTrainData::get_vectors(get_CvMat_ptr(_subsample_idx), (float *)(&values[0]), (::uchar *)(&missing[0]), (float *)(&responses[0]), get_class_idx);
        }
        else{
            inst.get_vectors(get_CvMat_ptr(_subsample_idx), (float *)(&values[0]), (::uchar *)(&missing[0]), (float *)(&responses[0]), get_class_idx);
        }
    }

    virtual ::CvDTreeNode * new_node( ::CvDTreeNode * parent, int count, int storage_idx, int offset ) {
        if( bp::override func_new_node = this->get_override( "new_node" ) )
            return func_new_node( boost::python::ptr(parent), count, storage_idx, offset );
        else{
            return this->CvDTreeTrainData::new_node( boost::python::ptr(parent), count, storage_idx, offset );
        }
    }
    
    ::CvDTreeNode * default_new_node( ::CvDTreeNode * parent, int count, int storage_idx, int offset ) {
        return CvDTreeTrainData::new_node( boost::python::ptr(parent), count, storage_idx, offset );
    }

    virtual ::CvDTreeSplit * new_split_cat( int vi, float quality ) {
        if( bp::override func_new_split_cat = this->get_override( "new_split_cat" ) )
            return func_new_split_cat( vi, quality );
        else{
            return this->CvDTreeTrainData::new_split_cat( vi, quality );
        }
    }
    
    ::CvDTreeSplit * default_new_split_cat( int vi, float quality ) {
        return CvDTreeTrainData::new_split_cat( vi, quality );
    }

    virtual ::CvDTreeSplit * new_split_ord( int vi, float cmp_val, int split_point, int inversed, float quality ) {
        if( bp::override func_new_split_ord = this->get_override( "new_split_ord" ) )
            return func_new_split_ord( vi, cmp_val, split_point, inversed, quality );
        else{
            return this->CvDTreeTrainData::new_split_ord( vi, cmp_val, split_point, inversed, quality );
        }
    }
    
    ::CvDTreeSplit * default_new_split_ord( int vi, float cmp_val, int split_point, int inversed, float quality ) {
        return CvDTreeTrainData::new_split_ord( vi, cmp_val, split_point, inversed, quality );
    }

    virtual void read_params( ::CvFileStorage * fs, ::CvFileNode * node ) {
        namespace bpl = boost::python;
        if( bpl::override func_read_params = this->get_override( "read_params" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_read_params.ptr(), fs, node );
        }
        else{
            CvDTreeTrainData::read_params( boost::python::ptr(fs), boost::python::ptr(node) );
        }
    }
    
    static void default_read_params( ::CvDTreeTrainData & inst, ::cv::FileStorage & fs, ::cv::FileNode & node ){
        if( dynamic_cast< CvDTreeTrainData_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvDTreeTrainData::read_params(fs.fs, *(node));
        }
        else{
            inst.read_params(fs.fs, *(node));
        }
    }

    virtual void set_data( ::CvMat const * _train_data, int _tflag, ::CvMat const * _responses, ::CvMat const * _var_idx=0, ::CvMat const * _sample_idx=0, ::CvMat const * _var_type=0, ::CvMat const * _missing_mask=0, ::CvDTreeParams const & _params=::CvDTreeParams( ), bool _shared=false, bool _add_labels=false, bool _update_data=false ) {
        namespace bpl = boost::python;
        if( bpl::override func_set_data = this->get_override( "set_data" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_set_data.ptr(), _train_data, _tflag, _responses, _var_idx, _sample_idx, _var_type, _missing_mask, _params, _shared, _add_labels, _update_data );
        }
        else{
            CvDTreeTrainData::set_data( boost::python::ptr(_train_data), _tflag, boost::python::ptr(_responses), boost::python::ptr(_var_idx), boost::python::ptr(_sample_idx), boost::python::ptr(_var_type), boost::python::ptr(_missing_mask), boost::ref(_params), _shared, _add_labels, _update_data );
        }
    }
    
    static void default_set_data( ::CvDTreeTrainData & inst, ::cv::Mat & _train_data, int _tflag, ::cv::Mat & _responses, ::cv::Mat _var_idx=cv::Mat(), ::cv::Mat _sample_idx=cv::Mat(), ::cv::Mat _var_type=cv::Mat(), ::cv::Mat _missing_mask=cv::Mat(), ::CvDTreeParams const & _params=::CvDTreeParams( ), bool _shared=false, bool _add_labels=false, bool _update_data=false ){
        if( dynamic_cast< CvDTreeTrainData_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvDTreeTrainData::set_data(get_CvMat_ptr(_train_data), _tflag, get_CvMat_ptr(_responses), get_CvMat_ptr(_var_idx), get_CvMat_ptr(_sample_idx), get_CvMat_ptr(_var_type), get_CvMat_ptr(_missing_mask), _params, _shared, _add_labels, _update_data);
        }
        else{
            inst.set_data(get_CvMat_ptr(_train_data), _tflag, get_CvMat_ptr(_responses), get_CvMat_ptr(_var_idx), get_CvMat_ptr(_sample_idx), get_CvMat_ptr(_var_type), get_CvMat_ptr(_missing_mask), _params, _shared, _add_labels, _update_data);
        }
    }

    virtual bool set_params( ::CvDTreeParams const & params ) {
        if( bp::override func_set_params = this->get_override( "set_params" ) )
            return func_set_params( boost::ref(params) );
        else{
            return this->CvDTreeTrainData::set_params( boost::ref(params) );
        }
    }
    
    bool default_set_params( ::CvDTreeParams const & params ) {
        return CvDTreeTrainData::set_params( boost::ref(params) );
    }

    virtual CvDTreeNode * subsample_data( ::CvMat const * _subsample_idx ) {
        namespace bpl = boost::python;
        if( bpl::override func_subsample_data = this->get_override( "subsample_data" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_subsample_data.ptr(), _subsample_idx );
            return bpl::extract< CvDTreeNode * >( pyplus_conv::get_out_argument( py_result, 0 ) );
        }
        else{
            return CvDTreeTrainData::subsample_data( boost::python::ptr(_subsample_idx) );
        }
    }
    
    static boost::python::object default_subsample_data( ::CvDTreeTrainData & inst, ::cv::Mat & _subsample_idx ){
        CvDTreeNode * result;
        if( dynamic_cast< CvDTreeTrainData_wrapper * >( boost::addressof( inst ) ) ){
            result = inst.::CvDTreeTrainData::subsample_data(get_CvMat_ptr(_subsample_idx));
        }
        else{
            result = inst.subsample_data(get_CvMat_ptr(_subsample_idx));
        }
        typedef bp::return_internal_reference< > call_policies_t;
        return bp::object( pyplusplus::call_policies::make_object< call_policies_t, CvDTreeNode * >( result ) );
    }

    virtual void write_params( ::CvFileStorage * fs ) const  {
        namespace bpl = boost::python;
        if( bpl::override func_write_params = this->get_override( "write_params" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_write_params.ptr(), fs );
        }
        else{
            CvDTreeTrainData::write_params( boost::python::ptr(fs) );
        }
    }
    
    static void default_write_params( ::CvDTreeTrainData const & inst, ::cv::FileStorage & fs ){
        if( dynamic_cast< CvDTreeTrainData_wrapper const* >( boost::addressof( inst ) ) ){
            inst.::CvDTreeTrainData::write_params(fs.fs);
        }
        else{
            inst.write_params(fs.fs);
        }
    }

    static CvDTreeNode * get_data_root(CvDTreeTrainData const & inst ){
        return inst.data_root;
    }
    
    static void set_data_root( CvDTreeTrainData & inst, CvDTreeNode * new_value ){ 
        inst.data_root = new_value;
    }

    cv::Mat responses_copy_as_Mat;
    CvMat responses_copy_as_CvMat;
    void update_responses_copy()
    {
        if(responses_copy_as_Mat.empty()) responses_copy = 0; // NULL pointer
        else
        {
            responses_copy_as_CvMat = responses_copy_as_Mat; // to ensure responses_copy points to a valid CvMat
            responses_copy = &responses_copy_as_CvMat;
        }
    }
    void set_responses_copy(cv::Mat const &new_responses_copy)
    {
        responses_copy_as_Mat = new_responses_copy; // to keep a reference to responses_copy
        update_responses_copy();
    }
    cv::Mat & get_CvDTreeTrainData_responses_copy()
    {
        update_responses_copy();
        return responses_copy_as_Mat;
    }

    cv::Mat cat_count_as_Mat;
    CvMat cat_count_as_CvMat;
    void update_cat_count()
    {
        if(cat_count_as_Mat.empty()) cat_count = 0; // NULL pointer
        else
        {
            cat_count_as_CvMat = cat_count_as_Mat; // to ensure cat_count points to a valid CvMat
            cat_count = &cat_count_as_CvMat;
        }
    }
    void set_cat_count(cv::Mat const &new_cat_count)
    {
        cat_count_as_Mat = new_cat_count; // to keep a reference to cat_count
        update_cat_count();
    }
    cv::Mat & get_CvDTreeTrainData_cat_count()
    {
        update_cat_count();
        return cat_count_as_Mat;
    }

    cv::Mat cat_ofs_as_Mat;
    CvMat cat_ofs_as_CvMat;
    void update_cat_ofs()
    {
        if(cat_ofs_as_Mat.empty()) cat_ofs = 0; // NULL pointer
        else
        {
            cat_ofs_as_CvMat = cat_ofs_as_Mat; // to ensure cat_ofs points to a valid CvMat
            cat_ofs = &cat_ofs_as_CvMat;
        }
    }
    void set_cat_ofs(cv::Mat const &new_cat_ofs)
    {
        cat_ofs_as_Mat = new_cat_ofs; // to keep a reference to cat_ofs
        update_cat_ofs();
    }
    cv::Mat & get_CvDTreeTrainData_cat_ofs()
    {
        update_cat_ofs();
        return cat_ofs_as_Mat;
    }

    cv::Mat cat_map_as_Mat;
    CvMat cat_map_as_CvMat;
    void update_cat_map()
    {
        if(cat_map_as_Mat.empty()) cat_map = 0; // NULL pointer
        else
        {
            cat_map_as_CvMat = cat_map_as_Mat; // to ensure cat_map points to a valid CvMat
            cat_map = &cat_map_as_CvMat;
        }
    }
    void set_cat_map(cv::Mat const &new_cat_map)
    {
        cat_map_as_Mat = new_cat_map; // to keep a reference to cat_map
        update_cat_map();
    }
    cv::Mat & get_CvDTreeTrainData_cat_map()
    {
        update_cat_map();
        return cat_map_as_Mat;
    }

    cv::Mat counts_as_Mat;
    CvMat counts_as_CvMat;
    void update_counts()
    {
        if(counts_as_Mat.empty()) counts = 0; // NULL pointer
        else
        {
            counts_as_CvMat = counts_as_Mat; // to ensure counts points to a valid CvMat
            counts = &counts_as_CvMat;
        }
    }
    void set_counts(cv::Mat const &new_counts)
    {
        counts_as_Mat = new_counts; // to keep a reference to counts
        update_counts();
    }
    cv::Mat & get_CvDTreeTrainData_counts()
    {
        update_counts();
        return counts_as_Mat;
    }

    cv::Mat buf_as_Mat;
    CvMat buf_as_CvMat;
    void update_buf()
    {
        if(buf_as_Mat.empty()) buf = 0; // NULL pointer
        else
        {
            buf_as_CvMat = buf_as_Mat; // to ensure buf points to a valid CvMat
            buf = &buf_as_CvMat;
        }
    }
    void set_buf(cv::Mat const &new_buf)
    {
        buf_as_Mat = new_buf; // to keep a reference to buf
        update_buf();
    }
    cv::Mat & get_CvDTreeTrainData_buf()
    {
        update_buf();
        return buf_as_Mat;
    }

    cv::Mat direction_as_Mat;
    CvMat direction_as_CvMat;
    void update_direction()
    {
        if(direction_as_Mat.empty()) direction = 0; // NULL pointer
        else
        {
            direction_as_CvMat = direction_as_Mat; // to ensure direction points to a valid CvMat
            direction = &direction_as_CvMat;
        }
    }
    void set_direction(cv::Mat const &new_direction)
    {
        direction_as_Mat = new_direction; // to keep a reference to direction
        update_direction();
    }
    cv::Mat & get_CvDTreeTrainData_direction()
    {
        update_direction();
        return direction_as_Mat;
    }

    cv::Mat split_buf_as_Mat;
    CvMat split_buf_as_CvMat;
    void update_split_buf()
    {
        if(split_buf_as_Mat.empty()) split_buf = 0; // NULL pointer
        else
        {
            split_buf_as_CvMat = split_buf_as_Mat; // to ensure split_buf points to a valid CvMat
            split_buf = &split_buf_as_CvMat;
        }
    }
    void set_split_buf(cv::Mat const &new_split_buf)
    {
        split_buf_as_Mat = new_split_buf; // to keep a reference to split_buf
        update_split_buf();
    }
    cv::Mat & get_CvDTreeTrainData_split_buf()
    {
        update_split_buf();
        return split_buf_as_Mat;
    }

    cv::Mat var_idx_as_Mat;
    CvMat var_idx_as_CvMat;
    void update_var_idx()
    {
        if(var_idx_as_Mat.empty()) var_idx = 0; // NULL pointer
        else
        {
            var_idx_as_CvMat = var_idx_as_Mat; // to ensure var_idx points to a valid CvMat
            var_idx = &var_idx_as_CvMat;
        }
    }
    void set_var_idx(cv::Mat const &new_var_idx)
    {
        var_idx_as_Mat = new_var_idx; // to keep a reference to var_idx
        update_var_idx();
    }
    cv::Mat & get_CvDTreeTrainData_var_idx()
    {
        update_var_idx();
        return var_idx_as_Mat;
    }

    cv::Mat var_type_as_Mat;
    CvMat var_type_as_CvMat;
    void update_var_type()
    {
        if(var_type_as_Mat.empty()) var_type = 0; // NULL pointer
        else
        {
            var_type_as_CvMat = var_type_as_Mat; // to ensure var_type points to a valid CvMat
            var_type = &var_type_as_CvMat;
        }
    }
    void set_var_type(cv::Mat const &new_var_type)
    {
        var_type_as_Mat = new_var_type; // to keep a reference to var_type
        update_var_type();
    }
    cv::Mat & get_CvDTreeTrainData_var_type()
    {
        update_var_type();
        return var_type_as_Mat;
    }

    cv::Mat priors_as_Mat;
    CvMat priors_as_CvMat;
    void update_priors()
    {
        if(priors_as_Mat.empty()) priors = 0; // NULL pointer
        else
        {
            priors_as_CvMat = priors_as_Mat; // to ensure priors points to a valid CvMat
            priors = &priors_as_CvMat;
        }
    }
    void set_priors(cv::Mat const &new_priors)
    {
        priors_as_Mat = new_priors; // to keep a reference to priors
        update_priors();
    }
    cv::Mat & get_CvDTreeTrainData_priors()
    {
        update_priors();
        return priors_as_Mat;
    }

    cv::Mat priors_mult_as_Mat;
    CvMat priors_mult_as_CvMat;
    void update_priors_mult()
    {
        if(priors_mult_as_Mat.empty()) priors_mult = 0; // NULL pointer
        else
        {
            priors_mult_as_CvMat = priors_mult_as_Mat; // to ensure priors_mult points to a valid CvMat
            priors_mult = &priors_mult_as_CvMat;
        }
    }
    void set_priors_mult(cv::Mat const &new_priors_mult)
    {
        priors_mult_as_Mat = new_priors_mult; // to keep a reference to priors_mult
        update_priors_mult();
    }
    cv::Mat & get_CvDTreeTrainData_priors_mult()
    {
        update_priors_mult();
        return priors_mult_as_Mat;
    }

};

static bp::object CvDTreeTrainData_get_cat_var_data(bp::object const &bpinst, CvDTreeNode* n, int vi)
{
    CvDTreeTrainData &inst = bp::extract<CvDTreeTrainData &>(bpinst);
    int size = n->sample_count;
    sdcpp::ndarray result = sdcpp::simplenew_ndarray(1, &size, NPY_INT);
    int *in_arr = (int*)result.data();
    const int *out_arr = inst.get_cat_var_data(n, vi, in_arr);
    
    if(!out_arr) return bp::object();
    if(out_arr == in_arr) return result.get_obj();
    
    result = sdcpp::new_ndarray1d(size, NPY_INT, (void *)out_arr);
    bp::objects::make_nurse_and_patient(result.get_obj().ptr(), bpinst.ptr());
    return result.get_obj();
}

static bp::object CvDTreeTrainData_get_cv_labels(bp::object const &bpinst, CvDTreeNode* n)
{
    CvDTreeTrainData &inst = bp::extract<CvDTreeTrainData &>(bpinst);
    int size = n->sample_count;
    sdcpp::ndarray result = sdcpp::simplenew_ndarray(1, &size, NPY_INT);
    int *in_arr = (int*)result.data();
    const int *out_arr = inst.get_cv_labels(n, in_arr);
    
    if(!out_arr) return bp::object();
    if(out_arr == in_arr) return result.get_obj();
    
    result = sdcpp::new_ndarray1d(size, NPY_INT, (void *)out_arr);
    bp::objects::make_nurse_and_patient(result.get_obj().ptr(), bpinst.ptr());
    return result.get_obj();
}

static bp::object CvDTreeTrainData_get_sample_indices(bp::object const &bpinst, CvDTreeNode* n)
{
    CvDTreeTrainData &inst = bp::extract<CvDTreeTrainData &>(bpinst);
    int size = n->sample_count;
    sdcpp::ndarray result = sdcpp::simplenew_ndarray(1, &size, NPY_INT);
    int *in_arr = (int*)result.data();
    const int *out_arr = inst.get_sample_indices(n, in_arr);
    
    if(!out_arr) return bp::object();
    if(out_arr == in_arr) return result.get_obj();
    
    result = sdcpp::new_ndarray1d(size, NPY_INT, (void *)out_arr);
    bp::objects::make_nurse_and_patient(result.get_obj().ptr(), bpinst.ptr());
    return result.get_obj();
}

static bp::tuple CvDTreeTrainData_get_ord_var_data(bp::object const &bpinst, CvDTreeNode* n, int vi)
{
    CvDTreeTrainData &inst = bp::extract<CvDTreeTrainData &>(bpinst);
    int size = n->sample_count;
    std::vector<int> sample_indices(size);
    sdcpp::ndarray result1 = sdcpp::simplenew_ndarray(1, &size, NPY_FLOAT);
    sdcpp::ndarray result2 = sdcpp::simplenew_ndarray(1, &size, NPY_INT);
    float *in_arr1 = (float*)result1.data();
    int *in_arr2 = (int*)result2.data();
    const float *out_arr1;
    const int *out_arr2;
    inst.get_ord_var_data(n, vi, in_arr1, in_arr2, &out_arr1, &out_arr2, &sample_indices[0]);
    
    bp::object obj1, obj2;
    
    if(out_arr1 && out_arr1 != in_arr1)
    {
        result1 = sdcpp::new_ndarray1d(size, NPY_FLOAT, (void *)out_arr1);
        bp::objects::make_nurse_and_patient(result1.get_obj().ptr(), bpinst.ptr());
    }
    if(out_arr1) obj1 = result1.get_obj();
    
    if(out_arr2 && out_arr2 != in_arr2)
    {
        result2 = sdcpp::new_ndarray1d(size, NPY_INT, (void *)out_arr2);
        bp::objects::make_nurse_and_patient(result2.get_obj().ptr(), bpinst.ptr());
    }
    if(out_arr2) obj2 = result2.get_obj();
    
    return bp::make_tuple(obj1, obj2);
}

static bp::object CvDTreeTrainData_get_ord_responses(bp::object const &bpinst, CvDTreeNode* n)
{
    CvDTreeTrainData &inst = bp::extract<CvDTreeTrainData &>(bpinst);
    int size = n->sample_count;
    std::vector<int> sample_indices(size);
    sdcpp::ndarray result = sdcpp::simplenew_ndarray(1, &size, NPY_FLOAT);
    float *in_arr = (float*)result.data();
    const float *out_arr = inst.get_ord_responses(n, in_arr, &sample_indices[0]);
    
    if(!out_arr) return bp::object();
    if(out_arr == in_arr) return result.get_obj();
    
    result = sdcpp::new_ndarray1d(size, NPY_FLOAT, (void *)out_arr);
    bp::objects::make_nurse_and_patient(result.get_obj().ptr(), bpinst.ptr());
    return result.get_obj();
}

static bp::object CvDTreeTrainData_get_class_labels(bp::object const &bpinst, CvDTreeNode* n)
{
    CvDTreeTrainData &inst = bp::extract<CvDTreeTrainData &>(bpinst);
    int size = n->sample_count;
    sdcpp::ndarray result = sdcpp::simplenew_ndarray(1, &size, NPY_INT);
    int *in_arr = (int*)result.data();
    const int *out_arr = inst.get_class_labels(n, in_arr);
    
    if(!out_arr) return bp::object();
    if(out_arr == in_arr) return result.get_obj();
    
    result = sdcpp::new_ndarray1d(size, NPY_INT, (void *)out_arr);
    bp::objects::make_nurse_and_patient(result.get_obj().ptr(), bpinst.ptr());
    return result.get_obj();
}

static cv::Mat get_CvDTreeTrainData_train_data(CvDTreeTrainData const &inst) { return inst.train_data? cv::Mat(inst.train_data): cv::Mat(); }

static cv::Mat get_CvDTreeTrainData_responses(CvDTreeTrainData const &inst) { return inst.responses? cv::Mat(inst.responses): cv::Mat(); }

static cv::MemStorage get_CvDTreeTrainData_tree_storage(CvDTreeTrainData const &inst) { return cv::MemStorage(inst.tree_storage); }

static cv::MemStorage get_CvDTreeTrainData_temp_storage(CvDTreeTrainData const &inst) { return cv::MemStorage(inst.temp_storage); }

static ::CvSet * get_CvDTreeTrainData_node_heap( CvDTreeTrainData const & inst ) { return inst.node_heap; }

static ::CvSet * get_CvDTreeTrainData_split_heap( CvDTreeTrainData const & inst ) { return inst.split_heap; }

static ::CvSet * get_CvDTreeTrainData_cv_heap( CvDTreeTrainData const & inst ) { return inst.cv_heap; }

static ::CvSet * get_CvDTreeTrainData_nv_heap( CvDTreeTrainData const & inst ) { return inst.nv_heap; }

static cv::RNG *get_CvDTreeTrainData_rng(CvDTreeTrainData const &inst) { return (cv::RNG *)(&inst.rng); }

struct CvEMParams_wrapper : CvEMParams, bp::wrapper< CvEMParams > {

    CvEMParams_wrapper(CvEMParams const & arg )
    : CvEMParams( arg )
      , bp::wrapper< CvEMParams >(){
        // copy constructor
        
    }

    CvEMParams_wrapper( )
    : CvEMParams( )
      , bp::wrapper< CvEMParams >(){
        // null constructor
    
    }

    CvEMParams_wrapper(int _nclusters, int _cov_mat_type, int _start_step)
        : CvEMParams(_nclusters, _cov_mat_type, _start_step), bp::wrapper< CvEMParams >() { }

};

static cv::Mat get_CvEMParams_probs(CvEMParams const &inst) { return inst.probs? cv::Mat(inst.probs): cv::Mat(); }

static cv::Mat get_CvEMParams_weights(CvEMParams const &inst) { return inst.weights? cv::Mat(inst.weights): cv::Mat(); }

static cv::Mat get_CvEMParams_means(CvEMParams const &inst) { return inst.means? cv::Mat(inst.means): cv::Mat(); }

static cv::TermCriteria *get_CvEMParams_term_crit(CvEMParams const &inst) { return (cv::TermCriteria *)(&inst.term_crit); }

struct CvEM_wrapper : CvEM, bp::wrapper< CvEM > {

    CvEM_wrapper(CvEM const & arg )
    : CvEM( arg )
      , bp::wrapper< CvEM >(){
        // copy constructor
        
    }

    CvEM_wrapper( )
    : CvEM( )
      , bp::wrapper< CvEM >(){
        // null constructor
    
    }

    CvEM_wrapper(::CvMat const * samples, ::CvMat const * sample_idx=0, ::CvEMParams params=::CvEMParams( ), ::CvMat * labels=0 )
    : CvEM( boost::python::ptr(samples), boost::python::ptr(sample_idx), params, boost::python::ptr(labels) )
      , bp::wrapper< CvEM >(){
        // constructor
    
    }

    CvEM_wrapper(::cv::Mat const & samples, ::cv::Mat const & sample_idx=cv::Mat(), ::CvEMParams params=::CvEMParams( ), ::cv::Mat * labels=0 )
    : CvEM( boost::ref(samples), boost::ref(sample_idx), params, boost::python::ptr(labels) )
      , bp::wrapper< CvEM >(){
        // constructor
    
    }

    virtual void clear(  ) {
        if( bp::override func_clear = this->get_override( "clear" ) )
            func_clear(  );
        else{
            this->CvEM::clear(  );
        }
    }
    
    void default_clear(  ) {
        CvEM::clear( );
    }

    virtual float predict( ::CvMat const * sample, ::CvMat * probs ) const  {
        namespace bpl = boost::python;
        if( bpl::override func_predict = this->get_override( "predict" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_predict.ptr(), sample, probs );
            return bpl::extract< float >( pyplus_conv::get_out_argument( py_result, 0 ) );
        }
        else{
            return CvEM::predict( boost::python::ptr(sample), boost::python::ptr(probs) );
        }
    }
    
    static boost::python::object default_predict_e2a6ccb3e80d0945b65e2adfc4d80129( ::CvEM const & inst, ::cv::Mat & sample, ::cv::Mat & probs ){
        float result;
        if( dynamic_cast< CvEM_wrapper const* >( boost::addressof( inst ) ) ){
            result = inst.::CvEM::predict(get_CvMat_ptr(sample), get_CvMat_ptr(probs));
        }
        else{
            result = inst.predict(get_CvMat_ptr(sample), get_CvMat_ptr(probs));
        }
        return bp::object( result );
    }

    virtual float predict( ::cv::Mat const & sample, ::cv::Mat * probs ) const  {
        if( bp::override func_predict = this->get_override( "predict" ) )
            return func_predict( boost::ref(sample), boost::python::ptr(probs) );
        else{
            return this->CvEM::predict( boost::ref(sample), boost::python::ptr(probs) );
        }
    }
    
    float default_predict( ::cv::Mat const & sample, ::cv::Mat * probs ) const  {
        return CvEM::predict( boost::ref(sample), boost::python::ptr(probs) );
    }

    virtual bool train( ::CvMat const * samples, ::CvMat const * sample_idx=0, ::CvEMParams params=::CvEMParams( ), ::CvMat * labels=0 ) {
        namespace bpl = boost::python;
        if( bpl::override func_train = this->get_override( "train" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_train.ptr(), samples, sample_idx, params, labels );
            return bpl::extract< bool >( pyplus_conv::get_out_argument( py_result, 0 ) );
        }
        else{
            return CvEM::train( boost::python::ptr(samples), boost::python::ptr(sample_idx), params, boost::python::ptr(labels) );
        }
    }
    
    static boost::python::object default_train_ad96ec9280c0f7571752ed3a0ca86d28( ::CvEM & inst, ::cv::Mat & samples, ::cv::Mat sample_idx=cv::Mat(), ::CvEMParams params=::CvEMParams( ), ::cv::Mat labels=cv::Mat() ){
        bool result;
        if( dynamic_cast< CvEM_wrapper * >( boost::addressof( inst ) ) ){
            result = inst.::CvEM::train(get_CvMat_ptr(samples), get_CvMat_ptr(sample_idx), params, get_CvMat_ptr(labels));
        }
        else{
            result = inst.train(get_CvMat_ptr(samples), get_CvMat_ptr(sample_idx), params, get_CvMat_ptr(labels));
        }
        return bp::object( result );
    }

    virtual bool train( ::cv::Mat const & samples, ::cv::Mat const & sample_idx=cv::Mat(), ::CvEMParams params=::CvEMParams( ), ::cv::Mat * labels=0 ) {
        if( bp::override func_train = this->get_override( "train" ) )
            return func_train( boost::ref(samples), boost::ref(sample_idx), params, boost::python::ptr(labels) );
        else{
            return this->CvEM::train( boost::ref(samples), boost::ref(sample_idx), params, boost::python::ptr(labels) );
        }
    }
    
    bool default_train( ::cv::Mat const & samples, ::cv::Mat const & sample_idx=cv::Mat(), ::CvEMParams params=::CvEMParams( ), ::cv::Mat * labels=0 ) {
        return CvEM::train( boost::ref(samples), boost::ref(sample_idx), params, boost::python::ptr(labels) );
    }

    virtual void load( char const * filename, char const * name=0 ) {
        if( bp::override func_load = this->get_override( "load" ) )
            func_load( filename, name );
        else{
            this->CvStatModel::load( filename, name );
        }
    }
    
    void default_load( char const * filename, char const * name=0 ) {
        CvStatModel::load( filename, name );
    }

    virtual void read( ::CvFileStorage * storage, ::CvFileNode * node ) {
        namespace bpl = boost::python;
        if( bpl::override func_read = this->get_override( "read" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_read.ptr(), storage, node );
        }
        else{
            CvStatModel::read( boost::python::ptr(storage), boost::python::ptr(node) );
        }
    }
    
    static void default_read( ::CvStatModel & inst, ::cv::FileStorage & storage, ::cv::FileNode & node ){
        if( dynamic_cast< CvEM_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvStatModel::read(storage.fs, *(node));
        }
        else{
            inst.read(storage.fs, *(node));
        }
    }

    virtual void save( char const * filename, char const * name=0 ) const  {
        if( bp::override func_save = this->get_override( "save" ) )
            func_save( filename, name );
        else{
            this->CvStatModel::save( filename, name );
        }
    }
    
    void default_save( char const * filename, char const * name=0 ) const  {
        CvStatModel::save( filename, name );
    }

    virtual void write( ::CvFileStorage * storage, char const * name ) const  {
        namespace bpl = boost::python;
        if( bpl::override func_write = this->get_override( "write" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_write.ptr(), storage, name );
        }
        else{
            CvStatModel::write( boost::python::ptr(storage), name );
        }
    }
    
    static void default_write( ::CvStatModel const & inst, ::cv::FileStorage & storage, char const * name ){
        if( dynamic_cast< CvEM_wrapper const* >( boost::addressof( inst ) ) ){
            inst.::CvStatModel::write(storage.fs, name);
        }
        else{
            inst.write(storage.fs, name);
        }
    }

};

void register_classes_4(){

    bp::class_< CvDTreeTrainData_wrapper >( "CvDTreeTrainData", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvDTreeTrainData >() )    
        .def( bp::init< CvMat const *, int, CvMat const *, bp::optional< CvMat const *, CvMat const *, CvMat const *, CvMat const *, CvDTreeParams const &, bool, bool > >(( bp::arg("_train_data"), bp::arg("_tflag"), bp::arg("_responses"), bp::arg("_var_idx")=bp::object(), bp::arg("_sample_idx")=bp::object(), bp::arg("_var_type")=bp::object(), bp::arg("_missing_mask")=bp::object(), bp::arg("_params")=::CvDTreeParams( ), bp::arg("_shared")=(bool)(false), bp::arg("_add_labels")=(bool)(false) ), "\nWrapped function:"
    "\n    CvDTreeTrainData"
    "\nArgument '_train_data':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_responses':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_var_idx':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_sample_idx':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_var_type':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_missing_mask':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat") )    
        .def( 
            "clear"
            , (void ( CvDTreeTrainData::* )(  ) )(&::CvDTreeTrainData::clear)
            , (void ( CvDTreeTrainData_wrapper::* )(  ) )(&CvDTreeTrainData_wrapper::default_clear) )    
        .def( 
            "do_responses_copy"
            , (void ( CvDTreeTrainData::* )(  ) )(&::CvDTreeTrainData::do_responses_copy)
            , (void ( CvDTreeTrainData_wrapper::* )(  ) )(&CvDTreeTrainData_wrapper::default_do_responses_copy) )    
        .def( 
            "free_node"
            , (void ( CvDTreeTrainData::* )( ::CvDTreeNode * ) )(&::CvDTreeTrainData::free_node)
            , (void ( CvDTreeTrainData_wrapper::* )( ::CvDTreeNode * ) )(&CvDTreeTrainData_wrapper::default_free_node)
            , ( bp::arg("node") ) )    
        .def( 
            "free_node_data"
            , (void ( CvDTreeTrainData::* )( ::CvDTreeNode * ) )(&::CvDTreeTrainData::free_node_data)
            , (void ( CvDTreeTrainData_wrapper::* )( ::CvDTreeNode * ) )(&CvDTreeTrainData_wrapper::default_free_node_data)
            , ( bp::arg("node") ) )    
        .def( 
            "free_train_data"
            , (void ( CvDTreeTrainData::* )(  ) )(&::CvDTreeTrainData::free_train_data)
            , (void ( CvDTreeTrainData_wrapper::* )(  ) )(&CvDTreeTrainData_wrapper::default_free_train_data) )    
        .def( 
            "get_child_buf_idx"
            , (int ( CvDTreeTrainData::* )( ::CvDTreeNode * ) )(&::CvDTreeTrainData::get_child_buf_idx)
            , (int ( CvDTreeTrainData_wrapper::* )( ::CvDTreeNode * ) )(&CvDTreeTrainData_wrapper::default_get_child_buf_idx)
            , ( bp::arg("n") ) )    
        .def( 
            "get_num_classes"
            , (int ( CvDTreeTrainData::* )(  ) const)( &::CvDTreeTrainData::get_num_classes ) )    
        .def( 
            "get_var_type"
            , (int ( CvDTreeTrainData::* )( int ) const)( &::CvDTreeTrainData::get_var_type )
            , ( bp::arg("vi") ) )    
        .def( 
            "get_vectors"
            , (void (*)( CvDTreeTrainData &,::cv::Mat &,std::vector<float> const &,std::vector<unsigned char> const &,std::vector<float> const &,bool ))( &CvDTreeTrainData_wrapper::default_get_vectors )
            , ( bp::arg("inst"), bp::arg("_subsample_idx"), bp::arg("values"), bp::arg("missing"), bp::arg("responses"), bp::arg("get_class_idx")=(bool)(false) )
            , "\nArgument '_subsample_idx':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument 'values':"\
    "\n    C++ type: float *"\
    "\n    Python type: vector_float32"\
    "\nArgument 'missing':"\
    "\n    C++ type: ::uchar *"\
    "\n    Python type: vector_uint8"\
    "\nArgument 'responses':"\
    "\n    C++ type: float *"\
    "\n    Python type: vector_float32" )    
        .def( 
            "get_work_var_count"
            , (int ( CvDTreeTrainData::* )(  ) const)( &::CvDTreeTrainData::get_work_var_count ) )    
        .def( 
            "new_node"
            , (::CvDTreeNode * ( CvDTreeTrainData::* )( ::CvDTreeNode *,int,int,int ) )(&::CvDTreeTrainData::new_node)
            , (::CvDTreeNode * ( CvDTreeTrainData_wrapper::* )( ::CvDTreeNode *,int,int,int ) )(&CvDTreeTrainData_wrapper::default_new_node)
            , ( bp::arg("parent"), bp::arg("count"), bp::arg("storage_idx"), bp::arg("offset") )
            , bp::return_internal_reference< >() )    
        .def( 
            "new_split_cat"
            , (::CvDTreeSplit * ( CvDTreeTrainData::* )( int,float ) )(&::CvDTreeTrainData::new_split_cat)
            , (::CvDTreeSplit * ( CvDTreeTrainData_wrapper::* )( int,float ) )(&CvDTreeTrainData_wrapper::default_new_split_cat)
            , ( bp::arg("vi"), bp::arg("quality") )
            , bp::return_internal_reference< >() )    
        .def( 
            "new_split_ord"
            , (::CvDTreeSplit * ( CvDTreeTrainData::* )( int,float,int,int,float ) )(&::CvDTreeTrainData::new_split_ord)
            , (::CvDTreeSplit * ( CvDTreeTrainData_wrapper::* )( int,float,int,int,float ) )(&CvDTreeTrainData_wrapper::default_new_split_ord)
            , ( bp::arg("vi"), bp::arg("cmp_val"), bp::arg("split_point"), bp::arg("inversed"), bp::arg("quality") )
            , bp::return_internal_reference< >() )    
        .def( 
            "read_params"
            , (void (*)( CvDTreeTrainData &,::cv::FileStorage &,::cv::FileNode & ))( &CvDTreeTrainData_wrapper::default_read_params )
            , ( bp::arg("inst"), bp::arg("fs"), bp::arg("node") )
            , "\nArgument 'fs':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage"\
    "\nArgument 'node':"\
    "\n    C++ type: ::CvFileNode *"\
    "\n    Python type: FileNode" )    
        .def( 
            "set_data"
            , (void (*)( CvDTreeTrainData &,::cv::Mat &,int,::cv::Mat &,::cv::Mat,::cv::Mat,::cv::Mat,::cv::Mat,CvDTreeParams const &,bool,bool,bool ))( &CvDTreeTrainData_wrapper::default_set_data )
            , ( bp::arg("inst"), bp::arg("_train_data"), bp::arg("_tflag"), bp::arg("_responses"), bp::arg("_var_idx")=cv::Mat(), bp::arg("_sample_idx")=cv::Mat(), bp::arg("_var_type")=cv::Mat(), bp::arg("_missing_mask")=cv::Mat(), bp::arg("_params")=::CvDTreeParams( ), bp::arg("_shared")=(bool)(false), bp::arg("_add_labels")=(bool)(false), bp::arg("_update_data")=(bool)(false) )
            , "\nArgument '_train_data':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_responses':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_var_idx':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_sample_idx':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_var_type':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_missing_mask':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat" )    
        .def( 
            "set_params"
            , (bool ( CvDTreeTrainData::* )( ::CvDTreeParams const & ) )(&::CvDTreeTrainData::set_params)
            , (bool ( CvDTreeTrainData_wrapper::* )( ::CvDTreeParams const & ) )(&CvDTreeTrainData_wrapper::default_set_params)
            , ( bp::arg("params") ) )    
        .def( 
            "subsample_data"
            , (boost::python::object (*)( CvDTreeTrainData &,::cv::Mat & ))( &CvDTreeTrainData_wrapper::default_subsample_data )
            , ( bp::arg("inst"), bp::arg("_subsample_idx") )
            , "\nArgument '_subsample_idx':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat" )    
        .def( 
            "write_params"
            , (void (*)( CvDTreeTrainData const &,::cv::FileStorage & ))( &CvDTreeTrainData_wrapper::default_write_params )
            , ( bp::arg("inst"), bp::arg("fs") )
            , "\nArgument 'fs':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage" )    
        .def_readwrite( "buf_count", &CvDTreeTrainData::buf_count )    
        .def_readwrite( "buf_size", &CvDTreeTrainData::buf_size )    
        .def_readwrite( "cat_var_count", &CvDTreeTrainData::cat_var_count )    
        .add_property( "data_root"
                    , bp::make_function( (::CvDTreeNode * (*)( ::CvDTreeTrainData const & ))(&CvDTreeTrainData_wrapper::get_data_root), bp::return_internal_reference< >() )
                    , bp::make_function( (void (*)( ::CvDTreeTrainData &,::CvDTreeNode * ))(&CvDTreeTrainData_wrapper::set_data_root), bp::with_custodian_and_ward_postcall< 1, 2 >() ) )    
        .def_readwrite( "have_labels", &CvDTreeTrainData::have_labels )    
        .def_readwrite( "have_priors", &CvDTreeTrainData::have_priors )    
        .def_readwrite( "is_buf_16u", &CvDTreeTrainData::is_buf_16u )    
        .def_readwrite( "is_classifier", &CvDTreeTrainData::is_classifier )    
        .def_readwrite( "max_c_count", &CvDTreeTrainData::max_c_count )    
        .def_readwrite( "ord_var_count", &CvDTreeTrainData::ord_var_count )    
        .def_readwrite( "params", &CvDTreeTrainData::params )    
        .def_readwrite( "sample_count", &CvDTreeTrainData::sample_count )    
        .def_readwrite( "shared", &CvDTreeTrainData::shared )    
        .def_readwrite( "tflag", &CvDTreeTrainData::tflag )    
        .def_readwrite( "var_all", &CvDTreeTrainData::var_all )    
        .def_readwrite( "var_count", &CvDTreeTrainData::var_count )    
        .def_readwrite( "work_var_count", &CvDTreeTrainData::work_var_count )    
        .def("get_cat_var_data", &::CvDTreeTrainData_get_cat_var_data, (bp::arg("self"), bp::arg("n"), bp::arg("vi")))    
        .def("get_cv_labels", &::CvDTreeTrainData_get_cv_labels, (bp::arg("self"), bp::arg("n")))    
        .def("get_sample_indices", &::CvDTreeTrainData_get_sample_indices, (bp::arg("self"), bp::arg("n")))    
        .def("get_ord_var_data", &::CvDTreeTrainData_get_ord_var_data, (bp::arg("self"), bp::arg("n"), bp::arg("vi")))    
        .def("get_ord_responses", &::CvDTreeTrainData_get_ord_responses, (bp::arg("self"), bp::arg("n")))    
        .def("get_class_labels", &::CvDTreeTrainData_get_class_labels, (bp::arg("self"), bp::arg("n")))    
        .add_property( "train_data", &::get_CvDTreeTrainData_train_data )    
        .add_property( "responses", &::get_CvDTreeTrainData_responses )    
        .add_property( "responses_copy", bp::make_function(&CvDTreeTrainData_wrapper::get_CvDTreeTrainData_responses_copy, bp::return_internal_reference<>()),
            &CvDTreeTrainData_wrapper::set_responses_copy)    
        .def( "validate_responses_copy", &CvDTreeTrainData_wrapper::update_responses_copy, "Updates the internal C pointer that represents 'responses_copy'. The function should be called every time the header of 'responses_copy' is modified by the user." )    
        .add_property( "cat_count", bp::make_function(&CvDTreeTrainData_wrapper::get_CvDTreeTrainData_cat_count, bp::return_internal_reference<>()),
            &CvDTreeTrainData_wrapper::set_cat_count)    
        .def( "validate_cat_count", &CvDTreeTrainData_wrapper::update_cat_count, "Updates the internal C pointer that represents 'cat_count'. The function should be called every time the header of 'cat_count' is modified by the user." )    
        .add_property( "cat_ofs", bp::make_function(&CvDTreeTrainData_wrapper::get_CvDTreeTrainData_cat_ofs, bp::return_internal_reference<>()),
            &CvDTreeTrainData_wrapper::set_cat_ofs)    
        .def( "validate_cat_ofs", &CvDTreeTrainData_wrapper::update_cat_ofs, "Updates the internal C pointer that represents 'cat_ofs'. The function should be called every time the header of 'cat_ofs' is modified by the user." )    
        .add_property( "cat_map", bp::make_function(&CvDTreeTrainData_wrapper::get_CvDTreeTrainData_cat_map, bp::return_internal_reference<>()),
            &CvDTreeTrainData_wrapper::set_cat_map)    
        .def( "validate_cat_map", &CvDTreeTrainData_wrapper::update_cat_map, "Updates the internal C pointer that represents 'cat_map'. The function should be called every time the header of 'cat_map' is modified by the user." )    
        .add_property( "counts", bp::make_function(&CvDTreeTrainData_wrapper::get_CvDTreeTrainData_counts, bp::return_internal_reference<>()),
            &CvDTreeTrainData_wrapper::set_counts)    
        .def( "validate_counts", &CvDTreeTrainData_wrapper::update_counts, "Updates the internal C pointer that represents 'counts'. The function should be called every time the header of 'counts' is modified by the user." )    
        .add_property( "buf", bp::make_function(&CvDTreeTrainData_wrapper::get_CvDTreeTrainData_buf, bp::return_internal_reference<>()),
            &CvDTreeTrainData_wrapper::set_buf)    
        .def( "validate_buf", &CvDTreeTrainData_wrapper::update_buf, "Updates the internal C pointer that represents 'buf'. The function should be called every time the header of 'buf' is modified by the user." )    
        .add_property( "direction", bp::make_function(&CvDTreeTrainData_wrapper::get_CvDTreeTrainData_direction, bp::return_internal_reference<>()),
            &CvDTreeTrainData_wrapper::set_direction)    
        .def( "validate_direction", &CvDTreeTrainData_wrapper::update_direction, "Updates the internal C pointer that represents 'direction'. The function should be called every time the header of 'direction' is modified by the user." )    
        .add_property( "split_buf", bp::make_function(&CvDTreeTrainData_wrapper::get_CvDTreeTrainData_split_buf, bp::return_internal_reference<>()),
            &CvDTreeTrainData_wrapper::set_split_buf)    
        .def( "validate_split_buf", &CvDTreeTrainData_wrapper::update_split_buf, "Updates the internal C pointer that represents 'split_buf'. The function should be called every time the header of 'split_buf' is modified by the user." )    
        .add_property( "var_idx", bp::make_function(&CvDTreeTrainData_wrapper::get_CvDTreeTrainData_var_idx, bp::return_internal_reference<>()),
            &CvDTreeTrainData_wrapper::set_var_idx)    
        .def( "validate_var_idx", &CvDTreeTrainData_wrapper::update_var_idx, "Updates the internal C pointer that represents 'var_idx'. The function should be called every time the header of 'var_idx' is modified by the user." )    
        .add_property( "var_type", bp::make_function(&CvDTreeTrainData_wrapper::get_CvDTreeTrainData_var_type, bp::return_internal_reference<>()),
            &CvDTreeTrainData_wrapper::set_var_type)    
        .def( "validate_var_type", &CvDTreeTrainData_wrapper::update_var_type, "Updates the internal C pointer that represents 'var_type'. The function should be called every time the header of 'var_type' is modified by the user." )    
        .add_property( "priors", bp::make_function(&CvDTreeTrainData_wrapper::get_CvDTreeTrainData_priors, bp::return_internal_reference<>()),
            &CvDTreeTrainData_wrapper::set_priors)    
        .def( "validate_priors", &CvDTreeTrainData_wrapper::update_priors, "Updates the internal C pointer that represents 'priors'. The function should be called every time the header of 'priors' is modified by the user." )    
        .add_property( "priors_mult", bp::make_function(&CvDTreeTrainData_wrapper::get_CvDTreeTrainData_priors_mult, bp::return_internal_reference<>()),
            &CvDTreeTrainData_wrapper::set_priors_mult)    
        .def( "validate_priors_mult", &CvDTreeTrainData_wrapper::update_priors_mult, "Updates the internal C pointer that represents 'priors_mult'. The function should be called every time the header of 'priors_mult' is modified by the user." )    
        .add_property( "tree_storage", bp::make_function(&::get_CvDTreeTrainData_tree_storage, bp::with_custodian_and_ward_postcall<0, 1>()) )    
        .add_property( "temp_storage", bp::make_function(&::get_CvDTreeTrainData_temp_storage, bp::with_custodian_and_ward_postcall<0, 1>()) )    
        .add_property( "node_heap", bp::make_function(&::get_CvDTreeTrainData_node_heap, bp::return_internal_reference<>()) )    
        .add_property( "split_heap", bp::make_function(&::get_CvDTreeTrainData_split_heap, bp::return_internal_reference<>()) )    
        .add_property( "cv_heap", bp::make_function(&::get_CvDTreeTrainData_cv_heap, bp::return_internal_reference<>()) )    
        .add_property( "nv_heap", bp::make_function(&::get_CvDTreeTrainData_nv_heap, bp::return_internal_reference<>()) )    
        .add_property( "rng", bp::make_function(&::get_CvDTreeTrainData_rng, bp::return_internal_reference<>()) );

    bp::class_< CvEMParams_wrapper >( "CvEMParams", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvEMParams >() )    
        .def_readwrite( "cov_mat_type", &CvEMParams::cov_mat_type )    
        .def_readwrite( "nclusters", &CvEMParams::nclusters )    
        .def_readwrite( "start_step", &CvEMParams::start_step )    
        .def( bp::init< int, int, int >(( bp::arg("_nclusters"), bp::arg("_cov_mat_type")=1, bp::arg("_start_step")=0 )) )    
        .add_property( "probs", &::get_CvEMParams_probs )    
        .add_property( "weights", &::get_CvEMParams_weights )    
        .add_property( "means", &::get_CvEMParams_means )    
        .add_property( "term_crit", bp::make_function(&::get_CvEMParams_term_crit, bp::return_internal_reference<>()) );

    { //::CvEM
        typedef bp::class_< CvEM_wrapper, bp::bases< CvStatModel > > CvEM_exposer_t;
        CvEM_exposer_t CvEM_exposer = CvEM_exposer_t( "CvEM", bp::init< >() );
        bp::scope CvEM_scope( CvEM_exposer );
        CvEM_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< CvEM >() );
        bp::scope().attr("COV_MAT_SPHERICAL") = (int)CvEM::COV_MAT_SPHERICAL;
        bp::scope().attr("COV_MAT_DIAGONAL") = (int)CvEM::COV_MAT_DIAGONAL;
        bp::scope().attr("COV_MAT_GENERIC") = (int)CvEM::COV_MAT_GENERIC;
        bp::scope().attr("START_E_STEP") = (int)CvEM::START_E_STEP;
        bp::scope().attr("START_M_STEP") = (int)CvEM::START_M_STEP;
        bp::scope().attr("START_AUTO_STEP") = (int)CvEM::START_AUTO_STEP;
        CvEM_exposer.def( bp::init< CvMat const *, bp::optional< CvMat const *, CvEMParams, CvMat * > >(( bp::arg("samples"), bp::arg("sample_idx")=bp::object(), bp::arg("params")=::CvEMParams( ), bp::arg("labels")=bp::object() ), "\nWrapped function:"
    "\n    CvEM"
    "\nArgument 'samples':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument 'sample_idx':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument 'labels':"\
    "\n    C++ type: ::CvMat *"\
    "\n    Python type: Mat") );
        bp::implicitly_convertible< CvMat const *, CvEM >();
        CvEM_exposer.def( bp::init< cv::Mat const &, bp::optional< cv::Mat const &, CvEMParams, cv::Mat * > >(( bp::arg("samples"), bp::arg("sample_idx")=cv::Mat(), bp::arg("params")=::CvEMParams( ), bp::arg("labels")=bp::object() )) );
        bp::implicitly_convertible< cv::Mat const &, CvEM >();
        { //::CvEM::clear
        
            typedef void ( ::CvEM::*clear_function_type )(  ) ;
            typedef void ( CvEM_wrapper::*default_clear_function_type )(  ) ;
            
            CvEM_exposer.def( 
                "clear"
                , clear_function_type(&::CvEM::clear)
                , default_clear_function_type(&CvEM_wrapper::default_clear) );
        
        }
        { //::CvEM::get_log_likelihood
        
            typedef double ( ::CvEM::*get_log_likelihood_function_type )(  ) const;
            
            CvEM_exposer.def( 
                "get_log_likelihood"
                , get_log_likelihood_function_type( &::CvEM::get_log_likelihood ) );
        
        }
        { //::CvEM::get_means
        
            typedef ::CvMat const * ( ::CvEM::*get_means_function_type )(  ) const;
            
            CvEM_exposer.def( 
                "get_means"
                , get_means_function_type( &::CvEM::get_means )
                , bp::return_internal_reference< >() );
        
        }
        { //::CvEM::get_nclusters
        
            typedef int ( ::CvEM::*get_nclusters_function_type )(  ) const;
            
            CvEM_exposer.def( 
                "get_nclusters"
                , get_nclusters_function_type( &::CvEM::get_nclusters ) );
        
        }
        { //::CvEM::get_probs
        
            typedef ::CvMat const * ( ::CvEM::*get_probs_function_type )(  ) const;
            
            CvEM_exposer.def( 
                "get_probs"
                , get_probs_function_type( &::CvEM::get_probs )
                , bp::return_internal_reference< >() );
        
        }
        { //::CvEM::get_weights
        
            typedef ::CvMat const * ( ::CvEM::*get_weights_function_type )(  ) const;
            
            CvEM_exposer.def( 
                "get_weights"
                , get_weights_function_type( &::CvEM::get_weights )
                , bp::return_internal_reference< >() );
        
        }
        { //::CvEM::predict
        
            typedef boost::python::object ( *default_predict_function_type )( CvEM const &,::cv::Mat &,::cv::Mat & );
            
            CvEM_exposer.def( 
                "predict"
                , default_predict_function_type( &CvEM_wrapper::default_predict_e2a6ccb3e80d0945b65e2adfc4d80129 )
                , ( bp::arg("inst"), bp::arg("sample"), bp::arg("probs") )
                , "\nArgument 'sample':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument 'probs':"\
    "\n    C++ type: ::CvMat *"\
    "\n    Python type: Mat" );
        
        }
        { //::CvEM::predict
        
            typedef float ( ::CvEM::*predict_function_type )( ::cv::Mat const &,::cv::Mat * ) const;
            typedef float ( CvEM_wrapper::*default_predict_function_type )( ::cv::Mat const &,::cv::Mat * ) const;
            
            CvEM_exposer.def( 
                "predict"
                , predict_function_type(&::CvEM::predict)
                , default_predict_function_type(&CvEM_wrapper::default_predict)
                , ( bp::arg("sample"), bp::arg("probs") ) );
        
        }
        { //::CvEM::train
        
            typedef boost::python::object ( *default_train_function_type )( CvEM &,::cv::Mat &,::cv::Mat,CvEMParams,::cv::Mat );
            
            CvEM_exposer.def( 
                "train"
                , default_train_function_type( &CvEM_wrapper::default_train_ad96ec9280c0f7571752ed3a0ca86d28 )
                , ( bp::arg("inst"), bp::arg("samples"), bp::arg("sample_idx")=cv::Mat(), bp::arg("params")=::CvEMParams( ), bp::arg("labels")=cv::Mat() )
                , "\nArgument 'samples':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument 'sample_idx':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument 'labels':"\
    "\n    C++ type: ::CvMat *"\
    "\n    Python type: Mat" );
        
        }
        { //::CvEM::train
        
            typedef bool ( ::CvEM::*train_function_type )( ::cv::Mat const &,::cv::Mat const &,::CvEMParams,::cv::Mat * ) ;
            typedef bool ( CvEM_wrapper::*default_train_function_type )( ::cv::Mat const &,::cv::Mat const &,::CvEMParams,::cv::Mat * ) ;
            
            CvEM_exposer.def( 
                "train"
                , train_function_type(&::CvEM::train)
                , default_train_function_type(&CvEM_wrapper::default_train)
                , ( bp::arg("samples"), bp::arg("sample_idx")=cv::Mat(), bp::arg("params")=::CvEMParams( ), bp::arg("labels")=bp::object() ) );
        
        }
        { //::CvStatModel::load
        
            typedef void ( ::CvStatModel::*load_function_type )( char const *,char const * ) ;
            typedef void ( CvEM_wrapper::*default_load_function_type )( char const *,char const * ) ;
            
            CvEM_exposer.def( 
                "load"
                , load_function_type(&::CvStatModel::load)
                , default_load_function_type(&CvEM_wrapper::default_load)
                , ( bp::arg("filename"), bp::arg("name")=bp::object() ) );
        
        }
        { //::CvStatModel::read
        
            typedef void ( *default_read_function_type )( CvStatModel &,::cv::FileStorage &,::cv::FileNode & );
            
            CvEM_exposer.def( 
                "read"
                , default_read_function_type( &CvEM_wrapper::default_read )
                , ( bp::arg("inst"), bp::arg("storage"), bp::arg("node") )
                , "\nArgument 'storage':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage"\
    "\nArgument 'node':"\
    "\n    C++ type: ::CvFileNode *"\
    "\n    Python type: FileNode" );
        
        }
        { //::CvStatModel::save
        
            typedef void ( ::CvStatModel::*save_function_type )( char const *,char const * ) const;
            typedef void ( CvEM_wrapper::*default_save_function_type )( char const *,char const * ) const;
            
            CvEM_exposer.def( 
                "save"
                , save_function_type(&::CvStatModel::save)
                , default_save_function_type(&CvEM_wrapper::default_save)
                , ( bp::arg("filename"), bp::arg("name")=bp::object() ) );
        
        }
        { //::CvStatModel::write
        
            typedef void ( *default_write_function_type )( CvStatModel const &,::cv::FileStorage &,char const * );
            
            CvEM_exposer.def( 
                "write"
                , default_write_function_type( &CvEM_wrapper::default_write )
                , ( bp::arg("inst"), bp::arg("storage"), bp::arg("name") )
                , "\nArgument 'storage':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage" );
        
        }
    }

}
