# pylint: disable-msg=E1101,W0613,W0603

from pyopendata import OECDStore, OECDResource

import numpy as np
import pandas as pd
from pandas.compat import range
import pandas.util.testing as tm


class TestOECDTestSite(tm.TestCase):

    def setUp(self):
        self.store = OECDStore()

    def test_isvalid(self):
        self.assertTrue(self.store.is_valid())

    def test_get_un_den(self):
        data = self.store.get('UN_DEN')
        self.assertTrue(isinstance(data, OECDResource))

        df = data.read()

        au = [50.17292785, 49.47181009, 49.52106174, 49.16341327, 48.19296375,
              47.8863461, 45.83517292, 45.02021403, 44.78983834, 44.37794217,
              44.15358142, 45.38865546, 46.33092037, 47.2343406, 48.80023876,
              50.0639872, 50.23390644, 49.8214994, 49.67636585, 49.55227375,
              48.48657368, 47.41179739, 47.52526561, 47.93048854, 47.26327162,
              45.4617105, 43.90202112, 42.32759607, 40.35838899, 39.35157364,
              39.55023059, 39.93196617, 39.21915611, 37.24341973, 34.42587311,
              32.51238056, 31.16811321, 29.78802692, 28.14678656, 25.41919614,
              25.71802695, 24.53149132, 23.21981032, 22.99175908, 22.29392791,
              22.29118237, 20.22236361, 18.51151852, 18.5674024, 19.31219498,
              18.44405734, 18.51407731, 18.19718895, 17.04071205]
        jp = [32.89493671, 33.80225989, 34.5969919, 35.01871257, 35.46869345,
              35.28164117, 34.749499, 34.40573103, 34.50762389, 35.16411379,
              35.10284332, 34.57209848, 34.31168831, 33.46611342, 34.26450371,
              34.53099287, 33.69881466, 32.99814274, 32.59541985, 31.75696594,
              31.14832536, 30.8917513, 30.56612982, 29.75285171, 29.22391559,
              28.79202411, 28.18680064, 27.71454381, 26.94358748, 26.13165206,
              26.13236815, 25.24310276, 24.98554405, 24.83467897, 24.7263178,
              24.38077142, 23.3953401, 22.78797997, 22.52794337, 22.18157944,
              21.54406273, 20.88284597, 20.26073907, 19.73945642, 19.06442577,
              18.79844243, 18.3497807, 18.25095057, 18.2204924, 18.45787546,
              18.38733297, 18.99504195, 17.97238372, 17.78318026]
        us = [30.89748411, 29.51891217, 29.34276869, 28.51337535, 28.30646144,
              28.16661991, 28.19557735, 27.76578899, 27.9004622, 27.30836054,
              27.43402867, 26.94941363, 26.25996487, 25.83134349, 25.74427582,
              25.28771204, 24.38412814, 23.59186681, 23.94328194, 22.3651229,
              22.06009466, 21.01328205, 20.47463895, 19.45290876, 18.22953818,
              17.44855678, 17.00126975, 16.5162476, 16.24744487, 15.86401127,
              15.45147174, 15.46986912, 15.1499578, 15.13654544, 14.91544059,
              14.31762091, 14.02052225, 13.55213736, 13.39571457, 13.36670812,
              12.90865079, 12.86997731, 12.76906383, 12.39142968, 12.02130767,
              11.96023574, 11.48458378, 11.56435375, 11.91022276, 11.79401904,
              11.38345975, 11.32948829, 11.07884758, 10.80789137]

        index = pd.DatetimeIndex(map(str, range(1960, 2014)))
        for label, values in [('Australia', au), ('Japan', jp), ('United States', us)]:
            expected = pd.Series(values, index=index)
            tm.assert_series_equal(df[label], expected)

        raw_data = data.read(raw=True)
        self.assertTrue(len(raw_data) > 0)

    def test_get_tourism(self):
        data = self.store.get('TOURISM_INBOUND')
        df = data.read()

        jp = np.array([6138, 6728, 7334, 8347, 8351, 6790, 8611, 6219, 8368, ], dtype=float)
        us = np.array([np.nan, np.nan, 183178, 175142, 175632, 160359, 162269, 164672, 171630], dtype=float)

        index = pd.DatetimeIndex(['2004', '2005', '2006', '2007', '2008',
                                  '2009', '2010', '2011', '2012'])
        for label, values in [('Japan', jp), ('United States', us)]:
            expected = pd.Series(values, index=index)
            tm.assert_series_equal(df[label]['Total international arrivals'], expected)


if __name__ == '__main__':
    import nose
    nose.runmodule(argv=[__file__, '-vvs', '-x', '--pdb', '--pdb-failure'], exit=False)
