import os
import argparse
from string import Template

def main():
  '''Generates boilerplate for opensource project.'''
  parser = argparse.ArgumentParser(description='Generates project skeleton for open source python project.')
  parser.add_argument('projectName', metavar='projectName', help='the name of the project')

  args = parser.parse_args()
  projectName = args.projectName

  DIRS = [
    Template('$project_name/docs'),
    Template('$project_name/src'),
    Template('$project_name/tests')
  ]

  FILES = [
    Template('$project_name/docs/.gitinclude'),
    Template('$project_name/src/.gitinclude'),
    Template('$project_name/tests/.gitinclude'),
    Template('$project_name/.gitignore'),
    Template('$project_name/.travis.yml'),
    Template('$project_name/LICENSE'),
    Template('$project_name/MANIFEST.in'),
    Template('$project_name/README.md'),
    Template('$project_name/setup.py'),
    Template('$project_name/CONTRIBUTING.md'),
    Template('$project_name/CHANGELOG.md'),
    Template('$project_name/AUTHORS.md'),
    Template('$project_name/Vagrantfile')
  ]

  for d in DIRS:
    os.makedirs(d.substitute(project_name=projectName))

  for f in FILES:
    open(f.substitute(project_name=projectName), 'w')